package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TctiacreDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tctiacre;

/**
 * TctiacreServiceImpl  
 *  
 */

@Service(value = "tctiacreService")
public class TctiacreServiceImpl implements TctiacreService {

	@Autowired
	private TctiacreDao tctiacreDao;

	/**
	 * Inserts a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tctiacre add(Tctiacre tctiacre) {
		return this.tctiacreDao.add(tctiacre);
	}

	/**
	 * Updates a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tctiacre update(Tctiacre tctiacre) {
		return this.tctiacreDao.update(tctiacre);
	 }

	/**
	 * Finds a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
	public Tctiacre find(Tctiacre tctiacre) {
		return (Tctiacre) this.tctiacreDao.find(tctiacre);
	}

	/**
	 * Finds a List of rows in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tctiacre> findAll(Tctiacre tctiacre, Pagination pagination) {
		return (List<Tctiacre>) this.tctiacreDao.findAll(tctiacre, pagination);
	}
    
	/**
	 * Counts rows in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Long
	 */
	public Long findAllCount(Tctiacre tctiacre) {        
		return  this.tctiacreDao.findAllCount(tctiacre);
	}

	/**
	 * Finds rows in the Tctiacre table using like.
	 *
	 * @param tctiacre Tctiacre
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tctiacre> findAllLike(Tctiacre tctiacre, Pagination pagination, Boolean startsWith) {
		return (List<Tctiacre>) this.tctiacreDao.findAllLike(tctiacre, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tctiacre table using like.
	 *
	 * @param tctiacre Tctiacre
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tctiacre tctiacre, Boolean startsWith) {
		return this.tctiacreDao.findAllLikeCount(tctiacre, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tctiacre tctiacre) {
		this.tctiacreDao.remove(tctiacre);
	}
	
	/**
	 * Deletes multiple rows in the Tctiacre table.
	 *
	 * @param tctiacreList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tctiacre> tctiacreList) {
		for (Tctiacre  tctiacreAux:tctiacreList) {
			this.tctiacreDao.remove(tctiacreAux);
		}
	}
	
}

