package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tctiacre;

/**
 * TctiacreService  
 *  
 */

public interface TctiacreService {

	/**
	 * Inserts a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
    Tctiacre add(Tctiacre tctiacre);

	/**
	 * Updates a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
	Tctiacre update(Tctiacre tctiacre);

	/**
	 * Finds a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Tctiacre
	 */
	Tctiacre find(Tctiacre tctiacre);

	/**
	 * Finds a List of rows in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @param pagination Pagination
	 * @return List
	 */
	List<Tctiacre> findAll(Tctiacre tctiacre, Pagination pagination);

	/**
	 * Counts rows in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return Long
	 */
	Long findAllCount(Tctiacre tctiacre);
	
	/**
	 * Finds rows in the Tctiacre table using like.
	 *
	 * @param tctiacre Tctiacre
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Tctiacre> findAllLike(Tctiacre tctiacre, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Tctiacre table using like.
	 *
	 * @param tctiacre Tctiacre
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Tctiacre tctiacre, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Tctiacre table.
	 *
	 * @param tctiacre Tctiacre
	 * @return 
	 */
	void remove(Tctiacre tctiacre);
	
	/**
	 * Deletes multiple rows in the Tctiacre table.
	 *
	 * @param tctiacreList List
	 * @return 
	 */	
	void removeMultiple(List<Tctiacre> tctiacreList);
    
}


