package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TcmotinaDao;
import com.ejie.y41b.model.Tcmotina;

/**
 * TcmotinaServiceImpl  
 * 
 *  
 */

@Service(value = "tcmotinaService")
public class TcmotinaServiceImpl implements TcmotinaService {

	@Autowired
	private TcmotinaDao tcmotinaDao;

	/**
	 * Inserts a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Tcmotina
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tcmotina add(Tcmotina tcmotina) {
		return this.tcmotinaDao.add(tcmotina);
	}

	/**
	 * Updates a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Tcmotina
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tcmotina update(Tcmotina tcmotina) {
		return this.tcmotinaDao.update(tcmotina);
	}

	/**
	 * Finds a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Tcmotina
	 */
	public Tcmotina find(Tcmotina tcmotina) {
		return (Tcmotina) this.tcmotinaDao.find(tcmotina);
	}

	/**
	 * Finds a List of rows in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tcmotina> findAll(Tcmotina tcmotina, Pagination pagination) {
		return (List<Tcmotina>) this.tcmotinaDao.findAll(tcmotina, pagination);
	}

	/**
	 * Counts rows in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Long
	 */
	public Long findAllCount(Tcmotina tcmotina) {
		return this.tcmotinaDao.findAllCount(tcmotina);
	}

	/**
	 * Finds rows in the Tcmotina table using like.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tcmotina> findAllLike(Tcmotina tcmotina, Pagination pagination,
			Boolean startsWith) {
		return (List<Tcmotina>) this.tcmotinaDao.findAllLike(tcmotina,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Tcmotina table using like.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tcmotina tcmotina, Boolean startsWith) {
		return this.tcmotinaDao.findAllLikeCount(tcmotina, startsWith);
	}

	/**
	 * Deletes a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tcmotina tcmotina) {
		this.tcmotinaDao.remove(tcmotina);
	}

	/**
	 * Deletes multiple rows in the Tcmotina table.
	 * 
	 * @param tcmotinaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tcmotina> tcmotinaList) {
		for (Tcmotina tcmotinaAux : tcmotinaList) {
			this.tcmotinaDao.remove(tcmotinaAux);
		}
	}

}
