package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.dao.TclugaudDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TclugaudServiceImpl  
 * 
 *  
 */

@Service(value = "tclugaudService")
public class TclugaudServiceImpl implements TclugaudService {

	@Autowired
	private TclugaudDao tclugaudDao;
	@Autowired
	private T17CalleDao t17CalleDao;
	@Autowired()
	private T17PortalService t17PortalService;
	@Autowired
	private T17ProvinciaDao t17ProvinciaDao;
	@Autowired
	private T17LocalidadDao t17LocalidadDao;

	/**
	 * Inserts a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tclugaud add(Tclugaud tclugaud) {
		return this.tclugaudDao.add(tclugaud);
	}

	/**
	 * Updates a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tclugaud update(Tclugaud tclugaud) {
		return this.tclugaudDao.update(tclugaud);
	}

	/**
	 * Finds a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	public Tclugaud find(Tclugaud tclugaud) {

		tclugaud = this.tclugaudDao.find(tclugaud);
		tclugaud.setT4calle(this.dameCalle(tclugaud));

		return (tclugaud);
	}

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tclugaud> findAll(Tclugaud tclugaud, Pagination pagination) {
		return (List<Tclugaud>) this.tclugaudDao.findAll(tclugaud, pagination);
	}

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	public Long findAllCount(Tclugaud tclugaud) {
		return this.tclugaudDao.findAllCount(tclugaud);
	}

	/**
	 * Finds rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tclugaud> findAllLike(Tclugaud tclugaud, Pagination pagination,
			Boolean startsWith) {

		List<Tclugaud> listaIntervinientes = this.tclugaudDao.findAllBusqueda(
				tclugaud, pagination);
		for (Tclugaud tclugaud2 : listaIntervinientes) {
			tclugaud2.setDireccionCompleta(this
					.dameDireccionCompleta(tclugaud2));

			if (pagination != null) {
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4nombre")) {
					pagination.setSort("T4NOMBRE");
				}
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4nombreeu")) {
					pagination.setSort("T4NOMBREEU");
				}
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4fecbaja")) {
					pagination.setSort("T4FECBAJA");
				}

			}
			if (tclugaud2.getT4fecbaja() != null) {
				tclugaud2.setIndIncluirBaja(true);

			}
		}

		return listaIntervinientes;
	}

	/**
	 * Counts rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tclugaud tclugaud, Boolean startsWith) {
		return this.tclugaudDao.findAllLikeCount(tclugaud, startsWith);
	}

	/**
	 * Deletes a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tclugaud tclugaud) {
		this.tclugaudDao.remove(tclugaud);
	}

	/**
	 * Deletes multiple rows in the Tclugaud table.
	 * 
	 * @param tclugaudList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tclugaud> tclugaudList) {
		for (Tclugaud tclugaudAux : tclugaudList) {
			this.tclugaudDao.remove(tclugaudAux);
		}
	}

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tclugaud> findAllBusqueda(Tclugaud tclugaud,
			Pagination pagination) {
		List<Tclugaud> listaLugaresAudiencia = this.tclugaudDao.findAllBusqueda(
				tclugaud, pagination);
		for (Tclugaud tclugaud2 : listaLugaresAudiencia) {
			tclugaud2.setDireccionCompleta(this
					.dameDireccionCompleta(tclugaud2));

			if (pagination != null) {
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4nombre")) {
					pagination.setSort("T4NOMBRE");
				}
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4nombreeu")) {
					pagination.setSort("T4NOMBREEU");
				}
				if (pagination.getSort() != null
						&& pagination.getSort().equals("t4fecbaja")) {
					pagination.setSort("T4FECBAJA");
				}

			}
			if (tclugaud2.getT4fecbaja() != null) {
				tclugaud2.setIndIncluirBaja(true);

			}
		}
		return listaLugaresAudiencia;
	}

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	public Long findAllBusquedaCount(Tclugaud tclugaud) {
		return this.tclugaudDao.findAllBusquedaCount(tclugaud);
	}

	/**
	 * 
	 * @param datosCalle
	 *            Tclugaud
	 * @return String
	 */
	private String dameCalle(Tclugaud datosCalle) {
		String calle = "";
		try {
			if (!Y41bUtils.esNullOCadenaVacia(datosCalle.getT4noraCalleId())) {
				calle = this.t17CalleDao.findCalleConTipoVia(
						new T17Calle(Long.parseLong(datosCalle
								.getT4noraCalleId()), null)).getDsO();
			}
		} catch (Exception e) {

		}
		return calle;
	}

	public String dameLineaDireccion(Tclugaud tclugaud) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(tclugaud.getT4noraCalleId())) {

			String calle = "";
			try {
				calle = this.t17CalleDao.findCalleConTipoVia(
						new T17Calle(
								Long.parseLong(tclugaud.getT4noraCalleId()),
								null)).getDsO();
			} catch (Exception e) {

			}
			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(tclugaud.getT4nodir())) {
					direccion.append(tclugaud.getT4nodir());
				}
			} else {

				if (tclugaud.getT4noraPortalId() != null) {
					t17portal
							.setId(Long.parseLong(tclugaud.getT4noraPortalId()));
					t17portal.setCalleId(Long.parseLong(tclugaud
							.getT4noraCalleId()));
					List<T17Portal> list = this.t17PortalService.findAll(
							t17portal, null);
					if (list != null && list.size() > 0) {
						t17portal = list.get(0);
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ").append(
									Y41bUtils.componerDireccion(calle,
											t17portal.getBloque(),
											t17portal.getPortal(), 0, null,
											tclugaud.getT4nombrePiso(),
											tclugaud.getT4nodir()));
						} else if (t17portal != null
								&& t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(tclugaud
									.getT4nodir())) {
								direccion.append(" ").append(
										tclugaud.getT4nodir());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(tclugaud
									.getT4nodir())) {
								direccion.append(" ").append(
										tclugaud.getT4nodir());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils
								.esNullOCadenaVacia(tclugaud.getT4nodir())) {
							direccion.append(" ").append(tclugaud.getT4nodir());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(tclugaud.getT4nodir())) {
						direccion.append(" ").append(tclugaud.getT4nodir());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(tclugaud.getT4nodir())) {
				direccion.append(" ").append(tclugaud.getT4nodir());
			}
		}
		return (direccion.toString());

	}

	public String dameLocalidad(Tclugaud tclugaud) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";

		/* localidad */
		if ((tclugaud.getT4noraLocalidadId() != null)
				&& (tclugaud.getT4municipio() != null)
				&& (tclugaud.getT4noraProvinciaId() != null)) {
			T17Localidad localidadVO = this.t17LocalidadDao
					.find(new T17Localidad(tclugaud.getT4noraLocalidadId(),
							null, tclugaud.getT4municipio(), tclugaud
									.getT4noraProvinciaId(), null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO
						.getDsO();
			}

			direccion.append(" ");
			direccion.append(localidad);
		}
		return (direccion.toString());
	}

	public String dameProvincia(Tclugaud tclugaud) {
		StringBuffer direccion = new StringBuffer("");

		String provincia = "";
		/* localidad */
		if (tclugaud.getT4noraProvinciaId() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(tclugaud.getT4noraProvinciaId(),
							null, null)));

			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO
						.getDsO();
			}

			direccion.append(" ");
			direccion.append(provincia);

		}
		return (direccion.toString());
	}

	private String dameDireccionCompleta(Tclugaud tclugaud) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(tclugaud));

		if ((tclugaud.getT4noraLocalidadId() != null)
				&& (tclugaud.getT4noraMunicipioId() != null)
				&& (tclugaud.getT4noraProvinciaId() != null)) {
			direccion.append(dameLocalidad(tclugaud));
		}

		if (tclugaud.getT4noraProvinciaId() != null) {
			direccion.append(this.dameProvincia(tclugaud));
		}

		return (direccion.toString());
	}
}
