package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tclugaud;

/**
 * TclugaudService  
 * 
 *  
 */

public interface TclugaudService {

	/**
	 * Inserts a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	Tclugaud add(Tclugaud tclugaud);

	/**
	 * Updates a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	Tclugaud update(Tclugaud tclugaud);

	/**
	 * Finds a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Tclugaud
	 */
	Tclugaud find(Tclugaud tclugaud);

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tclugaud> findAll(Tclugaud tclugaud, Pagination pagination);

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	Long findAllCount(Tclugaud tclugaud);

	/**
	 * Finds rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tclugaud> findAllLike(Tclugaud tclugaud, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tclugaud tclugaud, Boolean startsWith);

	/**
	 * Deletes a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return
	 */
	void remove(Tclugaud tclugaud);

	/**
	 * Deletes multiple rows in the Tclugaud table.
	 * 
	 * @param tclugaudList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Tclugaud> tclugaudList);

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tclugaud> findAllBusqueda(Tclugaud tclugaud, Pagination pagination);

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param Tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	Long findAllBusquedaCount(Tclugaud tclugaud);

	// /**
	// * Borra los registros temporales
	// *
	// * @param tclugaud
	// * Tclugaud
	// */
	// void borrarTemporales(Tclugaud tclugaud);

}
