package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.T17TipoViaDao;
import com.ejie.y41b.model.T17TipoVia;

/**
 * T17TipoViaServiceImpl  
 * 
 *  
 */

@Service(value = "t17TipoViaService")
public class T17TipoViaServiceImpl implements T17TipoViaService {

	@Autowired
	private T17TipoViaDao t17TipoViaDao;

	/**
	 * Inserts a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17TipoVia add(T17TipoVia t17TipoVia) {
		return this.t17TipoViaDao.add(t17TipoVia);
	}

	/**
	 * Updates a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17TipoVia update(T17TipoVia t17TipoVia) {
		return this.t17TipoViaDao.update(t17TipoVia);
	}

	/**
	 * Finds a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	public T17TipoVia find(T17TipoVia t17TipoVia) {
		return (T17TipoVia) this.t17TipoViaDao.find(t17TipoVia);
	}

	/**
	 * Finds a List of rows in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17TipoVia> findAll(T17TipoVia t17TipoVia, Pagination pagination) {
		return (List<T17TipoVia>) this.t17TipoViaDao.findAll(t17TipoVia,
				pagination);
	}

	/**
	 * Counts rows in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return Long
	 */
	public Long findAllCount(T17TipoVia t17TipoVia) {
		return this.t17TipoViaDao.findAllCount(t17TipoVia);
	}

	/**
	 * Finds rows in the T17TipoVia table using like.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<T17TipoVia> findAllLike(T17TipoVia t17TipoVia,
			Pagination pagination, Boolean startsWith) {
		return (List<T17TipoVia>) this.t17TipoViaDao.findAllLike(t17TipoVia,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the T17TipoVia table using like.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(T17TipoVia t17TipoVia, Boolean startsWith) {
		return this.t17TipoViaDao.findAllLikeCount(t17TipoVia, startsWith);
	}

	/**
	 * Deletes a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17TipoVia t17TipoVia) {
		this.t17TipoViaDao.remove(t17TipoVia);
	}

	/**
	 * Deletes multiple rows in the T17TipoVia table.
	 * 
	 * @param t17TipoViaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<T17TipoVia> t17TipoViaList) {
		for (T17TipoVia t17TipoViaAux : t17TipoViaList) {
			this.t17TipoViaDao.remove(t17TipoViaAux);
		}
	}

}
