package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.T17Portal;

/**
 * T17PortalService  
 * 
 *  
 */
public interface T17PortalService {

	/**
	 * Inserts a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal add(T17Portal t17Portal);

	/**
	 * Updates a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal update(T17Portal t17Portal);

	/**
	 * Finds a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal find(T17Portal t17Portal);

	/**
	 * Finds a List of rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Portal> findAll(T17Portal t17Portal, Pagination pagination);

	/**
	 * Counts rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return Long
	 */
	Long findAllCount(T17Portal t17Portal);

	/**
	 * Finds rows in the T17Portal table using like.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Portal> findAllLike(T17Portal t17Portal, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 */
	void remove(T17Portal t17Portal);

	/**
	 * Deletes multiple rows in the T17Portal table.
	 * 
	 * @param t17PortalList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Portal> t17PortalList);

	/**
	 * Finds a List of distinct rows by CP in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Portal> findAllLike_CodigoPostal(T17Portal t17Portal,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of distinct CP rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal findCodigoPostal(T17Portal t17Portal);

	/**
	 * Finds a single row in the T17Portal table.
	 * 
	 * @param t17portal
	 *            Pagination
	 * @return T17Portal
	 */
	public T17Portal find(Long idT17portal);
}
