package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.T17Autonomia;

/**
 * T17AutonomiaService  
 * 
 *  
 */
public interface T17AutonomiaService {

	/**
	 * Inserts a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia add(T17Autonomia t17Autonomia);

	/**
	 * Updates a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia update(T17Autonomia t17Autonomia);

	/**
	 * Finds a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia find(T17Autonomia t17Autonomia);

	/**
	 * Finds a List of rows in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Autonomia> findAll(T17Autonomia t17Autonomia, Pagination pagination);

	/**
	 * Counts rows in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return Long
	 */
	Long findAllCount(T17Autonomia t17Autonomia);

	/**
	 * Finds rows in the T17Autonomia table using like.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Autonomia> findAllLike(T17Autonomia t17Autonomia,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 */
	void remove(T17Autonomia t17Autonomia);

	/**
	 * Deletes multiple rows in the T17Autonomia table.
	 * 
	 * @param t17AutonomiaList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Autonomia> t17AutonomiaList);

}
