// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.adapter.services.NSHFServiceImpl;
import com.ejie.y41b.adapter.services.OutputSirServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.dao.AdjunInfraccHechoDenunDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.BandejaSolicitudesDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ComunicacionDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.dao.DecisionHechoDao;
import com.ejie.y41b.dao.DestComunicacionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.TipoDocumentoDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.dao.TrasladoDao;
import com.ejie.y41b.dao.UnidadesDir3Dao;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Comunicacion;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DecisionHecho;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.DestComunicacion;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoComunicacion;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteAlegacion;
import com.ejie.y41b.model.TramiteAnulacionPropuestaSancion;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteConciliacionEntrePartes;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteEnviarSalidaSIR;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteInformeAsesoria;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteMediacionPresencial;
import com.ejie.y41b.model.TramiteMediacionTelefonica;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionInspeccion;
import com.ejie.y41b.model.TramiteRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteRecepcionRecurso;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoSubsanacion;
import com.ejie.y41b.model.TramiteRecepcionTraslado;
import com.ejie.y41b.model.TramiteRegistroDecision;
import com.ejie.y41b.model.TramiteRegistroSolicitud;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoAlegacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRequerimientoSubsanacion;
import com.ejie.y41b.model.TramiteRespuestaAmpliacionPlazo;
import com.ejie.y41b.model.TramiteRespuestaColaboracion;
import com.ejie.y41b.model.TramiteRespuestaSegundaMediacion;
import com.ejie.y41b.model.TramiteSegundaMediacion;
import com.ejie.y41b.model.TramiteSolicitudColaboracion;
import com.ejie.y41b.model.TramiteSolicitudInspeccion;
import com.ejie.y41b.model.TramiteTrasladoRedCiac;
import com.ejie.y41b.model.Traslado;
import com.ejie.y41b.model.TrasladoBusqueda;
import com.ejie.y41b.model.UnidadesDir3;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Firma;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.LocalizadorDocumento;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.dokusi.TransformarDocumento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.nshf.Body;
import com.ejie.y41b.nshf.EjgvDocument;
import com.ejie.y41b.nshf.EjgvDocumentType;
import com.ejie.y41b.nshf.Header;
import com.ejie.y41b.outputsir.ArrayOfSignatureDocuments;
import com.ejie.y41b.outputsir.Signatures;
import com.ejie.y41b.outputsir.WSParamSignatureDocument;
import com.ejie.y41b.utils.Y41bStringUtils;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

import noNamespace.SignatureListDocument;

/**
 * SoltramexpServiceImpl
 * 
 *  
 */
@Service(value = "soltramexpService")
public class SoltramexpServiceImpl implements SoltramexpService {

	private static final Logger logger = LoggerFactory.getLogger(SoltramexpServiceImpl.class);

	@Autowired
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private HistoricofasesService historicofasesService;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired
	private SanpropbandejaService sanpropbandejaService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private DecisionHechoDao decisionHechoDao;

	@Autowired
	private TrasladoDao trasladoDao;

	@Autowired
	private OrganismoDao organismoDao;

	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired
	private CensoMonitorDao censoMonitorDao;

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private TipoDocumentoDao tipoDocumentoDao;

	@Autowired
	private BandejaSolicitudesDao bandejaSolicitudesDao;

	@Autowired
	private EstablecimientoDao establecimientoDao;

	@Autowired
	private EstablecimSectorDao establecimSectorDao;

	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired
	private ConsumidorDao consumidorDao;

	@Autowired
	private TramiteDao tramiteDao;

	@Autowired
	private RemesaDao remesaDao;

	@Autowired
	private InfraccHechoDenDao infraccHechoDenDao;

	@Autowired
	private AdjunInfraccHechoDenunDao adjunInfraccHechoDenunDao;

	@Autowired
	private ComunicacionDao comunicacionDao;

	@Autowired
	private DestComunicacionDao destComunicacionDao;

	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired
	private EstablecimientoService establecimientoService;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private DecisionDao decisionDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;

	@Autowired
	private SantramexpDao santramexpDao;

	@Autowired
	private ExpedienDao expedienDao;

	@Autowired
	private SantipdocDao santipdocDao;

	@Autowired
	private SolarbDao solarbDao;

	@Autowired
	private ArbtipdocDao arbtipdocDao;

	@Autowired
	private SanexprelDao sanexprelDao;

	@Autowired
	private ArbtramexpDao arbtramexpDao;

	@Autowired
	private ArbpropbandejaService arbpropbandejaService;

	@Autowired
	InspeccionesPropBandejaService inspeccionesPropBandejaService;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired
	private SanexprelService sanexprelService;

	@Autowired
	private UnidadesDir3Dao unidadesDir3Dao;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	@Autowired
	private SantramexpService santramexpService;

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	// GEN-FIRST:INICIO
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun) {
		this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		this.documentoHechoDao.addAdjuntarDocs(tramiteComun);
	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarInfraccHechoDenunTableTemporal(TramiteComun tramiteComun) {
		this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);
		this.infraccHechoDenDao.addAdjuntarInfracciones(tramiteComun);
	}

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun) {
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			DocumentoHecho documentoHechoAux = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux.setQ5pcodigo(documentoExpediente.getPcodigo());
				try {
					this.documentoHechoDao.addAdjuntarDoc(documentoHechoAux, tramiteComun);
				} catch (DuplicateKeyException duplicateKeyException) {
					throw new Y41bUDAException("error.adjuntardocstramite.duplicateException", true, new Exception());
				}
			}
		}
	}

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocumentosTableTemporalActa(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun) {
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			DocumentoHecho documentoHechoAux = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux.setQ5pcodigo(documentoExpediente.getPcodigo());
				try {
					this.documentoHechoDao.addAdjuntarDoc(documentoHechoAux, tramiteComun);
				} catch (DuplicateKeyException duplicateKeyException) {
					throw new Y41bUDAException("error.adjuntardocstramite.duplicateException", true, new Exception());
				}
			}
		}

		Adjuntardocs adjuntardocsAux = new Adjuntardocs();
		adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ACTA_INSP);
		adjuntardocsAux.setTipoDocumento(tipoDocumento);

		Long total = this.adjuntardocsDao.findAllCount(adjuntardocsAux);

		if (total > 1) {
			throw new Y41bUDAException("error.inspecciones.existeDocumentoActa", true, new Exception());
		}
	}

	/**
	 * Elimina el tramite recibido por parametro
	 * 
	 * @param ehcodigo
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarTramite(String ehcodigo) {
		logger.info("eliminarTramite ini:" + ehcodigo);
		// 1. Recuperamos el tramite hecho
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(ehcodigo);
		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		// No se permite eliminar el tramite de registro de solicitud, est o no
		// tramitado.
		if (Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD.equals(tramitehecho.getEhcotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteRegSolException", true, new Exception());
		}

		if (Y41bConstantes.TRAMITE_GENERICO.equals(tramitehecho.getEhcotee())
				&& Y41bConstantes.VALOR_SI.equals(tramitehecho.getEhautomatico())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true, new Exception());
		}

		// No se permite eliminar el tramite de aportacin de documentacin
		// telematico
		if (Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION.equals(tramitehecho.getEhcotee())) {
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(ehcodigo);
			List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
				DocumentoHecho documentoHecho = null;
				boolean aportadoReclamanteReclamado = false;
				for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
					documentoHecho = listDocumentoHechoAporta.get(j);
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))
							&& documentoHecho.getQ5iddocumentum() != null
							&& !documentoHecho.getQ5iddocumentum().equals("")
							&& documentoHecho.getQ5numregistroentrada() != null
							&& documentoHecho.getQ5numregistroentrada().contains("RTE")) {
						aportadoReclamanteReclamado = true;
						break;
					}
				}
				if (aportadoReclamanteReclamado) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAportacionTelematicaException", true,
							new Exception());
				}
			}
		}

		if (tramitehecho.getEhfechafin() != null
				&& Y41bConstantes.TRAMITE_COMUNICACION.equals(tramitehecho.getEhcotee())) {
			// No se podr eliminar un tramite de comunicacion si esta tramitado
			// telematicamente.
			if (Y41bConstantes.TIPO_COMUNICACION_TELEMATICA.equals(tramitehecho.getEhtipocomunicacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionTelematicaException", true,
						new Exception());
				// No se podr eliminar una comunicacion tramitada por mail
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO
					.equals(tramitehecho.getEhtipocomunicacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionMailException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO.equals(tramitehecho.getEhtipocomunicacion())
					&& Y41bConstantes.SI.equals(tramitehecho.getEhenvrem()) && tramitehecho.getEhcodrem() != null
					&& !tramitehecho.getEhcodrem().equals("")) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		if (tramitehecho.getEhfechafin() != null
				&& Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramitehecho.getEhcotee())) {
			// No se podr eliminar un tramite de notificacin si esta tramitado
			// telematicamente.
			if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramitehecho.getEhtiponotificacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionTelematicaException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(tramitehecho.getEhtiponotificacion())
					&& Y41bConstantes.SI.equals(tramitehecho.getEhenvrem()) && tramitehecho.getEhcodrem() != null
					&& !tramitehecho.getEhcodrem().equals("")) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		if (Y41bConstantes.TRAMITE_ACUSE_RECIBO.equals(tramitehecho.getEhcotee())) {
			// No se permite eliminar el tramite de acuse de recibo si est
			// tramitado.
			if (tramitehecho.getEhfechafin() != null) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboTramitadoException", true,
						new Exception());
			}

			// No se podr eliminar un tramite de acuse de recibo realacionado
			// con
			// una notificacin telematica
			if (tramitehecho.getTramiteHecho() != null
					&& Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramitehecho.getTramiteHecho().getEhcotee())
					&& Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA
							.equals(tramitehecho.getTramiteHecho().getEhtiponotificacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboNotificacionTelematicaException",
						true, new Exception());
			}

			// No se podr eliminar un tramite de acuse de recibo realacionado
			// con
			// una notificacin ordinaria con remesa generada (por lo que si se
			// elimina la remesa, se podr eliminar el acuse)
			if (tramitehecho.getTramiteHecho() != null
					&& Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramitehecho.getTramiteHecho().getEhcotee())
					&& Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA
							.equals(tramitehecho.getTramiteHecho().getEhtiponotificacion())
					&& Y41bConstantes.SI.equals(tramitehecho.getTramiteHecho().getEhenvrem())
					&& tramitehecho.getTramiteHecho().getEhcodrem() != null
					&& !tramitehecho.getTramiteHecho().getEhcodrem().equals("")) {
				throw new Y41bUDAException(
						"error.eliminarTramite.isTramiteAcuseReciboNotificacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		// No se permite eliminar el tramite de recepcin de traslado.
		if (Y41bConstantes.TRAMITE_RECEPCION_TRASLADO.equals(tramitehecho.getEhcotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteRecepcionTrasladoException", true,
					new Exception());
		}

		// No se permite eliminar el tramite de cierre de expediente si est
		// tramitado
		if (tramitehecho.getEhfechafin() != null
				&& Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE.equals(tramitehecho.getEhcotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteCierreException", true, new Exception());
		}

		// Al elminar el acuse de recibo (en los casos que se pueda) el tramite
		// notificacion asociado pasara a estar como pendiente.
		if (Y41bConstantes.TRAMITE_ACUSE_RECIBO.equals(tramitehecho.getEhcotee())) {

			if (tramitehecho.getTramiteHecho() != null
					&& Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramitehecho.getTramiteHecho().getEhcotee())) {
				TramiteHecho tramitehechoAux = new TramiteHecho();
				tramitehechoAux.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
				tramitehechoAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				this.tramiteHechoDao.updateReabrirTramite(tramitehechoAux);
			}
		}

		if (tramitehecho.getEhfechafin() != null
				&& Y41bConstantes.TRAMITE_SOLICITUD_INSPECCION.equals(tramitehecho.getEhcotee())) {
			// Elimina el registro de la bandeja de propuestas de inspeccion (si
			// existe).
			InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();
			inspeccionesPropBandeja.setBaprinsexcodigo(tramitehecho.getEhcohd());
			List<InspeccionesPropBandeja> listaInspeccionesPropBandeja = this.inspeccionesPropBandejaService
					.findAll(inspeccionesPropBandeja, null);

			if (listaInspeccionesPropBandeja.size() > 0) {
				for (InspeccionesPropBandeja inspPropBandeja : listaInspeccionesPropBandeja) {
					this.inspeccionesPropBandejaService.remove(inspPropBandeja);
				}
			}
		}

		try {
			// 3. Eliminamos el tramiteHecho
			// 3.1 Recuperamos los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(ehcodigo);
			List<DocumentoExpediente> documentosHecho = this.documentoHechoDao
					.findAllDocumentosGeneradosTramite(tramiteComun, null);
			// 3.2 Eliminamos los documentos del tramite de la tabla intermedia
			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(ehcodigo);
			this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);
			// 3.3.1 Eliminamos el tramiteHecho en la bandeja de solicitudes
			BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
			bandejasolicitudes.setHdcodigo(tramitehecho.getEhcohd());
			this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);
			// 3.3.2 Recorremos tabla de documentos y los eliminamos
			DocumentoHecho documentoHechoAux = null;
			if (documentosHecho != null && documentosHecho.size() > 0) {
				for (DocumentoExpediente documentoExpediente : documentosHecho) {
					try {
						documentoHechoAux = new DocumentoHecho();
						documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
						this.documentoHechoDao.remove(documentoHechoAux);
					} catch (DataIntegrityViolationException e) {
						// Si tiene tramnite relacionado dara esta excepcion
						throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException",
								true, e);
					}
				}
			}
			// 3.3.3 Eliminamos el tramiteHecho
			this.tramiteHechoDao.remove(tramitehecho);

			if (Y41bConstantes.TRAMITE_REGISTRO_DECISION.equals(tramitehecho.getEhcotee())) {
				Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
				// Codigo del hecho denunciado
				sanpropbandeja.setBaprsanexcodigo(tramitehecho.getEhcohd());

				this.sanpropbandejaService.removeSolicitudes(sanpropbandeja);

				HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
				hechodenunciadoAux.setHdcodigo(tramitehecho.getEhcohd());
				hechodenunciadoAux.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);

				this.hechoDenunciadoDao.updateIndicadorArbitraje(hechodenunciadoAux);

				Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
				// Codigo del hecho denunciado
				arbpropbandeja.setBaprarbexcodigo(tramitehecho.getEhcohd());
				this.arbpropbandejaService.removeSolicitudes(arbpropbandeja);

				// eliminar infracciones
				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
				this.infraccHechoDenDao.removeAllInfraccionesHecho(tramiteComun);

				// buscar el tramite de decision
				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
				tramiteHechoDetalle.setHdcodigo(tramitehecho.getEhcohd());

				Long tramiteRegistroDecisionTramitado = this.tramiteHechoDao
						.findAllTramiteRegistroDecisionTramitadoCount(tramiteHechoDetalle);

				if (tramiteRegistroDecisionTramitado == 0) {
					tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
					TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
					this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);
				} else {
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					try {
						TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
						miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_DECISION);
						miTramiteHechoDetalle.setHdcodigo(tramitehecho.getEhcohd());

						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteTramitado(miTramiteHechoDetalle);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null) {
						TramiteHecho tramiteHechoAux = new TramiteHecho();
						tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

						tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

						if (tramiteHechoAux != null) {
							tramiteComun = new TramiteComun();
							tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
							TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
							tramiteRegistroDecision.setFechaDecision(tramiteHechoAux.getEhfecharesolucion());
							tramiteRegistroDecision.setTipoDecision(tramiteHechoAux.getEhdecodigo());
							this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);
						}
					}

				}
			}

			// 3.5 Actualizamos Bandeja Firma - Elinamos de la bandeja todos
			// los documentos del tramite
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(ehcodigo);
			bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

			this.actualizarUltimoTramite(tramitehecho);

			// Actualizamos Bandeja Solicitudes
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
			this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciado);

			// Eliminamos los documentos de dokusi
			if (documentosHecho != null && documentosHecho.size() > 0) {
				for (DocumentoExpediente documentoExpediente : documentosHecho) {
					if (documentoExpediente != null && documentoExpediente.getIddocumentum() != null
							&& !documentoExpediente.getIddocumentum().equals("")) {

						documentoHechoAux = new DocumentoHecho();
						documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
						Long numTramitesUtilizado = this.documentoHechoDao
								.findAllDocTramiteHechoCount(documentoHechoAux);

						if (numTramitesUtilizado == 0) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(documentoExpediente.getIddocumentum());
							documento.setBoolAllVersions("true");

							y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						}
					}
				}
			}
		} catch (DataIntegrityViolationException e) {
			// Si tiene tramnite relacionado dara esta excepcion
			throw new Y41bUDAException("error.eliminarTramite.DataIntegrityViolationException", true, e);
		}

		if (tramitehecho != null && tramitehecho.getEhproceedingsidplatea() != null) {
			try {
				this.eliminarMisGestionesReclamante(tramitehecho);
				this.eliminarMisGestionesReclamado(tramitehecho);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
		logger.info("eliminarTramite fin:" + ehcodigo);
	}

	/**
	 * Reabrir expediente
	 * 
	 * @param ehcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrirExpediente(String hdcodigo, CensoMonitor censoMonitor) throws Exception {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// buscar el tramite de cierre
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

		tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		try {
			tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
		} catch (Exception e) {
		}

		// eliminar tramite de cierre
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehecho.setEhcohd(solicitudDetalle.getHdcodigo());
		this.tramiteHechoDao.remove(tramitehecho);

		// Eliminamos la fecha de cierre
		this.hechoDenunciadoDao.updateFechaCierreReabrirExpediente(solicitudDetalle);

		// crear tramite generico
		this.generarTramiteGenericoReabrirExpediente(solicitudDetalle, censoMonitor);

		// actualizar el ultimo tramite realizado
		this.actualizarUltimoTramite(tramitehecho);

		// Actualizamos Bandeja Solicitudes
		HechoDenunciado hechodenunciado = new HechoDenunciado();
		hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciado);

		this.reabrirExpedienteParticipacion(solDetalle);
	}

	/**
	 * Reabrir expediente participacion reclamante
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 */
	private void reabrirExpedienteParticipacion(SolicitudDetalle solDetalle) throws Exception {
		// Reabrir expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(solDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solDetalle.getDtnif());
		datosPersona.setNombre(solDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solDetalle.getDtapellido1())) {
			datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).toString());

			if (Y41bUtils.isFilled(solDetalle.getDtapellido2())) {
				datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).append(" ")
						.append(solDetalle.getDtapellido2()).toString());
			}
		}

		datosPersona.setMail(solDetalle.getDttecoem());
		datosPersona.setTelefono(solDetalle.getDtnrtel());
		datosPersona.setIdioma(solDetalle.getHdidioma());
		actualizarExpediente.setIdiomaNotificacion(solDetalle.getHdidioma());

		// buscar el representante del reclamante validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(solDetalle.getHdcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		actualizarExpediente.setSolicitante(datosPersona);

		if (solDetalle.getHdparticipacionreclamado() != null
				&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {

			actualizarExpediente.setIdParticipacionInteresado(solDetalle.getHdidparticipacionreclamado());

			DatosPersona datosInteresado = new DatosPersona();
			datosInteresado.setDni(solDetalle.getEsnif());
			datosInteresado.setNombre(solDetalle.getEsnombre());

			datosInteresado.setMail(solDetalle.getEscoem());
			datosInteresado.setTelefono(solDetalle.getEsnrtel());
			datosInteresado.setIdioma(solDetalle.getHdidiomareclamado());
			actualizarExpediente.setIdiomaNotificacionInteresado(solDetalle.getHdidiomareclamado());

			// buscar el representante del reclamante validado
			// si existe se aade
			intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(solDetalle.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
			intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

			if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

				DatosPersona datosPersonaRepresentante = new DatosPersona();
				datosPersonaRepresentante.setDni(intervinientes.getNif());
				datosPersonaRepresentante.setNombre(intervinientes.getNombre());

				if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

					if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
						datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1())
								.append(" ").append(intervinientes.getApellido2()).toString());
					}
				}
				actualizarExpediente.setRepresentanteInteresado(datosPersonaRepresentante);

				// Si tiene representante los datos sern del representante
				datosInteresado.setMail(intervinientes.getCoem());
				datosInteresado.setTelefono(intervinientes.getNrtel());
			}

			// En actualizarExpediente el solicitante es el titular de la
			// participacin, en nuestro caso
			// el reclamado
			actualizarExpediente.setInteresado(datosInteresado);

		}

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		actualizarExpediente.setEjercicio(solDetalle.getDenran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solDetalle.getNumregistroentrada());
		datosRegistro.setRegistryTimestamp(
				Y41bUtils.formatearDateToString(solDetalle.getDefere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		actualizarExpediente.setDatosRegistro(datosRegistro);

		Calendar cal = Calendar.getInstance();
		cal.setTime(solDetalle.getDefere());
		actualizarExpediente.setStartTimestamp(cal);

		// Tramites Expediente
		List<Proceedings> listProceedingsReclamante = new ArrayList<Proceedings>();

		Proceedings proceedings = new Proceedings();
		if (solDetalle.getistelematico() != null && solDetalle.getistelematico().equals(Y41bConstantes.SI)) {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_TELEMATICO);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_EU);
		} else {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_PRESENCIAL);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU);
		}

		// buscar tramite de registro de solicitud
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

		tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		try {
			tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			// "El tipo tramite se vuelve a asignar, ya que en la find NO de
			// devuelve y luego se va a usar"
			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		} catch (Exception e) {
		}

		// Si no tiene tramite de registro de solicitud,
		// buscar el tramite de Recepcion de traslado (debiera ser de Y41A)
		if (null == tramiteHechoDetalle.getEhcodigo()) {
			tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());
			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
				// "El tipo tramite se vuelve a asignar, ya que en la find NO de
				// devuelve y luego se va a usar"
				tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			} catch (Exception e) {
			}
		}

		Date fechaAux_ehfechafin = tramiteHechoDetalle.getEhfechafin();
		if (null == fechaAux_ehfechafin) {
			fechaAux_ehfechafin = tramiteHechoDetalle.getEhfecha();
		}

		cal = Calendar.getInstance();
		cal.setTime(fechaAux_ehfechafin);
		proceedings.setTimestamp(cal);

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteHechoDetalle.getEhcodigo());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		List<Documento> documentos = new ArrayList<Documento>();
		// "Jgrey (22/03/2017): 91240: [Construccion] - Adecuacion de Mis
		// gestiones"
		// "SOLO se incorporarn documentos si el tramite es de tipo Registro
		// solicitud. Para el resto (en principio, solo trmite de Traslado) NO
		// se incorporaran documentos."
		if (Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD.equals(tramiteHechoDetalle.getTrcodigo())) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						if (documentoHecho.getQ5nofile() != null
								&& !documentoHecho.getQ5nofile().contains("_Fichareducida")) {
							documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
							documento.setDescripcion(documentoHecho.getQ5tedesfile());
							documento.setNombre(documentoHecho.getQ5nofile());
							documentos.add(documento);
						}
					}
				}
			}
		}

		proceedings.setDocumentos(documentos);

		listProceedingsReclamante.add(proceedings);

		proceedings = new Proceedings();
		if (solDetalle.getistelematico() != null && solDetalle.getistelematico().equals(Y41bConstantes.SI)) {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
		} else {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);
		}

		cal = Calendar.getInstance();
		cal.setTime(fechaAux_ehfechafin);
		cal.add(Calendar.MINUTE, 1);
		proceedings.setTimestamp(cal);

		listProceedingsReclamante.add(proceedings);

		// buscar los tramites de aportacin de documentacin
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());
		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
				.findAllTramiteHecho(tramiteHechoDetalle, null);
		if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {
			for (int i = 0; i < listTramiteHechoDetalle.size(); i++) {
				tramiteHechoDetalle = listTramiteHechoDetalle.get(i);

				if (tramiteHechoDetalle.getEhfechafin() != null) {
					if (tramiteHechoDetalle.getTrcodigo() != null && tramiteHechoDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION)) {
						listProceedingsReclamante = this
								.reabrirExpedienteAportacionDocumentacionParticipacionReclamante(tramiteHechoDetalle,
										listProceedingsReclamante);
					} else if (tramiteHechoDetalle.getTrcodigo() != null
							&& tramiteHechoDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
						listProceedingsReclamante = this.reabrirExpedienteComunicacionParticipacionReclamante(
								tramiteHechoDetalle, listProceedingsReclamante);
					} else if (tramiteHechoDetalle.getTrcodigo() != null
							&& tramiteHechoDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_ACUSE_RECIBO)) {
						listProceedingsReclamante = this.reabrirExpedienteAcuseReciboParticipacionReclamante(
								tramiteHechoDetalle, listProceedingsReclamante);
					}
				}
			}
		}

		// Eliminar duplicados
		Map<String, Proceedings> mapProceedingsReclamante = new HashMap<String, Proceedings>(
				listProceedingsReclamante.size());

		for (Proceedings p : listProceedingsReclamante) {
			mapProceedingsReclamante.put(p.getProceedingsID(), p);
		}

		List listaProceedingsReclamanteSinDuplicados = new ArrayList();
		// Agrego cada elemento del map a una nueva lista y muestro cada
		// elemento.
		for (Entry<String, Proceedings> p : mapProceedingsReclamante.entrySet()) {
			listaProceedingsReclamanteSinDuplicados.add(p.getValue());
		}

		actualizarExpediente.setProceedings(listaProceedingsReclamanteSinDuplicados);

		if (solDetalle.getHdparticipacionreclamado() != null
				&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
			List<Proceedings> listProceedingsReclamado = new ArrayList<Proceedings>();

			proceedings = new Proceedings();
			if (solDetalle.getistelematico() != null && solDetalle.getistelematico().equals(Y41bConstantes.SI)) {
				proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
			} else {
				proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);
			}

			cal = Calendar.getInstance();
			cal.setTime(fechaAux_ehfechafin);
			cal.add(Calendar.MINUTE, 1);
			proceedings.setTimestamp(cal);

			listProceedingsReclamado.add(proceedings);

			// buscar los tramites de aportacin de documentacin
			tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());
			listTramiteHechoDetalle = this.tramiteHechoDao.findAllTramiteHecho(tramiteHechoDetalle, null);
			if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {
				for (int i = 0; i < listTramiteHechoDetalle.size(); i++) {
					tramiteHechoDetalle = listTramiteHechoDetalle.get(i);

					if (tramiteHechoDetalle.getEhfechafin() != null) {
						if (tramiteHechoDetalle.getTrcodigo() != null && tramiteHechoDetalle.getTrcodigo()
								.equals(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION)) {
							listProceedingsReclamado = this
									.reabrirExpedienteAportacionDocumentacionParticipacionReclamado(tramiteHechoDetalle,
											listProceedingsReclamado);
						} else if (tramiteHechoDetalle.getTrcodigo() != null
								&& tramiteHechoDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
							listProceedingsReclamado = this.reabrirExpedienteComunicacionParticipacionReclamado(
									tramiteHechoDetalle, listProceedingsReclamado);
						} else if (tramiteHechoDetalle.getTrcodigo() != null
								&& tramiteHechoDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_ACUSE_RECIBO)) {
							listProceedingsReclamado = this.reabrirExpedienteAcuseReciboParticipacionReclamado(
									tramiteHechoDetalle, listProceedingsReclamado);
						}
					}
				}
			}

			Map<String, Proceedings> mapProceedingsReclamado = new HashMap<String, Proceedings>(
					listProceedingsReclamado.size());

			for (Proceedings p : listProceedingsReclamado) {
				mapProceedingsReclamado.put(p.getProceedingsID(), p);
			}

			List listaProceedingsReclamadoSinDuplicados = new ArrayList();
			// Agrego cada elemento del map a una nueva lista y muestro cada
			// elemento.
			for (Entry<String, Proceedings> p : mapProceedingsReclamado.entrySet()) {
				listaProceedingsReclamadoSinDuplicados.add(p.getValue());
			}

			actualizarExpediente.setProceedingsInteresado(listaProceedingsReclamadoSinDuplicados);
		}

		y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * participacin reclamante
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacionParticipacionReclamante(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteHechoDetalle.getEhcodigo());
		List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);
		if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
			DocumentoHecho documentoHecho = null;
			boolean aportadoReclamante = false;
			for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
				documentoHecho = listDocumentoHechoAporta.get(j);
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))
						&& documentoHecho.getQ5iddocumentum() != null
						&& !documentoHecho.getQ5iddocumentum().equals("")) {
					aportadoReclamante = true;
					break;
				}
			}
			if (aportadoReclamante) {
				Proceedings proceedings = new Proceedings();

				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
					proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

				List<Documento> documentos = new ArrayList<Documento>();
				Date fechaAportacion = null;
				if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
					documentoHecho = null;
					for (int k = 0; k < listDocumentoHechoAporta.size(); k++) {
						documentoHecho = listDocumentoHechoAporta.get(k);
						Documento documento = new Documento();
						if (documentoHecho.getQ5origen() != null
								&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
										|| documentoHecho.getQ5origen()
												.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))
								&& documentoHecho.getQ5iddocumentum() != null
								&& !documentoHecho.getQ5iddocumentum().equals("")) {
							if (fechaAportacion == null) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							} else if (documentoHecho.getQ5fechaentrada() != null
									&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							}

							documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
							documento.setDescripcion(documentoHecho.getQ5tedesfile());
							documento.setNombre(documentoHecho.getQ5nofile());
							documentos.add(documento);
						}
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String idioma = LocaleContextHolder.getLocale().getLanguage();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, idioma);

				String fechaAportacionConHoras = "";

				DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
						.append(hourFormat.format(tramiteHechoDetalle.getEhfechainicio())).toString();
				aportacionTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, LocaleContextHolder.getLocale()));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * participacin reclamado
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * 
	 * @throws Exception
	 *             Exception
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacionParticipacionReclamado(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteHechoDetalle.getEhcodigo());
		List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);
		if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
			DocumentoHecho documentoHecho = null;
			boolean aportadoReclamado = false;
			for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
				documentoHecho = listDocumentoHechoAporta.get(j);
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))
						&& documentoHecho.getQ5iddocumentum() != null
						&& !documentoHecho.getQ5iddocumentum().equals("")) {
					aportadoReclamado = true;
					break;
				}
			}
			if (aportadoReclamado) {
				Proceedings proceedings = new Proceedings();

				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
					proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

				List<Documento> documentos = new ArrayList<Documento>();
				Date fechaAportacion = null;
				if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
					documentoHecho = null;
					for (int k = 0; k < listDocumentoHechoAporta.size(); k++) {
						documentoHecho = listDocumentoHechoAporta.get(k);
						Documento documento = new Documento();
						if (documentoHecho.getQ5origen() != null
								&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
										|| documentoHecho.getQ5origen()
												.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))
								&& documentoHecho.getQ5iddocumentum() != null
								&& !documentoHecho.getQ5iddocumentum().equals("")) {
							if (fechaAportacion == null) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							} else if (documentoHecho.getQ5fechaentrada() != null
									&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							}
							documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
							documento.setDescripcion(documentoHecho.getQ5tedesfile());
							documento.setNombre(documentoHecho.getQ5nofile());
							documentos.add(documento);
						}
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String idioma = LocaleContextHolder.getLocale().getLanguage();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, idioma);

				String fechaAportacionConHoras = "";

				DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
						.append(hourFormat.format(tramiteHechoDetalle.getEhfechainicio())).toString();
				aportacionTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, LocaleContextHolder.getLocale()));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para requerimiento de subsanacion
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteRequerimientoSubsanacionParticipacionReclamante(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) {

		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		Proceedings proceedings = new Proceedings();

		if (tramitehechoAux != null && tramitehechoAux.getEhproceedingsidplatea() != null) {
			proceedings.setProceedingsID(tramitehechoAux.getEhproceedingsidplatea());
		} else {
			proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
		}

		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_EU);
		Calendar cal = Calendar.getInstance();
		cal.setTime(tramitehechoAux.getEhfechafin());
		proceedings.setTimestamp(cal);

		listProceedings.add(proceedings);

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para decision
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteDecision(TramiteHechoDetalle tramiteHechoDetalle,
			List<Proceedings> listProceedings) {

		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		Proceedings proceedings = new Proceedings();

		if (tramitehechoAux != null && tramitehechoAux.getEhproceedingsidplatea() != null) {
			proceedings.setProceedingsID(tramitehechoAux.getEhproceedingsidplatea());
		} else {
			proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
		}

		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_DECISION_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_DECISION_EU);
		Calendar cal = Calendar.getInstance();
		cal.setTime(tramitehechoAux.getEhfechafin());
		proceedings.setTimestamp(cal);

		Decision decision = new Decision();
		decision.setDecodigo(tramitehechoAux.getEhdecodigo());

		decision = this.decisionDao.find(decision);

		proceedings.setDecisionCast(decision.getDenombre());
		proceedings.setDecisionEus(decision.getDenombree());
		cal = Calendar.getInstance();
		cal.setTime(tramitehechoAux.getEhfecharesolucion());
		proceedings.setDecisiontimestamp(cal);

		listProceedings.add(proceedings);

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion participacin
	 * reclamante
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacionParticipacionReclamante(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		boolean remesaEmitida = true;
		if (tramitehechoAux.getEhenvrem() != null && tramitehechoAux.getEhenvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (tramitehechoAux.getEhcodrem() != null && !tramitehechoAux.getEhcodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(tramitehechoAux.getEhcodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramitehechoAux.getEhiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))
				&& (tramitehechoAux.getEhtipocomunicacion() != null && (tramitehechoAux.getEhtipocomunicacion()
						.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
						|| tramitehechoAux.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
					&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setEhcodigo(tramitehecho.getEhcodigo());

				if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteHechoDetalleAux, listProceedings);
				} else if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION)) {
					listProceedings = this.reabrirExpedienteRequerimientoSubsanacionParticipacionReclamante(
							tramiteHechoDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramitehechoAux.getEhidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramitehechoAux.getEhidnotificacionplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteHechoDetalle.getEhcodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion participacin
	 * reclamado
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacionParticipacionReclamado(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		boolean remesaEmitida = true;
		if (tramitehechoAux.getEhenvrem() != null && tramitehechoAux.getEhenvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (tramitehechoAux.getEhcodrem() != null && !tramitehechoAux.getEhcodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(tramitehechoAux.getEhcodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramitehechoAux.getEhiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))
				&& (tramitehechoAux.getEhtipocomunicacion() != null && (tramitehechoAux.getEhtipocomunicacion()
						.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
						|| tramitehechoAux.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
					&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setEhcodigo(tramitehecho.getEhcodigo());

				if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteHechoDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramitehechoAux.getEhidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramitehechoAux.getEhidnotificacionplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteHechoDetalle.getEhcodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo participacion
	 * reclamante
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAcuseReciboParticipacionReclamante(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) {

		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramitehechoAux.getTramiteHecho().getEhiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
			tramitehecho = this.tramiteHechoDao.find(tramitehecho);
			if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
					&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {

				tramitehecho.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setEhcodigo(tramitehecho.getEhcodigo());

				if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteHechoDetalleAux, listProceedings);
				} else if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION)) {
					listProceedings = this.reabrirExpedienteRequerimientoSubsanacionParticipacionReclamante(
							tramiteHechoDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea());

			proceedings.setNotifiedActId(tramitehechoAux.getTramiteHecho().getEhtiponotificacionplatea());

			cal = Calendar.getInstance();
			cal.setTime(tramitehechoAux.getTramiteHecho().getEhfechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			proceedings.setNotifiedResult(tramitehechoAux.getEhacusereciborecibido());

			if (proceedings.getNotifiedResult() != null
					&& !proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				cal = Calendar.getInstance();
				cal.setTime(tramitehechoAux.getEhacuserecibo());
				proceedings.setNotifiedDeliverytimestamp(cal);
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramitehechoAux.getTramiteHecho().getEhcodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;

				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo participacion
	 * reclamado
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAcuseReciboParticipacionReclamado(
			TramiteHechoDetalle tramiteHechoDetalle, List<Proceedings> listProceedings) {

		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramitehechoAux.getTramiteHecho().getEhiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
			tramitehecho = this.tramiteHechoDao.find(tramitehecho);
			if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
					&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {

				tramitehecho.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setEhcodigo(tramitehecho.getEhcodigo());

				if (tramitehecho.getEhcotee() != null
						&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteHechoDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteHechoDetalle.getEhproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteHechoDetalle.getEhfechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea());

			proceedings.setNotifiedActId(tramitehechoAux.getTramiteHecho().getEhtiponotificacionplatea());

			cal = Calendar.getInstance();
			cal.setTime(tramitehechoAux.getTramiteHecho().getEhfechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			proceedings.setNotifiedResult(tramitehechoAux.getEhacusereciborecibido());

			if (proceedings.getNotifiedResult() != null
					&& !proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				cal = Calendar.getInstance();
				cal.setTime(tramitehechoAux.getEhacuserecibo());
				proceedings.setNotifiedDeliverytimestamp(cal);
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramitehechoAux.getTramiteHecho().getEhcodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;

				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que actualiza el ultimo tramite
	 * 
	 * @param tramitehecho
	 *            Tramitehecho
	 */
	private void actualizarUltimoTramite(TramiteHecho tramitehecho) {
		// consultar el ultimo tramite realizado
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(tramitehecho.getEhcohd());

		TramiteHechoDetalle tramiteHechoDetalleAux = null;

		tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoYFase(tramiteHechoDetalle);

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHddenunciaaaccempresas() != null
				&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(tramiteHechoDetalleAux.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ALEGACION.equals(tramiteHechoDetalleAux.getTrcodigo())) {
				tramiteHechoDetalleAux.setFcodigo(Y41bConstantes.FASE_ALEGACIONES);
			}
		}

		// si es tramite generico consultar el ultimo tramite no generico
		if (tramiteHechoDetalleAux.getFcodigo() == null || tramiteHechoDetalleAux.getFcodigo().equals("")) {
			TramiteHechoDetalle tramiteHechoDetalleAux2 = null;
			tramiteHechoDetalleAux2 = this.tramiteHechoDao.findUltimoTramiteHechoYFaseNoGenerico(tramiteHechoDetalle);

			if (solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(tramiteHechoDetalleAux2.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ALEGACION.equals(tramiteHechoDetalleAux2.getTrcodigo())) {
					tramiteHechoDetalleAux2.setFcodigo(Y41bConstantes.FASE_ALEGACIONES);
				}
			}

			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciadoAux.setFcodigoactual(tramiteHechoDetalleAux2.getFcodigo());
			hechodenunciadoAux.setTrcodigoactual(tramiteHechoDetalleAux.getTrcodigo());

			if (!tramiteHechoDetalleAux2.getTrcodigo().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
				hechodenunciadoAux.setTrposiblecodigo(tramiteHechoDetalleAux2.getTrcodigo());
			} else {
				// buscar tramite no generico que no sea cierre
				TramiteHechoDetalle tramiteHechoDetalleAux3 = this.tramiteHechoDao
						.findUltimoTramiteHechoYFaseNoGenericoNoCierre(tramiteHechoDetalle);
				hechodenunciadoAux.setTrposiblecodigo(tramiteHechoDetalleAux3.getTrcodigo());
			}

			this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);

		} else {
			// si no es tramite generico actualizar
			// updateUltimoTramiteConFase
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciadoAux.setFcodigoactual(tramiteHechoDetalleAux.getFcodigo());
			hechodenunciadoAux.setTrcodigoactual(tramiteHechoDetalleAux.getTrcodigo());

			if (!tramiteHechoDetalleAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
				hechodenunciadoAux.setTrposiblecodigo(tramiteHechoDetalleAux.getTrcodigo());

				if (tramiteHechoDetalleAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR)) {
					// Si el tramite de asignacin est pendiente,los posibles
					// tramites se calculan con el tramite de registro de
					// solicitud
					if (tramiteHechoDetalleAux.getEhestadotramite() != null && tramiteHechoDetalleAux
							.getEhestadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION)) {
						hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
					}
				}

			} else {
				// buscar tramite no generico que no sea cierre
				TramiteHechoDetalle tramiteHechoDetalleAux3 = this.tramiteHechoDao
						.findUltimoTramiteHechoYFaseNoGenericoNoCierre(tramiteHechoDetalle);
				hechodenunciadoAux.setTrposiblecodigo(tramiteHechoDetalleAux3.getTrcodigo());
			}

			this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
		}
	}

	/**
	 * Obtiene la carga de trabajo de los inspectores del organismo
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CargaTrabajo> getCargatrabajo(CensoMonitor censoMonitor) {

		List<CargaTrabajo> listCargaTrabajoExpedientes = this.hechoDenunciadoDao
				.findAllExpedientesCerradosOrganismo(censoMonitor, null);

		return listCargaTrabajoExpedientes;
	}

	/**
	 * Guardar Tramite Registro Solicitud
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRegistroSolicitud(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		if (tramitar) {
			// Validar campos obligatorios
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solicitudDetalle);
			solDetalle.setHdte(solDetalleAux.getHdte());

			if (validarSiSolicitudEstaCompleta(solDetalle)) {
				throw new Y41bUDAException("error.solicitud.noCompletaSolicitudException", true, new Exception());
			}

			if (!Y41bUtils.isFilled(solDetalle.getDtnif())) {
				throw new Y41bUDAException("error.solicitud.nifReclamanteException", true, new Exception());
			}

			if (!Y41bUtils.isFilled(solDetalle.getEsnif())) {
				throw new Y41bUDAException("error.solicitud.nifReclamadoException", true, new Exception());
			}
		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRegistroSolicitud.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRegistroSolicitud.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRegistroSolicitud.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRegistroSolicitud.getComentario());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRegistroSolicitud.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRegistroSolicitud.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);

		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRegistroSolicitud.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			if (solDetalle.getistelematico() != null && solDetalle.getistelematico().equals(Y41bConstantes.SI)) {
				this.insertarFichaReducidaRegistroSolicitud(solicitudDetalle, tramiteComun);
			}
			// modificar el responsable del expediente

			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {
				Organismo organismo = new Organismo();
				organismo.setCodOrg(solDetalle.getHccoor());

				censoMonitorCoordinador.setOrganismo(organismo);

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorSolicitudes(censoMonitorCoordinador);
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
			}

			// Actualizamos el instructor del hecho denunciado
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramiteComun.getIdExpediente());
			hechodenunciado.setCensoMonitor(censoMonitorCoordinador);

			this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

			solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			this.generarTramiteAsignacionInstructorAutomatico(solDetalle);

			// Actualizar ultimo tramite
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(solDetalle.getHdcodigo());
			hechodenunciadoAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
			hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

			this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		if (tramitar) {
			if (solDetalle.getistelematico() == null || solDetalle.getistelematico().equals("")
					|| solDetalle.getistelematico().equals(Y41bConstantes.NO)) {
				this.abrirExpedientePresencialPlatea(solDetalle, tramiteComun);
			} else {
				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				this.adjuntarDocumentosTramiteCorrespondienteRegistroSolicitud(listDocumentoHecho, tramiteComun);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los adjunta en
	 * los tramites correspondientes
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void adjuntarDocumentosTramiteCorrespondienteRegistroSolicitud(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun) throws Exception {
		// MODIFICACIONES DE LA TRAMITACION DE APORTACION DE DOCUMENTOS
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5idTipodoc() != null && documentoHecho.getQ5idTipodoc()
						.equals(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION)) {

					// generar tramite y adjuntar el documento
					this.generarTramiteRecepcionAcreditacionRepresentacion(tramiteComun, documentoHecho);

					// Actualizar ultimo tramite
					this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION, null,
							tramiteComun.getIdExpediente());
				}
			}
		}
	}

	/**
	 * Actualiza la participacin del reclamante
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionReclamante(TramiteComun tramiteComun) throws Exception {

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

		// Validar campos obligatorios
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(solDetalle.getHdidparticipacionreclamante());

		// Reclamante
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solDetalle.getDtnif());
		datosPersona.setNombre(solDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solDetalle.getDtapellido1())) {
			datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).toString());

			if (Y41bUtils.isFilled(solDetalle.getDtapellido2())) {
				datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).append(" ")
						.append(solDetalle.getDtapellido2()).toString());
			}
		}

		// Si tiene representante los datos sern del representante
		datosPersona.setMail(solDetalle.getDttecoem());
		datosPersona.setTelefono(solDetalle.getDtnrtel());

		datosPersona.setIdioma(solDetalle.getHdidioma());

		// buscar el representante del reclamante validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		// En actualizarExpediente el solicitante es el titular de la
		// participacin, en nuestro caso
		// el reclamante
		actualizarExpediente.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setEjercicio(solDetalle.getDenran().toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solDetalle.getNumregistroentrada());
		datosRegistro.setRegistryTimestamp(
				Y41bUtils.formatearDateToString(solDetalle.getDefere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		actualizarExpediente.setDatosRegistro(datosRegistro);

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Actualiza la participacin del reclamado
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionReclamado(TramiteComun tramiteComun) throws Exception {

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(solDetalle.getHdidparticipacionreclamado());

		// Reclamado
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solDetalle.getEsnif());
		datosPersona.setNombre(solDetalle.getEsnombre());

		// Si tiene representante los datos sern del representante
		// datosPersona.setMail(solDetalle.getEscoem());
		// datosPersona.setTelefono(solDetalle.getEsnrtel());

		datosPersona.setIdioma(solDetalle.getHdidiomareclamado());

		// buscar el representante del reclamante validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		// En actualizarExpediente el solicitante es el titular de la
		// participacin, en nuestro caso
		// el reclamado
		actualizarExpediente.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setEjercicio(solDetalle.getDenran().toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solDetalle.getNumregistroentrada());
		datosRegistro.setRegistryTimestamp(
				Y41bUtils.formatearDateToString(solDetalle.getDefere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		actualizarExpediente.setDatosRegistro(datosRegistro);

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Metodo que graba los documentos del tramite
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws SQLException
	 */
	public void procesarDocumentosTramite(TramiteComun tramiteComun) {
		this.documentoHechoDao.removeAdjuntarDocsTramiteHecho(tramiteComun);

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}

		this.documentoHechoDao.addDocumentosHechoAdjuntarDocs(tramiteComun);

		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

		for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
			this.documentoHechoDao.updateDocumentosHechoAdjuntarDocs(adjuntardocsAux, tramiteComun);
		}

		this.documentoHechoDao.addAdjuntarDocsTramiteHecho(tramiteComun);

		this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws SQLException
	 *             SQLException
	 * @throws ParseException
	 *             ParseException
	 */
	private void abrirExpedientePresencialPlatea(SolicitudDetalle solDetalle, TramiteComun tramiteComun)
			throws SQLException, ParseException {
		// Abrir el expediente presencial
		SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		solicitudPresencial.setProcedure(procedure);

		solicitudPresencial.setIdParticipacion(solDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solDetalle.getDtnif());
		datosPersona.setNombre(solDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solDetalle.getDtapellido1())) {
			datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).toString());

			if (Y41bUtils.isFilled(solDetalle.getDtapellido2())) {
				datosPersona.setApellido1(new StringBuffer(solDetalle.getDtapellido1()).append(" ")
						.append(solDetalle.getDtapellido2()).toString());
			}
		}

		datosPersona.setMail(solDetalle.getDttecoem());
		datosPersona.setTelefono(solDetalle.getDtnrtel());
		datosPersona.setIdioma(solDetalle.getHdidioma());
		solicitudPresencial.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		solicitudPresencial.setNumeroExpediente(numeroExpediente.toString());

		solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solDetalle.getNumregistroentrada());
		datosRegistro.setRegistryTimestamp(
				Y41bUtils.formatearDateToString(solDetalle.getDefere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		solicitudPresencial.setDatosRegistro(datosRegistro);

		// Documento de solicitud

		// 1.User
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);

		// Validacion: Debe haber almenos 1 documento
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		Documento documento = null;
		List<Documento> listDocumentos = new ArrayList<Documento>();

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			documento = new Documento();

			documento.setUser(user);

			// 2.Tipo Documental
			documento.setTipoDocumental(documentoHechoAux.getQ5idTipodoc());

			documento.setIdDocumento(documentoHechoAux.getQ5codocumento().toString());
			documento.setNombre(documentoHechoAux.getQ5nofile());
			documento.setExtension(Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile()));
			documento.setDescripcion(documentoHechoAux.getQ5tedesfile());

			if (Y41bUtils.isFilled(documentoHechoAux.getQ5iddocumentum())) {
				documento.setOidDokusi(documentoHechoAux.getQ5iddocumentum());
			} else {
				Blob contenido = documentoHechoAux.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
			}

			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
			documento.setProcedure(procedure);

			documento.setRegistryNumber(solDetalle.getNumregistroentrada());
			documento.setRegistryTimestamp(
					Y41bUtils.formatearDateToString(solDetalle.getDefere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
			documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);

			listDocumentos.add(documento);
		}

		solicitudPresencial.setDocumentosAdjuntos(listDocumentos);

		solicitudPresencial = y41bPlateaAdapterService.crearSolicitudPresencial(solicitudPresencial);

		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documentoAux : solicitudPresencial.getDocumentosAdjuntos()) {
				// Actualizo OID Dokusi en tabla documentos hecho
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoAux.getIdDocumento());
				documentoHechoAux.setQ5iddocumentum(documentoAux.getOidDokusi());
				// Update oid de documentum
				this.documentoHechoDao.updateOIDDokusi(documentoHechoAux);

				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHechoAux);
			}
		}
	}

	/**
	 * Metodo que inserta la ficha reducida en el tramite de registro de
	 * solicitud para solicitudes WEB
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void insertarFichaReducidaRegistroSolicitud(SolicitudDetalle solicitudDetalle, TramiteComun tramiteComun)
			throws Exception {
		PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
				.findPlantillaSolicitudDetalle(solicitudDetalle);

		if (plantillaSolicitudDetalle.getHdte() != null) {
			plantillaSolicitudDetalle.setHdte(plantillaSolicitudDetalle.getHdte().replaceAll("\n", "&lineSeparator;"));
			plantillaSolicitudDetalle.setHdte(
					plantillaSolicitudDetalle.getHdte().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
			plantillaSolicitudDetalle.setHdte(
					Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdte()), 0));
		}

		if (plantillaSolicitudDetalle.getHdteso() != null) {
			plantillaSolicitudDetalle
					.setHdteso(plantillaSolicitudDetalle.getHdteso().replaceAll("\n", "&lineSeparator;"));
			plantillaSolicitudDetalle.setHdteso(
					plantillaSolicitudDetalle.getHdteso().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
			plantillaSolicitudDetalle.setHdteso(
					Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdteso()), 0));
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String rutaRTF = prop.getProperty("y41bVistaWar.ruta.plantillas.word");
		String rutaXML = prop.getProperty("y41bVistaWar.rutaxml.plantillas.word");
		String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_RTF;
		String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_XML;

		String rutaCompletaRTF = rutaRTF + nombreRTF;
		String rutaCompletaXML = rutaXML + nombreXML;

		String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

		String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML, plantillaSolicitudDetalle,
				plantilla);

		byte[] bytesFichero = strFileDataDecode.getBytes();

		// Cambiamos el objeto Response para visualizar el contenido del
		// archivo
		String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-" + plantillaSolicitudDetalle.getDenror() + "-"
				+ plantillaSolicitudDetalle.getDenran() + "_Fichareducida.rtf";

		String descFichero = plantillaSolicitudDetalle.getDecoor() + "-" + plantillaSolicitudDetalle.getDenror() + "-"
				+ plantillaSolicitudDetalle.getDenran() + "_Fichareducida";

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(String.valueOf(this.denunciaService.getNewPKDocumentoHecho().intValue()));
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHecho.setQ5nofile(nombreFichero);
		Blob blob = new SerialBlob(bytesFichero);
		documentoHecho.setQ5datafile(blob);
		documentoHecho.setQ5sizefile(bytesFichero.length);
		documentoHecho.setQ5tedesfile(descFichero);
		documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5fecha(new Date());
		documentoHecho.setQ5contenttypefile("application/msword");

		documentoHecho.setQ5fechaaportacion(new Date());
		documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_SOLICITUD);
		this.documentoHechoDao.add(documentoHecho);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
	}

	/**
	 * Guardar tramite aportacion de documentacion
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteAdjuntarDocs.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteAdjuntarDocs.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteAdjuntarDocs.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteAdjuntarDocs.getComentario());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteAdjuntarDocs.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteAdjuntarDocs.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_APORTACION_DOCUMENTOS)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
			this.enviarMailInstructor(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION, null,
				tramiteComun.getIdExpediente());

		if (tramitar) {
			// Subimos los documentos a dokusi sin localizar
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {

				// Recorro los documentos del tramite buscando aquel
				// documento que
				// este pendiente de firma
				DocumentoHecho documentoHecho = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					TramiteComun tramiteComunDokusiAux = new TramiteComun();
					tramiteComunDokusiAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunDokusiAux.setIdTramite(documentoHecho.getQ5tramite());

					// this.registrarDocumentosDokusiSinLocalizarSol(documentoHecho,
					// tramiteComunDokusiAux);
					this.registrarDocumentosDokusiSol(documentoHecho, tramiteComunDokusiAux);
				}
			}

			TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

			if (tramitehechoAux.getEhistelematico() == null) {
				this.denunciaService.actualizarMisGestionesAportaciondocumentacion(tramitehecho, listDocumentoHecho);
			}

			this.adjuntarDocumentosTramiteCorrespondiente(listDocumentoHecho, tramiteComun);
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los adjunta en
	 * los tramites correspondientes
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void adjuntarDocumentosTramiteCorrespondiente(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun) throws Exception {
		// MODIFICACIONES DE LA TRAMITACION DE APORTACION DE DOCUMENTOS
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_SUBSANACION)) {
					// se debe buscar el trmite de recepcin de subsanacin
					// pendiente de tramitar con el origen que coincida
					// con el origen de la aportacin y aportarlo. Si existe
					// ms de un trmite, se aportar al ltimo trmite
					// pendiente de recepcin.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
					}

					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteHechoDetalleAux, origen);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_REQUERIMIENTO)) {
					// se debe buscar el trmite de recepcin de
					// requerimiento pendiente de tramitar
					// con el destino que coincida con el origen de la
					// aportacin y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
					}

					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteHechoDetalleAux, origen);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}

				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_ALEGACION)) {
					// se debe buscar el trmite de recepcin de
					// requerimiento pendiente de tramitar
					// con el destino que coincida con el origen de la
					// aportacin y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
					}

					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteHechoDetalleAux, origen);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRegistroAlegaciones(tramiteComun, documentoHecho);

						// Actualizar ultimo tramite
						this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ALEGACION, null,
								tramiteComun.getIdExpediente());
					}

				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_RESPUESTA_MEDIACION)) {
					// se debe buscar el trmite de recepcin de
					// requerimiento pendiente de tramitar
					// con el destino que coincida con el origen de la
					// aportacin y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
					}

					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteHechoDetalleAux, origen);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRespuestaSegundaMediacion(tramiteComun, documentoHecho);

						// Actualizar ultimo tramite
						this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION, null,
								tramiteComun.getIdExpediente());
					}

				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_RECURSO)) {
					// habr que buscar el ultimo, sino generarlo
					// se genere automticamente el trmite de recepcin de
					// recurso de alzada y se adjunte el documento al
					// tramite
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_RECURSO);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteHechoDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRecepcionRecurso(tramiteComun, documentoHecho);

						// Actualizar ultimo tramite
						this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_RECURSO, null,
								tramiteComun.getIdExpediente());
					}
				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_ORDEN)) {
					// se debe buscar el trmite de recepcin de orden de
					// consejero y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteHechoDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
				} else if (documentoHecho.getQ5idTipodoc() != null && documentoHecho.getQ5idTipodoc()
						.equals(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION)) {
					// habr que buscar el ultimo, sino generarlo
					// se genere automticamente el trmite de recepcin de
					// recurso de alzada y se adjunte el documento al
					// tramite
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
						origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
					}

					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteHechoDetalleAux, origen);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRecepcionAcreditacionRepresentacion(tramiteComun, documentoHecho);

						// Actualizar ultimo tramite
						this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION, null,
								tramiteComun.getIdExpediente());
					}
				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_SOLICITUD_AMPLIACION_PLAZO)) {
					// se debe buscar el trmite de respuesta ampliacion plazo
					// Si existe sin tramitar, no se crea.
					// Si no existe, se crear el tramite sin adjuntar ningun
					// documento.
					TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
					tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO);
					tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteHechoDetalleAux = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteHechoDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() == null) {
						// generar tramite y adjuntar el documento
						this.generarTramiteRespuestaAmpliacionPlazo(tramiteComun);

						// Actualizar ultimo tramite
						this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO, null,
								tramiteComun.getIdExpediente());
					}
				}

			}
		}
	}

	/**
	 * Generar Tramite Automatico de Registro de Alegaciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRegistroAlegaciones(TramiteComun tramiteComun, DocumentoHecho documentoHecho)
			throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ALEGACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		String origen = "";
		if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		} else if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
		}

		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(origen);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Respuesta Segunda Mediacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRespuestaSegundaMediacion(TramiteComun tramiteComun,
			DocumentoHecho documentoHecho) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		String origen = "";
		if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		} else if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
		}

		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(origen);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Recepcion de Recurso
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRecepcionRecurso(TramiteComun tramiteComun, DocumentoHecho documentoHecho)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_RECURSO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		tramitehecho.setEhtiporecurso(Y41bConstantes.TIPO_RECURSO_ALZADA);
		tramitehecho.setEhfecharecurso(todayWithZeroTime);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Recepcion Acreditacion Representacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRecepcionAcreditacionRepresentacion(TramiteComun tramiteComun,
			DocumentoHecho documentoHecho) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		String origen = "";
		if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		} else if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
		} else {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		}

		tramitehecho.setEhorigenalegacion(origen);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(new TramiteHecho(tramiteComun.getIdTramite(), null));

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Respuesta Ampliacion Plazo
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRespuestaAmpliacionPlazo(TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(new TramiteHecho(tramiteComun.getIdTramite(), null));

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Requerimiento Acreditacion Representacion
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRequerimientoAcreditacionRepresentacion(Intervinientes intervinientes)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(intervinientes.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		intervinientes = this.intervinientesDao.find(intervinientes);

		String origen = "";
		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO)) {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;
		} else {
			origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;
		}

		tramitehecho.setEhorigenalegacion(origen);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(new TramiteHecho(tramiteComun.getIdTramite(), null));

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		// actualizar el ultimo tramite realizado
		this.actualizarUltimoTramite(tramitehecho);

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Guardar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_GENERICO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteGenerico.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteGenerico.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteGenerico.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteGenerico.getComentario());

		tramitehecho.setEhnombretramite(tramiteGenerico.getNombreTramite());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteGenerico.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteGenerico.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_GENERICO, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteAsignacionInstructor(TramiteAsignacionInstructor tramiteAsignacionInstructor,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		logger.debug("###################INICIO ASIGNACION INSTRUCTOR");
		logger.debug("###################tramiteComun.getIdTramite()[" + tramiteComun.getIdTramite() + "]");

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteAsignacionInstructor.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteAsignacionInstructor.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteAsignacionInstructor.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteAsignacionInstructor.getComentario());

		tramitehecho.setEhcosc(tramiteAsignacionInstructor.getTipoSolicitud());

		tramitehecho.setEhcomodesignado(tramiteAsignacionInstructor.getInstructorExpediente().getMocodigo());

		tramitehecho
				.setEhsiguientestramites(Y41bUtils.stringToClob(tramiteAsignacionInstructor.getSiguientesTramites()));

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteAsignacionInstructor.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteAsignacionInstructor.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		logger.debug("###################INICIO GRABAR TRAMITE ASIGNACION INSTRUCTOR");
		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}
		logger.debug("###################FIN GRABAR TRAMITE ASIGNACION INSTRUCTOR");

		if (tramitar) {
			// Actualizamos el instructor del hecho denunciado
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramiteComun.getIdExpediente());
			hechodenunciado.setHdcosc(tramiteAsignacionInstructor.getTipoSolicitud());
			hechodenunciado.setCensoMonitor(tramiteAsignacionInstructor.getInstructorExpediente());

			this.hechoDenunciadoDao.updateTramiteCambioInstructor(hechodenunciado);

			SolicitudDetalle solDetalle = null;
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getistelematico() != null && solDetalle.getistelematico().equals(Y41bConstantes.SI)) {
				if (solDetalle.getHddenunciaaaccempresas() == null
						|| !solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
					logger.debug("###################INICIO GENERAR TRAMITE COMUNICACION");
					logger.debug("###################tramiteComun.getIdTramite()[" + tramiteComun.getIdTramite() + "]");
					this.generarTramiteComunicacionAutomaticoAsignacionInstructor(tramiteAsignacionInstructor,
							tramiteComun);
					logger.debug("###################FIN GENERAR TRAMITE COMUNICACION");
				}
			}

			if (solDetalle.getTfpcodigo() != null
					&& solDetalle.getTfpcodigo().equals(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO)) {
				if (solDetalle.getHddenunciaaaccempresas() == null
						|| !solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
					logger.debug("###################INICIO GENERAR TRAMITE COMUNICACION");
					logger.debug("###################tramiteComun.getIdTramite()[" + tramiteComun.getIdTramite() + "]");
					this.generarTramiteComunicacionAutomaticoAsignacionInstructor(tramiteAsignacionInstructor,
							tramiteComun);
					logger.debug("###################FIN GENERAR TRAMITE COMUNICACION");
				}
			}
		}

		logger.debug("###################INICIO ACTUALIZAR ULTIMO TRAMITE");
		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(tramitehecho);
		logger.debug("###################FIN ACTUALIZAR ULTIMO TRAMITE");

		logger.debug("###################INICIO TRATAMIENTO BANDEJA");
		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);
		logger.debug("###################FIN TRATAMIENTO BANDEJA");

		logger.debug("###################FIN ASIGNACION INSTRUCTOR");

		return tramitehecho;
	}

	/**
	 * Guardar el tramite requerimientoSubsanacion
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRequerimientoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRequerimientoSubsanacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRequerimientoSubsanacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRequerimientoSubsanacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRequerimientoSubsanacion.getComentario());

		tramitehecho.setEhdocumentacionrequerida(
				Y41bUtils.stringToClob(tramiteRequerimientoSubsanacion.getDocumentacionrequerida()));
		tramitehecho.setEhdocumentacionrequeridae(
				Y41bUtils.stringToClob(tramiteRequerimientoSubsanacion.getDocumentacionrequeridae()));

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRequerimientoSubsanacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRequerimientoSubsanacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRequerimientoSubsanacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho,
						Y41bConstantes.FASE_SUBSANACION, Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION);
			}
		}

		if (tramitar) {
			// Generar notificacion al reclamante
			tramitehecho = this.generarTramiteNotificacionAutomaticoSubsanacion(tramiteRequerimientoSubsanacion,
					tramiteComun);

			// Generar recepcion informacion
			this.generarTramiteRecSubsanacionAutomaticoReqSubsanacion(tramitehecho, tramiteComun);

			// si denuncia empresas y
			// si forma de notificacion es telematica generar tramite de
			// comunicacion automatico
			// y41bBusquedaSolicitudesComboFormaNotificacion Telemtica T
			// hdformanotificacion

			SolicitudDetalle solDetalle = null;
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& solDetalle.getHdformanotificacion() != null && solDetalle.getHdformanotificacion()
							.equalsIgnoreCase(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
				this.generarTramiteComunicacionAutomaticoRequerimientoSubsanacion(tramiteRequerimientoSubsanacion,
						tramiteComun);
			}

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION,
					Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION, tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * guardar
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 *             Exception
	 */
	private void controlDocumentosPendientesFirmaGuardar(TramiteComun tramiteComun, TramiteHecho tramitehecho,
			String fase, String tramite) throws Exception {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar
		// el
		// estado del tramite
		boolean isDocPendienteFirma = false;
		boolean isDocDenegadaFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA.equals(documentoHecho.getQ5estadodocumento())) {
					isDocDenegadaFirma = true;
					break;
				}
			}
		} else {
			// Validacion: Debe haber almenos 1 documento
			// throw new
			// Y41bUDAException("error.solicitud.documentoException",
			// true, new Exception());
		}

		if (isDocDenegadaFirma) {
			// Llamamos a un método que recorrera la lista de
			// documentos
			// del
			// tramite y actualizara la bandeja de firma
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, fase, tramite);
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			this.tramiteHechoDao.updateEstadoTramite(tramitehecho);
		} else if (isDocPendienteFirma) {
			// Llamamos a un método que recorrera la lista de
			// documentos
			// del
			// tramite y actualizara la bandeja de firma
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, fase, tramite);
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			this.tramiteHechoDao.updateEstadoTramite(tramitehecho);
		} else {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			// bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}
	}

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * tramitar
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoProcedimiento
	 *            String
	 * @throws SQLException
	 *             SQLException
	 */
	public void controlDocumentosPendientesFirmaTramitar(TramiteComun tramiteComun, String tipoProcedimiento)
			throws SQLException {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar el
		// estado del tramite
		boolean isDocPendienteFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		} else {
			if (tipoProcedimiento != null && tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				// buscar el tramite de inspecciones
				TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				if (tramiteInspeccion.getTidecodigo() != null && (tramiteInspeccion.getTidecodigo()
						.equals(Y41bConstantes.DECISION_INSPECCIONES_CON_PROPUESTA_DE_SANCION)
						|| tramiteInspeccion.getTidecodigo().equals(Y41bConstantes.DECISION_INSPECCIONES_SIN_INFRACCION)
						|| tramiteInspeccion.getTidecodigo()
								.equals(Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP))) {
					// Propuesta de sancin o sin infraccin no es necesario
					// aportar ningn documento
				} else if (tramiteInspeccion.getTicotee() != null && (tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ENVIAR_MUESTRA_EMPRESA))) {
				} else if (tramiteInspeccion.getTicotee() != null && (tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR))) {
				} else {
					// Validacion: Debe haber almenos 1 documento
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());

				}
			} else {
				if (tipoProcedimiento != null && tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					// buscar el tramite de solicitudes
					TramiteHecho tramiteHecho = new TramiteHecho();
					tramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
					tramiteHecho = this.tramiteHechoDao.find(tramiteHecho);

					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

					SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

					if (tramiteHecho.getEhdecodigo() != null && (tramiteHecho.getEhdecodigo()
							.equals(Y41bConstantes.DECISION_ERROR_DENUNCIA)
							|| tramiteHecho.getEhdecodigo().equals(Y41bConstantes.DECISION_ERROR_QUEJA)
							|| tramiteHecho.getEhdecodigo().equals(Y41bConstantes.DECISION_ERROR_RECLAMACION))) {
						// Decisin error no es necesario
						// aportar ningn documento
					} else if (tramiteHecho.getEhdecodigo() != null
							&& tramiteHecho.getEhdecodigo().equals(Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA)
							&& solDetalle != null && solDetalle.getHddenunciaaaccempresas() != null
							&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
						// Para Registro de decisin de Propuesta de Sancin en
						// Denuncias de empresas
						// Documento opcional
					} else {
						// Validacion: Debe haber almenos 1 documento
						throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());

					}
				} else {
					// Validacion: Debe haber almenos 1 documento
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
		}

		if (isDocPendienteFirma) {
			// No se puede tramitar el tramite si tiene algun documento
			// pendiente de firma
			throw new Y41bUDAException("error.documentos.nofirmados", true, null);
		} else {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			bandejaFirma.setPcodigo(tipoProcedimiento);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}
	}

	/**
	 * Metodo que comprueba que todos los documentos se encuentren todos
	 * firmados al tramitar
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoProcedimiento
	 *            String
	 * @throws SQLException
	 *             SQLException
	 */
	public void controlDocumentosPendientesFirmaSIRTramitar(TramiteComun tramiteComun, String tipoProcedimiento)
			throws SQLException {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar el
		// estado del tramite
		boolean isDocPendienteFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (!Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		} else {
			// Validacion: Debe haber almenos 1 documento
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (isDocPendienteFirma) {
			// No se puede tramitar el tramite si tiene algun documento
			// pendiente de firma
			throw new Y41bUDAException("error.documentos.nofirmados", true, null);
		}
	}

	/**
	 * Metodo que controla que los documentos sean PDF
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 *             Exception
	 */
	private void controlDocumentosPDFSIRTramitar(List<Adjuntardocs> listadjuntardocs) throws Exception {

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocsAux)) {

					if (!StringUtils.isBlank(adjuntardocsAux.getThiddocumentum())) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
						Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

						if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
							if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					} else {
						throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
					}

				} else {
					if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
							&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
									.equalsIgnoreCase(Y41bConstantes.PDF)) {
						throw new Y41bUDAException("error.adjuntardocstramite.pdfException", true, new Exception());
					}
				}
			}
		}
	}

	/**
	 * Guardar el tramite registro decision
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar, CensoMonitor censoMonitor)
			throws Exception {

		if (Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION
						.equals(tramiteRegistroDecision.getTipoDecision())) {
			// Obtener el numero de expediente
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHdfehd() == null) {
				throw new Y41bUDAException("error.tramitedecision.propsancionsinfechahecho", true, null);
			}

			// validacion infracciones una infraccion por materia y por articulo
			if (this.infraccHechoDenDao.findAllMateriasSolicitudesCount(tramiteComun.getIdExpediente()) == 0) {
				throw new Y41bUDAException("error.tramitedecision.infraccionmateria", true, null);
			}
			if (this.infraccHechoDenDao.findAllArticulosSolicitudesCount(tramiteComun.getIdExpediente()) == 0) {
				throw new Y41bUDAException("error.tramitedecision.infraccionarticulo", true, null);
			}

			// 0195582

			// if
			// (!censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))
			// {
			// if (!(solDetalle.getHddenunciaaaccempresas() != null
			// &&
			// solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)))
			// {
			//
			// logger.info("#####Parametros
			// this.santramexpService.tieneEmail(establecimiento codigo: "
			// + solDetalle.getEscodigo() + " , establecimiento cif: " +
			// solDetalle.getEsnif()
			// + " , tipoProc: " + Y41bConstantes.TIPO_PROC_SANCIONES);
			//
			// boolean notificacionViaEmail =
			// this.santramexpService.tieneEmail(solDetalle.getEscodigo(),
			// solDetalle.getEsnif(), Y41bConstantes.TIPO_PROC_SANCIONES);
			//
			// if (!notificacionViaEmail) {
			// throw new Y41bUDAException("error.tramitedecision.sinMailAvisos",
			// true, null);
			// }
			//
			// }
			// }

		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REGISTRO_DECISION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRegistroDecision.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRegistroDecision.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRegistroDecision.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRegistroDecision.getComentario());

		tramitehecho.setEhjustificacioninfraccion(
				Y41bUtils.stringToClob(tramiteRegistroDecision.getJustificacionInfraccion()));
		tramitehecho.setEhcoortraspaso(tramiteRegistroDecision.getCodOrgTraslado());

		// Registro decision ini
		tramitehecho.setEhdecodigo(tramiteRegistroDecision.getTipoDecision());
		tramitehecho.setEhfecharesolucion(tramiteRegistroDecision.getFechaDecision());
		// Registro decision fin

		tramitehecho.setEhapercibimientoes(Y41bUtils.stringToClob(tramiteRegistroDecision.getApercibimientoEs()));
		tramitehecho.setEhapercibimientoeu(Y41bUtils.stringToClob(tramiteRegistroDecision.getApercibimientoEu()));

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRegistroDecision.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRegistroDecision.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (tramitar && (Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_DENUNCIA
				.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_QUEJA.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_RECLAMACION
						.equals(tramiteRegistroDecision.getTipoDecision()))) {

			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
			hechodenunciadoAux.setHdinsoma(Y41bConstantes.SOLICITUD_ARBITRAJE);

			// Comprobar si ya existe un arbitraje con esa solicitud como
			// origen.
			Sanexprel sanexprel = new Sanexprel();
			sanexprel.setRlhdcodrel(tramiteComun.getIdExpediente());
			sanexprel.setRlesorig(Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN);

			List<Sanexprel> solicitudConArbitraje = this.sanexprelDao.findAll(sanexprel, null);

			if (solicitudConArbitraje.size() > 0) {
				for (Sanexprel sanexprelAux : solicitudConArbitraje) {
					if (sanexprelAux != null && sanexprelAux.getRlhdcodrel() != null) {

						// Buscamos el codigo del arbitraje para mostrarlo en el
						// error.
						Solarb solarb = new Solarb();
						solarb.setSacohd(sanexprelAux.getExcodigo());

						List<Solarb> solarbs = this.solarbDao.findAll(solarb, null);

						if (solarbs != null && solarbs.size() > 0 && solarbs.get(0) != null) {
							String[] args = { solarbs.get(0).getSacoja() + "-" + solarbs.get(0).getSanror() + "-"
									+ solarbs.get(0).getSanran() };

							String msgError = this.appMessageSource.getMessage("error.solicitud.tieneArbitraje", args,
									LocaleContextHolder.getLocale());

							throw new Y41bUDAException(msgError, true, null);
						}
					}
				}
			}

			// Al grabar esta decisión también se actualizará el
			// indicador de solicitado arbitraje HDINSOMA en la tabla
			// HECDEN.
			this.hechoDenunciadoDao.updateIndicadorArbitraje(hechodenunciadoAux);
			this.tratamientoBandejaPropuestaArbitraje(tramitehecho);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		this.infraccHechoDenDao.removeAllInfraccionesHecho(tramiteComun);

		this.infraccHechoDenDao.addAllInfraccionesHechoAdjuntarInfracciones(tramiteComun);

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRegistroDecision.getAnyadirPlantilla() == null) {

			this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);

				this.tratamientoDecisionTraslado(tramiteRegistroDecision, tramiteComun);

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

				SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				// Para Registro de decisin de Propuesta de Sancin en
				// Denuncias de empresas
				// Documento opcional
				// No generar trmite de notificacin posterior
				if (Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA.equals(tramiteRegistroDecision.getTipoDecision())
						&& solDetalle != null && solDetalle.getHddenunciaaaccempresas() != null
						&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				} else {

					// Generamos tramites de notificacion automaticos
					this.generarTramiteNotificacionAutomaticoRegistroDecision(tramiteRegistroDecision, tramiteComun);
				}

				this.tratamientoCierreDecision(tramiteComun);

				this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);

				HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
				hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
				hechodenunciadoAux.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);

				// Al grabar esta decisión también se actualizará el
				// indicador de solicitado arbitraje HDINSOMA en la tabla
				// HECDEN.
				this.hechoDenunciadoDao.updateIndicadorArbitraje(hechodenunciadoAux);

				// Actualizamos la bandeja de propuestas de sancion (si el tipo
				// decision
				// es una propuesta de sancion)
				if (Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA.equals(tramiteRegistroDecision.getTipoDecision())
						|| Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA.equals(tramiteRegistroDecision.getTipoDecision())
						|| Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION
								.equals(tramiteRegistroDecision.getTipoDecision())) {
					if (!this.existePropuestaSancionOExpedienteSancionador(tramiteComun)) {
						this.tratamientoBandejaPropuestaSancion(tramitehecho);
					}
				}

			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, Y41bConstantes.FASE_RESOLUCION,
						Y41bConstantes.TRAMITE_REGISTRO_DECISION);
			}
		}

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(tramitehecho);
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REGISTRO_DECISION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Esta funcion realiza la modificacion de la decisin del expediente
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void tratamientoModificacionDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun) {
		// Modificamos la decision del hecho
		DecisionHechoDetalle decisionHechoDetalleAux = new DecisionHechoDetalle();
		decisionHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
		decisionHechoDetalleAux = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalleAux);
		DecisionHecho decisionhechoAux = new DecisionHecho();
		decisionhechoAux.setHccodigo(decisionHechoDetalleAux.getHccodigo());
		decisionhechoAux.setHcfede(tramiteRegistroDecision.getFechaDecision());
		Decision decisionAux = new Decision();
		decisionAux.setDecodigo(tramiteRegistroDecision.getTipoDecision());
		decisionhechoAux.setDecision(decisionAux);
		this.decisionHechoDao.updateDecision(decisionhechoAux);
	}

	/**
	 * Esta funcion realiza el tratamiento del cierre en la decisin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void tratamientoCierreDecision(TramiteComun tramiteComun) {
		// Miramos si existe tramite de cierre
		boolean isTramiteCierre = tramiteHechoService.existeTramite(tramiteComun.getIdExpediente(),
				Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		if (isTramiteCierre) {
			// Actualizamos las fechas del tramite de cierre del
			// expediente
			// (fecha inicio y fecha limite)
			tramiteHechoService.updateFechasTramiteCierre(tramiteComun.getIdExpediente());
		} else {
			// JGREY. Comentado por 86471: [Evolutivo Bandejas ] -
			// Trmite de
			// Cierre - Solicitudes

			// Generamos tramite de cierre
			// this.generarTramiteCierreAutomaticoRegistroDecision(
			// tramiteRegistroDecision, tramiteComun);
		}
	}

	/**
	 * Esta funcion realiza el tratamiento de la decisin de traslado
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	public void tratamientoDecisionTraslado(TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun)
			throws Exception {
		if (Y41bConstantes.DECISION_TRASLADO_DENUNCIA.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_TRASLADO_QUEJA.equals(tramiteRegistroDecision.getTipoDecision())
				|| Y41bConstantes.DECISION_TRASLADO_RECLAMACION.equals(tramiteRegistroDecision.getTipoDecision())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramiteRegistroDecision.getCodOrgTraslado());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			// buscar el interviniente interesado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			Intervinientes intervinientesAux = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
					organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null,
					null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
					esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS, intervinientes.getIdExpediente(), null, null, null,
					null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				intervinientesAux.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
				this.intervinientesDao.update(intervinientesAux);
			} else {
				this.intervinientesDao.add(intervinientesAux);
			}

			this.generarTramiteNotificacionOtrosRegistroDecision(tramiteRegistroDecision, tramiteComun,
					intervinientesAux);
		}

	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, DocumentoHecho docHechoPEE, boolean esRemesa,
			boolean reintento) throws Exception {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteComun.getIdTramite());

		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		if (tramitehechoAux.getEhestadotramite() != null
				&& !tramitehechoAux.getEhestadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
			tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ACUSE_RECIBO);

			// Evita problemas con las fechas desde hasta
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
			tramitehecho.setEhfecha(todayWithZeroTime);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			tramitehecho.setEhhora(ehhora);
			tramitehecho.setEhfechainicio(tramiteAcuseRecibo.getFechaInicio());
			tramitehecho.setEhcomoasignado(tramiteAcuseRecibo.getInstructorAsignado().getMocodigo());
			tramitehecho.setEhcomo(tramiteAcuseRecibo.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhtexto(tramiteAcuseRecibo.getComentario());

			// Info de Acuse recibo ini
			tramitehecho.setEhacuserecibo(tramiteAcuseRecibo.getFechaacuse());
			tramitehecho.setEhacusereciborecibido(tramiteAcuseRecibo.getSituacionacuse());
			tramitehecho.setEhfecharegistroentrada(tramiteAcuseRecibo.getFechaentrada());
			tramitehecho.setEhnumregistroentrada(tramiteAcuseRecibo.getNumregistroentrada());
			// Info de Acuse recibo fin

			if (tramitar) {
				tramitehecho.setEhfechafin(tramiteAcuseRecibo.getFechaFin());
				tramitehecho.setEhcomoejecucion(tramiteAcuseRecibo.getInstructorEjecucion().getMocodigo());
				tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			} else {
				tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			}

			if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
				// Se inserta el tramite
				this.tramiteHechoService.addTramiteHecho(tramitehecho);
			} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				this.tramiteHechoService.updateTramiteHecho(tramitehecho);
			}

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			List<DocumentoExpediente> listDocumentoExpediente = null;
			if (esRemesa) {
				if (docHechoPEE != null) {
					this.documentoHechoDao.add(docHechoPEE);

					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
					documentoTramiteHecho.setCodocumento(docHechoPEE.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			} else {
				if (tramiteAcuseRecibo.getAnyadirPlantilla() == null) {
					listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

					this.procesarDocumentosTramite(tramiteComun);
				}
			}

			// Se actualiza el origen de la lista de documentos del tramite
			// dependiendo del destinatario de la notificacion
			this.actualizarOrigenDocsTramiteAcuseRecibo(tramiteComun,
					tramiteAcuseRecibo.getTramiteNotificacion().getDestinatario());

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ACUSE_RECIBO, null, tramiteComun.getIdExpediente());

			// Tratamiento de Bandeja Solicitudes
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
			this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

			if (tramitar) {
				this.tratamientoMisGestionesAcuseRecibo(tramitehecho);
			}

			// Eliminamos los documentos de dokusi
			if (listDocumentoExpediente != null) {
				this.eliminarDocumentosDokusi(listDocumentoExpediente);
			}

			if (reintento) {
				// actualizar el campo del tramite de acuse a EHACUSEREINTENTADO
				// a S
				tramitehecho.setEhacusereintentado(Y41bConstantes.SI);
				this.tramiteHechoDao.updateAcuseReintentado(tramitehecho);

				// generar la notificacin
				tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

				this.generarReintentoTramiteNotificacion(tramitehechoAux.getTramiteHecho().getEhcodigo());
			}

			return tramitehecho;
		} else {

			if (reintento) {
				// actualizar el campo del tramite de acuse a EHACUSEREINTENTADO
				// a S
				tramitehechoAux.setEhacusereintentado(Y41bConstantes.SI);
				this.tramiteHechoDao.updateAcuseReintentado(tramitehechoAux);

				// generar la notificacin
				this.generarReintentoTramiteNotificacion(tramitehechoAux.getTramiteHecho().getEhcodigo());
			}

			return tramitehechoAux;
		}
	}

	/**
	 * Generar Reintento Tramite de Notificacion
	 * 
	 * @param ehcodigo
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void generarReintentoTramiteNotificacion(String ehcodigo) throws Exception {

		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(ehcodigo);

		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		TramiteHecho tramitehechoReintento = new TramiteHecho();

		tramitehechoReintento.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoReintento.setEhcohd(tramitehechoAux.getEhcohd());
		tramitehechoReintento.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehechoReintento.setEhenvrem(tramitehechoAux.getEhenvrem());

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehechoReintento.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehechoReintento.setEhhora(ehhora);
		tramitehechoReintento.setEhfechainicio(todayWithZeroTime);

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdExpediente(tramitehechoAux.getEhcohd());

		tramitehechoReintento.setEhcomoasignado(obtenerResponsableExpediente(tramiteComunAux));
		tramitehechoReintento.setEhcomo(obtenerResponsableExpediente(tramiteComunAux));

		tramitehechoReintento.setEhfechacomunicacion(todayWithZeroTime);

		tramitehechoReintento.setEhiddestinatario(tramitehechoAux.getEhiddestinatario());

		tramitehechoReintento.setEhsede(tramitehechoAux.getEhsede());

		tramitehechoReintento.setEhtiponotificacionplatea(tramitehechoAux.getEhtiponotificacionplatea());

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
		tramitehechoReintento.setTramiteHecho(tramitehechoRel);

		tramitehechoReintento.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		tramitehechoReintento.setEhtextocomunicacion(tramitehechoAux.getEhtextocomunicacion());

		tramitehechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehechoAux);

		tramitehechoReintento.setEhtexto(tramitehechoAux.getEhtexto());

		tramitehechoReintento.setEhautomatico(Y41bConstantes.VALOR_SI);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoReintento);

		// Buscar los documentos del tramite de notificacion
		tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(ehcodigo);
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		// Relaciono tramite - documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehechoReintento.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentoHechoAux.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehechoReintento);

		// Tratamiento de Bandeja Solicitudes
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramitehechoReintento.getEhcohd());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);
	}

	/**
	 * Esta funcion realiza el tratamiento de mis gestiones para el acuse recibo
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	public void tratamientoMisGestionesAcuseRecibo(TramiteHecho tramitehecho) throws Exception {
		TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramitehechoAux.getTramiteHecho().getEhiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {
			// Documentos notificacion
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramitehechoAux.getTramiteHecho().getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
			tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
			if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
					&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

				tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
				tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
				if (tramitehechoAux.getEhcotee() != null
						&& tramitehechoAux.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					this.actualizarMisGestionesRegistroDecisionReclamante(tramitehechoAux);
				} else if (tramitehechoAux.getEhcotee() != null
						&& tramitehechoAux.getEhcotee().equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION)) {
					this.actualizarMisGestionesRequerimientoSubsanacionConsumidor(tramitehechoAux);
				}
			}

			this.actualizarMisGestionesNotificacionReclamante(tramitehecho, listDocumentoHecho);
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

			// Documentos notificacion
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramitehechoAux.getTramiteHecho().getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
			tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
			if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
					&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

				tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
				tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
				if (tramitehechoAux.getEhcotee() != null
						&& tramitehechoAux.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
					this.actualizarMisGestionesRegistroDecisionReclamado(tramitehechoAux);
				}
			}

			this.actualizarMisGestionesNotificacionReclamado(tramitehecho, listDocumentoHecho);
		}

	}

	/**
	 * Guardar la mediacion telefonica
	 * 
	 * @param tramiteMediacionTelefonica
	 *            TramiteMediacionTelefonica
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteMediacionTelefonica(TramiteMediacionTelefonica tramiteMediacionTelefonica,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_MEDIACION_TELEFONICA);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteMediacionTelefonica.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteMediacionTelefonica.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteMediacionTelefonica.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteMediacionTelefonica.getComentario());

		// Info Mediacion Ini
		tramitehecho.setEhfechamediacion(tramiteMediacionTelefonica.getFechamediacion());
		tramitehecho.setEhhoramediacion(tramiteMediacionTelefonica.getHoramediacion());
		tramitehecho.setEhhoramediacioninicio(tramiteMediacionTelefonica.getHoramediacioninicio());
		tramitehecho.setEhhoramediacionfin(tramiteMediacionTelefonica.getHoramediacionfin());

		tramitehecho.setEhtipomediacion(Y41bConstantes.TIPO_MEDIACION_TELEFONICA);
		tramitehecho.setEhresumenmediacion(Y41bUtils.stringToClob(tramiteMediacionTelefonica.getResumenmediacion()));
		tramitehecho
				.setEhintervinientes(Y41bUtils.stringToClob(tramiteMediacionTelefonica.getIntervinientesmediacion()));

		tramitehecho.setEhnrtel1(tramiteMediacionTelefonica.getTelefonosMediacion1());
		tramitehecho.setEhnrtel2(tramiteMediacionTelefonica.getTelefonosMediacion2());
		tramitehecho.setEhnrtel3(tramiteMediacionTelefonica.getTelefonosMediacion3());
		// Info Mediacion Fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteMediacionTelefonica.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteMediacionTelefonica.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteMediacionTelefonica.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_MEDIACION_TELEFONICA, null, tramiteComun.getIdExpediente());

		// Tratamiento de Bandeja Solicitudes
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar la mediacion presencial
	 * 
	 * @param tramiteMediacionPresencial
	 *            TramiteMediacionPresencial
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteMediacionPresencial(TramiteMediacionPresencial tramiteMediacionPresencial,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_MEDIACION_PRESENCIAL);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteMediacionPresencial.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteMediacionPresencial.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteMediacionPresencial.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteMediacionPresencial.getComentario());

		// Info Mediacion Ini
		tramitehecho.setEhfechamediacion(tramiteMediacionPresencial.getFechamediacion());
		tramitehecho.setEhhoramediacion(tramiteMediacionPresencial.getHoramediacion());
		tramitehecho.setEhhoramediacioninicio(tramiteMediacionPresencial.getHoramediacioninicio());
		tramitehecho.setEhhoramediacionfin(tramiteMediacionPresencial.getHoramediacionfin());

		tramitehecho.setEhtipomediacion(Y41bConstantes.TIPO_MEDIACION_PRESENCIAL);
		tramitehecho.setEhresumenmediacion(Y41bUtils.stringToClob(tramiteMediacionPresencial.getResumenmediacion()));
		tramitehecho
				.setEhintervinientes(Y41bUtils.stringToClob(tramiteMediacionPresencial.getIntervinientesmediacion()));
		// Info Mediacion Fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteMediacionPresencial.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteMediacionPresencial.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteMediacionPresencial.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_MEDIACION_PRESENCIAL, null, tramiteComun.getIdExpediente());

		// Tratamiento de Bandeja Solicitudes
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite requerimientoAlegacion
	 * 
	 * @param tramiteRequerimientoAlegacion
	 *            TramiteRequerimientoAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRequerimientoAlegacion(TramiteRequerimientoAlegacion tramiteRequerimientoAlegacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRequerimientoAlegacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRequerimientoAlegacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRequerimientoAlegacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRequerimientoAlegacion.getComentario());

		tramitehecho.setEhorigenalegacion(tramiteRequerimientoAlegacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRequerimientoAlegacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRequerimientoAlegacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRequerimientoAlegacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, Y41bConstantes.FASE_MEDIACION,
						Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
			}
		}

		if (tramitar) {
			// Generar notificacion al reclamado
			this.generarTramiteNotificacionAutomaticoReqAlegacion(tramiteRequerimientoAlegacion, tramiteComun);

			// Generar alegacion
			this.generarTramiteAlegacionAutomaticoReqAlegacion(tramitehecho, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION,
					Y41bConstantes.TRAMITE_ALEGACION, tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite SegundaMediacion
	 * 
	 * @param tramiteSegundaMediacion
	 *            TramiteSegundaMediacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteSegundaMediacion(TramiteSegundaMediacion tramiteSegundaMediacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteSegundaMediacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteSegundaMediacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteSegundaMediacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteSegundaMediacion.getComentario());

		tramitehecho.setEhorigenalegacion(tramiteSegundaMediacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteSegundaMediacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteSegundaMediacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteSegundaMediacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, Y41bConstantes.FASE_MEDIACION,
						Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION);
			}
		}

		if (tramitar) {
			// Generar notificacion al reclamado
			this.generarTramiteNotificacionAutomaticoSegundaMediacion(tramiteSegundaMediacion, tramiteComun);

			// Generar respuesta segunda mediacion
			this.generarTramiteRespuestaSegundaMediacionAutomaticoSegundaMediacion(tramitehecho, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION,
					Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION, tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite requerimientoInformacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRequerimientoInformacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRequerimientoInformacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRequerimientoInformacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRequerimientoInformacion.getComentario());

		tramitehecho.setEhorigenalegacion(tramiteRequerimientoInformacion.getOrigen());

		tramitehecho.setEhdocumentacionrequerida(
				Y41bUtils.stringToClob(tramiteRequerimientoInformacion.getDocumentacionrequerida()));
		tramitehecho.setEhdocumentacionrequeridae(
				Y41bUtils.stringToClob(tramiteRequerimientoInformacion.getDocumentacionrequeridae()));

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRequerimientoInformacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRequerimientoInformacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRequerimientoInformacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho,
						Y41bConstantes.FASE_REQUERIMIENTO, Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION);
			}
		}

		if (tramitar) {
			// Generar notificacion al reclamado
			this.generarTramiteNotificacionAutomaticoReqInformacion(tramiteRequerimientoInformacion, tramiteComun);

			// Generar recepcion informacion
			this.generarTramiteRecInformacionAutomaticoReqInformacion(tramitehecho, tramiteComun);

			////////// 0185983
			// si denuncia empresas y
			// si forma de notificacion es telematica generar tramite de
			// comunicacion automatico
			// y41bBusquedaSolicitudesComboFormaNotificacion Telemtica T
			// reclamado

			SolicitudDetalle solDetalle = null;
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& solDetalle.getHdformanotificacionestablecimiento() != null
					&& solDetalle.getHdformanotificacionestablecimiento()
							.equalsIgnoreCase(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
				this.generarTramiteComunicacionAutomaticoRequerimientoInformacion(tramiteRequerimientoInformacion,
						tramiteComun);
			}
			/////////

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION,
					Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION, tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Respuesta Ampliacion Plazo
	 * 
	 * @param tramiteRespuestaAmpliacionPlazo
	 *            TramiteRespuestaAmpliacionPlazo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRespuestaAmpliacionPlazo(
			TramiteRespuestaAmpliacionPlazo tramiteRespuestaAmpliacionPlazo, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRespuestaAmpliacionPlazo.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRespuestaAmpliacionPlazo.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRespuestaAmpliacionPlazo.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRespuestaAmpliacionPlazo.getComentario());

		tramitehecho.setEhfechasolampliacionplazo(tramiteRespuestaAmpliacionPlazo.getFechasolampliacionplazo());
		tramitehecho.setEhaceptacionplazo(tramiteRespuestaAmpliacionPlazo.getAceptacionplazo());
		// tramitehecho.setEhplazoconcedido(tramiteRespuestaAmpliacionPlazo.getPlazoconcedido());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRespuestaAmpliacionPlazo.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRespuestaAmpliacionPlazo.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRespuestaAmpliacionPlazo.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				// Llamamos a un metodo que recorrera la lista de documentos
				// del
				// tramite y actualizara la bandeja de firma
				// En este caso, al ser un tramite generico le metemos la
				// fase
				// del
				// expediente
				SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
				solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
				solicitudDetalleAux = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);
				String faseExp = solicitudDetalleAux.getFcodigo();

				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, faseExp,
						Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO);
			}
		}

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO, null,
					tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite BOPVAyto
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_BOPV_AYTO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteBOPVAyto.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteBOPVAyto.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteBOPVAyto.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteBOPVAyto.getComentario());

		tramitehecho.setEhfechapublicacionbopv(tramiteBOPVAyto.getFechaPublicacionBOPV());
		tramitehecho.setEhfechapublicacionayto(tramiteBOPVAyto.getFechaPublicacionAyto());
		tramitehecho.setEhfechaEnvioBOPVBOE(tramiteBOPVAyto.getFechaEnvioBOPVBOE());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteBOPVAyto.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteBOPVAyto.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteBOPVAyto.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				// Llamamos a un metodo que recorrera la lista de documentos
				// del
				// tramite y actualizara la bandeja de firma
				// En este caso, al ser un tramite generico le metemos la
				// fase
				// del
				// expediente
				SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
				solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
				solicitudDetalleAux = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);
				String faseExp = solicitudDetalleAux.getFcodigo();

				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, faseExp,
						Y41bConstantes.TRAMITE_BOPV_AYTO);
			}
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_BOPV_AYTO, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Recepcion Recurso
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionRecurso.getIdTramite());
		tramitehecho.setEhcohd(tramiteRecepcionRecurso.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_RECURSO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionRecurso.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionRecurso.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionRecurso.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionRecurso.getComentario());

		// Info recepcion recurso ini
		tramitehecho.setEhtiporecurso(tramiteRecepcionRecurso.getTiporecurso());
		tramitehecho.setEhfecharecurso(tramiteRecepcionRecurso.getFecharecurso());
		tramitehecho.setEhabogado(tramiteRecepcionRecurso.getAbogado());
		tramitehecho.setEhmotivorecurso(Y41bUtils.stringToClob(tramiteRecepcionRecurso.getMotivorecurso()));
		// Info recepcion recurso fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRecepcionRecurso.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRecepcionRecurso.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			this.generarTramiteInformeAsesoriaAutomatico(tramitehecho);

			// Miramos si existe tramite de cierre
			boolean isTramiteCierre = tramiteHechoService.existeTramite(tramiteRecepcionRecurso.getIdExpediente(),
					Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);

			if (isTramiteCierre) {
				// Actualizamos la fecha limite del tramite de cierre a null
				this.tramiteHechoService.updateFechaLimiteTramiteCierre(tramiteRecepcionRecurso.getIdExpediente());
			}

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_RECURSO,
					Y41bConstantes.TRAMITE_ELABORACION_INFORME_ASESORIA, tramiteRecepcionRecurso.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_RECURSO, null,
					tramiteRecepcionRecurso.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteRecepcionRecurso.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Elaboracion BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteElaboracionBOPVAyto.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteElaboracionBOPVAyto.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteElaboracionBOPVAyto.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteElaboracionBOPVAyto.getComentario());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteElaboracionBOPVAyto.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteElaboracionBOPVAyto.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteElaboracionBOPVAyto.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			this.generarTramiteBOPV_AYTO(tramiteElaboracionBOPVAyto, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA,
					Y41bConstantes.TRAMITE_BOPV_AYTO, tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite RecepcionOrdenConsejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionOrdenConsejero(TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionOrdenConsejero.getIdTramite());
		tramitehecho.setEhcohd(tramiteRecepcionOrdenConsejero.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionOrdenConsejero.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionOrdenConsejero.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionOrdenConsejero.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionOrdenConsejero.getComentario());

		// Info recepcion orden consejero ini
		tramitehecho.setEhestimacion(tramiteRecepcionOrdenConsejero.getEstimacion());
		// Info recepcion orden consejero fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRecepcionOrdenConsejero.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRecepcionOrdenConsejero.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Generar notificacion al reclamante
			tramitehecho = this.generarTramiteNotificacionAutomaticoOrdenConsejero(tramiteRecepcionOrdenConsejero,
					tramiteComun);

			// Miramos si existe tramite de cierre
			boolean isTramiteCierre = tramiteHechoService.existeTramite(
					tramiteRecepcionOrdenConsejero.getIdExpediente(), Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);

			if (Y41bConstantes.SI.equals(tramiteRecepcionOrdenConsejero.getEstimacion())) {
				// Genero el tramite de asignacion de instructor
				this.generarTramiteAsignacionInstructorAutomaticoRecepcConsejero(tramiteRecepcionOrdenConsejero);

				if (isTramiteCierre) {
					BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
					bandejasolicitudes.setHdcodigo(tramitehecho.getEhcohd());

					this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);

					this.tramiteHechoDao.removeTramiteCierreSinTramitarExpediente(tramitehecho);
				}

				// Actualizar ultimo tramite
				this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO,
						Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR, tramiteRecepcionOrdenConsejero.getIdExpediente());

			} else {
				if (isTramiteCierre) {
					// Actualizamos las fechas del tramite de cierre del
					// expediente
					tramiteHechoService.updateFechasTramiteCierre(tramiteRecepcionOrdenConsejero.getIdExpediente());
					// Actualizar ultimo tramite
					this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO,
							Y41bConstantes.TRAMITE_NOTIFICACION, tramiteRecepcionOrdenConsejero.getIdExpediente());
				} else {
					// JGREY. Comentado por 86471: [Evolutivo Bandejas ] -
					// Trmite
					// de
					// Cierre - Solicitudes
					// actualizarUltimoTramite: tambien se actualiza con el null

					// Generamos tramite de cierre
					// this.generarTramiteCierreAutomaticoRecepcConsejero(tramiteRecepcionOrdenConsejero);

					// Actualizar ultimo tramite
					this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO, null,
							tramiteRecepcionOrdenConsejero.getIdExpediente());
				}
			}
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO, null,
					tramiteRecepcionOrdenConsejero.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteRecepcionOrdenConsejero.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite cierre
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteCierre.getIdTramite());
		tramitehecho.setEhcohd(tramiteCierre.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteCierre.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteCierre.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteCierre.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteCierre.getComentario());

		tramitehecho.setEhfechacierre(tramiteCierre.getFechaCierre());

		tramitehecho.setEhexcluircierre(tramiteCierre.getExcluirCierre());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteCierre.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteCierre.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// 2.1 Se comprueba que no haya ningún trámite de cierre
		boolean isTramiteCierre = tramiteHechoService.existenMasTramites(tramiteCierre.getIdExpediente(),
				tramiteCierre.getIdTramite(), Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		if (isTramiteCierre) {
			throw new Y41bUDAException("error.tramiteCierre.existeCierre", true, null);
		}

		if (tramitar) {
			// buscar el tramite de decision
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(tramiteCierre.getIdExpediente());

			Long tramiteRegistroDecisionTramitado = this.tramiteHechoDao
					.findAllTramiteRegistroDecisionTramitadoCount(tramiteHechoDetalle);

			if (tramiteRegistroDecisionTramitado == 0) {
				throw new Y41bUDAException("error.tramiteDecision.sinTramitar", true, null);
			}

			// 3. Actualizar en tabla de exp el ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE, null,
					tramiteCierre.getIdExpediente());
		} else {
			// Caso especial en el tratamiento del ultimo tramite del expediente
			this.actualizarUltimoTramiteCierreGuardar(tramiteCierre.getIdExpediente());
		}

		if (tramitar) {
			// 4. Cerramos el expediente en PLATEA
			// Obtengo la información del expediente
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteCierre.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
					.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
					.append(solDetalle.getHdnror());

			this.hechoDenunciadoDao.updateFechaCierre(solicitudDetalle);

			CierreExpediente cierreExpediente = new CierreExpediente();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			cierreExpediente.setProcedure(procedure);
			cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
			cierreExpediente.setEjercicio(solDetalle.getDenran().toString());

			y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteCierre.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite alegacion
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteAlegacion(TramiteAlegacion tramiteAlegacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ALEGACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteAlegacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteAlegacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteAlegacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteAlegacion.getComentario());

		tramitehecho.setEhresumenalegacion(Y41bUtils.stringToClob(tramiteAlegacion.getResumenAlegaciones()));
		tramitehecho.setEhrespuesta(tramiteAlegacion.getRespuesta());
		tramitehecho.setEhorigenalegacion(tramiteAlegacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteAlegacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteAlegacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun, tramiteAlegacion.getOrigen());

		if (tramitar) {

			SolicitudDetalle solDetalle = null;
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHddenunciaaaccempresas() == null
					|| !solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				// Generar comunicacion al reclamante
				this.generarTramiteComunicacionAutomaticoAlegacion(tramiteAlegacion, tramiteComun);

				// Actualizar ultimo tramite
				this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ALEGACION, Y41bConstantes.TRAMITE_COMUNICACION,
						tramiteComun.getIdExpediente());
			} else {
				// Actualizar ultimo tramite
				this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ALEGACION, null, tramiteComun.getIdExpediente());
			}

			boolean existeSegundaMediacion = this.existeSegundaMediacion(tramiteComun);

			if (!existeSegundaMediacion) {
				if (Y41bConstantes.RESPUESTA_ALEGACION_NO_ACEPTA.equals(tramiteAlegacion.getRespuesta())
						|| Y41bConstantes.RESPUESTA_ALEGACION_NO_RESPONDE.equals(tramiteAlegacion.getRespuesta())) {
					if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteAlegacion.getOrigen())) {
						this.generarTramiteSegundaMediacion(tramitehecho, tramiteComun);

						// actualizar el ultimo tramite realizado
						this.actualizarUltimoTramite(tramitehecho);
					}
				}
			}

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ALEGACION, null, tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite RespuestaSegundaMediacion
	 * 
	 * @param tramiteRespuestaSegundaMediacion
	 *            TramiteRespuestaSegundaMediacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRespuestaSegundaMediacion(
			TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRespuestaSegundaMediacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRespuestaSegundaMediacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRespuestaSegundaMediacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRespuestaSegundaMediacion.getComentario());

		tramitehecho.setEhresumenalegacion(
				Y41bUtils.stringToClob(tramiteRespuestaSegundaMediacion.getResumenAlegaciones()));
		tramitehecho.setEhrespuesta(tramiteRespuestaSegundaMediacion.getRespuesta());
		tramitehecho.setEhorigenalegacion(tramiteRespuestaSegundaMediacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRespuestaSegundaMediacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRespuestaSegundaMediacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun, tramiteRespuestaSegundaMediacion.getOrigen());

		if (tramitar) {

			SolicitudDetalle solDetalle = null;
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHddenunciaaaccempresas() == null
					|| !solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				// Generar comunicacion al reclamante
				this.generarTramiteComunicacionAutomaticoRespuestaSegundaMediacion(tramiteRespuestaSegundaMediacion,
						tramiteComun);

				// Actualizar ultimo tramite
				this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION,
						Y41bConstantes.TRAMITE_COMUNICACION, tramiteComun.getIdExpediente());
			} else {
				// Actualizar ultimo tramite
				this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION, null,
						tramiteComun.getIdExpediente());
			}
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Informacion
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionRequerimientoInformacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionRequerimientoInformacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionRequerimientoInformacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionRequerimientoInformacion.getComentario());

		tramitehecho.setEhresumenalegacion(
				Y41bUtils.stringToClob(tramiteRecepcionRequerimientoInformacion.getResumenAlegaciones()));
		tramitehecho.setEhrespuesta(tramiteRecepcionRequerimientoInformacion.getRespuesta());
		tramitehecho.setEhorigenalegacion(tramiteRecepcionRequerimientoInformacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRecepcionRequerimientoInformacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(
					tramiteRecepcionRequerimientoInformacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun, tramiteRecepcionRequerimientoInformacion.getOrigen());

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION,
					Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION, tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(
				tramiteRecepcionRequerimientoAcreditacionRepresentacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(
				tramiteRecepcionRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getComentario());

		tramitehecho.setEhresumenalegacion(Y41bUtils
				.stringToClob(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getResumenAlegaciones()));
		tramitehecho.setEhrespuesta(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta());
		tramitehecho.setEhorigenalegacion(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen());

		if (tramitar) {

			// Si la respuesta es 'Valido', se busca un representante de origen
			// no valido y se le pone a 'Valido'. Si no encuentra representante,
			// se devuelve un mensaje de error.
			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO
					.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta())) {
				Intervinientes interviniente = new Intervinientes();
				interviniente.setIdExpediente(tramitehecho.getEhcohd());

				Intervinientes intervinienteAux = new Intervinientes();
				intervinienteAux.setIdExpediente(tramitehecho.getEhcohd());

				if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					// 0183585: Acreditacin de representacin
					intervinienteAux
							.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
					intervinienteAux = this.intervinientesDao.findIntervinienteTipo(intervinienteAux);

					if (intervinienteAux != null) {
					} else {

						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
						interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

						if (interviniente == null) {
							throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamante",
									true, new Exception());
						}

						interviniente
								.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
					}

				} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					// 0183585: Acreditacin de representacin
					intervinienteAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
					intervinienteAux = this.intervinientesDao.findIntervinienteTipo(intervinienteAux);

					if (intervinienteAux != null) {
					} else {
						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
						interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

						if (interviniente == null) {
							throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamado",
									true, new Exception());
						}

						interviniente
								.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
					}

				}

				this.intervinientesDao.updateTipoInterviniente(interviniente);
			}

			// En otro orden de cosas...
			tramitehecho.setEhfechafin(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(
					tramiteRecepcionRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun,
				tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen());

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION,
					Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION, tramiteComun.getIdExpediente());

			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO
					.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta())) {
				tramiteComunAux = new TramiteComun();
				tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());

				if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
					tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

					tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
					try {
						tramiteHechoDetalle = this.tramiteHechoDao
								.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
					} catch (Exception e) {
					}

					// si est el tramite de registro de solicitud tramitado
					if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
						this.actualizarParticipacionReclamante(tramiteComunAux);
					}

				} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

					SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

					if (solDetalle.getHdparticipacionreclamado() != null
							&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
						this.actualizarParticipacionReclamado(tramiteComunAux);
					}
				}
			}
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Subsanacion
	 * 
	 * @param tramiteRecepcionRequerimientoSubsanacion
	 *            TramiteRecepcionRequerimientoSubsanacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionRequerimientoSubsanacion(
			TramiteRecepcionRequerimientoSubsanacion tramiteRecepcionRequerimientoSubsanacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionRequerimientoSubsanacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionRequerimientoSubsanacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionRequerimientoSubsanacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionRequerimientoSubsanacion.getComentario());

		tramitehecho.setEhresumenalegacion(
				Y41bUtils.stringToClob(tramiteRecepcionRequerimientoSubsanacion.getResumenAlegaciones()));
		tramitehecho.setEhrespuesta(tramiteRecepcionRequerimientoSubsanacion.getRespuesta());
		tramitehecho.setEhorigenalegacion(tramiteRecepcionRequerimientoSubsanacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRecepcionRequerimientoSubsanacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(
					tramiteRecepcionRequerimientoSubsanacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun, tramiteRecepcionRequerimientoSubsanacion.getOrigen());

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION,
					Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION, tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite Informe Asesoria
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ELABORACION_INFORME_ASESORIA);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteInformeAsesoria.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteInformeAsesoria.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteInformeAsesoria.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteInformeAsesoria.getComentario());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteInformeAsesoria.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteInformeAsesoria.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteInformeAsesoria.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			this.generarTramiteComunicacionAutomaticoInformeAsesoria(tramiteInformeAsesoria, tramiteComun);

			this.generarTramiteRecepcionOrdenConsejeroAutomatico(tramitehecho, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ELABORACION_INFORME_ASESORIA,
					Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO, tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ELABORACION_INFORME_ASESORIA, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite conciliacion entre partes
	 * 
	 * @param tramiteConciliacionEntrePartes
	 *            TramiteConciliacionEntrePartes
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteConciliacionEntrePartes(TramiteConciliacionEntrePartes tramiteConciliacionEntrePartes,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_CONCILIACION_ENTRE_PARTES);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteConciliacionEntrePartes.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteConciliacionEntrePartes.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteConciliacionEntrePartes.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteConciliacionEntrePartes.getComentario());

		tramitehecho.setEhfechaenvioconvocatoria(tramiteConciliacionEntrePartes.getFechaEnvioConvocatoria());
		tramitehecho.setEhfechaconciliacion(tramiteConciliacionEntrePartes.getFechaActoConciliacion());
		tramitehecho.setEhfechafirmaacuerdo(tramiteConciliacionEntrePartes.getFechaFirmaAcuerdo());
		tramitehecho.setEhtextoacuerdo(Y41bUtils.stringToClob(tramiteConciliacionEntrePartes.getTextoAcuerdo()));
		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteConciliacionEntrePartes.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteConciliacionEntrePartes.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteConciliacionEntrePartes.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_CONCILIACION_ENTRE_PARTES, null,
				tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar tramite solicitud inspeccion
	 * 
	 * @param tramiteSolicitudInspeccion
	 *            TramiteSolicitudInspeccion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteSolicitudInspeccion(TramiteSolicitudInspeccion tramiteSolicitudInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_SOLICITUD_INSPECCION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteSolicitudInspeccion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteSolicitudInspeccion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteSolicitudInspeccion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteSolicitudInspeccion.getComentario());

		tramitehecho.setEhplazoinspeccion(tramiteSolicitudInspeccion.getPlazoRealizacion());
		tramitehecho.setIncodigo(tramiteSolicitudInspeccion.getInspector());

		tramitehecho.setEhinstrucinspecc(Y41bUtils.stringToClob(tramiteSolicitudInspeccion.getInstrucciones()));

		tramitehecho.setEhcoorinspeccion(tramiteSolicitudInspeccion.getCoorinspeccion());

		if (tramitar) {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				this.inspeccionesPropBandejaService.generarPropuestaInspeccion(solicitudDetalle, tramitehecho);
			}

			tramitehecho.setEhfechafin(tramiteSolicitudInspeccion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteSolicitudInspeccion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_SOLICITUD_INSPECCION, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Guardar el tramite traslado red ciac
	 * 
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteTrasladoRedCiac(TramiteTrasladoRedCiac tramiteTrasladoRedCiac,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_TRASLADO_RED_CIAC);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteTrasladoRedCiac.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteTrasladoRedCiac.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteTrasladoRedCiac.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteTrasladoRedCiac.getComentario());

		tramitehecho.setEhcoortraspaso(tramiteTrasladoRedCiac.getCodOrgTraslado());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteTrasladoRedCiac.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteTrasladoRedCiac.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteTrasladoRedCiac.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			// Verificamos que los documentos adjuntados esten correctos - Ini
			boolean isReclamanteAdjuntado = false;
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (Y41bUtils.isFilled(documentoHecho.getQ5destino())) {
						if (Y41bConstantes.DESTINO_TRASLADOCIAC_RECLAMANTE.equals(documentoHecho.getQ5destino())) {
							isReclamanteAdjuntado = true;
						}
					}
				}
			} else {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			if (!isReclamanteAdjuntado) {
				// No se puede tramitar el tramite si no ha adjuntado almenos 1
				// documento para el reclamante y otro para el reclamado
				throw new Y41bUDAException("error.documentos.trasladociac.reclamanteoblig", true, null);
			}
			// Verificamos que los documentos adjuntados esten correctos - Fin

			this.tratamientoTrasladoRedCiac(tramiteTrasladoRedCiac, tramiteComun, tramitehecho);

			// Generar comunicacion al interesado
			this.generarTramiteComunicacionAutomaticoTrasladoRedCiac(tramitehecho, tramiteTrasladoRedCiac);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_TRASLADO_RED_CIAC, Y41bConstantes.TRAMITE_COMUNICACION,
					tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_TRASLADO_RED_CIAC, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Esta funcion realiza el tratamiento del traslado del expediente a la Red
	 * Ciac
	 * 
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	public void tratamientoTrasladoRedCiac(TramiteTrasladoRedCiac tramiteTrasladoRedCiac, TramiteComun tramiteComun,
			TramiteHecho tramitehecho) throws Exception {
		// Algoritmo para envio Traslado a KONTSUMONET - Ini
		// Insertar traslado para KONTSUMONET
		// Update de HCCOOR con el codigo de organismo al que se
		// traslada la solicitud de la tabla L2125T00 DECISION HECHO
		DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
		decisionHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

		String codOrganismoOrigen = decisionHechoDetalle.getHccoor();

		// Se modifica el organismo propietario del expediente
		DecisionHecho decisionHecho = new DecisionHecho();
		decisionHecho.setHccoor(tramiteTrasladoRedCiac.getCodOrgTraslado());
		decisionHecho.setHccodigo(decisionHechoDetalle.getHccodigo());
		this.decisionHechoDao.updateOrganismoTraslado(decisionHecho);

		// Se aade el nuevo interviniente gestor del expediente
		Organismo organismo = new Organismo();
		organismo.setCodOrg(tramiteTrasladoRedCiac.getCodOrgTraslado());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		// buscar el interviniente interesado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION);

		Intervinientes intervinientesAux = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null, organismo.getEntidadId(),
				organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null, null, null,
				organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
				organismo.getNoraProvinciaId(), organismo.getNombreProvincia(), organismo.getNoraMunicipioId(),
				organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
				organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
				organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
				organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
				organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null, null,
				null);

		this.intervinientesDao.add(intervinientesAux);

		// Se vacia el intructor del expediente
		HechoDenunciado hechodenunciado = new HechoDenunciado();
		hechodenunciado.setHdcodigo(tramiteComun.getIdExpediente());
		CensoMonitor censoMonitor = new CensoMonitor();
		hechodenunciado.setCensoMonitor(censoMonitor);
		this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

		// Se graba un registro en TRASLADO
		Traslado traslado = new Traslado();
		traslado.setIhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		traslado.setIhcoortr(codOrganismoOrigen);
		traslado.setIhnrantr(new BigDecimal(Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_ANYO)));

		if (organismo.getIskontsumonet().equals(Y41bConstantes.VALOR_SI)) {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_TRASLADO);
		} else {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_COMUNICACION);
		}

		StringBuffer textoTraslado = new StringBuffer();
		// Si el texto es mayor de 255 lo truncamos
		if (tramitehecho.getEhtexto() != null
				&& tramitehecho.getEhtexto().length() > Y41bConstantes.MAXLENGTH_OBJECT_NAME) {
			textoTraslado.append(tramitehecho.getEhtexto().subSequence(Y41bConstantes.MINLENGTH_OBJECT_NAME,
					Y41bConstantes.MAXLENGTH_OBJECT_NAME));
		} else {
			textoTraslado.append(tramitehecho.getEhtexto());
		}
		traslado.setIhtedoad(textoTraslado.toString());
		traslado.setIhfereor(tramitehecho.getEhfecha());
		traslado.setIhcooror(codOrganismoOrigen); // cod org de la denuncia
		traslado.setIhcoordt(tramiteTrasladoRedCiac.getCodOrgTraslado());

		DecisionHecho decisiontraslado = new DecisionHecho();
		decisiontraslado.setHccodigo(decisionHechoDetalle.getHccodigo());
		traslado.setDecisionHecho(decisiontraslado); // codigo de la
														// decision

		// Codigo del tramite hecho
		traslado.setIhcoeh(tramitehecho.getEhcodigo());

		// // JAVI 09/01
		// String texto = Y41bUtils
		// .clobToString(tramitehecho.getEhmotivorechazo());
		// if (texto.length() > 255) {
		// texto = Y41bUtils.clobToString(tramitehecho.getEhmotivorechazo())
		// .substring(0, 255);
		// }
		// traslado.setIhtedoad(texto);

		// alta traslado
		this.trasladoDao.addTraslado(traslado);
		// Algoritmo para envio Traslado a KONTSUMONET - Fin
	}

	/**
	 * Guardar tramite recepcion traslado
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionTraslado(TramiteRecepcionTraslado tramiteRecepcionTraslado,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionTraslado.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionTraslado.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionTraslado.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionTraslado.getComentario());

		tramitehecho.setEhrespuestatraspaso(tramiteRecepcionTraslado.getRespuesta());

		tramitehecho.setEhmotivorechazo(Y41bUtils.stringToClob(tramiteRecepcionTraslado.getMotivoRechazo()));

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRecepcionTraslado.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRecepcionTraslado.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		if (tramitar) {
			DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
			decisionHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

			// Buscar el traslado
			TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda();
			trasladoBusqueda.setIhcoordt(decisionHechoDetalle.getHccoor());
			trasladoBusqueda.setHdcodigo(tramiteComun.getIdExpediente());
			trasladoBusqueda.setSinRecepcionarDestino(Y41bConstantes.SI);

			List<TrasladoBusqueda> traslados = this.trasladoDao.findAllTraslado(trasladoBusqueda, null);

			// Recepcionar traslado
			if (traslados != null && traslados.size() > 0) {
				trasladoBusqueda = new TrasladoBusqueda();
				trasladoBusqueda.setIhcodigo(traslados.get(0).getIhcodigo());
				trasladoBusqueda.setIhfereen(todayWithZeroTime);
				this.trasladoDao.updateTraslado(trasladoBusqueda);
			}

			if (tramiteRecepcionTraslado.getRespuesta() != null
					&& tramiteRecepcionTraslado.getRespuesta().equals(Y41bConstantes.RESPUESTA_TRASLADO_ACEPTADO)) {
				this.tratamientoRecepcionarTrasladoAceptado(tramiteRecepcionTraslado, tramiteComun, traslados);
			} else if (tramiteRecepcionTraslado.getRespuesta() != null
					&& tramiteRecepcionTraslado.getRespuesta().equals(Y41bConstantes.RESPUESTA_TRASLADO_DENEGADO)) {
				this.tratamientoRecepcionarTrasladoDenegado(tramitehecho, tramiteRecepcionTraslado, tramiteComun,
						traslados);
			}
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Esta funcion realiza el tratamiento de la aceptacin de la recepcin del
	 * traslado
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	public void tratamientoRecepcionarTrasladoAceptado(TramiteRecepcionTraslado tramiteRecepcionTraslado,
			TramiteComun tramiteComun, List<TrasladoBusqueda> traslados) throws Exception {
		// actualizar el monitor del expediente
		HechoDenunciado hechodenunciado = new HechoDenunciado();
		hechodenunciado.setHdcodigo(tramiteComun.getIdExpediente());
		hechodenunciado.setCensoMonitor(tramiteRecepcionTraslado.getInstructorEjecucion());
		this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

		// update forma de notificacion a ordinaria
		hechodenunciado.setHdformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
		this.hechoDenunciadoDao.updateFormaNotificacion(hechodenunciado);

		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux = this.hechoDenunciadoDao.find(hechodenunciado);

		if (hechodenunciadoAux.getHdidioma() != null
				&& hechodenunciadoAux.getHdidioma().equalsIgnoreCase(Y41bConstantes.CASTELLANO)) {
			hechodenunciado.setHdidioma(Y41bConstantes.CASTELLANO);
		} else if (hechodenunciadoAux.getHdidioma() != null
				&& hechodenunciadoAux.getHdidioma().equalsIgnoreCase(Y41bConstantes.EUSKERA)) {
			hechodenunciado.setHdidioma(Y41bConstantes.EUSKERA);
		} else {
			hechodenunciado.setHdidioma(Y41bConstantes.CASTELLANO);
		}

		// actualizar el idioma del reclamante a castellano
		// hechodenunciado.setHdidioma(Y41bConstantes.CASTELLANO);
		this.hechoDenunciadoDao.updateIdiomaReclamante(hechodenunciado);

		// actualizar el idioma del reclamado a castellano
		hechodenunciado.setHdidiomareclamado(Y41bConstantes.CASTELLANO);
		this.hechoDenunciadoDao.updateIdiomaReclamado(hechodenunciado);

		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		Intervinientes intervinientesAux = this.tratamientoAadirIntervinienteInteresado(solDetalle, tramiteComun);

		this.tratamientoAadirIntervinienteDemandado(solDetalle, tramiteComun);

		this.tratamientoAadirIntervinienteAdministracion(tramiteRecepcionTraslado, tramiteComun);

		this.tratamientoAperturaPresenciaRecepcionTraslado(solDetalle, intervinientesAux);

		// Creacion de tramite de asignacion de instructor tramitado
		this.generarTramiteAsignacionInstructorAutomatico(solicitudDetalle);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD,
				Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR, tramiteComun.getIdExpediente());

		this.tratamientoEnviarcomunicacionRecepcionTraslado(solDetalle, tramiteRecepcionTraslado, traslados);
	}

	/**
	 * Esta funcion realiza el tratamiento de la denegacin de la recepcin del
	 * traslado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            TramiteComun
	 * @param traslados
	 *            List<TrasladoBusqueda>
	 * @throws Exception
	 */
	public void tratamientoRecepcionarTrasladoDenegado(TramiteHecho tramitehecho,
			TramiteRecepcionTraslado tramiteRecepcionTraslado, TramiteComun tramiteComun,
			List<TrasladoBusqueda> traslados) throws Exception {
		// Insertar traslado para KONTSUMONET
		// Update de HCCOOR con el codigo de organismo al que se
		// traslada la solicitud de la tabla L2125T00 DECISION HECHO
		DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
		decisionHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

		String codOrganismoOrigen = decisionHechoDetalle.getHccoor();

		DecisionHecho decisionHecho = new DecisionHecho();
		decisionHecho.setHccoor(traslados.get(0).getIhcooror());
		decisionHecho.setHccodigo(decisionHechoDetalle.getHccodigo());

		this.decisionHechoDao.updateOrganismoTraslado(decisionHecho);

		// buscar el ultimo tramite de traslado
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_SOLICITUD_TRASLADO_SOLICITUD);
		try {
			tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
		} catch (Exception e) {
		}

		// actualizar el responsable del expediente
		// Actualizamos el instructor del hecho denunciado
		HechoDenunciado hechodenunciado = new HechoDenunciado();

		CensoMonitor censoMonitorResponsable = new CensoMonitor();

		// Buscar responsable expediente
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcodigo(tramiteHechoDetalle.getEhcodigo());

		tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);

		censoMonitorResponsable.setMocodigo(tramitehechoAux.getEhcomo());
		hechodenunciado.setHdcodigo(tramiteComun.getIdExpediente());
		hechodenunciado.setCensoMonitor(censoMonitorResponsable);

		this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

		Organismo organismo = new Organismo();
		organismo.setCodOrg(traslados.get(0).getIhcooror());

		organismo = this.organismoDao.find(organismo);

		// Se graba un registro en TRASLADO
		Traslado traslado = new Traslado();
		traslado.setIhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		traslado.setIhcoortr(codOrganismoOrigen);
		traslado.setIhnrantr(new BigDecimal(Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_ANYO)));

		if (organismo.getIskontsumonet().equals(Y41bConstantes.VALOR_SI)) {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_TRASLADO);
		} else {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_COMUNICACION);
		}

		StringBuffer textoTraslado = new StringBuffer();
		// Si el texto es mayor de 255 lo truncamos
		if (tramitehecho.getEhtexto() != null
				&& tramitehecho.getEhtexto().length() > Y41bConstantes.MAXLENGTH_OBJECT_NAME) {
			textoTraslado.append(tramitehecho.getEhtexto().subSequence(Y41bConstantes.MINLENGTH_OBJECT_NAME,
					Y41bConstantes.MAXLENGTH_OBJECT_NAME));
		} else {
			textoTraslado.append(tramitehecho.getEhtexto());
		}
		traslado.setIhtedoad(textoTraslado.toString());
		traslado.setIhfereor(tramitehecho.getEhfecha());
		traslado.setIhcooror(codOrganismoOrigen); // cod
		// org
		// de
		// la
		// denuncia
		traslado.setIhcoordt(traslados.get(0).getIhcooror());

		DecisionHecho decisiontraslado = new DecisionHecho();
		decisiontraslado.setHccodigo(decisionHechoDetalle.getHccodigo());
		traslado.setDecisionHecho(decisiontraslado); // codigo
														// de
														// la
														// decision

		// Codigo del tramite hecho
		traslado.setIhcoeh(tramitehecho.getEhcodigo());

		// -JAVI 09/01
		String texto = tramiteRecepcionTraslado.getMotivoRechazo();
		if (texto.length() > 255) {
			texto = tramiteRecepcionTraslado.getMotivoRechazo().substring(0, 255);
		}
		traslado.setIhtedoad(texto);

		// alta traslado
		this.trasladoDao.addTraslado(traslado);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO, null, tramiteComun.getIdExpediente());
	}

	/**
	 * Esta funcion realiza la apertura del expediente presencial tras la
	 * recepcin del traslado
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param intervinientesAux
	 *            Intervinientes
	 * @throws Exception
	 */
	public void tratamientoAperturaPresenciaRecepcionTraslado(SolicitudDetalle solDetalle,
			Intervinientes intervinientesAux) throws Exception {
		// Abrir el expediente presencial
		SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		solicitudPresencial.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(intervinientesAux.getNif());
		datosPersona.setNombre(intervinientesAux.getNombre());

		if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
			datosPersona.setApellido1(intervinientesAux.getApellido1());
		}

		solicitudPresencial.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		solicitudPresencial.setNumeroExpediente(numeroExpediente.toString());

		solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		// "Jgrey (22/03/2017): 91240: [Construccion] - Adecuacion de Mis
		// gestiones"
		// "NO se incluyen documentos en la solicitud presencial de PLATEA, ya
		// que son documentos generados por la Administracion."
		solicitudPresencial = y41bPlateaAdapterService.crearSolicitudPresencial(solicitudPresencial);

		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documentoAux : solicitudPresencial.getDocumentosAdjuntos()) {
				// Actualizo OID Dokusi en tabla documentos hecho
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documentoAux.getIdDocumento());
				documentoHechoAux.setQ5iddocumentum(documentoAux.getOidDokusi());
				// Update oid de documentum
				this.documentoHechoDao.updateOIDDokusi(documentoHechoAux);

				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHechoAux);
			}
		}
	}

	/**
	 * Esta funcion aade el interviniente interesado en una recepcin de
	 * traslado
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Intervinientes
	 * @throws Exception
	 */
	public Intervinientes tratamientoAadirIntervinienteInteresado(SolicitudDetalle solDetalle,
			TramiteComun tramiteComun) throws Exception {
		// buscar el interviniente interesado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		// Interviniente consumidor
		Consumidor consumidor = new Consumidor();
		consumidor.setDtcodigo(solDetalle.getDtcodigo());

		consumidor = this.consumidorDao.find(consumidor);

		Intervinientes intervinientesAux = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), consumidor.getDtcodigo(), null, null,
				consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
				consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
				consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
				consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
				consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(), consumidor.getDtnoraMunicipioId(),
				consumidor.getDtnombreMunicipio(), consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
				consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
				consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
				consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
				consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, tramiteComun.getIdExpediente(), null,
				consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
				consumidor.getCensoMonitor().getUsuarioxlnet());

		// Comprobamos si existe, si existe lo modificamos, si no existe
		// lo
		// insertamos
		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			intervinientesAux.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
			this.intervinientesDao.update(intervinientesAux);
			if (!Y41bUtils.isFilled(solDetalle.getHdidparticipacionreclamante())) {
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);
			}
		} else {
			this.intervinientesDao.add(intervinientesAux);
			this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);
		}

		return intervinientesAux;
	}

	/**
	 * Esta funcion aade el interviniente demandado en una recepcin de
	 * traslado
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Intervinientes
	 * @throws Exception
	 */
	public Intervinientes tratamientoAadirIntervinienteDemandado(SolicitudDetalle solDetalle,
			TramiteComun tramiteComun) throws Exception {
		// buscar el interviniente demandado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		// Interviniente establecimiento
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(solDetalle.getEscodigo());

		establecimiento = this.establecimientoDao.find(establecimiento);

		establecimiento = this.tratamientoAnyadirIntervinienteDemandado(establecimiento);

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(establecimiento);

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
			if (establecimArbitra != null) {
				if ("A".equals(establecimiento.getEsinadar())) {
					if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
						establecimiento.setEsinadar("L");
					}
				}
			}
		} catch (Exception e) {

		}

		Intervinientes intervinientesAux2 = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, establecimiento.getEscodigo(),
				null, establecimiento.getEsnombre(), null, null, establecimiento.getEsnoco(), null,
				establecimiento.getEsnif(), null, null, establecimiento.getEscoidco(), establecimiento.getEsteurl(),
				establecimiento.getEsnopeco(), establecimiento.getEsfeba(), establecimiento.getEsnrtel(),
				establecimiento.getEsnrtel2(), establecimiento.getEscoem(), establecimiento.getEsextranjero(),
				establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
				establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
				establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
				establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(), establecimiento.getEsnoraCpId(),
				establecimiento.getEsnombreCp(), establecimiento.getEsnoraPortalId(),
				establecimiento.getEsnombrePortal(), establecimiento.getEsnombrePiso(),
				establecimiento.getEsnoraPaisId(), // JAVI 26/04
				establecimiento.getEsnoraPaisNombre(), // JAVI 26/04
				establecimiento.getEsdireccion_nocapv(), null, establecimiento.getEsinadar(),
				establecSector.getSector().getSecodigo(), establecSector.getSector().getSenombre(),
				establecSector.getSector().getSenombree(), Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO,
				tramiteComun.getIdExpediente(), null, establecimiento.getEsfemod(),
				establecimiento.getCensoMonitor().getMocodigo(), establecimiento.getCensoMonitor().getUsuarioxlnet());

		// Comprobamos si existe, si existe lo modificamos, si no existe
		// lo
		// insertamos
		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			intervinientesAux2.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
			this.intervinientesDao.update(intervinientesAux2);
			if (!Y41bUtils.isFilled(solDetalle.getHdidparticipacionreclamado())) {
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMADO(intervinientesAux2);
			}
		} else {
			this.intervinientesDao.add(intervinientesAux2);
			this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMADO(intervinientesAux2);
		}

		return intervinientesAux2;
	}

	private Establecimiento tratamientoAnyadirIntervinienteDemandado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un establecimiento a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

	/**
	 * Esta funcion aade el interviniente administracion en una recepcin de
	 * traslado
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Intervinientes
	 * @throws Exception
	 */
	public Intervinientes tratamientoAadirIntervinienteAdministracion(
			TramiteRecepcionTraslado tramiteRecepcionTraslado, TramiteComun tramiteComun) throws Exception {
		Organismo organismo = new Organismo();
		organismo.setCodOrg(tramiteRecepcionTraslado.getInstructorEjecucion().getOrganismo().getCodOrg());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		// buscar el interviniente administracion
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setEntidadId(organismo.getEntidadId());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		Intervinientes intervinientesAux3 = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null, organismo.getEntidadId(),
				organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null, null, null,
				organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
				organismo.getNoraProvinciaId(), organismo.getNombreProvincia(), organismo.getNoraMunicipioId(),
				organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
				organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
				organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
				organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
				organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null, null,
				null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			intervinientesAux3.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
			this.intervinientesDao.update(intervinientesAux3);
		} else {
			this.intervinientesDao.add(intervinientesAux3);
		}

		return intervinientesAux3;
	}

	/**
	 * Esta funcion realiza el envio de la comunicacion en una recepcin de
	 * traslado
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param traslados
	 *            List<TrasladoBusqueda>
	 * @throws Exception
	 */
	public void tratamientoEnviarcomunicacionRecepcionTraslado(SolicitudDetalle solDetalle,
			TramiteRecepcionTraslado tramiteRecepcionTraslado, List<TrasladoBusqueda> traslados) throws Exception {
		// enviar comunicacion
		Comunicacion comunicacion = new Comunicacion();
		comunicacion.setM4cocomu(this.comunicacionDao.getNewPK());

		Organismo organismoComunicacion = new Organismo();
		organismoComunicacion.setCodOrg(tramiteRecepcionTraslado.getInstructorEjecucion().getOrganismo().getCodOrg());

		TipoComunicacion tipoComunicacion = new TipoComunicacion(Y41bConstantes.TIPO_COMUNICACION_NO_REPLY, null, null,
				null, null, null, null, null);

		comunicacion.setOrganismo(organismoComunicacion);
		comunicacion.setTipoComunicacion(tipoComunicacion);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

		// recuperar texto de properties
		StringBuffer asunto = new StringBuffer();
		asunto.append(appMessageSource.getMessage("traslado.aceptacion", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append(" ").append(numeroExpediente);
		asunto.append(" / ");
		asunto.append(appMessageSource.getMessage("traslado.aceptacion", null, new Locale(Y41bConstantes.EUSKERA)))
				.append(" ").append(numeroExpediente);

		comunicacion.setM4tesubject(asunto.toString());

		StringBuffer aceptacionTraslado = new StringBuffer();
		aceptacionTraslado.append(
				appMessageSource.getMessage("traslado.textoaceptacion", null, new Locale(Y41bConstantes.CASTELLANO)));
		aceptacionTraslado.append(" / ");
		aceptacionTraslado.append(
				appMessageSource.getMessage("traslado.textoaceptacion", null, new Locale(Y41bConstantes.EUSKERA)));

		comunicacion.setM4tecomu(aceptacionTraslado.toString());

		// buscar monitor
		CensoMonitor remitente = new CensoMonitor();
		remitente.setMocodigo(tramiteRecepcionTraslado.getInstructorEjecucion().getMocodigo());

		remitente = this.censoMonitorDao.find(remitente);

		comunicacion.setM4noremi(remitente.getMonombre());

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		comunicacion.setM4feenv(todayWithZeroTime);
		comunicacion.setM4fecad(todayWithZeroTime);

		comunicacion.setM4nudest(new Long(1));
		comunicacion.setM4nufiladj(new Long(0));
		comunicacion.setM4incomact(0);
		comunicacion.setM4incombl(0);

		this.comunicacionDao.add(comunicacion);

		DestComunicacion destcomunicacion = new DestComunicacion();

		Organismo organismoDestComunicacion = new Organismo();
		organismoDestComunicacion.setCodOrg(traslados.get(0).getIhcooror());

		destcomunicacion.setOrganismo(organismoDestComunicacion);
		destcomunicacion.setComunicacion(comunicacion);

		this.destComunicacionDao.add(destcomunicacion);
	}

	/**
	 * Guardar tramite comunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoComunicacion
	 *            tipo de comunicacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoComunicacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar) {
			if (Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
				this.validarSiExisteSede(tramiteComunicacion.getDestinatario());
			}

			if (tipoComunicacion != null
					&& tipoComunicacion.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO)) {
				if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
					throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
				}
			}
		}

		if (!Y41bUtils.isFilled(tramiteComunicacion.getDestinatario())) {
			throw new Y41bUDAException("error.notificacioncomunicacion.destinatario_Exception", true, new Exception());
		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteComunicacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteComunicacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteComunicacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteComunicacion.getComentario());

		// Remesas Ini
		tramitehecho.setEhenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		tramitehecho.setEhcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin

		tramitehecho.setEhfechacomunicacion(tramiteComunicacion.getFechaComunicacion());
		tramitehecho.setEhiddestinatario(tramiteComunicacion.getDestinatario());
		tramitehecho.setEhsede(tramiteComunicacion.getSede());
		tramitehecho.setEhtipocomunicacion(tipoComunicacion);
		tramitehecho.setEhfecharegistrosalida(tramiteComunicacion.getFechasalida());
		tramitehecho.setEhnumregistrosalida(tramiteComunicacion.getNumregistrosalida());
		tramitehecho.setEhasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		tramitehecho.setEhtextocomunicacion(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));

		tramitehecho.setEhidmailorigen(tramiteComunicacion.getIdmailorigen());
		tramitehecho.setEhmailorigen(tramiteComunicacion.getMailorigen());
		tramitehecho.setEhidmaildestino(tramiteComunicacion.getIdmaildestino());
		tramitehecho.setEhmaildestino(tramiteComunicacion.getMaildestino());

		if (tramitar) {
			if (tramitehecho.getEhtipocomunicacion() != null
					&& tramitehecho.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)) {
				tramitehecho = obtenerRegistrosalidaComunicacionNotificacion(tramitehecho, tramiteComun);
			}

			tramitehecho.setEhfechafin(tramiteComunicacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteComunicacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteComunicacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			this.procesarDocumentosTramite(tramiteComun);

			// Obtenemos los documentos del tramite
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (tramitar) {
				if (tramitehecho.getEhtipocomunicacion() != null && tramitehecho.getEhtipocomunicacion()
						.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, tramitehecho,
							tramiteComun, idZipFile);
				} else if (tramitehecho.getEhtipocomunicacion() != null && tramitehecho.getEhtipocomunicacion()
						.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO)) {
					// Mando el email
					boolean enviadoOk = this.envioEmailComunicacion(tramiteComunicacion, tramiteComun, listadjuntardocs,
							censoMonitor);
					if (!enviadoOk) {
						throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
					}
				} else if (tramitehecho.getEhtipocomunicacion() != null
						&& tramitehecho.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)) {
					this.procesarComunicacionElectronica(listDocumentoHecho, tramiteComunicacion, tramitehecho,
							censoMonitor);
				}
			} else {
				this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun,
						Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
				/******************************************/
			}
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_COMUNICACION, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		if (tramitar) {
			this.tratamientoComunicacion(tramitehecho, tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar tramite notificacion
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoNotificacion
	 *            tipo de notificacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoNotificacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar) {
			if (Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
				this.validarSiExisteSede(tramiteNotificacion.getDestinatario());
			}
		}

		if (!Y41bUtils.isFilled(tramiteNotificacion.getDestinatario())) {
			throw new Y41bUDAException("error.notificacioncomunicacion.destinatario_Exception", true, new Exception());
		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteNotificacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteNotificacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteNotificacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteNotificacion.getComentario());

		// Remesas Ini
		tramitehecho.setEhenvrem(tramiteNotificacion.getEnvRemesaNotificacion());
		tramitehecho.setEhcodrem(tramiteNotificacion.getIdRemesaNotificacion());
		// Remesas Fin

		tramitehecho.setEhfechacomunicacion(tramiteNotificacion.getFechaComunicacion());
		tramitehecho.setEhiddestinatario(tramiteNotificacion.getDestinatario());
		tramitehecho.setEhsede(tramiteNotificacion.getSede());
		tramitehecho.setEhtiponotificacion(tipoNotificacion);
		tramitehecho.setEhtiponotificacionplatea(tramiteNotificacion.getTipoNotificacionPlatea());
		tramitehecho.setEhfecharegistrosalida(tramiteNotificacion.getFechasalida());
		tramitehecho.setEhnumregistrosalida(tramiteNotificacion.getNumregistrosalida());
		tramitehecho.setEhtextocomunicacion(Y41bUtils.stringToClob(tramiteNotificacion.getTextoComunicacion()));

		if (tramitar) {
			if (tramitehecho.getEhtiponotificacion() != null
					&& tramitehecho.getEhtiponotificacion().equals(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA)) {
				tramitehecho = obtenerRegistrosalidaComunicacionNotificacion(tramitehecho, tramiteComun);
			}

			tramitehecho.setEhfechafin(tramiteNotificacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteNotificacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteNotificacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			this.procesarDocumentosTramite(tramiteComun);

			/******************************************/
			// Obtenemos los documentos del tramite
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (tramitar) {
				if (tramitehecho.getEhtiponotificacion() != null
						&& tramitehecho.getEhtiponotificacion().equals(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA)) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, tramitehecho,
							tramiteComun, idZipFile);

					// Se genera el tramite de acuse de recibo vinculado al
					// tramite de
					// notificacion
					String idEspera = null;
					this.generarTramiteAcuseReciboAutomatico(idEspera, tramitehecho, tramiteComun);

				} else if (tramitehecho.getEhtiponotificacion() != null
						&& tramitehecho.getEhtiponotificacion().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
					this.procesarNotificacionElectronica(listDocumentoHecho, tramiteNotificacion, tramitehecho,
							tramiteComun, censoMonitor);
				}
			} else {
				this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun,
						Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			}
		}

		if (tramitar) {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_NOTIFICACION, Y41bConstantes.TRAMITE_ACUSE_RECIBO,
					tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_NOTIFICACION, null, tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar la solicitud de colaboracin otro organismo
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteSolicitudColaboracion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteSolColaboracion(TramiteSolicitudColaboracion tramiteSolicitudColaboracion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_SOLICITUD_COLABORACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);

		tramitehecho.setEhfechainicio(tramiteSolicitudColaboracion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteSolicitudColaboracion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhfechafin(tramiteSolicitudColaboracion.getFechaFin());
		tramitehecho.setEhcomoejecucion(tramiteSolicitudColaboracion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhcomo(tramiteSolicitudColaboracion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteSolicitudColaboracion.getComentario());

		// Info Mediacion Ini
		tramitehecho.setEhfeccolabsol(tramiteSolicitudColaboracion.getFecha());
		tramitehecho.setEhcodmotivocolabsol(tramiteSolicitudColaboracion.getMotivoSolicitud());
		tramitehecho.setEhidorganismocolabsol(tramiteSolicitudColaboracion.getOrganismo().getCodOrg());
		tramitehecho.setEhresumencolabsol(Y41bUtils.stringToClob(tramiteSolicitudColaboracion.getResumensolicitud()));
		// Info Mediacion Fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteSolicitudColaboracion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteSolicitudColaboracion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteSolicitudColaboracion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);

				this.tratamientoAadirIntervinienteOtros(tramitehecho, tramiteComun);

			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho, Y41bConstantes.FASE_MEDIACION,
						Y41bConstantes.TRAMITE_SOLICITUD_COLABORACION);
			}
		}

		if (tramitar) {
			// 3. Se genera el tramite de Notificacin vinculado al tramite de
			// Solicitud de colaboracin otro organismo
			this.generarTramiteNotificacionSolColaboracion(tramiteSolicitudColaboracion, tramiteComun);

			// 4. Se genera el tramite de Respuesta solicitud de colaboracin
			// vinculado al tramite de
			// Solicitud de colaboracin otro organismo
			// Solicitud de colaboracin otro organismo
			this.generarTramiteRespuestaColaboracion(tramiteSolicitudColaboracion, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_SOLICITUD_COLABORACION,
					Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION, tramiteComun.getIdExpediente());
		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_SOLICITUD_COLABORACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratamiento de Bandeja Solicitudes
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Esta funcion aade el interviniente otros en una solicitud de
	 * colaboracin
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Intervinientes
	 * @throws Exception
	 */
	public void tratamientoAadirIntervinienteOtros(TramiteHecho tramitehecho, TramiteComun tramiteComun)
			throws Exception {
		// 2. Guardar el Organismo como Interviniente
		Organismo organismo = new Organismo();
		organismo.setCodOrg(tramitehecho.getEhidorganismocolabsol());
		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		// buscar el interviniente interesado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS);
		intervinientes.setEntidadId(organismo.getEntidadId());
		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		Intervinientes intervinientesAux = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null, organismo.getEntidadId(),
				organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null, null, null,
				organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
				organismo.getNoraProvinciaId(), organismo.getNombreProvincia(), organismo.getNoraMunicipioId(),
				organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
				organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
				organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
				organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
				organismo.getNombreCalle(), null, null, null, null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS,
				intervinientes.getIdExpediente(), null, null, null, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			intervinientesAux.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
			this.intervinientesDao.update(intervinientesAux);
		} else {
			this.intervinientesDao.add(intervinientesAux);
		}
	}

	/**
	 * Guardar la respuesta de colaboracin otro organismo
	 * 
	 * @param tramiteRespuestaColaboracion
	 *            TramiteRespuestaColaboracion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRespColaboracion(TramiteRespuestaColaboracion tramiteRespuestaColaboracion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRespuestaColaboracion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRespuestaColaboracion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRespuestaColaboracion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRespuestaColaboracion.getComentario());

		// Info Respuesta Colaboracin Ini
		tramitehecho.setEhfeccolabresp(tramiteRespuestaColaboracion.getFecha());
		tramitehecho.setEhrespuestacolabresp(tramiteRespuestaColaboracion.getRespuesta());
		tramitehecho.setEhresumencolabresp(Y41bUtils.stringToClob(tramiteRespuestaColaboracion.getResumenrespuesta()));
		// Info Respuesta Colaboracin Fin

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRespuestaColaboracion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRespuestaColaboracion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		this.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Validaciones
			if (Y41bConstantes.RESPUESTA_RESPONDIDO.equals(tramitehecho.getEhrespuestacolabresp())) {
				// No se puede tramitar el tramite si tiene es respondido
				// y no tiene resumen o no tiene documento de respuesta

				TramiteComun tramiteComunAux = new TramiteComun();
				tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				if ((listDocumentoHecho == null || listDocumentoHecho.size() == 0)
						&& tramitehecho.getEhresumencolabresp() == null) {
					throw new Y41bUDAException("error.solicitud.documento_o_resumen_Exception", true, new Exception());
				}
			}
		}
		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION, null,
				tramiteComun.getIdExpediente());

		// Tratamiento de Bandeja Solicitudes
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	private TramiteHecho tramitarEditTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, DocumentoHecho docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo(tramiteAcuseRecibo, tramiteComun, null, true,
				Y41bConstantes.MODO_POPUP_MODIFICACION, docHechoPEE, true, false);
	}

	private TramiteHecho editTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, DocumentoHecho docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo(tramiteAcuseRecibo, tramiteComun, null, false,
				Y41bConstantes.MODO_POPUP_MODIFICACION, docHechoPEE, true, false);
	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion
	 * 
	 * @param tramitehecho
	 *            Tramitehecho
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	private boolean tratamientoSeguridad(TramiteHecho tramitehecho, CensoMonitor censoMonitor) {
		// obtener la solicitud
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());

		solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (censoMonitor == null) {
			return false;
		}

		// Miro si la solicitud esta cerrada
		if (solicitudDetalle.getHdfechacierre() != null) {
			return false;
		}

		if (tramitehecho != null && tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_BOPV_AYTO)) {

			if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
				return true;
			}
		}

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		if (solicitudDetalle != null && solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramitehecho.getEhcotee());

			tramite = this.tramiteDao.find(tramite);

			if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				if (solicitudDetalle.getMocodigo() != null
						&& !solicitudDetalle.getMocodigo().equals(censoMonitor.getMocodigo())) {
					return false;
				}
			}

			// Comunicacion traslado organismo origen no puede
			if (tramite != null && tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
						&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
					TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
					tramiteHechoDet.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
					TrasladoBusqueda trasladoBusqueda = this.trasladoDao.findTrasladoTramite(tramiteHechoDet);
					if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null
							&& !trasladoBusqueda.getIhcooror().equals(censoMonitor.getOrganismo().getCodOrg())) {
						if (censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
							return true;
						} else {
							return false;
						}
					}
				}
			}

			if (tramite != null && tramite.getIdPerfil() != null) {
				if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO) && (censoMonitor
						.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
						|| censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
						|| censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					return true;
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
						&& (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
								|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_COORDINADOR)
								|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					return true;
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						&& (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
								|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {

			// borrar los tramites del expediente en la bandeja
			BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
			bandejasolicitudes.setHdcodigo(tramitehecho.getEhcohd());

			// consultar los tramites no tramitados
			List<BandejaSolicitudes> listBandejaSolicitudes = this.bandejaSolicitudesDao
					.findAllTramitesPendientesSolicitudes(bandejasolicitudes, null);

			if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {

				Tramite tramiteActual = new Tramite();
				tramiteActual.setTrcodigo(tramitehecho.getEhcotee());

				tramiteActual = this.tramiteDao.find(tramiteActual);

				if (tramiteActual != null && tramiteActual.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
					// insertar los tramites no tramitados en la bandeja
					for (BandejaSolicitudes bandejaSolicitudesAux : listBandejaSolicitudes) {
						// Si el tramite es una comunicacion, se mira si el
						// tramite
						// de
						// comunicacion esta relacionado con un traslado,
						// Si pertenece a un traslado, se mete el organismo
						// origen
						// en la
						// bandeja, para que aparezca en la bandeja
						// de los instructores del organismo origen para poder
						// realizar
						// la comunicacion
						if (tramitehecho.getEhcodigo() != null
								&& tramitehecho.getEhcodigo().equals(bandejaSolicitudesAux.getEhcodigo())
								&& bandejaSolicitudesAux != null && bandejaSolicitudesAux.getTrcodigo() != null
								&& bandejaSolicitudesAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
							tramitehecho = new TramiteHecho();
							tramitehecho.setEhcodigo(bandejaSolicitudesAux.getEhcodigo());

							tramitehecho = this.tramiteHechoDao.find(tramitehecho);

							try {
								if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
										&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
									TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
									tramiteHechoDet.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
									TrasladoBusqueda trasladoBusqueda = this.trasladoDao
											.findTrasladoTramite(tramiteHechoDet);
									if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null
											&& trasladoBusqueda.getIhcooror()
													.equals(censoMonitor.getOrganismo().getCodOrg())) {
										return true;
									}
								}
							} catch (EmptyResultDataAccessException e) {
								if (!censoMonitor.getPerfilSolicitudes().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
									return false;
								}
							}
						}
					}
				}
			}
			// si el usuario conectado tiene perfil de supervisior, le damos
			// permiso para modificar
			if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHechoDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteAdjuntarDocs.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteAdjuntarDocs tramiteAdjuntarDocsAux = new TramiteAdjuntarDocs();
		tramiteAdjuntarDocsAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteAdjuntarDocsAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteAdjuntarDocsAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAdjuntarDocsAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAdjuntarDocsAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAdjuntarDocsAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteAdjuntarDocsAux.setIstelematico(tramitehecho.getEhistelematico());

		/* Evolutivo SIR */
		tramiteAdjuntarDocsAux.setIsSIR(tramitehecho.getEhissir());
		/* Aportaciones Evolutivo Web Sin certficado - Aportaciones */
		tramiteAdjuntarDocsAux.setIsWebSinCertificado(tramitehecho.getEhIsWebSinCertificado());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteAdjuntarDocsAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteAdjuntarDocsAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAdjuntarDocsAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAdjuntarDocsAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor censoMonitor) {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteGenerico.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteGenerico tramiteGenericoAux = new TramiteGenerico();
		tramiteGenericoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteGenericoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteGenericoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteGenericoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteGenericoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteGenericoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteGenericoAux.setNombreTramite(tramitehecho.getEhnombretramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteGenericoAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteGenericoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAsignacionInstructor
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAsignacionInstructor findTramiteAsignacionInstructor(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, CensoMonitor censoMonitor)
			throws SQLException, IOException {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteAsignacionInstructor.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteAsignacionInstructor tramiteAsignacionInstructorAux = new TramiteAsignacionInstructor();
		tramiteAsignacionInstructorAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteAsignacionInstructorAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteAsignacionInstructorAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAsignacionInstructorAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAsignacionInstructorAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAsignacionInstructorAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteAsignacionInstructorAux.setTipoSolicitud(tramitehecho.getEhcosc());

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		tramiteAsignacionInstructorAux.setDenunciaaaccempresas(solDetalle.getHddenunciaaaccempresas());

		if (tramiteAsignacionInstructorAux.getTipoSolicitud() == null
				|| tramiteAsignacionInstructorAux.getTipoSolicitud().equals("")) {

			tramiteAsignacionInstructorAux.setTipoSolicitud(solDetalle.getHdcosc());
		}

		CensoMonitor instructorExpediente = new CensoMonitor();
		instructorExpediente.setMocodigo(tramitehecho.getEhcomodesignado());

		if (tramitehecho.getEhcomodesignado() != null && !tramitehecho.getEhcomodesignado().equals("")) {
			instructorExpediente = this.censoMonitorDao.find(instructorExpediente);
		}

		tramiteAsignacionInstructorAux.setInstructorExpediente(instructorExpediente);

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteAsignacionInstructorAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteAsignacionInstructorAux
				.setSiguientesTramites(Y41bUtils.clobToString(tramitehecho.getEhsiguientestramites()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteAsignacionInstructorAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAsignacionInstructorAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAsignacionInstructorAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroSolicitud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRegistroSolicitud findTramiteRegistroSolicitud(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			CensoMonitor censoMonitor) {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRegistroSolicitud.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRegistroSolicitud tramiteRegistroSolicitudAux = new TramiteRegistroSolicitud();
		tramiteRegistroSolicitudAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRegistroSolicitudAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRegistroSolicitudAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRegistroSolicitudAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRegistroSolicitudAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRegistroSolicitudAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRegistroSolicitudAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRegistroSolicitudAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRegistroSolicitudAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRegistroSolicitudAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoSubsanacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoSubsanacion findTramiteRequerimientoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRequerimientoSubsanacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacionsAux = new TramiteRequerimientoSubsanacion();
		tramiteRequerimientoSubsanacionsAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRequerimientoSubsanacionsAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRequerimientoSubsanacionsAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRequerimientoSubsanacionsAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRequerimientoSubsanacionsAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoSubsanacionsAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRequerimientoSubsanacionsAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRequerimientoSubsanacionsAux
				.setDocumentacionrequerida(Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequerida()));
		tramiteRequerimientoSubsanacionsAux
				.setDocumentacionrequeridae(Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequeridae()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRequerimientoSubsanacionsAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoSubsanacionsAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoSubsanacionsAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRegistroDecision findTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRegistroDecision.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRegistroDecision tramiteRegistroDecisionAux = new TramiteRegistroDecision();
		tramiteRegistroDecisionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRegistroDecisionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRegistroDecisionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRegistroDecisionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRegistroDecisionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRegistroDecisionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		// Registro decision ini
		tramiteRegistroDecisionAux.setTipoDecision(tramitehecho.getEhdecodigo());
		tramiteRegistroDecisionAux.setFechaDecision(tramitehecho.getEhfecharesolucion());
		// Registro decision fin

		//
		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRegistroDecisionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRegistroDecisionAux
				.setJustificacionInfraccion(Y41bUtils.clobToString(tramitehecho.getEhjustificacioninfraccion()));

		//

		if (tramitehecho.getEhcoortraspaso() != null && !tramitehecho.getEhcoortraspaso().equals("")) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramitehecho.getEhcoortraspaso());

			organismo = this.organismoDao.find(organismo);

			tramiteRegistroDecisionAux.setCodOrgTraslado(organismo.getCodOrg());
			tramiteRegistroDecisionAux.setNombreOrgTrasladoEs(organismo.getNombreEs());
			tramiteRegistroDecisionAux.setNombreOrgTrasladoEu(organismo.getNombreEu());
		}

		tramiteRegistroDecisionAux.setInstructorAsignado(instructorAsignado);

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRegistroDecisionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRegistroDecisionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		if (tramitehecho.getEhapercibimientoes() != null && !tramitehecho.getEhapercibimientoes().equals("")) {
			tramiteRegistroDecisionAux
					.setApercibimientoEs(Y41bUtils.clobToString(tramitehecho.getEhapercibimientoes()));
		}
		if (tramitehecho.getEhapercibimientoeu() != null && !tramitehecho.getEhapercibimientoeu().equals("")) {
			tramiteRegistroDecisionAux
					.setApercibimientoEu(Y41bUtils.clobToString(tramitehecho.getEhapercibimientoeu()));
		}

		return tramiteRegistroDecisionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteAcuseRecibo.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteAcuseRecibo tramiteAcuseReciboAux = new TramiteAcuseRecibo();
		tramiteAcuseReciboAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteAcuseReciboAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteAcuseReciboAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAcuseReciboAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAcuseReciboAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAcuseReciboAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteAcuseReciboAux.setAcusereintentado(tramitehecho.getEhacusereintentado());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteAcuseReciboAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info de Acuse recibo ini
		tramiteAcuseReciboAux.setFechaacuse(tramitehecho.getEhacuserecibo());
		tramiteAcuseReciboAux.setSituacionacuse(tramitehecho.getEhacusereciborecibido());
		tramiteAcuseReciboAux.setFechaentrada(tramitehecho.getEhfecharegistroentrada());
		tramiteAcuseReciboAux.setNumregistroentrada(tramitehecho.getEhnumregistroentrada());
		// Info de Acuse recibo fin

		// Recupero el tramite de notificacion relacionado ini
		TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
		tramiteNotificacionWhere.setIdTramite(tramitehecho.getTramiteHecho().getEhcodigo());
		TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
				censoMonitor);
		tramiteAcuseReciboAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		// Recupero el tramite de notificacion relacionado fin

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteAcuseReciboAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAcuseReciboAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAcuseReciboAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteMediacionTelefonica
	 *            TramiteMediacionTelefonica
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacionTelefonica
	 * @throws IOException
	 * @throws SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteMediacionTelefonica findTramiteMediacionTelefonica(
			TramiteMediacionTelefonica tramiteMediacionTelefonica, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteMediacionTelefonica.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteMediacionTelefonica tramiteMediacionTelefonicaAux = new TramiteMediacionTelefonica();
		tramiteMediacionTelefonicaAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteMediacionTelefonicaAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteMediacionTelefonicaAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteMediacionTelefonicaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteMediacionTelefonicaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteMediacionTelefonicaAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteMediacionTelefonicaAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info Mediacion Ini
		tramiteMediacionTelefonicaAux.setFechamediacion(tramitehecho.getEhfechamediacion());
		tramiteMediacionTelefonicaAux.setHoramediacion(tramitehecho.getEhhoramediacion());
		tramiteMediacionTelefonicaAux.setHoramediacioninicio(tramitehecho.getEhhoramediacioninicio());
		tramiteMediacionTelefonicaAux.setHoramediacionfin(tramitehecho.getEhhoramediacionfin());

		tramiteMediacionTelefonicaAux.setTelefonosMediacion1(tramitehecho.getEhnrtel1());
		tramiteMediacionTelefonicaAux.setTelefonosMediacion2(tramitehecho.getEhnrtel2());
		tramiteMediacionTelefonicaAux.setTelefonosMediacion3(tramitehecho.getEhnrtel3());
		// Info Mediacion Fin

		tramiteMediacionTelefonicaAux.setResumenmediacion(Y41bUtils.clobToString(tramitehecho.getEhresumenmediacion()));
		tramiteMediacionTelefonicaAux
				.setIntervinientesmediacion(Y41bUtils.clobToString(tramitehecho.getEhintervinientes()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteMediacionTelefonicaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteMediacionTelefonicaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteMediacionTelefonicaAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteMediacionPresencial
	 *            TramiteMediacionPresencial
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacionPresencial
	 * @throws IOException
	 * @throws SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteMediacionPresencial findTramiteMediacionPresencial(
			TramiteMediacionPresencial tramiteMediacionPresencial, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteMediacionPresencial.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteMediacionPresencial tramiteMediacionPresencialAux = new TramiteMediacionPresencial();
		tramiteMediacionPresencialAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteMediacionPresencialAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteMediacionPresencialAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteMediacionPresencialAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteMediacionPresencialAux.setInstructorEjecucion(instructorEjecucion);

		tramiteMediacionPresencialAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteMediacionPresencialAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info Mediacion Ini
		tramiteMediacionPresencialAux.setFechamediacion(tramitehecho.getEhfechamediacion());
		tramiteMediacionPresencialAux.setHoramediacion(tramitehecho.getEhhoramediacion());

		tramiteMediacionPresencialAux.setHoramediacioninicio(tramitehecho.getEhhoramediacioninicio());
		tramiteMediacionPresencialAux.setHoramediacionfin(tramitehecho.getEhhoramediacionfin());

		// Info Mediacion Fin

		tramiteMediacionPresencialAux.setResumenmediacion(Y41bUtils.clobToString(tramitehecho.getEhresumenmediacion()));
		tramiteMediacionPresencialAux
				.setIntervinientesmediacion(Y41bUtils.clobToString(tramitehecho.getEhintervinientes()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteMediacionPresencialAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteMediacionPresencialAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteMediacionPresencialAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoAlegacion
	 *            TramiteRequerimientoAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoAlegacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoAlegacion findTramiteRequerimientoAlegacion(
			TramiteRequerimientoAlegacion tramiteRequerimientoAlegacion, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRequerimientoAlegacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRequerimientoAlegacion tramiteRequerimientoAlegacionsAux = new TramiteRequerimientoAlegacion();
		tramiteRequerimientoAlegacionsAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRequerimientoAlegacionsAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRequerimientoAlegacionsAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRequerimientoAlegacionsAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRequerimientoAlegacionsAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoAlegacionsAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRequerimientoAlegacionsAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRequerimientoAlegacionsAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRequerimientoAlegacionsAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoAlegacionsAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoAlegacionsAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSegundaMediacion
	 *            TramiteSegundaMediacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSegundaMediacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteSegundaMediacion findTramiteSegundaMediacion(TramiteSegundaMediacion tramiteSegundaMediacion,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteSegundaMediacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteSegundaMediacion tramiteSegundaMediacionAux = new TramiteSegundaMediacion();
		tramiteSegundaMediacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteSegundaMediacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteSegundaMediacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteSegundaMediacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteSegundaMediacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteSegundaMediacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteSegundaMediacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteSegundaMediacionAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteSegundaMediacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteSegundaMediacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteSegundaMediacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoInformacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoInformacion findTramiteRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRequerimientoInformacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRequerimientoInformacion tramiteRequerimientoInformacionAux = new TramiteRequerimientoInformacion();
		tramiteRequerimientoInformacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRequerimientoInformacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRequerimientoInformacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRequerimientoInformacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRequerimientoInformacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoInformacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRequerimientoInformacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRequerimientoInformacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRequerimientoInformacionAux
				.setDocumentacionrequerida(Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequerida()));
		tramiteRequerimientoInformacionAux
				.setDocumentacionrequeridae(Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequeridae()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoInformacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaAmpliacionPlazo
	 *            TramiteRespuestaAmpliacionPlazo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRespuestaAmpliacionPlazo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRespuestaAmpliacionPlazo findTramiteRespuestaAmpliacionPlazo(
			TramiteRespuestaAmpliacionPlazo tramiteRespuestaAmpliacionPlazo, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRespuestaAmpliacionPlazo.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRespuestaAmpliacionPlazo tramiteRespuestaAmpliacionPlazoAux = new TramiteRespuestaAmpliacionPlazo();
		tramiteRespuestaAmpliacionPlazoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRespuestaAmpliacionPlazoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRespuestaAmpliacionPlazoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRespuestaAmpliacionPlazoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRespuestaAmpliacionPlazoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRespuestaAmpliacionPlazoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRespuestaAmpliacionPlazoAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRespuestaAmpliacionPlazoAux.setFechasolampliacionplazo(tramitehecho.getEhfechasolampliacionplazo());
		tramiteRespuestaAmpliacionPlazoAux.setAceptacionplazo(tramitehecho.getEhaceptacionplazo());
		tramiteRespuestaAmpliacionPlazoAux.setPlazoconcedido(tramitehecho.getEhplazoconcedido());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRespuestaAmpliacionPlazoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRespuestaAmpliacionPlazoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRespuestaAmpliacionPlazoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteBOPVAyto.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteBOPVAyto tramiteBOPVAytoAux = new TramiteBOPVAyto();
		tramiteBOPVAytoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteBOPVAytoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteBOPVAytoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteBOPVAytoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteBOPVAytoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteBOPVAytoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteBOPVAytoAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteBOPVAytoAux.setFechaPublicacionBOPV(tramitehecho.getEhfechapublicacionbopv());
		tramiteBOPVAytoAux.setFechaPublicacionAyto(tramitehecho.getEhfechapublicacionayto());
		tramiteBOPVAytoAux.setFechaEnvioBOPVBOE(tramitehecho.getEhfechaEnvioBOPVBOE());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteBOPVAytoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteBOPVAytoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteBOPVAytoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRecurso
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRecurso findTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionRecurso.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionRecurso tramiteRecepcionRecursoAux = new TramiteRecepcionRecurso();
		tramiteRecepcionRecursoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionRecursoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionRecursoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRecursoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRecursoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRecursoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionRecursoAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info recepcion recurso ini
		tramiteRecepcionRecursoAux.setTiporecurso(tramitehecho.getEhtiporecurso());
		tramiteRecepcionRecursoAux.setFecharecurso(tramitehecho.getEhfecharecurso());
		tramiteRecepcionRecursoAux.setAbogado(tramitehecho.getEhabogado());

		tramiteRecepcionRecursoAux.setMotivorecurso(Y41bUtils.clobToString(tramitehecho.getEhmotivorecurso()));

		// Info recepcion recurso fin

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionRecursoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRecursoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRecursoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(
			TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteElaboracionBOPVAyto.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAytoAux = new TramiteElaboracionBOPVAyto();
		tramiteElaboracionBOPVAytoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteElaboracionBOPVAytoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteElaboracionBOPVAytoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteElaboracionBOPVAytoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteElaboracionBOPVAytoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteElaboracionBOPVAytoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteElaboracionBOPVAytoAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteElaboracionBOPVAytoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteElaboracionBOPVAytoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteElaboracionBOPVAytoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionOrdenConsejero
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionOrdenConsejero findTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionOrdenConsejero.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejeroAux = new TramiteRecepcionOrdenConsejero();
		tramiteRecepcionOrdenConsejeroAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionOrdenConsejeroAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionOrdenConsejeroAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionOrdenConsejeroAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionOrdenConsejeroAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionOrdenConsejeroAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionOrdenConsejeroAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info recepcion orden consejero ini
		tramiteRecepcionOrdenConsejeroAux.setEstimacion(tramitehecho.getEhestimacion());
		// Info recepcion orden consejero fin

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionOrdenConsejeroAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionOrdenConsejeroAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionOrdenConsejeroAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteCierre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteCierre.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteCierre tramiteCierreAux = new TramiteCierre();
		tramiteCierreAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteCierreAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteCierreAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteCierreAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteCierreAux.setInstructorEjecucion(instructorEjecucion);

		tramiteCierreAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteCierreAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteCierreAux.setFechaCierre(tramitehecho.getEhfechacierre());

		tramiteCierreAux.setExcluirCierre(tramitehecho.getEhexcluircierre());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteCierreAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteCierreAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteCierreAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAlegacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAlegacion findTramiteAlegacion(TramiteAlegacion tramiteAlegacion, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteAlegacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteAlegacion tramiteAlegacionAux = new TramiteAlegacion();
		tramiteAlegacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteAlegacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteAlegacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAlegacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAlegacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAlegacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteAlegacionAux.setRespuesta(tramitehecho.getEhrespuesta());

		tramiteAlegacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteAlegacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteAlegacionAux.setResumenAlegaciones(Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteAlegacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteAlegacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteAlegacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAlegacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAlegacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaSegundaMediacion
	 *            TramiteRespuestaSegundaMediacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRespuestaSegundaMediacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRespuestaSegundaMediacion findTramiteRespuestaSegundaMediacion(
			TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacion, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRespuestaSegundaMediacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacionAux = new TramiteRespuestaSegundaMediacion();
		tramiteRespuestaSegundaMediacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRespuestaSegundaMediacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRespuestaSegundaMediacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRespuestaSegundaMediacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRespuestaSegundaMediacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRespuestaSegundaMediacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRespuestaSegundaMediacionAux.setRespuesta(tramitehecho.getEhrespuesta());

		tramiteRespuestaSegundaMediacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRespuestaSegundaMediacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRespuestaSegundaMediacionAux
				.setResumenAlegaciones(Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteRespuestaSegundaMediacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRespuestaSegundaMediacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRespuestaSegundaMediacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRespuestaSegundaMediacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRespuestaSegundaMediacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoInformacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionRequerimientoInformacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacionAux = new TramiteRecepcionRequerimientoInformacion();
		tramiteRecepcionRequerimientoInformacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionRequerimientoInformacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionRequerimientoInformacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRequerimientoInformacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRequerimientoInformacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRequerimientoInformacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRecepcionRequerimientoInformacionAux.setRespuesta(tramitehecho.getEhrespuesta());

		tramiteRecepcionRequerimientoInformacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionRequerimientoInformacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRecepcionRequerimientoInformacionAux
				.setResumenAlegaciones(Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRequerimientoInformacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacionAux = new TramiteRecepcionRequerimientoAcreditacionRepresentacion();
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setRespuesta(tramitehecho.getEhrespuesta());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux
				.setResumenAlegaciones(Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRequerimientoAcreditacionRepresentacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoSubsanacion
	 *            TramiteRecepcionRequerimientoSubsanacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoSubsanacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoSubsanacion findTramiteRecepcionRequerimientoSubsanacion(
			TramiteRecepcionRequerimientoSubsanacion tramiteRecepcionRequerimientoSubsanacion,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionRequerimientoSubsanacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionRequerimientoSubsanacion tramiteRecepcionRequerimientoSubsanacionAux = new TramiteRecepcionRequerimientoSubsanacion();
		tramiteRecepcionRequerimientoSubsanacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionRequerimientoSubsanacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionRequerimientoSubsanacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRequerimientoSubsanacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRequerimientoSubsanacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRequerimientoSubsanacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRecepcionRequerimientoSubsanacionAux.setRespuesta(tramitehecho.getEhrespuesta());

		tramiteRecepcionRequerimientoSubsanacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionRequerimientoSubsanacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRecepcionRequerimientoSubsanacionAux
				.setResumenAlegaciones(Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteRecepcionRequerimientoSubsanacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRecepcionRequerimientoSubsanacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionRequerimientoSubsanacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRequerimientoSubsanacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRequerimientoSubsanacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInformeAsesoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInformeAsesoria findTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteInformeAsesoria.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteInformeAsesoria tramiteInformeAsesoriaAux = new TramiteInformeAsesoria();
		tramiteInformeAsesoriaAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteInformeAsesoriaAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteInformeAsesoriaAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteInformeAsesoriaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteInformeAsesoriaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteInformeAsesoriaAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteInformeAsesoriaAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteInformeAsesoriaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteInformeAsesoriaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteInformeAsesoriaAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteConciliacionEntrePartes
	 *            TramiteConciliacionEntrePartes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteConciliacionEntrePartes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteConciliacionEntrePartes findTramiteConciliacionEntrePartes(
			TramiteConciliacionEntrePartes tramiteConciliacionEntrePartes, CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteConciliacionEntrePartes.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteConciliacionEntrePartes tramiteConciliacionEntrePartesAux = new TramiteConciliacionEntrePartes();
		tramiteConciliacionEntrePartesAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteConciliacionEntrePartesAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteConciliacionEntrePartesAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteConciliacionEntrePartesAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteConciliacionEntrePartesAux.setInstructorEjecucion(instructorEjecucion);

		tramiteConciliacionEntrePartesAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteConciliacionEntrePartesAux.setFechaEnvioConvocatoria(tramitehecho.getEhfechaenvioconvocatoria());

		tramiteConciliacionEntrePartesAux.setFechaActoConciliacion(tramitehecho.getEhfechaconciliacion());
		tramiteConciliacionEntrePartesAux.setFechaFirmaAcuerdo(tramitehecho.getEhfechafirmaacuerdo());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteConciliacionEntrePartesAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteConciliacionEntrePartesAux.setTextoAcuerdo(Y41bUtils.clobToString(tramitehecho.getEhtextoacuerdo()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteConciliacionEntrePartesAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteConciliacionEntrePartesAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteConciliacionEntrePartesAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSolicitudInspeccion
	 *            TramiteSolicitudInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSolicitudInspeccion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteSolicitudInspeccion findTramiteSolicitudInspeccion(
			TramiteSolicitudInspeccion tramiteSolicitudInspeccion, CensoMonitor censoMonitor)
			throws SQLException, IOException {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteSolicitudInspeccion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteSolicitudInspeccion tramiteSolicitudInspeccionAux = new TramiteSolicitudInspeccion();
		tramiteSolicitudInspeccionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteSolicitudInspeccionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteSolicitudInspeccionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteSolicitudInspeccionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteSolicitudInspeccionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteSolicitudInspeccionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteSolicitudInspeccionAux.setPlazoRealizacion(tramitehecho.getEhplazoinspeccion());

		tramiteSolicitudInspeccionAux.setInspector(tramitehecho.getIncodigo());

		tramiteSolicitudInspeccionAux.setCoorinspeccion(tramitehecho.getEhcoorinspeccion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteSolicitudInspeccionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteSolicitudInspeccionAux.setInstrucciones(Y41bUtils.clobToString(tramitehecho.getEhinstrucinspecc()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteSolicitudInspeccionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteSolicitudInspeccionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteSolicitudInspeccionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteTrasladoRedCiac
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteTrasladoRedCiac findTramiteTrasladoRedCiac(TramiteTrasladoRedCiac tramiteTrasladoRedCiac,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteTrasladoRedCiac.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteTrasladoRedCiac tramiteTrasladoRedCiacAux = new TramiteTrasladoRedCiac();
		tramiteTrasladoRedCiacAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteTrasladoRedCiacAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteTrasladoRedCiacAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteTrasladoRedCiacAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteTrasladoRedCiacAux.setInstructorEjecucion(instructorEjecucion);

		tramiteTrasladoRedCiacAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteTrasladoRedCiacAux.setCodOrgTraslado(tramitehecho.getEhcoortraspaso());

		if (tramitehecho.getEhcoortraspaso() != null && !tramitehecho.getEhcoortraspaso().equals("")) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramitehecho.getEhcoortraspaso());

			organismo = this.organismoDao.findOrganismoKnet(organismo);

			tramiteTrasladoRedCiacAux.setNombreOrgTrasladoEs(organismo.getNombreEs());
			tramiteTrasladoRedCiacAux.setNombreOrgTrasladoEu(organismo.getNombreEu());
		}

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteTrasladoRedCiacAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteTrasladoRedCiacAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteTrasladoRedCiacAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteTrasladoRedCiacAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionTraslado
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionTraslado findTramiteRecepcionTraslado(TramiteRecepcionTraslado tramiteRecepcionTraslado,
			CensoMonitor censoMonitor) throws SQLException, IOException {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionTraslado.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionTraslado tramiteRecepcionTrasladoAux = new TramiteRecepcionTraslado();
		tramiteRecepcionTrasladoAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionTrasladoAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionTrasladoAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionTrasladoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionTrasladoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionTrasladoAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRecepcionTrasladoAux.setRespuesta(tramitehecho.getEhrespuestatraspaso());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionTrasladoAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteRecepcionTrasladoAux.setMotivoRechazo(Y41bUtils.clobToString(tramitehecho.getEhmotivorechazo()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionTrasladoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionTrasladoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionTrasladoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteEnviarSalidaSIR
	 *            TramiteEnviarSalidaSIR
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteEnviarSalidaSIR
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteEnviarSalidaSIR findTramiteEnviarSalidaSIR(TramiteEnviarSalidaSIR tramiteEnviarSalidaSIR,
			CensoMonitor censoMonitor) {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteEnviarSalidaSIR.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteEnviarSalidaSIR tramiteEnviarSalidaSIRAux = new TramiteEnviarSalidaSIR();
		tramiteEnviarSalidaSIRAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteEnviarSalidaSIRAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteEnviarSalidaSIRAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteEnviarSalidaSIRAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteEnviarSalidaSIRAux.setInstructorEjecucion(instructorEjecucion);

		tramiteEnviarSalidaSIRAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteEnviarSalidaSIRAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteEnviarSalidaSIRAux.setAsunto(tramitehecho.getEhasuntocomunicacion());

		UnidadesDir3 unidadesDir3 = new UnidadesDir3();
		unidadesDir3.setIdUnidadDir3(tramitehecho.getEhidunidaddir3());

		if (tramitehecho.getEhidunidaddir3() != null && !tramitehecho.getEhidunidaddir3().equals("")) {
			unidadesDir3 = this.unidadesDir3Dao.find(unidadesDir3);
		}

		tramiteEnviarSalidaSIRAux.setUnidadesDir3(unidadesDir3);

		tramiteEnviarSalidaSIRAux.setFechasalida(tramitehecho.getEhfecharegistrosalida());
		tramiteEnviarSalidaSIRAux.setNumregistrosalida(tramitehecho.getEhnumregistrosalida());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteEnviarSalidaSIRAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteEnviarSalidaSIRAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteEnviarSalidaSIRAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComunicacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteComunicacion tramiteComunicacionAux = new TramiteComunicacion();
		tramiteComunicacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteComunicacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteComunicacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteComunicacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteComunicacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteComunicacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteComunicacionAux.setFechaComunicacion(tramitehecho.getEhfechacomunicacion());

		tramiteComunicacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(tramitehecho));

		tramiteComunicacionAux.setSede(tramitehecho.getEhsede());

		tramiteComunicacionAux.setTipoComunicacion(tramitehecho.getEhtipocomunicacion());

		tramiteComunicacionAux.setFechasalida(tramitehecho.getEhfecharegistrosalida());

		tramiteComunicacionAux.setNumregistrosalida(tramitehecho.getEhnumregistrosalida());

		tramiteComunicacionAux.setAsuntoComunicacion(tramitehecho.getEhasuntocomunicacion());

		// Remesas Ini
		tramiteComunicacionAux.setEnvRemesaComunicacion(tramitehecho.getEhenvrem());
		if (tramitehecho.getEhcodrem() != null && !"".equals(tramitehecho.getEhcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(tramitehecho.getEhcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteComunicacionAux.setIdRemesaComunicacion(remesa.getRmcodigo());
			tramiteComunicacionAux.setFechaRemesaComunicacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteComunicacionAux.setIdmailorigen(tramitehecho.getEhidmailorigen());
		tramiteComunicacionAux.setMailorigen(tramitehecho.getEhmailorigen());
		tramiteComunicacionAux.setIdmaildestino(tramitehecho.getEhidmaildestino());
		tramiteComunicacionAux.setMaildestino(tramitehecho.getEhmaildestino());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteComunicacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteComunicacionAux.setTextoComunicacion(Y41bUtils.clobToString(tramitehecho.getEhtextocomunicacion()));

		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteComunicacionAux;
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return String
	 */
	private String calcularDestinatarioComunicacionNotificacion(TramiteHecho tramitehecho) {
		// Calcular el destinatario
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramitehecho.getEhestadotramite())) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramitehecho.getEhiddestinatario());

			intervinientes = this.intervinientesDao.find(intervinientes);

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null
					&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
				if (solDetalle.getHddestnotificareclamante() != null && solDetalle.getHddestnotificareclamante()
						.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

					// buscar el representante
					Intervinientes intervinientesAux = new Intervinientes();
					intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
					intervinientesAux
							.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
					intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

					if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
						return intervinientesAux.getIdinterviniente();
					} else {

						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
							return intervinientesAux.getIdinterviniente();
						} else {
							// Si no existe se pone como destinatario el titular
							return tramitehecho.getEhiddestinatario();
						}
					}

				} else {
					return tramitehecho.getEhiddestinatario();
				}

			} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
					&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
				if (solDetalle.getHddestnotificareclamado() != null && solDetalle.getHddestnotificareclamado()
						.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

					// buscar el representante
					Intervinientes intervinientesAux = new Intervinientes();
					intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
					intervinientesAux
							.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
					intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

					if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
						return intervinientesAux.getIdinterviniente();
					} else {
						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
							return intervinientesAux.getIdinterviniente();
						} else {
							// Si no existe se pone como destinatario el titular
							return tramitehecho.getEhiddestinatario();
						}
					}

				} else {
					return tramitehecho.getEhiddestinatario();
				}
			} else {
				return tramitehecho.getEhiddestinatario();
			}

		} else {
			return tramitehecho.getEhiddestinatario();
		}
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteNotificacion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteNotificacion tramiteNotificacionAux = new TramiteNotificacion();
		tramiteNotificacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteNotificacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteNotificacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteNotificacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteNotificacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteNotificacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteNotificacionAux.setFechaComunicacion(tramitehecho.getEhfechacomunicacion());

		tramiteNotificacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(tramitehecho));

		tramiteNotificacionAux.setSede(tramitehecho.getEhsede());

		tramiteNotificacionAux.setTipoNotificacion(tramitehecho.getEhtiponotificacion());

		tramiteNotificacionAux.setTipoNotificacionPlatea(tramitehecho.getEhtiponotificacionplatea());

		tramiteNotificacionAux.setFechasalida(tramitehecho.getEhfecharegistrosalida());

		tramiteNotificacionAux.setNumregistrosalida(tramitehecho.getEhnumregistrosalida());

		tramiteNotificacionAux.setIdnotificacionplatea(tramitehecho.getEhidnotificacionplatea());

		// Remesas Ini
		tramiteNotificacionAux.setEnvRemesaNotificacion(tramitehecho.getEhenvrem());
		if (tramitehecho.getEhcodrem() != null && !"".equals(tramitehecho.getEhcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(tramitehecho.getEhcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteNotificacionAux.setIdRemesaNotificacion(remesa.getRmcodigo());
			tramiteNotificacionAux.setFechaRemesaNotificacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteNotificacionAux.setComentario(tramiteHechoAux.getEhtexto());

		tramiteNotificacionAux.setTextoComunicacion(Y41bUtils.clobToString(tramitehecho.getEhtextocomunicacion()));

		if ((tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null)
				|| Y41bConstantes.VALOR_SI.equals(tramitehecho.getEhautomatico())) {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteNotificacionAux;
	}

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		RegistroEntrada registroEntrada = new RegistroEntrada();

		WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Intervinientes intervinientesDatos = new Intervinientes();
		intervinientesDatos.setIdinterviniente(intervinientes.getIdinterviniente());
		intervinientesDatos = this.intervinientesDao.find(intervinientesDatos);

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(intervinientesDatos.getNif())) {
			sbPerson.append(intervinientesDatos.getNif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(intervinientesDatos.getEsnoco())) {
			sbPerson.append(intervinientesDatos.getEsnoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(intervinientesDatos.getNombre())) {
				sbPerson.append(intervinientesDatos.getNombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesDatos.getApellido1())) {
				sbPerson.append(intervinientesDatos.getApellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesDatos.getApellido2())) {
				sbPerson.append(intervinientesDatos.getApellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		sbMatter.append("-");
		sbMatter.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

		registroEntrada.setRegistryNumber(wSInputRegister.getNumber());
		registroEntrada.setRegistryDate(wSInputRegister.getDate().toGregorianCalendar().getTime());

		return registroEntrada;
	}

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param tramiteComun
	 *            TramiteComun
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(Remesa remesa, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
		} else {
			if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			} else {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			}
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Intervinientes intervinientesAux = this.intervinientesDao.find(intervinientes);

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(intervinientesAux.getNif())) {
			sbPerson.append(intervinientesAux.getNif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(intervinientesAux.getEsnoco())) {
			sbPerson.append(intervinientesAux.getEsnoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(intervinientesAux.getNombre())) {
				sbPerson.append(intervinientesAux.getNombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				sbPerson.append(intervinientesAux.getApellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				sbPerson.append(intervinientesAux.getApellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();

		if (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION)) {
			sbMatter.append(Y41bConstantes.LITERAL_NOTIFICACION_ES);
		} else {
			sbMatter.append(Y41bConstantes.LITERAL_COMUNICACION_ES);
		}

		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		sbMatter.append("-");
		sbMatter.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

		RegistroSalida registroSalida = new RegistroSalida();

		registroSalida.setRegistryNumber(wSOutputRegister.getNumber());
		registroSalida.setRegistryDate(new Date());

		return registroSalida;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteSolicitudColaboracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSolicitudColaboracion
	 * @throws IOException
	 * @throws SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteSolicitudColaboracion findTramiteSolColaboracion(
			TramiteSolicitudColaboracion tramiteSolicitudColaboracion, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteSolicitudColaboracion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteSolicitudColaboracion tramiteSolicitudColaboracionAux = new TramiteSolicitudColaboracion();
		Organismo organismoAux = new Organismo();
		tramiteSolicitudColaboracionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteSolicitudColaboracionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteSolicitudColaboracionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteSolicitudColaboracionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteSolicitudColaboracionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteSolicitudColaboracionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteSolicitudColaboracionAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info Solicitud Colaboracin Ini
		tramiteSolicitudColaboracionAux.setFecha(tramitehecho.getEhfeccolabsol());
		tramiteSolicitudColaboracionAux.setMotivoSolicitud(tramitehecho.getEhcodmotivocolabsol());

		organismoAux.setCodOrg(tramitehecho.getEhidorganismocolabsol());

		organismoAux = this.organismoDao.findOrganismo(organismoAux);
		tramiteSolicitudColaboracionAux.setOrganismo(organismoAux);
		// Info Solicitud Colaboracin Fin

		tramiteSolicitudColaboracionAux
				.setResumensolicitud(Y41bUtils.clobToString(tramitehecho.getEhresumencolabsol()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteSolicitudColaboracionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteSolicitudColaboracionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteSolicitudColaboracionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaColaboracion
	 *            TramiteRespuestaColaboracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacionPresencial
	 * @throws IOException
	 * @throws SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRespuestaColaboracion findTramiteRespColaboracion(
			TramiteRespuestaColaboracion tramiteRespuestaColaboracion, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRespuestaColaboracion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRespuestaColaboracion tramiteRespuestaColaboracionAux = new TramiteRespuestaColaboracion();
		tramiteRespuestaColaboracionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRespuestaColaboracionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRespuestaColaboracionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRespuestaColaboracionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRespuestaColaboracionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRespuestaColaboracionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRespuestaColaboracionAux.setComentario(tramiteHechoAux.getEhtexto());

		// Info Respuesta Colaboracin Ini
		tramiteRespuestaColaboracionAux.setFecha(tramitehecho.getEhfeccolabresp());
		tramiteRespuestaColaboracionAux.setRespuesta(tramitehecho.getEhrespuestacolabresp());
		// Info Respuesta Colaboracin Fin

		tramiteRespuestaColaboracionAux
				.setResumenrespuesta(Y41bUtils.clobToString(tramitehecho.getEhresumencolabresp()));

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRespuestaColaboracionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRespuestaColaboracionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRespuestaColaboracionAux;
	}

	/**
	 * Create ejgv document for notificacion and comunication
	 * 
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param tipoNotificacionPlatea
	 *            String
	 * @param envRemesa
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacionComunicacion(
			String textoNotificacionComunicacion, String destinatario, String tipoNotificacionPlatea, String envRemesa,
			TramiteComun tramiteComun, CensoMonitor censoMonitor) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);

		intervinientes = this.intervinientesDao.find(intervinientes);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(intervinientes.getNif());

		StringBuffer nombreCompleto = new StringBuffer();
		nombreCompleto.append(intervinientes.getNombre());
		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido1());
		}
		if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido2());
		}

		datosPersonaSolicitante.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			datosPersonaSolicitante.setApellido1(intervinientes.getApellido1());
		}
		datosPersonaSolicitante.setMail(intervinientes.getCoem());
		datosPersonaSolicitante.setTelefono(intervinientes.getNrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		crearNotifEJGV.setIdTipoNotificacion(tipoNotificacionPlatea);
		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

		List<Documento> listDocumentos = new ArrayList<Documento>();
		Documento documento = null;

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {

				adjuntardocsAux = this.adjuntardocsDao.findAdjuntarDocs(adjuntardocsAux);

				if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					// crear el objeto DocumentoHecho
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
					documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
					documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
					documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
					documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
					tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

					documento = this.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// crear el objeto Sandoctemp
					Sandoctemp sandocTemp = new Sandoctemp();
					sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
					sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
					sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
					sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
					sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
					sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

					DocumentoHecho documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHechoAux.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHechoAux.getQ5tramite());

					documento = this.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// crear el objeto Sandoctemp
					Arbdoctemp arbdocTemp = new Arbdoctemp();
					arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					arbdocTemp.setArbtipdoc(arbtipdoc);
					arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
					arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
					arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
					arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
					arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

					DocumentoHecho documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHechoAux.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHechoAux.getQ5tramite());

					documento = this.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
						&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					// crear el objeto DocumentoHecho
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
					documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
					documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
					documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
					documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
					tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

					documento = this.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);

				}

				listDocumentos.add(documento);
			}
		}

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (Y41bUtils.isFilled(tipoNotificacionPlatea)) {
			respuestaEjgv = y41bPlateaAdapterService.crearEJGVDocumentNotificacion(crearNotifEJGV);
		} else {
			respuestaEjgv = y41bPlateaAdapterService.crearEJGVDocumentComunicacion(crearNotifEJGV);
		}

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return respuestaEjgv;
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {

		if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
			pagination.setSort("Q5FECHA");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
			pagination.setSort("Q5TEDESFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
			pagination.setSort("Q5NOFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
			pagination.setSort("Q5ORIGEN");
		}

		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.documentoHechoDao
				.findAllDocumentosHechoComunicacion(tramiteComun, pagination);

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (DocumentoHecho documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getQ5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosHechoComunicacionCount(tramiteComun);
	}

	/**
	 * Generar Tramite automatico de Recepcion de Orden del Consejero
	 * 
	 * @param tramitehechoInformeAsesoriaRel
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRecepcionOrdenConsejeroAutomatico(TramiteHecho tramitehechoInformeAsesoriaRel,
			TramiteComun tramiteComun) throws Exception {
		// Generar el tramite de elaboracion de informe de asesoria vinculado al
		// tramite de
		// recepcion de recurso
		// Creacion de tramite de elaboracion de informe de asesoria
		TramiteHecho tramitehechoAcuse = new TramiteHecho();
		tramitehechoAcuse.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAcuse.setEhcohd(tramiteComun.getIdExpediente());
		tramitehechoAcuse.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO);

		// Evita problemas con las fechas desde hasta
		tramitehechoAcuse.setEhfecha(tramitehechoInformeAsesoriaRel.getEhfecha());
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehechoAcuse.setEhhora(ehhora);
		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramitehechoAcuse.setEhfechainicio(tramitehechoInformeAsesoriaRel.getEhfecha());

		tramitehechoAcuse.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhtexto("");
		tramitehechoAcuse.setTramiteHecho(tramitehechoInformeAsesoriaRel);
		tramitehechoAcuse.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAcuse);
		return tramitehechoAcuse;
	}

	/**
	 * Generar Tramite automatico de Elaboracion de Informe de Asesoria
	 * 
	 * @param tramitehechoRecepRecRel
	 *            TramiteHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteInformeAsesoriaAutomatico(TramiteHecho tramitehechoRecepRecRel) throws Exception {
		// Generar el tramite de elaboracion de informe de asesoria vinculado al
		// tramite de
		// recepcion de recurso
		// Creacion de tramite de elaboracion de informe de asesoria
		TramiteHecho tramitehechoAcuse = new TramiteHecho();
		tramitehechoAcuse.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAcuse.setEhcohd(tramitehechoRecepRecRel.getEhcohd());
		tramitehechoAcuse.setEhcotee(Y41bConstantes.TRAMITE_ELABORACION_INFORME_ASESORIA);

		// Evita problemas con las fechas desde hasta
		tramitehechoAcuse.setEhfecha(tramitehechoRecepRecRel.getEhfecha());
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehechoAcuse.setEhhora(ehhora);
		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramitehechoAcuse.setEhfechainicio(tramitehechoRecepRecRel.getEhfecha());

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramitehechoRecepRecRel.getEhcohd());
		tramitehechoAcuse.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhtexto("");
		tramitehechoAcuse.setTramiteHecho(tramitehechoRecepRecRel);
		tramitehechoAcuse.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAcuse);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// En Denuncias de empresas se envia un email a los usuarios que son
		// administrativo en liquidaciones
		if (solDetalle != null && solDetalle.getHddenunciaaaccempresas() != null
				&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(tramitehechoAcuse.getEhcomoasignado());

			this.enviarEmailElaboracionInformeAsesoria(tramitehechoRecepRecRel.getEhcohd(), censoMonitor);
		}

		return tramitehechoAcuse;
	}

	/**
	 * Envia un email a los usuarios que son administrativo en liquidaciones
	 * 
	 * @param hdcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void enviarEmailElaboracionInformeAsesoria(String hdcodigo, CensoMonitor censoMonitor) {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
		censoMonitor = censoMonitorDao.find(censoMonitor);
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}
		String from = censoMonitor.getMocoem();

		CensoMonitor adminLiq = new CensoMonitor();
		adminLiq.setMoadmiliquidacion(Y41bConstantes.VALOR_SI);
		List<CensoMonitor> ladminLiq = censoMonitorDao.findAllCensoMonitorSanciones(adminLiq);
		StringBuffer destinatarios = new StringBuffer("");
		for (int i = 0; i < ladminLiq.size(); i++) {
			if (!Y41bUtils.esNullOCadenaVacia(ladminLiq.get(i).getMocoem())) {
				if (destinatarios.length() > 0) {
					destinatarios.append(";");
				}
				destinatarios.append(ladminLiq.get(i).getMocoem());
			}
		}
		if (!Y41bUtils.isFilled(destinatarios.toString())) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
		// 2. Creo el asunto
		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		SolicitudDetalle solDetalle = this.denunciaService.findSolicitud(solicitudDetalle, null);

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		numeroExpediente.append("-");
		numeroExpediente.append(solDetalle.getNumExpediente());

		StringBuffer asunto = new StringBuffer();
		// Castellano
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(numeroExpediente).append(" / ");
		// Euskera
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params = new String[1];
		params[0] = numeroExpediente.toString();
		texto.append("<B>").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento de
	 * Alegacion
	 * 
	 * @param tramiteRequerimientoAlegacion
	 *            TramiteRequerimientoAlegacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoReqAlegacion(
			TramiteRequerimientoAlegacion tramiteRequerimientoAlegacion, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRequerimientoAlegacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteRequerimientoAlegacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(tramiteRequerimientoAlegacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_ALEGACION);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde segunda mediacion
	 * 
	 * @param tramiteSegundaMediacion
	 *            TramiteSegundaMediacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoSegundaMediacion(
			TramiteSegundaMediacion tramiteSegundaMediacion, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteSegundaMediacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteSegundaMediacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(tramiteSegundaMediacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_ALEGACION);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de SegundaMediacion
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteSegundaMediacion(TramiteHecho tramitehecho, TramiteComun tramiteComun)
			throws Exception {

		TramiteHecho tramitehechoAux = new TramiteHecho();

		tramitehechoAux.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAux.setEhcohd(tramiteComun.getIdExpediente());
		tramitehechoAux.setEhcotee(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehechoAux.setEhfecha(todayWithZeroTime);
		tramitehechoAux.setEhhora(ehhora);
		tramitehechoAux.setEhfechainicio(todayWithZeroTime);

		tramitehechoAux.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAux.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAux.setEhtexto("");

		// Origen del tramite que lo origina
		tramitehechoAux.setEhorigenalegacion(tramitehecho.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehechoAux.setTramiteHecho(tramitehecho);

		tramitehechoAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAux);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Alegacion desde Requerimiento de Alegacion
	 * 
	 * @param tramitehechoReqAlegacion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteAlegacionAutomaticoReqAlegacion(TramiteHecho tramitehechoReqAlegacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ALEGACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(tramitehechoReqAlegacion.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(tramitehechoReqAlegacion);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de RespuestaSegundaMediacion desde
	 * SegundaMediacion
	 * 
	 * @param tramitehechoSegundaMediacion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRespuestaSegundaMediacionAutomaticoSegundaMediacion(
			TramiteHecho tramitehechoSegundaMediacion, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_SEGUNDA_MEDIACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(tramitehechoSegundaMediacion.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(tramitehechoSegundaMediacion);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento de
	 * Informacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoReqInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRequerimientoInformacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteRequerimientoInformacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(tramiteRequerimientoInformacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_REQUERIMIENTO);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Recepción Informacion desde Requerimiento
	 * de Informacion
	 * 
	 * @param tramitehechoReqInformacion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRecInformacionAutomaticoReqInformacion(TramiteHecho tramitehechoReqInformacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");
		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(tramitehechoReqInformacion.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(tramitehechoReqInformacion);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento de
	 * Acreditacion Representacion
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoReqAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));

		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO
						.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE
				.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_REQUERIMIENTO);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Recepción Informacion desde Requerimiento
	 * de Acreditacion Representacion
	 * 
	 * @param tramitehechoReqAcreditacionRepresentacion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRecInformacionAutomaticoReqAcreditacionRepresentacion(
			TramiteHecho tramitehechoReqAcreditacionRepresentacion, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");
		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(tramitehechoReqAcreditacionRepresentacion.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(tramitehechoReqAcreditacionRepresentacion);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Recepcin Subsanacin desde Requerimiento
	 * de Subsanacion
	 * 
	 * @param tramitehechoReqSubsanacion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRecSubsanacionAutomaticoReqSubsanacion(TramiteHecho tramitehechoReqInformacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_SUBSANACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");
		// Origen del tramite que lo origina
		tramitehecho.setEhorigenalegacion(tramitehechoReqInformacion.getEhorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramitehecho.setTramiteHecho(tramitehechoReqInformacion);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Subsanacion
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));

		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_SUBSANACION);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Orden Consejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Traslado Red Ciac
	 * 
	 * @param tramitehechoTraslado
	 *            TramiteHecho
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoTrasladoRedCiac(TramiteHecho tramitehechoTraslado,
			TramiteTrasladoRedCiac tramiteTrasladoRedCiac) throws Exception {

		TramiteHecho tramitehechoAux = new TramiteHecho();

		tramitehechoAux.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAux.setEhcohd(tramitehechoTraslado.getEhcohd());
		tramitehechoAux.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehechoAux.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehechoAux.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehechoAux.setEhhora(ehhora);
		tramitehechoAux.setEhfechainicio(todayWithZeroTime);

		tramitehechoAux.setEhcomoasignado(tramiteTrasladoRedCiac.getInstructorAsignado().getMocodigo());
		tramitehechoAux.setEhcomo(tramiteTrasladoRedCiac.getInstructorAsignado().getMocodigo());
		tramitehechoAux.setEhtexto("");

		tramitehechoAux.setEhfechacomunicacion(todayWithZeroTime);

		// Buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramitehechoTraslado.getEhcohd());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehechoAux.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehechoAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		tramitehechoAux.setTramiteHecho(tramitehechoTraslado);

		// 1.1 Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAux);

		if (Y41bUtils.isFilled(tramitehechoAux.getEhiddestinatario())) {
			// 1.2 Hay que relacionar los documentos de la decision con
			// el tramite de notificacion al reclamado
			// Recupero los documentos al reclamado
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(tramitehechoTraslado.getEhcohd());
			documentoHechoAux.setQ5tramite(tramitehechoTraslado.getEhcodigo());
			List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
			// Relaciono tramite - documento
			if (documentosdecision != null && documentosdecision.size() > 0) {
				DocumentoTramiteHecho documentoTramiteHecho = null;
				for (DocumentoHecho documentodecision : documentosdecision) {
					if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_TRASLADOCIAC_RECLAMANTE)) {
						documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramitehechoAux.getEhcodigo());
						documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehechoAux);

		return tramitehechoAux;
	}

	/**
	 * Generar Tramite BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteBOPV_AYTO(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			TramiteComun tramiteComun) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_BOPV_AYTO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Asignacion Instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoAsignacionInstructor(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		logger.debug("###################tramiteComun.getIdTramite()2[" + tramiteComun.getIdTramite() + "]");
		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		logger.debug("###################INICIO GRABAR TRAMITE COMUNICACION");
		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);
		logger.debug("###################FIN GRABAR TRAMITE COMUNICACION");

		tramiteComun.setIdTramite(tramitehecho.getEhcodigo());

		logger.debug("###################INICIO GENERAR PLANTILLA COMUNICACION");
		this.insertarPlantillaComunicacion(tramiteComun);
		logger.debug("###################FIN GENERAR PLANTILLA COMUNICACION");

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Metodo que inserta la ficha reducida en el tramite de registro de
	 * solicitud para solicitudes WEB
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void insertarPlantillaComunicacion(TramiteComun tramiteComun) throws Exception {
		try {
			logger.debug("###################INICIO COMBINAR PLANTILLA COMUNICACION");
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = this
					.findPlantillaTramiteHechoDetalle(tramiteComun);

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String rutaRTF = prop.getProperty("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = prop.getProperty("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_INICIO_CONS_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO;

			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaTramiteHechoDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// buscar la solicitud
			SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
			solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);

			StringBuffer nombreFichero = new StringBuffer();

			nombreFichero.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
					.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
					.append(solDetalle.getHdnror());

			nombreFichero.append("-").append(Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_INICIO_CONS_RTF);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(String.valueOf(this.denunciaService.getNewPKDocumentoHecho().intValue()));
			documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
			documentoHecho.setQ5nofile(nombreFichero.toString());
			Blob blob = new SerialBlob(bytesFichero);
			documentoHecho.setQ5datafile(blob);
			documentoHecho.setQ5sizefile(bytesFichero.length);
			documentoHecho
					.setQ5tedesfile(Y41bUtils.getNameFile(Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_INICIO_CONS_RTF));
			documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
			documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
			documentoHecho.setQ5fecha(new Date());
			documentoHecho.setQ5contenttypefile("application/msword");

			documentoHecho.setQ5fechaaportacion(new Date());
			documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_COMUNICACION);
			this.documentoHechoDao.add(documentoHecho);

			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
			documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
			documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

			logger.debug("###################FIN COMBINAR PLANTILLA COMUNICACION");

			logger.debug("###################INICIO REGISTRAR DOKUSI PLANTILLA COMUNICACION");
			this.registrarDocumentosDokusiSol(documentoHecho, tramiteComun);
			logger.debug("###################FIN REGISTRAR DOKUSI PLANTILLA COMUNICACION");
		} catch (Exception e) {
			logger.error("insertarPlantillaComunicacion ERROR ***** ", e);
			throw e;
		}
	}

	/**
	 * Finds PlantillaTramiteHechoDetalle.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHechoDetalle(TramiteComun tramiteComun) throws Exception {
		// Obtener los datos de la solicitud
		PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = new PlantillaTramiteHechoDetalle();
		plantillaTramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		plantillaTramiteHechoDetalle = this.tramiteHechoDao.findPlantillaTramiteHecho(plantillaTramiteHechoDetalle);

		plantillaTramiteHechoDetalle.setEhfecha(new Date());

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solicitudDetalle);
		plantillaTramiteHechoDetalle.setHdte(solDetalleAux.getHdte());

		if (plantillaTramiteHechoDetalle != null && plantillaTramiteHechoDetalle.getHdte() != null) {
			plantillaTramiteHechoDetalle.setHdte(Y41bStringUtils.unescapeHTML(
					Y41bUtils.eliminarTags(plantillaTramiteHechoDetalle.getHdte().replaceAll("\n", "&lineSeparator;")
							.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;")),
					0));
		}

		if (plantillaTramiteHechoDetalle != null && plantillaTramiteHechoDetalle.getHdteso() != null) {
			plantillaTramiteHechoDetalle.setHdteso(Y41bStringUtils.unescapeHTML(
					Y41bUtils.eliminarTags(plantillaTramiteHechoDetalle.getHdteso().replaceAll("\n", "&lineSeparator;")
							.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;")),
					0));
		}

		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		plantillaTramiteHechoDetalle.setFechaHoy(todayWithZeroTime);

		//

		plantillaTramiteHechoDetalle = this.denunciaService
				.completeInfoPlantillaTramiteHechoDetalle(plantillaTramiteHechoDetalle);

		return plantillaTramiteHechoDetalle;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Alegacion
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoAlegacion(TramiteAlegacion tramiteAlegacion,
			TramiteComun tramiteComun) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteAlegacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteAlegacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(tramiteAlegacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		}
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Alegacion
	 * 
	 * @param tramiteRespuestaSegundaMediacion
	 *            TramiteRespuestaSegundaMediacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoRespuestaSegundaMediacion(
			TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacion, TramiteComun tramiteComun)
			throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRespuestaSegundaMediacion.getOrigen())
				&& Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(tramiteRespuestaSegundaMediacion.getOrigen())) {
			// Si el origen es reclamado -> destinatario = reclamante
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(tramiteRespuestaSegundaMediacion.getOrigen())) {
			// Si el origen es reclamante -> destinatario = reclamado
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO;
		}
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Alegacion
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoInformeAsesoria(
			TramiteInformeAsesoria tramiteInformeAsesoria, TramiteComun tramiteComun) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos del informe de asesoria con el
		// tramite de comunicacion
		// 1. Recupero los documentos
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosinformeasesoria = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// 2. Relaciono tramite - documento
		if (documentosinformeasesoria != null && documentosinformeasesoria.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentoinformeasesoria : documentosinformeasesoria) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentoinformeasesoria.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro de Decision
	 * para traslado a Otros
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionOtrosRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		tramitehecho.setEhiddestinatario(intervinientes.getIdinterviniente());

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION); // JJ

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// 1.2 Hay que relacionar los documentos de la decision con
		// el tramite de notificacion a otros
		// Recupero los documentos para otros
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_OTROS)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro Decision.
	 * Genera 2 tramites de notificacion: Reclamante + Reclamado
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionAutomaticoRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun) throws Exception {

		if (tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_ARCHIVO_QUEJA)) {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			// Para Registro de decisin de Sin infraccin
			// en
			// Denuncias de empresas
			// No generar trmite de comunicacin al demandado posterior
			if (Y41bConstantes.DECISION_SIN_INFRACCION_DENUNCIA.equals(tramiteRegistroDecision.getTipoDecision())
					&& solDetalle != null && solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {

			} else {
				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
				tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

				tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

				// Evita problemas con las fechas desde hasta
				Locale locale = LocaleContextHolder.getLocale();
				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
				tramitehecho.setEhfecha(todayWithZeroTime);
				// La hora Ini
				String ehhora = null;
				try {
					Calendar todayCalendar = Calendar.getInstance();
					todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
					ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
				} catch (ParseException e) {
					ehhora = null;
				}
				// La hora Fin

				tramitehecho.setEhfecha(todayWithZeroTime);
				tramitehecho.setEhhora(ehhora);
				tramitehecho.setEhfechainicio(todayWithZeroTime);

				tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
				tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
				tramitehecho.setEhtexto("");

				tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

				TramiteHecho tramitehechoRel = new TramiteHecho();
				tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
				tramitehecho.setTramiteHecho(tramitehechoRel);

				tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

				// buscar el interviniente reclamado
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

				if (listIntervinientes != null && listIntervinientes.size() > 0) {
					tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
					// 1.1 Se inserta el tramite para la comunicacion al
					// reclamado
					this.tramiteHechoService.addTramiteHecho(tramitehecho);

					// 1.2 Hay que relacionar los documentos de la decision con
					// el tramite de notificacion al reclamado
					// Recupero los documentos al reclamado
					DocumentoHecho documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
					documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
					List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
					// Relaciono tramite - documento
					if (documentosdecision != null && documentosdecision.size() > 0) {
						DocumentoTramiteHecho documentoTramiteHecho = null;
						for (DocumentoHecho documentodecision : documentosdecision) {
							if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_RECLAMADO)) {
								documentoTramiteHecho = new DocumentoTramiteHecho();
								documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
								documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
								documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
								this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
							}
						}
					}

					this.calcularEstadoTramiteGenerado(tramitehecho);
				}
			}
		} else if (tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_APERCIBIMIENTO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_APERCIBIMIENTO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_APERCIBIMIENTO_RECLAMACION)) {

			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);
			tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);// JJ

			tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramitehecho.setEhfecha(todayWithZeroTime);
			// La hora Ini
			String ehhora = null;
			try {
				Calendar todayCalendar = Calendar.getInstance();
				todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
				ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}
			// La hora Fin

			tramitehecho.setEhfecha(todayWithZeroTime);
			tramitehecho.setEhhora(ehhora);
			tramitehecho.setEhfechainicio(todayWithZeroTime);

			tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
			tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
			tramitehecho.setEhtexto("");

			tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

			TramiteHecho tramitehechoRel = new TramiteHecho();
			tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
			tramitehecho.setTramiteHecho(tramitehechoRel);

			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			// buscar el interviniente reclamado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
				// 1.1 Se inserta el tramite para la comunicacion al
				// reclamado
				this.tramiteHechoService.addTramiteHecho(tramitehecho);

				// 1.2 Hay que relacionar los documentos de la decision con
				// el tramite de notificacion al reclamado
				// Recupero los documentos al reclamado
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
				documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
				List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
				// Relaciono tramite - documento
				if (documentosdecision != null && documentosdecision.size() > 0) {
					DocumentoTramiteHecho documentoTramiteHecho = null;
					for (DocumentoHecho documentodecision : documentosdecision) {
						if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_RECLAMADO)) {
							documentoTramiteHecho = new DocumentoTramiteHecho();
							documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
							documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
							documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
							this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
						}
					}
				}

				this.calcularEstadoTramiteGenerado(tramitehecho);
			}
		}

		boolean noComunicacionNiNotificacionConsumidor = false;
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());

		if (tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_APERCIBIMIENTO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_APERCIBIMIENTO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_APERCIBIMIENTO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_DESISTIMIENTO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_ARREPENTIM_COMPRA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_ARREPENTIM_COMPRA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_ARREPENTIM_COMPRA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INADMISION_DANOS_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INADMISION_DANOS_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_DANOS_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_NO_CONSUMO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INADMISION_NO_CONSUMO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_NO_CONSUMO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_NO_GARANTIA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_NO_GARANTIA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_NO_GARANTIA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_OPCION_REPARACION_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_OPCION_REPARACION_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_OPCION_REPARACION_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_AESA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_AESA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_AESA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_OTROS_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_OTROS_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INHIBICION_OTROS_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_SEGUROS_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_SEGUROS_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INHIBICION_SEGUROS_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INHIBICION_TRANSPORTE_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_TRANSPORTE_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INHIBICION_TRANSPORTE_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_LOCALIZADO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_LOCALIZADO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_LOCALIZADO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_SUBSANACION_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_SUBSANACION_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_SUBSANACION_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_PROPUESTA_ARBITRAJE_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_SIN_INFRACCION_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_TRASLADO_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_TRASLADO_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_TRASLADO_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INHIBICION_BANCA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INADMISION_TIQUE)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_INADMISION_RECLAMACION_DUPLICADA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_INADMISION_GENERAL)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_ARCHIVO_DENUNCIA)) {
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);
			tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);// JJ
			tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);
		} else if (tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_AVENENCIA_PARCIAL_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_NO_AVENENCIA_RECLAMACION)
				|| tramiteRegistroDecision.getTipoDecision().equals(Y41bConstantes.DECISION_ARCHIVO_QUEJA)) {
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);
			tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);
		} else if (tramiteRegistroDecision.getTipoDecision()
				.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_DENUNCIA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_QUEJA)
				|| tramiteRegistroDecision.getTipoDecision()
						.equals(Y41bConstantes.DECISION_RECLAMANTE_NO_ALEGACIONES_RECLAMACION)) {
			noComunicacionNiNotificacionConsumidor = true;
		} else {
			noComunicacionNiNotificacionConsumidor = true;
		}

		if (!noComunicacionNiNotificacionConsumidor) {
			// buscar el interviniente reclamante
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
				tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

				// Evita problemas con las fechas desde hasta
				Locale locale = LocaleContextHolder.getLocale();
				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
				tramitehecho.setEhfecha(todayWithZeroTime);
				// La hora Ini
				String ehhora = null;
				try {
					Calendar todayCalendar = Calendar.getInstance();
					todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
					ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
				} catch (ParseException e) {
					ehhora = null;
				}
				// La hora Fin

				tramitehecho.setEhfecha(todayWithZeroTime);
				tramitehecho.setEhhora(ehhora);
				tramitehecho.setEhfechainicio(todayWithZeroTime);

				tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
				tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
				tramitehecho.setEhtexto("");

				tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

				TramiteHecho tramitehechoRel = new TramiteHecho();
				tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
				tramitehecho.setTramiteHecho(tramitehechoRel);

				tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

				// 2.1 Se inserta el tramite para la comunicacion al reclamante
				this.tramiteHechoService.addTramiteHecho(tramitehecho);

				// 2.2 Hay que relacionar los documentos de la decision con
				// el tramite de notificacion al reclamante
				// Recupero los documentos al reclamante
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
				documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
				List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
				// Relaciono tramite - documento
				if (documentosdecision != null && documentosdecision.size() > 0) {
					DocumentoTramiteHecho documentoTramiteHecho = null;
					for (DocumentoHecho documentodecision : documentosdecision) {
						if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_RECLAMANTE)) {
							documentoTramiteHecho = new DocumentoTramiteHecho();
							documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
							documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
							documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
							this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
						}
					}
				}

				this.calcularEstadoTramiteGenerado(tramitehecho);
			}
		}
		return tramitehecho;
	}

	/**
	 * Generar Tramite Generico de reapertura de expediente
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteGenericoReabrirExpediente(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(solicitudDetalle.getHdcodigo());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_GENERICO);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhfechafin(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(censoMonitor.getMocodigo());
		tramitehecho.setEhcomoejecucion(censoMonitor.getMocodigo());
		tramitehecho.setEhcomo(censoMonitor.getMocodigo());

		tramitehecho.setEhnombretramite(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_REAPERTURA);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Asignacion de Instructor desde el Tramite
	 * de Recepcion de Consejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteAsignacionInstructorAutomaticoRecepcConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero) throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteRecepcionOrdenConsejero.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_3);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramiteRecepcionOrdenConsejero.getIdExpediente());
		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Asignacion de Instructor
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteAsignacionInstructorAutomatico(SolicitudDetalle solicitudDetalle)
			throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(solicitudDetalle.getHdcodigo());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(solicitudDetalle.getMocodigo());
		tramitehecho.setEhcomo(solicitudDetalle.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramitehechoNotifRel
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteAcuseReciboAutomatico(String idEspera, TramiteHecho tramitehechoNotifRel,
			TramiteComun tramiteComun) throws Exception {
		// Generar el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		// Creacion de tramite de registro de solicitud tramitado
		TramiteHecho tramitehechoAcuse = new TramiteHecho();
		tramitehechoAcuse.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAcuse.setEhcohd(tramiteComun.getIdExpediente());
		tramitehechoAcuse.setEhcotee(Y41bConstantes.TRAMITE_ACUSE_RECIBO);

		// Evita problemas con las fechas desde hasta
		tramitehechoAcuse.setEhfecha(tramitehechoNotifRel.getEhfecha());
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehechoAcuse.setEhhora(ehhora);
		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramitehechoAcuse.setEhfechainicio(tramitehechoNotifRel.getEhfecha());

		tramitehechoAcuse.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehechoAcuse.setEhtexto("");
		tramitehechoAcuse.setTramiteHecho(tramitehechoNotifRel);
		tramitehechoAcuse.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// tratamos el idEspera pasado por parametro
		if (Y41bUtils.isFilled(idEspera)) {
			tramitehechoAcuse.setEhidesperaplatea(idEspera);
			tramitehechoAcuse.setEhmatarespera(Y41bConstantes.NO);
		}

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAcuse);
		return tramitehechoAcuse;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Solicitud colaboracin
	 * otro organismo
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteNotificacionSolColaboracion(
			TramiteSolicitudColaboracion tramiteSolicitudColaboracion, TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_NOTIFICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehecho.setEhtiponotificacionplatea(Y41bConstantes.NOTIFICACION_REQUERIMIENTO);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Respuesta de la colaboracin otro organismo
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteRespuestaColaboracion(TramiteSolicitudColaboracion tramiteSolicitudColaboracion,
			TramiteComun tramiteComun) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();

		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfeccolabresp(todayWithZeroTime);

		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		this.calcularEstadoTramiteGenerado(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Metodo que manda un email con la información de comunicacion recibida
	 * por parámetro.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	private boolean envioEmailComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			List<Adjuntardocs> listadjuntardocs, CensoMonitor censoMonitor)
			throws SerialException, SQLException, Exception {
		DocumentoHechoDetalle documentoHechoDetalle = null;
		try {
			// 1. Calculo FROM + TO del email

			String from = tramiteComunicacion.getMailorigen();

			String destinatariosMail = "";

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramiteComunicacion.getDestinatario());

			intervinientes = this.intervinientesDao.find(intervinientes);

			if (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
					|| intervinientes.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_ESTABLECIMIENTO)) {
				destinatariosMail = tramiteComunicacion.getMaildestino();
			} else {
				destinatariosMail = intervinientes.getCoem();
			}

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}

			StringBuffer destinatarios = new StringBuffer();
			destinatarios.append(destinatariosMail);

			StringBuffer copiaoculta = new StringBuffer();
			copiaoculta.append(censoMonitor.getMocoem());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			// 2. Creo el asunto
			// Calculo el numero de expediente
			// Obtener el numero de expediente
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
					.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
					.append(solDetalle.getHdnror());

			StringBuffer asunto = new StringBuffer();
			if (Y41bUtils.isFilled(tramiteComunicacion.getAsuntoComunicacion())) {
				asunto.append(tramiteComunicacion.getAsuntoComunicacion());
			} else {
				// Castellano
				asunto.append(appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
			}

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer();
			texto.append("<B>").append(appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ").append(
					appMessageSource.getMessage("comunicacion.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
					.append("</B><BR><BR>");
			texto.append(tramiteComunicacion.getTextoComunicacion().replaceAll("\n", "<BR>"));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					PlantillaTramite plantillaTramite = null;
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
					}

					if (Y41bUtils.isDocumentoLocalizable(adjuntardocs)) {
						if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocs.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocs != null && adjuntardocs.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocs.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}

					AttachFile fileattach = new AttachFile();
					documentoHechoDetalle = new DocumentoHechoDetalle();
					documentoHechoDetalle.setQ5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

					fileattach.setContentType(documentoHechoDetalle.getQ5contenttypefile());
					fileattach.setNombre(documentoHechoDetalle.getQ5nofile());
					fileattach.setAdjunto(documentoHechoDetalle.getQ5datafile());

					attachments.add(fileattach);
				}
			}

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), copiaoculta.toString(), attachments);

			return envio;
		} finally {

		}
	}

	/**
	 * Metodo que crea un zip con nombre zipName, y comprime los documentos del
	 * tramite del expediente
	 * 
	 * @param zipName
	 *            String
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean true si hay ficheros en el zip / false si no hay ficheros
	 *         en el zip
	 */
	public boolean crearZipDocumentosExpediente(String zipName, List<Adjuntardocs> listadjuntardocs,
			TramiteComun tramiteComun) {

		DocumentoHechoDetalle documentoHechoDetalle = null;
		boolean zipConFicheros = true;
		boolean zipSinFicheros = false;
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Ej. /datos/y41b/tmp/zip/
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		String strZipDirectory = strTmpZipDirectory + zipName;
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strZipFile = strTmpZipDirectory + zipName + Y41bConstantes.EXTENSION_ZIP;
		try {
			// 1. Validamos que exista el directorio TMP para los ZIP. Si no
			// existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
			// 2. Validamos que exista el directorio TMP para el ZIP actual. Si
			// no existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strZipDirectory);
			// 3. Creamos el ZIP
			Y41bFicheroUtils.crearFichero(new File(strZipFile));

			// ******* Borramos historico de ficheros con mas de 1 minuto
			// (60000ms) de
			// diferencia en la fecha de creacion
			Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), 60000);

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				String nombreFichero = null;
				InputStream ficheroStream = null;
				File fileFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {

					documentoHechoDetalle = new DocumentoHechoDetalle();
					documentoHechoDetalle.setQ5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile());
					ficheroStream = documentoHechoDetalle.getQ5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if (local.equals("true")) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				// 5. Comprimimos el directorio del zip en el fichero zip que
				// hemos creado
				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);

				// 8.1. Hay ficheros en el zip
				return zipConFicheros;
			} else {
				// 8.2.1. Eliminamos el zip vacio (no sirve de nada)
				Y41bFicheroUtils.deleteFile(new File(strZipFile));
				// 8.2.2. No hay ficheros en el zip
				return zipSinFicheros;
			}
		} catch (Exception e) {
			logger.error("crearZipDocumentosExpediente ERROR ***** ", e);
			// Eliminamos el zip vacio si existe
			Y41bFicheroUtils.deleteFile(new File(strZipFile));
			throw new Y41bUDAException("error.zip.crearZipDocumentosExpediente", true, new Exception());
		} finally {

			// 6. Borramos el directorio temporal del ZIP y su contenido
			File directoryToDelete = new File(strZipDirectory);
			if (directoryToDelete.exists()) {
				Y41bFicheroUtils.deleteDirectory(directoryToDelete);
			}
			if (directoryToDelete.exists()) {
				directoryToDelete.delete();
			}
		}
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite de
	 * alegacion con el parametro recibido
	 * 
	 * @param origen
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void actualizarOrigenDocsTramiteAlegacion(TramiteComun tramiteComun, String origen) {
		String origen_doc = "";
		if (Y41bUtils.isFilled(origen) && Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO.equals(origen)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO;
		} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE.equals(origen)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE;
		}
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setQ5origen(origen_doc);
				this.documentoHechoDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite
	 * acuse de recibo con el parametro recibido
	 * 
	 * @param origen
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void actualizarOrigenDocsTramiteAcuseRecibo(TramiteComun tramiteComun, String destinatario) {
		String origen_doc = "";
		// Calculamos el origen del documento adjunto en el acuse a
		// partir del destinatario del tramite de notificacion
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);
		intervinientes = this.intervinientesDao.find(intervinientes);
		String tipo_interviniente = intervinientes.getTipoInterviniente();
		if (Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO;
		} else if (Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO;
		} else {
			origen_doc = Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS;
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setQ5origen(origen_doc);
				this.documentoHechoDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Metodo que procesa la tramitacion de la comunicacin e informa a mis
	 * gestiones
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void tratamientoComunicacion(TramiteHecho tramitehecho, TramiteComun tramiteComun) throws Exception {
		// Si es un tramite de comunicacion, relacionada con un traslado
		// Borramos la bandeja de solicitudes, ya que ya no es de la gestion
		// del
		// usuario
		TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

		try {
			if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
					&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {
				TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
				tramiteHechoDet.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
				TrasladoBusqueda trasladoBusqueda = this.trasladoDao.findTrasladoTramite(tramiteHechoDet);

				if (trasladoBusqueda != null && trasladoBusqueda.getIhcodigo() != null
						&& !trasladoBusqueda.getIhcodigo().equals("")) {
					// Cerramos el expediente en PLATEA
					// Obtengo la información del expediente
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

					SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

					if (solDetalle != null && solDetalle.getHccoor() != null
							&& (!solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)
									&& !solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)
									&& !solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA))) {
						// borrar los tramites del expediente en la bandeja
						BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
						bandejasolicitudes.setHdcodigo(tramiteComun.getIdExpediente());

						this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);

						StringBuffer numeroExpediente = new StringBuffer();

						numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-")
								.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
								.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

						CierreExpediente cierreExpediente = new CierreExpediente();
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
						cierreExpediente.setProcedure(procedure);
						cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
						cierreExpediente.setEjercicio(solDetalle.getDenran().toString());

						y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
					}
				}
			}
		} catch (EmptyResultDataAccessException e) {
		}

		if (tramitehecho.getEhtipocomunicacion() != null
				&& (tramitehecho.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
						|| tramitehecho.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA))) {
			if (tramitehecho.getEhenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getEhenvrem())) {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(tramitehecho.getEhiddestinatario());

				intervinientes = this.intervinientesDao.find(intervinientes);

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null
						&& (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
								|| intervinientes.getTipoInterviniente()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
								|| intervinientes.getTipoInterviniente().equals(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

					if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
							&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

						tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
						tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
						if (tramitehechoAux.getEhcotee() != null
								&& tramitehechoAux.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
							this.actualizarMisGestionesRegistroDecisionReclamante(tramitehechoAux);
						} else if (tramitehechoAux.getEhcotee() != null && tramitehechoAux.getEhcotee()
								.equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION)) {
							this.actualizarMisGestionesRequerimientoSubsanacionConsumidor(tramitehechoAux);
						}
					}

					List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
							.findAllDocumentosTramite(tramiteComun, null);

					this.actualizarMisGestionesComunicacionReclamante(tramitehecho, listDocumentoHecho);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
						&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
								|| intervinientes.getTipoInterviniente()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
								|| intervinientes.getTipoInterviniente().equals(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

					if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
							&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

						tramitehechoAux.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
						tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAux);
						if (tramitehechoAux.getEhcotee() != null
								&& tramitehechoAux.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
							this.actualizarMisGestionesRegistroDecisionReclamado(tramitehechoAux);
						}
					}

					List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
							.findAllDocumentosTramite(tramiteComun, null);

					this.actualizarMisGestionesComunicacionReclamado(tramitehecho, listDocumentoHecho);

				}
			}
		} else if (tramitehecho.getEhtipocomunicacion() != null
				&& tramitehecho.getEhtipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO)) {
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramitehecho.getEhiddestinatario());

			intervinientes = this.intervinientesDao.find(intervinientes);

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null
					&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
							|| intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
							|| intervinientes.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {
				this.crearParticipacionMisGestionesReclamado(tramitehecho);
			}

		}

	}

	/**
	 * Metodo que procesa el envio de una comunicacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarComunicacionElectronica(List<DocumentoHecho> listDocumentoHecho,
			TramiteComunicacion tramiteComunicacion, TramiteHecho tramitehecho, CensoMonitor censoMonitor)
			throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		String textoNotificacionComunicacion = tramiteComunicacion.getTextoComunicacion();
		String destinatario = tramiteComunicacion.getDestinatario();
		String envRemesa = tramiteComunicacion.getEnvRemesaComunicacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getEhcohd(),
				tramitehecho.getEhcodigo(), Y41bConstantes.NOTIFICACION_COMUNICACION, textoNotificacionComunicacion,
				destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// update tramite campo idnotificacionplatea
		tramitehecho.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		this.tramiteHechoDao.updateIdNotificacionPlatea(tramitehecho);

		// recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setEhnumregistrosalida(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setEhfecharegistrosalida(
				Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));
		this.tramiteHechoDao.updateRegistroSalidaPlatea(tramitehecho);
	}

	/**
	 * Metodo que crea el objeto CrearNotifEJGV para envio de
	 * notificacin/comunicacin electrnica
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoNotificacion
	 *            String
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param envRemesa
	 *            String
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CrearNotifEJGV
	 * @throws Exception
	 */
	private CrearNotifEJGV crearObjetoCrearNotifEJGV(String idExpediente, String idTramite, String idTipoNotificacion,
			String textoNotificacionComunicacion, String destinatario, String envRemesa,
			List<DocumentoHecho> listDocumentoHecho, CensoMonitor censoMonitor) throws Exception {

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());

		// Obtener el expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(idExpediente);

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {
			crearNotifEJGV.setIdiomaNotificacion(solDetalle.getHdidioma());
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {
			crearNotifEJGV.setIdiomaNotificacion(solDetalle.getHdidiomareclamado());
		} else {
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);
		}

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(intervinientes.getNif());

		StringBuffer nombreCompleto = new StringBuffer();
		nombreCompleto.append(intervinientes.getNombre());
		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido1());
		}
		if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido2());
		}

		datosPersonaSolicitante.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			datosPersonaSolicitante.setApellido1(intervinientes.getApellido1());
		}
		datosPersonaSolicitante.setMail(intervinientes.getCoem());

		// Mail de notificacion del establecimiento
		if (Y41bUtils.isFilled(intervinientes.getEscodigo())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(intervinientes.getEscodigo());
			establecimiento = this.establecimientoDao.find(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

			if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
				datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
			} else if (Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
				datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
			}
		}

		datosPersonaSolicitante.setTelefono(intervinientes.getNrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		crearNotifEJGV.setIdTipoNotificacion(idTipoNotificacion);

		List<Documento> listDocumentos = this.registrarDocumentosDokusi(listDocumentoHecho, null);

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return crearNotifEJGV;
	}

	/**
	 * Metodo que procesa el envio de una notificacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarNotificacionElectronica(List<DocumentoHecho> listDocumentoHecho,
			TramiteNotificacion tramiteNotificacion, TramiteHecho tramitehecho, TramiteComun tramiteComun,
			CensoMonitor censoMonitor) throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		// 2. Se genera el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		String idEspera = this.tramiteHechoService.getNewEsperaPK() + "";
		TramiteHecho tramiteAcuse = this.generarTramiteAcuseReciboAutomatico(idEspera, tramitehecho, tramiteComun);

		// 3. Enviamos telematicamente la solicitud
		String textoNotificacionComunicacion = tramiteNotificacion.getTextoComunicacion();
		String destinatario = tramiteNotificacion.getDestinatario();
		String envRemesa = tramiteNotificacion.getEnvRemesaNotificacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getEhcohd(),
				tramitehecho.getEhcodigo(), tramiteNotificacion.getTipoNotificacionPlatea(),
				textoNotificacionComunicacion, destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// 4.1 Update tramite notificacion (campo idnotificacionplatea)
		tramitehecho.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		this.tramiteHechoDao.updateIdNotificacionPlatea(tramitehecho);

		// 4.2 Recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setEhnumregistrosalida(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setEhfecharegistrosalida(
				Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

		this.tramiteHechoDao.updateRegistroSalidaPlatea(tramitehecho);
		// 4.3 Add notificacion / acuse recibo (tabla)
		NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
		notificacionAcuseRecibo.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		notificacionAcuseRecibo.setEhcodigoacuse(tramiteAcuse.getEhcodigo());
		notificacionAcuseRecibo.setEhpcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.tramiteHechoDao.addNotificacionAcuseRecibo(notificacionAcuseRecibo);
	}

	/**
	 * Metodo que procesa el envio de una comunicacin o notificacion ordinaria
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idZipFile
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void procesarComunicacionNotificacionOrdinaria(List<Adjuntardocs> listadjuntardocs,
			List<DocumentoHecho> listDocumentoHecho, TramiteHecho tramitehecho, TramiteComun tramiteComun,
			String idZipFile) throws Exception {

		// Validacion: Debe haber almenos 1 documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
				PlantillaTramite plantillaTramite = null;
				if (adjuntardocsAux != null && adjuntardocsAux.getPtcodigo() != null
						&& !adjuntardocsAux.getPtcodigo().equals("")) {
					plantillaTramite = new PlantillaTramite();
					plantillaTramite.setPtcodigo(adjuntardocsAux.getPtcodigo());
					// Obtener la plantilla del tramite
					plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
				}

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocsAux)) {
					if ((tramitehecho.getEhenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getEhenvrem()))
							&& (plantillaTramite != null && plantillaTramite.getNolocalizable() != null
									&& plantillaTramite.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

					} else {
						if (!StringUtils.isBlank(adjuntardocsAux.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils
												.getExtensionFile(adjuntardocsAux.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}
				} else {
					if (tramitehecho.getEhenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getEhenvrem())) {
						if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		if (tramitehecho.getEhenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getEhenvrem())) {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				this.controlDocumentosProtegidosRemesa(listadjuntardocs);
			}
		}

		if (tramitehecho.getEhenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getEhenvrem())) {
			this.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, tramiteComun);
		}

		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
	}

	/**
	 * Metodo que obtiene el registro de salida en una comunicacion o
	 * notificacion ordinaria sin remesa
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws SQLException
	 */
	private TramiteHecho obtenerRegistrosalidaComunicacionNotificacion(TramiteHecho tramitehecho,
			TramiteComun tramiteComun) throws SQLException {
		if (tramitehecho.getEhenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getEhenvrem())) {
			if (tramitehecho.getEhnumregistrosalida() == null || tramitehecho.getEhnumregistrosalida().equals("")) {
				WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

				SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				} else {
					if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					} else if (solDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					} else {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					}
				}

				ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(tramitehecho.getEhiddestinatario());

				intervinientes = this.intervinientesDao.find(intervinientes);

				WSParamPerson wSParamPerson = new WSParamPerson();
				StringBuffer sbPerson = new StringBuffer();
				if (Y41bUtils.isFilled(intervinientes.getNif())) {
					sbPerson.append(intervinientes.getNif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(intervinientes.getEsnoco())) {
					sbPerson.append(intervinientes.getEsnoco());
					sbPerson.append(" ");
				} else {
					if (Y41bUtils.isFilled(intervinientes.getNombre())) {
						sbPerson.append(intervinientes.getNombre());
						sbPerson.append(" ");
					}
					if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
						sbPerson.append(intervinientes.getApellido1());
						sbPerson.append(" ");
					}
					if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
						sbPerson.append(intervinientes.getApellido2());
						sbPerson.append(" ");
					}
				}

				wSParamPerson.setPersonName(sbPerson.toString());

				persons.getWSParamPerson().add(wSParamPerson);

				datas.setPersons(persons);

				StringBuffer sbMatter = new StringBuffer();

				if (tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
					sbMatter.append(Y41bConstantes.LITERAL_COMUNICACION_ES);
				} else if (tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_NOTIFICACION)) {
					sbMatter.append(Y41bConstantes.LITERAL_NOTIFICACION_ES);
				}

				sbMatter.append(" - [");
				sbMatter.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				sbMatter.append("-");
				sbMatter.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
						.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
				sbMatter.append("]");
				datas.setMatter(sbMatter.toString());

				N61ServiceImpl n61Service = new N61ServiceImpl();
				WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

				tramitehecho.setEhfecharegistrosalida(new Date());
				tramitehecho.setEhnumregistrosalida(wSOutputRegister.getNumber());
			}
		}

		return tramitehecho;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI, previamente comprueba si se ha localizado y si no se ha
	 * localizado se elimina de DOKUSI y se vuelve a registrar en DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idProcedimiento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void guardarDocumentosDokusiTramiteComunicacionNotificacion(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun, String idProcedimiento) throws Exception {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		DocumentoHecho documentoHecho = null;
		for (int i = 0; i < listDocumentoHecho.size(); i++) {
			documentoHecho = listDocumentoHecho.get(i);
			if (documentoHecho.getQ5fechasollocalizador() != null) {
				if (documentoHecho != null && documentoHecho.getQ5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
						.getExtensionFile(documentoHecho.getQ5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

					int minutos = 0;
					if (parametros != null && parametros.getValor() != null
							&& Y41bUtils.isNumeric(parametros.getValor())) {
						minutos = Integer.parseInt(parametros.getValor());
					}

					SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

					Date d1 = null;
					Date d2 = null;
					long diffMinutes = 0;
					try {
						d1 = format.parse(format.format(documentoHecho.getQ5fechasollocalizador()));

						d2 = format.parse(format.format(new Date()));

						long diff = d2.getTime() - d1.getTime();

						diffMinutes = diff / (60 * 1000);
					} catch (ParseException e) {
						diffMinutes = 0;
					}

					if (diffMinutes > minutos) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(idProcedimiento);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setBoolAllVersions("true");

						try {
							y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						} catch (Exception e) {
						}

						documentoHecho.setQ5fechasollocalizador(null);
						documentoHecho.setQ5iddocumentum(null);
					}
				}
			}
		}

		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Documento>
	 * @throws Exception
	 *             Exception
	 */
	public List<Documento> registrarDocumentosDokusi(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun)
			throws Exception {
		List<Documento> listDocumentos = new ArrayList<Documento>();

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			// Calculo el numero del expediente para Dokusi
			/*
			 * SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			 * solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
			 * 
			 * SolicitudDetalle solDetalle = this.hechoDenunciadoDao
			 * .findSolicitud(solicitudDetalle);
			 * 
			 * StringBuffer numeroExpediente = new StringBuffer();
			 * 
			 * numeroExpediente.append(solDetalle.getDecoor()).append("-")
			 * .append(solDetalle.getDenror()).append("-")
			 * .append(solDetalle.getDenran()).append("-")
			 * .append(solDetalle.getHdnror());
			 */

			Documento documento = null;
			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
						&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

					documento = this.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
				} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
						&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// crear el objeto Sandoctemp
					Sandoctemp sandocTemp = new Sandoctemp();
					sandocTemp.setU5iddocumentum(documentoHecho.getQ5iddocumentum());
					sandocTemp.setU5tipodocumento(documentoHecho.getQ5idTipodoc());
					sandocTemp.setU5codocumento(documentoHecho.getQ5codocumento());
					sandocTemp.setU5nofile(documentoHecho.getQ5nofile());
					sandocTemp.setU5origen(documentoHecho.getQ5origen());
					sandocTemp.setU5ptcodigo(documentoHecho.getQ5ptcodigo());
					sandocTemp.setU5datafile(documentoHecho.getQ5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

					documento = this.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
				} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
						&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// crear el objeto Sandoctemp
					Arbdoctemp arbdocTemp = new Arbdoctemp();
					arbdocTemp.setX5iddocumentum(documentoHecho.getQ5iddocumentum());
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoHecho.getQ5idTipodoc());
					arbdocTemp.setArbtipdoc(arbtipdoc);
					arbdocTemp.setX5codocumento(documentoHecho.getQ5codocumento());
					arbdocTemp.setX5nofile(documentoHecho.getQ5nofile());
					arbdocTemp.setX5origen(documentoHecho.getQ5origen());
					arbdocTemp.setX5ptcodigo(documentoHecho.getQ5ptcodigo());
					arbdocTemp.setX5datafile(documentoHecho.getQ5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

					documento = this.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
				} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
						&& (documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
						&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

					documento = this.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
				}

				listDocumentos.add(documento);
			}
		}

		return listDocumentos;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarBandejaFirma(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			// Elimino de la Bandeja de Firma los documentos del tramite
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			// bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

			// Calculo el numero del expediente para Dokusi
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
					.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					// Si esta pendiente de firma, lo primero lo meto en Dokusi
					// si NO esta dado de alta ya
					if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

						if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
								&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

							this.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
						} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
								&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
							// crear el objeto Sandoctemp
							Sandoctemp sandocTemp = new Sandoctemp();
							sandocTemp.setU5iddocumentum(documentoHecho.getQ5iddocumentum());
							sandocTemp.setU5tipodocumento(documentoHecho.getQ5idTipodoc());
							sandocTemp.setU5codocumento(documentoHecho.getQ5codocumento());
							sandocTemp.setU5nofile(documentoHecho.getQ5nofile());
							sandocTemp.setU5origen(documentoHecho.getQ5origen());
							sandocTemp.setU5ptcodigo(documentoHecho.getQ5ptcodigo());
							sandocTemp.setU5datafile(documentoHecho.getQ5datafile());

							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

							this.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
						} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
								&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
							// crear el objeto Sandoctemp
							Arbdoctemp arbdocTemp = new Arbdoctemp();
							arbdocTemp.setX5iddocumentum(documentoHecho.getQ5iddocumentum());
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoHecho.getQ5idTipodoc());
							arbdocTemp.setArbtipdoc(arbtipdoc);
							arbdocTemp.setX5codocumento(documentoHecho.getQ5codocumento());
							arbdocTemp.setX5nofile(documentoHecho.getQ5nofile());
							arbdocTemp.setX5origen(documentoHecho.getQ5origen());
							arbdocTemp.setX5ptcodigo(documentoHecho.getQ5ptcodigo());
							arbdocTemp.setX5datafile(documentoHecho.getQ5datafile());

							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

							this.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
						} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
								&& (documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
										|| documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
										|| documentoHecho.getQ5pcodigo()
												.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

						} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
								&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

							this.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
						}

					}
					// Lo segundo lo meto en la Bandeja de Firma
					bandejaFirma = new BandejaFirma();

					bandejaFirma.setIdbandejafirma(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaFirma.setIdexpediente(tramiteComun.getIdExpediente());
					bandejaFirma.setExpediente(numeroExpediente.toString());
					bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					bandejaFirma.setHccoor(solDetalle.getHccoor());
					bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
					bandejaFirma.setTrcodigo(tipoTramite);

					Fase fase = new Fase();
					fase.setFcodigo(faseTramite);
					bandejaFirma.setFase(fase);

					bandejaFirma.setCodocumento(documentoHecho.getQ5codocumento());
					bandejaFirma.setIddocumentum(documentoHecho.getQ5iddocumentum());
					bandejaFirma.setNofile(documentoHecho.getQ5nofile());
					bandejaFirma.setDesfile(documentoHecho.getQ5tedesfile());
					bandejaFirma.setFechalimfirma(new Date());
					bandejaFirma.setIdperfilfirma(documentoHecho.getQ5idPerfilfirma());

					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

					Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

					String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
					bandejaFirma.setHashfile(hashDocumento);

					if (bandejaFirma.getIdperfilfirma() != null
							&& bandejaFirma.getIdperfilfirma().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
						bandejaFirma.setComoasigfirma(solDetalle.getMocodigo());
					}

					this.bandejaFirmaDao.add(bandejaFirma);
				}
			}
		}
	}

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite)
			throws Exception {
		try {
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			tramitehecho.setEhcohd(tramiteGenerico.getIdExpediente());
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_GENERICO);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			if (locale == null || (!locale.getLanguage().equals(Y41bConstantes.CASTELLANO)
					&& !locale.getLanguage().equals(Y41bConstantes.EUSKERA))) {
				locale = new Locale(Y41bConstantes.CASTELLANO);
			}

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramitehecho.setEhfecha(todayWithZeroTime);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			tramitehecho.setEhhora(ehhora);
			tramitehecho.setEhfechainicio(todayWithZeroTime);
			String instructor = null;
			if (null != tramiteGenerico.getInstructorAsignado()) {
				instructor = tramiteGenerico.getInstructorAsignado().getMocodigo();
			}

			tramitehecho.setEhcomoasignado(instructor);
			tramitehecho.setEhcomo(instructor);
			/* hablado con alberto bm 23/01/2015 antes en ehmotivorechazo */
			tramitehecho.setEhtexto(tramiteGenerico.getComentario());

			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			StringBuffer nombreTramite = new StringBuffer();
			nombreTramite.append(
					appMessageSource.getMessage(literalNombreTramite, null, new Locale(Y41bConstantes.CASTELLANO)));
			nombreTramite.append(" / ");
			nombreTramite.append(
					appMessageSource.getMessage(literalNombreTramite, null, new Locale(Y41bConstantes.EUSKERA)));
			tramitehecho.setEhnombretramite(nombreTramite.toString());

			tramitehecho.setEhautomatico(Y41bConstantes.VALOR_SI);

			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_GENERICO, null, tramiteGenerico.getIdExpediente());

			// Tratar la bandeja
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramiteGenerico.getIdExpediente());
			this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

			return tramitehecho;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en addTramiteGenericoAutomatico: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Guardar el tramite requerimientoAcreditacionRepresentacion
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRequerimientoAcreditacionRepresentacion.getFechaInicio());
		tramitehecho.setEhcomoasignado(
				tramiteRequerimientoAcreditacionRepresentacion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRequerimientoAcreditacionRepresentacion.getComentario());

		tramitehecho.setEhorigenalegacion(tramiteRequerimientoAcreditacionRepresentacion.getOrigen());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteRequerimientoAcreditacionRepresentacion.getFechaFin());
			tramitehecho.setEhcomoejecucion(
					tramiteRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRequerimientoAcreditacionRepresentacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramitehecho,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION);
			}
		}

		if (tramitar) {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdExpediente(tramitehecho.getEhcohd());

			if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE
					.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {

				interviniente.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamante", true,
							new Exception());
				}

			} else if (Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO
					.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {
				interviniente
						.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamado", true,
							new Exception());
				}
			}

			// Generar notificacion al reclamado
			this.generarTramiteNotificacionAutomaticoReqAcreditacionRepresentacion(
					tramiteRequerimientoAcreditacionRepresentacion, tramiteComun);

			// Generar recepcion informacion
			this.generarTramiteRecInformacionAutomaticoReqAcreditacionRepresentacion(tramitehecho, tramiteComun);

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION,
					Y41bConstantes.TRAMITE_RECEPCION_ACREDITACION_REPRESENTACION, tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramite
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramite.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacionAux = new TramiteRequerimientoAcreditacionRepresentacion();
		tramiteRequerimientoAcreditacionRepresentacionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRequerimientoAcreditacionRepresentacionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRequerimientoAcreditacionRepresentacionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRequerimientoAcreditacionRepresentacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRequerimientoAcreditacionRepresentacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoAcreditacionRepresentacionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRequerimientoAcreditacionRepresentacionAux.setOrigen(tramitehecho.getEhorigenalegacion());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRequerimientoAcreditacionRepresentacionAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoAcreditacionRepresentacionAux;
	}

	/**
	 * Guardar el tramite anulacionPropuestaSancion
	 * 
	 * @param tramiteAnulacionPropuestaSancion
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ANULACION_PROPUESTA_SANCION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteAnulacionPropuestaSancion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteAnulacionPropuestaSancion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteAnulacionPropuestaSancion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteAnulacionPropuestaSancion.getComentario());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteAnulacionPropuestaSancion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteAnulacionPropuestaSancion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		if (tramitar) {

			Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
			sanpropbandeja.setBaprsanexcodigo(tramiteComun.getIdExpediente());

			if (this.sanpropbandejaService.findAllCount(sanpropbandeja) > 0) {
				this.sanpropbandejaService.removeSolicitudes(sanpropbandeja);
			} else {
				throw new Y41bUDAException("error.tramiteAnulacionPropuestaSancion.propuestaSancion", true,
						new Exception());
			}

			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ANULACION_PROPUESTA_SANCION, null,
					tramiteComun.getIdExpediente());

		} else {
			// Actualizar ultimo tramite
			this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ANULACION_PROPUESTA_SANCION, null,
					tramiteComun.getIdExpediente());
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAnulacionPropuestaSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAnulacionPropuestaSancion findTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramite, CensoMonitor censoMonitor) {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramite.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancionAux = new TramiteAnulacionPropuestaSancion();
		tramiteAnulacionPropuestaSancionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteAnulacionPropuestaSancionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteAnulacionPropuestaSancionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAnulacionPropuestaSancionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAnulacionPropuestaSancionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAnulacionPropuestaSancionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteAnulacionPropuestaSancionAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteAnulacionPropuestaSancionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAnulacionPropuestaSancionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAnulacionPropuestaSancionAux;
	}

	/**
	 * Esta funcion actualiza el ultimo tramite ejecutado para Solicitudes
	 * 
	 * @param codTramiteEjecutado
	 *            String
	 * @param codUltimoTramiteGenerado
	 *            String
	 * @param idExpediente
	 *            String
	 */
	public String actualizarUltimoTramite(String codTramiteEjecutado, String codUltimoTramiteGenerado,
			String idExpediente) {
		// Actualizo la fase del expediente
		this.actualizarHistoricoFases(codTramiteEjecutado, codUltimoTramiteGenerado, idExpediente);
		// Calculo si el tramite ejecutado es generico o no es generico
		Tramite tramiteEjecutado = new Tramite();
		tramiteEjecutado.setTrcodigo(codTramiteEjecutado);
		tramiteEjecutado = this.tramiteDao.find(tramiteEjecutado);
		boolean isTramiteEjecutadoGenerico = true;
		if (tramiteEjecutado.getFase() != null && Y41bUtils.isFilled(tramiteEjecutado.getFase().getFcodigo())) {
			isTramiteEjecutadoGenerico = false;
		}

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(idExpediente);

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHddenunciaaaccempresas() != null
				&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(codTramiteEjecutado)
					|| Y41bConstantes.TRAMITE_ALEGACION.equals(codTramiteEjecutado)) {
				Fase fase = new Fase();
				fase.setFcodigo(Y41bConstantes.FASE_ALEGACIONES);
				tramiteEjecutado.setFase(fase);
			}
		}

		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		if (isTramiteEjecutadoGenerico) {
			hechodenunciadoAux.setHdcodigo(idExpediente);
			if (Y41bUtils.isFilled(codUltimoTramiteGenerado)) {
				hechodenunciadoAux.setTrcodigoactual(codUltimoTramiteGenerado);
			} else {
				hechodenunciadoAux.setTrcodigoactual(codTramiteEjecutado);
			}
			this.hechoDenunciadoDao.updateUltimoTramiteGenerico(hechodenunciadoAux);
			logger.info("1. Caso Tramite Ejecutado generico - Trcodigoactual:" + codTramiteEjecutado);
			return "1";
		} else {
			String faseTramiteEjecutado = tramiteEjecutado.getFase().getFcodigo();
			if (Y41bUtils.isFilled(codUltimoTramiteGenerado)) {
				// Se ha ejecutado trámite generado automatico posterior
				Tramite ultimoTramiteGenerado = new Tramite();
				ultimoTramiteGenerado.setTrcodigo(codUltimoTramiteGenerado);
				ultimoTramiteGenerado = this.tramiteDao.find(ultimoTramiteGenerado);
				boolean isUltimoTramiteGeneradoGenerico = true;
				if (ultimoTramiteGenerado.getFase() != null
						&& Y41bUtils.isFilled(ultimoTramiteGenerado.getFase().getFcodigo())) {
					isUltimoTramiteGeneradoGenerico = false;
				}

				if (solDetalle.getHddenunciaaaccempresas() != null
						&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
					if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(codUltimoTramiteGenerado)
							|| Y41bConstantes.TRAMITE_ALEGACION.equals(codUltimoTramiteGenerado)) {
						Fase fase = new Fase();
						fase.setFcodigo(Y41bConstantes.FASE_ALEGACIONES);
						ultimoTramiteGenerado.setFase(fase);
					}

				}
				if (isUltimoTramiteGeneradoGenerico) {
					// Se ha ejecutado trámite generado automatico posterior
					// GENERICO
					hechodenunciadoAux.setHdcodigo(idExpediente);
					hechodenunciadoAux.setFcodigoactual(faseTramiteEjecutado);
					hechodenunciadoAux.setTrcodigoactual(codUltimoTramiteGenerado);
					hechodenunciadoAux.setTrposiblecodigo(codTramiteEjecutado);

					this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
					logger.info("3. Caso Tramite Ejecutado no generico y tramite generado genérico - Trcodigoactual:"
							+ codUltimoTramiteGenerado + " / Fcodigoactual:" + faseTramiteEjecutado
							+ " / Trposiblecodigo:" + codTramiteEjecutado);
					return "3";
				} else {
					// Se ha ejecutado trámite generado automatico posterior NO
					// GENERICO
					String faseUltimoTramiteGenerado = ultimoTramiteGenerado.getFase().getFcodigo();
					hechodenunciadoAux.setHdcodigo(idExpediente);
					hechodenunciadoAux.setFcodigoactual(faseUltimoTramiteGenerado);
					hechodenunciadoAux.setTrcodigoactual(codUltimoTramiteGenerado);

					if (Y41bConstantes.TRAMITE_REGISTRO_DECISION.equals(codTramiteEjecutado)
							&& Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE.equals(codUltimoTramiteGenerado)) {
						// Caso en el que desde el tramite de decision se genera
						// un tramite automatico de cierre
						hechodenunciadoAux.setTrposiblecodigo(codTramiteEjecutado);
					} else {
						hechodenunciadoAux.setTrposiblecodigo(codUltimoTramiteGenerado);
					}

					this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
					logger.info(
							"4. Caso Tramite Ejecutado no generico y tramite generado no genérico - Trcodigoactual:"
									+ codUltimoTramiteGenerado + " / Fcodigoactual:" + faseUltimoTramiteGenerado
									+ " / Trposiblecodigo:" + codUltimoTramiteGenerado);
					return "4";
				}
			} else {
				hechodenunciadoAux.setHdcodigo(idExpediente);
				hechodenunciadoAux.setFcodigoactual(faseTramiteEjecutado);
				hechodenunciadoAux.setTrcodigoactual(codTramiteEjecutado);
				hechodenunciadoAux.setTrposiblecodigo(codTramiteEjecutado);

				this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
				logger.info("2. Caso Tramite Ejecutado no generico y sin tramite generado - Trcodigoactual:"
						+ codTramiteEjecutado + " / Fcodigoactual:" + faseTramiteEjecutado + " / Trposiblecodigo:"
						+ codTramiteEjecutado);
				return "2";
			}
		}
	}

	/**
	 * Esta funcion actualiza el ultimo tramite ejecutado para Solicitudes CASO
	 * ESPECIAL PARA TRAMITE CIERRE (AL GUARDAR)
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void actualizarUltimoTramiteCierreGuardar(String idExpediente) {
		// 1. Actualizo la fase del expediente
		Date hfffin = new Date();
		String faseExpediente = "";
		if (Y41bUtils.isFilled(idExpediente)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
			faseExpediente = solDetalle.getFcodigo();
		}
		// 1.1 Cerramos (fechafin) la fase del expediente en el historico de
		// fases
		boolean crearNewFaseCierre = false;
		if (Y41bUtils.isFilled(faseExpediente)) {
			Historicofases historicotrejecutadoAux = new Historicofases();
			historicotrejecutadoAux.setHfhdcodigo(idExpediente);
			List<Historicofases> historicotrejecutadoList = this.historicofasesService
					.findAllFasesHistoricoAbiertas(historicotrejecutadoAux);
			if (historicotrejecutadoList != null && historicotrejecutadoList.size() > 0) {
				for (Historicofases historicotrejecutado : historicotrejecutadoList) {
					if (!Y41bConstantes.FASE_CIERRE.equals(historicotrejecutado.getHffcodigo())) {
						if (historicotrejecutado.getHfffin() == null) {
							historicotrejecutado.setHfffin(hfffin);
							this.historicofasesService.updateFechaFin(historicotrejecutado);
							crearNewFaseCierre = true;
						}
					}
				}
			}
		}
		// 1.2 Miramos si existe en el historico de fases una fase de
		// cierre.
		if (crearNewFaseCierre) {
			Historicofases historicotrcierre = new Historicofases();
			historicotrcierre.setHfhdcodigo(idExpediente);
			historicotrcierre.setHffcodigo(Y41bConstantes.FASE_CIERRE);
			historicotrcierre.setHffinicio(new Date());
			historicotrcierre.setHfffin(null);
			this.historicofasesService.add(historicotrcierre);
		}
		// 2. Calculo si el tramite ejecutado es generico o no es generico
		Tramite tramiteEjecutado = new Tramite();
		tramiteEjecutado.setTrcodigo(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		tramiteEjecutado = this.tramiteDao.find(tramiteEjecutado);

		String faseTramiteEjecutado = tramiteEjecutado.getFase().getFcodigo();

		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(idExpediente);
		hechodenunciadoAux.setFcodigoactual(faseTramiteEjecutado);
		hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);

		this.hechoDenunciadoDao.updateUltimoTramiteConFaseGenerico(hechodenunciadoAux);
	}

	/**
	 * Esta funcion actualiza el historico de fases del expediente a partir de
	 * los tramites ejecutados y generados. Cubre los casos siempre que el
	 * tramite ejecutado no genere automaticamente tramites (que no sean el
	 * codTramiteGenerado): - NO GENERICOS - CON CAMBIO DE FASE. Esta funcion no
	 * contempla el caso de Registro de Solicitud ya que es especial y no usa
	 * esta funcionalidad.
	 * 
	 * @param codTramiteEjecutado
	 *            String
	 * @param codTramiteGenerado
	 *            String
	 * @param idExpediente
	 *            String
	 */
	public void actualizarHistoricoFases(String codTramiteEjecutado, String codTramiteGenerado, String idExpediente) {
		logger.info("ActualizarHistoricoFases Ini");
		Date hfffin = new Date();
		String faseExpediente = "";
		String faseTramiteEjecutado = "";
		String faseTramiteGenerado = "";
		// 1. Recuperamos las fases que vamos a necesitar
		// 1.1 Recuperamos la fase actual del expediente
		SolicitudDetalle solDetalle = null;
		if (Y41bUtils.isFilled(idExpediente)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);

			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
			faseExpediente = solDetalle.getFcodigo();
		}

		// 1.2 Recuperamos la fase del tramite ejecutado
		if (Y41bUtils.isFilled(codTramiteEjecutado)) {
			Tramite tramiteEjecutado = new Tramite();
			tramiteEjecutado.setTrcodigo(codTramiteEjecutado);
			tramiteEjecutado = this.tramiteDao.find(tramiteEjecutado);
			if (tramiteEjecutado.getFase() != null && Y41bUtils.isFilled(tramiteEjecutado.getFase().getFcodigo())) {
				faseTramiteEjecutado = tramiteEjecutado.getFase().getFcodigo();
			}

			if (solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(codTramiteEjecutado)
						|| Y41bConstantes.TRAMITE_ALEGACION.equals(codTramiteEjecutado)) {
					faseTramiteEjecutado = Y41bConstantes.FASE_ALEGACIONES;
				}
			}

		}
		// 1.3 Recuperamos la fase del tramite generado
		if (Y41bUtils.isFilled(codTramiteGenerado)) {
			Tramite tramiteGenerado = new Tramite();
			tramiteGenerado.setTrcodigo(codTramiteGenerado);
			tramiteGenerado = this.tramiteDao.find(tramiteGenerado);
			if (tramiteGenerado.getFase() != null && Y41bUtils.isFilled(tramiteGenerado.getFase().getFcodigo())) {
				faseTramiteGenerado = tramiteGenerado.getFase().getFcodigo();
			}

			if (solDetalle.getHddenunciaaaccempresas() != null
					&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(codTramiteGenerado)
						|| Y41bConstantes.TRAMITE_ALEGACION.equals(codTramiteGenerado)) {
					faseTramiteGenerado = Y41bConstantes.FASE_ALEGACIONES;
				}
			}
		}

		if (Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE.equals(codTramiteEjecutado)) {
			// Cuando se da a tramitar el Cierre
			// 2.1 Cerramos (fechafin) la fase del expediente en el historico de
			// fases
			boolean ultimoTramiteAbiertoCierre = false;
			if (Y41bUtils.isFilled(faseExpediente)) {
				Historicofases historicotrexpedienteAux = new Historicofases();
				historicotrexpedienteAux.setHfhdcodigo(idExpediente);
				List<Historicofases> historicotrexpedienteList = this.historicofasesService
						.findAllFasesHistoricoAbiertas(historicotrexpedienteAux);
				if (historicotrexpedienteList != null && historicotrexpedienteList.size() > 0) {
					for (Historicofases historicotrexpediente : historicotrexpedienteList) {
						if (historicotrexpediente.getHfffin() == null) {
							historicotrexpediente.setHfffin(hfffin);
							this.historicofasesService.updateFechaFin(historicotrexpediente);
						}
						if (Y41bConstantes.FASE_CIERRE.equals(historicotrexpediente.getHffcodigo())) {
							ultimoTramiteAbiertoCierre = true;
						}
					}
				}
			}
			// 2.2 Miramos si existe en el historico de fases una fase de
			// cierre.
			if (!ultimoTramiteAbiertoCierre) {
				Historicofases historicotrcierre = new Historicofases();
				historicotrcierre.setHfhdcodigo(idExpediente);
				historicotrcierre.setHffcodigo(Y41bConstantes.FASE_CIERRE);
				historicotrcierre.setHffinicio(new Date());
				historicotrcierre.setHfffin(new Date());
				this.historicofasesService.add(historicotrcierre);
			}
		} else {
			// 3.1 Comparamos la fase del expediente con la fase del tramite
			// ejecutado
			if (Y41bUtils.isFilled(faseTramiteEjecutado)) {
				// Si son diferentes
				if (!faseExpediente.equals(faseTramiteEjecutado)) {
					// - Cerramos (fechafin) la fase del expediente en el
					// historico de fases
					if (Y41bUtils.isFilled(faseExpediente)) {
						Historicofases historicotrexpedienteAux = new Historicofases();
						historicotrexpedienteAux.setHfhdcodigo(idExpediente);
						List<Historicofases> historicotrexpedienteList = this.historicofasesService
								.findAllFasesHistoricoAbiertas(historicotrexpedienteAux);
						if (historicotrexpedienteList != null && historicotrexpedienteList.size() > 0) {
							for (Historicofases historicotrexpediente : historicotrexpedienteList) {
								if (historicotrexpediente.getHfffin() == null) {
									historicotrexpediente.setHfffin(hfffin);
									this.historicofasesService.updateFechaFin(historicotrexpediente);
								}
							}
						}
					}
					// - Creamos una nueva fase (tramite ejecutado)
					Historicofases historicoejecutadotr = new Historicofases();
					historicoejecutadotr.setHfhdcodigo(idExpediente);
					historicoejecutadotr.setHffcodigo(faseTramiteEjecutado);
					historicoejecutadotr.setHffinicio(new Date());
					historicoejecutadotr.setHfffin(null);
					this.historicofasesService.add(historicoejecutadotr);
				}
			}

			// 3.2 Comparamos la fase del tramite ejecutado con la fase del
			// tramite generado
			if (Y41bUtils.isFilled(faseTramiteGenerado)) {
				// Si son diferentes
				if (!faseTramiteEjecutado.equals(faseTramiteGenerado)) {
					// - Cerramos (fechafin) la fase del tramite ejecutado en el
					// historico de fases
					if (Y41bUtils.isFilled(faseTramiteEjecutado)) {
						Historicofases historicotrejecutadoAux = new Historicofases();
						historicotrejecutadoAux.setHfhdcodigo(idExpediente);
						List<Historicofases> historicotrejecutadoList = this.historicofasesService
								.findAllFasesHistoricoAbiertas(historicotrejecutadoAux);
						if (historicotrejecutadoList != null && historicotrejecutadoList.size() > 0) {
							for (Historicofases historicotrejecutado : historicotrejecutadoList) {
								if (historicotrejecutado.getHfffin() == null) {
									historicotrejecutado.setHfffin(hfffin);
									this.historicofasesService.updateFechaFin(historicotrejecutado);
								}
							}
						}
					}
					// - Creamos una nueva fase (tramite generado)
					Historicofases historicogeneradotr = new Historicofases();
					historicogeneradotr.setHfhdcodigo(idExpediente);
					historicogeneradotr.setHffcodigo(faseTramiteGenerado);
					historicogeneradotr.setHffinicio(new Date());
					historicogeneradotr.setHfffin(null);
					this.historicofasesService.add(historicogeneradotr);
				}
			}
		}
		logger.info("ActualizarHistoricoFases Fin");
	}

	/**
	 * Finds rows in the Tramites table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination) {
		filterNotifComuni.setCompatibleAA66(this.compatibleConAA66());
		List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.tramiteHechoDao
				.findAllNotifiComuni(filterNotifComuni, pagination);

		for (NotificacionesComunicacionesBusqueda notifcomun : listNotifiComuniBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(filterNotifComuni.getRmtipoExpediente()).append(" ").append(notifcomun.getDecoor())
					.append("-").append(notifcomun.getDenran()).append("-").append(notifcomun.getDenror()).append("-")
					.append(notifcomun.getHdnror());

			notifcomun.setRmtipoExpediente(filterNotifComuni.getRmtipoExpediente());

			notifcomun.setNumExpediente(numeroExpediente.toString());

			// En caso de que sea el destino Sede fijar la direccin de la misma
			if (notifcomun.getEhsede() != null && notifcomun.getEhsede().equals("S")) {

				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEsnif(notifcomun.getNif());

				establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

				if (establecimiento != null) {
					Sede sede = new Sede();
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

					sede = this.establecimientoService.findEstablecimientoSede(sede);

					if (sede != null) {
						notifcomun.setNombre_CP(sede.getNombreCp());
						if (sede.getNombreMunicipio() != null) {
							notifcomun.setNombre_Municipio(sede.getNombreMunicipio());
						}
						if (sede.getNombreLocalidad() != null) {
							notifcomun.setNombre_Localidad(sede.getNombreLocalidad());
						}
						if (sede.getNombreProvincia() != null) {
							notifcomun.setNombre_Provincia(sede.getNombreProvincia());
						}

						if (sede.getNombreCalle() != null) {
							notifcomun.setNombre_Calle(sede.getNombreCalle());

							notifcomun.setNombre_Portal(sede.getNombrePortal());
							notifcomun.setNombre_Piso(sede.getNombrePiso());

						} else if (sede.getDireccionNocapv() != null) {

							notifcomun.setNombre_Calle("");
							notifcomun.setNombre_Portal("");
							notifcomun.setNombre_Piso("");

							if (sede.getNoraPaisNombre() != null && !sede.getNoraPaisNombre().equals("")) {
								notifcomun.setNombre_Pais(sede.getNoraPaisNombre());
							}
							notifcomun.setExtranjero(sede.getExtranjero());
							notifcomun.setDireccionNocapv(sede.getDireccionNocapv());
						}
					} else {
						ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
					}
				} else {
					ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
				}
			}
			// PREPARO LAS DIRECCIONES DESTINO
			StringBuffer direccion2 = new StringBuffer();
			if (notifcomun.getNombre_CP() != null && !notifcomun.getNombre_CP().equals("")) {
				direccion2.append(notifcomun.getNombre_CP());
			} else {
				direccion2.append("");
				notifcomun.setNombre_CP("");
			}
			if (notifcomun.getExtranjero() != null && notifcomun.getExtranjero().equals("S")) {
				notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				direccion2.append(" ").append(notifcomun.getNombre_Pais());
				notifcomun.setDireccion2(direccion2.toString());

			} else {
				if (notifcomun.getNombre_Calle() != null && !notifcomun.getNombre_Calle().equals("")) {
					StringBuffer direccionCapv = new StringBuffer();
					direccionCapv.append(notifcomun.getNombre_Calle());
					if (notifcomun.getNombre_Portal() != null && !notifcomun.getNombre_Portal().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Portal());
					}
					if (notifcomun.getNombre_Piso() != null && !notifcomun.getNombre_Piso().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Piso());
					}
					notifcomun.setDireccion1(direccionCapv.toString());
				} else {
					notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				}

				direccion2.append(" ").append(notifcomun.getNombre_Municipio());
				notifcomun.setDireccion2(direccion2.toString());

			}

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (notifcomun.getNombreCalle() != null && !notifcomun.getNombreCalle().equals("")) {
				direccionCompleta.append(notifcomun.getNombreCalle());

				if (notifcomun.getNombrePortal() != null && !notifcomun.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(notifcomun.getNombrePortal());
				}
			}

			notifcomun.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (notifcomun.getNombreCp() != null && !notifcomun.getNombreCp().equals("")) {
				cpMunicipio.append(notifcomun.getNombreCp());

				if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(notifcomun.getNombreMunicipio());
				}
			} else if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
				cpMunicipio.append(notifcomun.getNombreMunicipio());
			}

			notifcomun.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer();

			piepagina_linea1.append(notifcomun.getDireccionOrganismo()).append(" - ")
					.append(notifcomun.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(notifcomun.getTelefonoOrganismo());

			notifcomun.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(notifcomun.getEmailOrganismo()).append(" / ")
					.append(notifcomun.getWebOrganismo());

			notifcomun.setPiePaginaLinea2(piepagina_linea2.toString());
		}

		return listNotifiComuniBusqueda;

	}

	/**
	 * Comprueba si existe compatibilidad con AA66
	 * 
	 * @return boolean
	 */
	private boolean compatibleConAA66() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	private void ponerVaciaLaSedeEnLaNotificaComunica(NotificacionesComunicacionesBusqueda notifcomun) {
		notifcomun.setNombre_CP("");
		notifcomun.setNombre_Municipio("");
		notifcomun.setNombre_Provincia("");
		notifcomun.setNombre_Calle("");
		notifcomun.setNombre_Portal("");
		notifcomun.setNombre_Piso("");
		notifcomun.setNombre_Pais("");
		notifcomun.setExtranjero("");
		notifcomun.setDireccionNocapv("");
	}

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni) {
		return this.tramiteHechoDao.findAllNotifiComuniCount(filterNotifComuni);
	}

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws SerialException, SQLException, Exception {

		List<NotificacionesComunicacionesBusqueda> listaClobsNotifiComuni = this.tramiteHechoDao
				.findBlobTablaDocumentosHecho(filterNotifiComuni);

		if (listaClobsNotifiComuni != null) {

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listaClobsNotifiComuni) {

				// si est en dokusi, descargar de dokusi
				if (notificacionesComunicacionesBusquedaAux != null
						&& notificacionesComunicacionesBusquedaAux.getQ5iddocumentum() != null
						&& !notificacionesComunicacionesBusquedaAux.getQ5iddocumentum().equals("")) {
					// descargar de dokusi
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(notificacionesComunicacionesBusquedaAux.getQ5iddocumentum());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					notificacionesComunicacionesBusquedaAux.setQ5datafile(blob);
				} else {
					// si no est en dokusi descargar de base de datos
				}
			}
		}
		return listaClobsNotifiComuni;
	}

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni) {

		return this.tramiteHechoDao.findSumSizeBlobNotifiComuni(filterNotifiComuni);
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de sancion con la
	 * informacion del tramitehecho recibido por parametro
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	public void tratamientoBandejaPropuestaSancion(TramiteHecho tramitehecho) {
		logger.info("TratamientoBandejaPropuestaSancion Ini");
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		// Codigo del hecho denunciado
		sanpropbandeja.setBaprsanexcodigo(tramitehecho.getEhcohd());
		// Num expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
		sanpropbandeja.setBaprsanexcodigocompleto(numeroExpediente.toString());
		// Procedimiento
		sanpropbandeja.setBaprsanpcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		// Fecha registro
		// 20150401: Cambiamos a fecha del hecho, a la fecha del hecho
		// denunciado
		sanpropbandeja.setBaprsanfec(solDetalle.getHdfehd());
		// Buscamos el interviniente Denunciado (Establecimiento)
		// Datos del establecimiento Ini
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramitehecho.getEhcohd());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());
			sanpropbandeja.setBaprsanmunic(listIntervinientes.get(0).getNoraMunicipioId());
			sanpropbandeja.setBaprsanprov(listIntervinientes.get(0).getNoraProvinciaId());
		}
		// Datos del establecimiento Fin
		// Responsable del expediente
		sanpropbandeja.setBaprsanrespexp(solDetalle.getMocodigo());

		sanpropbandejaService.add(sanpropbandeja);
		logger.info("TratamientoBandejaPropuestaSancion Fin");
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Solicitudes
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSol(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {
		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

		// Si no tiene tipo documental, metemos por defecto
		// ejgv_d_archivo
		String tipoDocumental = null;

		if (Y41bUtils.isFilled(documentoHecho.getQ5idTipodoc())) {
			tipoDocumental = documentoHecho.getQ5idTipodoc();
		} else {
			tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		}

		documento.setTipoDocumental(tipoDocumental);

		TipoDocumento tipodocumento = new TipoDocumento();
		tipodocumento.setIdTipodoc(tipoDocumental);
		try {
			tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
			if (tipodocumento != null) {
				documento.setTipoDocumento(tipodocumento.getTdnombre());
			} else {
				documento.setTipoDocumento(".");
			}
		} catch (EmptyResultDataAccessException e) {
			documento.setTipoDocumento(".");
		}

		documento.setIdDocumento(documentoHecho.getQ5codocumento());

		// Para que sepa PLATEA que es un RTF (obligatorio)
		documento.setDescripcion(documentoHecho.getQ5tedesfile());
		documento.setNombre(documentoHecho.getQ5nofile());
		documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile()));

		// Calculo el origen de DOKUSI del documento ini
		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

		if (Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		if (documentoHecho != null && documentoHecho.getQ5ptcodigo() != null
				&& !documentoHecho.getQ5ptcodigo().equals("")) {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(documentoHecho.getQ5ptcodigo());
			// Obtener la plantilla del tramite
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

			documento.setNolocalizable(plantillaTramite.getNolocalizable());
		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		// Compruebo si tiene OID de Dokusi
		if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {
			// si es aportacion y presencial digitalizado
			if (tramitehecho != null && tramitehecho.getEhcotee() != null
					&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION)
					&& tramitehecho.getEhistelematico() == null) {
				// documento.setNaturaleza(Y41bConstantes.NATURALEZA_DIGITALIZADO);
			}

			Blob contenido = documentoHecho.getQ5datafile();

			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			// Si no tiene, lo registro en Dokusi y actualizo OID
			documento = y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
			// Actualizo OID Dokusi en tabla documentos intermedia
			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}

		} else {
			if (tramitehecho != null && tramitehecho.getEhcotee() != null
					&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION)
					&& tramitehecho.getEhistelematico() != null
					&& tramitehecho.getEhistelematico().equals(Y41bConstantes.VALOR_SI)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			} else {
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documento.getIdDocumento());
				documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

				if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() == null) {
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documento)
							&& (documento.getNolocalizable() == null
									|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

						LocalizadorDocumento incorporarLocalizador = new LocalizadorDocumento();
						incorporarLocalizador.setOidDocumento(documento.getOidDokusi());
						incorporarLocalizador.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						incorporarLocalizador.setUser(sender);
						incorporarLocalizador.setBoolVersion(true);
						incorporarLocalizador.setBoolReducir(false);
						incorporarLocalizador.setSede("");

						y41bDokusiAdapterService.incorporarLocalizadorDokusi(incorporarLocalizador);
					} else if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						TransformarDocumento transformarDocumento = new TransformarDocumento();
						transformarDocumento.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						transformarDocumento.setUser(sender);
						transformarDocumento.setOidDocumento(documento.getOidDokusi());

						y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);
					}

					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
					} else {
						this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
					}
				}
			}
		}

		return documento;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Solicitudes Sin Localizar
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSinLocalizarSol(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {
		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

		// Si no tiene tipo documental, metemos por defecto
		// ejgv_d_archivo
		String tipoDocumental = null;

		if (Y41bUtils.isFilled(documentoHecho.getQ5idTipodoc())) {
			tipoDocumental = documentoHecho.getQ5idTipodoc();
		} else {
			tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		}

		documento.setTipoDocumental(tipoDocumental);

		TipoDocumento tipodocumento = new TipoDocumento();
		tipodocumento.setIdTipodoc(tipoDocumental);
		try {
			tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
			if (tipodocumento != null) {
				documento.setTipoDocumento(tipodocumento.getTdnombre());
			} else {
				documento.setTipoDocumento(".");
			}
		} catch (EmptyResultDataAccessException e) {
			documento.setTipoDocumento(".");
		}

		documento.setIdDocumento(documentoHecho.getQ5codocumento());

		// Para que sepa PLATEA que es un RTF (obligatorio)
		documento.setDescripcion(documentoHecho.getQ5tedesfile());
		documento.setNombre(documentoHecho.getQ5nofile());
		documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile()));

		// Calculo el origen de DOKUSI del documento ini
		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

		if (Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		if (documentoHecho != null && documentoHecho.getQ5ptcodigo() != null
				&& !documentoHecho.getQ5ptcodigo().equals("")) {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(documentoHecho.getQ5ptcodigo());
			// Obtener la plantilla del tramite
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

			documento.setNolocalizable(plantillaTramite.getNolocalizable());
		}

		// Compruebo si tiene OID de Dokusi
		if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {
			Blob contenido = documentoHecho.getQ5datafile();

			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			// Si no tiene, lo registro en Dokusi y actualizo OID
			documento = y41bDokusiAdapterService.registrarDocumentoDokusiSinLocalizar(documento);
			// Actualizo OID Dokusi en tabla documentos intermedia
			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}
		} else {
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(tramiteComun.getIdTramite());

			tramitehecho = this.tramiteHechoDao.find(tramitehecho);

			if (tramitehecho != null && tramitehecho.getEhcotee() != null
					&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			}
		}

		return documento;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Inspecciones
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiIns(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {
		// Obtener el numero de expediente
		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(this.instramexpService.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

		// Si no tiene tipo documental, metemos por defecto
		// ejgv_d_archivo
		String tipoDocumental = null;

		if (Y41bUtils.isFilled(documentoHecho.getQ5idTipodoc())) {
			tipoDocumental = documentoHecho.getQ5idTipodoc();
		} else {
			tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		}

		documento.setTipoDocumental(tipoDocumental);

		TipoDocumento tipodocumento = new TipoDocumento();
		tipodocumento.setIdTipodoc(tipoDocumental);
		try {
			tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
			if (tipodocumento != null) {
				documento.setTipoDocumento(tipodocumento.getTdnombre());
			} else {
				documento.setTipoDocumento(".");
			}
		} catch (EmptyResultDataAccessException e) {
			documento.setTipoDocumento(".");
		}

		documento.setIdDocumento(documentoHecho.getQ5codocumento());

		// Para que sepa PLATEA que es un RTF (obligatorio)
		documento.setDescripcion(documentoHecho.getQ5tedesfile());
		documento.setNombre(documentoHecho.getQ5nofile());
		documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile()));

		// Calculo el origen de DOKUSI del documento ini
		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

		if (Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_OTROS.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		if (documentoHecho != null && documentoHecho.getQ5ptcodigo() != null
				&& !documentoHecho.getQ5ptcodigo().equals("")) {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(documentoHecho.getQ5ptcodigo());
			// Obtener la plantilla del tramite
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

			documento.setNolocalizable(plantillaTramite.getNolocalizable());
		}

		TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
		tramiteinspeccionAux.setTicodigo(tramiteComun.getIdTramite());

		tramiteinspeccionAux = this.tramiteInspeccionDao.find(tramiteinspeccionAux);

		// Compruebo si tiene OID de Dokusi
		if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {
			// si es aportacion y presencial digitalizado
			if (tramiteinspeccionAux != null && tramiteinspeccionAux.getTicotee() != null
					&& tramiteinspeccionAux.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)
					&& tramiteinspeccionAux.getTiistelematico() == null) {
				// documento.setNaturaleza(Y41bConstantes.NATURALEZA_DIGITALIZADO);
			}

			Blob contenido = documentoHecho.getQ5datafile();

			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			// Si no tiene, lo registro en Dokusi y actualizo OID
			documento = y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
			// Actualizo OID Dokusi en tabla documentos intermedia
			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}

		} else {
			if (tramiteinspeccionAux != null && tramiteinspeccionAux.getTicotee() != null
					&& tramiteinspeccionAux.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)
					&& tramiteinspeccionAux.getTiistelematico() != null
					&& tramiteinspeccionAux.getTiistelematico().equals(Y41bConstantes.VALOR_SI)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			} else {
				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documento.getIdDocumento());
				documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

				if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() == null) {
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documento)
							&& (documento.getNolocalizable() == null
									|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

						LocalizadorDocumento incorporarLocalizador = new LocalizadorDocumento();
						incorporarLocalizador.setOidDocumento(documento.getOidDokusi());
						incorporarLocalizador.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						incorporarLocalizador.setUser(sender);
						incorporarLocalizador.setBoolVersion(true);
						incorporarLocalizador.setBoolReducir(false);
						incorporarLocalizador.setSede("");

						y41bDokusiAdapterService.incorporarLocalizadorDokusi(incorporarLocalizador);
					} else if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						TransformarDocumento transformarDocumento = new TransformarDocumento();
						transformarDocumento.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						transformarDocumento.setUser(sender);
						transformarDocumento.setOidDocumento(documento.getOidDokusi());

						y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);
					}

					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
					} else {
						this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
					}
				}
			}
		}

		return documento;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Inspecciones Sin Localizar
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSinLocalizarIns(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {
		// Obtener el numero de expediente
		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(this.instramexpService.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

		// Si no tiene tipo documental, metemos por defecto
		// ejgv_d_archivo
		String tipoDocumental = null;

		if (Y41bUtils.isFilled(documentoHecho.getQ5idTipodoc())) {
			tipoDocumental = documentoHecho.getQ5idTipodoc();
		} else {
			tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		}

		documento.setTipoDocumental(tipoDocumental);

		TipoDocumento tipodocumento = new TipoDocumento();
		tipodocumento.setIdTipodoc(tipoDocumental);
		try {
			tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
			if (tipodocumento != null) {
				documento.setTipoDocumento(tipodocumento.getTdnombre());
			} else {
				documento.setTipoDocumento(".");
			}
		} catch (EmptyResultDataAccessException e) {
			documento.setTipoDocumento(".");
		}

		documento.setIdDocumento(documentoHecho.getQ5codocumento());

		// Para que sepa PLATEA que es un RTF (obligatorio)
		documento.setDescripcion(documentoHecho.getQ5tedesfile());
		documento.setNombre(documentoHecho.getQ5nofile());
		documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile()));

		// Calculo el origen de DOKUSI del documento ini
		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

		if (Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_INS_APORTADO_OTROS.equals(documentoHecho.getQ5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		if (documentoHecho != null && documentoHecho.getQ5ptcodigo() != null
				&& !documentoHecho.getQ5ptcodigo().equals("")) {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(documentoHecho.getQ5ptcodigo());
			// Obtener la plantilla del tramite
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

			documento.setNolocalizable(plantillaTramite.getNolocalizable());
		}

		// Compruebo si tiene OID de Dokusi
		if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {
			Blob contenido = documentoHecho.getQ5datafile();

			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			// Si no tiene, lo registro en Dokusi y actualizo OID
			documento = y41bDokusiAdapterService.registrarDocumentoDokusiSinLocalizar(documento);
			// Actualizo OID Dokusi en tabla documentos intermedia
			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}
		} else {
			TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
			tramiteinspeccionAux.setTicodigo(tramiteComun.getIdTramite());

			tramiteinspeccionAux = this.tramiteInspeccionDao.find(tramiteinspeccionAux);

			if (tramiteinspeccionAux != null && tramiteinspeccionAux.getTicotee() != null && tramiteinspeccionAux
					.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			}
		}

		return documento;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Sanciones
	 * 
	 * @param sandocTemp
	 *            Sandoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSan(Sandoctemp sandocTemp, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {

		// Calculo el numero del expediente para Dokusi
		Expedien expediente = new Expedien();
		expediente.setExcodigo(tramiteComun.getIdExpediente());
		expediente = this.expedienDao.find(expediente);

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(expediente.damecodCompletoPlatea());

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(sandocTemp.getU5iddocumentum());

		// 2.Tipo Documental
		String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		String tipoDocumento = ".";
		Santipdoc santipdoc = new Santipdoc();
		if (sandocTemp.getU5tipodocumento() != null) {
			santipdoc.setTdid(sandocTemp.getU5tipodocumento());
			santipdoc = this.santipdocDao.find(santipdoc);
			if (santipdoc != null) {
				serieDocumental = (santipdoc.getIdTipodoc());
				if (Y41bUtils.isFilled(santipdoc.getTdnombre())) {
					tipoDocumento = santipdoc.getTdnombre();
				}
			}
		}

		documento.setTipoDocumental(serieDocumental);
		documento.setTipoDocumento(tipoDocumento);

		documento.setIdDocumento(sandocTemp.getU5codocumento());

		documento.setDescripcion(sandocTemp.getU5tedesfile());
		documento.setNombre(sandocTemp.getU5nofile());
		documento.setDescripcion(sandocTemp.getU5tedesfile());

		String extensionFichero = Y41bUtils.getExtensionFile(sandocTemp.getU5nofile());
		documento.setExtension(extensionFichero);

		if (Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE.equals(sandocTemp.getU5origen())
				|| Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_ESTABLECIMIENTO.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO.equals(sandocTemp.getU5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		// COMPROBAR SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE
		// Obtener tramite
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.santramexpDao.find(santramexp);
		if (sandocTemp != null && sandocTemp.getU5ptcodigo() != null && !sandocTemp.getU5ptcodigo().equals("")) {

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(sandocTemp.getU5ptcodigo());
			// Obtener la plantilla del tramite
			List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite, null);
			if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
				documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
			} else {// No existe la
					// plantilla_tramite,
					// miramos en plantilla_decision
				PlantillaDecision plantillaDecision = new PlantillaDecision();
				plantillaDecision.setPdcodigo(sandocTemp.getU5ptcodigo());
				// Obtener la plantilla decision
				long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
				if (cont > 0) {// En esta tabla las
								// plantillas son
								// localizables
								// siempre
					documento.setNolocalizable(Y41bConstantes.VALOR_NO);
				}
			}
		}

		// El tipo documental liquidacion tiene un metadato propio
		if (Y41bConstantes.TIPO_DOC_LIQUIDACION.equals(documento.getTipoDocumental())) {
			String s_metadato = Y41bUtils.esNullOCadenaVacia(santramexp.getTrreferencia()) ? "0"
					: santramexp.getTrreferencia();
			List<Metadato> metadatos = new ArrayList<Metadato>();
			Metadato metadato = new Metadato();
			metadato.setNombre("ejgv_num_liquidacion");
			metadato.setValor(s_metadato);
			metadatos.add(metadato);
			documento.setMetadatos(metadatos);
		}

		if (!Y41bUtils.isFilled(sandocTemp.getU5iddocumentum())) {

			Blob contenido = sandocTemp.getU5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			documento = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);

			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (Y41bUtils.isDocumentoTransformable(documento)) {
				this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(documento.getIdDocumento());
			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}
		} else {
			if (santramexp != null && santramexp.getTrcodigo() != null
					&& santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			} else {

				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documento.getIdDocumento());
				documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

				if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() == null) {
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documento)
							&& (documento.getNolocalizable() == null
									|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

						LocalizadorDocumento incorporarLocalizador = new LocalizadorDocumento();
						incorporarLocalizador.setOidDocumento(documento.getOidDokusi());
						incorporarLocalizador.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						incorporarLocalizador.setUser(sender);
						incorporarLocalizador.setBoolVersion(true);
						incorporarLocalizador.setBoolReducir(false);
						incorporarLocalizador.setSede("");

						y41bDokusiAdapterService.incorporarLocalizadorDokusi(incorporarLocalizador);
					} else if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						TransformarDocumento transformarDocumento = new TransformarDocumento();
						transformarDocumento.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						transformarDocumento.setUser(sender);
						transformarDocumento.setOidDocumento(documento.getOidDokusi());

						y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);
					}

					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(documento.getIdDocumento());
					documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
					} else {
						this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
					}
				}
			}
		}

		return documento;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Arbitraje
	 * 
	 * @param arbdocTemp
	 *            Arbdoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiArb(Arbdoctemp arbdocTemp, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {

		// Calculo el numero del expediente para Dokusi
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(solarb.damecodCompletoPlatea());

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
		documento.setProcedure(procedure);

		documento.setOidDokusi(arbdocTemp.getX5iddocumentum());

		// 2.Tipo Documental
		String serieDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		String tipoDocumento = ".";
		Arbtipdoc arbtipdoc = new Arbtipdoc();
		if (arbdocTemp.getArbtipdoc().getTdid() != null) {
			arbtipdoc.setTdid(arbdocTemp.getArbtipdoc().getTdid());
			arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
			if (arbtipdoc != null) {
				serieDocumental = (arbtipdoc.getIdTipodoc());
				if (Y41bUtils.isFilled(arbtipdoc.getTdnombre())) {
					tipoDocumento = arbtipdoc.getTdnombre();
				}
			}
		}
		documento.setTipoDocumental(serieDocumental);
		documento.setTipoDocumento(tipoDocumento);

		documento.setIdDocumento(arbdocTemp.getX5codocumento());

		documento.setDescripcion(arbdocTemp.getX5tedesfile());
		documento.setNombre(arbdocTemp.getX5nofile());
		documento.setDescripcion(arbdocTemp.getX5tedesfile());

		String extensionFichero = Y41bUtils.getExtensionFile(arbdocTemp.getX5nofile());
		documento.setExtension(extensionFichero);

		if (Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdocTemp.getX5origen())
				|| Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE2.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_ESTABLECIMIENTO.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_ARBITRO.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_PERITO.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO.equals(arbdocTemp.getX5origen())
				|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE.equals(arbdocTemp.getX5origen())) {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
		} else {
			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
		}

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		// COMPROBAR SI EL TIPO DE DOCUMENTO NO ES LOCALIZABLE
		// Obtener tramite
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp = this.arbtramexpDao.find(arbtramexp);
		if (arbdocTemp != null && arbdocTemp.getX5ptcodigo() != null && !arbdocTemp.getX5ptcodigo().equals("")) {

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(arbdocTemp.getX5ptcodigo());
			// Obtener la plantilla del tramite
			List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite, null);
			if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
				documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
			} else {// No existe la
					// plantilla_tramite,
					// miramos en plantilla_decision
				PlantillaDecision plantillaDecision = new PlantillaDecision();
				plantillaDecision.setPdcodigo(arbdocTemp.getX5ptcodigo());
				// Obtener la plantilla decision
				long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
				if (cont > 0) {// En esta tabla las
								// plantillas son
								// localizables
								// siempre
					documento.setNolocalizable(Y41bConstantes.VALOR_NO);
				}
			}
		}

		if (!Y41bUtils.isFilled(arbdocTemp.getX5iddocumentum())) {

			Blob contenido = arbdocTemp.getX5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

			documento = this.y41bDokusiAdapterService.registrarDocumentoDokusi(documento);

			Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

			adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
			adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
			this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

			if (Y41bUtils.isDocumentoTransformable(documento)) {
				this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
			} else {
				this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
			}

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(documento.getIdDocumento());
			documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

			// Actualizo OID Dokusi en tabla documentos hecho
			// Update oid de documentum
			this.documentoHechoDao.updateOIDDokusi(documentoHecho);

			if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
			} else {
				this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
			}
		} else {
			if (arbtramexp != null && arbtramexp.getTrcodigo() != null
					&& arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION)
					&& arbtramexp.getTristelematica() != null
					&& arbtramexp.getTristelematica().equals(Y41bConstantes.VALOR_SI)) {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			} else {
				y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);

				DocumentoHecho documentoHechoAux = new DocumentoHecho();
				documentoHechoAux.setQ5codocumento(documento.getIdDocumento());
				documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

				if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() == null) {
					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documento)
							&& (documento.getNolocalizable() == null
									|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

						LocalizadorDocumento incorporarLocalizador = new LocalizadorDocumento();
						incorporarLocalizador.setOidDocumento(documento.getOidDokusi());
						incorporarLocalizador.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						incorporarLocalizador.setUser(sender);
						incorporarLocalizador.setBoolVersion(true);
						incorporarLocalizador.setBoolReducir(false);
						incorporarLocalizador.setSede("");

						y41bDokusiAdapterService.incorporarLocalizadorDokusi(incorporarLocalizador);
					} else if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						TransformarDocumento transformarDocumento = new TransformarDocumento();
						transformarDocumento.setProcedure(procedure);
						User sender = new User();
						sender.setNombre(Y41bConstantes.COD_APLICACION);
						sender.setDni(Y41bConstantes.COD_APLICACION);
						transformarDocumento.setUser(sender);
						transformarDocumento.setOidDocumento(documento.getOidDokusi());

						y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);
					}

					Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

					adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.adjuntardocsDao.updateFechaLocalizacion(adjuntardocsAuxUpdateOID);
					} else {
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}

					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(documento.getIdDocumento());
					documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

					if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
						this.documentoHechoDao.updateFechaLocalizacion(documentoHecho);
					} else {
						this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
					}
				}
			}
		}

		return documento;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	private void eliminarDocumentosDokusi(List<DocumentoExpediente> listDocumentoExpediente) throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				if (documentoExpediente != null && documentoExpediente.getIddocumentum() != null
						&& !documentoExpediente.getIddocumentum().equals("")) {

					documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(documentoExpediente.getCodocumento());
					Long numTramitesUtilizado = this.documentoHechoDao.findAllDocTramiteHechoCount(documentoHecho);

					if (numTramitesUtilizado == 0) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoExpediente.getIddocumentum());
						documento.setBoolAllVersions("true");

						y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					}
				}
			}
		}
	}

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	private void eliminarMisGestionesReclamante(TramiteHecho tramitehecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());

		y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
	}

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	private void eliminarMisGestionesReclamado(TramiteHecho tramitehecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());

		y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesComunicacionReclamante(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		if (Y41bUtils.isFilled(tramitehecho.getEhidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramitehecho.getEhidnotificacionplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que crea la participacin del reclamado en Mis Gestiones
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	public void crearParticipacionMisGestionesReclamado(TramiteHecho tramitehecho) throws Exception {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		if (solicitudDetalle.getHdparticipacionreclamado() == null
				|| solicitudDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_NO)) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
			this.actualizarParticipacionReclamado(tramiteComun);

			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciado.setHdparticipacionreclamado(Y41bConstantes.VALOR_SI);
			this.hechoDenunciadoDao.updateParticipacionReclamado(hechodenunciado);

		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 */
	public void actualizarMisGestionesComunicacionReclamado(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		if (solicitudDetalle.getHdparticipacionreclamado() == null
				|| solicitudDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_NO)) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
			this.actualizarParticipacionReclamado(tramiteComun);

			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciado.setHdparticipacionreclamado(Y41bConstantes.VALOR_SI);
			this.hechoDenunciadoDao.updateParticipacionReclamado(hechodenunciado);

		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getEsnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getEsnombre());

		datosPersona.setNombre(nombreCompleto.toString());

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		if (Y41bUtils.isFilled(tramitehecho.getEhidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramitehecho.getEhidnotificacionplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesNotificacionReclamante(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());

		TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

		actualizarMisGestiones.setIdnotificacionplatea(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea());

		if (Y41bUtils.isFilled(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones
				.setIdTiponotificacionplatea(tramitehechoAux.getTramiteHecho().getEhtiponotificacionplatea());

		Calendar notificacionPublicationTimestamp = Calendar.getInstance();
		notificacionPublicationTimestamp.setTime(tramitehechoAux.getTramiteHecho().getEhfechafin());
		actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);

		Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
		notificacionDeliveryTimestamp.setTime(tramitehecho.getEhacuserecibo());
		actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);

		actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(tramitehecho.getEhacusereciborecibido());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 */
	public void actualizarMisGestionesNotificacionReclamado(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		if (solicitudDetalle.getHdparticipacionreclamado() == null
				|| solicitudDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_NO)) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
			this.actualizarParticipacionReclamado(tramiteComun);

			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciado.setHdparticipacionreclamado(Y41bConstantes.VALOR_SI);
			this.hechoDenunciadoDao.updateParticipacionReclamado(hechodenunciado);

		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getEsnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getEsnombre());

		datosPersona.setNombre(nombreCompleto.toString());

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());

		TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

		actualizarMisGestiones.setIdnotificacionplatea(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea());

		if (Y41bUtils.isFilled(tramitehechoAux.getTramiteHecho().getEhidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones
				.setIdTiponotificacionplatea(tramitehechoAux.getTramiteHecho().getEhtiponotificacionplatea());

		Calendar notificacionPublicationTimestamp = Calendar.getInstance();
		notificacionPublicationTimestamp.setTime(tramitehechoAux.getTramiteHecho().getEhfechafin());
		actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);

		Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
		notificacionDeliveryTimestamp.setTime(tramitehecho.getEhacuserecibo());
		actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);

		actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(tramitehecho.getEhacusereciborecibido());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de requerimiento de
	 * subsanacion al consumidor
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRequerimientoSubsanacionConsumidor(TramiteHecho tramitehecho)
			throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_REQUERIMIENTO_SUBSANACION_CONSUMIDOR_EU);

		y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionReclamante(TramiteHecho tramitehecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bUtils.isFilled(tramitehecho.getEhproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_DECISION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_DECISION_EU);

		Decision decision = new Decision();
		decision.setDecodigo(tramitehecho.getEhdecodigo());

		decision = this.decisionDao.find(decision);

		actualizarMisGestiones.setDecisionCas(decision.getDenombre());
		actualizarMisGestiones.setDecisionEus(decision.getDenombree());

		Calendar decisionTimestamp = Calendar.getInstance();
		decisionTimestamp.setTime(tramitehecho.getEhfecharesolucion());
		actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);

		y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);

		tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionReclamado(TramiteHecho tramitehecho) throws SQLException {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		if (solicitudDetalle.getHdparticipacionreclamado() != null
				&& solicitudDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {

			ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

			actualizarMisGestiones.setProcedure(procedure);

			actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamado());

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(solicitudDetalle.getEsnif());

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append(solicitudDetalle.getEsnombre());

			datosPersona.setNombre(nombreCompleto.toString());

			actualizarMisGestiones.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-")
					.append(solicitudDetalle.getDecoor()).append("-").append(solicitudDetalle.getDenror()).append("-")
					.append(solicitudDetalle.getDenran()).append("-").append(solicitudDetalle.getHdnror());

			actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

			actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			if (Y41bUtils.isFilled(tramitehecho.getEhproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
			}

			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_DECISION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_DECISION_EU);

			Decision decision = new Decision();
			decision.setDecodigo(tramitehecho.getEhdecodigo());

			decision = this.decisionDao.find(decision);

			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());

			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(tramitehecho.getEhfecharesolucion());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);

			y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);

			tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);

		}
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @throws SQLException
	 */
	private void calcularEstadoTramiteGenerado(TramiteHecho tramiteHecho) throws SQLException {
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteHecho.getEhestadotramite())) {

			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteHecho.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			boolean todosFirmados = true;
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (listDocumentoHecho.get(i).getQ5estadodocumento() != null && !listDocumentoHecho.get(i)
							.getQ5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
						todosFirmados = false;
						break;
					}
				}
			}
			if (todosFirmados) {
				boolean firmado = false;
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (int i = 0; i < listDocumentoHecho.size(); i++) {
						if (listDocumentoHecho.get(i).getQ5estadodocumento() != null) {
							firmado = true;
							break;
						}
					}
				}

				if (firmado) {
					tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
				} else {
					tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}

			} else {
				boolean pendienteFirma = false;
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (int i = 0; i < listDocumentoHecho.size(); i++) {
						if (listDocumentoHecho.get(i).getQ5estadodocumento() != null) {
							pendienteFirma = true;
							break;
						}
					}
				}

				if (pendienteFirma) {
					tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
				} else {
					tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
			}
		}

		this.tramiteHechoDao.updateEstadoTramite(tramiteHecho);
	}

	/**
	 * Metodo que comprueba que los documentos enviados a remesa no tienen
	 * problemas para ser remesados
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 *             Exception
	 */
	public void controlDocumentosProtegidosRemesa(List<Adjuntardocs> listadjuntardocs) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		DocumentoHechoDetalle documentoHechoDetalle = null;
		for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
			documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(adjuntardocsAux.getThcodocumento());
			documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getQ5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());
			try {
				Document document = new Document();
				int totalPages = 0;
				PdfReader pdfReader = new PdfReader(bContenido);
				totalPages = pdfReader.getNumberOfPages();

				ByteArrayOutputStream bos = new ByteArrayOutputStream();

				ObjectOutputStream os = new ObjectOutputStream(bos);

				// Create a writer for the outputstream
				PdfWriter writer = PdfWriter.getInstance(document, os);

				document.open();
				BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
				PdfContentByte cb = writer.getDirectContent(); // Holds
																// the
																// PDF
				// data

				boolean paginate = false;
				int pageOfCurrentReaderPDF = 0;
				int currentPageNumber = 0;
				PdfImportedPage page;
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader.getPageN(pageOfCurrentReaderPDF + 1));
					// if (r.getWidth() == 792.0 && r.getHeight() ==
					// 612.0)
					if (r.getWidth() > r.getHeight())
						document.setPageSize(PageSize.A4.rotate());
					else
						document.setPageSize(PageSize.A4);
					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;
					page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
					cb.addTemplate(page, 0, 0);

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, 9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, "" + currentPageNumber + " of " + totalPages,
								520, 5, 0);
						cb.endText();
					}
				}
				pageOfCurrentReaderPDF = 0;
				pdfReader.close();

				if (document.isOpen()) {
					document.close();
				}
				writer.close();
				os.writeObject(new Date());
				os.close();
			} catch (Exception e) {
				StringBuffer errorPassword = new StringBuffer();
				errorPassword.append(appMessageSource.getMessage("error.documentos.passwordremesapdf", null, locale));
				errorPassword.append(documentoHechoDetalle.getQ5nofile());
				throw new Y41bUDAException(errorPassword.toString(), true, new Exception());
			} finally {
			}
		}
	}

	private boolean validarSiSolicitudEstaCompleta(SolicitudDetalle solDetalle) {
		return solDetalle != null && (solDetalle.getHdcosc() == null || solDetalle.getHdcosc().equals("")
				|| solDetalle.getDefede() == null || solDetalle.getDefede().equals("") || solDetalle.getDefere() == null
				|| solDetalle.getDefere().equals("") || solDetalle.getTfpcodigo() == null
				|| solDetalle.getTfpcodigo().equals("") || solDetalle.getDtcodigo() == null
				|| solDetalle.getDtcodigo().equals("") || solDetalle.getHdformanotificacion() == null
				|| solDetalle.getHdformanotificacion().equals("") || solDetalle.getEscodigo() == null
				|| solDetalle.getEscodigo().equals("") || solDetalle.getHdformanotificacionestablecimiento() == null
				|| solDetalle.getHdformanotificacionestablecimiento().equals("") || solDetalle.getHdfehd() == null
				|| solDetalle.getHdfehd().equals("") || solDetalle.getHdte() == null || solDetalle.getHdte().equals("")
				|| solDetalle.getPscodigo() == null || solDetalle.getPscodigo().equals("")
				|| solDetalle.getTircodigo() == null || solDetalle.getTircodigo().equals("")
				|| solDetalle.getFvcodigo() == null || solDetalle.getFvcodigo().equals("")
				|| ((solDetalle.getTsrcodigo() == null || solDetalle.getTsrcodigo().equals(""))
						&& !Y41bConstantes.VALOR_SI.equals(solDetalle.getHddenunciaaaccempresas()))
				|| solDetalle.getNumregistroentrada() == null || solDetalle.getNumregistroentrada().equals(""));
	}

	/**
	 * Validar si una sede existe en la base de datos.
	 * 
	 * @param idInterviniente
	 *            String
	 */
	public void validarSiExisteSede(String idInterviniente) {
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(idInterviniente);

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (Y41bUtils.isFilled(intervinientes.getNif())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(intervinientes.getNif());

			establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

			if (establecimiento == null) {
				throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
			}
		} else {
			throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
		}
	}

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 * @param remesaEmitida
	 * @param envio
	 * @param fechaSituacion
	 * @param situacionCorreos
	 * @param estadoDelEnvio
	 * @param documentoByte
	 * @param filename
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoByte, String filename) {

		// "Salir si no est respondido por Correos"
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)
				&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
			return;
		}

		TramiteComun tramiteComun = null;
		TramiteAcuseRecibo tramiteAcuseRecibo = null;

		if (envio.getIdTramiteAcuseRelacionado() != null) {
			try {
				// Buscar el trmite de Acuse relacionado con el envio
				tramiteAcuseRecibo = new TramiteAcuseRecibo();
				tramiteAcuseRecibo.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				tramiteAcuseRecibo = this.findTramiteAcuseRecibo(tramiteAcuseRecibo, censoMonitor);

				if (tramiteAcuseRecibo == null) {
					throw new Exception(envio.getIdTramiteAcuseRelacionado());
				}

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(envio.getHdcodigo());
				tramiteComun.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(remesaEmitida.getRmtipoproc());
				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				// "Crear el documento hecho del PEE para asociar al tramite,
				// siempre y cuando el envio no haya dado error"
				// " El unico error que se ha podido dar es que no exista
				// documento PEE; ya que el resto dan excepcin previa y no
				// entran por aqui"
				DocumentoHecho docHechoPEE_Aux = null;
				if (!Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
					docHechoPEE_Aux = new DocumentoHecho();
					docHechoPEE_Aux.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

					docHechoPEE_Aux.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
					docHechoPEE_Aux.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO);
					Blob blob = new SerialBlob(documentoByte);
					docHechoPEE_Aux.setQ5datafile(blob);
					docHechoPEE_Aux.setQ5contenttypefile(Y41bConstantes.CONTENT_TYPE_PDF);
					docHechoPEE_Aux.setQ5nofile(filename);
					docHechoPEE_Aux.setQ5tedesfile(Y41bConstantes.PRUEBA_ENTREGA_ENVIO);
					docHechoPEE_Aux.setQ5sizefile((int) documentoByte.length);
					docHechoPEE_Aux.setQ5hdcodigo(tramiteComun.getIdExpediente());
					docHechoPEE_Aux.setQ5tramite(tramiteComun.getIdTramite());
					docHechoPEE_Aux.setQ5fecha(new Date());
				}

				// "Actualizar tramite de acuse de recibo asociado al envio"
				Date fecha;
				fecha = Y41bUtils.convertFromSQLDateToJAVADate(
						Y41bUtils.formatearStringToDateFormato(fechaSituacion, Y41bConstantes.FORMATO_FECHA_ES));
				tramiteAcuseRecibo.setFechaacuse(fecha);

				if (situacionCorreos != null) {
					tramiteAcuseRecibo.setSituacionacuse(situacionCorreos);
				}

				// "Si el trmite ya estaba TRAMITADO, entonces SOLO se aade el
				// documeto PEE al trmite"
				if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteAcuseRecibo.getEstadoTramite())) {

					// "Solo si ha sido respondido por Correos"
					if (Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)) {

						this.documentoHechoDao.add(docHechoPEE_Aux);

						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
						documentoTramiteHecho.setCodocumento(docHechoPEE_Aux.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
					// "ELSE: Si el envo viene erroneo; entonces NO se hace
					// nada, se queda a la espera de que venga el documento PEE"

				} else {

					// "Si la situacin devuelta por Correos es convertida a
					// ACUSE ACEPTADO, entonces hay que tramitar el trmite de
					// Acuese e informar al responsable."
					// "Aunque solo en el caso de que NO se haya producido un
					// error (el de no existe PEE, ya que el resto lanzan
					// excepcin y no pasan por aqu)"
					if (situacionCorreos != null
							&& situacionCorreos.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
							&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {

						// "Aceptado y NO erroneo >>> Tramita acuse y envia
						// email al responsable."
						this.tramitarEditTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun,
								docHechoPEE_Aux);
						this.envioMailAcuseRecibo(tramiteComun, fecha);

					} else {
						// "Guarda acuse."
						this.editTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, docHechoPEE_Aux);
					}
				}
			} catch (ParseException e) {
				logger.error("error ParseException", e);
				throw new Y41bUDAException("error.generico", true, e);
			} catch (Exception e) {
				logger.error("error genrico", e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * Envio mail acuse de recibo aceptado
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param fecha
	 *            Date
	 */
	private void envioMailAcuseRecibo(TramiteComun tramiteComun, Date fecha) {
		// Enviar mail
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.denunciaService.findSolicitud(solicitudDetalle, null);

		String numeroExpediente = Y41bConstantes.TIPO_PROC_SOLICITUDES + "-" + solDetalle.getNumExpediente();

		CensoMonitor responsableExpediente = new CensoMonitor();
		responsableExpediente.setMocodigo(solDetalle.getMocodigo());

		if (responsableExpediente.getMocodigo() != null && !responsableExpediente.getMocodigo().equals("")) {
			responsableExpediente = this.censoMonitorDao.find(responsableExpediente);
		}

		String from = "";
		if (responsableExpediente != null && responsableExpediente.getOrganismo() != null) {
			from = responsableExpediente.getOrganismo().getEmail();
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.CASTELLANO)));

		asunto.append(" ").append(numeroExpediente).append(" / ");

		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);

		StringBuffer texto = new StringBuffer();
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append("</B>");
		texto.append(" ").append(numeroExpediente).append("<BR>");
		texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
				new Locale(Y41bConstantes.CASTELLANO))).append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.CASTELLANO)).append("<BR><BR>");

		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(numeroExpediente).append("<BR>");
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.textofecha", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.EUSKERA)).append("<BR><BR>");

		String destinatariosMail = responsableExpediente.getMocoem();

		ArrayList attachments = new ArrayList();

		// Envio mail
		Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatariosMail, "", attachments);
	}

	/**
	 * Obtiene el responsable del expediente
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 * @return String
	 */
	private String obtenerResponsableExpediente(TramiteComun tramiteComun) {
		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		return solicitudDetalle.getMocodigo();
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de arbitraje con la
	 * informacion del tramitehecho recibido por parametro
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	public void tratamientoBandejaPropuestaArbitraje(TramiteHecho tramitehecho) {
		logger.info("TratamientoBandejaPropuestaArbitraje Ini");
		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
		// Codigo del hecho denunciado
		arbpropbandeja.setBaprarbexcodigo(tramitehecho.getEhcohd());
		// Num expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
		arbpropbandeja.setBaprarbexcodigocompleto(numeroExpediente.toString());
		// Procedimiento
		arbpropbandeja.setBaprarbpcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		// Fecha registro
		// 20150401: Cambiamos a fecha del hecho, a la fecha del hecho
		// denunciado
		arbpropbandeja.setBaprarbfec(solDetalle.getHdfehd());
		// Buscamos el interviniente Denunciado (Establecimiento)
		// Datos del establecimiento Ini
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramitehecho.getEhcohd());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			arbpropbandeja.setEstablecimiento(new Establecimiento(listIntervinientes.get(0).getEscodigo()));
			arbpropbandeja.setBaprarbmunic(listIntervinientes.get(0).getNoraMunicipioId());
			arbpropbandeja.setBaprarbprov(listIntervinientes.get(0).getNoraProvinciaId());
		}
		// Datos del establecimiento Fin
		// Responsable del expediente
		arbpropbandeja.setBaprarbrespexp(solDetalle.getMocodigo());

		this.arbpropbandejaService.add(arbpropbandeja);
		logger.info("TratamientoBandejaPropuestaArbitraje Fin");
	}

	// 111718 - Se aade este metodo para poder resetear el flag del expediente
	// de solicitud que impide que se pueda modificar en y41a
	/**
	 * Esta funcion quita el flag de arbitraje del hecho denunciado
	 * 
	 * @param ehcohd
	 *            String
	 */
	public void resetIndicadorArbitraje(String ehcohd) {
		logger.info("resetIndicadorArbitraje Ini");
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(ehcohd);
		hechodenunciadoAux.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);

		this.hechoDenunciadoDao.updateIndicadorArbitraje(hechodenunciadoAux);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(ehcohd);

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		Organismo organismo = new Organismo();
		organismo.setCodOrg(solDetalle.getHccoor());
		Long total = this.organismoDao.findAllLikeOrganismosOmicAsociacionCount(organismo, false);

		// Es una omic, se actualiza en la tabla L2125T00 los campos HCCOTTD y
		// HCFEDE a null
		if (total > 0) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(ehcohd);
			TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
			this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);
		}

		logger.info("resetIndicadorArbitraje Fin");
	}

	/**
	 * Esta funcion realiza el envio de la comunicacion en una recepcin de
	 * traslado
	 * 
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param traslados
	 *            List<TrasladoBusqueda>
	 * @throws Exception
	 */
	public void tratamientoEnviarcomunicacionDesdePropuestaArbitraje(String hdcodigo, boolean aceptado,
			String expedienteArbitraje, String mocodigo, String textoRechazo) throws Exception {
		// enviar comunicacion
		Comunicacion comunicacion = new Comunicacion();
		comunicacion.setM4cocomu(this.comunicacionDao.getNewPK());

		Organismo organismoComunicacion = new Organismo();
		organismoComunicacion.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);

		TipoComunicacion tipoComunicacion = new TipoComunicacion(Y41bConstantes.TIPO_COMUNICACION_NO_REPLY, null, null,
				null, null, null, null, null);

		comunicacion.setOrganismo(organismoComunicacion);
		comunicacion.setTipoComunicacion(tipoComunicacion);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

		String[] args = { numeroExpediente.toString() };
		// recuperar texto de properties
		StringBuffer asunto = new StringBuffer();

		if (aceptado) {
			asunto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.asunto.aceptado", args,
					new Locale(Y41bConstantes.CASTELLANO)));
			asunto.append(" / ");
			asunto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.asunto.aceptado", args,
					new Locale(Y41bConstantes.EUSKERA)));
		} else {
			asunto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.asunto.rechazado", args,
					new Locale(Y41bConstantes.CASTELLANO)));
			asunto.append(" / ");
			asunto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.asunto.rechazado", args,
					new Locale(Y41bConstantes.EUSKERA)));
		}

		comunicacion.setM4tesubject(asunto.toString());

		StringBuffer texto = new StringBuffer();
		if (aceptado) {
			String args1[] = { expedienteArbitraje };
			texto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.textoAceptada", args1,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ");
			texto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.textoAceptada", args1,
					new Locale(Y41bConstantes.EUSKERA)));
		} else {
			String args1[] = { numeroExpediente.toString() };
			texto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.textoRechazada.1", args1,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ");
			texto.append(appMessageSource.getMessage("propuestaArbitraje.comunicacion.textoRechazada.1", args1,
					new Locale(Y41bConstantes.EUSKERA)));
			if (textoRechazo != null) {
				texto.append("\r\n").append(textoRechazo);
			}
		}

		comunicacion.setM4tecomu(texto.toString());

		// buscar monitor
		CensoMonitor remitente = new CensoMonitor();
		remitente.setMocodigo(mocodigo);

		remitente = this.censoMonitorDao.find(remitente);

		comunicacion.setM4noremi(Y41bUtils.isFilled(remitente.getMonombre()) ? remitente.getMonombre() : "ARBITRAJE");

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		if (locale == null || (!locale.getLanguage().equals(Y41bConstantes.CASTELLANO)
				&& !locale.getLanguage().equals(Y41bConstantes.EUSKERA))) {
			locale = new Locale(Y41bConstantes.CASTELLANO);
		}

		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		comunicacion.setM4feenv(todayWithZeroTime);
		comunicacion.setM4fecad(todayWithZeroTime);

		comunicacion.setM4nudest(new Long(1));
		comunicacion.setM4nufiladj(new Long(0));
		comunicacion.setM4incomact(0);
		comunicacion.setM4incombl(0);

		this.comunicacionDao.add(comunicacion);

		DestComunicacion destcomunicacion = new DestComunicacion();

		Organismo organismoDestComunicacion = new Organismo();
		organismoDestComunicacion.setCodOrg(solDetalle.getHccoor());

		destcomunicacion.setOrganismo(organismoDestComunicacion);
		destcomunicacion.setComunicacion(comunicacion);

		this.destComunicacionDao.add(destcomunicacion);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionInspeccion findTramiteRecepcionInspeccion(
			TramiteRecepcionInspeccion tramiteRecepcionInspeccion, CensoMonitor censoMonitor) {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteRecepcionInspeccion.getIdTramite());

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		TramiteRecepcionInspeccion tramiteRecepcionInspeccionAux = new TramiteRecepcionInspeccion();
		tramiteRecepcionInspeccionAux.setIdTramite(tramitehecho.getEhcodigo());
		tramiteRecepcionInspeccionAux.setFechaInicio(tramitehecho.getEhfechainicio());
		tramiteRecepcionInspeccionAux.setFechaFin(tramitehecho.getEhfechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramitehecho.getEhcomoasignado());

		if (tramitehecho.getEhcomoasignado() != null && !tramitehecho.getEhcomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionInspeccionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramitehecho.getEhcomoejecucion());

		if (tramitehecho.getEhcomoejecucion() != null && !tramitehecho.getEhcomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionInspeccionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionInspeccionAux.setEstadoTramite(tramitehecho.getEhestadotramite());

		tramiteRecepcionInspeccionAux.setEhcoactua(tramitehecho.getEhcoactua());
		tramiteRecepcionInspeccionAux.setEhresumenins(tramitehecho.getEhresumenins());
		tramiteRecepcionInspeccionAux.setEhaceptacionins(tramitehecho.getEhaceptacionins());
		tramiteRecepcionInspeccionAux.setEhmotivoins(tramitehecho.getEhmotivoins());
		tramiteRecepcionInspeccionAux.setEhcodins(tramitehecho.getEhcodins());

		TramiteHecho tramiteHechoAux = this.tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		tramiteRecepcionInspeccionAux.setComentario(tramiteHechoAux.getEhtexto());

		if (tratamientoSeguridad(tramitehecho, censoMonitor)) {
			tramiteRecepcionInspeccionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionInspeccionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionInspeccionAux;
	}

	/**
	 * Guardar tramite de Enviar Salida SIR
	 * 
	 * @param tramiteEnviarSalidaSIR
	 *            TramiteEnviarSalidaSIR
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteEnviarSalidaSIR(TramiteEnviarSalidaSIR tramiteEnviarSalidaSIR,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ENVIAR_SALIDA_SIR);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteEnviarSalidaSIR.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteEnviarSalidaSIR.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteEnviarSalidaSIR.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteEnviarSalidaSIR.getComentario());

		tramitehecho.setEhasuntocomunicacion(tramiteEnviarSalidaSIR.getAsunto());

		tramitehecho.setEhidunidaddir3(tramiteEnviarSalidaSIR.getUnidadesDir3().getIdUnidadDir3());

		tramitehecho.setEhfecharegistrosalida(tramiteEnviarSalidaSIR.getFechasalida());
		tramitehecho.setEhnumregistrosalida(tramiteEnviarSalidaSIR.getNumregistrosalida());

		if (tramitar) {
			tramitehecho.setEhfechafin(tramiteEnviarSalidaSIR.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteEnviarSalidaSIR.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

		this.procesarDocumentosTramite(tramiteComun);

		// Obtenemos los documentos del tramite
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (tramitar) {
			this.controlDocumentosPendientesFirmaSIRTramitar(tramiteComun, Y41bConstantes.TIPO_PROC_SOLICITUDES);

			this.controlDocumentosPDFSIRTramitar(listadjuntardocs);

			this.procesarEnvioSIRSalida(listDocumentoHecho, tramitehecho);

		} else {
			this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun,
					Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			/******************************************/
		}

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_ENVIAR_SALIDA_SIR, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramitehecho;
	}

	/**
	 * Guardar tramite de Recepcion de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param TramiteRecepcionInspeccion
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionInspeccion(TramiteRecepcionInspeccion tramiteRecepcionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(tramiteRecepcionInspeccion.getFechaInicio());
		tramitehecho.setEhcomoasignado(tramiteRecepcionInspeccion.getInstructorAsignado().getMocodigo());
		tramitehecho.setEhcomo(tramiteRecepcionInspeccion.getInstructorEjecucion().getMocodigo());
		tramitehecho.setEhtexto(tramiteRecepcionInspeccion.getComentario());

		tramitehecho.setEhresumenins(tramiteRecepcionInspeccion.getEhresumenins());
		tramitehecho.setEhaceptacionins(tramiteRecepcionInspeccion.getEhaceptacionins());
		tramitehecho.setEhmotivoins(tramiteRecepcionInspeccion.getEhmotivoins());
		tramitehecho.setEhcodins(tramiteRecepcionInspeccion.getEhcodins());
		tramitehecho.setEhcoactua(tramiteRecepcionInspeccion.getEhcoactua());

		if (tramitar) {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				if (!Y41bConstantes.VALOR_SI.equals(tramiteRecepcionInspeccion.getEhaceptacionins())) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(tramiteRecepcionInspeccion.getEhcoactua());

					TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
					tramiteInspeccion.setTimotivoampli(tramiteRecepcionInspeccion.getEhmotivoins());

					this.instramexpService.generarTramiteAmpliacionInspeccion(tramiteInspeccion, tramiteComunAux);
				} else {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(tramiteRecepcionInspeccion.getEhcoactua());

					this.instramexpService.generarTramiteAutomatico(tramiteComunAux,
							Y41bConstantes.TRAMITE_INSPECCIONES_ACEPTACION_INFORME_VALORACION);
				}
			}
			tramitehecho.setEhfechafin(tramiteRecepcionInspeccion.getFechaFin());
			tramitehecho.setEhcomoejecucion(tramiteRecepcionInspeccion.getInstructorEjecucion().getMocodigo());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramitehecho);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteHechoService.updateTramiteHecho(tramitehecho);
		}

		this.procesarDocumentosTramite(tramiteComun);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION, null, tramiteComun.getIdExpediente());

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramitehecho;
	}

	/**
	 * Generar Tramite automatico de Recepcion de de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRecepcionInspeccion(TramiteHecho tramiteRecepcionInspeccion,
			TramiteComun tramiteComun) throws Exception {
		TramiteHecho tramiteHecho = new TramiteHecho();
		tramiteHecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteHecho.setEhcohd(tramiteComun.getIdExpediente());
		tramiteHecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION);

		// Evita problemas con las fechas desde hasta
		tramiteHecho.setEhfecha(tramiteRecepcionInspeccion.getEhfecha());
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramiteHecho.setEhhora(ehhora);
		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteHecho.setEhfechainicio(tramiteRecepcionInspeccion.getEhfechainicio());

		tramiteHecho.setEhcomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteHecho.setEhcomo(this.obtenerResponsableExpediente(tramiteComun));
		tramiteHecho.setEhtexto("");
		tramiteHecho.setTramiteHecho(tramiteRecepcionInspeccion);
		tramiteHecho.setEhcoactua(tramiteRecepcionInspeccion.getEhcoactua());
		tramiteHecho.setEhresumenins(tramiteRecepcionInspeccion.getEhresumenins());
		tramiteHecho.setEhcodins(tramiteRecepcionInspeccion.getEhcodins());
		tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramiteHecho);

		// Actualizar ultimo tramite
		TramiteHecho tramiteHechoAux = new TramiteHecho();
		tramiteHechoAux.setEhcohd(tramiteComun.getIdExpediente());
		this.actualizarUltimoTramite(tramiteHechoAux);

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramiteHecho;
	}

	/**
	 * Generar Tramite automatico de Recepcion de de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentosHecho
	 *            List<DocumentoHecho>
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRecepcionInspeccion(TramiteHecho tramiteRecepcionInspeccion,
			TramiteComun tramiteComun, List<DocumentoHecho> documentosHecho) throws Exception {

		// buscar el ultimo tramite de recepcin no tramitado
		TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
		tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION);
		tramiteHechoDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
		try {
			tramiteHechoDetalleAux = this.tramiteHechoDao
					.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteHechoDetalleAux);
		} catch (Exception e) {
		}

		TramiteHecho tramiteHecho = new TramiteHecho();

		if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {
			// si existe se actualiza
			TramiteHecho tramitehechoAux = new TramiteHecho();
			tramitehechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

			tramiteHecho = this.tramiteHechoDao.find(tramitehechoAux);

			tramiteHecho.setEhresumenins(tramiteRecepcionInspeccion.getEhresumenins());

			// Se actualiza el tramite
			this.tramiteHechoService.updateTramiteHecho(tramiteHecho);
		} else {
			// si no existe se genera
			tramiteHecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteHecho.setEhcohd(tramiteComun.getIdExpediente());
			tramiteHecho.setEhcotee(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION);

			// Evita problemas con las fechas desde hasta
			tramiteHecho.setEhfecha(tramiteRecepcionInspeccion.getEhfecha());
			// La hora Ini
			String ehhora = null;
			try {
				Calendar todayCalendar = Calendar.getInstance();
				todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_2);
				ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}
			// La hora Fin
			tramiteHecho.setEhhora(ehhora);
			// Ponemos en la fecha de inicio la fecha en la que se genera
			tramiteHecho.setEhfechainicio(tramiteRecepcionInspeccion.getEhfechainicio());

			tramiteHecho.setEhcomoasignado(this.obtenerResponsableExpediente(tramiteComun));
			tramiteHecho.setEhcomo(this.obtenerResponsableExpediente(tramiteComun));
			tramiteHecho.setEhtexto("");

			tramiteHecho.setTramiteHecho(tramiteRecepcionInspeccion);
			tramiteHecho.setEhcoactua(tramiteRecepcionInspeccion.getEhcoactua());
			tramiteHecho.setEhresumenins(tramiteRecepcionInspeccion.getEhresumenins());
			tramiteHecho.setEhcodins(tramiteRecepcionInspeccion.getEhcodins());
			tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			// Se inserta el tramite
			this.tramiteHechoService.addTramiteHecho(tramiteHecho);
		}

		// Se copian los documentos
		for (DocumentoHecho documentoHecho : documentosHecho) {
			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(tramiteHecho.getEhcodigo());
			documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
			documentoTramiteHecho.setPcodigo(documentoHecho.getQ5pcodigo());

			this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
		}

		// Actualizar ultimo tramite
		TramiteHecho tramiteHechoAux = new TramiteHecho();
		tramiteHechoAux.setEhcohd(tramiteComun.getIdExpediente());
		this.actualizarUltimoTramite(tramiteHechoAux);

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramiteComun.getIdExpediente());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return tramiteHecho;
	}

	/**
	 * Comprueba si existe propuesta de inspeccion o expediente sancionador
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean
	 */
	public boolean existePropuestaSancionOExpedienteSancionador(TramiteComun tramiteComun) {

		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		sanpropbandeja.setBaprsanexcodigo(tramiteComun.getIdExpediente());

		if (this.sanpropbandejaService.findAllCount(sanpropbandeja) > 0) {
			return true;
		}

		Sanexprel sanexprel = new Sanexprel();
		sanexprel.setRlhdcodrel(tramiteComun.getIdExpediente());

		if (this.sanexprelService.findSancionadorRelacionadoSolicitudesCount(sanexprel) > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramitehechoAcuse
	 *            TramiteHecho
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(TramiteHecho tramitehechoAcuse, Documento justificanteAcuse) {

		DocumentoHecho docHechoJustificanteAcuse = new DocumentoHecho();
		docHechoJustificanteAcuse.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

		docHechoJustificanteAcuse.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
		docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO);
		docHechoJustificanteAcuse.setQ5iddocumentum(justificanteAcuse.getOidDokusi());
		docHechoJustificanteAcuse.setQ5contenttypefile(justificanteAcuse.getContentType());
		docHechoJustificanteAcuse.setQ5nofile(justificanteAcuse.getNombre());
		docHechoJustificanteAcuse.setQ5tedesfile(Y41bConstantes.JUSTIFICANTE_NOTIFICACION_ELECTRONICA);
		docHechoJustificanteAcuse.setQ5sizefile((int) justificanteAcuse.getLength());
		docHechoJustificanteAcuse.setQ5hdcodigo(tramitehechoAcuse.getEhcohd());
		docHechoJustificanteAcuse.setQ5tramite(tramitehechoAcuse.getEhcodigo());
		docHechoJustificanteAcuse.setQ5fecha(new Date());

		this.documentoHechoDao.add(docHechoJustificanteAcuse);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramitehechoAcuse.getEhcodigo());
		documentoTramiteHecho.setCodocumento(docHechoJustificanteAcuse.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Requerimiento de
	 * Subsanacion
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoRequerimientoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		logger.debug("###################tramiteComun.getIdTramite()2[" + tramiteComun.getIdTramite() + "]");
		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		logger.debug("###################INICIO GRABAR TRAMITE COMUNICACION");
		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);
		logger.debug("###################FIN GRABAR TRAMITE COMUNICACION");

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Requerimiento de
	 * Informacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(tramiteComun.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehecho.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);

		tramitehecho.setEhcomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhcomo(obtenerResponsableExpediente(tramiteComun));
		tramitehecho.setEhtexto("");

		tramitehecho.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehecho.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		logger.debug("###################tramiteComun.getIdTramite()2[" + tramiteComun.getIdTramite() + "]");
		TramiteHecho tramitehechoRel = new TramiteHecho();
		tramitehechoRel.setEhcodigo(tramiteComun.getIdTramite());
		tramitehecho.setTramiteHecho(tramitehechoRel);

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		logger.debug("###################INICIO GRABAR TRAMITE COMUNICACION");
		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);
		logger.debug("###################FIN GRABAR TRAMITE COMUNICACION");

		return tramitehecho;
	}

	/**
	 * Envia mail al instructor al hacer una aportacion de documentacion
	 * mediante la utilidad de y41b, solo si el expediente esta cerrado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void enviarMailInstructor(TramiteHecho tramitehecho) {

		logger.info("Inicio enviarMailInstructor");

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());
		solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solicitudDetalle.getHdfechacierre() != null) {
			CensoMonitor instructor = new CensoMonitor();

			instructor.setMocodigo(solicitudDetalle.getMocodigo());
			instructor = this.censoMonitorDao.find(instructor);

			if (instructor != null && !Y41bUtils.esNullOCadenaVacia(instructor.getMocoem())) {
				// obtener servidor smtp
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
				// 0. From
				String from = "";
				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.PARAMETRO_GENERAL_FROMGENERICO);
				parametros = this.parametrosDao.find(parametros);
				if (parametros == null || (parametros != null
						&& (parametros.getValor() == null || parametros.getValor().equals("")))) {
					// salimos sin enviar correo - no esta definido el from en
					// parametros
					logger.info("enviarMailInstructor / Correo no enviado - no esta definido el from en parametros");

					return;
				}
				from = parametros.getValor();
				// 1. Destinatario
				String destinatario = instructor.getMocoem();
				// 2. Creo el asunto
				// Obtener el numero de expediente
				StringBuilder numeroExpediente = new StringBuilder();

				numeroExpediente.append("SOL-").append(solicitudDetalle.getDecoor()).append("-")
						.append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
						.append("-").append(solicitudDetalle.getHdnror());
				logger.info("enviarMailInstructor / numExpediente" + numeroExpediente);

				StringBuilder asunto = new StringBuilder();
				// Castellano
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
				// 3. Creo el contenido del mail
				StringBuilder texto = new StringBuilder();
				String[] params = new String[1];
				params[0] = numeroExpediente.toString();
				texto.append("<B>").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto",
						params, new Locale(Y41bConstantes.CASTELLANO)));
				texto.append(" / ").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto",
						params, new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");
				boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
						destinatario, "", null);
				if (!enviadoOK) {
					logger.info("enviarMailInstructor / Correo no enviado - sendMail resultado false");
				} else {
					logger.info("enviarMailInstructor / Correo enviado correctamente");
				}
			} else {
				logger.info(
						"enviarMailInstructor / No se ha enviado correo al intructor porque carece de correo electronico (email)");
			}
		}
		logger.info("FIN enviarMailInstructor");
	}

	/**
	 * Metodo que procesa el envio de SIR salida
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	private void procesarEnvioSIRSalida(List<DocumentoHecho> listDocumentoHecho, TramiteHecho tramitehecho)
			throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 5) {
			throw new Y41bUDAException("error.solicitud.maximodocumentoException", true, new Exception());
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String entorno_ejecucion = prop.getProperty("entorno_ejecucion");

		com.ejie.y41b.outputsir.WSParamSIROutputRegister datas = new com.ejie.y41b.outputsir.WSParamSIROutputRegister();

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (entorno_ejecucion.equals("desarrollo")) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_DESARROLLO);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_DESARROLLO);
		} else {
			if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			} else if (solDetalle.getHccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			}
		}

		datas.setMatter(tramitehecho.getEhasuntocomunicacion());

		com.ejie.y41b.outputsir.ArrayOfWSParamPerson personList = new com.ejie.y41b.outputsir.ArrayOfWSParamPerson();

		com.ejie.y41b.outputsir.WSParamPerson wsParamPerson = new com.ejie.y41b.outputsir.WSParamPerson();
		wsParamPerson.setPersonName(Y41bConstantes.PERSON_NAME_SIR);
		personList.getWSParamPerson().add(wsParamPerson);

		datas.setPersons(personList);

		com.ejie.y41b.outputsir.DIR3Destination dir3Destination = new com.ejie.y41b.outputsir.DIR3Destination();

		UnidadesDir3 unidadesDir3 = new UnidadesDir3();
		unidadesDir3.setIdUnidadDir3(tramitehecho.getEhidunidaddir3());

		if (tramitehecho.getEhidunidaddir3() != null && !tramitehecho.getEhidunidaddir3().equals("")) {
			unidadesDir3 = this.unidadesDir3Dao.find(unidadesDir3);
		}

		if (unidadesDir3 != null) {
			dir3Destination.setOfficeCode(unidadesDir3.getCodOficina());
			dir3Destination.setUnitCode(unidadesDir3.getCodUnidad());
		}

		datas.setDIR3(dir3Destination);

		com.ejie.y41b.outputsir.ObjectFactory objectFactory = new com.ejie.y41b.outputsir.ObjectFactory();

		// DOCUMENTOS
		com.ejie.y41b.outputsir.ArrayOfWSSirParamDocument arrayOfWSSirParamDocument = new com.ejie.y41b.outputsir.ArrayOfWSSirParamDocument();
		List<com.ejie.y41b.outputsir.WSSirParamDocument> listWSSirParamDocument = arrayOfWSSirParamDocument
				.getWSSirParamDocument();

		// FIRMAS
		ArrayOfSignatureDocuments arrayOfSignatureDocuments = new ArrayOfSignatureDocuments();
		List<WSParamSignatureDocument> listWSParamSignatureDocument = arrayOfSignatureDocuments
				.getWSParamSignatureDocument();
		Signatures signatures = new Signatures();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			Documento documento = new Documento();

			documento.setUser(user);
			documento.setProcedure(procedure);
			documento.setOidDokusi(documentoHechoAux.getQ5iddocumentum());

			Documento documentoRdo = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

			String pathTo = "/y59/SIR/" + documentoHechoAux.getQ5iddocumentum() + ".pdf";

			Y31AttachmentBean y31AttachmentBeanDoc = y41bPifAdapterService.moveToPath(documentoRdo.getPifId(), pathTo,
					true);

			String documentName = Y41bUtils.getNameFileFromPath(y31AttachmentBeanDoc.getFilePath());

			com.ejie.y41b.outputsir.WSSirParamDocument wSSirParamDocument = new com.ejie.y41b.outputsir.WSSirParamDocument();
			wSSirParamDocument.setDocumentName(Y41bUtils.getNameFile(documentName));
			wSSirParamDocument.setFileName(documentName);
			wSSirParamDocument.setDocumentLocation(Y41bUtils.getNameFile(documentName) + "::pdf");
			wSSirParamDocument.setExtension(Y41bUtils.getExtensionFile(documentName));
			listWSSirParamDocument.add(wSSirParamDocument);

			// FIRMAS

			Documento documentoFiltro = new Documento();
			// 1.User
			documentoFiltro.setUser(user);
			documentoFiltro.setProcedure(procedure);
			documentoFiltro.setOidDokusi(documentoHechoAux.getQ5iddocumentum());
			String firmasStr = y41bDokusiAdapterService.recuperarFirmarDocumentosDokusiString(documento);

			SignatureListDocument signatureListDocument = SignatureListDocument.Factory.parse(firmasStr);

			InputStream isXML = new ByteArrayInputStream(
					signatureListDocument.getSignatureList().getSignatureArray(0).getSignature().getBytes("UTF-8"));

			// Dejamos firma en pif (y59/SIR)
			String rutaFirma = "/y59/SIR/" + documentoHechoAux.getQ5iddocumentum() + "_firma.xml";

			String idPif = y41bPifAdapterService.putFileToPath(isXML, rutaFirma);

			com.ejie.y41b.outputsir.WSParamSignatureDocument wSParamSignatureDocument = new com.ejie.y41b.outputsir.WSParamSignatureDocument();
			wSParamSignatureDocument.setFileName(documentoHechoAux.getQ5iddocumentum() + "_firma.xml");
			wSParamSignatureDocument.setDocumentLocation(documentoHechoAux.getQ5iddocumentum() + "_firma::xml");
			wSParamSignatureDocument.setRelatedDocumentLocation(Y41bUtils.getNameFile(documentName) + "::pdf");

			JAXBElement<String> extension = objectFactory.createWSParamSignatureDocumentExtension("xml");
			wSParamSignatureDocument.setExtension(extension);
			listWSParamSignatureDocument.add(wSParamSignatureDocument);

		}

		datas.setDocuments(arrayOfWSSirParamDocument);

		JAXBElement<ArrayOfSignatureDocuments> firmas = objectFactory
				.createSignaturesArrayOfSignatureDocuments(arrayOfSignatureDocuments);
		signatures.setArrayOfSignatureDocuments(firmas);
		datas.setSignatures(signatures);

		OutputSirServiceImpl outputSirServiceImpl = new OutputSirServiceImpl();
		com.ejie.y41b.outputsir.WSOutputRegister wSOutputRegister = outputSirServiceImpl.wsNewSIROutputRegister(datas);

		tramitehecho.setEhnumregistrosalida(wSOutputRegister.getNumber());
		tramitehecho.setEhfecharegistrosalida(wSOutputRegister.getDate().toGregorianCalendar().getTime());
		this.tramiteHechoDao.updateRegistroSalidaPlatea(tramitehecho);
	}

	/**
	 * Metodo que guarda en Dokusi la firma del documento.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveFirmaDocHash(Adjuntardocs adjuntardocs) throws Exception {
		// 1. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(adjuntardocs.getThcodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		documentoHecho.setQ5fechafirma(Calendar.getInstance().getTime());
		documentoHecho.setQ5comofirma(adjuntardocs.getThcomofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);

		adjuntardocsDao.updateDatosFirma(documentoHecho);

		// 2. Actualizamos en Dokusi la firma
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(adjuntardocs.getThiddocumentum());
		if (adjuntardocs.getThnofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(adjuntardocs.getThnofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(adjuntardocs.getThnofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, adjuntardocs);

		// ******************************************************

		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
	}

	/**
	 * Obtiene la firma del documento para enviar a DOKUSI
	 * 
	 * @param documento
	 *            Documento
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * 
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 */
	private Documento obtenerFirmaDocumento(Documento documento, Adjuntardocs adjuntardocs) throws Exception {
		Documento docDokusi = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

		EjgvDocumentType signature = new EjgvDocumentType();
		signature.setEjgvDocument(new EjgvDocument());
		signature.getEjgvDocument().setHeader(new Header());
		signature.getEjgvDocument().getHeader().setType("xades");
		signature.getEjgvDocument().getHeader().setPlacement("detached");
		signature.getEjgvDocument().getHeader().setFormat("ES-T");
		signature.getEjgvDocument().getHeader().setVersion("2.0");
		signature.getEjgvDocument().getHeader().setFlags("0");

		signature.getEjgvDocument().setBody(new Body());
		signature.getEjgvDocument().getBody().setSign(adjuntardocs.getFirma());

		Date fechaHoy = new Date();
		String fechaActual = com.ejie.y41b.utils.Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

		StringBuffer nombreSignature = new StringBuffer().append("updateSignatureLocation")
				.append(documento.getOidDokusi()).append(fechaActual).append(".xml");

		// Create JAXB Context
		JAXBContext jaxbContext = JAXBContext.newInstance(EjgvDocumentType.class);

		// Create Marshaller
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();

		// Required formatting??
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		QName qName = new QName("com.ejie.y41b.nshf.EjgvDocumentType", "ejgvDocumentType");
		JAXBElement<EjgvDocumentType> root = new JAXBElement<EjgvDocumentType>(qName, EjgvDocumentType.class,
				signature);

		// Print XML String to Console
		StringWriter swSignature = new StringWriter();

		// Write XML to StringWriter
		jaxbMarshaller.marshal(root, swSignature);

		InputStream myInputStream = new ByteArrayInputStream(Y41bUtils.removePrefixes(swSignature.toString())
				.replaceAll("<ejgvDocumentType >", "").replaceAll("</ejgvDocumentType>", "").getBytes());

		String idPifSignature = this.y41bPifAdapterService.putFileToPLATEA(myInputStream, nombreSignature.toString());

		Y31AttachmentBean y31AttachmentBeanDoc = this.y41bPifAdapterService.moveToPLATEA(docDokusi.getPifId(), true);

		NSHFServiceImpl nshfService = new NSHFServiceImpl();
		String signatureReturnPifId = nshfService.updateSignatureLocation(idPifSignature,
				y31AttachmentBeanDoc.getFilePath(), Y41bConstantes.COD_APLICACION);
		// *************************************************

		// DESCARGA EL DOCUMENTO DEL PIF
		BufferedInputStream bIS = this.y41bPifAdapterService.getFile(signatureReturnPifId);

		String signaturePifReturn = Y41bUtils.convertInputStreamToString(bIS);

		// Parseo del XML mediante JAXB
		com.ejie.y41b.model.nshf.EjgvDocument signatureReturn = null;

		// Create JAXB Context
		jaxbContext = JAXBContext.newInstance(com.ejie.y41b.model.nshf.EjgvDocument.class);

		Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
		StringReader reader = new StringReader(signaturePifReturn);
		signatureReturn = (com.ejie.y41b.model.nshf.EjgvDocument) jaxbUnmarshaller.unmarshal(reader);
		// *************************************************

		List<Firma> listaFirma = new ArrayList<Firma>();
		Firma firma = new Firma();
		firma.setFirma(signatureReturn.getBody().getSign());
		listaFirma.add(firma);

		documento.setFirmas(listaFirma);

		documento.setTsaSerialNumber(signatureReturn.getHeader().getTsaSerialNumber());

		return documento;
	}

	/**
	 * Comprueba si existe propuesta de inspeccion o expediente sancionador
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean
	 */
	public boolean existeSegundaMediacion(TramiteComun tramiteComun) {

		TramiteHecho tramiteHecho = new TramiteHecho();
		tramiteHecho.setEhcohd(tramiteComun.getIdExpediente());
		// tramiteHecho.setEhcotee(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION);

		if (this.tramiteHechoDao.findAllSegundaMediacionCount(tramiteHecho) > 0) {
			return true;
		} else {
			return false;
		}

	}

}
