package com.ejie.y41b.service;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.sql.rowset.serial.SerialException;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteAlegacion;
import com.ejie.y41b.model.TramiteAnulacionPropuestaSancion;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteConciliacionEntrePartes;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteEnviarSalidaSIR;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteInformeAsesoria;
import com.ejie.y41b.model.TramiteMediacionPresencial;
import com.ejie.y41b.model.TramiteMediacionTelefonica;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionInspeccion;
import com.ejie.y41b.model.TramiteRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteRecepcionRecurso;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoSubsanacion;
import com.ejie.y41b.model.TramiteRecepcionTraslado;
import com.ejie.y41b.model.TramiteRegistroDecision;
import com.ejie.y41b.model.TramiteRegistroSolicitud;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoAlegacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRequerimientoSubsanacion;
import com.ejie.y41b.model.TramiteRespuestaAmpliacionPlazo;
import com.ejie.y41b.model.TramiteRespuestaColaboracion;
import com.ejie.y41b.model.TramiteRespuestaSegundaMediacion;
import com.ejie.y41b.model.TramiteSegundaMediacion;
import com.ejie.y41b.model.TramiteSolicitudColaboracion;
import com.ejie.y41b.model.TramiteSolicitudInspeccion;
import com.ejie.y41b.model.TramiteTrasladoRedCiac;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;

/**
 * SoltramexpService
 * 
 *  
 */

public interface SoltramexpService {

	/**
	 * Metodo que recibe una lista de documentos del tramite y los adjunta en
	 * los tramites correspondientes
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void adjuntarDocumentosTramiteCorrespondiente(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarBandejaFirma(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception;

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * tramitar
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoProcedimiento
	 *            String
	 * @throws SQLException
	 *             SQLException
	 */
	public void controlDocumentosPendientesFirmaTramitar(TramiteComun tramiteComun, String tipoProcedimiento)
			throws SQLException;

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addTramiteAdjuntarInfraccHechoDenunTableTemporal(TramiteComun tramiteComun);

	/**
	 * Inserta los documentos recibidos por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun);

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosTableTemporalActa(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun);

	/**
	 * Elimina el tramite recibido por parametro
	 * 
	 * @param ehcodigo
	 *            String
	 */
	public void eliminarTramite(String ehcodigo);

	/**
	 * Reabrir expediente
	 * 
	 * @param hdcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             ex
	 */
	public void reabrirExpediente(String hdcodigo, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Obtiene la carga de trabajo de los inspectores del organismo
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CargaTrabajo> getCargatrabajo(CensoMonitor censoMonitor);

	/**
	 * Guardar Tramite Registro Solicitud
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRegistroSolicitud(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteAsignacionInstructor(TramiteAsignacionInstructor tramiteAsignacionInstructor,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite requerimientoInformacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Respuesta Ampliacion Plazo
	 * 
	 * @param tramiteRespuestaAmpliacionPlazo
	 *            TramiteRespuestaAmpliacionPlazo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRespuestaAmpliacionPlazo(
			TramiteRespuestaAmpliacionPlazo tramiteRespuestaAmpliacionPlazo, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento Informacion
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite requerimientoSubsanacion
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRequerimientoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento Subsanacion
	 * 
	 * @param tramiteRecepcionRequerimientoSubsanacion
	 *            TramiteRecepcionRequerimientoSubsanacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionRequerimientoSubsanacion(
			TramiteRecepcionRequerimientoSubsanacion tramiteRecepcionRequerimientoSubsanacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite requerimientoAlegacion
	 * 
	 * @param tramiteRequerimientoAlegacion
	 *            TramiteRequerimientoAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRequerimientoAlegacion(TramiteRequerimientoAlegacion tramiteRequerimientoAlegacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite alegacion
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteAlegacion(TramiteAlegacion tramiteAlegacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite SegundaMediacion
	 * 
	 * @param tramiteSegundaMediacion
	 *            TramiteSegundaMediacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteSegundaMediacion(TramiteSegundaMediacion tramiteSegundaMediacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite RespuestaSegundaMediacion
	 * 
	 * @param tramiteRespuestaSegundaMediacion
	 *            TramiteRespuestaSegundaMediacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRespuestaSegundaMediacion(
			TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar la mediacion telefonica
	 * 
	 * @param tramiteMediacionTelefonica
	 *            TramiteMediacionTelefonica
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteMediacionTelefonica(TramiteMediacionTelefonica tramiteMediacionTelefonica,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar la mediacion presencial
	 * 
	 * @param tramiteMediacionPresencial
	 *            TramiteMediacionPresencial
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteMediacionPresencial(TramiteMediacionPresencial tramiteMediacionPresencial,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite conciliacion entre partes
	 * 
	 * @param tramiteConciliacionEntrePartes
	 *            TramiteConciliacionEntrePartes
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteConciliacionEntrePartes(TramiteConciliacionEntrePartes tramiteConciliacionEntrePartes,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite solicitud inspeccion
	 * 
	 * @param tramiteSolicitudInspeccion
	 *            TramiteSolicitudInspeccion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteSolicitudInspeccion(TramiteSolicitudInspeccion tramiteSolicitudInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite traslado red ciac
	 * 
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteTrasladoRedCiac(TramiteTrasladoRedCiac tramiteTrasladoRedCiac,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite recepcion traslado
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionTraslado(TramiteRecepcionTraslado tramiteRecepcionTraslado,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite registro decision
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar el tramite Recepcion Recurso
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Informe Asesoria
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite RecepcionOrdenConsejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRecepcionOrdenConsejero(TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite cierre
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite comunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoComunicacion
	 *            tipo de comunicacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoComunicacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar tramite notificacion
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoNotificacion
	 *            tipo de notificacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoNotificacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar el tramite BOPVAyto
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Elaboracion BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, DocumentoHecho docHechoPEE, boolean esRemesa,
			boolean reintento) throws Exception;

	/**
	 * Guardar tramite aportacion de documentacion
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar la solicitud de colaboracin otro organismo
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteSolicitudColaboracion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteSolColaboracion(TramiteSolicitudColaboracion tramiteSolicitudColaboracion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar la respuesta de colaboracin otro organismo
	 * 
	 * @param tramiteRespuestaColaboracion
	 *            TramiteRespuestaColaboracion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRespColaboracion(TramiteRespuestaColaboracion tramiteRespuestaColaboracion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite requerimientoAcreditacionRepresentacion
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar el tramite anulacionPropuestaSancion
	 * 
	 * @param tramiteAnulacionPropuestaSancion
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAnulacionPropuestaSancion
	 */
	public TramiteAnulacionPropuestaSancion findTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramite, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHechoDetalle
	 */
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return TramiteGenerico
	 */
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAsignacionInstructor
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteAsignacionInstructor findTramiteAsignacionInstructor(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroSolicitud
	 */
	public TramiteRegistroSolicitud findTramiteRegistroSolicitud(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoSubsanacion
	 *            TramiteRequerimientoSubsanacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoSubsanacion
	 */
	public TramiteRequerimientoSubsanacion findTramiteRequerimientoSubsanacion(
			TramiteRequerimientoSubsanacion tramiteRequerimientoSubsanacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroDecision
	 */
	public TramiteRegistroDecision findTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteMediacionTelefonica
	 *            TramiteMediacionTelefonica
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacion
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteMediacionTelefonica findTramiteMediacionTelefonica(
			TramiteMediacionTelefonica tramiteMediacionTelefonica, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteMediacionPresencial
	 *            TramiteMediacionPresencial
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacion
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteMediacionPresencial findTramiteMediacionPresencial(
			TramiteMediacionPresencial tramiteMediacionPresencial, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoAlegacion
	 *            TramiteRequerimientoAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoAlegacion
	 */
	public TramiteRequerimientoAlegacion findTramiteRequerimientoAlegacion(
			TramiteRequerimientoAlegacion tramiteRequerimientoAlegacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSegundaMediacion
	 *            TramiteSegundaMediacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSegundaMediacion
	 */
	public TramiteSegundaMediacion findTramiteSegundaMediacion(TramiteSegundaMediacion tramiteSegundaMediacion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaSegundaMediacion
	 *            TramiteRespuestaSegundaMediacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRespuestaSegundaMediacion
	 */
	public TramiteRespuestaSegundaMediacion findTramiteRespuestaSegundaMediacion(
			TramiteRespuestaSegundaMediacion tramiteRespuestaSegundaMediacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoInformacion
	 */
	public TramiteRequerimientoInformacion findTramiteRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaAmpliacionPlazo
	 *            TramiteRespuestaAmpliacionPlazo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRespuestaAmpliacionPlazo
	 */
	public TramiteRespuestaAmpliacionPlazo findTramiteRespuestaAmpliacionPlazo(
			TramiteRespuestaAmpliacionPlazo tramiteRespuestaAmpliacionPlazo, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRecurso
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteRecepcionRecurso findTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(
			TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionOrdenConsejero
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteRecepcionOrdenConsejero findTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteCierre
	 */
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAlegacion
	 */
	public TramiteAlegacion findTramiteAlegacion(TramiteAlegacion tramiteAlegacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoInformacion
	 */
	public TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoSubsanacion
	 *            TramiteRecepcionRequerimientoSubsanacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoSubsanacion
	 */
	public TramiteRecepcionRequerimientoSubsanacion findTramiteRecepcionRequerimientoSubsanacion(
			TramiteRecepcionRequerimientoSubsanacion tramiteRecepcionRequerimientoSubsanacion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteInformeAsesoria
	 *            InformeAsesoria
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInformeAsesoria
	 */
	public TramiteInformeAsesoria findTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteConciliacionEntrePartes
	 *            TramiteConciliacionEntrePartes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteConciliacionEntrePartes
	 */
	public TramiteConciliacionEntrePartes findTramiteConciliacionEntrePartes(
			TramiteConciliacionEntrePartes tramiteConciliacionEntrePartes, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSolicitudInspeccion
	 *            TramiteSolicitudInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSolicitudInspeccion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteSolicitudInspeccion findTramiteSolicitudInspeccion(
			TramiteSolicitudInspeccion tramiteSolicitudInspeccion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteTrasladoRedCiac
	 *            TramiteTrasladoRedCiac
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteTrasladoRedCiac
	 */
	public TramiteTrasladoRedCiac findTramiteTrasladoRedCiac(TramiteTrasladoRedCiac tramiteTrasladoRedCiac,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionTraslado
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteRecepcionTraslado findTramiteRecepcionTraslado(TramiteRecepcionTraslado tramiteRecepcionTraslado,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramitehechoNotifRel
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho generarTramiteAcuseReciboAutomatico(String idEspera, TramiteHecho tramitehechoNotifRel,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Create ejgv document for notificacion and comunication
	 * 
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param tipoNotificacionPlatea
	 *            String
	 * @param envRemesa
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacionComunicacion(
			String textoNotificacionComunicacion, String destinatario, String tipoNotificacionPlatea, String envRemesa,
			TramiteComun tramiteComun, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception;

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(Remesa remesa, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteSolicitudColaboracion
	 *            TramiteSolicitudColaboracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacion
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteSolicitudColaboracion findTramiteSolColaboracion(
			TramiteSolicitudColaboracion tramiteSolicitudColaboracion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRespuestaColaboracion
	 *            TramiteRespuestaColaboracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteMediacionPresencial
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRespuestaColaboracion findTramiteRespColaboracion(
			TramiteRespuestaColaboracion tramiteRespuestaColaboracion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Esta funcion actualiza el ultimo tramite ejecutado para Solicitudes
	 * 
	 * @param codTramiteEjecutado
	 *            String
	 * @param codUltimoTramiteGenerado
	 *            String
	 * @param idExpediente
	 *            String
	 * 
	 * @return String
	 */
	public String actualizarUltimoTramite(String codTramiteEjecutado, String codUltimoTramiteGenerado,
			String idExpediente);

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite)
			throws Exception;

	/**
	 * Finds rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination);

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws SerialException, SQLException, Exception;

	/**
	 * Esta funcion actualiza la bandeja de propuesta de sancion con la
	 * informacion del tramitehecho recibido por parametro
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	void tratamientoBandejaPropuestaSancion(TramiteHecho tramitehecho);

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesComunicacionReclamante(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesComunicacionReclamado(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesNotificacionReclamante(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesNotificacionReclamado(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionReclamante(TramiteHecho tramitehecho) throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionReclamado(TramiteHecho tramitehecho) throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de requerimiento de
	 * subsanacion al consumidor
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesRequerimientoSubsanacionConsumidor(TramiteHecho tramitehecho) throws SQLException;

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param estadoDelEnvio
	 *            String
	 * @param documentoByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoByte, String filename);

	/**
	 * Esta funcion realiza el tratamiento de mis gestiones para el acuse recibo
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public void tratamientoMisGestionesAcuseRecibo(TramiteHecho tramitehecho) throws Exception;

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Documento>
	 * @throws Exception
	 *             Exception
	 */
	public List<Documento> registrarDocumentosDokusi(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun)
			throws Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Solicitudes
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSol(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Solicitudes Sin Localizar
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSinLocalizarSol(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Inspecciones
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	Documento registrarDocumentosDokusiIns(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Inspecciones Sin Localizar
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSinLocalizarIns(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Sanciones
	 * 
	 * @param sandocTemp
	 *            Sandoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiSan(Sandoctemp sandocTemp, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	/**
	 * Metodo que registra en DOKUSI documentos de Arbitraje
	 * 
	 * @param arbdocTemp
	 *            Arbdoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento registrarDocumentosDokusiArb(Arbdoctemp arbdocTemp, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception;

	// 111718 - Se aade este metodo para poder resetear el flag del expediente
	// de solicitud que impide que se pueda modificar en y41a
	/**
	 * Esta funcion quita el flag de arbitraje del hecho denunciado
	 * 
	 * @param ehcohd
	 *            String
	 */
	public void resetIndicadorArbitraje(String ehcohd);

	/**
	 * Esta funcion realiza el envio de la comunicacion en una recepcin de
	 * traslado
	 * 
	 * @param hdcodigo
	 *            String
	 * @param aceptado
	 *            boolean
	 * @param expedienteArbitraje
	 *            String
	 * @param mocodigo
	 *            String
	 * @param textoRechazo
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void tratamientoEnviarcomunicacionDesdePropuestaArbitraje(String hdcodigo, boolean aceptado,
			String expedienteArbitraje, String mocodigo, String textoRechazo) throws Exception;

	/**
	 * Actualiza la participacin del reclamante
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionReclamante(TramiteComun tramiteComun) throws Exception;

	/**
	 * Actualiza la participacin del reclamado
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionReclamado(TramiteComun tramiteComun) throws Exception;

	/**
	 * Metodo que graba los documentos del tramite
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws SQLException
	 */
	public void procesarDocumentosTramite(TramiteComun tramiteComun);

	/**
	 * Validar si una sede existe en la base de datos.
	 * 
	 * @param idInterviniente
	 *            String
	 */
	void validarSiExisteSede(String idInterviniente);

	/**
	 * Metodo que crea un zip con nombre zipName, y comprime los documentos del
	 * tramite del expediente
	 * 
	 * @param zipName
	 *            String
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean true si hay ficheros en el zip / false si no hay ficheros
	 *         en el zip
	 */
	boolean crearZipDocumentosExpediente(String zipName, List<Adjuntardocs> listadjuntardocs,
			TramiteComun tramiteComun);

	/**
	 * Metodo que comprueba que los documentos enviados a remesa no tienen
	 * problemas para ser remesados
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 *             Exception
	 */
	public void controlDocumentosProtegidosRemesa(List<Adjuntardocs> listadjuntardocs) throws Exception;

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI, previamente comprueba si se ha localizado y si no se ha
	 * localizado se elimina de DOKUSI y se vuelve a registrar en DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idProcedimiento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void guardarDocumentosDokusiTramiteComunicacionNotificacion(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun, String idProcedimiento) throws Exception;

	/**
	 * Esta funcion realiza el tratamiento de la decisin de traslado
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void tratamientoDecisionTraslado(TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun)
			throws Exception;

	/**
	 * Esta funcion realiza el tratamiento del cierre en la decisin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void tratamientoCierreDecision(TramiteComun tramiteComun);

	/**
	 * Esta funcion realiza la modificacion de la decisin del expediente
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void tratamientoModificacionDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionInspeccion findTramiteRecepcionInspeccion(
			TramiteRecepcionInspeccion tramiteRecepcionInspeccion, CensoMonitor censoMonitor);

	/**
	 * Guardar tramite de Recepcion de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param TramiteRecepcionInspeccion
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteRecepcionInspeccion(TramiteRecepcionInspeccion tramiteRecepcionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Generar Tramite automatico de Recepcion de de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRecepcionInspeccion(TramiteHecho tramiteRecepcionInspeccion,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Generar Tramite automatico de Recepcion de de Inspeccion
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentosHecho
	 *            List<DocumentoHecho>
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRecepcionInspeccion(TramiteHecho tramiteRecepcionInspeccion,
			TramiteComun tramiteComun, List<DocumentoHecho> documentosHecho) throws Exception;

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni);

	/**
	 * Generar Tramite Automatico de Requerimiento Acreditacion Representacion
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho generarTramiteRequerimientoAcreditacionRepresentacion(Intervinientes intervinientes)
			throws Exception;

	/**
	 * Comprueba si existe propuesta de inspeccion o expediente sancionador
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean
	 */
	public boolean existePropuestaSancionOExpedienteSancionador(TramiteComun tramiteComun);

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramitehechoAcuse
	 *            TramiteHecho
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(TramiteHecho tramitehechoAcuse, Documento justificanteAcuse);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteEnviarSalidaSIR
	 *            TramiteEnviarSalidaSIR
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteEnviarSalidaSIR
	 */
	public TramiteEnviarSalidaSIR findTramiteEnviarSalidaSIR(TramiteEnviarSalidaSIR tramiteEnviarSalidaSIR,
			CensoMonitor censoMonitor);

	/**
	 * Guardar tramite de Enviar Salida SIR
	 * 
	 * @param tramiteEnviarSalidaSIR
	 *            TramiteEnviarSalidaSIR
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public TramiteHecho addTramiteEnviarSalidaSIR(TramiteEnviarSalidaSIR tramiteEnviarSalidaSIR,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Metodo que guarda en Dokusi la firma del documento.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @throws Exception
	 */
	public void saveFirmaDocHash(Adjuntardocs adjuntardocs) throws Exception;
}
