package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DocumentosSolicitudesTelematicasEventosDao;
import com.ejie.y41b.dao.SolicitudesTelematicasEventosDao;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * SolicitudesTelematicasEventosServiceImpl  
 * 9:38:26.
 * 
 *  
 */

@Service(value = "solicitudesTelematicasEventosService")
public class SolicitudesTelematicasEventosServiceImpl implements SolicitudesTelematicasEventosService {

	private static final Logger logger = LoggerFactory.getLogger(SolicitudesTelematicasEventosServiceImpl.class);

	@Autowired
	private SolicitudesTelematicasEventosDao solicitudesTelematicasEventosDao;

	@Autowired
	private DocumentosSolicitudesTelematicasEventosDao documentosSolicitudesTelematicasEventosDao;

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudTelematicaEventos> findAllListaSolicitudTelematicaEventos(
			SolicitudTelematicaEventos filterSolicitudTelematicaEventos, Date fechaRegistroDesde,
			Date fechaRegistroHasta, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stPnombre")) {
				pagination.setSort("PNOMBRE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stPnombre")) {
				pagination.setSort("PNOMBRE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stPnombree")) {
				pagination.setSort("PNOMBREE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stPnombree")) {
				pagination.setSort("PNOMBREE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stNumExpediente")) {
				pagination.setSort("NUM_EXPEDIENTE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stNumExpediente")) {
				pagination.setSort("NUM_EXPEDIENTE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stIdAccionTelematica")) {
				pagination.setSort("ID_ACCION_TELEMATICA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stIdAccionTelematica")) {
				pagination.setSort("ID_ACCION_TELEMATICA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stFechaRegistro")) {
				pagination.setSort("FECHA_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stFechaRegistro")) {
				pagination.setSort("FECHA_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stNumRegistro")) {
				pagination.setSort("NUM_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stNumRegistro")) {
				pagination.setSort("NUM_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("stTipoExpediente")) {
				pagination.setSort("TIPO_EXPEDIENTE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("stTipoExpediente")) {
				pagination.setSort("TIPO_EXPEDIENTE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		return this.solicitudesTelematicasEventosDao.findAllSolicitudesTelematicasEventos(
				filterSolicitudTelematicaEventos, fechaRegistroDesde, fechaRegistroHasta, pagination);
	}

	/**
	 * Counts rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            BandejaSolicitudes
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllListaSolicitudTelematicaEventosCount(SolicitudTelematicaEventos filterSolicitudTelematicaEventos,
			Date fechaRegistroDesde, Date fechaRegistroHasta) {
		return this.solicitudesTelematicasEventosDao.findAllSolicitudesTelematicasEventosCount(
				filterSolicitudTelematicaEventos, fechaRegistroDesde, fechaRegistroHasta);

	}

	/**
	 * Finds a single row with clob in the Solicitud table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return Solicitud
	 */
	public SolicitudTelematicaEventos findXmlSolicitud(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		return (SolicitudTelematicaEventos) this.solicitudesTelematicasEventosDao
				.findXmlSolicitud(solicitudTelematicaEventos);
	}

	/**
	 * Inserts a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudTelematicaEventos add(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		return this.solicitudesTelematicasEventosDao.add(solicitudTelematicaEventos);
	}

	/**
	 * Inserts a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public SolicitudTelematicaEventos addSolicitudTelematicaEventos(
			SolicitudTelematicaEventos solicitudTelematicaEventos) {
		solicitudTelematicaEventos.setStCodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		SolicitudesTelematicasEventosServiceImpl.logger.debug(
				"SolicitudServiceImpl.addSolicitudTelematica - ANTES add:" + solicitudTelematicaEventos.toString());

		solicitudTelematicaEventos = this.solicitudesTelematicasEventosDao.add(solicitudTelematicaEventos);

		SolicitudesTelematicasEventosServiceImpl.logger.debug(
				"SolicitudServiceImpl.addSolicitudTelematica - DESPUES add:" + solicitudTelematicaEventos.toString());

		for (DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventosAux : solicitudTelematicaEventos
				.getDocumentoSolicitudTelematicaEventos()) {

			documentoSolicitudTelematicaEventosAux.setDsSolicitudTelematicaEventos(solicitudTelematicaEventos);
			this.documentosSolicitudesTelematicasEventosDao.add(documentoSolicitudTelematicaEventosAux);

			SolicitudesTelematicasEventosServiceImpl.logger
					.debug("SolicitudServiceImpl.addSolicitudTelematica - DESPUES addDocuments:"
							+ documentoSolicitudTelematicaEventosAux.toString());
		}

		return solicitudTelematicaEventos;
	}

	/**
	 * onMessage.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void onMessage(SolicitudTelematicaEventos solicitudTelematicaEventos) {

		try {

			if (!(solicitudTelematicaEventos.getStIdAccionTelematica().equalsIgnoreCase(Y41bConstantes.TEXTO_SIR))) {
				// borrarDocumentos
				this.documentosSolicitudesTelematicasEventosDao
						.removeDocumentosSolicitudTelematicaEventos(solicitudTelematicaEventos);
			}

			// borrarSolicitud
			this.solicitudesTelematicasEventosDao.removeSolicitudTelematicaEventos(solicitudTelematicaEventos);

		} catch (Throwable th) {
			SolicitudesTelematicasEventosServiceImpl.logger
					.error("Error en SolicitudesTelematicasEventosServiceImpl mtodo onMessage", th);

		}

	}

}
