package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.util.Date;
import java.util.List;

import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.model.TramiteHechoModal;

/**
 * BandejaSolicitudesService  
 * 
 *  
 */

public interface SolicitudesTelematicasEventosService {

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudTelematicaEventos> findAllListaSolicitudTelematicaEventos(
			SolicitudTelematicaEventos filterSolicitudTelematicaEventos, Date fechaRegistroDesde,
			Date fechaRegistroHasta, Pagination pagination);

	/**
	 * Counts rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            BandejaSolicitudes
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllListaSolicitudTelematicaEventosCount(SolicitudTelematicaEventos filterSolicitudTelematicaEventos,
			Date fechaRegistroDesde, Date fechaRegistroHasta);

	/**
	 * Finds a single row with clob in the Solicitud table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	SolicitudTelematicaEventos findXmlSolicitud(SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * Inserts a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	SolicitudTelematicaEventos add(SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * Inserts a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	public SolicitudTelematicaEventos addSolicitudTelematicaEventos(
			SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * onMessage
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * 
	 */
	public void onMessage(SolicitudTelematicaEventos solicitudTelematicaEventos);

}