package com.ejie.y41b.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bEIKAAdapterService;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bADOConstantes;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadocorrelDao;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbcolegioDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbitroDao;
import com.ejie.y41b.dao.ArbnumsolDao;
import com.ejie.y41b.dao.ArbpropbandejaDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DtsaDao;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SecretarDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.ArbFicheroADO;
import com.ejie.y41b.model.ArbPagoArbitroADO;
import com.ejie.y41b.model.Arbadocorrel;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbnumsol;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Dtsa;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagosarbitros;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolarbKgest;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteARBApertura;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.report.Y41bReportMergeService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * SolarbServiceImpl  
 * 
 *  
 */

@Service(value = "solarbService")
public class SolarbServiceImpl implements SolarbService {

	private final static Logger logger = LoggerFactory.getLogger(SolarbServiceImpl.class);

	@Autowired()
	private SolarbDao solarbDao;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ArbitroDao arbitroDao;

	@Autowired()
	private SecretarDao secretarDao;

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private EssaDao essaDao;

	@Autowired()
	private DtsaDao dtsaDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private ConsumidorDao consumidorDao;

	@Autowired()
	private ArbtramexpDao arbtramexpDao;

	@Autowired()
	private ArbbandejaDao arbbandejaDao;

	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired()
	private ArbexpDao arbexpDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private SanexprelDao sanexprelDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	// @Autowired()
	// private BandejaFirmaDao bandejaFirmaDao;
	// @Autowired()
	// private ArbdoctempDao arbdoctempdao;
	// @Autowired()
	// private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private ArbadocorrelDao arbadocorrelDao;
	@Autowired()
	private ArbnumsolDao arbnumsolDao;
	@Autowired()
	private ArbcolegioDao arbcolegioDao;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private ArbpropbandejaDao arbpropbandejaDao;
	@Autowired()
	private SoltramexpService soltramexpService;
	@Autowired()
	private Y41bEIKAAdapterService y41bEIKAAdapterService;
	@Autowired()
	private Y41bReportMergeService y41bReportMergeService;

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Solarb recibirSolicitudTelematica(Solarb solarb, List<Documento> listDocumento) {

		return solarb;
	}

	@Transactional(rollbackFor = Throwable.class)
	public Map<String, Object> add(Solarb solarb) throws Exception {
		return this.add0(solarb, null);
	}

	public Map<String, Object> addDesdeTelematica(Solarb solarb, List<Documento> listDocumento) throws Exception {
		return this.add0(solarb, listDocumento);
	}

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 * @throws Exception
	 *             exc
	 */
	private Map<String, Object> add0(Solarb solarb, List<Documento> listDocumento) throws Exception {

		Map<String, Object> retorno = new HashMap<String, Object>();

		// en las presenciales la clave interna la generamos al mostrar la modal
		if (solarb.getSacodigo() == null) {
			solarb.setSacodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		}

		solarb.getArbexp().setExcodigo(solarb.getSacodigo());

		// rellenamos nmero del expediente
		// las telemticas ya lo traen.

		if (!Y41bUtils.isFilled(solarb.getSacoja())) {
			// el organismo es fijo
			solarb.setSacoja(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		}
		if (solarb.getSanran() == null) {
			// Año actual
			solarb.setSanran(new BigDecimal(Calendar.getInstance().get(Calendar.YEAR)));
		}

		if (solarb.getSanror() == null) {

			// Correlativo dentro del organismo y ao
			Arbnumsol arbnumsol = new Arbnumsol();
			arbnumsol.setArbcoor(solarb.getSacoja());
			arbnumsol.setArbnran(solarb.getSanran());
			solarb.setSanror(this.arbnumsolDao.findAndAddNumSolicitud(arbnumsol));

		}

		// Tecnico conectado
		String mocodigo = solarb.getArbexp().getExmocodigo();

		// calcular el coordinador del expediente TELEMTICO
		// TODO para presencial y propuesta.
		CensoMonitor coordinador = this.censoMonitorDao.findCoordinadorArbitraje();
		if (coordinador == null || Y41bUtils.esNullOCadenaVacia(coordinador.getMocodigo())) {
			// if
			// (!Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb
			// .getArbexp().getExformapres())) {
			// throw new Y41bUDAException("error.arbitraje.faltaCoordinador",
			// true, null);
			// }
			solarb.getArbexp().setExmocodigo("");
		} else {
			solarb.getArbexp().setExmocodigo(coordinador.getMocodigo());
		}

		/* CALCULAMOS LA FECHA DE FIN PREVISTA */
		if (solarb.getArbexp() == null) {
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(solarb.getSacodigo());
			solarb.setArbexp(arbexp);
		}
		solarb.getArbexp()
				.setExfecprevfin(this.parametrosDao.devuelvefechaFinPrevista(solarb.getArbexp().getExfecini()));

		// TODO falta tipo presentacion, no hay campo rivas lo va a mirar

		// buscamos los datos de la reclamacin previa.
		Establecimiento establecimiento = null;
		Intervinientes interv_establecimiento = null;
		Intervinientes interv_consumidor = null;

		HechoDenunciado hechodenunciado = new HechoDenunciado();
		String formaNotiEstablecimiento = "";
		if (solarb.getSacohd() != null) {

			hechodenunciado.setHdcodigo(solarb.getSacohd());
			hechodenunciado = hechoDenunciadoDao.find(hechodenunciado);
			formaNotiEstablecimiento = hechodenunciado.getHdformanotificacionestablecimiento();

		}
		// TODO: la formaNotiEstablecimiento cuando no hay hecho denunciado
		// asociado

		// if telematico
		// hay que coger los campos del hecho que no se cargan en la solicitud
		// del propio hecho.
		// en el resto de altas se cogeran del formulario de alta, y si no lo
		// que hay
		// que hacer es cargar TODOS los campos del hecho.
		// despus si quieren completar campos lo harn en la ficha del
		// arbitraje.
		if (solarb.getSacohd() != null) {
			// Forma de venta e idioma son obligatorios en la solicitud
			// presencial, hay que calcularlos para la web
			if (Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
				solarb.getArbexp().setHdformaventa(hechodenunciado.getHdformaventa());

				// EL IDIOMA DE LA SOLICITUD EN LAS TELEMTICAS, YA NO SE COGE
				// DE LA SOLICITUD RELACIONADA
				// SIMPLEMENTE SE RECOGE EN UN CAMPO DEL FORMULARIO DE
				// SOLICITUD.
				// solarb.getArbexp().setExidisol(hechodenunciado.getHdidioma());

				// cogemos los datos del hecho que no vienen dados desde la web.
				solarb.setSacops(
						hechodenunciado.getProducto() != null ? hechodenunciado.getProducto().getPscodigo() : null);
				solarb.setSacotir(
						hechodenunciado.getMotivo() != null ? hechodenunciado.getMotivo().getTircodigo() : null);
			}
		}

		// La participacion del reclamado inicialmente se pone a NO
		solarb.getArbexp().setExpartrecl(Y41bConstantes.VALOR_NO);

		solarb.getArbexp().setExdestnotifreclamado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);
		solarb.getArbexp().setExdestnotifreclamante(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);

		// 0169289: Estudio de la Integracin SIR
		String isSIR = "";
		if (null != solarb.getArbexp().getIdAsiento()) {
			isSIR = solarb.getArbexp().getIdAsiento();
			// solarb.getArbexp().setIsSIR(solarb.getArbexp().getIdAsiento())
		}
		// 0169289: Estudio de la Integracin SIR

		solarbDao.add(solarb);
		arbexpDao.add(solarb.getArbexp());

		// si ha escogido reclamacin previa los datos del establecimiento y del
		// consumidor hay que recogerlos de intervinientes/censo. Si no
		// directamente del censo.
		String dtcodigo = null;
		String escodigo = null;

		if (solarb.getSacohd() != null) {
			establecimiento = hechodenunciado.getEstablecimiento();
			interv_establecimiento = new Intervinientes();
			interv_establecimiento.setEscodigo(establecimiento.getEscodigo());
			interv_establecimiento.setIdExpediente(hechodenunciado.getHdcodigo());
			interv_establecimiento.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO); // J
																											// 19/12
			interv_establecimiento = intervinientesDao.findIntervinienteEstablecimiento(interv_establecimiento);

			if (Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
				// Asi cogera los datos del consumidor en la funcion
				// generarReclamante
				interv_consumidor = null;
				dtcodigo = solarb.getDtcodigo();
			} else {
				interv_consumidor = new Intervinientes();
				interv_consumidor.setDtcodigo(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
				interv_consumidor.setIdExpediente(hechodenunciado.getHdcodigo());
				interv_consumidor.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);
				interv_consumidor = intervinientesDao.findIntervinienteConsumidor(interv_consumidor);
				dtcodigo = hechodenunciado.getDenuncia().getConsumidor().getDtcodigo();
				escodigo = establecimiento.getEscodigo();
			}
		} else {
			dtcodigo = solarb.getDtcodigo();
			escodigo = solarb.getEscodigo();
		}

		Arbinterv reclamanteArb = this.generarReclamante(interv_consumidor, solarb, dtcodigo);

		Arbinterv reclamadoArb = this.generarReclamado(interv_establecimiento, establecimiento, solarb,
				formaNotiEstablecimiento, escodigo);

		// para los telemticos el mail y telefono del consumidor viene
		// TODO para los telemticos hay que indicar que la forma de
		// notificacin/comunicacin es telemtico
		/*
		 * if (solarb.getEmailNotifDesdeTelem() != null) {
		 * reclamanteArb.setUacoem(solarb.getEmailNotifDesdeTelem()); } if
		 * (solarb.getTelefonoNotifDesdeTelem() != null) {
		 * reclamanteArb.setUanrtel(solarb.getTelefonoNotifDesdeTelem()); }
		 */

		Establecimiento establecimientoAux = new Establecimiento(reclamadoArb.getUaescodigo());
		establecimientoAux = this.establecimientoDao.find(establecimientoAux);
		// Se actualiza el tipo de arbitraje si el establecimiento existe y esta
		// actualmente adherido
		if (establecimientoAux != null && ("A".equalsIgnoreCase(establecimientoAux.getEsinadar())
				|| "L".equalsIgnoreCase(establecimientoAux.getEsinadar()))) {
			solarb.setSaintiso(establecimientoAux.getEsintiar());
			this.solarbDao.updateTipoArbitraje(solarb);
		}

		this.arbintervDao.add(reclamanteArb);
		this.arbexpDao.updateEXIDPARTICIPACIONRECLAMANTE(reclamanteArb, solarb.getSacodigo());
		this.arbintervDao.add(reclamadoArb);
		this.arbexpDao.updateEXIDPARTICIPACIONRECLAMADO(reclamadoArb, solarb.getSacodigo());

		// Aadimos el organismo que presenta la solicitud como interviniente
		if (!Y41bUtils.esNullOCadenaVacia(solarb.getArbexp().getExcoorg())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solarb.getArbexp().getExcoorg());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
			// buscar el interviniente interesado
			Arbinterv arbintervAux = new Arbinterv();
			arbintervAux.setUaexcodigo(solarb.getSacodigo());
			arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
			arbintervAux.setUaentidadId(organismo.getEntidadId());
			List<Arbinterv> listIntervinientes = this.arbintervDao.findAll(arbintervAux, null);
			arbintervAux.setUaexcodigo(solarb.getSacodigo());
			arbintervAux.setUanombre(organismo.getNombreEs());
			// arbintervAux.setUacoem(establecimiento.getEscoem());
			arbintervAux.setUanif(organismo.getCif());
			arbintervAux.setUanrtel(organismo.getTelefono());
			arbintervAux.setUanrtel2(null);
			arbintervAux.setUaprovId(organismo.getNoraProvinciaId());
			arbintervAux.setUamunId(organismo.getNoraMunicipioId());
			arbintervAux.setUalocId(organismo.getNoraLocalidadId());
			arbintervAux.setUacalleId(organismo.getNoraCalleId());
			// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
			// nombrecp
			// arbintervAux.setUacpId(organismo.getNoraCpId());
			arbintervAux.setUacpId(organismo.getNombreCp());
			arbintervAux.setUaportalId(organismo.getNoraPortalId());
			arbintervAux
					.setUanombrePiso((organismo.getCompleDirec() != null && organismo.getCompleDirec().length() > 40)
							? organismo.getCompleDirec().substring(0, 40) : organismo.getCompleDirec());

			if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
					|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
							&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
							&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
				arbintervAux.setUadireNocapv(organismo.getNombreCalle());
			}
			arbintervAux.setUadireAnt(organismo.getCompleDirec());
			arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
			arbintervAux.setUaentidadId(organismo.getEntidadId());
			if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
				arbintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
			} else {
				arbintervAux.setUapaisId(organismo.getNoraPaisId());
			}
			arbintervAux.setUaurl(organismo.getUrl());
			arbintervAux.setUacoem(organismo.getEmail());
			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				arbintervAux.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
				this.arbintervDao.update(arbintervAux);
			} else {
				this.arbintervDao.add(arbintervAux);
			}
		}

		// Para las solicitudes telematicas, si hay representante hay que
		// aadirlo a la lista de intervinientes
		if (Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
			if (solarb.getRepresentante() != null) {
				solarb.getRepresentante().setUaexcodigo(solarb.getSacodigo());
				solarb.getRepresentante()
						.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
				arbintervDao.add(solarb.getRepresentante());
			}
		}

		// por mantener coherencia con histricos hay que insertar en la tabla
		// ESSA - DTSA
		Essa essa = new Essa();
		essa.setSolarb(solarb);
		essa.setEstablecimiento(new Establecimiento(reclamadoArb.getUaescodigo()));
		this.essaDao.add(essa);

		Dtsa dtsa = new Dtsa();
		dtsa.setSolarb(solarb);
		Consumidor consumidor = new Consumidor();
		consumidor.setDtcodigo(reclamanteArb.getUadtcodigo());
		dtsa.setConsumidor(consumidor);
		this.dtsaDao.add(dtsa);

		// si no han introducido registro de entrada hay que obtenerlo del
		// registro presencial
		if (Y41bUtils.esNullOCadenaVacia(solarb.getArbexp().getExregen())) {

			WSParamInputRegisterEx datas = new WSParamInputRegisterEx();
			// TODO SUPONGO QUE HABR UNA UNIDAD ORGNICA PARA LA JUNTA ARBITRAL
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);

			ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

			WSParamPerson wSParamPerson = new WSParamPerson();
			StringBuffer sbPerson = new StringBuffer();
			if (Y41bUtils.isFilled(reclamanteArb.getUanif())) {
				sbPerson.append(reclamanteArb.getUanif());
				sbPerson.append(" - ");
			}
			if (Y41bUtils.isFilled(reclamanteArb.getUanombre())) {
				sbPerson.append(reclamanteArb.getUanombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(reclamanteArb.getUaapellido1())) {
				sbPerson.append(reclamanteArb.getUaapellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(reclamanteArb.getUaapellido2())) {
				sbPerson.append(reclamanteArb.getUaapellido2());
				sbPerson.append(" ");
			}

			wSParamPerson.setPersonName(sbPerson.toString());

			persons.getWSParamPerson().add(wSParamPerson);

			datas.setPersons(persons);

			StringBuffer sbMatter = new StringBuffer();
			sbMatter.append(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
			sbMatter.append(" - [");
			sbMatter.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			sbMatter.append("-");
			sbMatter.append(solarb.getSacoja()).append("-").append(solarb.getSanror()).append("-")
					.append(solarb.getSanran()).append("-");
			sbMatter.append("]");
			datas.setMatter(sbMatter.toString());

			N61ServiceImpl n61Service = new N61ServiceImpl();
			WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

			solarb.getArbexp().setExregen(wSInputRegister.getNumber());
			solarb.getArbexp().setExfecreg(wSInputRegister.getDate().toGregorianCalendar().getTime());

			arbexpDao.update(solarb.getArbexp());
		}

		// si hay hecho denunciado habr que recoger datos del mismo pero habr
		// otros que sean de la propia alta.

		// String descripcionExpediente = "no hay descripcin en telemtico...";
		String descripcionExpediente = solarb.getArbexp().getExdesces();
		// Date fechaInicioExpediente = solarb.getSafesoli();

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(solarb.getSacodigo());

		// si estamos haciendo un alta presencial
		// el tramite de apertura vendr relleno
		if (solarb.getIdTramiteApertura() != null && !"".equals(solarb.getIdTramiteApertura())) {
			tramiteComun.setIdTramite(solarb.getIdTramiteApertura());
		} else {
			tramiteComun.setIdTramite(this.arbtramexpService.getNewPK().toString());
			// Recuperar documentos aportados de la reclamacion previa (Viene de
			// telematica)
			this.arbdoctempDao.removeDocumentosReclamacionPrevia(tramiteComun.getIdTramite());
			this.arbdoctempDao.volcarDocumentosReclamacionPrevia(solarb.getSacohd(), tramiteComun.getIdTramite());
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA);

		// TODO tramite de apertura que fecha de inicio?
		TramiteARBApertura tramiteApertura = new TramiteARBApertura();
		tramiteApertura.setFechaInicio(solarb.getArbexp().getExfecini());

		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		tramiteApertura.setFechaFin(todayWithZeroTime);

		// TODO alta presencial??
		tramiteApertura.setInstructorAsignado(new CensoMonitor(mocodigo, null));
		tramiteApertura.setInstructorEjecucion(new CensoMonitor(mocodigo, null));
		tramiteApertura.setComentario(descripcionExpediente);
		// 0169289: Estudio de la Integracin SIR
		tramiteApertura.setIsSIR(isSIR);
		// 0169289: Estudio de la Integracin SIR

		Arbtramexp tramiteAperturaRetorno = arbtramexp2Service.addTramiteApertura(tramiteApertura, tramiteComun, "",
				true, "", listDocumento);

		logger.info("SolarbServiceImpl. - Add. Insertado en historico fases");

		SolarbServiceImpl.logger.info("SolarbServiceImpl. - Add. He añadido a la bandeja");

		this.tratamientoReclamacionRelacionada(solarb, mocodigo);

		// Crear aviso
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION);
		parametros = this.parametrosDao.find(parametros);
		if (parametros != null) {
			Long numero = new Long(parametros.getValor());
			this.arbbandejaDao.aniadeAvisoBandejaDias(solarb, new CensoMonitor(mocodigo, null), numero, "", "",
					tramiteAperturaRetorno.getTrid(), Y41bUtils.hoy(), Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION);
		}

		// necesitamos los datos del reclamado para abrir la participacin
		// telemtica
		solarb.setReclamado(reclamadoArb);

		// Para las solicitudes telematicas, rellenar el campo estado adhesion
		// inicial establecimiento
		if (Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
			// Registar el estado de adhesion del establecimiento
			this.arbexpService.actualizarEstAdhEstablecimiento(solarb.getSacodigo());
		}

		retorno.put("solarb", solarb);
		retorno.put("tramiteApertura", tramiteAperturaRetorno);
		retorno.put("solarb", solarb);
		return retorno;
	}

	private void tratamientoReclamacionRelacionada(Solarb solarb, String mocodigo) throws Exception {
		// aadimos a la tabla de expedientes relacionados en caso de tener una
		// solicitud relacionada.
		if (solarb.getSacohd() != null) {
			Sanexprel exprel = new Sanexprel();
			// Sanexprel exprelsolicitud = new Sanexprel();

			exprel.setRlarbcodigo(solarb.getSacodigo());
			exprel.setRlhdcodrel(solarb.getSacohd());
			exprel.setRlesorig(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN);
			this.sanexprelDao.add(exprel);

			Sanexprel exprelSol = new Sanexprel();
			exprelSol.setRlhdcodigo(solarb.getSacohd());
			exprelSol.setRlarbcodrel(solarb.getSacodigo());
			exprel.setRlesorig(Y41bConstantes.TIPO_ARB_EXPREL_OTROS);

			this.sanexprelDao.add(exprelSol);

			// Aadimos trmite genrico a la reclamaacin
			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico.setIdExpediente(solarb.getSacohd());
			tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
			tramiteGenerico.setInstructorAsignado(new CensoMonitor(mocodigo, null));

			Locale locale = LocaleContextHolder.getLocale();
			if (locale != null) {
				SolarbServiceImpl.logger.debug("SolarbServiceImpl LANGUAGE LOCALE:: " + locale.getLanguage());
			}
			if (locale == null || (!locale.getLanguage().equals(Y41bConstantes.CASTELLANO)
					&& !locale.getLanguage().equals(Y41bConstantes.EUSKERA))) {

				if (solarb.getArbexp() != null && solarb.getArbexp().getExidisol() != null) {
					locale = new Locale(solarb.getArbexp().getExidisol().toLowerCase());
				} else {
					locale = new Locale(Y41bConstantes.CASTELLANO);
				}

			}

			tramiteGenerico
					.setComentario(appMessageSource.getMessage("tramite.aperturaArbitrajeComentario", null, locale)
							+ " ( " + Y41bConstantes.TIPO_PROC_ARBITRAJE + "-" + solarb.damecodCompleto() + " )");
			String literalNombreTramite = "tramite.aperturaArbitraje";
			this.soltramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);

			// Eliminamos el expediente de propuesta de arbitraje
			Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
			arbpropbandeja.setBaprarbexcodigo(solarb.getSacohd());
			List<Arbpropbandeja> listaRegistrosBandeja = arbpropbandejaDao.findAll(arbpropbandeja, null);
			if (listaRegistrosBandeja != null && listaRegistrosBandeja.size() > 0) {
				this.soltramexpService.tratamientoEnviarcomunicacionDesdePropuestaArbitraje(solarb.getSacohd(), true,
						solarb.damecodCompleto(), mocodigo, null);

				// cogemos el primero porque solo habria uno
				for (int k = 0; k < listaRegistrosBandeja.size(); k++) {
					Arbpropbandeja arbpropbandejaAux = listaRegistrosBandeja.get(k);
					arbpropbandejaDao.remove(arbpropbandejaAux);
				}
			}
		}
	}

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Solarb update(Solarb solarb) {
		return this.solarbDao.update(solarb);
	}

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	public Solarb find(Solarb solarb) {
		return (Solarb) this.solarbDao.find(solarb);
	}

	/**
	 * Finds a List of rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Solarb> findAll(Solarb solarb, Pagination pagination) {
		return (List<Solarb>) this.solarbDao.findAll(solarb, pagination);
	}

	/**
	 * Counts rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Long
	 */
	public Long findAllCount(Solarb solarb) {
		return this.solarbDao.findAllCount(solarb);
	}

	/**
	 * Finds rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Solarb> findAllLike(Solarb solarb, Pagination pagination, Boolean startsWith) {
		return (List<Solarb>) this.solarbDao.findAllLike(solarb, pagination, startsWith);
	}

	/**
	 * Counts rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Solarb solarb, Boolean startsWith) {
		return this.solarbDao.findAllLikeCount(solarb, startsWith);
	}

	/**
	 * Deletes a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Solarb solarb) {
		this.solarbDao.remove(solarb);
	}

	/**
	 * Deletes multiple rows in the Solarb table.
	 * 
	 * @param solarbList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Solarb> solarbList) {
		for (Solarb solarbAux : solarbList) {
			this.solarbDao.remove(solarbAux);
		}
	}

	/**
	 * 
	 * @param anio
	 *            int
	 * @param mes
	 *            int
	 * @return HashMap<String,String>
	 * @throws Exception
	 */
	// EVOLUTIVO 0134898 2.8 se ha aniadido el parametro resp a la llamada
	public HashMap<String, Object> getDiasConAudiencia(int anio, int mes, String resp) throws Exception {
		Solarb solarb = new Solarb();
		Calendar calendar = Calendar.getInstance();
		// Calendar Enero=0
		calendar.set(anio, mes, 1);
		calendar.add(Calendar.MONTH, -3);
		Date safeciau = calendar.getTime();
		solarb.setSafeciauDesde(safeciau);
		solarb.setSafeciau2Desde(safeciau);
		calendar.set(anio, mes, 1);
		Date safeciau2 = calendar.getTime();
		solarb.setSafeciauHasta(safeciau2);
		solarb.setSafeciau2Hasta(safeciau2);
		// EVOLUTIVO 0134898 2.8
		if (resp != null) {
			Arbexp arbexp = new Arbexp();
			arbexp.setExmocodigo(resp);
			solarb.setArbexp(arbexp);
		}
		// EVOLUTIVO 0134898 2.8
		Pagination pagination = new Pagination();
		pagination.setSort("sahrciau asc, sahrciau2 ");
		pagination.setSord("asc");
		List<Solarb> lista = (List<Solarb>) this.solarbDao.findAll(solarb, pagination);
		if (!lista.isEmpty() && resp != null) {
			for (int i = 0; i < lista.size(); i++) {
				Solarb solarb1 = lista.get(i);
				Arbexp arbexp1 = solarb1.getArbexp();
				arbexp1.setExmocodigo(resp);
				lista.get(i).setArbexp(arbexp1);

			}
		}
		HashMap<String, Object> datosMes = new HashMap<String, Object>();
		int mes2 = 0;
		int mes3 = 0;
		int anio2 = anio;
		int anio3 = anio;
		if (mes == 1) {
			mes2 = 12;
			mes3 = 11;
			anio2 = anio - 1;
			anio3 = anio - 1;
		} else if (mes == 2) {
			mes2 = 1;
			mes3 = 12;
			anio3 = anio - 1;
		} else {
			mes2 = mes - 1;
			mes3 = mes - 2;
			anio2 = anio;
			anio3 = anio;
		}

		ArrayList<Integer> diasMes = new ArrayList<Integer>();
		ArrayList<Integer> diasMes2 = new ArrayList<Integer>();
		ArrayList<Integer> diasMes3 = new ArrayList<Integer>();
		if (lista != null) {
			for (int i = 0; i < lista.size(); i++) {
				solarb = lista.get(i);
				Date fecha = this.fechaUltimaResolucionTramitadaSiNoLaudo(solarb.getSacodigo());
				if (solarb.getSafeciau() != null && (fecha == null || fecha.after(solarb.getSafeciau()))) {
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio), "0", 4))
							&& !diasMes.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd"))) {
						diasMes.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd")));
					}
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes2), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio2), "0", 4))
							&& !diasMes2.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd"))) {
						diasMes2.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd")));

					}
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes3), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio3), "0", 4))
							&& !diasMes3.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd"))) {
						diasMes3.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau(), "dd")));
					}
				}
				if (solarb.getSafeciau2() != null && (fecha == null || fecha.after(solarb.getSafeciau2()))) {
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio), "0", 4))
							&& !diasMes.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd"))) {
						diasMes.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd")));
					}
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes2), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio2), "0", 4))
							&& !diasMes2.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd"))) {
						diasMes2.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd")));
					}
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes3), "0", 2))
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "yyyy")
									.equals(Y41bUtils.rellenaIzda(String.valueOf(anio3), "0", 4))
							&& !diasMes3.contains(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd"))) {
						diasMes3.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "dd")));
					}

				}

			}
		}
		datosMes.put(String.valueOf(mes), diasMes);
		datosMes.put(String.valueOf(mes2), diasMes2);
		datosMes.put(String.valueOf(mes3), diasMes3);
		datosMes.put("diasConAudiencia", lista);
		return datosMes;
	}

	/**
	 * fechaUltimaResolucionTramitadaSiNoLaudo
	 * 
	 * @param sacodigo
	 *            String
	 * @return Date
	 */
	private Date fechaUltimaResolucionTramitadaSiNoLaudo(String sacodigo) {
		Date resultado = null;

		Arbtramexp resolucion = new Arbtramexp();
		// sacar los datos del ultimo que este resuelto
		Solarb solarb = new Solarb(sacodigo);
		resolucion.setSolarb(solarb);
		resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION);
		resolucion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		Pagination<Object> pagination = new Pagination<Object>();
		pagination.setSort("trfecfin");
		pagination.setAscDsc("desc");
		List<Arbtramexp> lista = this.arbtramexpDao.findAll(resolucion, pagination);

		if (lista != null && lista.size() > 0) {
			Arbtramexp arbtramexp = lista.get(0);
			if (!Y41bConstantes.DECISION_ARB_LAUDO.equalsIgnoreCase(arbtramexp.getTrresotipo())) {
				resultado = arbtramexp.getTrresofecha();
			}
		}
		return resultado;
	}

	/**
	 * Method 'getFichaExpedienteArbitraje'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	public ModelAndView getFichaExpedienteArbitraje(Model model, String desde, String accesoPest2, String sacodigo,
			HttpServletRequest httpRequest) {
		return this.getFichaExpedienteArbitraje(model, desde, accesoPest2, false, sacodigo, httpRequest);
	}

	/**
	 * Method 'getFichaExpedienteArbitraje'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sinCabecera
	 *            boolean
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	public ModelAndView getFichaExpedienteArbitraje(Model model, String desde, String accesoPest2, boolean sinCabecera,
			String sacodigo, HttpServletRequest httpRequest) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		model.addAttribute("accesoPest2", accesoPest2);
		model.addAttribute("sacodigo", sacodigo);

		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		solarb = this.solarbDao.find(solarb);

		// Variable para ficha arbitraje histrico
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(sacodigo);
		arbexp = this.arbexpService.find(arbexp);

		// Al entrar en el expediente se informar de los siguientes trmites al
		// responsable tras su asignacin al expediente
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
		List<Arbtramexp> larbtramexp = this.arbtramexpDao.findAll(arbtramexp, null);
		if (larbtramexp != null && larbtramexp.size() > 0) {
			model.addAttribute("siguientesTramites",
					Y41bUtils.clobToString(larbtramexp.get(0).getTrsiguientestramites()));
		}

		httpRequest.getSession().setAttribute(Y41bConstantes.SESSION_NUMEXP_ARB, sacodigo);

		httpRequest.getSession().setAttribute(Y41bConstantes.CTE_TIPO_PROC, Y41bConstantes.TIPO_PROC_ARBITRAJE);

		httpRequest.getSession().setAttribute("desde", desde);

		model.addAttribute("codCompleto", solarb.damecodCompleto());

		// String valor = Y41bConstantes.SI;
		// Arbinterv arbinterv = new Arbinterv();
		// arbinterv.setUaexcodigo(sacodigo);
		// arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
		// List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv,
		// null);
		// if (larbinterv != null && larbinterv.size() > 0) {
		// valor = Y41bConstantes.NO;
		// for (int i = 0; i < larbinterv.size(); i++) {
		// arbinterv = larbinterv.get(i);
		// Organismo organismo = new Organismo();
		// organismo.setEntidadId(arbinterv.getUaentidadId());
		// organismo = this.organismoDao.findOrganismoById(organismo);
		// if (!(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA
		// .equals(organismo.getEntidadId()) ||
		// Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI
		// .equals(organismo.getCodOrg()))) {
		// valor = Y41bConstantes.SI;
		// break;
		// }
		// }
		// } else {
		// valor = Y41bConstantes.NO;
		// }
		// model.addAttribute("mostrarDivNotComOtros", valor);

		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(sacodigo);
			this.denunciaService.actualizarDocumentosLocalizados(solicitudDetalle);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		// si arbexp null, sacar ficha histrica, de lo contrario la normal
		if (!sinCabecera) {
			if (null == arbexp) {
				return new ModelAndView("fichaExpedienteHistoricoArbitraje", "model", model);
			} else {
				return new ModelAndView("fichaExpedienteArbitraje", "model", model);
			}
		} else {
			if (null == arbexp) {
				return new ModelAndView("fichaExpedienteHistoricoArbitrajeSinCabecera", "model", model);
			} else {
				return new ModelAndView("fichaExpedienteArbitrajeSinCabecera", "model", model);
			}
		}

		// return new ModelAndView("fichaExpedienteArbitraje", "model", model);
	}

	/**
	 * 
	 * @param fecha
	 *            String
	 * @param lista
	 *            List<Solarb>
	 * @return ArrayList<HashMap<String, String>>
	 * @throws Exception
	 */
	public ArrayList<HashMap<String, String>> getHorasDiaConAudiencia(String fecha, List<Solarb> lista)
			throws Exception {
		ArrayList<HashMap<String, String>> horas = new ArrayList<HashMap<String, String>>();
		Solarb solarb = null;
		HashMap<String, String> hora = null;
		HashMap<String, String> datosIntervinientes = null;
		for (int i = 0; i < lista.size(); i++) {
			solarb = lista.get(i);
			if ((solarb.getSafeciau() != null
					&& Y41bUtils.formatearDateToString(solarb.getSafeciau(), "yyyyMMdd").equals(fecha))
					|| (solarb.getSafeciau2() != null
							&& Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "yyyyMMdd").equals(fecha))) {
				datosIntervinientes = this.obtenerDatosIntervinientesCalendario(solarb);
				Date fechaUltimaResolucionTramitadaSiNoLaudo = this
						.fechaUltimaResolucionTramitadaSiNoLaudo(solarb.getSacodigo());
				if (solarb.getSafeciau() != null && (fechaUltimaResolucionTramitadaSiNoLaudo == null
						|| fechaUltimaResolucionTramitadaSiNoLaudo.after(solarb.getSafeciau()))) {
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau(), "yyyyMMdd").equals(fecha)) {
						hora = new HashMap<String, String>();
						hora.put("sacodigo", solarb.getSacodigo());
						hora.put("hora", solarb.getSahrciau());
						hora.put("audiencia", "1");
						hora.put("reclamante", datosIntervinientes.get("reclamante"));
						hora.put("reclamanteId", datosIntervinientes.get("reclamanteId"));
						hora.put("reclamanteUaidinterv", datosIntervinientes.get("reclamanteUaidinterv"));
						hora.put("reclamado", datosIntervinientes.get("reclamado"));
						hora.put("reclamadoId", datosIntervinientes.get("reclamadoId"));
						hora.put("reclamadoUaidinterv", datosIntervinientes.get("reclamadoUaidinterv"));
						hora.put("expediente", solarb.damecodCompleto());
						Secretar secretario = new Secretar();
						if (!Y41bUtils.esNullOCadenaVacia(solarb.getSacoset())) {
							secretario.setSrcodigo(solarb.getSacoset());
							if (this.secretarDao.findAllCount(secretario).longValue() > 0L) {
								hora.put("secretarioId", solarb.getSacoset());
								hora.put("secretario", this.secretarDao.find(secretario).getSrnombre());
							} else {
								hora.put("secretarioId", "");
								hora.put("secretario", "");
							}
						} else {
							hora.put("secretarioId", "");
							hora.put("secretario", "");
						}

						Arbitro arbitro = new Arbitro();
						String arbPresidente = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivopsup())
								? solarb.getSacoarps() : solarb.getSacoarpt());
						if (!Y41bUtils.esNullOCadenaVacia(arbPresidente)) {
							arbitro.setArcodigo(arbPresidente);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroP", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroPId", arbPresidente);
							} else {
								hora.put("arbitroP", "");
								hora.put("arbitroPId", "");
							}
						} else {
							hora.put("arbitroP", "");
							hora.put("arbitroPId", arbPresidente);
						}
						arbitro = new Arbitro();
						String arbConsumidor = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoaaccsup())
								? solarb.getSacoarts() : solarb.getSacoartt());
						if (!Y41bUtils.esNullOCadenaVacia(arbConsumidor)) {
							arbitro.setArcodigo(arbConsumidor);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroC", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroCId", arbConsumidor);
							} else {
								hora.put("arbitroC", "");
								hora.put("arbitroCId", "");
							}
						} else {
							hora.put("arbitroC", "");
							hora.put("arbitroCId", "");
						}
						arbitro = new Arbitro();
						String arbEmpresarial = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoooeesup())
								? solarb.getSacoards() : solarb.getSacoardt());
						if (!Y41bUtils.esNullOCadenaVacia(arbEmpresarial)) {
							arbitro.setArcodigo(arbEmpresarial);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroE", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroEId", arbEmpresarial);
							} else {
								hora.put("arbitroE", "");
								hora.put("arbitroEId", "");
							}
						} else {
							hora.put("arbitroE", "");
							hora.put("arbitroEId", "");
						}
					}
					if (hora != null) {
						horas.add(hora);
						hora = null;
					}
				}
				if (solarb.getSafeciau2() != null && (fechaUltimaResolucionTramitadaSiNoLaudo == null
						|| fechaUltimaResolucionTramitadaSiNoLaudo.after(solarb.getSafeciau2()))) {
					if (Y41bUtils.formatearDateToString(solarb.getSafeciau2(), "yyyyMMdd").equals(fecha)) {
						hora = new HashMap<String, String>();
						hora.put("sacodigo", solarb.getSacodigo());
						hora.put("hora", solarb.getSahrciau2());
						hora.put("audiencia", "2");
						hora.put("reclamante", datosIntervinientes.get("reclamante"));
						hora.put("reclamanteId", datosIntervinientes.get("reclamanteId"));
						hora.put("reclamanteUaidinterv", datosIntervinientes.get("reclamanteUaidinterv"));
						hora.put("reclamado", datosIntervinientes.get("reclamado"));
						hora.put("reclamadoId", datosIntervinientes.get("reclamadoId"));
						hora.put("reclamadoUaidinterv", datosIntervinientes.get("reclamadoUaidinterv"));
						hora.put("expediente", solarb.damecodCompleto());
						Secretar secretario = new Secretar();
						if (!Y41bUtils.esNullOCadenaVacia(solarb.getSacoset2())) {
							secretario.setSrcodigo(solarb.getSacoset2());
							if (this.secretarDao.findAllCount(secretario).longValue() > 0L) {
								hora.put("secretario", this.secretarDao.find(secretario).getSrnombre());
								hora.put("secretarioId", solarb.getSacoset2());
							} else {
								hora.put("secretario", "");
								hora.put("secretarioId", "");
							}
						} else {
							hora.put("secretario", "");
							hora.put("secretarioId", "");
						}
						Arbitro arbitro = new Arbitro();
						String arbPresidente = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivopsup())
								? solarb.getSacoarps2() : solarb.getSacoarpt2());
						if (!Y41bUtils.esNullOCadenaVacia(arbPresidente)) {
							arbitro.setArcodigo(arbPresidente);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroP", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroPId", arbPresidente);
							} else {
								hora.put("arbitroP", "");
								hora.put("arbitroPId", "");
							}
						} else {
							hora.put("arbitroP", "");
							hora.put("arbitroPId", "");
						}
						arbitro = new Arbitro();
						String arbConsumidor = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoaaccsup())
								? solarb.getSacoarts2() : solarb.getSacoartt2());
						if (!Y41bUtils.esNullOCadenaVacia(arbConsumidor)) {
							arbitro.setArcodigo(arbConsumidor);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroC", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroCId", arbConsumidor);
							} else {
								hora.put("arbitroC", "");
								hora.put("arbitroCId", "");
							}
						} else {
							hora.put("arbitroC", "");
							hora.put("arbitroCId", "");
						}
						arbitro = new Arbitro();
						String arbEmpresarial = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoooeesup())
								? solarb.getSacoards2() : solarb.getSacoardt2());
						if (!Y41bUtils.esNullOCadenaVacia(arbEmpresarial)) {
							arbitro.setArcodigo(arbEmpresarial);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroE", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroPId", arbEmpresarial);
							} else {
								hora.put("arbitroE", "");
								hora.put("arbitroEId", "");
							}
						} else {
							hora.put("arbitroE", "");
							hora.put("arbitroEId", "");
						}
					}
					if (hora != null) {
						horas.add(hora);
						hora = null;
					}
				}
			}
		}
		horas = ordenarHoras(horas);
		return horas;
	}

	private ArrayList<HashMap<String, String>> ordenarHoras(ArrayList<HashMap<String, String>> horas) {
		HashMap<String, String> aux;
		int horaj, horak;
		try {
			for (int j = 0; j < horas.size() - 1; j++) {
				int index = j;
				for (int k = j + 1; k < horas.size(); k++) {
					horaj = Integer.parseInt(horas.get(index).get("hora").substring(0, 2)
							+ horas.get(index).get("hora").substring(3, 5));
					horak = Integer.parseInt(
							horas.get(k).get("hora").substring(0, 2) + horas.get(k).get("hora").substring(3, 5));
					if (horak < horaj) {
						index = k;
					}
				}
				aux = horas.get(index);
				horas.set(index, horas.get(j));
				horas.set(j, aux);
			}
		} catch (Exception e) {
			// horas es null
		}

		return horas;
	}

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            the sacodigo
	 * @param relacionados
	 *            the relacionados
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroArbitraje> findAllArbitrajesRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo,
			String relacionados, Pagination pagination) {
		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA ASC, SANROR ASC, SANRAN ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA DESC, SANROR DESC, SANRAN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("arbexp.hdfechd")) {
			pagination.setSort(" arbexpHDFECHD ");
		}
		return (List<FiltroArbitraje>) this.solarbDao.findAllArbitrajeRelacionar(filtroArbitraje, sacodigo,
				relacionados, pagination);
	}

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            the sacodigo
	 * @param relacionados
	 *            the relacionados
	 * @return Long
	 */
	public Long findAllCountArbitrajesRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo,
			String relacionados) {
		return this.solarbDao.findAllCountArbitrajeRelacionar(filtroArbitraje, sacodigo, relacionados);
	}

	/**
	 * 
	 * @param anio
	 *            int
	 * @param mes
	 *            int
	 * @return HashMap<String,String>
	 * @throws Exception
	 */
	public HashMap<String, Object> getDiasConPrueba(int anio, int mes) throws Exception {
		Solarb solarb = new Solarb();
		Calendar calendar = Calendar.getInstance();
		// Calendar Enero=0
		calendar.set(anio, mes, 1);
		calendar.add(Calendar.MONTH, -3);
		Date saferepr = calendar.getTime();
		solarb.setSafereprDesde(saferepr);
		calendar.set(anio, mes, 1);
		Date saferepr2 = calendar.getTime();
		solarb.setSafereprHasta(saferepr2);
		Pagination pagination = new Pagination();
		pagination.setSort("saferepr asc, sahrrepr ");
		pagination.setSord("asc");
		List<Solarb> lista = (List<Solarb>) this.solarbDao.findAll(solarb, null);
		HashMap<String, Object> datosMes = new HashMap<String, Object>();
		int mes2 = 0;
		int mes3 = 0;
		if (mes == 1) {
			mes2 = 12;
			mes3 = 11;
		} else if (mes == 2) {
			mes2 = 1;
			mes3 = 12;
		} else {
			mes2 = mes - 1;
			mes3 = mes - 2;
		}

		ArrayList<Integer> diasMes = new ArrayList<Integer>();
		ArrayList<Integer> diasMes2 = new ArrayList<Integer>();
		ArrayList<Integer> diasMes3 = new ArrayList<Integer>();
		if (lista != null) {
			for (int i = 0; i < lista.size(); i++) {
				solarb = lista.get(i);
				if (solarb.getSaferepr() != null) {
					if (Y41bUtils.formatearDateToString(solarb.getSaferepr(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes), "0", 2))
							&& !diasMes.contains(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd"))) {
						diasMes.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd")));
					}
					if (Y41bUtils.formatearDateToString(solarb.getSaferepr(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes2), "0", 2))
							&& !diasMes2.contains(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd"))) {
						diasMes2.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd")));
					}
					if (Y41bUtils.formatearDateToString(solarb.getSaferepr(), "MM")
							.equals(Y41bUtils.rellenaIzda(String.valueOf(mes3), "0", 2))
							&& !diasMes3.contains(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd"))) {
						diasMes3.add(new Integer(Y41bUtils.formatearDateToString(solarb.getSaferepr(), "dd")));
					}
				}
			}
		}
		datosMes.put(String.valueOf(mes), diasMes);
		datosMes.put(String.valueOf(mes2), diasMes2);
		datosMes.put(String.valueOf(mes3), diasMes3);
		datosMes.put("diasConPrueba", lista);
		return datosMes;
	}

	/**
	 * 
	 * @param fecha
	 *            String
	 * @param lista
	 *            List<Solarb>
	 * @return ArrayList<HashMap<String, String>>
	 * @throws Exception
	 */
	public ArrayList<HashMap<String, String>> getHorasDiaConPrueba(String fecha, List<Solarb> lista) throws Exception {
		ArrayList<HashMap<String, String>> horas = new ArrayList<HashMap<String, String>>();
		Solarb solarb = null;
		HashMap<String, String> hora = null;
		HashMap<String, String> datosIntervinientes = null;
		for (int i = 0; i < lista.size(); i++) {
			solarb = lista.get(i);
			if ((solarb.getSaferepr() != null
					&& Y41bUtils.formatearDateToString(solarb.getSaferepr(), "yyyyMMdd").equals(fecha))) {
				datosIntervinientes = this.obtenerDatosIntervinientesCalendario(solarb);
				if (solarb.getSaferepr() != null) {
					if (Y41bUtils.formatearDateToString(solarb.getSaferepr(), "yyyyMMdd").equals(fecha)) {
						hora = new HashMap<String, String>();
						hora.put("sacodigo", solarb.getSacodigo());
						hora.put("hora", solarb.getSahrrepr());
						hora.put("audiencia", "1");
						hora.put("reclamante", datosIntervinientes.get("reclamante"));
						hora.put("reclamanteId", datosIntervinientes.get("reclamanteId"));
						hora.put("reclamanteUaidinterv", datosIntervinientes.get("reclamanteUaidinterv"));
						hora.put("reclamado", datosIntervinientes.get("reclamado"));
						hora.put("reclamadoId", datosIntervinientes.get("reclamadoId"));
						hora.put("reclamadoUaidinterv", datosIntervinientes.get("reclamadoUaidinterv"));
						hora.put("expediente", solarb.damecodCompleto());
						Secretar secretario = new Secretar();
						if (!Y41bUtils.esNullOCadenaVacia(solarb.getSacoset())) {
							secretario.setSrcodigo(solarb.getSacoset());
							if (this.secretarDao.findAllCount(secretario).longValue() > 0L) {
								hora.put("secretarioId", solarb.getSacoset());
								hora.put("secretario", this.secretarDao.find(secretario).getSrnombre());
							} else {
								hora.put("secretarioId", "");
								hora.put("secretario", "");
							}
						} else {
							hora.put("secretarioId", "");
							hora.put("secretario", "");
						}

						Arbitro arbitro = new Arbitro();
						String arbPresidente = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivopsup())
								? solarb.getSacoarps() : solarb.getSacoarpt());
						if (!Y41bUtils.esNullOCadenaVacia(arbPresidente)) {
							arbitro.setArcodigo(arbPresidente);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroP", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroPId", arbPresidente);
							} else {
								hora.put("arbitroP", "");
								hora.put("arbitroPId", "");
							}
						} else {
							hora.put("arbitroP", "");
							hora.put("arbitroPId", arbPresidente);
						}
						arbitro = new Arbitro();
						String arbConsumidor = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoaaccsup())
								? solarb.getSacoarts() : solarb.getSacoartt());
						if (!Y41bUtils.esNullOCadenaVacia(arbConsumidor)) {
							arbitro.setArcodigo(arbConsumidor);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroC", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroCId", arbConsumidor);
							} else {
								hora.put("arbitroC", "");
								hora.put("arbitroCId", "");
							}
						} else {
							hora.put("arbitroC", "");
							hora.put("arbitroCId", "");
						}
						arbitro = new Arbitro();
						String arbEmpresarial = (Y41bConstantes.VALOR_SI.equals(solarb.getXjactivoooeesup())
								? solarb.getSacoards() : solarb.getSacoardt());
						if (!Y41bUtils.esNullOCadenaVacia(arbEmpresarial)) {
							arbitro.setArcodigo(arbEmpresarial);
							if (this.arbitroDao.findAllCount(arbitro).longValue() > 0L) {
								hora.put("arbitroE", this.arbitroDao.find(arbitro).getArnombre());
								hora.put("arbitroEId", arbEmpresarial);
							} else {
								hora.put("arbitroE", "");
								hora.put("arbitroEId", "");
							}
						} else {
							hora.put("arbitroE", "");
							hora.put("arbitroEId", "");
						}
					}
					if (hora != null) {
						horas.add(hora);
						hora = null;
					}
				}
			}
		}
		horas = ordenarHoras(horas);
		return horas;
	}

	private HashMap<String, String> obtenerDatosIntervinientesCalendario(Solarb solarb) {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(new Solarb(solarb.getSacodigo()));
		HashMap<String, String> datos = new HashMap<String, String>();
		StringBuffer reclamado = new StringBuffer("");
		StringBuffer reclamante = new StringBuffer("");
		StringBuffer reclamadoId = new StringBuffer("");
		StringBuffer reclamanteId = new StringBuffer("");
		StringBuffer reclamanteUaidinterv = new StringBuffer("");
		StringBuffer reclamadoUaidinterv = new StringBuffer("");
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		if (larbinterv == null || larbinterv.size() == 0) {
			Essa essa = new Essa();
			essa.setSolarb(solarb);
			Establecimiento establecimiento = new Establecimiento();
			List<Essa> lessa = this.essaDao.findAll(essa, null);
			if (lessa != null) {
				for (int j = 0; j < lessa.size(); j++) {
					establecimiento.setEscodigo(lessa.get(j).getEstablecimiento().getEscodigo());
					establecimiento = this.establecimientoDao.find(establecimiento);
					if (reclamado.length() > 0) {
						reclamado.append(", ");
						reclamadoId.append(", ");
						reclamadoUaidinterv.append(", ");
					}
					reclamado.append(establecimiento.getEsnombre());
					reclamadoId.append(establecimiento.getEscodigo());
					reclamadoUaidinterv.append(establecimiento.getEscodigo());
				}
			}
			Dtsa dtsa = new Dtsa();
			dtsa.setSolarb(solarb);
			Consumidor consumidor = new Consumidor();
			List<Dtsa> ldtsa = this.dtsaDao.findAll(dtsa, null);
			if (ldtsa != null) {
				for (int j = 0; j < ldtsa.size(); j++) {
					consumidor.setDtcodigo(ldtsa.get(j).getConsumidor().getDtcodigo());
					consumidor = this.consumidorDao.find(consumidor);
					if (reclamante.length() > 0) {
						reclamante.append(", ");
						reclamanteId.append(", ");
						reclamanteUaidinterv.append(", ");
					}
					reclamante.append(consumidor.getDtnombre());
					if (!Y41bUtils.esNullOCadenaVacia(consumidor.getDtapellido1())) {
						reclamante.append(" ").append(consumidor.getDtapellido1());
					}
					if (!Y41bUtils.esNullOCadenaVacia(consumidor.getDtapellido2())) {
						reclamante.append(" ").append(consumidor.getDtapellido2());
					}
					reclamanteId.append(consumidor.getDtcodigo());
					reclamanteUaidinterv.append(consumidor.getDtcodigo());
				}
			}
		} else {
			for (int j = 0; j < larbinterv.size(); j++) {
				arbinterv = larbinterv.get(j);
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
					if (reclamante.length() > 0) {
						reclamante.append(", ");
						reclamanteId.append(", ");
						reclamanteUaidinterv.append(", ");
					}
					reclamante.append(arbinterv.getUanombre());
					reclamanteId.append(arbinterv.getUadtcodigo());
					reclamanteUaidinterv.append(arbinterv.getUaidinterv());
					if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido1())) {
						reclamante.append(" ").append(arbinterv.getUaapellido1());
					}
					if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido2())) {
						reclamante.append(" ").append(arbinterv.getUaapellido2());
					}
				}
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
					if (reclamado.length() > 0) {
						reclamado.append(", ");
						reclamadoId.append(", ");
						reclamadoUaidinterv.append(", ");
					}
					reclamado.append(arbinterv.getUanombre());
					reclamadoId.append(arbinterv.getUaescodigo());
					reclamadoUaidinterv.append(arbinterv.getUaidinterv());
					if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido1())) {
						reclamado.append(" ").append(arbinterv.getUaapellido1());
					}
					if (!Y41bUtils.esNullOCadenaVacia(arbinterv.getUaapellido2())) {
						reclamado.append(" ").append(arbinterv.getUaapellido2());
					}
				}
			}
		}
		datos.put("reclamante", reclamante.toString());
		datos.put("reclamanteId", reclamanteId.toString());
		datos.put("reclamanteUaidinterv", reclamanteUaidinterv.toString());
		datos.put("reclamado", reclamado.toString());
		datos.put("reclamadoId", reclamadoId.toString());
		datos.put("reclamadoUaidinterv", reclamadoUaidinterv.toString());
		return datos;
	}

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @return Solarb
	 */
	public Solarb findArbitrajeByNumeroExpediente(Solarb filterSolarb) {
		Solarb solarb = this.solarbDao.findArbitrajeByNumeroExpediente(filterSolarb);
		if (solarb == null) {
			throw new Y41bUDAException("error.sancion.numExpedienteException", true, new Exception());
		}
		/*
		 * Arbexp arbexp = new Arbexp();
		 * arbexp.setExcodigo(solarb.getSacodigo()); Arbexp arbexpaux =
		 * this.arbexpDao.findLobTablaTemporal(arbexp); if (arbexpaux != null) {
		 * solarb.getArbexp().setHdte(arbexpaux.getHdte()); }
		 */

		return solarb;
	}

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @return Solarb
	 */
	public Solarb findArbitrajeByRegistryNumber(Solarb filterSolarb) {
		return this.solarbDao.findArbitrajeByNumeroRegistro(filterSolarb);
	}

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param filterSolarb
	 *            SolarbKgest
	 * @return SolarbKgest
	 */
	public SolarbKgest findKgest(SolarbKgest filterSolarb) {

		Solarb solarb2 = new Solarb();
		solarb2.setSacodigo(filterSolarb.getSacodigo());

		SolarbKgest solarb = (SolarbKgest) this.solarbDao.findKgest(filterSolarb);
		// Saninterv saninterv = new Saninterv();
		// saninterv.setUaescodigo(solarb.getExcoes());
		// int numeroSolarbtesConRecursos = this.SolarbtesConRecursos(
		// solarb2, saninterv);
		// String respuesta = numeroSolarbtesConRecursos + "";
		// solarb.setEsTieneSentenciasFirmes(respuesta);

		return solarb;

	}

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitrajes
	 *            FiltroArbitrajes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountArbitrajes(FiltroArbitraje filtroArbitrajes, Boolean startsWith) {
		return this.solarbDao.findAllLikeCountArbitrajes(filtroArbitrajes, startsWith);
	}

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FiltroArbitraje> findAllLikeArbitrajes(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA ASC, SANRAN ASC, CORRELATIVOPAD ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA DESC, SANRAN DESC, CORRELATIVOPAD ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("exfecfin")) {
			pagination.setSort("ARBEXPEXFECFIN ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombre")) {
			pagination.setSort("fasefnombre");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombree")) {
			pagination.setSort("fasefnombree");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("arbtramexp.trnomtramCompletoes")) {
			pagination.setSort("tramiteTRNOMBRE");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("arbtramexp.trnomtramCompletoeu")) {
			pagination.setSort("tramiteTRNOMBREE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE");
		}

		return (List<FiltroArbitraje>) this.solarbDao.findAllLikeArbitrajes(filtroArbitraje, pagination, startsWith);
	}

	/**
	 * 
	 * @param interv_establecimiento
	 *            Intervinientes
	 * @param establecimiento
	 *            Establecimiento
	 * @param solarb
	 *            Solarb
	 * @param formaNotiEstablecimiento
	 *            String
	 * @return Arbinterv
	 */
	private Arbinterv generarReclamado(Intervinientes interv_establecimiento, Establecimiento establecimiento,
			Solarb solarb, String formaNotiEstablecimiento, String escodigo) {
		Arbinterv reclamadoArb = new Arbinterv();
		String pais = "";
		// preparar los datos del reclamado
		if (establecimiento == null && interv_establecimiento == null) {
			Establecimiento establecimientoFiltro = new Establecimiento();
			establecimientoFiltro.setEscodigo(escodigo);
			establecimiento = (Establecimiento) this.establecimientoDao.find(establecimientoFiltro);
			establecimiento = this.tratamientoAnyadirIntervinienteReclamado(establecimiento);
		}

		if (establecimiento != null && interv_establecimiento == null) {
			// los datos son del establecimiento de la select del hecho
			// denunciado
			reclamadoArb.setUaexcodigo(solarb.getSacodigo());
			reclamadoArb.setUaescodigo(establecimiento.getEscodigo());
			reclamadoArb.setUanombre(establecimiento.getEsnombre());
			reclamadoArb.setUanif(establecimiento.getEsnif());
			reclamadoArb.setUanrtel(establecimiento.getEsnrtel());
			reclamadoArb.setUanrtel2(establecimiento.getEsnrtel2());
			reclamadoArb.setUacoem(establecimiento.getEscoem());
			reclamadoArb.setUaprovId(establecimiento.getEsnoraProvinciaId());
			reclamadoArb.setUamunId(establecimiento.getEsnoraMunicipioId());
			reclamadoArb.setUalocId(establecimiento.getEsnoraLocalidadId());
			reclamadoArb.setUacalleId(establecimiento.getEsnoraCalleId());
			reclamadoArb.setUacpId(establecimiento.getEsnombreCp());
			reclamadoArb.setUaportalId(establecimiento.getEsnoraPortalId());
			reclamadoArb.setUanombrePiso(establecimiento.getEsnombrePiso());
			reclamadoArb.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
			reclamadoArb.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			// -> reclamadoArb.setUanodir(establecimiento.getEsnodir())
			reclamadoArb.setUanodir(establecimiento.getEsnombrePiso());
			reclamadoArb.setUadireAnt(establecimiento.getEsnodir());
			pais = "";
			if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
				pais = establecimiento.getEsnoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			reclamadoArb.setUapaisId(pais);

			reclamadoArb.setUanopeco(establecimiento.getEsnopeco());
			reclamadoArb.setUaurl(establecimiento.getEsteurl());
			reclamadoArb.setUanoco(establecimiento.getEsnoco());

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			reclamadoArb.setUasecodigo(establecSector.getSector().getSecodigo());
			reclamadoArb.setUasenombre(establecSector.getSector().getSenombre());
			reclamadoArb.setUasenombree(establecSector.getSector().getSenombree());
			reclamadoArb.setUafecultmod(establecimiento.getEsfemod());
			reclamadoArb.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());

			if (solarb.getFormanotifreclamado() != null && !"".equals(solarb.getFormanotifreclamado())) {
				reclamadoArb.setUaformanotificacion(solarb.getFormanotifreclamado());
			}

			// el idioma para el reclamado es de primeras el del censo y si no
			// tiene, castellano
			reclamadoArb.setUaidioma(establecimiento.getEscoidco() == null ? Y41bConstantes.CASTELLANO_CENSO
					: establecimiento.getEscoidco());

		} else {

			reclamadoArb.setUaexcodigo(solarb.getSacodigo());
			reclamadoArb.setUaescodigo(interv_establecimiento.getEscodigo());
			reclamadoArb.setUanombre(interv_establecimiento.getNombre());
			reclamadoArb.setUanif(interv_establecimiento.getNif());
			reclamadoArb.setUacoem(interv_establecimiento.getCoem());
			reclamadoArb.setUanrtel(interv_establecimiento.getNrtel());
			reclamadoArb.setUanrtel2(interv_establecimiento.getNrtel2());
			reclamadoArb.setUaprovId(interv_establecimiento.getNoraProvinciaId());
			reclamadoArb.setUamunId(interv_establecimiento.getNoraMunicipioId());
			reclamadoArb.setUalocId(interv_establecimiento.getNoraLocalidadId());
			reclamadoArb.setUacalleId(interv_establecimiento.getNoraCalleId());
			reclamadoArb.setUacpId(interv_establecimiento.getNombreCp());
			pais = "";
			if (Y41bConstantes.SI.equals(interv_establecimiento.getExtranjero())) {
				pais = interv_establecimiento.getNoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			reclamadoArb.setUapaisId(pais);

			reclamadoArb.setUaportalId(interv_establecimiento.getNoraPortalId());
			reclamadoArb.setUanombrePiso(interv_establecimiento.getNombrePiso());
			reclamadoArb.setUanodir(interv_establecimiento.getNombrePiso());
			reclamadoArb.setUadireAnt(interv_establecimiento.getDireccionAntigua());
			reclamadoArb.setUadireNocapv(interv_establecimiento.getDireccionNocapv());
			reclamadoArb.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			reclamadoArb.setUanopeco(interv_establecimiento.getEsnopeco());
			reclamadoArb.setUaurl(interv_establecimiento.getEsteurl());
			reclamadoArb.setUanoco(interv_establecimiento.getEsnoco());
			reclamadoArb.setUasecodigo(interv_establecimiento.getSecodigo());
			reclamadoArb.setUasenombre(interv_establecimiento.getSenombre());
			reclamadoArb.setUasenombree(interv_establecimiento.getSenombree());
			reclamadoArb.setUafecultmod(interv_establecimiento.getInfemod());
			reclamadoArb.setUausuultmod(interv_establecimiento.getIncozs());

			if (solarb.getFormanotifreclamado() != null && !"".equals(solarb.getFormanotifreclamado())) {
				reclamadoArb.setUaformanotificacion(solarb.getFormanotifreclamado());
			} else {

				if (Y41bUtils.esNullOCadenaVacia(formaNotiEstablecimiento)) {
					reclamadoArb.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
				} else {
					reclamadoArb.setUaformanotificacion(formaNotiEstablecimiento);
				}

			}
			// el idioma para el reclamado es de primeras el del censo y si no
			// tiene, castellano
			reclamadoArb.setUaidioma(interv_establecimiento.getCoidco() == null ? Y41bConstantes.CASTELLANO_CENSO
					: interv_establecimiento.getCoidco());

		}

		return reclamadoArb;
	}

	/**
	 * 
	 * @param interv_consumidor
	 *            Intervinientes
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param solarb
	 *            Solarb
	 * @return Arbinterv
	 */
	private Arbinterv generarReclamante(Intervinientes interv_consumidor, Solarb solarb, String dtcodigo) {
		Arbinterv reclamanteArb = new Arbinterv();
		String pais = null;
		if (interv_consumidor == null || interv_consumidor.getDtcodigo() == null) {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(dtcodigo);
			consumidor = this.consumidorDao.find(consumidor);

			reclamanteArb.setUaexcodigo(solarb.getSacodigo());

			reclamanteArb.setUanombre(consumidor.getDtnombre());
			reclamanteArb.setUaapellido1(consumidor.getDtapellido1());
			reclamanteArb.setUaapellido2(consumidor.getDtapellido2());
			reclamanteArb.setUacoem(consumidor.getDttecoem());
			reclamanteArb.setUanif(consumidor.getDtnif());
			reclamanteArb.setUanrtel(consumidor.getDtnrtel());
			reclamanteArb.setUanrtel2(consumidor.getDtnrtel2());
			reclamanteArb.setUaprovId(consumidor.getDtnoraProvinciaId());
			reclamanteArb.setUamunId(consumidor.getDtnoraMunicipioId());
			reclamanteArb.setUalocId(consumidor.getDtnoraLocalidadId());
			reclamanteArb.setUacalleId(consumidor.getDtnoraCalleId());
			// Este campo no se utiliza. Nora y no nora guarda el cp en
			// dtnombrecp
			// reclamanteArb.setUacpId(consumidor.getDtnoraCpId());
			reclamanteArb.setUacpId(consumidor.getDtnombreCp());
			reclamanteArb.setUaportalId(consumidor.getDtnoraPortalId());
			reclamanteArb.setUanombrePiso(consumidor.getDtnombrePiso());
			reclamanteArb.setUadireNocapv(consumidor.getDtdireccion_nocapv());
			// En el censo la logica de estos campos esta cambiada.
			reclamanteArb.setUanodir(consumidor.getDtnombrePiso());
			reclamanteArb.setUadireAnt(consumidor.getDtnodir());
			reclamanteArb.setUadtcodigo(consumidor.getDtcodigo());

			if (Y41bConstantes.SI.equals(consumidor.getDtextranjero())) {
				pais = consumidor.getDtnoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			reclamanteArb.setUapaisId(pais);

			reclamanteArb.setUafecultmod(consumidor.getDtfemod());
			reclamanteArb.setUausuultmod(consumidor.getCensoMonitor().getMocodigo());
			reclamanteArb.setUasexo(consumidor.getDtcosx());
			reclamanteArb.setUaedad(consumidor.getRangoEdad().getRancod());

			// idioma no vamos a coger el del consumidor si no el de la
			// solicitud
			reclamanteArb.setUaidioma(Y41bUtils.idiomaOneChar(solarb.getArbexp().getExidisol()));
			if (reclamanteArb.getUaidioma() == null) {
				reclamanteArb.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}

			reclamanteArb.setUatipoidentificacion(consumidor.getDtintipid());
			reclamanteArb.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

			if (solarb.getFormanotifreclamante() != null && !"".equals(solarb.getFormanotifreclamante())) {
				reclamanteArb.setUaformanotificacion(solarb.getFormanotifreclamante());
			}

		} else {

			// los datos son de intervinientes
			reclamanteArb.setUaexcodigo(solarb.getSacodigo());
			reclamanteArb.setUanombre(interv_consumidor.getNombre());
			reclamanteArb.setUaapellido1(interv_consumidor.getApellido1());
			reclamanteArb.setUaapellido2(interv_consumidor.getApellido2());
			reclamanteArb.setUacoem(interv_consumidor.getCoem());
			reclamanteArb.setUanif(interv_consumidor.getNif());
			reclamanteArb.setUanrtel(interv_consumidor.getNrtel());
			reclamanteArb.setUanrtel2(interv_consumidor.getNrtel2());
			reclamanteArb.setUaprovId(interv_consumidor.getNoraProvinciaId());
			reclamanteArb.setUamunId(interv_consumidor.getNoraMunicipioId());
			reclamanteArb.setUalocId(interv_consumidor.getNoraLocalidadId());
			reclamanteArb.setUacalleId(interv_consumidor.getNoraCalleId());
			// Este campo no se utiliza. Nora y no nora guarda el cp en
			// dtnombrecp
			// reclamanteArb.setUacpId(consumidor.getDtnoraCpId());
			reclamanteArb.setUacpId(interv_consumidor.getNombreCp());
			reclamanteArb.setUaportalId(interv_consumidor.getNoraPortalId());
			reclamanteArb.setUanombrePiso(interv_consumidor.getNombrePiso());
			reclamanteArb.setUadireNocapv(interv_consumidor.getDireccionNocapv());
			// En el censo la logica de estos campos esta cambiada.
			reclamanteArb.setUanodir(interv_consumidor.getNombrePiso());
			reclamanteArb.setUadireAnt(interv_consumidor.getDireccionAntigua());
			reclamanteArb.setUadtcodigo(interv_consumidor.getDtcodigo());

			if (Y41bConstantes.SI.equals(interv_consumidor.getExtranjero())) {
				pais = interv_consumidor.getNoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			reclamanteArb.setUapaisId(pais);

			reclamanteArb.setUafecultmod(interv_consumidor.getInfemod());
			reclamanteArb.setUausuultmod(interv_consumidor.getIncozs());
			reclamanteArb.setUasexo(interv_consumidor.getDtcosx());
			reclamanteArb.setUaedad(interv_consumidor.getDtrango_edad());
			// idioma no vamos a coger el del consumidor si no el de la
			// solicitud
			reclamanteArb.setUaidioma(Y41bUtils.idiomaOneChar(solarb.getArbexp().getExidisol()));
			if (reclamanteArb.getUaidioma() == null) {
				reclamanteArb.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}
			reclamanteArb.setUatipoidentificacion(interv_consumidor.getDtintipid());
			reclamanteArb.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

			if (solarb.getFormanotifreclamante() != null && !"".equals(solarb.getFormanotifreclamante())) {
				reclamanteArb.setUaformanotificacion(solarb.getFormanotifreclamante());
			}

		}
		return reclamanteArb;
	}

	// /**
	// * Actualiza el documento en BBDD despues de insertar el localizador.
	// *
	// * @param documentohecho
	// * DocumentoHecho
	// * @return Long
	// * @throws Exception
	// * Exception
	// */
	// @Transactional(rollbackFor = Throwable.class)
	// public Long actualizarDocumentoLocalizadorBBDD(Arbdoctemp documentoX5)
	// throws Exception {
	//
	// try {
	// int numRowsUpdated = 0;
	// Documento docDokusi = null;
	// List<Arbdoctemp> listaDocumentos = this.arbdoctempdao.findAll(
	// documentoX5, null);
	// if (listaDocumentos != null && listaDocumentos.size() > 0) {
	// Documento documento = new Documento();
	// User user = new User();
	// user.setNombre(Y41bConstantes.COD_APLICACION);
	// user.setDni(Y41bConstantes.COD_APLICACION);
	// documento.setUser(user);
	// Procedure procedure = new Procedure();
	// procedure
	// .setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
	// documento.setProcedure(procedure);
	// documento.setOidDokusi(documentoX5.getX5iddocumentum());
	//
	// docDokusi = this.y41bDokusiAdapterService
	// .descargarDocumentoDokusi(documento);
	//
	// Arbdoctemp documentohechoAux = new Arbdoctemp();
	// documentohechoAux.setX5nofile(docDokusi.getNombre());
	// documentohechoAux.setX5iddocumentum(documentoX5
	// .getX5iddocumentum());
	// documentohechoAux.setX5sizefile((int) docDokusi.getLength());
	// Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi
	// .getBytes()));
	// documentohechoAux.setX5datafile(blob);
	// documentohechoAux.setX5conttype(docDokusi.getContentType());
	//
	// numRowsUpdated = this.arbdoctempdao
	// .updateArbDocTemp(documentohechoAux);
	//
	// this.adjuntardocsDao.updateArbDocTemp(documentohechoAux);
	//
	// logger.debug("###################################ExpedienServiceImpl.actualizarDocumentoLocalizadorBBDD
	// DOID: ["
	// + listaDocumentos.get(0).getX5codocumento() + "]");
	//
	// }
	// logger.debug("###################################ExpedienServiceImpl.actualizarDocumentoLocalizadorBBDD
	// numRowsUpdated ["
	// + numRowsUpdated + "]");
	//
	// if (numRowsUpdated == 1) {
	// BandejaFirma bandejafirma = new BandejaFirma();
	// bandejafirma.setNofile(docDokusi.getNombre());
	// bandejafirma.setIddocumentum(documentoX5.getX5iddocumentum());
	// this.bandejaFirmaDao.updateDocumentoBandejaFirma(bandejafirma);
	// return new Long(1);
	// } else {
	// return new Long(0);
	// }
	// } catch (Exception e) {
	// return new Long(0);
	// }
	// }

	/**
	 * 
	 * @param dtcodigo
	 *            String
	 * @return Map<String, Object>
	 */
	public Map<String, Object> numreclamacionesyarb(String dtcodigo) {

		Map<String, Object> retorno = new HashMap<String, Object>();

		// busamos las reclamaciones del reclamante de arbitraje en los 2
		// ltimos aos

		SolicitudBusqueda filtroReclamaciones = new SolicitudBusqueda();
		filtroReclamaciones.setDtcodigo(dtcodigo);

		Date fechaHasta = Y41bUtils.obtenerFechaHoy();
		Date fechaDesde = Y41bUtils.addYear(fechaHasta, Y41bConstantes.MENOS_DOS);

		filtroReclamaciones.setDefedeHasta(fechaHasta);
		filtroReclamaciones.setDefedeDesde(fechaDesde);

		filtroReclamaciones.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION);

		Long numReclamaciones = this.hechoDenunciadoDao.findAllLikeSolicitudesReclamanteArbitraje(filtroReclamaciones,
				false);

		FiltroArbitraje filtroArbitraje = new FiltroArbitraje();
		filtroArbitraje.getArbintervReclamante().setUadtcodigo(dtcodigo);
		filtroArbitraje.setFechaIniDesde(fechaDesde);
		filtroArbitraje.setFechaIniHasta(fechaHasta);
		filtroArbitraje.setUltimoTramite(false);
		filtroArbitraje.setAcuseRecibo(false);
		filtroArbitraje.setIndPendienteFirma(false);
		Long numArbitraje = this.solarbDao.findAllLikeCountArbitrajes(filtroArbitraje, false);

		retorno.put("numReclamaciones", numReclamaciones);
		retorno.put("numArbitraje", numArbitraje);

		return retorno;
	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor) throws Exception {

		// Actualizar la tabla de expediente sancionador
		Solarb expDetalle = new Solarb();
		expDetalle.setSacodigo(solicitudCambioInstructor.getIdExpediente());
		expDetalle.setArbexp(new Arbexp());

		// String codOrg =
		solicitudCambioInstructor.getOrganismo().getCodOrg();
		String codInstr = solicitudCambioInstructor.getInstructorNuevo().getMocodigo();
		if (Y41bUtils.esNullOCadenaVacia(codInstr)) {
			// Por Javascript se controla que slo sea nulo si cambio de oficina
			// se lo asignamos al coordinador de la oficina seleccionada
			CensoMonitor censomonitor = new CensoMonitor();
			censomonitor.setOrganismo(solicitudCambioInstructor.getOrganismo());
			censomonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_COORDINADOR, null, null));
			// No dado de baja
			censomonitor.setMofecbajaDesde(Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyyMMdd"));
			List<CensoMonitor> censomonitorList = censoMonitorDao.findAll(censomonitor, null);
			if (censomonitorList != null && censomonitorList.size() > 0) {
				censomonitor = censomonitorList.get(0);
				codInstr = censomonitor.getMocodigo();
			}
		}
		// expDetalle.getArbexp().setExcooractual(codOrg);
		// expDetalle.setExcoit(codInstr);
		expDetalle.getArbexp().setExmocodigo(codInstr);
		this.actualizaExpedienteCambioInstructor(expDetalle);

		CensoMonitor censoMonitor = new CensoMonitor(codInstr, null);
		// buscar tramites con estado "En Tramitacion" en santramexp y
		// modificar
		// el usuario asignado
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(new Solarb(solicitudCambioInstructor.getIdExpediente()));
		arbtramexp.setCensoMonitor(censoMonitor);
		this.arbtramexpDao.updateCensoMonitorNoTramitados(arbtramexp);

		// Tratar la bandeja de arbitrajes (con estado "En Tramitacion")
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setSolarb(new Solarb(solicitudCambioInstructor.getIdExpediente()));
		arbbandeja.setMonitor(censoMonitor);
		this.arbbandejaDao.updateCensoMonitorNoTramitados(arbbandeja);

	}

	/**
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	private Solarb actualizaExpedienteCambioInstructor(Solarb solarb) {

		/* actualizamos sanexp */
		Arbexp arbexpModif = solarb.getArbexp();

		logger.debug("ACTUALIZAMOS INSTRUCTOR ARBEXP EXMOCODIGO. " + arbexpModif.getExmocodigo() + ".");
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp.setExmocodigo(arbexpModif.getExmocodigo());
		// arbexp.setExcooractual(arbexpModif.getExcooractual());
		arbexpDao.updateInstructorOficina(arbexp);

		return solarb;
	}

	/**
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Solarb
	 */
	public Solarb actualizaExpediente(Solarb solarb, CensoMonitor censoMonitor) {

		/* actualizamos solarb */
		Solarb expediente = new Solarb();
		expediente.setSacodigo(solarb.getSacodigo());

		expediente = this.find(expediente);
		expediente.setSafesoli(solarb.getSafesoli());
		expediente.setSainacuo(solarb.getSainacuo());
		expediente.setSaintiso(solarb.getSaintiso());
		expediente.setSacops(solarb.getSacops());
		expediente.setSacotir(solarb.getSacotir());

		Solarb solarbAux = this.update(expediente);

		/* actualizamos arbexp */
		Arbexp arbexpModif = solarb.getArbexp();
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarbAux.getSacodigo());
		arbexp = arbexpDao.find(arbexp);

		arbexp.setExdesces(arbexpModif.getExdesces());
		arbexp.setExformapres(arbexpModif.getExformapres());
		arbexp.setExfecfin(arbexpModif.getExfecfin());
		arbexp.setExfecini(arbexpModif.getExfecini());
		arbexp.setExfecprevfin(arbexpModif.getExfecprevfin());
		arbexp.setExidisol(arbexpModif.getExidisol());
		if (solarbAux.getSainacuo().equals(Y41bConstantes.ARBITRAJE_SAINACUO_ORGANISMO)) {
			arbexp.setExcoorg(arbexpModif.getExcoorg());
		} else {
			arbexp.setExcoorg(null);
		}
		arbexp.setExtippres(arbexpModif.getExtippres());
		arbexp.setExnumregistroorigen(arbexpModif.getExnumregistroorigen());
		arbexp.setExfecharegistroorigen(arbexpModif.getExfecharegistroorigen());
		arbexp.setExregen(arbexpModif.getExregen());
		arbexp.setExfecreg(arbexpModif.getExfecreg());
		arbexp.setExcaja1(arbexpModif.getExcaja1());
		arbexp.setExcaja2(arbexpModif.getExcaja2());
		arbexp.setHdte(arbexpModif.getHdte());
		arbexp.setHdteso(arbexpModif.getHdteso());
		arbexp.setHdfechd(arbexpModif.getHdfechd());
		arbexp.setHdcotsr(arbexpModif.getHdcotsr());
		arbexp.setHdcaptso(arbexpModif.getHdcaptso());
		arbexp.setHdformaventa(arbexpModif.getHdformaventa());
		arbexp.setEximporteSol(arbexpModif.getEximporteSol());
		arbexp.setEximporteOtor(arbexpModif.getEximporteOtor());
		arbexp.setExdestnotifreclamante(arbexpModif.getExdestnotifreclamante());
		arbexp.setExdestnotifreclamado(arbexpModif.getExdestnotifreclamado());
		arbexp = arbexpDao.update(arbexp);

		solarbAux.setArbexp(arbexp);
		solarb.setArbexp(arbexp);

		solarbAux.setReclamado(this.arbintervService.actualizaReclamado(solarb, censoMonitor));
		solarbAux.setReclamante(this.arbintervService.actualizaReclamante(solarb, censoMonitor));

		// Aadimos el organismo que presenta la solicitud como interviniente
		if (!Y41bUtils.esNullOCadenaVacia(solarb.getArbexp().getExcoorg())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solarb.getArbexp().getExcoorg());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
			// buscar el interviniente interesado
			Arbinterv arbintervAux = new Arbinterv();
			arbintervAux.setUaexcodigo(solarb.getSacodigo());
			arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
			arbintervAux.setUaentidadId(organismo.getEntidadId());
			List<Arbinterv> listIntervinientes = this.arbintervDao.findAll(arbintervAux, null);
			arbintervAux.setUaexcodigo(solarb.getSacodigo());
			arbintervAux.setUanombre(organismo.getNombreEs());
			// arbintervAux.setUacoem(establecimiento.getEscoem());
			arbintervAux.setUanif(organismo.getCif());
			arbintervAux.setUanrtel(organismo.getTelefono());
			arbintervAux.setUanrtel2(null);
			arbintervAux.setUaprovId(organismo.getNoraProvinciaId());
			arbintervAux.setUamunId(organismo.getNoraMunicipioId());
			arbintervAux.setUalocId(organismo.getNoraLocalidadId());
			arbintervAux.setUacalleId(organismo.getNoraCalleId());
			// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
			// nombrecp
			// arbintervAux.setUacpId(organismo.getNoraCpId());
			arbintervAux.setUacpId(organismo.getNombreCp());
			arbintervAux.setUaportalId(organismo.getNoraPortalId());
			arbintervAux
					.setUanombrePiso((organismo.getCompleDirec() != null && organismo.getCompleDirec().length() > 40)
							? organismo.getCompleDirec().substring(0, 40) : organismo.getCompleDirec());

			if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
					|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
							&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
							&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
				arbintervAux.setUadireNocapv(organismo.getNombreCalle());
			}
			arbintervAux.setUadireAnt(organismo.getCompleDirec());
			arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
			arbintervAux.setUaentidadId(organismo.getEntidadId());
			if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
				arbintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
			} else {
				arbintervAux.setUapaisId(organismo.getNoraPaisId());
			}
			arbintervAux.setUaurl(organismo.getUrl());
			arbintervAux.setUacoem(organismo.getEmail());
			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				arbintervAux.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
				this.arbintervDao.update(arbintervAux);
			} else {
				this.arbintervDao.add(arbintervAux);
			}
		}

		// Actualizar los checks de Activo de los arbitros
		Arbtramexp arbtramexpArb = new Arbtramexp();
		Solarb solarbArb = new Solarb();
		solarbArb.setSacodigo(solarbAux.getSacodigo());
		arbtramexpArb.setSolarb(solarbArb);
		arbtramexpArb.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);

		List<Arbtramexp> listaArbtramexp = arbtramexpDao.findAll(arbtramexpArb, null);
		if (listaArbtramexp != null && listaArbtramexp.size() > 0) {
			arbtramexpArb = listaArbtramexp.get(0);
			Arbcolegio arbcolegio = new Arbcolegio();
			arbcolegio.setXjtrid(arbtramexpArb.getTrid());
			arbcolegio.setXjactivop(solarb.getXjactivop());
			arbcolegio.setXjactivopsup(solarb.getXjactivopsup());
			arbcolegio.setXjactivoaacc(solarb.getXjactivoaacc());
			arbcolegio.setXjactivoaaccsup(solarb.getXjactivoaaccsup());
			arbcolegio.setXjactivoooee(solarb.getXjactivoooee());
			arbcolegio.setXjactivoooeesup(solarb.getXjactivoooeesup());
			this.arbcolegioDao.updateActivos(arbcolegio);
		}

		return solarbAux;
	}

	/**
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return List<ArbFicheroADO>
	 */
	public List<ArbFicheroADO> findAllFicheroADO(ArbFicheroADO arbFicheroADO) {

		return (List<ArbFicheroADO>) this.solarbDao.findFicheroADO(arbFicheroADO);
	}

	/**
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return List<ArbFicheroADO>
	 */
	public List<ArbFicheroADO> findAllFicheroADOPagoPericialColegio(ArbFicheroADO arbFicheroADO) {

		return (List<ArbFicheroADO>) this.solarbDao.findFicheroADOPagoPericialColegio(arbFicheroADO);
	}

	/**
	 * 
	 * @param arbfichero
	 *            ArbFicheroADO
	 * @param mapParametros
	 *            Map<String, String>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class, isolation = Isolation.READ_COMMITTED)
	public String generarFicheroADO(ArbFicheroADO arbfichero, Map<String, String> mapParametros,
			CensoMonitor censoMonitor) throws Exception {

		FileWriter fichero = null;
		PrintWriter pw = null;

		FileWriter ficheroRdo = null;
		PrintWriter pwRdo = null;
		// obtnemeos el contador
		Arbadocorrel filtroarbadocorrel = new Arbadocorrel();
		try {
			String textoADO_CONRME = mapParametros.get(Y41bADOConstantes.NAME_ADO_CONRME);
			String textoADO_CONRME_PAGPERCOLEGIO = mapParametros.get(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO);
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Ej. /datos/y41b/tmp/zip/
			String strAdoDirectory = prop.getProperty("RUTA_TMP_ADO");
			Y41bFicheroUtils.crearDirectorio(strAdoDirectory);

			Date fechaHoy = Y41bUtils.hoy();
			filtroarbadocorrel.setAnyo(mapParametros.get(Y41bADOConstantes.NAME_ADO_EJER));
			Long contador = this.arbadocorrelDao.getNextContador(filtroarbadocorrel);

			mapParametros.put(Y41bADOConstantes.NAME_ADO_CORREL, contador.toString());

			// obtenemos los datos para generar el fichero
			List<ArbFicheroADO> listFicheroADO = this.solarbDao.findFicheroADO(arbfichero);

			if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
				List<ArbFicheroADO> listFicheroADOPagoPericialColegio = this.solarbDao
						.findFicheroADOPagoPericialColegio(arbfichero);

				// Se incluyen en el fichero ADO los pagos periciales colegido
				if (listFicheroADO != null) {
					listFicheroADO.addAll(listFicheroADOPagoPericialColegio);
				} else {
					listFicheroADO = listFicheroADOPagoPericialColegio;
				}
			}

			Map<String, List<String>> mapaRellenar = Y41bADOConstantes.mapeoCaracteresRellenar();
			Map<String, BigDecimal> mapaLongitudes = Y41bADOConstantes.mapeoLongitudesParam();

			StringBuilder nombre = new StringBuilder("fadoz810_");
			// inscripcion
			// NAME_ADO_CODINS
			nombre.append(
					this.generaValor(Y41bADOConstantes.NAME_ADO_CODINS, mapParametros, mapaRellenar, mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_EJER, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_SECCION, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_ORIMAQ, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CORREL, mapParametros, mapaRellenar,
							mapaLongitudes));

			fichero = new FileWriter(strAdoDirectory.concat(nombre.toString()).concat(".txt"), false);

			pw = new PrintWriter(fichero);

			ficheroRdo = new FileWriter(strAdoDirectory.concat(nombre.toString()).concat("Rdo").concat(".txt"), false);

			pwRdo = new PrintWriter(ficheroRdo);

			StringBuilder linea = new StringBuilder("");

			// generamos la primera lnea que es especial
			linea.append(this.generaValor(Y41bADOConstantes.NAME_ADO_TIPRGT_CABECERA, mapParametros, mapaRellenar,
					mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CODINS, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_EJER, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_SECCION, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_ORIMAQ, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CORREL, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_USUARIO, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_IDIOMA, mapParametros, mapaRellenar,
							mapaLongitudes));

			pw.println(linea.toString());

			linea.setLength(0);

			List<String> listaCamposOrdenada = Y41bADOConstantes.listaCamposOrdenada();

			List<String> listaCamposOrdenadaPagPerColegio = Y41bADOConstantes.listaCamposOrdenadaPagPerColegio();

			List<String> listaCamposOrdenadaRdo = Y41bADOConstantes.listaCamposOrdenadaFichResult();

			List<String> listaCamposOrdenadaAux = null;
			StringBuilder cabeceraRDO = new StringBuilder("");

			// PINTAMOS LA CABECERA DEL FICHERO DE RDOS
			cabeceraRDO.setLength(0);
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_NUMEXP, Y41bADOConstantes.BLANCO,
					Y41bADOConstantes.LONG_ADO2_NUMEXP));
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_FECLAUDO,
					Y41bADOConstantes.BLANCO, Y41bADOConstantes.LONG_ADO2_FECLAUDO));
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_NOMBREARB,
					Y41bADOConstantes.BLANCO, Y41bADOConstantes.LONG_ADO2_NOMBREARB));
			cabeceraRDO.append(Y41bADOConstantes.TITULO_CAB_RDO_NIFARB);
			pwRdo.println(cabeceraRDO.toString());

			// recorremos los pagos
			StringBuffer tramitadores = new StringBuffer("");
			if (listFicheroADO != null && listFicheroADO.size() > 0) {

				for (int i = 0; i < listFicheroADO.size(); i++) {
					ArbFicheroADO pagoLinea = listFicheroADO.get(i);

					if (pagoLinea.getArbitrosPagoLaudo() != null && pagoLinea.getArbitrosPagoLaudo().size() > 0) {

						// metemos los valores que se cogen de BBDD en
						// parmetros
						mapParametros.put(Y41bADOConstantes.NAME_ADO_NUMXPE, pagoLinea.damecodCompletoPlatea());

						mapParametros.put(Y41bADOConstantes.NAME_ADO2_NUMEXP, pagoLinea.damecodCompleto());

						mapParametros.put(Y41bADOConstantes.NAME_ADO2_FECLAUDO,
								Y41bUtils.parseDateToString(pagoLinea.getSafelaud(), Y41bConstantes.CASTELLANO));

						/*
						 * mapParametros.put( Y41bADOConstantes.NAME_ADO_CONRME,
						 * mapParametros .get(Y41bADOConstantes.NAME_ADO_CONRME)
						 * .concat("  ") .concat(pagoLinea
						 * .damecodCompletoPlatea()));
						 */

						// El pago pericial colegio tiene su propio prefijo
						// concepto resumido
						if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(pagoLinea.getTrcodigo())) {
							mapParametros.put(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO,
									textoADO_CONRME_PAGPERCOLEGIO.concat("  ")
											.concat(pagoLinea.damecodCompletoPlatea()));
						} else {
							mapParametros.put(Y41bADOConstantes.NAME_ADO_CONRME,
									textoADO_CONRME.concat("  ").concat(pagoLinea.damecodCompletoPlatea()));
						}

						for (int j = 0; j < pagoLinea.getArbitrosPagoLaudo().size(); j++) {

							linea.setLength(0);
							Arbitro arbitro = pagoLinea.getArbitrosPagoLaudo().get(j);

							mapParametros.put(Y41bADOConstantes.NAME_ADO_CODTER,
									Y41bUtils.upperCase(arbitro.getArnif()));

							mapParametros.put(Y41bADOConstantes.NAME_ADO2_NOMBREARB, arbitro.getArnombre());

							mapParametros.put(Y41bADOConstantes.NAME_ADO2_NIFARB,
									Y41bUtils.upperCase(arbitro.getArnif()));

							// por cada arbitro tenemos que escribir una lineas
							// en cada fichero
							// Para el pago pericial colegio, la lista de
							// parametros es diferente
							if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
									.equals(pagoLinea.getTrcodigo())) {

								listaCamposOrdenadaAux = listaCamposOrdenadaPagPerColegio;
							} else {
								listaCamposOrdenadaAux = listaCamposOrdenada;
							}

							for (int z = 0; z < listaCamposOrdenadaAux.size(); z++) {

								linea.append(this.generaValor(listaCamposOrdenadaAux.get(z), mapParametros,
										mapaRellenar, mapaLongitudes));

							}

							pw.println(linea);

							linea.setLength(0);
							for (int z = 0; z < listaCamposOrdenadaRdo.size(); z++) {

								linea.append(this.generaValor(listaCamposOrdenadaRdo.get(z), mapParametros,
										mapaRellenar, mapaLongitudes));

							}
							pwRdo.println(linea);

						}
					}

					// Buscamos la orden de pago

					Arbdoctemp ordenPago = new Arbdoctemp();
					ordenPago.setX5excodigo(pagoLinea.getSacodigo());
					List<Arbdoctemp> ordenesPago = arbdoctempDao.findAllOrdenesPago(ordenPago, null);
					for (int j = 0; j < ordenesPago.size(); j++) {
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(ordenesPago.get(j).getX5iddocumentum());

						Documento docDokusi = this.y41bDokusiAdapterService.descargarDocumentoDokusi(documento);
						InputStream ficheroStream = (new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes())))
								.getBinaryStream();
						String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
						String strZipDirectory = strTmpZipDirectory + nombre;
						Y41bFicheroUtils.crearDirectorio(strZipDirectory);
						File ficheroOrdenPago = null;
						String local = (String) prop.getProperty("y41bVistaWar.entorno.local");
						if ("true".equals(local)) {
							ficheroOrdenPago = new File(strZipDirectory.concat("\\").concat(documento.getOidDokusi())
									.concat(docDokusi.getNombre()));
						} else {
							ficheroOrdenPago = new File(strZipDirectory.concat("/").concat(documento.getOidDokusi())
									.concat(docDokusi.getNombre()));

						}
						Y41bFicheroUtils.escribirFichero(ficheroStream, ficheroOrdenPago);
						if (null != ficheroStream) {
							ficheroStream.close();
						}
					}

					// tramitadores
					CensoMonitor tramitador = new CensoMonitor(pagoLinea.getTrmocodigoEj(), null);
					tramitador = this.censoMonitorDao.find(tramitador);
					if (tramitadores.indexOf(tramitador.getMocoem()) == -1) {
						tramitadores.append(";").append(tramitador.getMocoem());
					}

					// Para el pago pericial colegio, hay que actualizar la
					// fecha de pago pericial colegio
					if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(pagoLinea.getTrcodigo())) {
						Solarb solarb = new Solarb();
						solarb.setSacodigo(pagoLinea.getSacodigo());
						solarb.setSafeoppc(fechaHoy);
						this.solarbDao.updateEnvioPagoPericialColegio(solarb);
					} else {
						// aqu tenemos que actualizar el flag y la fecha de
						// envio
						// del tramite de pagoLaudo.
						Solarb solarb = new Solarb();
						solarb.setSacodigo(pagoLinea.getSacodigo());
						solarb.setSafeopla(fechaHoy);
						this.solarbDao.updateEnvioPagoLaudo(solarb);
					}

					// Coger el importe del pago para grabarlo en ARBTRAMEXP y
					// tener
					// referencia de lo que se pago en su momento (OBIEE)
					String importe = null;
					if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(pagoLinea.getTrcodigo())) {
						importe = mapParametros.get("ADO_IMPORTE_PAGPERCOLEGIO") != null
								? mapParametros.get("ADO_IMPORTE_PAGPERCOLEGIO") : null;
					} else {
						importe = mapParametros.get("ADO_IMPORTE") != null ? mapParametros.get("ADO_IMPORTE") : null;
					}

					// actualizamos tambien en la tabla de artramexp los datos
					// del envio y el flag.
					// En Tridpagolaudo va el trid del pago laudo o el pago
					// pericial colegio, segn el registro que se trate
					Arbtramexp tramitePagoLaudo = new Arbtramexp();
					tramitePagoLaudo.setTrid(pagoLinea.getTridpagolaudo());
					tramitePagoLaudo.setTrfeopla(fechaHoy);
					tramitePagoLaudo.setTrimporte((new BigDecimal(importe)).divide(new BigDecimal(100)));
					tramitePagoLaudo.setTrfichado(nombre.toString());
					this.arbtramexpDao.updateTrasGenerarFicheroADO(tramitePagoLaudo);

				}
				// cerramos el flujo de los dos ficheros generados
				if (null != fichero) {
					fichero.close();
				}

				if (null != ficheroRdo) {
					ficheroRdo.close();
				}

				String strZipFile = this.generarZipFicheroADO(nombre.toString(), strAdoDirectory);

				// enviamos mail
				String from = "";

				if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
					throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
				} else if (censoMonitor != null) {
					from = censoMonitor.getMocoem();
				}

				String destinatariosMail = mapParametros.get(Y41bADOConstantes.NAME_ADO_EMAIL);

				if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
					throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
				}
				StringBuffer destinatarios = new StringBuffer("");
				destinatarios.append(destinatariosMail);
				destinatarios.append(tramitadores);

				String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

				StringBuffer asunto = new StringBuffer("");
				asunto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" \n");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));

				// 3. Creo el contenido del mail
				StringBuffer texto = new StringBuffer("");
				texto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.texto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				texto.append(" \n");
				// Euskera
				texto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.texto", null,
						new Locale(Y41bConstantes.EUSKERA)));

				// 4. Creo attachments del mail
				List<AttachFile> attachments = new ArrayList<AttachFile>();
				AttachFile fileattach = new AttachFile();
				fileattach.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
				fileattach.setNombre(nombre.toString().concat(Y41bConstantes.EXTENSION_ZIP));

				fileattach.setAdjunto(Y41bUtils.convertTxtFiletoBlob(strZipFile));

				attachments.add(fileattach);

				// 5. Envio mail
				boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
						destinatarios.toString(), "", attachments);

				if (!envio) {
					throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
				}
				return destinatarios.toString();
			} else {
				return "0";
			}

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en generandoFicheroADO: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		} finally {
			// Nuevamente aprovechamos el finally para
			// asegurarnos que se cierra el fichero.
			if (null != fichero) {
				fichero.close();
			}

			if (null != ficheroRdo) {
				ficheroRdo.close();
			}
			try {
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
	}

	/**
	 * 
	 * @param nombreParametro
	 *            String
	 * @param mapParametros
	 *            Map<String, String>
	 * @param mapaRellenar
	 *            Map<String, List<String>>
	 * @param mapaLongitudes
	 *            Map<String, BigDecimal>
	 * @return String
	 */
	private String generaValor(String nombreParametro, Map<String, String> mapParametros,
			Map<String, List<String>> mapaRellenar, Map<String, BigDecimal> mapaLongitudes) {

		String valorRetorno = "";

		String valorParam = mapParametros.get(nombreParametro) != null ? mapParametros.get(nombreParametro) : "";
		String caracterRelleno = " ";
		String ladoRelleno = Y41bADOConstantes.DCHA;
		if (mapaRellenar.get(nombreParametro) != null) {

			if (mapaRellenar.get(nombreParametro).size() > 0) {

				caracterRelleno = mapaRellenar.get(nombreParametro).get(0);
				ladoRelleno = mapaRellenar.get(nombreParametro).get(1);

			}

		}

		int longitudCampo = mapaLongitudes.get(nombreParametro) != null ? mapaLongitudes.get(nombreParametro).intValue()
				: 0;

		if (ladoRelleno.equals(Y41bADOConstantes.IZQDA)) {
			valorRetorno = Y41bUtils.rellenaIzda(valorParam, caracterRelleno, longitudCampo);
		} else {
			valorRetorno = Y41bUtils.rellenaDcha(valorParam, caracterRelleno, longitudCampo);
		}

		return valorRetorno;

	}

	private String generarZipFicheroADO(String nombre, String strAdoDirectory) throws Exception {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		// creamos el zip para enviar el mail
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		String strZipDirectory = strTmpZipDirectory + nombre;
		// Ej.
		// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strZipFile = strTmpZipDirectory + nombre + Y41bConstantes.EXTENSION_ZIP;

		Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
		Y41bFicheroUtils.crearDirectorio(strZipDirectory);
		Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), Y41bConstantes.NUM_60000);

		String nombreFichero = null;
		InputStream ficheroStream = null;
		File fileFichero = null;
		File fileFicheroRdo = null;
		int numDoc = 1;

		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

		if ("true".equals(local)) {
			fileFichero = new File(strZipDirectory.concat("\\").concat(nombre.toString()).concat(".txt"));
			fileFicheroRdo = new File(
					strZipDirectory.concat("\\").concat(nombre.toString()).concat("Rdo").concat(".txt"));
		} else {
			fileFichero = new File(strZipDirectory.concat("/").concat(nombre.toString()).concat(".txt"));
			fileFicheroRdo = new File(
					strZipDirectory.concat("/").concat(nombre.toString()).concat("Rdo").concat(".txt"));
		}

		SolarbServiceImpl.logger.info("SolarbServiceImpl. - crearZipFicheroADO. crearZipFicheroADO. Paso 7.Bucle"
				+ numDoc + "." + strZipDirectory + "\\" + numDoc + "." + nombreFichero + ".");

		// primero el fichero de pagos
		ficheroStream = new FileInputStream(new File(strAdoDirectory.concat(nombre.toString()).concat(".txt")));
		Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
		ficheroStream.close();

		// luego el de rdo
		ficheroStream = new FileInputStream(
				new File(strAdoDirectory.concat(nombre.toString()).concat("Rdo").concat(".txt")));
		Y41bFicheroUtils.escribirFichero(ficheroStream, fileFicheroRdo);
		ficheroStream.close();

		// 5. Comprimimos el directorio del zip en el fichero zip que
		// hemos creado
		Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);

		// Copiar zip
		String strCopiaZipDirectory = prop.getProperty("RUTA_COPIA_ADO");
		String strCopiaZipFile = strCopiaZipDirectory + nombre + Y41bConstantes.EXTENSION_ZIP;
		Y41bFicheroUtils.crearDirectorio(strCopiaZipDirectory);
		Y41bFicheroUtils.copiarFichero(strZipFile, strCopiaZipFile);
		return strZipFile;

	}

	private String generarZipFicheroADONuevo(String nombre, String strAdoDirectory) throws Exception {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		// creamos el zip para enviar el mail
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		String strZipDirectory = strTmpZipDirectory + nombre;
		// Ej.
		// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strZipFile = strTmpZipDirectory + nombre + Y41bConstantes.EXTENSION_ZIP;

		Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
		Y41bFicheroUtils.crearDirectorio(strZipDirectory);
		Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), Y41bConstantes.NUM_60000);

		String nombreFichero = null;
		InputStream ficheroStream = null;
		File fileFicheroRdo = null;
		int numDoc = 1;

		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

		if ("true".equals(local)) {
			fileFicheroRdo = new File(
					strZipDirectory.concat("\\").concat(nombre.toString()).concat("Rdo").concat(".txt"));
		} else {
			fileFicheroRdo = new File(
					strZipDirectory.concat("/").concat(nombre.toString()).concat("Rdo").concat(".txt"));
		}

		SolarbServiceImpl.logger.info("SolarbServiceImpl. - crearZipFicheroADO. crearZipFicheroADO. Paso 7.Bucle"
				+ numDoc + "." + strZipDirectory + "\\" + numDoc + "." + nombreFichero + ".");

		// luego el de rdo
		ficheroStream = new FileInputStream(
				new File(strAdoDirectory.concat(nombre.toString()).concat("Rdo").concat(".txt")));
		Y41bFicheroUtils.escribirFichero(ficheroStream, fileFicheroRdo);
		ficheroStream.close();

		// 5. Comprimimos el directorio del zip en el fichero zip que
		// hemos creado
		Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);

		// Copiar zip
		String strCopiaZipDirectory = prop.getProperty("RUTA_COPIA_ADO");
		String strCopiaZipFile = strCopiaZipDirectory + nombre + Y41bConstantes.EXTENSION_ZIP;
		Y41bFicheroUtils.crearDirectorio(strCopiaZipDirectory);
		Y41bFicheroUtils.copiarFichero(strZipFile, strCopiaZipFile);
		return strZipFile;

	}

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FiltroArbitraje> findAllLikeArbitrajesBusquedaCombinada(FiltroArbitraje filtroArbitraje,
			Pagination pagination, Boolean startsWith) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA ASC, SANROR ASC, SANRAN ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("SACOJA DESC, SANROR DESC, SANRAN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("exfecfin")) {
			pagination.setSort("ARBEXPEXFECFIN ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombre")) {
			pagination.setSort("fasefnombre");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombree")) {
			pagination.setSort("fasefnombree");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("arbtramexp.trnomtramCompletoes")) {
			pagination.setSort("tramiteTRNOMBRE");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("arbtramexp.trnomtramCompletoeu")) {
			pagination.setSort("tramiteTRNOMBREE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE");
		}

		filtroArbitraje.setUltimoTramite(false);
		filtroArbitraje.setIndPendienteFirma(false);
		filtroArbitraje.setAcuseRecibo(false);

		return (List<FiltroArbitraje>) this.solarbDao.findAllLikeArbitrajesCombinada(filtroArbitraje, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeArbitrajesBusquedaCombinadaCount(FiltroArbitraje filtroArbitraje, Boolean startsWith) {
		return this.solarbDao.findAllLikeArbitrajesBusquedaCombinadaCount(filtroArbitraje, startsWith);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.SolarbService#volcarDocumentosReclamacionPrevia
	 * (java.lang.String, java.lang.String)
	 */
	@Override
	public void volcarDocumentosReclamacionPrevia(String hdcodigo, String idTramiteApertura) {
		this.arbdoctempDao.removeDocumentosReclamacionPrevia(idTramiteApertura);
		if (!Y41bUtils.esNullOCadenaVacia(hdcodigo)) {
			this.arbdoctempDao.volcarDocumentosReclamacionPrevia(hdcodigo, idTramiteApertura);
		}
	}

	public String envioMailEstablecimiento(String from, Establecimiento establecimiento) {
		StringBuilder mensaje = new StringBuilder("");

		String smtpMail = (String) this.appConfiguration.get("y41bVistaWar.mail.ejie.smtp");

		String asunto = this.appMessageSource.getMessage("arbitraje.petActDatos.asuntoEmail", null,
				LocaleContextHolder.getLocale());

		String enlaceEs = (String) this.appConfiguration.get("y41bVistaWar.enlaceSolicitudAdhesion.es");
		String enlaceEu = (String) this.appConfiguration.get("y41bVistaWar.enlaceSolicitudAdhesion.eu");
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - INICIO");
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - from: " + from);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - destinatario: " + establecimiento.getEscoem());
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - smtpMail: " + smtpMail);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - asunto: " + asunto);

		String[] args = { establecimiento.getEsnombre(), establecimiento.getEsnif(),
				establecimiento.getEsdireccionCompleta(),
				establecimiento.getEsnombreMunicipio() == null ? "" : establecimiento.getEsnombreMunicipio(), enlaceEu,
				establecimiento.getEsnombre(), establecimiento.getEsnif(), establecimiento.getEsdireccionCompleta(),
				establecimiento.getEsnombreMunicipio() == null ? "" : establecimiento.getEsnombreMunicipio(),
				enlaceEs };
		String texto = this.appMessageSource.getMessage("arbitraje.petActDatos.textoEmail", args,
				LocaleContextHolder.getLocale());
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - texto: " + texto);

		List<AttachFile> attachments = new ArrayList<AttachFile>();
		AttachFile fileattach = new AttachFile();
		fileattach.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
		fileattach.setNombre("image.png");
		fileattach.setContentId("image");
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		fileattach.setAdjunto(Y41bUtils.convertTxtFiletoBlob(prop.getProperty("IMAGEN_EMAIL_ESTABLECIMIENTO")));
		attachments.add(fileattach);

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto, texto, from, establecimiento.getEscoem(), "",
				attachments);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - FIN");
		if (!enviadoOK) {
			SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - NO Enviado");
			mensaje.append(this.appMessageSource.getMessage("error.comunicacion.email", null,
					LocaleContextHolder.getLocale()));
		}
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - enviadoOK");
		return mensaje.toString();
	}

	public String envioMailEstablecimientoIconoWeb(String from, Establecimiento establecimiento) {
		StringBuilder mensaje = new StringBuilder("");

		String smtpMail = (String) this.appConfiguration.get("y41bVistaWar.mail.ejie.smtp");

		String asunto = this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.asuntoEmail", null,
				LocaleContextHolder.getLocale());

		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - INICIO");
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - from: " + from);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - destinatario: " + establecimiento.getEscoem());
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - smtpMail: " + smtpMail);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - asunto: " + asunto);

		String[] args = { establecimiento.getEscodigo(), establecimiento.getEscodigo(), establecimiento.getEscodigo(),
				establecimiento.getEscodigo(), establecimiento.getEscodigo(), establecimiento.getEscodigo(),
				establecimiento.getEscodigo(), establecimiento.getEscodigo(), establecimiento.getEscodigo(),
				establecimiento.getEscodigo(), establecimiento.getEscodigo(), establecimiento.getEscodigo() };
		String texto = this.appMessageSource.getMessage("arbitraje.mailingIconoWeb.textoEmail", args,
				LocaleContextHolder.getLocale());
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - texto: " + texto);

		List<AttachFile> attachments = new ArrayList<AttachFile>();
		AttachFile fileattach = new AttachFile();
		fileattach.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
		fileattach.setNombre("image.png");
		fileattach.setContentId("image");
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		fileattach.setAdjunto(Y41bUtils.convertTxtFiletoBlob(prop.getProperty("IMAGEN_EMAIL_ESTABLECIMIENTO")));
		attachments.add(fileattach);

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto, texto, from, establecimiento.getEscoem(), "",
				attachments);
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - FIN");
		if (!enviadoOK) {
			SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - NO Enviado");
			mensaje.append(this.appMessageSource.getMessage("error.comunicacion.email", null,
					LocaleContextHolder.getLocale()));
		}
		SolarbServiceImpl.logger.debug("Y41bUtils.sendMail - enviadoOK");
		return mensaje.toString();
	}

	/**
	 * tratamientoAnyadirIntervinienteSancionado
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	private Establecimiento tratamientoAnyadirIntervinienteReclamado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un reclamado a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

	/**
	 * 
	 * findAllLikeListaADO
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * 
	 * @param pagination
	 *            Pagination
	 * 
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	public List<ArbPagoArbitroADO> findAllLikeListaADO(ArbPagoArbitroADO arbPagoArbitroADO, Pagination pagination,
			Boolean startsWith) {

		List<ArbPagoArbitroADO> listEstablecimiento = this.solarbDao.findlistaADO(arbPagoArbitroADO, pagination,
				startsWith);

		return listEstablecimiento;
	}

	/**
	 * 
	 * findAllLikeListaADOCount
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeListaADOCount(ArbPagoArbitroADO arbPagoArbitroADO, Boolean startsWith) {
		return this.solarbDao.findlistaADOCount(arbPagoArbitroADO, startsWith);
	}

	/**
	 * Method 'enviarEika'.
	 *
	 * @param listadoPagosArbitros
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void enviarEika(List<ArbPagoArbitroADO> listaPagos, Map<String, String> mapParametros,
			CensoMonitor censoMonitor) {
		// valida parametros ficheroADO y validamos que los arbitros sean
		// terceros antes de llegar aqui
		List<ArbPagoArbitroADO> lista = new ArrayList<ArbPagoArbitroADO>();
		for (ArbPagoArbitroADO pago : listaPagos) {
			// aqui llegan las lineas que se han seleccionado en el grid,
			// tenemos el sacodigo y el trid laudo para hacer para todos los
			// arbitros del colegio si solo se ha seleccionado uno
			ArbPagoArbitroADO pagoBuscar = new ArbPagoArbitroADO();
			pagoBuscar.setSacodigo(pago.getSacodigo());
			pagoBuscar.setTridpagolaudo(pago.getTridpagolaudo());
			lista.addAll(this.findAllLikeListaADO(pagoBuscar, null, false));

		}

		LinkedHashSet<ArbPagoArbitroADO> withUniqueValue = new LinkedHashSet<ArbPagoArbitroADO>(lista);

		lista.clear();
		lista.addAll(withUniqueValue);

		if (!lista.isEmpty()) {

			List<Map<String, String>> listaPagosParametros = new ArrayList<Map<String, String>>();
			for (ArbPagoArbitroADO pagoArbitro : lista) {

				// buscar si ya esta insertado
				Long existe = this.solarbDao.existePagoArbitro(pagoArbitro);

				// aniadir el arbitro a la lista de parametros
				if (existe == 0) {
					Map<String, String> mapaPago = new HashMap<String, String>();
					mapaPago.put("ID", pagoArbitro.getArnif());
					mapaPago.put("LAUDO", (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO.equals(pagoArbitro.getTrcodigo())
							? "L" : "P"));
					listaPagosParametros.add(mapaPago);
				}
			}

			// llamar al servicio de eika
			List<Map<String, String>> resultadoServicio = this.y41bEIKAAdapterService
					.crearObligaciones(listaPagosParametros);

			for (int i = 0; i < lista.size(); i++) {
				ArbPagoArbitroADO pagoArbitro = lista.get(i);
				Map<String, String> posicionResultadoServicio = resultadoServicio.get(i);

				// llamada

				// actualizar la tabla solarb , campos SAFEIPPC y
				// SAFEOPLA,
				// metodos
				// updateEnvioPagoLaud y upadteEnvioPagoPerciailCOlegio
				Solarb solarb = new Solarb();

				solarb.setSacodigo(pagoArbitro.getSacodigo());

				// estos dos dato vendrian de la llamada
				Date ahora = new Date();
				solarb.setSafeopla(ahora);
				solarb.setSafeoppc(ahora);
				this.solarbDao.updateEnvioPagoLaudo(solarb);

				this.solarbDao.updateEnvioPagoPericialColegio(solarb);
				// actualizar la tabla solarb

				// actualizar los tramites pagolaudo o pago pericial,
				// mryofo
				// ypdateTrasgenerarFicheroADo
				Arbtramexp arbtramexp = new Arbtramexp();
				// UPDATE ARBTRAMEXP SET TRFEOPLA=?, TRFICHADO=?,
				// TRIMPORTE=? WHERE
				// TRID=?
				arbtramexp.setTrid(pagoArbitro.getTridpagolaudo());

				// estos 3 dato vendrian de la llamada
				arbtramexp.setTrfeopla(ahora);
				arbtramexp.setTrfichado(posicionResultadoServicio.get("CODIGOEXPEDIENTE"));

				arbtramexp.setTrimporte(new BigDecimal(pagoArbitro.getTrimporte()));
				this.arbtramexpDao.updateTrasGenerarFicheroADO(arbtramexp);
				// actualizar los tramites pagolaudo o pago pericial

				// alta en tabla PAGOSARBITROS revisar estos datos
				Pagosarbitros pagoInsertar = new Pagosarbitros();
				pagoInsertar.setPasacodigo(pagoArbitro.getSacodigo());
				pagoInsertar.setPaarcodigo(pagoArbitro.getArcodigo());
				pagoInsertar.setPatrid(pagoArbitro.getTridpagolaudo());
				pagoInsertar.setPanumexp(posicionResultadoServicio.get("CODIGOEXPEDIENTE"));
				pagoInsertar.setPafeccont(null);
				pagoInsertar.setPafecultcon(null);
				pagoInsertar.setPadocfi(posicionResultadoServicio.get("DOCFI"));
				pagoInsertar.setPadocfi("DOCFI");
				this.solarbDao.insertPagoArbitro(pagoInsertar);
			}

			try {
				this.generarFicheroADONuevo(lista, mapParametros, censoMonitor);
			} catch (Y41bUDAException e) {
				// Se ahoga la excepcion para evitar que el pago se haga y no
				// quede reflejado en nuestras tablas
				logger.error("Error producido en envio de correo: " + e.getMessage(), e);
				// throw e;
			} catch (Exception e) {
				// Se ahoga la excepcion para evitar que el pago se haga y no
				// quede reflejado en nuestras tablas
				logger.error("Error producido en envio de correo: " + e.getMessage(), e);
				// throw new Y41bUDAException("error.generico", true, e);
			}

		}
	}

	@Transactional(rollbackFor = Throwable.class)
	public void validarArbitrostercero(List<Arbitro> listaArbitros) {
		for (Arbitro arbitro : listaArbitros) {
			arbitro = this.arbitroDao.find(arbitro);

			boolean estaDadoAlta = this.y41bEIKAAdapterService.consultaTerceros(arbitro.getArnif(),
					Y41bConstantes.EIKA_TIPO_ID_ES1);

			if (estaDadoAlta) {
				arbitro.setArtercero("S");
			} else {
				arbitro.setArtercero("");
			}
			this.arbitroDao.update(arbitro);
		}

	}

	/**
	 * 
	 * @param arbfichero
	 *            ArbFicheroADO
	 * @param mapParametros
	 *            Map<String, String>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             e
	 */

	private String generarFicheroADONuevo(List<ArbPagoArbitroADO> lista, Map<String, String> mapParametros,
			CensoMonitor censoMonitor) throws Exception {

		FileWriter ficheroRdo = null;
		PrintWriter pwRdo = null;
		// obtnemeos el contador
		Arbadocorrel filtroarbadocorrel = new Arbadocorrel();
		try {
			String textoADO_CONRME = mapParametros.get(Y41bADOConstantes.NAME_ADO_CONRME);
			String textoADO_CONRME_PAGPERCOLEGIO = mapParametros.get(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO);
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Ej. /datos/y41b/tmp/zip/
			String strAdoDirectory = prop.getProperty("RUTA_TMP_ADO");
			Y41bFicheroUtils.crearDirectorio(strAdoDirectory);

			Date fechaHoy = Y41bUtils.hoy();
			filtroarbadocorrel.setAnyo(mapParametros.get(Y41bADOConstantes.NAME_ADO_EJER));
			Long contador = this.arbadocorrelDao.getNextContador(filtroarbadocorrel);

			mapParametros.put(Y41bADOConstantes.NAME_ADO_CORREL, contador.toString());

			// obtenemos los datos para generar el fichero
			// List<ArbFicheroADO> listFicheroADO =
			// this.solarbDao.findFicheroADO(arbfichero);
			//
			// if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			// List<ArbFicheroADO> listFicheroADOPagoPericialColegio =
			// this.solarbDao
			// .findFicheroADOPagoPericialColegio(arbfichero);
			//
			// // Se incluyen en el fichero ADO los pagos periciales colegido
			// if (listFicheroADO != null) {
			// listFicheroADO.addAll(listFicheroADOPagoPericialColegio);
			// } else {
			// listFicheroADO = listFicheroADOPagoPericialColegio;
			// }
			// }

			Map<String, List<String>> mapaRellenar = Y41bADOConstantes.mapeoCaracteresRellenar();
			Map<String, BigDecimal> mapaLongitudes = Y41bADOConstantes.mapeoLongitudesParam();

			StringBuilder nombre = new StringBuilder("fadoz810_");
			// inscripcion
			// NAME_ADO_CODINS
			nombre.append(
					this.generaValor(Y41bADOConstantes.NAME_ADO_CODINS, mapParametros, mapaRellenar, mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_EJER, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_SECCION, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_ORIMAQ, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CORREL, mapParametros, mapaRellenar,
							mapaLongitudes));

			ficheroRdo = new FileWriter(strAdoDirectory.concat(nombre.toString()).concat("Rdo").concat(".txt"), false);

			pwRdo = new PrintWriter(ficheroRdo);

			StringBuilder linea = new StringBuilder("");

			// generamos la primera lnea que es especial
			linea.append(this.generaValor(Y41bADOConstantes.NAME_ADO_TIPRGT_CABECERA, mapParametros, mapaRellenar,
					mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CODINS, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_EJER, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_SECCION, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_ORIMAQ, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_CORREL, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_USUARIO, mapParametros, mapaRellenar,
							mapaLongitudes))
					.append(this.generaValor(Y41bADOConstantes.NAME_ADO_IDIOMA, mapParametros, mapaRellenar,
							mapaLongitudes));

			// pw.println(linea.toString());

			linea.setLength(0);

			List<String> listaCamposOrdenada = Y41bADOConstantes.listaCamposOrdenada();

			List<String> listaCamposOrdenadaPagPerColegio = Y41bADOConstantes.listaCamposOrdenadaPagPerColegio();

			List<String> listaCamposOrdenadaRdo = Y41bADOConstantes.listaCamposOrdenadaFichResult();

			List<String> listaCamposOrdenadaAux = null;
			StringBuilder cabeceraRDO = new StringBuilder("");

			// PINTAMOS LA CABECERA DEL FICHERO DE RDOS
			cabeceraRDO.setLength(0);
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_NUMEXP, Y41bADOConstantes.BLANCO,
					Y41bADOConstantes.LONG_ADO2_NUMEXP));
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_FECLAUDO,
					Y41bADOConstantes.BLANCO, Y41bADOConstantes.LONG_ADO2_FECLAUDO));
			cabeceraRDO.append(Y41bUtils.rellenaDcha(Y41bADOConstantes.TITULO_CAB_RDO_NOMBREARB,
					Y41bADOConstantes.BLANCO, Y41bADOConstantes.LONG_ADO2_NOMBREARB));
			cabeceraRDO.append(Y41bADOConstantes.TITULO_CAB_RDO_NIFARB);
			pwRdo.println(cabeceraRDO.toString());

			// recorremos los pagos
			StringBuffer tramitadores = new StringBuffer("");
			List<String> listaExpedientes = new ArrayList<String>();
			if (lista != null && lista.size() > 0) {

				for (int i = 0; i < lista.size(); i++) {
					ArbPagoArbitroADO pagoLinea = lista.get(i);
					listaExpedientes.add(pagoLinea.getSacodigo());

					// if (pagoLinea.getArbitrosPagoLaudo() != null &&
					// pagoLinea.getArbitrosPagoLaudo().size() > 0) {

					// metemos los valores que se cogen de BBDD en
					// parmetros
					mapParametros.put(Y41bADOConstantes.NAME_ADO_NUMXPE, pagoLinea.damecodCompletoPlatea());

					mapParametros.put(Y41bADOConstantes.NAME_ADO2_NUMEXP, pagoLinea.damecodCompleto());

					mapParametros.put(Y41bADOConstantes.NAME_ADO2_FECLAUDO,
							Y41bUtils.parseDateToString(pagoLinea.getSafelaud(), Y41bConstantes.CASTELLANO));

					/*
					 * mapParametros.put( Y41bADOConstantes.NAME_ADO_CONRME,
					 * mapParametros .get(Y41bADOConstantes.NAME_ADO_CONRME)
					 * .concat("  ") .concat(pagoLinea
					 * .damecodCompletoPlatea()));
					 */

					// El pago pericial colegio tiene su propio prefijo
					// concepto resumido
					if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(pagoLinea.getTrcodigo())) {
						mapParametros.put(Y41bADOConstantes.NAME_ADO_CONRME_PAGPERCOLEGIO,
								textoADO_CONRME_PAGPERCOLEGIO.concat("  ").concat(pagoLinea.damecodCompletoPlatea()));
					} else {
						mapParametros.put(Y41bADOConstantes.NAME_ADO_CONRME,
								textoADO_CONRME.concat("  ").concat(pagoLinea.damecodCompletoPlatea()));
					}

					linea.setLength(0);
					// Arbitro arbitro =
					// pagoLinea.getArbitrosPagoLaudo().get(j);

					mapParametros.put(Y41bADOConstantes.NAME_ADO_CODTER, Y41bUtils.upperCase(pagoLinea.getArnif()));

					mapParametros.put(Y41bADOConstantes.NAME_ADO2_NOMBREARB, pagoLinea.getArnombre());

					mapParametros.put(Y41bADOConstantes.NAME_ADO2_NIFARB, Y41bUtils.upperCase(pagoLinea.getArnif()));

					// por cada arbitro tenemos que escribir una lineas
					// en cada fichero
					// Para el pago pericial colegio, la lista de
					// parametros es diferente
					if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(pagoLinea.getTrcodigo())) {

						listaCamposOrdenadaAux = listaCamposOrdenadaPagPerColegio;
					} else {
						listaCamposOrdenadaAux = listaCamposOrdenada;
					}

					for (int z = 0; z < listaCamposOrdenadaAux.size(); z++) {

						linea.append(this.generaValor(listaCamposOrdenadaAux.get(z), mapParametros, mapaRellenar,
								mapaLongitudes));

					}

					// pw.println(linea);

					linea.setLength(0);
					for (int z = 0; z < listaCamposOrdenadaRdo.size(); z++) {

						linea.append(this.generaValor(listaCamposOrdenadaRdo.get(z), mapParametros, mapaRellenar,
								mapaLongitudes));

					}
					pwRdo.println(linea);

				}
			}

			// Buscamos los documentos de orden y certificaciones

			LinkedHashSet<String> withUniqueValueExpedientes = new LinkedHashSet<String>(listaExpedientes);

			listaExpedientes.clear();
			listaExpedientes.addAll(withUniqueValueExpedientes);

			for (int i = 0; i < listaExpedientes.size(); i++) {
				Arbdoctemp arbdoctempAux = new Arbdoctemp();
				arbdoctempAux.setX5excodigo(listaExpedientes.get(i));
				// con el sacodigo creamos un objeto nuevo y hacemos un find
				// para que nos devuevla la lista con todos los campos
				// todos van a tener los mismos campos comunes asiq nos quedamos
				// con el primero
				ArbPagoArbitroADO expediente = new ArbPagoArbitroADO();
				expediente.setSacodigo(listaExpedientes.get(i));
				expediente.setEstado("R");
				List<ArbPagoArbitroADO> listaBuscar = this.findAllLikeListaADO(expediente, null, false);
				List<Arbdoctemp> documentos = arbdoctempDao.findAllDocumentosPagos(arbdoctempAux, null);

				// INICIO 0197152: Pago de ADOs. Unificacin de orden de pago y
				// certificacin en un nico archivo
				List<InputStream> pdfsAUnificar = new ArrayList<InputStream>();
				for (int j = 0; j < documentos.size(); j++) {
					InputStream ficheroStream;
					// Esta en dokusi?
					if (Y41bUtils.esNullOCadenaVacia(documentos.get(j).getX5iddocumentum())) {
						// Si no esta en dokusi
						Blob contenido = documentos.get(j).getX5datafile();
						ficheroStream = (new SerialBlob(contenido.getBytes(1, (int) contenido.length())))
								.getBinaryStream();
					} else {
						// Si esta en dokusi
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentos.get(j).getX5iddocumentum());
						Documento docDokusi = this.y41bDokusiAdapterService.descargarDocumentoDokusi(documento);
						ficheroStream = (new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()))).getBinaryStream();
					}
					pdfsAUnificar.add(ficheroStream);
				}

				if (pdfsAUnificar != null && !pdfsAUnificar.isEmpty()) {
					String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
					String strZipDirectory = strTmpZipDirectory + nombre;
					Y41bFicheroUtils.crearDirectorio(strZipDirectory);

					String nombreFicheroPdfFusionado = strZipDirectory + File.separator
							+ this.solarbDao.find(new Solarb(listaExpedientes.get(i))).damecodCompleto() + ".pdf";
					OutputStream outputPdfFusionado = new FileOutputStream(nombreFicheroPdfFusionado);
					y41bReportMergeService.concatAcusePDFs(pdfsAUnificar, outputPdfFusionado, false);
					outputPdfFusionado.flush();
					outputPdfFusionado.close();
				}
				// FIN 0197152: Pago de ADOs. Unificacin de orden de pago y
				// certificacin en un nico archivo

				// tramitadores
				CensoMonitor tramitador = new CensoMonitor(listaBuscar.get(0).getTrmocodigoEj(), null);
				tramitador = this.censoMonitorDao.find(tramitador);
				if (tramitadores.indexOf(tramitador.getMocoem()) == -1) {
					tramitadores.append(";").append(tramitador.getMocoem());
				}

				// Para el pago pericial colegio, hay que actualizar la

				// Coger el importe del pago para grabarlo en ARBTRAMEXP y
				// tener
				// referencia de lo que se pago en su momento (OBIEE)
				String importe = null;
				if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO.equals(listaBuscar.get(0).getTrcodigo())) {
					importe = mapParametros.get("ADO_IMPORTE_PAGPERCOLEGIO") != null
							? mapParametros.get("ADO_IMPORTE_PAGPERCOLEGIO") : null;
				} else {
					importe = mapParametros.get("ADO_IMPORTE") != null ? mapParametros.get("ADO_IMPORTE") : null;
				}

			}

			// cerramos el flujo de los dos ficheros generados
			// if (null != fichero) {
			// fichero.close();
			// }

			if (null != ficheroRdo) {
				ficheroRdo.close();
			}

			String strZipFile = this.generarZipFicheroADONuevo(nombre.toString(), strAdoDirectory);

			// enviamos mail
			String from = "";

			if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
				throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, null);
			} else if (censoMonitor != null) {
				from = censoMonitor.getMocoem();
			}

			String destinatariosMail = mapParametros.get(Y41bADOConstantes.NAME_ADO_EMAIL);

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
			StringBuffer destinatarios = new StringBuffer("");
			destinatarios.append(destinatariosMail);
			destinatarios.append(tramitadores);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			StringBuffer asunto = new StringBuffer("");
			asunto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.asunto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			asunto.append(" \n");
			// Euskera
			asunto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.asunto", null,
					new Locale(Y41bConstantes.EUSKERA)));

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer("");
			texto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.texto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" \n");
			// Euskera
			texto.append(this.appMessageSource.getMessage("arbitraje.ficheroado.email.texto", null,
					new Locale(Y41bConstantes.EUSKERA)));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();
			AttachFile fileattach = new AttachFile();
			fileattach.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
			fileattach.setNombre(nombre.toString().concat(Y41bConstantes.EXTENSION_ZIP));

			fileattach.setAdjunto(Y41bUtils.convertTxtFiletoBlob(strZipFile));

			attachments.add(fileattach);

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), "", attachments);

			if (!envio) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
			return destinatarios.toString();

		} catch (Y41bUDAException e) {
			logger.error("Error producido en generandoFicheroADO: " + e.getMessage(), e);
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en generandoFicheroADO: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		} finally {
			// Nuevamente aprovechamos el finally para
			// asegurarnos que se cierra el fichero.
			// if (null != fichero) {
			// fichero.close();
			// }

			if (null != ficheroRdo) {
				ficheroRdo.close();
			}
			try {
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
	}

}
