package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ArbFicheroADO;
import com.ejie.y41b.model.ArbPagoArbitroADO;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolarbKgest;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.dokusi.Documento;

/**
 * SolarbService  
 * 
 *  
 */

public interface SolarbService {

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Map<String,Object>
	 * @throws Exception
	 *             excepcion
	 */
	Map<String, Object> add(Solarb solarb) throws Exception;

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param listDocumento
	 *            List<Documento>
	 * @return Map<String,Object>
	 * @throws Exception
	 *             excepcion
	 */
	Map<String, Object> addDesdeTelematica(Solarb solarb, List<Documento> listDocumento) throws Exception;

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb update(Solarb solarb);

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb find(Solarb solarb);

	/**
	 * Finds a List of rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Solarb> findAll(Solarb solarb, Pagination pagination);

	/**
	 * Counts rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Long
	 */
	Long findAllCount(Solarb solarb);

	/**
	 * Finds rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Solarb> findAllLike(Solarb solarb, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Solarb solarb, Boolean startsWith);

	/**
	 * Deletes a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return
	 */
	void remove(Solarb solarb);

	/**
	 * Deletes multiple rows in the Solarb table.
	 * 
	 * @param solarbList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Solarb> solarbList);

	/**
	 * 
	 * @param anio
	 *            int
	 * @param mes
	 *            int
	 * @param resp
	 *            String
	 * @return HashMap<String,Object>
	 * @throws Exception
	 *             e
	 */
	HashMap<String, Object> getDiasConAudiencia(int anio, int mes, String resp) throws Exception;

	/**
	 * Method 'getFichaExpedienteArbitraje'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	ModelAndView getFichaExpedienteArbitraje(Model model, String desde, String accesoPest2, String sacodigo,
			HttpServletRequest httpRequest);

	/**
	 * Method 'getFichaExpedienteArbitraje'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sinCabecera
	 *            boolean
	 * @param sacodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	ModelAndView getFichaExpedienteArbitraje(Model model, String desde, String accesoPest2, boolean sinCabecera,
			String sacodigo, HttpServletRequest httpRequest);

	/**
	 * 
	 * @param fecha
	 *            String
	 * @param lista
	 *            List<Solarb>
	 * @return ArrayList<HashMap<String, String>>
	 * @throws Exception
	 *             e
	 */
	ArrayList<HashMap<String, String>> getHorasDiaConAudiencia(String fecha, List<Solarb> lista) throws Exception;

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            the sacodigo
	 * @param relacionados
	 *            the relacionados
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FiltroArbitraje> findAllArbitrajesRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo,
			String relacionados, Pagination pagination);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroArbitraje> findAllLikeArbitrajes(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List
	 */
	Long findAllLikeCountArbitrajes(FiltroArbitraje filtroArbitraje, Boolean startsWith);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            the sacodigo
	 * @param relacionados
	 *            the relacionados
	 * @return Long
	 */
	Long findAllCountArbitrajesRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo, String relacionados);

	/**
	 * 
	 * @param anio
	 *            int
	 * @param mes
	 *            int
	 * @return HashMap<String,Object>
	 * @throws Exception
	 *             excepcion
	 */
	HashMap<String, Object> getDiasConPrueba(int anio, int mes) throws Exception;

	/**
	 * 
	 * @param fecha
	 *            String
	 * @param lista
	 *            List<Solarb>
	 * @return ArrayList<HashMap<String, String>>
	 * @throws Exception
	 *             excepcion
	 */
	ArrayList<HashMap<String, String>> getHorasDiaConPrueba(String fecha, List<Solarb> lista) throws Exception;

	/**
	 * findArbitrajeByNumeroExpediente
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb findArbitrajeByNumeroExpediente(Solarb solarb);

	/**
	 * findArbitrajeByRegistryNumber
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb findArbitrajeByRegistryNumber(Solarb solarb);

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param solarb
	 *            SolarbKgest
	 * @return SolarbKgest
	 */
	SolarbKgest findKgest(SolarbKgest solarb);

	// /**
	// * Actualiza el documento en BBDD despues de insertar el localizador.
	// *
	// * @param documentoX5
	// * Arbdoctemp
	// * @return Long
	// * @throws Exception
	// * Exception
	// */
	// Long actualizarDocumentoLocalizadorBBDD(Arbdoctemp documentoX5)
	// throws Exception;

	/**
	 * 
	 * @param dtcodigo
	 *            String
	 * @return Map<String, Object>
	 */
	Map<String, Object> numreclamacionesyarb(String dtcodigo);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             Exception
	 */
	void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor) throws Exception;

	/**
	 * actualizaExpediente
	 * 
	 * @param solarb
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Solarb
	 */
	Solarb actualizaExpediente(Solarb solarb, CensoMonitor censoMonitor);

	/**
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return List<ArbFicheroADO>
	 */
	List<ArbFicheroADO> findAllFicheroADO(ArbFicheroADO arbFicheroADO);

	/**
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return List<ArbFicheroADO>
	 */
	List<ArbFicheroADO> findAllFicheroADOPagoPericialColegio(ArbFicheroADO arbFicheroADO);

	/**
	 * generarFicheroADO
	 * 
	 * @param arbfichero
	 *            ArbFicheroADO
	 * @param mapParametros
	 *            Map<String, String>
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * @return String
	 * @throws Exception
	 *             excepcion
	 */
	public String generarFicheroADO(ArbFicheroADO arbfichero, Map<String, String> mapParametros,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param filtroArbitraje
	 *            the filtro arbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroArbitraje> findAllLikeArbitrajesBusquedaCombinada(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbexp table.
	 * 
	 * @param filtroArbitraje
	 *            the filtro sanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeArbitrajesBusquedaCombinadaCount(FiltroArbitraje filtroArbitraje, Boolean startsWith);

	/**
	 * volcarDocumentosReclamacionPrevia
	 * 
	 * @param hdcodigo
	 *            String
	 * @param idTramiteApertura
	 *            String
	 */
	void volcarDocumentosReclamacionPrevia(String hdcodigo, String idTramiteApertura);

	/**
	 * envioMailEstablecimiento
	 * 
	 * @param from
	 *            String
	 * @param establecimiento
	 *            Establecimiento
	 * @return String
	 */
	String envioMailEstablecimiento(String from, Establecimiento establecimiento);

	/**
	 * envioMailEstablecimientoIconoWeb
	 * 
	 * @param from
	 *            String
	 * @param establecimiento
	 *            Establecimiento
	 * @return String
	 */
	String envioMailEstablecimientoIconoWeb(String from, Establecimiento establecimiento);

	/**
	 * 
	 * findAllLikeListaADO
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * 
	 * @param pagination
	 *            Pagination
	 * 
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	List<ArbPagoArbitroADO> findAllLikeListaADO(ArbPagoArbitroADO filterListado, Pagination pagination, Boolean b);

	/**
	 * 
	 * findAllLikeListaADOCount
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeListaADOCount(ArbPagoArbitroADO filterListado, Boolean b);

	/**
	 * Method 'enviarEika'.
	 *
	 * @param listadoPagosArbitros
	 *            ArrayList
	 * @return
	 */
	void enviarEika(List<ArbPagoArbitroADO> listaPagos, Map<String, String> mapParametros, CensoMonitor censoMonitor);

	void validarArbitrostercero(List<Arbitro> listaArbitros);

}
