package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SedeDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;

import com.ejie.y41b.model.*;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SedeServiceImpl  
 * 
 *  
 */

@Service(value = "sedeService")
public class SedeServiceImpl implements SedeService {

	@Autowired
	private SedeDao sedeDao;

	@Autowired
	private T17CalleDao t17CalleDao;

	@Autowired
	private T17PortalDao t17PortalDao;

	@Autowired
	private T17LocalidadDao t17LocalidadDao;

	@Autowired
	private T17MunicipioDao t17MunicipioDao;

	@Autowired
	private T17ProvinciaDao t17ProvinciaDao;

	/**
	 * Inserts a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sede add(Sede sede) {
		return this.sedeDao.add(sede);
	}

	/**
	 * Updates a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sede update(Sede sede) {
		return this.sedeDao.update(sede);
	}

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	public Sede find(Sede sede) {

		sede = (Sede) this.sedeDao.find(sede);
		sede.setDireccionCompleta(dameDireccionCompleta(sede));

		return sede;
	}

	/**
	 * Finds a List of rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sede> findAll(Sede sede, Pagination pagination) {
		return (List<Sede>) this.sedeDao.findAll(sede, pagination);
	}

	/**
	 * Counts rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Long
	 */
	public Long findAllCount(Sede sede) {
		return this.sedeDao.findAllCount(sede);
	}

	/**
	 * Finds rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sede> findAllLike(Sede sede, Pagination pagination,
			Boolean startsWith) {
		return (List<Sede>) this.sedeDao.findAllLike(sede, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sede sede, Boolean startsWith) {
		return this.sedeDao.findAllLikeCount(sede, startsWith);
	}

	/**
	 * Deletes a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sede sede) {
		this.sedeDao.remove(sede);
	}

	/**
	 * Deletes multiple rows in the Sede table.
	 * 
	 * @param sedeList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sede> sedeList) {
		for (Sede sedeAux : sedeList) {
			this.sedeDao.remove(sedeAux);
		}
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	private String dameDireccionCompleta(Sede sede) {
		StringBuffer direccion = new StringBuffer("");

		direccion.append(dameLineaDireccion(sede));
		/* localidad */

		if ((sede.getNoraLocalidadId() != null)
				&& (sede.getNoraMunicipioId() != null)
				&& (sede.getNoraProvinciaId() != null)) {
			direccion.append(dameLocalidad(sede));
		}

		if ((sede.getNoraMunicipioId() != null)
				&& (sede.getNoraProvinciaId() != null)) {
			direccion.append(dameMunicipio(sede));
		}

		if (sede.getNoraProvinciaId() != null) {
			direccion.append(dameProvincia(sede));
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameLineaDireccion(Sede sede) {
		StringBuffer direccion = new StringBuffer("");

		if (!Y41bUtils.esNullOCadenaVacia(sede.getDireccionNocapv())) {
			direccion.append(sede.getDireccionNocapv());
		} else if (!Y41bUtils.esNullOCadenaVacia(sede.getNoraCalleId())) {
			String calle = "";
			T17Calle t17calle = new T17Calle(Long.parseLong(sede
					.getNoraCalleId()), null);
			try {
				t17calle = this.t17CalleDao.findCalleConTipoVia(t17calle);
				calle = t17calle.getDsO();
			} catch (Exception e) {

			}

			if (sede.getNoraPortalId() != null
					&& !"".equals(sede.getNoraPortalId())) {
				T17Portal t17portal = new T17Portal();
				t17portal.setId(Long.parseLong(sede.getNoraPortalId()));
				t17portal.setCalleId(Long.parseLong(sede.getNoraCalleId()));
				List<T17Portal> list = this.t17PortalDao.findAll(t17portal,
						null);
				if (list != null && list.size() > 0) {
					t17portal = list.get(0);
				}
				if (t17portal != null && t17portal.getPortal() != null) {
					direccion.append(" ").append(
							Y41bUtils.componerDireccion(calle,
									t17portal.getBloque(),
									t17portal.getPortal(),
									t17portal.getNumero(), t17portal.getBis(),
									sede.getNombrePiso(), ""));
				} else if (t17portal != null && t17portal.getNumero() != 0) {
					direccion.append(calle);
					direccion.append(" ");
					direccion.append(t17portal.getNumero());
					if (!Y41bUtils.esNullOCadenaVacia(sede.getNombrePiso())) {
						direccion.append(" ").append(sede.getNombrePiso());
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(sede.getNombrePiso())) {
						direccion.append(" ").append(sede.getNombrePiso());
					}
				}
			} else {
				if (calle != null && calle.length() > 0) {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(sede.getNombrePiso())) {
						direccion.append(" ").append(sede.getNombrePiso());
					}
				}
			}
		}

		return (direccion.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameCodigoPostal(Sede sede) {
		StringBuffer cp = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (sede.getNoraPortalId() != null
				&& !"".equals(sede.getNoraPortalId())) {
			t17portal.setId(Long.parseLong(sede.getNoraPortalId()));
			List<T17Portal> lt17portal = this.t17PortalDao.findAll(t17portal,
					null);

			if (lt17portal != null && lt17portal.size() > 0) {
				return lt17portal.get(0).getCodigoPostal();
			}

		}

		return (cp.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameLocalidad(Sede sede) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";

		/* localidad */
		if ((sede.getNoraLocalidadId() != null)
				&& (sede.getNoraMunicipioId() != null)
				&& (sede.getNoraProvinciaId() != null)) {
			T17Localidad localidadT17 = new T17Localidad(
					sede.getNoraLocalidadId(), null, sede.getNoraMunicipioId(),
					sede.getNoraProvinciaId(), null);

			localidadT17 = this.t17LocalidadDao.find(localidadT17);
			if (localidadT17 != null) {
				localidad = localidadT17.getDsO();
				direccion.append(" ");
				direccion.append(localidad);
			}
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameMunicipio(Sede sede) {
		StringBuffer direccion = new StringBuffer("");

		String municipio = "";

		/* localidad */

		if ((sede.getNoraMunicipioId() != null)
				&& (sede.getNoraProvinciaId() != null)) {
			municipio = (this.t17MunicipioDao.find(new T17Municipio(sede
					.getNoraMunicipioId(), sede.getNoraProvinciaId(), null,
					null)).getDsO());
			direccion.append(" ");
			direccion.append(municipio);
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameProvincia(Sede sede) {
		StringBuffer direccion = new StringBuffer("");

		String provincia = "";
		/* localidad */
		if (sede.getNoraProvinciaId() != null) {
			provincia = (this.t17ProvinciaDao.find(new T17Provincia(sede
					.getNoraProvinciaId(), null, null)).getDsO());
			direccion.append(" ");
			direccion.append(provincia);

		}
		return (direccion.toString());
	}
}
