package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.*;

/**
 * SedeService  
 * 
 *  
 */

public interface SedeService {

	/**
	 * Inserts a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede add(Sede sede);

	/**
	 * Updates a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede update(Sede sede);

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede find(Sede sede);

	/**
	 * Finds a List of rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sede> findAll(Sede sede, Pagination pagination);

	/**
	 * Counts rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Long
	 */
	Long findAllCount(Sede sede);

	/**
	 * Finds rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sede> findAllLike(Sede sede, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sede sede, Boolean startsWith);

	/**
	 * Deletes a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return
	 */
	void remove(Sede sede);

	/**
	 * Deletes multiple rows in the Sede table.
	 * 
	 * @param sedeList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Sede> sedeList);

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameLineaDireccion(Sede sede);

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameCodigoPostal(Sede sede);

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameLocalidad(Sede sede);

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameMunicipio(Sede sede);

	/**
	 * Dame direccion completa.
	 * 
	 * @param sede
	 *            the sede
	 * @return the string
	 */
	public String dameProvincia(Sede sede);
}
