package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SectorDao;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * SectorServiceImpl  
 * 
 *  
 */

@Service(value = "sectorService")
public class SectorServiceImpl implements SectorService {

	private static final Logger logger = LoggerFactory
			.getLogger(SectorServiceImpl.class);
	@Autowired
	private SectorDao sectorDao;

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector add(Sector sector) {
		return this.sectorDao.add(sector);
	}

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector addSector(Sector sector) {
		try {
			sector.setSecodigo(sector.getSecodigo().toUpperCase());
			this.sectorDao.add(sector);

			String idsDescriptores = sector.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}

			sector.setDescriptores(descriptores);

			this.sectorDao.addSectorDescriptor(sector);

			if (sector.getSecodigo().length() > 1) {
				if (sector.getSecodigo().length() == 2) {
					throw new Y41bUDAException("error.sector.NoPadreException",
							true, new Exception());
				}

				String secodigoPadre = null;

				if (sector.getSecodigo().length() == 3) {
					secodigoPadre = sector.getSecodigo().substring(0,
							sector.getSecodigo().length() - 2);
				} else {
					secodigoPadre = sector.getSecodigo().substring(0,
							sector.getSecodigo().length() - 1);
				}

				Sector sectorAux = new Sector();
				sectorAux.setSecodigo(secodigoPadre);

				Long numSector = this.sectorDao.findAllCount(sectorAux);

				if (numSector == 0) {
					throw new Y41bUDAException("error.sector.NoPadreException",
							true, new Exception());
				}
			}

			return sector;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.sector.DuplicateKeyException",
					true, e);
		}
	}

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector update(Sector sector) {
		return this.sectorDao.update(sector);
	}

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector updateSector(Sector sector) {
		this.sectorDao.update(sector);

		String idsDescriptores = sector.getIdsDescriptores();

		List<Descriptor> descriptores = new ArrayList<Descriptor>();

		// Generar el listado listado de etiquetas (comun)
		if (null != idsDescriptores && !"".equals(idsDescriptores)) {
			Descriptor descriptor = null;
			for (String id : idsDescriptores.split(",")) {
				descriptor = new Descriptor();
				descriptor.setIdDescriptor(id);
				descriptores.add(descriptor);
			}
		}

		sector.setDescriptores(descriptores);

		// Descriptores
		this.sectorDao.removeAllSectorDescriptor(sector);
		this.sectorDao.addSectorDescriptor(sector);

		return sector;
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector find(Sector sector) {
		return (Sector) this.sectorDao.find(sector);
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector findSector(Sector sector) {
		sector = this.sectorDao.find(sector);

		List<Descriptor> listDescriptor = this.sectorDao
				.findAllSectorDescriptor(sector, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(
						descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		sector.setIdsDescriptores(strIdsDescriptores.toString());
		sector.setDescsDescriptores(strDescsDescriptores.toString());

		return sector;
	}

	/**
	 * Finds a List of rows in the SectorDescriptor table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllSectorDescriptor(Sector sector,
			Pagination pagination) {
		return (List<Descriptor>) this.sectorDao.findAllSectorDescriptor(
				sector, pagination);
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector findSectorSeleccionable(Sector sector) {
		return (Sector) this.sectorDao.findSectorSeleccionable(sector);
	}

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sector> findAll(Sector sector, Pagination pagination) {
		return (List<Sector>) this.sectorDao.findAll(sector, pagination);
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Long
	 */
	public Long findAllCount(Sector sector) {
		return this.sectorDao.findAllCount(sector);
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith) {
		return (List<Sector>) this.sectorDao.findAllLike(sector, pagination,
				startsWith);
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith) {
		return (List<Sector>) this.sectorDao.findAllLikeSector(sector,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSectorCount(Sector sector, Boolean startsWith) {
		return this.sectorDao.findAllLikeSectorCount(sector, startsWith);
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLikeSectorSeleccion(Sector sector,
			Pagination pagination, Boolean startsWith) {
		return (List<Sector>) this.sectorDao.findAllLikeSectorSeleccion(sector,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSectorSeleccionCount(Sector sector,
			Boolean startsWith) {
		return this.sectorDao.findAllLikeSectorSeleccionCount(sector,
				startsWith);
	}

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sector sector) {
		this.sectorDao.remove(sector);
	}

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSector(Sector sector) {

		try {
			// Descriptores
			this.sectorDao.removeAllSectorDescriptor(sector);

			this.sectorDao.remove(sector);

			Sector sectorAux = new Sector();
			sectorAux.setSecodigo(sector.getSecodigo());

			Long numSector = this.sectorDao.findAllLikeSectorCount(sectorAux,
					true);

			if (numSector > 0) {
				throw new Y41bUDAException("error.sector.TieneHijosException",
						true, new Exception());
			}

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.sector.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Sector table.
	 * 
	 * @param sectorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Sector> sectorList) {
		for (Sector sectorAux : sectorList) {
			this.sectorDao.remove(sectorAux);
		}
	}

	/**
	 * Getter method for SectorDao
	 * 
	 * @return SectorDao
	 */
	public SectorDao getSectorDao() {
		return this.sectorDao;
	}

	/**
	 * Setter method for SectorDao.
	 * 
	 * @param sectorDao
	 *            SectorDao
	 * @return
	 */
	public void setSectorDao(SectorDao sectorDao) {
		logger.info("Setting Dependency " + sectorDao);
		this.sectorDao = sectorDao;
	}
}
