package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SectorAgrupadoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.SectorAgrupado;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SectorAgrupadoServiceImpl  
 * 
 *  
 */

@Service(value = "sectorAgrupadoService")
public class SectorAgrupadoServiceImpl implements SectorAgrupadoService {

	@Autowired
	private SectorAgrupadoDao sectorAgrupadoDao;

	/**
	 * Inserts a single row in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return SectorAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SectorAgrupado add(SectorAgrupado sectorAgrupado) {
		try {
			return this.sectorAgrupadoDao.add(sectorAgrupado);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.sectoragrupado.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return SectorAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SectorAgrupado update(SectorAgrupado sectorAgrupado) {
		return this.sectorAgrupadoDao.update(sectorAgrupado);
	}

	/**
	 * Finds a single row in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return SectorAgrupado
	 */
	public SectorAgrupado find(SectorAgrupado sectorAgrupado) {
		return (SectorAgrupado) this.sectorAgrupadoDao.find(sectorAgrupado);
	}

	/**
	 * Finds a List of rows in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SectorAgrupado> findAll(SectorAgrupado sectorAgrupado,
			Pagination pagination) {
		return (List<SectorAgrupado>) this.sectorAgrupadoDao.findAll(
				sectorAgrupado, pagination);
	}

	/**
	 * Counts rows in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return Long
	 */
	public Long findAllCount(SectorAgrupado sectorAgrupado) {
		return this.sectorAgrupadoDao.findAllCount(sectorAgrupado);
	}

	/**
	 * Finds rows in the SectorAgrupado table using like.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SectorAgrupado> findAllLike(SectorAgrupado sectorAgrupado,
			Pagination pagination, Boolean startsWith) {
		return (List<SectorAgrupado>) this.sectorAgrupadoDao.findAllLike(
				sectorAgrupado, pagination, startsWith);
	}

	/**
	 * Counts rows in the SectorAgrupado table using like.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(SectorAgrupado sectorAgrupado,
			Boolean startsWith) {
		return this.sectorAgrupadoDao.findAllLikeCount(sectorAgrupado,
				startsWith);
	}

	/**
	 * Deletes a single row in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupado
	 *            SectorAgrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(SectorAgrupado sectorAgrupado) {
		try {
			this.sectorAgrupadoDao.remove(sectorAgrupado);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.sectoragrupado.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the SectorAgrupado table.
	 * 
	 * @param sectorAgrupadoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<SectorAgrupado> sectorAgrupadoList) {
		for (SectorAgrupado sectorAgrupadoAux : sectorAgrupadoList) {
			this.sectorAgrupadoDao.remove(sectorAgrupadoAux);
		}
	}

}
