package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.LocalidaDao;
import com.ejie.y41b.dao.MunicipiDao;
import com.ejie.y41b.dao.SecretarDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Localida;
import com.ejie.y41b.model.Municipi;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SecretarServiceImpl  
 * 
 *  
 */

@Service(value = "secretarService")
public class SecretarServiceImpl implements SecretarService {

	@Autowired
	private SecretarDao secretarDao;
	@Autowired()
	private LocalidaDao localidaDao;
	@Autowired()
	private MunicipiDao municipiDao;
	@Autowired()
	private T17ProvinciaDao provinciaDao;

	/**
	 * Inserts a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Secretar add(Secretar secretar) {
		return this.secretarDao.add(secretar);
	}

	/**
	 * Updates a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Secretar update(Secretar secretar) {
		return this.secretarDao.update(secretar);
	}

	/**
	 * Finds a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	public Secretar find(Secretar secretar) {
		Secretar secretarDetalle = this.secretarDao.find(secretar);
		secretarDetalle.setSrdireccionNoCAPV(this
				.componerDireccionNoCAPV(secretarDetalle));
		return secretarDetalle;
	}

	/**
	 * Finds a List of rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Secretar> findAll(Secretar secretar, Pagination pagination) {
		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("srThActs")) {
			pagination.setSort("TA1NOMBRE");
		}
		return (List<Secretar>) this.secretarDao.findAll(secretar, pagination);
	}

	/**
	 * Counts rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Long
	 */
	public Long findAllCount(Secretar secretar) {
		return this.secretarDao.findAllCount(secretar);
	}

	/**
	 * Finds rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Secretar> findAllLike(Secretar secretar, Pagination pagination,
			Boolean startsWith) {
		return (List<Secretar>) this.secretarDao.findAllLike(secretar,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Secretar secretar, Boolean startsWith) {
		return this.secretarDao.findAllLikeCount(secretar, startsWith);
	}

	/**
	 * Deletes a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Secretar secretar) {
		this.secretarDao.remove(secretar);
	}

	/**
	 * Deletes multiple rows in the Secretar table.
	 * 
	 * @param secretarList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Secretar> secretarList) {
		for (Secretar secretarAux : secretarList) {
			this.secretarDao.remove(secretarAux);
		}
	}

	/**
	 * 
	 * @param secretar
	 *            Arbitro
	 * @return String
	 */
	private String componerDireccionNoCAPV(Secretar secretar) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			if (Y41bUtils.esNullOCadenaVacia(secretar.getSrprovId())) {
				if (secretar.getSrnodir() != null) {
					ardireccionNoCAPV.append(secretar.getSrnodir());
				}
				if (!Y41bUtils.esNullOCadenaVacia(secretar.getSrcolo())) {
					Localida localida = new Localida();
					localida.setLocodigo(secretar.getSrcolo());
					localida = this.localidaDao.find(localida);
					if (localida != null) {
						ardireccionNoCAPV.append(" ").append(
								localida.getLonombre());
						if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
							Municipi municipi = new Municipi();
							municipi.setMucodigo(localida.getLocomu());
							municipi = this.municipiDao.find(municipi);
							if (municipi != null) {
								ardireccionNoCAPV.append(" ").append(
										municipi.getMunombre());
							}
						}
						if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
							T17Provincia provincia = new T17Provincia();
							provincia.setId(localida.getLocopv());
							provincia = this.provinciaDao.find(provincia);
							if (provincia != null) {
								ardireccionNoCAPV.append(" ").append(
										provincia.getDsO());
							}
						}
					}
				}
			} else {
				if (!Y41bConstantes.ARABA.equals(secretar.getSrprovId())
						&& !Y41bConstantes.BIZKAIA.equals(secretar
								.getSrprovId())
						&& !Y41bConstantes.GIPUZKOA.equals(secretar
								.getSrprovId())) {
					if (secretar.getSrnodir() != null) {
						ardireccionNoCAPV.append(secretar.getSrnodir());
					}
				}
			}
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}

}
