package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Secretar;

/**
 * SecretarService  
 * 
 *  
 */

public interface SecretarService {

	/**
	 * Inserts a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	Secretar add(Secretar secretar);

	/**
	 * Updates a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	Secretar update(Secretar secretar);

	/**
	 * Finds a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Secretar
	 */
	Secretar find(Secretar secretar);

	/**
	 * Finds a List of rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Secretar> findAll(Secretar secretar, Pagination pagination);

	/**
	 * Counts rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Long
	 */
	Long findAllCount(Secretar secretar);

	/**
	 * Finds rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Secretar> findAllLike(Secretar secretar, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Secretar secretar, Boolean startsWith);

	/**
	 * Deletes a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return
	 */
	void remove(Secretar secretar);

	/**
	 * Deletes multiple rows in the Secretar table.
	 * 
	 * @param secretarList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Secretar> secretarList);

}
