// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.jdt.internal.compiler.ast.IfStatement;
import com.bea.jvm.ThreadSnapshot.Monitor;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterServiceImpl;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.adapter.services.Y41bPlateaServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HistoricofasesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PagosDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.PosibleTramiteDao;
import com.ejie.y41b.dao.RecursoDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.SanbandejaDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanenvioDao;
import com.ejie.y41b.dao.SanexpDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SanrecrcaDao;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.Recurso;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanenvio;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sanrecrca;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.TramiteSANAcuerdoIncoacion;
import com.ejie.y41b.model.TramiteSANAmpliacionPlazoAlegaciones;
import com.ejie.y41b.model.TramiteSANApertura;
import com.ejie.y41b.model.TramiteSANElaboracionInformeAsesoria;
import com.ejie.y41b.model.TramiteSANLiquidacion;
import com.ejie.y41b.model.TramiteSANPago;
import com.ejie.y41b.model.TramiteSANPropuestaResolucion;
import com.ejie.y41b.model.TramiteSANRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteSANRecepcionRecursoAlzada;
import com.ejie.y41b.model.TramiteSANRecepcionRecursoExtraordinario;
import com.ejie.y41b.model.TramiteSANRecepcionSolicitudReduccion;
import com.ejie.y41b.model.TramiteSANResolucion;
import com.ejie.y41b.model.TramiteSANResolucionComplementaria;
import com.ejie.y41b.model.TramiteSANResolucionRecursoPrueba;
import com.ejie.y41b.model.TramiteSANResolucionSolicitudPrueba;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

/**
 * SantramexpServiceImpl  
 * 
 *  
 */

@Service(value = "santramexpService")
public class SantramexpServiceImpl implements SantramexpService {

	private static final Logger logger = LoggerFactory.getLogger(SantramexpServiceImpl.class);

	@Autowired()
	private SantramexpDao santramexpDao;

	@Autowired()
	private ExpedienDao expedienDao;

	@Autowired()
	private SanexpDao sanexpDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private SanbandejaDao sanBandejaDao;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private SantipdocDao santipdocDao;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private SandoctempDao sandoctempDao;

	@Autowired()
	private SanenvioDao sanenvioDao;

	@Autowired()
	private TramiteDao tramiteDao;

	@Autowired()
	private RecursoDao recursoDao;

	@Autowired()
	private PosibleTramiteDao posibleTramiteDao;

	@Autowired()
	private SanbandejaDao sanbandejaDao;

	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private PagosDao pagosDao;

	@Autowired()
	private HistoricofasesDao historicoFasesDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;
	@Autowired()
	private RemesaDao remesaDao;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private SanrecrcaDao sanrecrcaDao;
	@Autowired()
	private DecisionDao decisionDao;

	@Autowired
	private ExpedienService expedienService;
	@Autowired
	private SandoctempService sandoctempService;
	@Autowired
	private SoltramexpService soltramexpService;
	@Autowired
	private ArbtipdocDao arbtipdocDao;
	@Autowired
	private AdjuntardocsService adjuntardocsService;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private SanintervService sanintervService;
	@Autowired
	private SanexpService sanexpService;
	@Autowired
	private DenunciaService denunciaService;
	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp add(Santramexp santramexp) {
		return this.santramexpDao.add(santramexp);
	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp update(Santramexp santramexp) {
		return this.santramexpDao.update(santramexp);
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp find(Santramexp santramexp) {
		return (Santramexp) this.santramexpDao.find(santramexp);
	}

	/**
	 * Finds a List of rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Santramexp> findAll(Santramexp santramexp, Pagination pagination) {
		if (pagination != null) {
			if ("trestado".equals(pagination.getSort())) {
				pagination.setSort("TRESTADO");
			} else if ("censoMonitorEj.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("trfecfin".equals(pagination.getSort())) {
				pagination.setSort("TRFECFIN");
			} else if ("trfecini".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trcodigo".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FNOMBREE");
			} else if ("trid".equals(pagination.getSort())) {
				pagination.setSort("TRID");
			}
		}

		List<Santramexp> listTramiteHechoDetalle = (List<Santramexp>) this.santramexpDao.findAll(santramexp,
				pagination);
		if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {

			Saninterv saninterv = new Saninterv();
			// Expedien expedien = santramexp.getExpedien();
			// expedien = this.expedienDao.find(expedien);
			saninterv.setExpedien(santramexp.getExpedien());
			List<Saninterv> listSaninterv = (List<Saninterv>) this.sanintervDao.findAll(saninterv, null);

			Date fechaEmisionApremio = null;
			List<Pagos> lpagosApremio = this.obtenerPagosViaApremioExpediente(santramexp.getExpedien().getExcodigo());
			// Si encontramos un trmite de pago posterior a la liquidacin en
			// apremio
			// el tramite de pago ser en pagado apremio
			for (int i = 0; i < lpagosApremio.size(); i++) {
				Pagos pagos = lpagosApremio.get(i);
				if (Y41bConstantes.ESTADO_PAGO_PAGADO.equals(pagos.getEstadopago().getSacodigo())
						|| Y41bConstantes.ESTADO_PAGO_PAGADO_DEFINITIVO.equals(pagos.getEstadopago().getSacodigo())
						|| Y41bConstantes.ESTADO_PAGO_PAGADO_APREMIO.equals(pagos.getEstadopago().getSacodigo())) {
					fechaEmisionApremio = pagos.getSgfechaemision();
				}
			}

			TramiteComun tramiteComun = new TramiteComun();
			for (Santramexp tramiteHechoDetalleAux : listTramiteHechoDetalle) {
				// buscar los documentos del tramite
				tramiteComun.setIdTramite(tramiteHechoDetalleAux.getTrid().toString());
				tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_SANCIONES));
				List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					tramiteHechoDetalleAux.setIndVariosDocumentos(Y41bConstantes.NO);

					tramiteHechoDetalleAux.setU5codocumento(listDocumentoHecho.get(0).getU5codocumento());
					tramiteHechoDetalleAux.setU5nofile(listDocumentoHecho.get(0).getU5nofile());
					tramiteHechoDetalleAux.setU5sizefile(listDocumentoHecho.get(0).getU5sizefile());
					tramiteHechoDetalleAux.setU5contenttypefile(listDocumentoHecho.get(0).getU5conttype());
					tramiteHechoDetalleAux.setU5tedesfile(listDocumentoHecho.get(0).getU5tedesfile());
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						tramiteHechoDetalleAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}

				/* esta pendiente de localizador */
				int minutos = 0;
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				if (listDocumentoHecho != null) {
					boolean error = false;
					boolean sinLocalizarPorTiempo = false;
					boolean localizado = false;
					boolean firmado = false;
					String origenDestino = "";
					for (Sandoctemp sandoctemp : listDocumentoHecho) {
						// Para el origen de la aportacion
						if (Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION
								.equals(tramiteHechoDetalleAux.getTrcodigo())) {
							if (!Y41bUtils.esNullOCadenaVacia(sandoctemp.getU5origen())
									&& (Y41bUtils.esNullOCadenaVacia(origenDestino)
											|| sandoctemp.getU5origen().equals(origenDestino))) {
								origenDestino = sandoctemp.getU5origen();
							} else {
								origenDestino = Y41bConstantes.VALOR_NO;
							}
						}
						if (sandoctemp.getU5fechasollocalizador() != null
								&& !tramiteHechoDetalleAux.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramiteHechoDetalleAux.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramiteHechoDetalleAux.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
							if (sandoctemp != null && sandoctemp.getU5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
									.getExtensionFile(sandoctemp.getU5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(sandoctemp.getU5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}
								if (diffMinutes > minutos) {
									error = true;
								} else {
									sinLocalizarPorTiempo = true;
								}

							} else {
								if (tramiteHechoDetalleAux.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									firmado = true;
								} else if (!tramiteHechoDetalleAux.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
										&& !tramiteHechoDetalleAux.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
										&& !tramiteHechoDetalleAux.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
										&& !tramiteHechoDetalleAux.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
										&& !tramiteHechoDetalleAux.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
									localizado = true;
								}
							}
						}

					}
					if (error) {
						tramiteHechoDetalleAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
					} else if (sinLocalizarPorTiempo) {
						tramiteHechoDetalleAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
					} else if (firmado) {
						tramiteHechoDetalleAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else if (localizado) {
						tramiteHechoDetalleAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
					}
					tramiteHechoDetalleAux.setNombreDestOrigen("");
					if (Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION
							.equals(tramiteHechoDetalleAux.getTrcodigo())
							|| Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
									.equals(tramiteHechoDetalleAux.getTrcodigo())
							|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION
									.equals(tramiteHechoDetalleAux.getTrcodigo())) {
						tramiteHechoDetalleAux.setTipoDestOrigen(origenDestino);
						if (listSaninterv != null) {
							for (Saninterv sanintervAux : listSaninterv) {
								if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO.equals(origenDestino)
										&& sanintervAux.getUatipointerv()
												.equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
										|| (Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO
												.equals(origenDestino)
												&& (sanintervAux.getUatipointerv()
														.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
														|| sanintervAux.getUatipointerv()
																.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR)
														|| sanintervAux.getUatipointerv().equals(
																Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO)))) {
									tramiteHechoDetalleAux.setNombreDestOrigen(sanintervAux.getUanombre() == null ? ""
											: sanintervAux.getUanombre().concat(" ")
													.concat(sanintervAux.getUaapellido1() == null ? ""
															: sanintervAux.getUaapellido1())
													.concat(" ").concat(sanintervAux.getUaapellido2() == null ? ""
															: sanintervAux.getUaapellido2()));
								}
							}
						}
					}

				}

				// Para los tramites de Pub BOPVBOE
				if (tramiteHechoDetalleAux.getTrfechaEnvioBOPVBOE() != null) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalleAux.getTramite().getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getTrfechaEnvioBOPVBOE(),
							Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalleAux.getTramite().getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getTrfechaEnvioBOPVBOE(),
							Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					tramiteHechoDetalleAux.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalleAux.getTramite().setTrnombree(sbTrnombree.toString());
				}
				// Para comunicaciones/notificaciones
				if (Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(tramiteHechoDetalleAux.getTrcodigo())
						|| Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(tramiteHechoDetalleAux.getTrcodigo())) {
					if (tramiteHechoDetalleAux.getTruaidinterv() != null && listSaninterv != null) {
						for (Saninterv sanintervAux : listSaninterv) {
							Expedien expedien = santramexp.getExpedien();
							expedien = this.expedienDao.find(expedien);
							sanintervAux.setExpedien(expedien);
							if (sanintervAux.getUaidinterv().equals(tramiteHechoDetalleAux.getTruaidinterv())) {
								if ("R".equals(sanintervAux.getExpedien().getSanexp().getExdestnotifsancionado())) {
									if (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO
											.equals(sanintervAux.getUatipointerv())
											&& Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION
													.equals(tramiteHechoDetalleAux.getTrestado())) {
										List<Saninterv> lsanintervaux = this.sanintervDao.findAllByTipo(expedien,
												Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
										if (lsanintervaux != null && lsanintervaux.size() > 0) {
											sanintervAux = lsanintervaux.get(0);
										} else {
											sanintervAux = this.sanintervDao.findAllByTipo(expedien,
													Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO).get(0);
										}
									}
								} else {
									if (Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
											.equals(sanintervAux.getUatipointerv())
											&& Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION
													.equals(tramiteHechoDetalleAux.getTrestado())) {
										sanintervAux = this.sanintervDao
												.findAllByTipo(expedien, Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
												.get(0);
									}
								}
								tramiteHechoDetalleAux.setTipoDestOrigen(sanintervAux.getUatipointerv());
								tramiteHechoDetalleAux.setNombreDestOrigen(sanintervAux.getUanombre() == null ? ""
										: sanintervAux.getUanombre().concat(" ")
												.concat(sanintervAux.getUaapellido1() == null ? ""
														: sanintervAux.getUaapellido1())
												.concat(" ").concat(sanintervAux.getUaapellido2() == null ? ""
														: sanintervAux.getUaapellido2()));
							}
						}
					}
				}
				// Para los pagos
				if (Y41bConstantes.TRAMITE_SANCIONES_PAGO.equals(tramiteHechoDetalleAux.getTrcodigo())) {
					if (tramiteHechoDetalleAux.getTrresofecha() != null && fechaEmisionApremio != null
							&& tramiteHechoDetalleAux.getTrresofecha().compareTo(fechaEmisionApremio) >= 0) {
						tramiteHechoDetalleAux.getTramite().setTrnombre(this.appMessageSource
								.getMessage("sanciones.pagoEnApremio", null, new Locale(Y41bConstantes.CASTELLANO)));
						tramiteHechoDetalleAux.getTramite().setTrnombree(this.appMessageSource
								.getMessage("sanciones.pagoEnApremio", null, new Locale(Y41bConstantes.CASTELLANO)));

					}
				}

				if (tramiteHechoDetalleAux.getTristelematica() != null) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalleAux.getTramite().getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(appMessageSource.getMessage("comun.telematico", null,
							new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalleAux.getTramite().getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(")");

					tramiteHechoDetalleAux.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalleAux.getTramite().setTrnombree(sbTrnombree.toString());
				}

				if (Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION
						.equals(tramiteHechoDetalleAux.getTrcodigo())
						&& Y41bConstantes.VALOR_SI.equals(tramiteHechoDetalleAux.getTrIsSir())
						&& (tramiteHechoDetalleAux.getTrIsSirConNumRegEntOri() == null || Y41bConstantes.VALOR_SI
								.equals(tramiteHechoDetalleAux.getTrIsSirConNumRegEntOri()))) {
					StringBuilder sbTrnombre = new StringBuilder();
					sbTrnombre.append(tramiteHechoDetalleAux.getTramite().getTrnombre());
					sbTrnombre.append(" (");
					// sbTrnombre.append(appMessageSource.getMessage("comun.telematico",
					// null,
					// new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(
							this.appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuilder sbTrnombree = new StringBuilder();
					sbTrnombree.append(tramiteHechoDetalleAux.getTramite().getTrnombree());
					sbTrnombree.append(" (");
					// sbTrnombree.append(
					// appMessageSource.getMessage("comun.telematico", null, new
					// Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(
							this.appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.EUSKERA)));

					sbTrnombree.append(")");

					tramiteHechoDetalleAux.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalleAux.getTramite().setTrnombree(sbTrnombree.toString());
				}
			}
		}

		return listTramiteHechoDetalle;
	}

	/**
	 * Counts rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Long
	 */
	public Long findAllCount(Santramexp santramexp) {
		return this.santramexpDao.findAllCount(santramexp);
	}

	/**
	 * Finds rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Santramexp> findAllLike(Santramexp santramexp, Pagination pagination, Boolean startsWith) {
		return this.santramexpDao.findAllLike(santramexp, pagination, startsWith);
	}

	/**
	 * Counts rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santramexp santramexp, Boolean startsWith) {
		return this.santramexpDao.findAllLikeCount(santramexp, startsWith);
	}

	/**
	 * Deletes a single row in the Santramexp table.
	 * 
	 * @param santramexpAux
	 *            Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santramexp santramexpAux) {
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl.remove Inicio:" + santramexpAux.getTrid() + ".");

		Santramexp santramexp = this.santramexpDao.find(santramexpAux);

		// APERTURA
		if (Y41bConstantes.TRAMITE_SANCIONES_APERTURA.equals(santramexp.getTrcodigo())) {
			// No se permite eliminar el tramite de apertura, est o no
			// tramitado.
			throw new Y41bUDAException("error.eliminarTramite.isTramiteAperturaSancionException", true,
					new Exception());
		}
		// APORTE TELEMATICO
		// No se permite eliminar el tramite de aportacin de documentacin
		// telematico
		if (Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION.equals(santramexp.getTrcodigo())) {
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(santramexp.getTrid().toString());
			List<Sandoctemp> listDocumentosAportados = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux,
					null);
			if (listDocumentosAportados != null && listDocumentosAportados.size() > 0) {
				Sandoctemp sandoctemp = null;
				boolean aportadoReclamado = false;
				for (int j = 0; j < listDocumentosAportados.size(); j++) {
					sandoctemp = listDocumentosAportados.get(j);
					if (sandoctemp.getU5origen() != null
							&& (sandoctemp.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO)
									|| sandoctemp.getU5origen()
											.equals(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO))
							&& !Y41bUtils.esNullOCadenaVacia(sandoctemp.getU5iddocumentum())
							&& sandoctemp.getU5numregistroentrada() != null
							&& sandoctemp.getU5numregistroentrada().contains("RTE")) {
						aportadoReclamado = true;
						break;
					}
				}
				if (aportadoReclamado) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAportacionTelematicaException", true,
							new Exception());
				}
			}
		}
		// COMUNICACION
		if (santramexp.getTrfecfin() != null
				&& Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(santramexp.getTrcodigo())) {
			if (Y41bConstantes.TIPO_COMUNICACION_TELEMATICA.equals(santramexp.getTrtipocom())) {
				// No se podr eliminar un tramite de comunicacion si esta
				// tramitado
				// telematicamente.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionTelematicaException", true,
						new Exception());

			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO.equals(santramexp.getTrtipocom())) {
				// No se podr eliminar una comunicacion tramitada por mail
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionMailException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO.equals(santramexp.getTrtipocom())
					&& Y41bConstantes.SI.equals(santramexp.getTrenvrem()) && santramexp.getTrcodrem() != null
					&& !"".equals(santramexp.getTrcodrem())) {
				// No se podr eliminar una comunicacion ordinaria si es con
				// remesa y tiene la remesa generada
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionOrdinariaRemesaException", true,
						new Exception());
			}
		}
		Santramexp santramexpRel = new Santramexp();
		// NOTIFICACION
		if (Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigo())) {
			if (santramexp.getTrfecfin() != null
					&& Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(santramexp.getTrtiponot())) {
				// No se podr eliminar un tramite de notificacin si esta
				// tramitado
				// telematicamente.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionTelematicaException", true,
						new Exception());
			} else if (santramexp.getTrfecfin() != null
					&& Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(santramexp.getTrtiponot())) {
				if (Y41bConstantes.SI.equals(santramexp.getTrenvrem()) && santramexp.getTrcodrem() != null
						&& !santramexp.getTrcodrem().equals("")) {
					// No se podr eliminar una comunicacion ordinaria si es con
					// remesa y tiene la remesa generada
					throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaRemesaException",
							true, new Exception());
				} else {
					// No se podr eliminar un tramite notificacin ordinario
					// sin remesa si tiene acuse de recibo relacionado
					santramexpRel = new Santramexp();
					// Acuse de recibo cuyo tramite relacionado es el tramite en
					// el que estamos
					santramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO);
					santramexpRel.setTrtridrel(santramexp.getTrid());
					Long contador = this.santramexpDao.findAllCount(santramexpRel);
					if (contador.intValue() > 0) {
						throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaAcuse", true,
								new Exception());
					}
				}
			}
			// Al eliminar la notificacion (en los casos que se pueda) el
			// tramite asociado pasara a estar como pendiente.
			if (santramexp.getTrtridrel() != null) {
				santramexpRel = new Santramexp();
				santramexpRel.setTrid(santramexp.getTrtridrel());
				santramexpRel = this.santramexpDao.find(santramexpRel);
				santramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				this.santramexpDao.updateReabrirTramite(santramexpRel);
			}
		}

		// ACUSE
		if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
			if (santramexp.getTrfecfin() != null) {
				// No se permite eliminar el tramite de acuse de recibo si est
				// tramitado.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboTramitadoException", true,
						new Exception());
			}
			if (santramexp.getTrcodigorel() != null
					&& Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigorel())) {
				// No se podr eliminar un tramite de acuse de recibo
				// relacionado con una notificacin telematica
				santramexpRel = new Santramexp();
				// Notificacion telematica relacionada con el acuse en el que
				// estamos
				santramexpRel.setTrid(santramexp.getTrtridrel());
				santramexpRel = this.santramexpDao.find(santramexpRel);
				if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(santramexpRel.getTrtiponot())) {
					throw new Y41bUDAException(
							"error.eliminarTramite.isTramiteAcuseReciboNotificacionTelematicaException", true,
							new Exception());
				}

				// No se podr eliminar un tramite de acuse de recibo
				// relacionado
				// con una notificacin ordinaria con remesa generada (por lo
				// que si se
				// elimina la remesa, se podr eliminar el acuse)
				if (Y41bConstantes.SI.equals(santramexpRel.getTrenvrem()) && santramexpRel.getTrcodrem() != null
						&& !santramexpRel.getTrcodrem().equals("")) {
					throw new Y41bUDAException(
							"error.eliminarTramite.isTramiteAcuseReciboNotificacionOrdinariaRemesaException", true,
							new Exception());
				}
				// Al elminar el acuse de recibo (en los casos que se pueda) el
				// tramite
				// notificacion asociado pasara a estar como pendiente.
				if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
					santramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.santramexpDao.updateReabrirTramite(santramexpRel);
					// Y se borra de sanenvio
					Sanenvio sanenvio = new Sanenvio();
					sanenvio.setSantramexpByEntrid(new Santramexp(santramexp.getTrtridrel()));
					List<Sanenvio> envios = this.sanenvioDao.findAll(sanenvio, null);
					if (envios != null && envios.size() > 0) {
						for (int i = 0; i < envios.size(); i++) {
							sanenvio = envios.get(i);
							this.sanenvioDao.remove(sanenvio);
						}
					}
				}
			}

		}
		// LIQUIDACION
		if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION.equals(santramexp.getTrcodigo())) {
			// No se puede eliminar el tramite de liquidacin si est tramitado
			if (santramexp.getTrfecfin() != null) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteLiquidacionTramitadaException", true,
						new Exception());
			}
			// No se puede eliminar el tramite de liquidacin si se ha generado
			// la liquidacion en pasarela
			if (santramexp.getTrreferencia() != null) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteLiquidacionGeneradaException", true,
						new Exception());
			}

			// El tramite relacionado se abre
			santramexpRel = new Santramexp();
			santramexpRel.setTrid(santramexp.getTrtridrel());
			List<Santramexp> listaSantramexpRel = this.santramexpDao.findAll(santramexpRel, null);
			if (listaSantramexpRel != null && listaSantramexpRel.size() > 0) {
				santramexpRel = listaSantramexpRel.get(0);
				santramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				this.santramexpDao.updateReabrirTramite(santramexpRel);
			}
		}
		// CIERRE
		if (santramexp.getTrfecfin() != null
				&& Y41bConstantes.TRAMITE_SANCIONES_CIERRE.equals(santramexp.getTrcodigo())) {
			// No permite eliminar el tramite de cierre de expediente si est
			// tramitado
			throw new Y41bUDAException("error.eliminarTramite.isTramiteCierreException", true, new Exception());
		}
		// ELABORACION DOCUMENTACION
		if (Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA.equals(santramexp.getTrcodigo())) {
			if (santramexp.getTrfecfin() != null) {
				// No permite eliminar el tramite de elaboracin de
				// documentacin
				// para publicacin en BOE-BOPV si est tramitado
				throw new Y41bUDAException("error.eliminarTramite.isTramiteElaboracionDocException", true,
						new Exception());
			} else {
				// Se reabre el acuse de recibo relacionado
				// El tramite relacionado es la notificacion asi que tengo que
				// buscar el acuse de la notificacin
				santramexpRel = new Santramexp();
				santramexpRel.setTrtridrel(santramexp.getTrtridrel());
				santramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO);
				List<Santramexp> listaSantramexpRel = this.santramexpDao.findAll(santramexpRel, null);
				if (listaSantramexpRel != null && listaSantramexpRel.size() > 0) {
					santramexpRel = listaSantramexpRel.get(0);
					santramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.santramexpDao.updateReabrirTramite(santramexpRel);
				}
			}
		}
		// PUBLICACION BOE BOPV
		if (Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA.equals(santramexp.getTrcodigo())) {
			if (santramexp.getTrfecfin() != null) {
				// No permite eliminar el tramite de publicacin en BOE-BOPV si
				// est
				// tramitado
				throw new Y41bUDAException("error.eliminarTramite.isTramitePublicacionBOEBOPVException", true,
						new Exception());
			} else {
				// Se reabre la elaboracin documentacin relacionada
				// El tramite relacionado es la notificacion asi que tengo que
				// buscar la elaboracin documentacin de la notificacin
				santramexpRel = new Santramexp();
				santramexpRel.setTrtridrel(santramexp.getTrtridrel());
				santramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA);
				List<Santramexp> listaSantramexpRel = this.santramexpDao.findAll(santramexpRel, null);
				if (listaSantramexpRel != null && listaSantramexpRel.size() > 0) {
					santramexpRel = listaSantramexpRel.get(0);
					santramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.santramexpDao.updateReabrirTramite(santramexpRel);
				}
			}
		}
		// PAGO
		if (santramexp.getTrfecfin() != null
				&& Y41bConstantes.TRAMITE_SANCIONES_PAGO.equals(santramexp.getTrcodigo())) {
			// No permite eliminar el tramite de pago de expediente
			throw new Y41bUDAException("error.eliminarTramite.isTramitePagoException", true, new Exception());
		}
		// RESOLUCION PAGADA EN PRONTO PAGO
		if (santramexp.getTrprontopago() != null && Y41bConstantes.VALOR_SI.equals(santramexp.getTrprontopago())
				&& Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigo())) {
			// No permite eliminar el tramite de pago de expediente
			throw new Y41bUDAException("error.eliminarTramite.isTramiteResolucionPagadaProntoPagoException", true,
					new Exception());
		}
		// Eliminar bandeja de firma
		BandejaFirma bandejafirma = new BandejaFirma();
		bandejafirma.setIdtramitehecho(santramexp.getTrid().toString());
		bandejafirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
		bandejafirma.setIdexpediente(santramexp.getExpedien().getExcodigo());
		List<BandejaFirma> listaBandeja = this.bandejaFirmaDao.findAll(bandejafirma, null);
		if (listaBandeja != null) {
			for (int i = 0; i < listaBandeja.size(); i++) {
				BandejaFirma bandeja = listaBandeja.get(i);
				this.bandejaFirmaDao.remove(bandeja);
			}
		}

		// Eliminar documentos
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(santramexp.getTrid().toString());
		tramiteComun.setIdExpediente(santramexp.getExpedien().getExcodigo());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_SANCIONES));
		this.sandoctempDao.removeSanDocTramite(tramiteComun);

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		try {
			// INICIO Codigo sustituido
			// this.sandoctempDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
			// FIN Codigo sustituido
			// INICIO Se sustituye por
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
			documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
			List<DocumentoHecho> listDocumentoHecho2 = this.documentoHechoDao.findAll(documentoHecho, null);

			for (DocumentoHecho documentoHechoAux : listDocumentoHecho2) {
				try {
					this.documentoHechoDao.remove(documentoHechoAux);
				} catch (DataIntegrityViolationException dataIntegrityViolationException) {
					throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
				}
			}
			// FIN Se sustituye por
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		} catch (Exception e) {
			// Si tiene tramnite relacionado dara esta excepcion
			throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException", true, e);
		}
		try { // Borramos de Dokusi
			this.eliminarDocumentosDokusi(listDocumentoHecho);
		} catch (Exception e) {
			// Si tiene tramnite relacionado dara esta excepcion
			SantramexpServiceImpl.logger.error("Error al eliminar de documentos de Dokusi: " + e.getMessage());
			throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException", true, e);
		}

		// Envios
		Sanenvio sanenvio = new Sanenvio();
		if (Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(santramexp.getTrcodigo())) {
			sanenvio.setSantramexpByEntrid(new Santramexp(santramexp.getTrid()));
			List<Sanenvio> envios = this.sanenvioDao.findAll(sanenvio, null);
			if (envios != null && envios.size() > 0) {
				for (int i = 0; i < envios.size(); i++) {
					sanenvio = envios.get(i);
					this.sanenvioDao.remove(sanenvio);
				}
			}
		}

		// Eliminar sanbandeja
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setBatrid(santramexp.getTrid());
		List<Sanbandeja> listSanbandeja = this.sanbandejaDao.findAll(sanbandeja, null);
		if (listSanbandeja != null && listSanbandeja.size() > 0) {
			for (int i = 0; i < listSanbandeja.size(); i++) {
				sanbandeja = listSanbandeja.get(i);
				this.sanbandejaDao.remove(sanbandeja);
			}
		}

		Sanexp sanexp = this.sanexpDao.find(santramexp.getExpedien().getSanexp());
		sanexp.setSantramexp(null);
		sanexp.setSantramexpEntidad(null);

		Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
		if (sanexpAux != null) {
			sanexp.setHdte(sanexpAux.getHdte());
		}
		this.sanexpDao.update(sanexp);

		// Eliminar tramite
		try {
			this.santramexpDao.remove(santramexp);
		} catch (Exception e) {
			throw new Y41bUDAException("error.eliminarTramite.DataIntegrityViolationException", true, e);
		}
		try {

			// Actualizar expediente con el ultimo tramite
			Santramexp ultimoSantramexp = this.calculaUltimoTramiteEnSanExp(sanexp);

			// Actualizar bandeja
			this.actualizaBandeja(ultimoSantramexp);

			// Borrar datos del expediente referentes al ultimo tramite
			this.actualizaExpedienteTrasEliminar(santramexp);

			// Actualizar datos del expediente con los datos del ultimo
			// tramite del mismo tipo
			// Lo normal es que slo haya un tramite de cada

		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
			try {
				this.eliminarMisGestiones(santramexp);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl.remove Fin:" + santramexp.getTrid() + ".");
	}

	/**
	 * Deletes multiple rows in the Santramexp table.
	 * 
	 * @param santramexpList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santramexp> santramexpList) {
		for (Santramexp santramexpAux : santramexpList) {
			this.santramexpDao.remove(santramexpAux);
		}
	}

	/**
	 * 
	 * @param tramiteComun
	 *            tramiteComun TramiteComun
	 * @param anyadirPlantilla
	 *            String
	 * @return List<Sandoctemp>
	 */
	private List<Sandoctemp> tratarDocumentosTemporal(TramiteComun tramiteComun, String anyadirPlantilla) {
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.sandoctempDao.findAllDocumentosEliminados(tramiteComun, null);

		/* borro de SANDOCTRAMITE los documentos de ese tramite */
		this.sandoctempDao.removeSanDocTramite(tramiteComun);
		// INICIO Codigo sustituido
		// this.sandoctempDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		// FIN Codigo sustituido
		// INICIO Se sustituye por
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		List<DocumentoHecho> listDocumentoHecho2 = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho2) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}
		// FIN Se sustituye por
		this.sandoctempDao.addDocumentosHechoAdjuntarDocs(tramiteComun);
		this.sandoctempDao.addAdjuntarDocsSanDocTramite(tramiteComun);

		// borrar temporal
		if (!Y41bConstantes.VALOR_SI.equals(anyadirPlantilla)) {
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		}

		return listSandoctempEliminados;

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramiteGenerico.getFechaFin());
			santramexp.setCensoMonitorEj(tramiteGenerico.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramiteGenerico.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_GENERICO);
		santramexp.setFase(expedien.getSanexp().getFase());

		santramexp.setCensoMonitor(tramiteGenerico.getInstructorAsignado());
		santramexp.setTrnomtrames(tramiteGenerico.getNombreTramite());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteGenerico.getComentario()));

		santramexp.setTrid(tramiteComun.getIdTramite());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		if (tramitar) {
			this.actualizaBandeja(santramexp);
			this.actualizaUltimoTramiteEnSanExp(santramexp);
		} else {
			this.actualizaBandeja(santramexp);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param monitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramiteGenerico.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteGenerico tramiteGenericoAux = new TramiteGenerico();
		tramiteGenericoAux.setIdTramite(santramexp.getTrid().toString());
		tramiteGenericoAux.setFechaInicio(santramexp.getTrfecini());
		tramiteGenericoAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteGenericoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteGenericoAux.setInstructorEjecucion(instructorEjecucion);
		tramiteGenericoAux.setEstadoTramite(santramexp.getTrestado());
		tramiteGenericoAux.setNombreTramite(santramexp.getTrnomtrames());

		tramiteGenericoAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteGenericoAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramiteCierre.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteCierre tramite = new TramiteCierre();
		tramite.setIdTramite(santramexp.getTrid().toString());
		tramite.setFechaInicio(santramexp.getTrfecini());
		tramite.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramite.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramite.setInstructorEjecucion(instructorEjecucion);

		tramite.setEstadoTramite(santramexp.getTrestado());

		tramite.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		tramite.setFechaCierre(santramexp.getTrfeccierre());

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramite.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramite.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramite;
	}

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @throws Exception
	 *             the exception
	 */

	public void actualizaBandeja(Santramexp santramexp) throws Exception {

		/*
		 * codigo muerto porque se borra por expediente Sanbandeja sanbandeja =
		 * rellenaSanBandeja(santramexp,estado);
		 */
		boolean hayEnTramitacion = false;
		/* elimino todas las entradas del expediente si las tuviera */
		Sanbandeja sanbandejaVO = new Sanbandeja();
		sanbandejaVO.setExpedien(santramexp.getExpedien());
		this.sanBandejaDao.deleteBandejaPorExpediente(sanbandejaVO);

		Santramexp cierre = new Santramexp();
		cierre.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
		cierre.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
		cierre.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		if (this.santramexpDao.findAllCount(cierre).longValue() == 0L) {
			/* por cada santramexp que tenga pendiente aniado un registro */
			Santramexp santramexpVO = new Santramexp();
			santramexpVO.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			List<Santramexp> listaEntTramitacion = this.santramexpDao.findAll(santramexpVO, null);
			if ((listaEntTramitacion != null) && (listaEntTramitacion.size() > 0)) {
				hayEnTramitacion = true;
				Sanbandeja sanbandejaAux = null;
				for (int i = 0; i < listaEntTramitacion.size(); i++) {
					sanbandejaAux = this.rellenaSanBandeja((Santramexp) listaEntTramitacion.get(i),
							Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.sanBandejaDao.add(sanbandejaAux);
				}
			}

			/* por cada santramexp que tenga firmado aniado un registro */
			santramexpVO = new Santramexp();
			santramexpVO.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			List<Santramexp> listaFirmado = this.santramexpDao.findAll(santramexpVO, null);
			if ((listaFirmado != null) && (listaFirmado.size() > 0)) {
				hayEnTramitacion = true;
				Sanbandeja sanbandejaAux = null;
				for (int i = 0; i < listaFirmado.size(); i++) {
					sanbandejaAux = this.rellenaSanBandeja((Santramexp) listaFirmado.get(i),
							Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					this.sanBandejaDao.add(sanbandejaAux);
				}
			}

			santramexpVO = new Santramexp();
			santramexpVO.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			List<Santramexp> listaDenegadaFirma = this.santramexpDao.findAll(santramexpVO, null);
			if ((listaDenegadaFirma != null) && (listaDenegadaFirma.size() > 0)) {
				hayEnTramitacion = true;
				Sanbandeja sanbandejaAux = null;
				for (int i = 0; i < listaDenegadaFirma.size(); i++) {
					sanbandejaAux = this.rellenaSanBandeja((Santramexp) listaDenegadaFirma.get(i),
							Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
					this.sanBandejaDao.add(sanbandejaAux);
				}
			}

			santramexpVO = new Santramexp();
			santramexpVO.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			List<Santramexp> listaPdteFirma = this.santramexpDao.findAll(santramexpVO, null);
			if ((listaPdteFirma != null) && (listaPdteFirma.size() > 0)) {
				hayEnTramitacion = true;
				Sanbandeja sanbandejaAux = null;
				for (int i = 0; i < listaPdteFirma.size(); i++) {
					sanbandejaAux = this.rellenaSanBandeja((Santramexp) listaPdteFirma.get(i),
							Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					this.sanBandejaDao.add(sanbandejaAux);
				}
			}
			/* si no he añadido a la bandeja nada despues de lo anterior */
			if (!hayEnTramitacion) {
				/*
				 * sino habia pendientes aniado el último de los tramitados
				 */
				santramexpVO = new Santramexp();
				santramexpVO.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				santramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				Pagination pagination = new Pagination();
				pagination.setSort("trfecalta desc, trid");
				pagination.setSord("desc");
				List<Santramexp> listaTramitado = this.santramexpDao.findAll(santramexpVO, pagination);
				Santramexp santramexpAux = new Santramexp();
				if ((listaTramitado != null) && (listaTramitado.size() > 0)) {
					Sanbandeja sanbandejaAux = null;
					santramexpAux = (Santramexp) listaTramitado.get(0);
					sanbandejaAux = this.rellenaSanBandeja(santramexpAux, Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					this.sanBandejaDao.add(sanbandejaAux);

				}
			}
		}
	}

	/**
	 * Rellena san bandeja.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @param estado
	 *            the estado
	 * @return the sanbandeja
	 */
	private Sanbandeja rellenaSanBandeja(Santramexp santramexp, String estado) {
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setExpedien(santramexp.getExpedien());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(estado)) {
			sanbandeja.setMonitor(santramexp.getCensoMonitorEj());

		} else if (Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION.equals(estado)) {
			sanbandeja.setMonitor(santramexp.getCensoMonitor());

		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(estado)) {
			sanbandeja.setMonitor(santramexp.getCensoMonitor());

		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADO.equals(estado)) {
			sanbandeja.setMonitor(santramexp.getCensoMonitor());
		}
		if (Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(santramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
			/* rellenamos el campo destino/origen */
			sanbandeja.setSaninterv(new Saninterv(santramexp.getTruaidinterv()));
		}
		sanbandeja.setBatrid(santramexp.getTrid());
		sanbandeja.setBaestado(estado);
		sanbandeja.setBafec(santramexp.getTrfecini());
		sanbandeja.setBafase(santramexp.getFase().getFcodigo());

		return sanbandeja;

	}

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @return Sanexp
	 */
	public Sanexp actualizaUltimoTramiteEnSanExp(Santramexp santramexp) {
		try {
			Expedien expediente = santramexp.getExpedien();

			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(expediente.getExcodigo());
			sanexp = this.sanexpDao.dameDetallesExpediente(sanexp);
			sanexp.setSantramexp(santramexp);
			PosibleTramite posibletramite = new PosibleTramite();
			posibletramite.setTrposiblecodigoorigen(santramexp.getTrcodigo());
			Long sugierePosibleTramite = this.posibleTramiteDao.findAllCount(posibletramite);

			if (sugierePosibleTramite != 0) {
				/* es de entidad */
				sanexp.setSantramexpEntidad(santramexp);
			}
			Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
			if (sanexpAux != null) {
				sanexp.setHdte(sanexpAux.getHdte());
			}

			/* actualizamos sanexp */
			this.sanexpDao.update(sanexp);

			return sanexp;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.error("Error producido en actualizaUltimoTramiteEnSanExp: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param sanexp
	 *            the sanexp
	 * @return the sanexp
	 */

	private Santramexp calculaUltimoTramiteEnSanExp(Sanexp sanexp) {
		try {
			Expedien expedien = this.expedienDao.find(new Expedien(sanexp.getExcodigo()));

			Santramexp santramexpAux = new Santramexp();
			santramexpAux.setExpedien(expedien);
			santramexpAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSort("TRFECFIN DESC, TRID");
			pagination.setSord("DESC");

			Santramexp ultimotramiteGeneral = this.santramexpDao.dameUltimoTramiteTramitado(sanexp.getExcodigo());
			ultimotramiteGeneral.setExpedien(new Expedien(sanexp.getExcodigo()));

			List<Santramexp> listaSanTramExp = this.santramexpDao.findAll(santramexpAux, pagination);
			Santramexp ultimotramiteEntidad = new Santramexp();
			PosibleTramite posibletramite = new PosibleTramite();
			boolean tramiteEncontrado = false;
			if (listaSanTramExp != null) {
				for (int i = 0; i < listaSanTramExp.size() && !tramiteEncontrado; i++) {
					santramexpAux = listaSanTramExp.get(i);
					posibletramite = new PosibleTramite();
					posibletramite.setTrposiblecodigoorigen(santramexpAux.getTrcodigo());
					Long sugierePosibleTramite = this.posibleTramiteDao.findAllCount(posibletramite);
					if (sugierePosibleTramite != 0) {
						/* es de entidad */
						ultimotramiteEntidad = santramexpAux;
						tramiteEncontrado = true;
					}
				}
			}
			sanexp.setSantramexp(ultimotramiteGeneral);
			sanexp.setSantramexpEntidad(ultimotramiteEntidad);
			sanexp.setFase(ultimotramiteEntidad.getFase());

			Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
			if (sanexpAux != null) {
				sanexp.setHdte(sanexpAux.getHdte());
			}
			this.sanexpDao.update(sanexp);

			return ultimotramiteGeneral;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.error("Error producido en actualizaUltimoTramiteEnSanExp: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param excodigo
	 *            String
	 * @param nuevaFase
	 *            String
	 */

	public void actualizaFaseEnSanExpDesdeAportacion(String excodigo, String nuevaFase) {
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(excodigo);
		sanexp = this.sanexpDao.find(sanexp);
		sanexp.setFase(new Fase(nuevaFase));

		Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
		if (sanexpAux != null) {
			sanexp.setHdte(sanexpAux.getHdte());
		}

		this.sanexpDao.update(sanexp);

		/* actualizo la salida de la fase, cojo la última */
		Historicofases historicoFases = new Historicofases();
		historicoFases.setHfexcodigo(excodigo);

		List<Historicofases> historicoFasesLista = this.historicoFasesDao.findAllFasesHistoricoAbiertas(historicoFases);
		if (historicoFasesLista != null) {
			if (historicoFasesLista.size() > 0) {
				Historicofases entradaACerrar = historicoFasesLista.get(0);
				entradaACerrar.setHfffin(new Date());
				this.historicoFasesDao.updateFechaFin(entradaACerrar);
			}
		}

		/* doy de alta la entrada en la nueva fase */
		historicoFases = new Historicofases();
		historicoFases.setHffcodigo(nuevaFase);
		historicoFases.setHfexcodigo(excodigo);
		historicoFases.setHffinicio(new Date());
		this.historicoFasesDao.add(historicoFases);

	}

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tipoDeTramite
	 *            the tipo de tramite
	 */

	public void actualizaFaseEnSanExpDesdeTramite(String excodigo, String tipoDeTramite) {

		String expediente = excodigo;
		String tipoTramite = tipoDeTramite;
		Fase faseActualExpediente = new Fase();
		Fase fase = null;
		if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_INICIO_SANCION);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_RESOLUCION_SANCION);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_PRUEBAS_SANCION);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_CIERRE.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_CIERRE_SANCION);
		}
		if (fase != null) {
			/* actualizamos sanexp */
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(expediente);
			sanexp = this.sanexpDao.find(sanexp);
			if (sanexp != null) {
				Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
				if (sanexpAux != null) {
					sanexp.setHdte(sanexpAux.getHdte());
				}
			}
			faseActualExpediente = sanexp.getFase();

			if (!faseActualExpediente.getFcodigo().equals(fase.getFcodigo())) {
				sanexp.setFase(fase);
				this.sanexpDao.update(sanexp);

				/* actualizo la salida de la fase, cojo la última */
				Historicofases historicoFases = new Historicofases();
				historicoFases.setHfexcodigo(excodigo);
				List<Historicofases> historicoFasesLista = this.historicoFasesDao
						.findAllFasesHistoricoAbiertas(historicoFases);
				if (historicoFasesLista != null) {
					if (historicoFasesLista.size() > 0) {
						Historicofases entradaACerrar = historicoFasesLista.get(0);
						entradaACerrar.setHfffin(new Date());
						this.historicoFasesDao.updateFechaFin(entradaACerrar);
					}
				}
				/* doy de alta la entrada en la nueva fase */
				historicoFases = new Historicofases();
				historicoFases.setHffcodigo(fase.getFcodigo());
				historicoFases.setHfexcodigo(excodigo);
				historicoFases.setHffinicio(new Date());
				this.historicoFasesDao.add(historicoFases);

			}
		}
	}

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, String idInterviniente) throws Exception {

		RegistroEntrada registroEntrada = new RegistroEntrada();

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

		String excoor = expedien.getSanexp() == null ? expedien.getExcoor() : expedien.getSanexp().getExcooractual();

		if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(new BigDecimal(idInterviniente));

		saninterv = this.sanintervDao.find(saninterv);

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(saninterv.getUanif())) {
			sbPerson.append(saninterv.getUanif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(saninterv.getUanoco())) {
			sbPerson.append(saninterv.getUanoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(saninterv.getUanombre())) {
				sbPerson.append(saninterv.getUanombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
				sbPerson.append(saninterv.getUaapellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				sbPerson.append(saninterv.getUaapellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_SANCIONES);
		sbMatter.append("-");
		sbMatter.append(expedien.getExcoor()).append("-").append(expedien.getExnror()).append("-")
				.append(expedien.getExnran()).append("-").append(expedien.getExnror());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

		registroEntrada.setRegistryNumber(wSInputRegister.getNumber());
		registroEntrada.setRegistryDate(wSInputRegister.getDate().toGregorianCalendar().getTime());

		return registroEntrada;
	}

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param esNotificacion
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(TramiteComun tramiteComun, String idInterviniente, boolean esNotificacion)
			throws Exception {

		WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

		Expedien expedienteVO = new Expedien();
		expedienteVO.setExcodigo(tramiteComun.getIdExpediente());

		expedienteVO = this.expedienDao.find(expedienteVO);

		String excoor = expedienteVO.getSanexp() == null ? expedienteVO.getExcoor()
				: expedienteVO.getSanexp().getExcooractual();

		if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (excoor.equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Saninterv saninterv = new Saninterv();
		if (Y41bUtils.esNullOCadenaVacia(idInterviniente)) {

			saninterv.setExpedien(
					new Expedien(tramiteComun.getIdExpediente(), null, null, null, null, null, null, null, null));
			saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			List<Saninterv> listaSaninterv = this.sanintervDao.findAll(saninterv, null);
			if (listaSaninterv != null) {
				if (listaSaninterv.size() == 1) {
					saninterv = (Saninterv) listaSaninterv.get(0);
				}
			}
		} else {
			saninterv.setExpedien(
					new Expedien(tramiteComun.getIdExpediente(), null, null, null, null, null, null, null, null));
			saninterv.setUaidinterv(new BigDecimal(idInterviniente));
			saninterv = this.sanintervDao.find(saninterv);
		}

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(saninterv.getUanif())) {
			sbPerson.append(saninterv.getUanif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(saninterv.getUanoco())) {
			sbPerson.append(saninterv.getUanoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(saninterv.getUanombre())) {
				sbPerson.append(saninterv.getUanombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
				sbPerson.append(saninterv.getUaapellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				sbPerson.append(saninterv.getUaapellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(
				esNotificacion ? Y41bConstantes.LITERAL_NOTIFICACION_ES : Y41bConstantes.LITERAL_COMUNICACION_ES);
		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_SANCIONES);
		sbMatter.append("-");
		sbMatter.append(expedienteVO.getExcoor()).append("-").append(expedienteVO.getExnror()).append("-")
				.append(expedienteVO.getExnran());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

		RegistroSalida registroSalida = new RegistroSalida();
		registroSalida.setRegistryNumber(wSOutputRegister.getNumber());
		registroSalida.setRegistryDate(new Date());

		return registroSalida;
	}

	/**
	 * 
	 * @param listDocumentoHecho
	 *            List<Sandoctemp>
	 * @return tramite
	 */
	public boolean hayDocsPendienteFirma(List<Sandoctemp> listDocumentoHecho) {

		// Miramos si hay algun documento pendiente de firma o denegada
		boolean isDocPendienteFirma = false;

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Sandoctemp documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getU5estadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getU5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}
		// Miramos si hay algun documento pendiente de firma
		return isDocPendienteFirma;
	}

	/**
	 * Comprueba si dispone de los datos en 'Mi perfil' platea (1) o en el censo
	 * (2) de la aplicacin (establecimiento) o con el cif del establecimiento y
	 * tipo de procedimiento (3).
	 * 
	 * @param codigoEstablecimiento
	 *            - codigoEstablecimiento
	 * @param nifEstablecimiento
	 *            - codigoEstablecimiento
	 * @param tipoProcedimeinto
	 *            - Constante que define el tipo de procedimiento
	 * @return boolean - Si tiene mail o no
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean tieneEmail(String codigoEstablecimiento, String nifEstablecimiento, final String tipoProcedimeinto)
			throws Exception {
		boolean tieneEmail = false;
		try {
			// 1. Comprobacin desde el servicio de GV Platea (Tramitagune) para
			// ver si tiene email en 'Mi Perfil'
			// aqui
			boolean tieneEmailPlateaMiPerfil = false;
			// Conexin con Platea y bsqueda de su tiene mail
			tieneEmailPlateaMiPerfil = y41bPlateaAdapterService.tieneEmailCuentaInteresado(nifEstablecimiento);
			logger.debug("tieneEmail: tieneEmailPlateaMiPerfil -> " + tieneEmailPlateaMiPerfil);

			// 2. Comprobacin desde esta app en el 'Censo de Empresas' si tiene
			// uno de los mails en establecimiento
			boolean tieneEmailCensoKontsumobide = false;
			// 2.1 Obtener establecimiento
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(codigoEstablecimiento);
			establecimiento = this.establecimientoService.find(establecimiento);
			// 2.2 Comprobaciones si el establecimiento tiene mail
			if (establecimiento != null) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimiento.getEsmailnotificacion())) {
					tieneEmailCensoKontsumobide = true;
				}
			}
			logger.debug("tieneEmail: tieneEmailCensoKontsumobide -> " + tieneEmailCensoKontsumobide);

			// 3. Comprobacin mail de aviso en notificaciones/comunicaciones
			// Platea por CIF de establecimiento y tipo de procedimiento
			boolean tieneEmailPlateaPorCIFTipoProcedimeinto = false;
			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			adjunDatosAvisosEstablec.setYipcodigo(tipoProcedimeinto);
			adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);
			if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
				tieneEmailPlateaPorCIFTipoProcedimeinto = true;
			} else if (establecimiento != null && Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
				tieneEmailPlateaPorCIFTipoProcedimeinto = true;
			}
			logger.debug("tieneEmail: tieneEmailPlateaPorCIFTipoProcedimeinto -> "
					+ tieneEmailPlateaPorCIFTipoProcedimeinto);

			// Comprobar si se cumplen las condiciones 1, 2 o 3.
			if (tieneEmailPlateaMiPerfil || tieneEmailCensoKontsumobide || tieneEmailPlateaPorCIFTipoProcedimeinto) {
				tieneEmail = true;
			}
			logger.debug("tieneEmail: resultado final -> " + tieneEmail);
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

		return tieneEmail;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteAcuerdoIncoacion(TramiteSANAcuerdoIncoacion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		// CONDICIONES A REVISAR: CIF e E-MAIL
		if (tramitar) {
			// 0175151: Debe disponerse de un CIF valido a la hora de abrir un
			// acuerdo de incoaccin a una empresa
			// comprobamos que el cif del establecimiento sancionado es correcto
			// antes de hacer nada
			Saninterv saninterv = this.sanintervDao.dameSancionado(tramiteComun.getIdExpediente());
			if (null != saninterv) {
				String documentoSancionado = saninterv.getUanif();
				if (!Y41bUtils.isValidCIF(documentoSancionado) && !Y41bUtils.isValidNIF(documentoSancionado)
						&& !Y41bUtils.isValidNIE(documentoSancionado)) {
					throw new Y41bUDAException("error.establecimiento.cifNoValidoException", true, null);
				}
			} else {
				throw new Y41bUDAException("error.establecimiento.cifNoValidoException", true, null);
			}

			// 0175151
			if (!this.compruebaSecuenciaFechasTramitacion(tramiteComun.getIdExpediente(),
					tramiteComun.getIdTipoTramite(), tramite.getFechaAcuerdoIncoacion())) {
				throw new Y41bUDAException("error.validacion.fechasTramitacion", true, null);
			}
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			// Notificacin: La empresa que es sancionada hay que comunicar
			// telemticamente si dispone de los datos y sino avisar mediante
			// notificacin postal.
			boolean notificacionViaEmail = tieneEmail(saninterv.getUaescodigo(), saninterv.getUanif(),
					Y41bConstantes.TIPO_PROC_SANCIONES);

			// Tramitar si se cumple 1 o 2 o 3
			// Si no tiene mail debe aparecer un mensaje:
			// - Si se pulsa en aceptar: se envia mediante postal.
			// - Si se pulsa en cancelar: se para la ejecucin.
			if (notificacionViaEmail) {
				// Informar mediante platea para enviar el aviso de la puesta a
				// disposicin de una notificacin.
				tramite.setVia(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			} else {
				if (tramite.getVia() == null) {
					// - si en el mensaje de confirmacin pulsa en aceptar se
					// enviar por papel insertando en tramite.getVia() =
					// "C". //PAPEL
					// - si pulsa en cancelar no se har nada.
					throw new Y41bUDAException("error no email", true, null);
				}
			}
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());

		santramexp.setTrfecacini(tramite.getFechaAcuerdoIncoacion());
		santramexp.setTrimporteinicial(Y41bUtils.esNullOCadenaVacia(tramite.getImporteInicial()) ? null
				: new BigDecimal(tramite.getImporteInicial().replace('\u002c', '\u002e')));
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		santramexp.setTrid(tramiteComun.getIdTramite());

		santramexp = this.setSantramexp(santramexp);

		// Buscamos los documentos almacenados con anterioridad
		List<Sandoctemp> listDocumentosAnteriores = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				if (tramite.getVia() != null) {
					if (Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(tramite.getVia())) {
						// Si no tiene mail de avisos la notificacin de la
						// incoacin deber ser en papel,
						// tal y como se determina en el art. 43.2 del RD
						// 203/2021. Advirtiendo al interesado,
						// en esa primera notificacin, que las sucesivas se
						// practicarn en forma electrnica
						// por comparecencia en la sede electrnica,
						// para ello se modificar la plantilla del adjunto
						// remito que se enva junto con la incoacin.
						santramexp.setTrisNotificacionIncoacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
					} else {
						// Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramite.getVia())
						// Platea se encarga en la notificacin de enviar el
						// aviso de la puesta a disposicin de una
						// notificacin
						santramexp.setTrisNotificacionIncoacion(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
					}

				}

				// Se genera el tramite (siguiente pantalla para elegir va
				// postal o electrnica)
				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				// Si se le ha enviado notificacion postal no se genera
				// comunicacion postal
				if (!Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA
						.equalsIgnoreCase(santramexp.getTrisNotificacionIncoacion())) {
					// # INICIO #
					// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
					// SANCIONADO
					//
					List<Saninterv> sanintervl = this.sanintervDao.findAllSancionados(expedien);
					if (sanintervl != null & sanintervl.size() > 0) {
						Saninterv saninterv = new Saninterv();
						saninterv = sanintervl.get(0);

						// 143236 - Solo se genera la comunicacion postal si la
						// forma de notificacion al sancionado en este momento
						// es
						// telematica

						if (saninterv != null
								&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO).equals(saninterv.getUatipointerv())
								&& (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)
										.equals(saninterv.getUaformanotificacion())) {
							santramexp.setTrisComunicacionInicio(Y41bConstantes.SI);
							this.sugiereTramiteComunicacionAutomaticamente(santramexp,
									saninterv.getUaidinterv().longValue(), false);
						}

					}
					// # FIN #
				}

				/*
				 * sugerimos una tarea de comunicacion para cada interesado,
				 * puede haber varios
				 */
				List<Saninterv> listaInteresados = this.sanintervDao.findAllInteresados(expedien);
				Saninterv saninterv = null;
				if (listaInteresados != null) {
					for (int i = 0; i < listaInteresados.size(); i++) {
						saninterv = (Saninterv) listaInteresados.get(i);
						Long idInterviniente = Long.parseLong(saninterv.getUaidinterv().toString());
						santramexp.setTrisComunicacionInicio(Y41bConstantes.NO);
						/* para cada interviniente sugiero una comunicacion */
						this.sugiereTramiteComunicacionAutomaticamente(santramexp, idInterviniente, false);
					}
				}

				// Tras tramitar la incoacin se elimina aviso fecha
				// prescripcin
				this.sanbandejaDao.eliminaAvisoFechaPrescripcion(expedien);

				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);

				// EVOLUTIVO 0135083 2.3 COMENTAMOS EL CODIGO DEL METODO QUE AL
				// TRAMITAR EL ACUERDO DE INCOACION ABRE EN PLATEA EL EXPEDIENTE
				// lo dejamos descomentado ya que se va a abrir en
				// crearEJGVDocumentNotificacion en
				// TramiteNotificacionController
				// Sanexp sanexp = new Sanexp();
				// sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
				// sanexp = this.sanexpDao.find(sanexp);
				// SantramexpServiceImpl.logger
				// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion -
				// Apertura expediente Platea");
				// if (!Y41bConstantes.VALOR_SI.equals(sanexp.getPlatea())) {
				// SantramexpServiceImpl.logger
				// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion -
				// Apertura expediente Platea Inicio");
				// this.abrirSolicitudOficioPlatea(expedien);
				// SantramexpServiceImpl.logger
				// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion -
				// Apertura expediente Platea Fin");
				// sanexpDao.updateIndicadorPlatea(sanexp);
				// SantramexpServiceImpl.logger
				// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion -
				// Actualizacion indicador Platea");
				// }

			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.enviarEmailRevisionDocumento(tramiteComun.getIdExpediente(), listDocumentosAnteriores, listDocumentoHecho,
				tramite.getInstructorEjecucion(), Y41bConstantes.FASE_INICIO_SANCION);

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * 
	 * @param santramexp
	 *            santramexp
	 * @param tramiteComun
	 *            tramiteComun
	 * @param listDocumentoHecho
	 *            listDocumentoHecho
	 * @param isDocPendienteFirma
	 *            isDocPendienteFirma
	 * @throws Exception
	 *             Exception
	 */
	public void guardarTramite(Santramexp santramexp, TramiteComun tramiteComun, List<Sandoctemp> listDocumentoHecho,
			boolean isDocPendienteFirma) throws Exception {
		if (isDocPendienteFirma) {
			this.actualizaBandeja(santramexp);
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, santramexp.getFase().getFcodigo(),
					santramexp.getTrcodigo());

		} else {
			this.actualizaBandeja(santramexp);
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}
	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param listDocumentosAnteriores
	 *            List<Sandoctemp>
	 * @param listDocumentoHecho
	 *            List<Sandoctemp>
	 * @param listDocumenfasetoHecho
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void enviarEmailRevisionDocumento(String excodigo, List<Sandoctemp> listDocumentosAnteriores,
			List<Sandoctemp> listDocumentoHecho, CensoMonitor censoMonitor, String fase) {

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			boolean enviarEmail = false;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA
						.equals(listDocumentoHecho.get(i).getU5estadodocumento())) {
					enviarEmail = true;
					for (int j = 0; j < listDocumentosAnteriores.size(); j++) {
						if (listDocumentoHecho.get(i).getU5codocumento()
								.equals(listDocumentosAnteriores.get(j).getU5codocumento())) {
							enviarEmail = false;
							break;
						}
						if (enviarEmail) {
							break;
						}
					}
				}
			}
			if (enviarEmail) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

				String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
				censoMonitor = censoMonitorDao.find(censoMonitor);
				if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
					throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
				}
				String from = censoMonitor.getMocoem();

				CensoMonitor adminLiq = new CensoMonitor();
				adminLiq.setMoadmiliquidacion(Y41bConstantes.VALOR_SI);
				List<CensoMonitor> ladminLiq = censoMonitorDao.findAllCensoMonitorSanciones(adminLiq);
				StringBuffer destinatarios = new StringBuffer("");
				for (int i = 0; i < ladminLiq.size(); i++) {
					if (!Y41bUtils.esNullOCadenaVacia(ladminLiq.get(i).getMocoem())) {
						if (destinatarios.length() > 0) {
							destinatarios.append(";");
						}
						destinatarios.append(ladminLiq.get(i).getMocoem());
					}
				}
				if (!Y41bUtils.isFilled(destinatarios.toString())) {
					throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
				}
				// 2. Creo el asunto
				// Obtener el numero de expediente
				Expedien expedien = new Expedien();
				expedien.setExcodigo(excodigo);
				expedien = this.expedienDao.find(expedien);

				StringBuffer numeroExpediente = new StringBuffer();
				numeroExpediente.append(expedien.damecodCompletoPlatea());

				StringBuffer asunto = new StringBuffer();
				// INICIO 0180618: SANCIONADOR - Cambios en mails de aviso
				String cadenaLiteralFase = "liquidacion.mail.faseInicio";
				if (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION.equalsIgnoreCase(fase)) {
					cadenaLiteralFase = "liquidacion.mail.fasePropuesta";
				} else if (Y41bConstantes.FASE_RESOLUCION_SANCION.equalsIgnoreCase(fase)) {
					cadenaLiteralFase = "liquidacion.mail.faseResolucion";
				}
				// Castellano
				asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(this.appMessageSource.getMessage(cadenaLiteralFase, null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(
						this.appMessageSource.getMessage(cadenaLiteralFase, null, new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
				// FIN 0180618: SANCIONADOR - Cambios en mails de aviso

				// 3. Creo el contenido del mail
				StringBuffer texto = new StringBuffer();
				String[] params = new String[1];
				params[0] = numeroExpediente.toString();
				texto.append("<B>").append(this.appMessageSource.getMessage("liquidacion.mail.texto", params,
						new Locale(Y41bConstantes.CASTELLANO)));
				texto.append(" / ").append(this.appMessageSource.getMessage("liquidacion.mail.texto", params,
						new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

				boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
						destinatarios.toString(), "", null);
				if (!enviadoOK) {
					throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
				}

			}
		}
	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param listDocumenfasetoHecho
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void enviarEmailElaboracionInformeAsesoria(String excodigo, CensoMonitor censoMonitor) {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
		censoMonitor = censoMonitorDao.find(censoMonitor);
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}
		String from = censoMonitor.getMocoem();

		CensoMonitor adminLiq = new CensoMonitor();
		adminLiq.setMoadmiliquidacion(Y41bConstantes.VALOR_SI);
		List<CensoMonitor> ladminLiq = censoMonitorDao.findAllCensoMonitorSanciones(adminLiq);
		StringBuffer destinatarios = new StringBuffer("");
		for (int i = 0; i < ladminLiq.size(); i++) {
			if (!Y41bUtils.esNullOCadenaVacia(ladminLiq.get(i).getMocoem())) {
				if (destinatarios.length() > 0) {
					destinatarios.append(";");
				}
				destinatarios.append(ladminLiq.get(i).getMocoem());
			}
		}
		if (!Y41bUtils.isFilled(destinatarios.toString())) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
		// 2. Creo el asunto
		// Obtener el numero de expediente
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		expedien = this.expedienDao.find(expedien);

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(expedien.damecodCompletoPlatea());

		StringBuffer asunto = new StringBuffer();
		// Castellano
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(numeroExpediente).append(" / ");
		// Euskera
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params = new String[1];
		params[0] = numeroExpediente.toString();
		texto.append("<B>").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	public TramiteSANAcuerdoIncoacion findTramiteAcuerdoIncoacion(TramiteSANAcuerdoIncoacion tramite,
			CensoMonitor censoMonitor) {

		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteSANAcuerdoIncoacion tramiteAux = new TramiteSANAcuerdoIncoacion();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAux.setEstadoTramite(santramexp.getTrestado());
		tramiteAux.setFechaAcuerdoIncoacion(santramexp.getTrfecacini());
		tramiteAux.setImporteInicial(santramexp.getTrimporteinicial() == null ? ""
				: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrimporteinicial().doubleValue()));

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteSANAmpliacionPlazoAlegaciones
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteAmpliacionPlazoAlegaciones(TramiteSANAmpliacionPlazoAlegaciones tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrnumDias(tramite.getNumeroDiasAmpliacion());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				this.actualizaBandeja(santramexp);

				/*
				 * buscamos los avisos de la bandeja de tipo alegaciones y les
				 * ampliamos el plazo en los x dias indicados en este tramite
				 */
				int numeroDiasAmpliados = Integer.parseInt(tramite.getNumeroDiasAmpliacion().toString());
				List<Sanbandeja> listaAvisosAlegaciones = this.sanbandejaDao.getAvisosPlazoAlegaciones(expedien);
				if (listaAvisosAlegaciones != null) {
					Sanbandeja entradaBandejaAlegaciones = new Sanbandeja();
					for (int i = 0; i < listaAvisosAlegaciones.size(); i++) {
						entradaBandejaAlegaciones = (Sanbandeja) listaAvisosAlegaciones.get(i);
						Date fechaInicioAviso = entradaBandejaAlegaciones.getBafecini();
						Date fechaLimiteAviso = entradaBandejaAlegaciones.getBafeclimite();
						fechaInicioAviso = Y41bUtils.addDays(fechaInicioAviso, numeroDiasAmpliados);
						fechaLimiteAviso = Y41bUtils.addDays(fechaLimiteAviso, numeroDiasAmpliados);
						entradaBandejaAlegaciones.setBafecini(fechaInicioAviso);
						entradaBandejaAlegaciones.setBafeclimite(fechaLimiteAviso);
						this.sanbandejaDao.update(entradaBandejaAlegaciones);
					}
				}
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANAmpliacionPlazoAlegaciones findTramiteAmpliacionPlazoAlegaciones(
			TramiteSANAmpliacionPlazoAlegaciones tramite, CensoMonitor censoMonitor) {
		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteSANAmpliacionPlazoAlegaciones tramiteAux = new TramiteSANAmpliacionPlazoAlegaciones();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAux.setEstadoTramite(santramexp.getTrestado());
		tramiteAux.setNumeroDiasAmpliacion(santramexp.getTrnumDias());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		if (this.tratamientoSeguridad(santramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramiteAcuse
	 *            the tramite acuse
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp sugiereTramiteAytoDesdeAcuse(Santramexp tramiteAcuse) throws Exception {

		Santramexp santramexp = new Santramexp();

		santramexp.setExpedien(tramiteAcuse.getExpedien());
		santramexp.setFase(tramiteAcuse.getFase());
		santramexp.setTrfecini(tramiteAcuse.getTrfecini());

		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
		santramexp.setCensoMonitor(tramiteAcuse.getCensoMonitorEj());

		this.santramexpDao.add(santramexp);
		santramexp.setTrid(this.santramexpDao.currentValue());

		this.actualizaBandeja(santramexp);

		return santramexp;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		if (tramite.getInterviniente() != 0) {
			santramexp.setTruaidinterv(new BigDecimal(tramite.getInterviniente()));
		}
		santramexp.setTrid(tramiteComun.getIdTramite());

		santramexp.setTipoDestOrigen(tramite.getOrigen());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				List<Saninterv> sanintervs = this.sanintervDao.findAllByTipo(expedien,
						Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);
				if (sanintervs == null || (sanintervs != null && sanintervs.size() == 0)) {
					throw new Y41bUDAException("error.tramiteRequerimientoAcreditacionRepresentacion.norepresentado",
							true, new Y41bUDAException());
				}

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				Santramexp santramexpAux = this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(santramexpAux.getTruaidinterv());
				saninterv = this.sanintervDao.find(saninterv);

				this.sugiereTramiteRecepcionRequerimientoAcreditacionRepresentacion(santramexp, saninterv);

				this.actualizaBandeja(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteRequerimientoAcreditacionRepresentacion tramiteAux = new TramiteRequerimientoAcreditacionRepresentacion();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		if (santramexp.getTruaidinterv() != null) {
			tramiteAux.setInterviniente(Long.parseLong(santramexp.getTruaidinterv().toString()));
		}

		tramiteAux.setOrigen(santramexp.getTipoDestOrigen());

		if (this.tratamientoSeguridad(santramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrresumenalegaciones(Y41bUtils.stringToClob(tramite.getResumenAlegaciones()));
		santramexp.setTrrespuesta(tramite.getRespuesta());
		santramexp.setTipoDestOrigen(tramite.getOrigen());

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		/*
		 * Si no existe tramite de incoacion tramitado no se puede acreditar un
		 * representante porque esto significa actualizar la participacion en
		 * platea cuando todavia no esta abierta, con lo que daria un error
		 */
		if (tramitar) {
			Santramexp acuerdoIncoacion = new Santramexp();
			acuerdoIncoacion.setExpedien(expedien);
			List<Santramexp> lsantramexp = null;
			acuerdoIncoacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
			acuerdoIncoacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			lsantramexp = this.santramexpDao.findAll(acuerdoIncoacion, null);

			if (lsantramexp == null || lsantramexp.size() == 0) {
				throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.acuerdoIncoacion", true,
						new Exception());
			}
		}

		if (tramitar) {

			// Si la respuesta es 'Valido', se busca un representante de origen
			// no valido y se le pone a 'Valido'. Si no encuentra representante,
			// se devuelve un mensaje de error.
			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO.equals(tramite.getRespuesta())) {
				Saninterv saninterv = new Saninterv();
				CensoMonitor censoMonitor = santramexp.getCensoMonitor();
				censoMonitor = this.censoMonitorDao.find(censoMonitor);

				List<Saninterv> lsaninterv = this.sanintervDao.findAllByTipo(expedien,
						Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);

				if (lsaninterv != null && lsaninterv.size() > 0) {
					saninterv = lsaninterv.get(0);
					saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
					this.sanintervDao.update(saninterv);
					this.sanexpService.actualizarParticipantPlatea(expedien,
							this.sanintervDao.dameSancionado(tramiteComun.getIdExpediente()), censoMonitor, false);
				} else {
					// buscamos representante
					lsaninterv = this.sanintervDao.findAllByTipo(expedien,
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

					// si no lo hay error
					if (lsaninterv == null || lsaninterv.size() == 0) {
						throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.sancionado", true,
								new Exception());
					}
				}

			}
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				// this.sugiereTramiteNotificacionAutomaticamente(santramexp,
				// null);

				this.actualizaBandeja(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteAux = new TramiteRecepcionRequerimientoAcreditacionRepresentacion();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setOrigen(santramexp.getTipoDestOrigen());
		tramiteAux.setRespuesta(santramexp.getTrrespuesta());
		tramiteAux.setResumenAlegaciones(Y41bUtils.clobToString(santramexp.getTrresumenalegaciones()));

		if (this.tratamientoSeguridad(santramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteResolucionSolicitudPrueba(TramiteSANResolucionSolicitudPrueba tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrresultado(tramite.getTipoResultado());

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				this.actualizaBandeja(santramexp);

			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANResolucionSolicitudPrueba findTramiteResolucionSolicitudPrueba(
			TramiteSANResolucionSolicitudPrueba tramite, CensoMonitor censoMonitor) {
		try {
			CensoMonitor censoMonitor2 = this.censoMonitorDao.find(censoMonitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANResolucionSolicitudPrueba tramiteAux = new TramiteSANResolucionSolicitudPrueba();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */
			tramiteAux.setTipoResultado(santramexp.getTrresultado());

			if (this.tratamientoSeguridad(santramexp, censoMonitor2)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANPropuestaResolucion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANPropuestaResolucion
	 */
	public TramiteSANPropuestaResolucion findTramitePropuestaResolucion(TramiteSANPropuestaResolucion tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANPropuestaResolucion tramiteAux = new TramiteSANPropuestaResolucion();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */

			tramiteAux.setFechaResolucion(santramexp.getTrresofecha());
			tramiteAux.setImporteSancion(santramexp.getTrresoimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));
			tramiteAux.setTipoSancionAccesoria(santramexp.getTrresosan());
			tramiteAux.setTipoResolucion(santramexp.getTrresotipo());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteSANPropuestaResolucion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramitePropuestaResolucion(TramiteSANPropuestaResolucion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			if (!this.compruebaSecuenciaFechasTramitacion(tramiteComun.getIdExpediente(),
					tramiteComun.getIdTipoTramite(), tramite.getFechaResolucion())) {
				throw new Y41bUDAException("error.validacion.fechasTramitacion", true, null);
			}
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		SantramexpServiceImpl.logger
				.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - Inicio " + tramite.toString());
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrresofecha(tramite.getFechaResolucion());
		santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporteSancion()) ? null
				: new BigDecimal(tramite.getImporteSancion().replace('\u002c', '\u002e')));
		santramexp.setTrresosan(tramite.getTipoSancionAccesoria());
		santramexp.setTrresotipo(tramite.getTipoResolucion());
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		List<Sandoctemp> listDocumentoAnteriores = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - Vamos a actualizar ");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				this.actualizaBandeja(santramexp);

				/*
				 * ELIMINO EL AVISO SOBRE LA PROPUESTA DE RESOLUCION, SOLO HABRA
				 * UNO
				 */
				SantramexpServiceImpl.logger.info(
						"SanbandejaDaoImpl - addTramitePropuestaResolucion - Elimino aviso sobre propuesta resolucion ");

				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}

				/*
				 * ELIMINO EL AVISO SOBRE PLAZO ALEGACIONES AI
				 */
				SantramexpServiceImpl.logger.info(
						"SanbandejaDaoImpl - addTramitePropuestaResolucion - Elimino aviso sobre propuesta resolucion ");

				sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC);
				listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}
			}
			SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - Fin ");

		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		if (Y41bConstantes.DECISION_SANCION_SANCION.equals(tramite.getTipoResolucion())) {
			this.enviarEmailRevisionDocumento(tramiteComun.getIdExpediente(), listDocumentoAnteriores,
					listDocumentoHecho, tramite.getInstructorEjecucion(),
					Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/* metodos de sara nuevos */
	/**
	 * Get a New PK Santramexp.
	 * 
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long getNewPK() {
		return this.santramexpDao.getNewPK();
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param idioma
	 *            String
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();

		santramexp.setTrid(tramiteComun.getIdTramite());

		Santramexp santramexpAux = this.santramexpDao.find(santramexp);
		if (santramexpAux != null) {
			santramexp = santramexpAux;
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());

		Sanexp sanexp = this.sanexpDao.find(new Sanexp(expedien.getExcodigo()));

		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		// 0169289: Estudio de la Integracin SIR
		if (null != tramite.getIsSIR() && "" != tramite.getIsSIR()) {
			santramexp.setTrIsSir(tramite.getIsSIR());
		}
		// 0169289: Estudio de la Integracin SIR
		if (null != tramite.getIsSIRConNumRegEntOri() && "" != tramite.getIsSIRConNumRegEntOri()) {
			santramexp.setTrIsSirConNumRegEntOri(tramite.getIsSIRConNumRegEntOri());
		}

		santramexp = this.setSantramexp(santramexp);
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		/*
		 * PROPIO DEL TRAMITE
		 */
		// Validacion: Debe haber almenos 1 documento
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllSanDocumentosTramite(tramiteComunAux, null);

		// boolean isAporteSancionado = false;
		// for (Sandoctemp documentoHecho : listDocumentoHecho) {
		// if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO
		// .equals(documentoHecho.getU5origen())
		// || Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO
		// .equals(documentoHecho.getU5origen())) {
		// isAporteSancionado = true;
		// break;
		// }
		// }

		if (modoEditar != "AR" && listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		/* los avisos se tratan aqui */
		if (tramitar) {

			if (Y41bConstantes.SI.equals(sanexp.getPlatea())) {
				this.actualizaExpedienteTrasAportacionDocumentacion(tramiteComunAux, sanexp, santramexp);

				// Subimos los documentos a dokusi
				this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
				/*
				 * al reves porque se puede haber sugerido el tramite de
				 * recepcion de recurso de alzada
				 */
				this.actualizaBandeja(santramexp);
				sanexp = this.actualizaUltimoTramiteEnSanExp(santramexp);

				listDocumentoHecho = this.sandoctempDao.findAllSanDocumentosTramite(tramiteComunAux, null);

				if (santramexp.getTristelematica() == null) {
					this.actualizarMisGestionesAportaciondocumentacion(santramexp, listDocumentoHecho);
				}

			} else {
				throw new Y41bUDAException("error.notramitable", true, new Exception());
			}

		} else {
			this.actualizaBandeja(santramexp);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor) {
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramiteAdjuntarDocs.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteAdjuntarDocs tramiteAux = new TramiteAdjuntarDocs();
		tramiteAux.setIdTramite(santramexp.getTrcodigo());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		tramiteAux.setIstelematico(santramexp.getTristelematica());
		tramiteAux.setIsSIR(santramexp.getTrIsSir());

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANRecepcionRecursoAlzada
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANRecepcionRecursoAlzada
	 */
	public TramiteSANRecepcionRecursoAlzada findTramiteSANRecepcionRecursoAlzada(
			TramiteSANRecepcionRecursoAlzada tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANRecepcionRecursoAlzada tramiteAux = new TramiteSANRecepcionRecursoAlzada();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */

			tramiteAux.setFechaRecurso(santramexp.getTrfecenvio());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			if (santramexp.getTruaidinterv() != null) {
				tramiteAux.setInterviniente(new Saninterv(santramexp.getTruaidinterv()));
			}
			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionRecursoAlzada(TramiteSANRecepcionRecursoAlzada tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		if (tramite.getInterviniente() != null) {
			santramexp.setTruaidinterv(tramite.getInterviniente().getUaidinterv());
		}
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrfecenvio(tramite.getFechaRecurso());
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);
		boolean tieneResolucionAcusada = this.existeNotificacionConAcuse(santramexp.getExpedien().getExcodigo());

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			}
			// EVOLUTIVO 135083 2.8 aniadimos condicion para verificar si tiene
			// una notificacion con acuse de recibo valido
			if (!tieneResolucionAcusada) {
				throw new Y41bUDAException("error.tramiteRecepcionRecursoAlzada.resolucionNoNotifi", true, null);
			}
			// EVOLUTIVO 135083 2.8
			else {
				/* CANCELAMOS EL AVISO DEL PLAZO DE RECURSO DE ALZADA */
				SantramexpServiceImpl.logger.info(
						"SanbandejaDaoImpl - addTramiteElaboracionInformeAsesoria - Elimino aviso sobre recurso de alzada ");
				Pagination pagination = new Pagination();
				pagination.setSort("BAFECLIMITE");
				pagination.setSord("ASC");

				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, pagination);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					// Borramos todos los avisos
					for (int i = 0; i < listaAvisosCancelar.size(); i++) {
						this.sanbandejaDao.remove(listaAvisosCancelar.get(i));
					}
				}

				/* seguerimos el tramite de elaboracion informe para asesoria */
				this.sugiereTramiteElaboracionInformeAsesoriaAutomaticamente(santramexp);
				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);
				this.actualizaExpedienteTrasTramitar(santramexp);

				this.actualizarMisGestiones(santramexp);
			}

		} else {
			this.actualizaBandeja(santramexp);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANApertura
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANApertura
	 */
	public TramiteSANApertura findTramiteSANApertura(TramiteSANApertura tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANApertura tramiteAux = new TramiteSANApertura();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */
			tramiteAux.setExpedien(santramexp.getExpedien());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteElaboracionInformeAsesoria(TramiteSANElaboracionInformeAsesoria tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrestimacion(tramite.getTipoEstimacion());
		santramexp.setTrfecenvio(tramite.getFechaEnvio());
		santramexp.setTrreconocimiento(tramite.getReconocimiento());
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				/* sugerimos una tarea de comunicacion para asesoria */
				/* crearia el saninterv de asesoria si no existe */
				try {
					Saninterv intervinienteAsesoria = this.obtenerCrearIntervinienteAsesoriaJuridica(tramiteComun);

					long uaidinterv = Long.parseLong(intervinienteAsesoria.getUaidinterv().toString());

					this.sugiereTramiteComunicacionAutomaticamente(santramexp, uaidinterv, true);
				} catch (Exception e) {
					throw new Y41bUDAException("error.tramiteElaboracionInformeAsesoria.parametroOrganismo", true,
							new Exception());
				}

				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);

			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;
	}

	private Saninterv obtenerCrearIntervinienteAsesoriaJuridica(TramiteComun tramiteComun) throws Exception {
		Saninterv resultado = null;
		Organismo organismoAsesoria = new Organismo();
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_SANCIONES_ID_ORGANISMO_ASESORIA);
		parametros = this.parametrosDao.find(parametros);

		String idEntidadOrganismoAsesoria = parametros.getValor();
		organismoAsesoria.setEntidadId(idEntidadOrganismoAsesoria);

		List<Organismo> lOrganismoAsesoria = this.organismoDao.findAll(organismoAsesoria, null);
		Saninterv nuevoSaninterv = null;
		Saninterv intervinienteExistente = null;
		if (lOrganismoAsesoria != null && lOrganismoAsesoria.size() > 0) {
			organismoAsesoria = lOrganismoAsesoria.get(0);
			nuevoSaninterv = this.sanintervDao.convierteOrganismoASanInterv(organismoAsesoria,
					new Expedien(tramiteComun.getIdExpediente()));
			intervinienteExistente = this.sanintervDao.findByTipoCodigoEntidad(
					new Expedien(tramiteComun.getIdExpediente()), nuevoSaninterv.getUatipointerv(),
					nuevoSaninterv.getUaentidad_id());
		}
		if (intervinienteExistente != null) {
			resultado = intervinienteExistente;
		} else {
			resultado = this.sanintervDao.add(nuevoSaninterv);
		}
		return resultado;
	}

	private Saninterv obtenerIntervinienteAsesoriaJuridica(TramiteComun tramiteComun) throws Exception {
		Saninterv resultado = null;
		Organismo organismoAsesoria = new Organismo();
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_SANCIONES_ID_ORGANISMO_ASESORIA);
		parametros = this.parametrosDao.find(parametros);

		String idEntidadOrganismoAsesoria = parametros.getValor();
		organismoAsesoria.setEntidadId(idEntidadOrganismoAsesoria);

		List<Organismo> lOrganismoAsesoria = this.organismoDao.findAll(organismoAsesoria, null);
		Saninterv nuevoSaninterv = null;
		Saninterv intervinienteExistente = null;
		if (lOrganismoAsesoria != null && lOrganismoAsesoria.size() > 0) {
			organismoAsesoria = lOrganismoAsesoria.get(0);
			nuevoSaninterv = this.sanintervDao.convierteOrganismoASanInterv(organismoAsesoria,
					new Expedien(tramiteComun.getIdExpediente()));
			intervinienteExistente = this.sanintervDao.findByTipoCodigoEntidad(
					new Expedien(tramiteComun.getIdExpediente()), nuevoSaninterv.getUatipointerv(),
					nuevoSaninterv.getUaentidad_id());
		}
		if (intervinienteExistente != null) {
			resultado = intervinienteExistente;
		}
		return resultado;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANElaboracionInformeAsesoria
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANElaboracionInformeAsesoria
	 */
	public TramiteSANElaboracionInformeAsesoria findTramiteSANElaboracionInformeAsesoria(
			TramiteSANElaboracionInformeAsesoria tramite, CensoMonitor monitor) {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteSANElaboracionInformeAsesoria tramiteAux = new TramiteSANElaboracionInformeAsesoria();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setTipoEstimacion(santramexp.getTrestimacion());
		tramiteAux.setFechaEnvio(santramexp.getTrfecenvio());
		tramiteAux.setReconocimiento(santramexp.getTrreconocimiento());
		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionOrdenConsejero(TramiteSANRecepcionOrdenConsejero tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			boolean resolucionProntoPago = false;
			Santramexp resolucion = new Santramexp();
			resolucion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
			resolucion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			resolucion.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			Pagination pagination = new Pagination();
			pagination.setSort("TRID");
			pagination.setAscDsc("desc");
			List<Santramexp> lresolucion = this.santramexpDao.findAll(resolucion, pagination);
			if (lresolucion != null && lresolucion.size() > 0) {
				for (int i = 0; i < lresolucion.size(); i++) {
					resolucion = lresolucion.get(i);
					if (Y41bConstantes.VALOR_SI.equals(resolucion.getTrprontopago())) {
						resolucionProntoPago = true;
						break;
					}
				}
			}
			if (!resolucionProntoPago) {
				if (!this.compruebaSecuenciaFechasTramitacion(tramiteComun.getIdExpediente(),
						tramiteComun.getIdTipoTramite(), tramite.getFechaOrden())) {
					throw new Y41bUDAException("error.validacion.fechasTramitacion", true, null);
				}
			}
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrestimacion(tramite.getTipoEstimacion());
		santramexp.setTrresofecha(tramite.getFechaOrden());
		santramexp.setTrresotipo(tramite.getTipoResolucion());

		if (String.valueOf(Y41bConstantes.DECISION_SANCION_SANCION).equals(tramite.getTipoResolucion())
		/*
		 * && (String.valueOf(Y41bConstantes.SAN_ESTIMACION_PARCIAL)
		 * .equals(tramite.getTipoEstimacion()) || String.valueOf(
		 * Y41bConstantes.SAN_ESTIMACION_TOTAL).equals(
		 * tramite.getTipoEstimacion()))
		 */) {
			santramexp.setTrresosan(Y41bUtils.esNullOCadenaVacia(tramite.getSancionAccesoria()) ? null
					: new BigDecimal(tramite.getSancionAccesoria()));
			santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporte()) ? null
					: new BigDecimal(tramite.getImporte().replace('\u002c', '\u002e')));
		} else {
			santramexp.setTrresosan(null);
			santramexp.setTrresoimporte(null);
		}

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			/*
			 * SI ES SANCION SUGIERE AUTOMATICAMENTE EL TRAMITE DE LIQUIDACION
			 * SI NO ES SANCION, NOTIFICA AUTOMATICAMENTE LA ORDEN DEL CONSEJERO
			 */
			if (tramite.getTipoResolucion() != null
					&& Y41bConstantes.DECISION_SANCION_SANCION.equals(tramite.getTipoResolucion())) {

				// 0177075: Recepcin orden del consejero INADMISIN: No generar
				// liquidacin cuando ya est en apremio
				// si el tipo de estimacion es igual a 3 (Desestimacion) que no
				// sugiera tramite de liquidacin para todo lo demas como
				// siempre
				if (!("3".equals(tramite.getTipoEstimacion())
						&& this.expedienteTienePagosViaApremio(tramiteComun.getIdExpediente()))) {
					this.sugiereTramiteLiquidacionAutomaticamente(santramexp);
				}

			} else {
				/* sugerimos una tarea de notificacion para cada sancionado */

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);
			}

			/* MATO EL AVISO */
			SantramexpServiceImpl.logger.info(
					"SanbandejaDaoImpl - actualizaTrasAportacionDocumentacion - Elimino aviso sobre remisión a asesoria al recoger el informe del consejero ");
			Pagination pagination = new Pagination();
			pagination.setSort("BAFECLIMITE");
			pagination.setSord("ASC");
			Sanbandeja sanbandeja = new Sanbandeja();
			sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
			sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_REMISION_ASESORI);
			List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, pagination);
			if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
				this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
			}

			this.actualizaBandeja(santramexp);
			this.actualizaUltimoTramiteEnSanExp(santramexp);
			this.actualizaExpedienteTrasTramitar(santramexp);
		} else {
			this.actualizaBandeja(santramexp);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANRecepcionOrdenConsejero
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANRecepcionOrdenConsejero
	 */
	public TramiteSANRecepcionOrdenConsejero findTramiteSANRecepcionOrdenConsejero(
			TramiteSANRecepcionOrdenConsejero tramite, CensoMonitor monitor) {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteSANRecepcionOrdenConsejero tramiteAux = new TramiteSANRecepcionOrdenConsejero();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setTipoEstimacion(santramexp.getTrestimacion());
		tramiteAux.setFechaOrden(santramexp.getTrresofecha());
		tramiteAux.setTipoResolucion(santramexp.getTrresotipo() == null ? "" : santramexp.getTrresotipo().toString());
		tramiteAux.setSancionAccesoria(santramexp.getTrresosan() == null ? "" : santramexp.getTrresosan().toString());
		tramiteAux.setImporte(santramexp.getTrresoimporte() == null ? ""
				: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;

	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tramiteNotificacion
	 *            the tramitenotificacion
	 * @param fechaAcuse
	 *            the fecha acuse
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void actualizaExpedienteTrasAcusar(String excodigo, Santramexp tramiteNotificacion, Date fechaAcuse)
			throws Exception {

		try {

			if (tramiteNotificacion.getTrtridrel() != null) {
				Santramexp tramiteOriginal = new Santramexp();
				tramiteOriginal.setTrid(tramiteNotificacion.getTrtridrel());
				tramiteOriginal = this.santramexpDao.find(tramiteOriginal);

				String codigoTipoTramite = tramiteOriginal.getTrcodigo();

				Expedien expedien = new Expedien();
				expedien.setExcodigo(excodigo);
				expedien = this.expedienDao.find(expedien);

				Sanexp sanexp = new Sanexp();
				sanexp.setExcodigo(excodigo);

				if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(codigoTipoTramite)) {
					expedien.setExfenopr(fechaAcuse);
					this.expedienDao.update(expedien);
					// Solo se actualiza la fecha de modificacion
					this.sanexpDao.updateSanexpFechaModificacion(sanexp);
				} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(codigoTipoTramite)) {
					Recurso recurso = new Recurso();
					recurso.setExpedien(new Expedien(excodigo));
					Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
					if (cuantosRecursos > 0) {
						List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
						if (recursosLista != null && recursosLista.size() > 0) {
							recurso = recursosLista.get(0);
							recurso.setRefenrro(fechaAcuse);
							this.recursoDao.update(recurso);
						}
					} else {
						recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						recurso.setRefenrro(fechaAcuse);
						this.recursoDao.add(recurso);
					}
				} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(codigoTipoTramite)) {
					expedien.setExfenore(fechaAcuse);
					this.expedienDao.update(expedien);
					// Solo se actualiza la fecha de modificacion
					if (sanexp != null) {
						this.sanexpDao.updateSanexpFechaModificacion(sanexp);
					}
				} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION.equals(codigoTipoTramite)) {
					/*
					 * AL REALIZAR LA LIQUIDACION SOLO ACTUALIZAMOS EL
					 * EXPEDIENTE SI ESTA RELACIONADA
					 */

					String tridrelliquidacion = tramiteOriginal.getTrtridrel();
					Santramexp tramiteRelLiquidacion = this.santramexpDao.find(new Santramexp(tridrelliquidacion));

					if (tramiteRelLiquidacion != null
							&& (tramiteRelLiquidacion.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)
									|| tramiteRelLiquidacion.getTrcodigo()
											.equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO))) {
						expedien.setExfenore(fechaAcuse);
						this.expedienDao.update(expedien);
						// Solo se actualiza la fecha de modificacion
						if (sanexp != null) {
							this.sanexpDao.updateSanexpFechaModificacion(sanexp);
						}
					}

					if (tramiteRelLiquidacion != null && tramiteRelLiquidacion.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO)) {
						Recurso recurso = new Recurso();
						recurso.setExpedien(new Expedien(excodigo));
						Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
						if (cuantosRecursos > 0) {
							List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
							if (recursosLista != null && recursosLista.size() > 0) {
								recurso = recursosLista.get(0);
								recurso.setRefenrro(fechaAcuse);
								this.recursoDao.update(recurso);
							}
						} else {
							recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
							recurso.setRefenrro(fechaAcuse);
							this.recursoDao.add(recurso);
						}
					}
				} else if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(codigoTipoTramite)) {
					/* fecha de la notificacion */
					expedien.setExfenoai(fechaAcuse);
					this.expedienDao.update(expedien);
					// Solo se actualiza la fecha de modificacion
					if (sanexp != null) {
						this.sanexpDao.updateSanexpFechaModificacion(sanexp);
					}
				}

			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public void actualizaExpedienteTrasTramitar(Santramexp santramexp) throws Exception {

		try {

			String codigoTipoTramite = santramexp.getTrcodigo();

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);
			if (sanexp != null) {
				Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
				if (sanexpAux != null) {
					sanexp.setHdte(sanexpAux.getHdte());
				}
			}

			if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL ACUERDO DE INICIO */
				expedien.setExfeacin(santramexp.getTrfecacini());
				expedien.setExfenoai(null);// Vaciamos fecha de acuse
				this.expedienDao.update(expedien);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(codigoTipoTramite)) {
				/* AL REALIZAR LA PROPUESTA DE RESOLUCION */
				sanexp.setExfecpropreso(santramexp.getTrresofecha());
				expedien.setExfenopr(null); // Vaciamos fecha de acuse
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(codigoTipoTramite)) {
				/* AL REALIZAR LA RESOLUCION */
				expedien.setExferes(santramexp.getTrresofecha());
				expedien.setExfenore(null);// Vaciamos fecha de acuse
				expedien.setExcamure(santramexp.getTrresoimporte());
				if (santramexp.getTrresotipo() != null) {
					if (santramexp.getTrresotipo().toString().equals(Y41bConstantes.DECISION_SANCION_SANCION)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOMULTA);
					} else if (santramexp.getTrresotipo().toString()
							.equals(Y41bConstantes.DECISION_SANCION_SOBRESEIMIENTO)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOOBRESEIMIENTO);
					} else if (santramexp.getTrresotipo().toString()
							.equals(Y41bConstantes.DECISION_SANCION_CADUCIDAD)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOCADUCIDAD);
					} else if (santramexp.getTrresotipo().toString().equals(Y41bConstantes.DECISION_SANCION_ERROR)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOARCHIVO);
					}
				}
				expedien = this.expedienDao.update(expedien);
				if (santramexp.getTrresoimporte() != null) {
					sanexp.setEximporte(santramexp.getTrresoimporte().toString());
				}
				sanexp.setExtipres(santramexp.getTrresotipo().toString());
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION.equals(codigoTipoTramite)) {
				/*
				 * AL REALIZAR LA LIQUIDACION SOLO ACTUALIZAMOS EL EXPEDIENTE SI
				 * ESTA RELACIONADA
				 */
				if (santramexp.getTrcodigorel() != null
						&& (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigorel())
								|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
										.equals(santramexp.getTrcodigorel())
								|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
										.equals(santramexp.getTrcodigorel()))) {
					expedien.setExcamure(santramexp.getTrresoimporte());
					Pagos pagos = new Pagos();
					pagos.setSgidexpediente(expedien.getExcodigo());
					pagos.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
					Pagination paginacion = new Pagination();
					paginacion.setSord("desc");
					paginacion.setSort("SGFECHAESTADO");
					List<Pagos> listaPagos = this.pagosDao.findAll(pagos, paginacion);
					if (listaPagos != null && listaPagos.size() > 0) {
						pagos = listaPagos.get(0);
						/*
						 * hemos tenido que agrandar el campo a 22 por si no
						 * entraba el resultado de esta concatenacion
						 */
						String numLiquidacionMultaExpSancionador = pagos.getSgdigitocontrol() + pagos.getSgreferencia();
						expedien.setExnuinlm(numLiquidacionMultaExpSancionador);
					}
					this.expedienDao.update(expedien);
					if (santramexp.getTrresoimporte() != null) {
						sanexp.setEximporte(santramexp.getTrresoimporte().toString());
					}
					this.sanexpDao.update(sanexp);
				}
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL RECURSO DE ALZADA */

				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos > 0) {
					List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
					if (recursosLista != null && recursosLista.size() > 0) {
						recurso = recursosLista.get(0);
						recurso.setRefereor(santramexp.getTrfecenvio());
						this.recursoDao.update(recurso);
					}
				} else {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setRefereor(santramexp.getTrfecenvio());
					this.recursoDao.add(recurso);
				}
				sanexp.setExrecurso(Y41bConstantes.SI);
				this.sanexpDao.update(sanexp);

			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(codigoTipoTramite)) {
				/* AL REALIZAR LA RECEPCION DE ORDEN DEL CONSEJERO */
				expedien.setExferes(santramexp.getTrresofecha());
				expedien.setExcamure(santramexp.getTrresoimporte());
				if (santramexp.getTrresotipo() != null) {
					if (santramexp.getTrresotipo().toString().equals(Y41bConstantes.DECISION_SANCION_SANCION)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOMULTA);
					} else if (santramexp.getTrresotipo().toString()
							.equals(Y41bConstantes.DECISION_SANCION_SOBRESEIMIENTO)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOOBRESEIMIENTO);
					} else if (santramexp.getTrresotipo().toString()
							.equals(Y41bConstantes.DECISION_SANCION_CADUCIDAD)) {
						expedien.setExcottr(Y41bConstantes.SAN_TIPORESOLUCION_VALORANTIGUOCADUCIDAD);
					}
				}
				expedien = this.expedienDao.update(expedien);

				BigDecimal importe = santramexp.getTrresoimporte();

				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				// Solo debiera haber uno
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos > 0) {
					List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
					if (recursosLista != null && recursosLista.size() > 0) {
						recurso = recursosLista.get(0);
						recurso.setRecamrro(importe);
						recurso.setReferero(santramexp.getTrresofecha());
						this.recursoDao.update(recurso);
					}
				} else {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setRecamrro(importe);
					recurso.setReferero(santramexp.getTrresofecha());
					this.recursoDao.add(recurso);
				}
				sanexp.setEximporte(importe == null ? null : importe.toString());
				if (santramexp.getTrresotipo() != null) {
					sanexp.setExtipres(santramexp.getTrresotipo().toString());
				}
				sanexp.setExorden(Y41bConstantes.SI);
				this.sanexpDao.update(sanexp);

			} else if (Y41bConstantes.TRAMITE_SANCIONES_CIERRE.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL CIERRE */
				expedien.setExfear(santramexp.getTrfeccierre());
				this.expedienDao.update(expedien);
				sanexp.setExfecfin(santramexp.getTrfeccierre());
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA.equals(codigoTipoTramite)) {
				// Propuesta estimacion
				sanexp.setExestimacion(santramexp.getTrestimacion());
				// Fecha envio
				sanexp.setExfecenvio(santramexp.getTrfecenvio());
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL RECURSO DE ALZADA */

				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos > 0) {
					List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
					if (recursosLista != null && recursosLista.size() > 0) {
						recurso = recursosLista.get(0);
						recurso.setReferere(santramexp.getTrfecenvio());
						this.recursoDao.update(recurso);
					}
				} else {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setReferere(santramexp.getTrfecenvio());
					this.recursoDao.add(recurso);
				}
				sanexp.setExrecurso(Y41bConstantes.SI);
				this.sanexpDao.update(sanexp);

			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void actualizaExpedienteTrasEliminar(Santramexp santramexp) throws Exception {

		try {

			String codigoTipoTramite = santramexp.getTrcodigo();

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);
			if (sanexp != null) {
				Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
				if (sanexpAux != null) {
					sanexp.setHdte(sanexpAux.getHdte());
				}
			}

			if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(codigoTipoTramite)) {
				expedien.setExfeacin(null);
				expedien.setExfenoai(null);// Vaciamos fecha de acuse
				this.expedienDao.update(expedien);
				// Solo se actualiza la fecha de modificacion
				this.sanexpDao.updateSanexpFechaModificacion(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(codigoTipoTramite)) {
				expedien.setExfenopr(null);// Vaciamos fecha de acuse
				this.expedienDao.update(expedien);
				sanexp.setExfecpropreso(null);
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(codigoTipoTramite)) {
				/* AL REALIZAR LA RESOLUCION */
				expedien.setExferes(null);
				expedien.setExfenore(null);// Vaciamos fecha de acuse
				expedien.setExcamure(null);
				expedien.setExcottr(null);
				expedien = this.expedienDao.update(expedien);
				sanexp.setEximporte(null);
				sanexp.setExtipres(null);
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(codigoTipoTramite)) {
				Recurso recurso = new Recurso();
				recurso.setExpedien(santramexp.getExpedien());
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos > 0) {
					List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
					if (recursosLista != null && recursosLista.size() > 0) {
						recurso = recursosLista.get(0);
						recurso.setRefereor(null);
						this.recursoDao.update(recurso);
					}
				}
				sanexp.setExrecurso(Y41bConstantes.NO);
				this.sanexpDao.update(sanexp);

			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(codigoTipoTramite)) {
				Recurso recurso = new Recurso();
				recurso.setExpedien(santramexp.getExpedien());
				recurso = this.recursoDao.find(recurso);
				if (recurso != null) {
					recurso.setRecamrro(null);
					recurso.setReferero(null);
					this.recursoDao.update(recurso);
				}
				sanexp.setEximporte(null);
				sanexp.setExorden(Y41bConstantes.NO);
				this.sanexpDao.update(sanexp);

			} else if (Y41bConstantes.TRAMITE_SANCIONES_CIERRE.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL CIERRE */
				expedien.setExfear(null);
				this.expedienDao.update(expedien);
				sanexp.setExfecfin(null);
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA.equals(codigoTipoTramite)) {
				// Propuesta estimacion
				sanexp.setExestimacion(null);
				// Fecha envio
				sanexp.setExfecenvio(null);
				this.sanexpDao.update(sanexp);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO.equals(codigoTipoTramite)) {
				/* AL REALIZAR EL RECURSO DE ALZADA */

				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos > 0) {
					List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
					if (recursosLista != null && recursosLista.size() > 0) {
						recurso = recursosLista.get(0);
						recurso.setReferere(santramexp.getTrfecenvio());
						this.recursoDao.update(recurso);
					}
				} else {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setReferere(santramexp.getTrfecenvio());
					this.recursoDao.add(recurso);
				}
				sanexp.setExrecurso(Y41bConstantes.SI);
				this.sanexpDao.update(sanexp);

			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente
	 * 
	 * @param santramexpTramiteNotificacion
	 *            Santramexp
	 * @param fechaAcuse
	 *            Date
	 * @throws Exception
	 *             Exception
	 */

	private void actualizaEnvios(Santramexp santramexpTramiteNotificacion, Date fechaAcuse) throws Exception {
		try {
			// Siempre que hay un acuse se debe actualizar el envio
			// if (santramexpTramiteNotificacion.getTrtridrel() != null) {
			Santramexp tramiteOriginal = new Santramexp();
			tramiteOriginal.setTrid(santramexpTramiteNotificacion.getTrtridrel());
			tramiteOriginal = this.santramexpDao.find(tramiteOriginal);

			Sanenvio sanenvio = new Sanenvio();
			sanenvio.setSantramexpByEntrid(new Santramexp(santramexpTramiteNotificacion.getTrid()));
			Long numeroEnvios = this.sanenvioDao.findAllCount(sanenvio);
			List<Sanenvio> enviosNotificacion = this.sanenvioDao.findAll(sanenvio, null);
			if (enviosNotificacion != null) {
				if (numeroEnvios.intValue() > 1) {
					// Borramos todos menos 1
					for (int i = 1; i < enviosNotificacion.size(); i++) {
						sanenvio = enviosNotificacion.get(i);
						this.sanenvioDao.remove(sanenvio);
					}
				}
				if (enviosNotificacion.size() > 0) {
					// Actualizamos el primero de la lista
					sanenvio = enviosNotificacion.get(0);
					sanenvio = this.sanenvioDao.find(sanenvio);
					if (tramiteOriginal != null) {
						sanenvio.setSantramexpByEntridacuse(new Santramexp(tramiteOriginal.getTrid()));
					}
					sanenvio.setEnfecacuse(fechaAcuse);
					sanenvio.setEnestado(Y41bConstantes.SAN_ESTADO_ENVIO_RECOGIDO);
					sanenvio = this.sanenvioDao.update(sanenvio);
				}
			}
			// }
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param tramiteComun
	 *            the tramite comun aux
	 * @param sanexp
	 *            the sanexp
	 * @param santramexp
	 *            the santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void actualizaExpedienteTrasAportacionDocumentacion(TramiteComun tramiteComun, Sanexp sanexp,
			Santramexp santramexp) throws Exception {
		try {

			List<Sandoctemp> documentosAportados = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
			String fase = "";
			boolean hayRecurso = false;
			boolean hayOrdenConsejero = false;
			boolean hayRecursoExtraordinario = false;
			boolean hayResolucionASolicitudPrueba = false;
			boolean hayRecursoAceptacionDenegacion = false;
			boolean haySolicitudPlazoAlegaciones = false;
			boolean haySolicitudExpedienteJuzgado = false;
			Date fechaEntrada = null;
			boolean hayAlegacionAI = false;
			boolean hayAlegacionPropuesta = false;
			boolean hayAlegacionResolucionPrueba = false;
			boolean haySolicitudReduccion = false;
			boolean hayRecepcionRequerimientoAcreditacion = false;
			// EVOLUTIVO 0135083 2.5
			boolean hayDocumentosAportadosRequerimiento = false;
			Date fechaSolicitudReduccion = null;
			if (documentosAportados != null) {
				for (int i = 0; i < documentosAportados.size(); i++) {
					Sandoctemp sandoc = (Sandoctemp) documentosAportados.get(i);
					String tipoDocumento = sandoc.getU5tipodocumento();
					if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUDPRUEBA.equals(tipoDocumento)) {
						if ("".equals(fase)
								|| (Integer.parseInt(fase) < Integer.parseInt(Y41bConstantes.FASE_PRUEBAS_SANCION))) {
							fase = Y41bConstantes.FASE_PRUEBAS_SANCION;
						}
						hayResolucionASolicitudPrueba = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO.equals(tipoDocumento)) {
						if ("".equals(fase)
								|| (Integer.parseInt(fase) <= Integer.parseInt(Y41bConstantes.FASE_RECURSO_SANCION))) {
							fase = Y41bConstantes.FASE_RECURSO_SANCION;
							hayRecurso = true;
							if (fechaEntrada == null || fechaEntrada.compareTo(sandoc.getU5fechaentrada()) < 0) {
								fechaEntrada = sandoc.getU5fechaentrada();
							}
						}
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO.equals(tipoDocumento)) {
						hayOrdenConsejero = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO_ACEPTACION_DENEGACION
							.equals(tipoDocumento)) {
						hayRecursoAceptacionDenegacion = true;
						hayAlegacionResolucionPrueba = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_AMPLIACION_PLAZO_ALEGACIONES
							.equals(tipoDocumento)) {
						haySolicitudPlazoAlegaciones = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_EXPEDIENTE_JUZGADO
							.equals(tipoDocumento)) {
						haySolicitudExpedienteJuzgado = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_ACUERDO_INCOACION
							.equals(tipoDocumento)) {
						hayAlegacionAI = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_PROPUESTA_RESOLUCION
							.equals(tipoDocumento)) {
						hayAlegacionPropuesta = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_REDUCCION
							.equals(tipoDocumento)) {
						haySolicitudReduccion = true;
						fechaSolicitudReduccion = sandoc.getU5fecharegistroorigen() == null ? sandoc.getU5fechaentrada()
								: sandoc.getU5fecharegistroorigen();
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ACREDITACION_REPRESENTACION
							.equals(tipoDocumento)) {
						hayRecepcionRequerimientoAcreditacion = true;
					} // EVOLUTIVO 0135083 2.5 nuevo entrada, en caso de
						// tramitar
						// el tramite de aportacion de documentos con documentos
						// aportados de tipo "Requerimiento", incorporar dichos
						// documentos al tramite de recpecion de requerimiento
						// pendiente mas moderno
					else if (Y41bConstantes.TIPO_DOC_SAN_REQ_ENTRADA.equals(tipoDocumento)) {
						hayDocumentosAportadosRequerimiento = true;
					} else if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSOEXTRAORDINARIO
							.equals(tipoDocumento)) {
						// if ("".equals(fase)
						// || (Integer.parseInt(fase) <=
						// Integer.parseInt(Y41bConstantes.FASE_RECURSO_SANCION)))
						// {
						// fase = Y41bConstantes.FASE_RECURSO_SANCION;
						hayRecursoExtraordinario = true;
						if (fechaEntrada == null || fechaEntrada.compareTo(sandoc.getU5fechaentrada()) < 0) {
							fechaEntrada = sandoc.getU5fechaentrada();
						}
						// }
					}
				}
			}
			if ((!"".equals(fase))) {
				this.actualizaFaseEnSanExpDesdeAportacion(sanexp.getExcodigo(), fase);
			}

			Expedien expedien = new Expedien();
			expedien.setExcodigo(sanexp.getExcodigo());
			expedien = this.expedienDao.find(expedien);

			this.expedienDao.update(expedien);

			// Solo se actualiza la fecha de modificacion
			this.sanexpDao.updateSanexpFechaModificacion(sanexp);

			String duenioExp = sanexp.getExmocodigo();
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(duenioExp);
			censoMonitor = this.censoMonitorDao.find(censoMonitor);

			if (hayRecurso) {
				this.sugiereTramiteRecursoAutomaticamente(santramexp);

				// Insert en la tabla recurso
				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(sanexp.getExcodigo()));
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos == 0) {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setRefereor(santramexp.getTrfecenvio());
					this.recursoDao.add(recurso);
				}

				// Aviso
				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}

			}

			if (hayRecursoExtraordinario) {
				this.sugiereTramiteRecursoAutomaticamenteExtraordinario(santramexp);

				// Insert en la tabla recurso
				Recurso recurso = new Recurso();
				recurso.setExpedien(new Expedien(sanexp.getExcodigo()));
				Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
				if (cuantosRecursos == 0) {
					recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					recurso.setReferere(santramexp.getTrfecenvio());
					this.recursoDao.add(recurso);
				}

				// Aviso
				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}

			}

			if (hayOrdenConsejero) {
				this.sugiereTramiteOrdenConsejero(santramexp, true);
			}

			if (hayResolucionASolicitudPrueba) {
				this.sugiereTramiteResolucionSolicitudPrueba(santramexp);
			}
			if (hayRecursoAceptacionDenegacion) {
				this.sugiereTramiteResolucionRecursoSolicitudPrueba(santramexp);
			}
			if (haySolicitudPlazoAlegaciones) {
				this.sugiereTramiteSolicitudPlazoAlegaciones(santramexp);
			}
			if (haySolicitudExpedienteJuzgado) {
				// Sugerimos una comunicacin por cada aporte de ese tipo
				// Lo normal es que haya una pero puede haber ms
				for (int i = 0; i < documentosAportados.size(); i++) {
					Sandoctemp sandoctemp = (Sandoctemp) documentosAportados.get(i);
					// El documento Solicitud de expediente a juzgado genera una
					// comunicacin y si es posible (Un nico interviniente de
					// ese tipo
					// en el expediente) se guarda el id
					if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_EXPEDIENTE_JUZGADO
							.equals(sandoctemp.getU5tipodocumento())) {
						Intervinientes saninterv = new Intervinientes();
						saninterv.setIdExpediente(expedien.getExcodigo());
						if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE.equals(sandoctemp.getU5origen())) {
							saninterv.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
						} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO.equals(sandoctemp.getU5origen())
								|| Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO
										.equals(sandoctemp.getU5origen())) {
							saninterv.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
						} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS.equals(sandoctemp.getU5origen())) {
							saninterv.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_OTRO);
						} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2.equals(sandoctemp.getU5origen())) {
							saninterv.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
						} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_ESTABLECIMIENTO
								.equals(sandoctemp.getU5origen())) {
							saninterv.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO);
						}
						List<Intervinientes> lSaninterv = this.sanintervDao.findAllIntervinientes(saninterv, null);
						if (lSaninterv != null && lSaninterv.size() == 1) {
							this.sugiereTramiteComunicacionAutomaticamente(santramexp,
									Long.parseLong(lSaninterv.get(0).getIdinterviniente()), false);
						} else {
							this.sugiereTramiteComunicacionAutomaticamente(santramexp, 0, false);
						}

					}
				}

			}

			if (hayAlegacionAI) {
				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}
			}
			if (hayAlegacionPropuesta) {
				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}
			}
			if (hayAlegacionResolucionPrueba) {
				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger
							.info("SanbandejaDaoImpl - addTramitePropuestaResolucion - ELIMINADO. ");
				}
			}
			// Solo se genera el tramite de recepcion de solicitud de reduccion
			// si todavia no hay resolucin
			if (haySolicitudReduccion && expedien.getExferes() == null) {
				this.sugiereTramiteRecepcionSolicitudReduccion(santramexp, fechaSolicitudReduccion);
			}
			if (hayRecepcionRequerimientoAcreditacion) {
				this.sugiereTramiteRecepcionRequerimientoAcreditacion(santramexp, tramiteComun);
			}
			// EVOLUTIVO 0135083 2.5
			if (hayDocumentosAportadosRequerimiento) {
				this.incorporaDocTramiteRecepcionReqInd(santramexp);
			}
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void insertEnvios(Santramexp santramexp) throws Exception {
		try {
			/*
			 * recibo como parámetro el tramite de notificacion que acaba deadd
			 * completarse
			 */

			// BigDecimal idTramiteRelacionado = santramexp.getTrtridrel();
			Sanenvio sanenvio = new Sanenvio();

			// if (idTramiteRelacionado != null) {
			// Santramexp santramexpTramiteNotificado = new Santramexp();
			// santramexpTramiteNotificado.setTrid(idTramiteRelacionado);
			// santramexpTramiteNotificado = this.santramexpDao
			// .find(santramexpTramiteNotificado);
			// /* asi sabemos que tramite es el que se estaba notificando */
			// /* y su tipologia */
			// sanenvio.setSantramexpByEntrid(santramexpTramiteNotificado);
			// } else {
			// sanenvio.setSantramexpByEntrid(santramexp);
			// }
			if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION)) {
				sanenvio.setEnestado(Y41bConstantes.SAN_ESTADO_ENVIO_RECOGIDO);
				sanenvio.setEnfecenvio(new Date());
				sanenvio.setEntipoenvio(santramexp.getTrtipocom());
			} else {
				sanenvio.setEnestado(Y41bConstantes.SAN_ESTADO_ENVIO_ENVIADO);
				sanenvio.setEnfecenvio(santramexp.getTrfecnotif());
				sanenvio.setEntipoenvio(santramexp.getTrtiponot());
			}
			sanenvio.setSantramexpByEntrid(santramexp);
			sanenvio.setExpedien(santramexp.getExpedien());
			BigDecimal idInterv = santramexp.getTruaidinterv();
			sanenvio.setSaninterv(new Saninterv(idInterv));

			sanenvio = this.sanenvioDao.add(sanenvio);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * getDatosSancion para sugerir en la resolucion y la liquidacion.
	 * 
	 * @param idExpediente
	 *            the id expediente
	 * @return the Santramexp resolucion
	 */
	public Santramexp getDatosSancion(String idExpediente, String codigoTramite) {
		Santramexp santramexp = new Santramexp();
		// Buscamos si hay resolucion con sancin
		Santramexp santramexp_reso = new Santramexp();
		santramexp_reso.setExpedien(new Expedien(idExpediente, null, null, null, null, null, null, null, null));
		santramexp_reso.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
		santramexp_reso.setTrresotipo((Y41bConstantes.DECISION_SANCION_SANCION));
		santramexp_reso.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECFIN");
		pagination.setSord("DESC");
		List<Santramexp> lista_santramexp_reso = this.santramexpDao.findAll(santramexp_reso, pagination);
		if (lista_santramexp_reso != null && lista_santramexp_reso.size() > 0) {
			santramexp_reso = lista_santramexp_reso.get(0);
			santramexp = calcularDatosReduccion(santramexp_reso, pagination, codigoTramite);
		} else {
			// Buscamos si hay propuesta, no hay resolucin con lo que no se ha
			// pagado por pronto pago
			Santramexp santramexp_propreso = new Santramexp();
			santramexp_propreso.setExpedien(new Expedien(idExpediente, null, null, null, null, null, null, null, null));
			santramexp_propreso.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
			santramexp_propreso.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			List<Santramexp> lista_santramexp_propreso = this.santramexpDao.findAll(santramexp_propreso, pagination);
			if (lista_santramexp_propreso != null && lista_santramexp_propreso.size() > 0) {
				santramexp_propreso = lista_santramexp_propreso.get(0);
				santramexp = calcularDatosReduccion(santramexp_propreso, pagination, codigoTramite);
				if (santramexp == null) {
					// Buscamos si hay acuerdo de incoacion
					Santramexp santramexp_acuerdoincoacion = new Santramexp();
					santramexp_acuerdoincoacion
							.setExpedien(new Expedien(idExpediente, null, null, null, null, null, null, null, null));
					santramexp_acuerdoincoacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
					santramexp_acuerdoincoacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					santramexp = calcularDatosReduccion(santramexp_acuerdoincoacion, pagination, codigoTramite);
				}
			} else {
				// Buscamos si hay acuerdo de incoacion
				Santramexp santramexp_acuerdoincoacion = new Santramexp();
				santramexp_acuerdoincoacion
						.setExpedien(new Expedien(idExpediente, null, null, null, null, null, null, null, null));
				santramexp_acuerdoincoacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
				santramexp_acuerdoincoacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				santramexp = calcularDatosReduccion(santramexp_acuerdoincoacion, pagination, codigoTramite);
			}
		}
		return santramexp;
	}

	/**
	 * 
	 * @param santramexpAux
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return Santramexp
	 */
	private Santramexp calcularDatosReduccion(Santramexp santramexpAux, Pagination pagination, String codigoTramite) {
		Santramexp santramexp = null;
		List<Santramexp> lista_santramexp = this.santramexpDao.findAll(santramexpAux, pagination);
		if (lista_santramexp != null && lista_santramexp.size() > 0) {
			santramexp = lista_santramexp.get(0);
			BigDecimal importe = null;
			if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals((santramexp.getTrcodigo()))) {
				importe = santramexp.getTrresoimporte();
			} else if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals((santramexp.getTrcodigo()))
					|| Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals((santramexp.getTrcodigo()))) {
				importe = santramexp.getTrimporteinicial();
			}
			santramexp.setTrimporteinicial(importe);
			Santramexp solicitudReduccion = new Santramexp();
			solicitudReduccion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
			solicitudReduccion.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			List<Santramexp> lsolicitudReduccion = this.santramexpDao.findAll(solicitudReduccion, pagination);
			if (lsolicitudReduccion != null && lsolicitudReduccion.size() > 0) {
				solicitudReduccion = lsolicitudReduccion.get(0);
				if (importe != null) {
					santramexp.setTrimporteinicial(importe);
					// Calculamos el descuento
					Parametros parametros = new Parametros();
					BigDecimal reduccion1 = new BigDecimal(0);
					BigDecimal reduccion2 = new BigDecimal(0);
					if (Y41bConstantes.VALOR_SI.equals(solicitudReduccion.getTrprontopago())) {
						if (codigoTramite.equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
							PagosBusqueda pagosBusqueda = new PagosBusqueda();
							pagosBusqueda.setSgidexpediente(santramexp.getExpedien().getExcodigo());
							pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
							List<Pagos> listaPagos = pagosDao.findAllPagos(pagosBusqueda, null);
							Pagos pagos = null;
							if (listaPagos != null && listaPagos.size() > 0) {
								pagos = listaPagos.get(0);
								if (pagos.getEstadopago().getSacodigo().equals(Y41bConstantes.ESTADO_PAGO_PAGADO)
										|| pagos.getEstadopago().getSacodigo()
												.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_DEFINITIVO)
										|| pagos.getEstadopago().getSacodigo()
												.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_PROVISIONAL)) {
									santramexp.setTrprontopago(Y41bConstantes.VALOR_SI);
								} else {
									santramexp.setTrprontopago(Y41bConstantes.VALOR_NO);
								}
							}
						} else {
							// Solo se aplica reduccin por pronto pago antes de
							// la resolucion
							if (!Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals((santramexpAux.getTrcodigo()))) {
								santramexp.setTrprontopago(Y41bConstantes.VALOR_SI);
								parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_PRONTO_PAGO);
								parametros = this.parametrosDao.find(parametros);
								if (parametros != null && parametros.getValor() != null
										&& Y41bUtils.isNumeric(parametros.getValor())) {
									reduccion1 = importe.multiply(new BigDecimal(parametros.getValor()))
											.divide(new BigDecimal(Y41bConstantes.NUM_100));
								}
							}
						}
					} else {
						santramexp.setTrprontopago(Y41bConstantes.VALOR_NO);
					}
					if (Y41bConstantes.VALOR_SI.equals(solicitudReduccion.getTrreconocimiento())) {
						parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_RECONOCIMIENTO);
						parametros = this.parametrosDao.find(parametros);
						if (parametros != null && parametros.getValor() != null
								&& Y41bUtils.isNumeric(parametros.getValor())) {
							reduccion2 = importe.multiply(new BigDecimal(parametros.getValor()))
									.divide(new BigDecimal(Y41bConstantes.NUM_100));
						}
						santramexp.setTrreconocimiento(Y41bConstantes.VALOR_SI);
					} else {
						santramexp.setTrreconocimiento(Y41bConstantes.VALOR_NO);
					}
					santramexp.setTrresoimporte(
							importe.subtract(reduccion1).subtract(reduccion2).setScale(2, RoundingMode.DOWN));
				} else {
					santramexp.setTrresoimporte(importe);
				}
			} else {
				santramexp.setTrresoimporte(importe);
			}
		}
		return santramexp;
	}

	/**
	 * Metodo que crea un zip con nombre zipName, y comprime los documentos del
	 * tramite del expediente
	 * 
	 * @param zipName
	 *            String
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean true si hay ficheros en el zip / false si no hay ficheros
	 *         en el zip
	 */
	private boolean crearZipDocumentosExpediente(String zipName, List<Adjuntardocs> listadjuntardocs,
			TramiteComun tramiteComun) {

		SantramexpServiceImpl.logger
				.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Inicio.");
		Sandoctemp documentoHechoDetalle = null;
		boolean zipConFicheros = true;
		boolean zipSinFicheros = false;
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Ej. /datos/y41b/tmp/zip/
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		String strZipDirectory = strTmpZipDirectory + zipName;
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strZipFile = strTmpZipDirectory + zipName + Y41bConstantes.EXTENSION_ZIP;
		try {
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 1.");
			// 1. Validamos que exista el directorio TMP para los ZIP. Si no
			// existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 2.");
			// 2. Validamos que exista el directorio TMP para el ZIP actual. Si
			// no existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strZipDirectory);
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 3.");
			// 3. Creamos el ZIP
			Y41bFicheroUtils.crearFichero(new File(strZipFile));
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 4.");
			// ******* Borramos historico de ficheros con mas de 1 minuto
			// (60000ms) de
			// diferencia en la fecha de creacion
			Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), Y41bConstantes.NUM_60000);
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				SantramexpServiceImpl.logger
						.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 6."
								+ listadjuntardocs.size() + ".");
				String nombreFichero = null;
				InputStream ficheroStream = null;
				File fileFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + ".");

					documentoHechoDetalle = new Sandoctemp();
					documentoHechoDetalle.setU5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.sandoctempService.find(documentoHechoDetalle);

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getU5nofile());
					ficheroStream = documentoHechoDetalle.getU5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if ("true".equals(local)) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + "." + strZipDirectory + "\\" + numDoc + "." + nombreFichero + ".");
					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 8.");

				// 5. Comprimimos el directorio del zip en el fichero zip que
				// hemos creado
				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);
				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 9.");
				// 8.1. Hay ficheros en el zip
				return zipConFicheros;
			} else {
				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.B.");
				// 8.2.1. Eliminamos el zip vacio (no sirve de nada)
				Y41bFicheroUtils.deleteFile(new File(strZipFile));
				// 8.2.2. No hay ficheros en el zip
				return zipSinFicheros;
			}
		} catch (Exception e) {
			// Eliminamos el zip vacio si existe
			SantramexpServiceImpl.logger
					.error("SantramexpServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());

			Y41bFicheroUtils.deleteFile(new File(strZipFile));
			throw new Y41bUDAException("error.zip.crearZipDocumentosExpediente", true, new Exception());
		} finally {
			// 6. Eliminamos de la zona temporal de BDDD para los LOB
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 10.FINALLY.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					documentoHechoDetalle = new Sandoctemp();
					documentoHechoDetalle.setU5codocumento(adjuntardocs.getThcodocumento());
					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 11. FINALLY. bucle."
									+ adjuntardocs.getThcodocumento() + ".");
				}
			}
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 12.FINALLY.");
			// 7. Borramos el directorio temporal del ZIP y su contenido
			File directoryToDelete = new File(strZipDirectory);
			if (directoryToDelete.exists()) {
				Y41bFicheroUtils.deleteDirectory(directoryToDelete);
			}
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 13.FINALLY.");

			if (directoryToDelete.exists()) {
				directoryToDelete.delete();
			}
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Fin.");
		}
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramiteNotificacion
	 *            Santramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public Santramexp generarTramiteAcuseReciboAutomatico(String idEspera, Santramexp tramiteNotificacion,
			TramiteComun tramiteComun) throws Exception {
		try {
			// Generar el tramite de acuse de recibo vinculado al tramite de
			// notificacion
			// Creacion de tramite de registro de solicitud tramitado
			Santramexp santramexpAcuse = new Santramexp();

			santramexpAcuse.setTrid(this.getNewPK().toString());
			santramexpAcuse.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			santramexpAcuse.setTrcodigo((Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO));
			// La fase del acuse es la fase del tramite de notificacion que lo
			// genera
			Fase fase = ((Santramexp) this.santramexpDao.find(tramiteNotificacion)).getFase();
			santramexpAcuse.setFase(fase);

			// Incidencia 74956 - Ponemos en la fecha de inicio la fecha del dia
			// de hoy, que coincide con la fecha de fin de la notificacion
			santramexpAcuse.setTrfecini(Y41bUtils.obtenerFechaHoy());

			santramexpAcuse.setCensoMonitor((tramiteNotificacion.getCensoMonitor()));
			santramexpAcuse.setTrcodigorel(tramiteNotificacion.getTrcodigo());
			santramexpAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpAcuse.setTrcodigorel(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
			santramexpAcuse.setTrtridrel(tramiteNotificacion.getTrid());
			santramexpAcuse.setTruaidinterv(tramiteNotificacion.getTruaidinterv());
			// tratamos el idEspera pasado por parametro
			if (Y41bUtils.isFilled(idEspera)) {
				santramexpAcuse.setTridesperaplatea(idEspera);
				santramexpAcuse.setTrmatarespera(Y41bConstantes.NO);
			}

			// Se inserta el tramite
			this.santramexpDao.add(santramexpAcuse);
			return santramexpAcuse;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger
					.error("Error producido en generarTramiteAcuseReciboAutomatico: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun) {
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			Sandoctemp documentoHechoAux = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoHechoAux = new Sandoctemp();
				documentoHechoAux.setU5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux.setU5pcodigo(documentoExpediente.getPcodigo());
				try {
					this.sandoctempDao.addAdjuntarDoc(documentoHechoAux, tramiteComun);
				} catch (DuplicateKeyException duplicateKeyException) {
					throw new Y41bUDAException("error.adjuntardocstramite.duplicateException", true, new Exception());
				}
			}
		}
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
				pagination.setSort("U5FECHA");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("U5TEDESFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
				pagination.setSort("U5NOFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
				pagination.setSort("U5ORIGEN");
			}
		}
		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.sandoctempDao
				.findAllDocumentosHechoComunicacion(tramiteComun, pagination);

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (Sandoctemp documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getU5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion, CensoMonitor monitor)
			throws SQLException, IOException {

		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteNotificacion.getIdTramite());

		santramexp = this.santramexpDao.findFichaTramite(santramexp);

		TramiteNotificacion tramiteNotificacionAux = new TramiteNotificacion();
		tramiteNotificacionAux.setIdTramite(santramexp.getTrid().toString());

		tramiteNotificacionAux.setFechaInicio(santramexp.getTrfecini());
		tramiteNotificacionAux.setFechaFin(santramexp.getTrfecfin());

		if (santramexp.getCensoMonitor() != null) {
			tramiteNotificacionAux.setInstructorAsignado(santramexp.getCensoMonitor());
		} else {
			tramiteNotificacionAux.setInstructorAsignado(null);
		}

		if (santramexp.getCensoMonitorEj() != null) {
			tramiteNotificacionAux.setInstructorEjecucion(santramexp.getCensoMonitorEj());
		} else {
			tramiteNotificacionAux.setInstructorEjecucion(null);
		}

		tramiteNotificacionAux.setEstadoTramite(santramexp.getTrestado());

		tramiteNotificacionAux.setFechaComunicacion(santramexp.getTrfecnotif());

		tramiteNotificacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(santramexp));

		tramiteNotificacionAux.setSede(santramexp.getTrsede());

		tramiteNotificacionAux.setTipoNotificacion(santramexp.getTrtiponot());

		tramiteNotificacionAux.setTipoNotificacionPlatea(santramexp.getTrtiponotplatea());

		tramiteNotificacionAux.setFechasalida(santramexp.getTrfecregs());

		tramiteNotificacionAux.setNumregistrosalida(santramexp.getTrnumregs());

		if ((santramexp != null && santramexp.getTrtridrel() != null)
				|| Y41bConstantes.VALOR_SI.equals(santramexp.getTrautomatico())) {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}
		// 0155560 si tiene un tramite relacionado liquidacion se puede cambiar
		// el combo tipo notificacion
		if ((santramexp != null && santramexp.getTrtridrel() != null)) {
			// BuscaTramiteRelacionado

			Santramexp tramiteNotificacionRelacionado = new Santramexp();
			tramiteNotificacionRelacionado.setTrid(santramexp.getTrtridrel());
			tramiteNotificacionRelacionado = this.santramexpDao.find(tramiteNotificacionRelacionado);

			// si existe tramite relacionado y es liquidacion entonces
			if (tramiteNotificacionRelacionado != null && tramiteNotificacionRelacionado.getTrid() != null
					&& tramiteNotificacionRelacionado.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION)) {
				tramiteNotificacionAux.setRelacionadoLiquidacion(Y41bConstantes.SI);
			} else {
				tramiteNotificacionAux.setRelacionadoLiquidacion(Y41bConstantes.NO);
			}
		}
		// 0155560

		tramiteNotificacionAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));
		tramiteNotificacionAux.setTextoComunicacion(Y41bUtils.clobToString(santramexp.getTrtexto()));

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		tramiteNotificacionAux.setIdnotificacionplatea(santramexp.getTridnotifplatea());

		// Remesas Ini
		tramiteNotificacionAux.setEnvRemesaNotificacion(santramexp.getTrenvrem());
		if (santramexp.getTrcodrem() != null && !"".equals(santramexp.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(santramexp.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteNotificacionAux.setIdRemesaNotificacion(remesa.getRmcodigo());
			tramiteNotificacionAux.setFechaRemesaNotificacion(remesa.getRmfechageneracion());
		}

		if (santramexp.getTrtridrel() != null) {
			tramiteNotificacionAux.setTramiteRelacionado(santramexp.getTrtridrel());
		}

		// Remesas Fin

		return tramiteNotificacionAux;
	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	private boolean tratamientoSeguridad(Santramexp santramexp, CensoMonitor censoMonitor) {
		// obtener la solicitud

		SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad. INICIO ." + santramexp.getTrid() + ".");

		if (censoMonitor == null || censoMonitor.getPerfilSanciones() == null
				|| censoMonitor.getPerfilSanciones().getIdPerfil() == null) {
			return false;
		}

		Expedien expediente = new Expedien();
		expediente.setExcodigo(santramexp.getExpedien().getExcodigo());

		expediente = this.expedienDao.find(expediente);

		// Si el expediente esta cerrado
		if (expediente.getExfear() != null) {
			return false;
		}

		// caso especial liquidacion
		Tramite tramite = new Tramite();
		tramite.setTrcodigo(santramexp.getTrcodigo());
		tramite = this.tramiteDao.find(tramite);

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad. PERFIL USUARIO CONECTADO:"
				+ censoMonitor.getPerfilSanciones().getIdPerfil() + ".");
		SantramexpServiceImpl.logger
				.info("SANCIONES.tratamientoSeguridad. TIPO DE TRAMITE:" + santramexp.getTrcodigo() + ".");
		if (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_CONSULTAS)) {
			return false;
		}
		if (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return false;
		}
		if (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return false;

		}
		// Si tiene marca BOPV puede tramitar
		if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA)) {
			if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
				return true;
			}
		}
		// El tramite de liquidacion es especial
		if ((tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION))) {
			return ((censoMonitor.getMoadmiliquidacion() != null
					&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI))
					|| censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR));
		}
		// El tramite de resolucion complementaria es especial
		if ((tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA))) {
			return ((censoMonitor.getMoadmiliquidacion() != null
					&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI))
					|| censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR));
		}
		if (expediente != null
				&& expediente.getSanexp().getExcooractual().equals(censoMonitor.getOrganismo().getCodOrg())) {
			SantramexpServiceImpl.logger
					.info("SANCIONES.tratamientoSeguridad. expediente.getExcoor():" + expediente.getExcoor() + ".");

			// Los instructores solo pueden modificar sus tramites
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(expediente.getExcodigo());
			sanexp = this.sanexpDao.dameDetallesExpediente(sanexp);

			String responsable = sanexp.getExmocodigo();

			if (tramite != null && tramite.getIdPerfil() != null) {
				SantramexpServiceImpl.logger
						.info("SANCIONES.tratamientoSeguridad. ID PERFIL DEL TRAMITE:" + tramite.getIdPerfil() + ".");
				if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
						&& (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
								|| (censoMonitor.getPerfilSanciones()
										.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
										&& responsable.equals(censoMonitor.getMocodigo()))
								|| censoMonitor.getPerfilSanciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_COORDINADOR)
								|| censoMonitor.getPerfilSanciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad.123.RETURN TRUE");
					return true;
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
						&& ((censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
								&& responsable.equals(censoMonitor.getMocodigo()))
								|| censoMonitor.getPerfilSanciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_COORDINADOR)
								|| censoMonitor.getPerfilSanciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad.124.RETURN TRUE");
					return true;
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR) && (censoMonitor
						.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						|| censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad.125.RETURN TRUE");
					return true;
				} else {
					SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad. RETURN FALSE1.");
					return false;
				}
			} else {
				SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad. RETURN FALSE2.");
				return false;
			}
		} else {

			// si el usuario conectado tiene perfil de supervisior, le damos
			// permiso para modificar
			if (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad.223.RETURN TRUE");
				return true;
			}
			// else if
			// (censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO))
			// {
			// Tramite tramite = new Tramite();
			// tramite.setTrcodigo(santramexp.getTrcodigo());
			//
			// tramite = this.tramiteDao.find(tramite);
			//
			// if
			// ((tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION))
			// ||
			// (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION))
			// ||
			// (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO)))
			// {
			// return true;
			// }
			// else {
			// SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad.
			// RETURN FALSE3.");
			// return false;
			// }
			// }
		}
		SantramexpServiceImpl.logger.info("SANCIONES.tratamientoSeguridad. RETURN FALSE4.");
		return false;
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public void sugiereTramitePublicacionBopvTablonAutomaticamente(Santramexp santramexp) throws Exception {
		try {
			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(santramexp.getExpedien());
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			Santramexp tramiteAcuse = this.santramexpDao.find(santramexp);
			Santramexp tramiteNotificacion = new Santramexp();
			tramiteNotificacion.setTrid(tramiteAcuse.getTrtridrel());
			tramiteNotificacion = this.santramexpDao.find(tramiteNotificacion);

			santramexpNuevo.setTrcodigorel(tramiteNotificacion.getTrcodigo());
			/* el tramite relacionado es la notificacion, no el acuse */
			santramexpNuevo.setTrtridrel(tramiteNotificacion.getTrid());
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			this.add(santramexpNuevo);

			this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString());

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Sugiere tramite elaboracion bopv tablon automaticamente.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @throws Exception
	 *             the exception
	 */
	private void sugiereTramiteElaboracionBopvTablonAutomaticamente(Santramexp santramexp) throws Exception {
		try {
			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(santramexp.getExpedien());
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			Santramexp tramiteAcuse = this.santramexpDao.find(santramexp);
			Santramexp tramiteNotificacion = new Santramexp();
			tramiteNotificacion.setTrid(tramiteAcuse.getTrtridrel());
			tramiteNotificacion = this.santramexpDao.find(tramiteNotificacion);

			santramexpNuevo.setTrcodigorel(tramiteNotificacion.getTrcodigo());
			/* el tramite relacionado es la notificacion, no el acuse */
			santramexpNuevo.setTrtridrel(tramiteNotificacion.getTrid());
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			this.add(santramexpNuevo);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	public boolean tratarTramitacionAcuse(Santramexp santramexp) throws Exception {
		try {

			if (santramexp.getTrestadoacuse().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				if (santramexp.getTrtridrel() != null) {
					// tiene tramite relacionado
					String tridrel = santramexp.getTrtridrel();

					Santramexp tramiteRelacionado = this.santramexpDao.find(new Santramexp(tridrel));

					if (tramiteRelacionado != null && tramiteRelacionado.getTrcodigo() != null) {
						if (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION)) {
							this.sugiereTramiteElaboracionBopvTablonAutomaticamente(santramexp);
							/*
							 * // si es una notificacion el tramite relacionado
							 * es // el // relacionado de este BigDecimal
							 * tridrelnotificacion = tramiteRelacionado
							 * .getTrtridrel(); Santramexp tramiteNotificado =
							 * this.santramexpDao .find(new
							 * Santramexp(tridrelnotificacion)); if
							 * (tramiteNotificado != null && (tramiteNotificado
							 * .getTrcodigo() .equals(Y41bConstantes.
							 * TRAMITE_SANCIONES_ACUERDOINCOACION) ||
							 * tramiteNotificado .getTrcodigo()
							 * .equals(Y41bConstantes
							 * .TRAMITE_SANCIONES_PROPUESTARESOLUCION) ||
							 * tramiteNotificado .getTrcodigo()
							 * .equals(Y41bConstantes
							 * .TRAMITE_SANCIONES_RESOLUCION) ||
							 * tramiteNotificado .getTrcodigo()
							 * .equals(Y41bConstantes
							 * .TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO) ||
							 * tramiteNotificado .getTrcodigo()
							 * .equals(Y41bConstantes
							 * .TRAMITE_SANCIONES_LIQUIDACION))) { this.
							 * sugiereTramiteElaboracionBopvTablonAutomaticamente
							 * (santramexp); } // else { //
							 * this.borrarAvisoEsperaAcuse( //
							 * santramexp.getExpedien(), // tramiteRelacionado);
							 * // }
							 */
						} else {
							// Si el tramite relacionado no es una notificacion,
							// no podemos hacer nada. No debiera darse el caso
							return false;
						}
					} else {
						// Si no tenemos el codigo del tramite relacionado, no
						// podemos hacer nada. No debiera darse el caso
						return false;
					}
				} else {
					// Si no tenemos tramite relacionado, no podemos hacer nada.
					// No debiera darse el caso
					return false;
				}
			} else {
				String idTramitenotificacion = santramexp.getTrtridrel();
				Santramexp santramexpTramiteNotificacion = new Santramexp();
				santramexpTramiteNotificacion.setTrid(idTramitenotificacion);
				santramexpTramiteNotificacion = this.santramexpDao.find(santramexpTramiteNotificacion);

				Date fechaAcuse = santramexp.getTrfecacuse();
				this.tratarAcuseRecogido(santramexpTramiteNotificacion, fechaAcuse);
				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(santramexp.getTruaidinterv());
				saninterv = this.sanintervDao.find(saninterv);

				if (saninterv != null && saninterv.getUatipointerv() != null
						&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
										.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO
										.equals(saninterv.getUatipointerv()))) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdTramite(santramexpTramiteNotificacion.getTrid().toString());
					List<Sandoctemp> listDocumentos = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux,
							null);
					this.actualizarMisGestionesNotificacion(santramexp, listDocumentos);

				}
			}
			return true;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - tratarTramitacionAcuse - ExceptionException .");
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param santramexpNotificacion
	 *            Santramexp
	 * @param fechaAcuse
	 *            Date
	 * @throws Exception
	 *             Exception
	 */
	private void tratarAcuseRecogido(Santramexp santramexpNotificacion, Date fechaAcuse) throws Exception {

		this.actualizaExpedienteTrasAcusar(santramexpNotificacion.getExpedien().getExcodigo(), santramexpNotificacion,
				fechaAcuse);

		Expedien expedien = santramexpNotificacion.getExpedien();
		expedien = this.expedienDao.find(expedien);

		// 135083 2.3 28/10/2019 nuevo punto apertura platea

		// Sanexp sanexpPlatea = new Sanexp();
		// sanexpPlatea.setExcodigo(expedien.getExcodigo());
		// sanexpPlatea = this.sanexpService.find(sanexpPlatea);
		// if (!Y41bConstantes.VALOR_SI.equals(sanexpPlatea
		// .getPlatea())) {
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - tratarAcuseRecogido - Apertura
		// expediente Platea Inicio");
		// this.abrirSolicitudOficioPlatea(expedien);
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - tratarAcuseRecogido - Apertura
		// expediente Platea Fin");
		// sanexpService.updateIndicadorPlatea(sanexpPlatea);
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - tratarAcuseRecogido - Actualizacion
		// indicador Platea");
		// }
		// 135083 2.3 28/10/2019 nuevo punto apertura platea

		/* AVISOS DE LA BANDEJA SOBRE PLAZO DE ALEGACIONES */
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - tratarTramitacionAcuse - Busco el tramite origen.");

		SantramexpServiceImpl.logger
				.info("SantramexpServiceImpl - tratarTramitacionAcuse - Busco el tramite origen. ENCONTRADO "
						+ santramexpNotificacion.getTrtridrel());

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - tratarTramitacionAcuse - Actualizo envios. "
				+ santramexpNotificacion.getTrtridrel());
		this.actualizaEnvios(santramexpNotificacion, fechaAcuse);

		SantramexpServiceImpl.logger.info(
				"SantramexpServiceImpl - tratarTramitacionAcuse - Elimino espera del acuse en bandeja de avisos. Si existe.. ");

		// this.borrarAvisoEsperaAcuse(expedien, santramexpNotificacion);

		// tratamos las fechas del acuse respecto al tramite de
		// notificacion asociado
		this.tratarAcuseNotificacion(santramexpNotificacion, expedien, fechaAcuse);

	}

	/**
	 * Tratar acuse notificacion.
	 * 
	 * @param santramexpTramiteNotificacion
	 *            the santramexp tramite notificacion
	 * @param expedien
	 *            the expedien
	 * @param fechaAcuse
	 *            Date
	 */
	private void tratarAcuseNotificacion(Santramexp santramexpTramiteNotificacion, Expedien expedien, Date fechaAcuse) {
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - tratarAcuseNotificacion - TRID NOTIFICACION ."
				+ santramexpTramiteNotificacion.getTrid() + ".EXP:"
				+ santramexpTramiteNotificacion.getExpedien().getExcodigo() + ".Fecha Acuse" + fechaAcuse.toString()
				+ ".");

		if (santramexpTramiteNotificacion.getTrtridrel() != null) {
			String idTramiteOriginal = santramexpTramiteNotificacion.getTrtridrel();

			Santramexp santramexpOriginal = new Santramexp();
			santramexpOriginal.setTrid(idTramiteOriginal);
			santramexpOriginal = this.santramexpDao.find(santramexpOriginal);

			if (Y41bConstantes.SI.equals(santramexpOriginal.getTracusereintentado())) {
				fechaAcuse = null;
			}

			if (santramexpTramiteNotificacion.getTrcodigo() != null) {

				String duenioExp = expedien.getSanexp().getExmocodigo();
				CensoMonitor censoMonitor = new CensoMonitor();
				censoMonitor.setMocodigo(duenioExp);
				censoMonitor = this.censoMonitorDao.find(censoMonitor);

				String parametroABuscar = null;
				String parametroABuscar2 = null;
				if (santramexpTramiteNotificacion.getTrtridrel() != null) {
					Santramexp tramiteOriginal = new Santramexp();
					tramiteOriginal.setTrid(santramexpTramiteNotificacion.getTrtridrel());
					tramiteOriginal = this.find(tramiteOriginal);

					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl - tratarTramitacionAcuse - Genero aviso sobre el tipo de notificacion especifica, si procede. "
									+ tramiteOriginal.getTrtiponot());

					String tipoTramite = tramiteOriginal.getTrcodigo();

					if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(tipoTramite)) {
						// this.sanbandejaDao.eliminaAvisoFechaPrescripcion(expedien);
						parametroABuscar = Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC;
						parametroABuscar2 = Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL;
					} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(tipoTramite)) {
						// this.sanbandejaDao.eliminaAvisoFechaPrescripcion(expedien);
						parametroABuscar = Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL;
						// Si existe el tramite de la resolucin tramitado no
						// creamos el aviso
						Santramexp resol = new Santramexp();
						resol.setExpedien(new Expedien(expedien.getExcodigo()));
						resol.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
						resol.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
						if (this.santramexpDao.findAllCount(resol).intValue() == 0) {
							parametroABuscar2 = Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_RESOL;
						}
					} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tipoTramite)) {
						// this.sanbandejaDao.eliminaAvisoFechaPrescripcion(expedien);
						parametroABuscar = Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION;
					} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA.equals(tipoTramite)) {
						// this.sanbandejaDao.eliminaAvisoFechaPrescripcion(expedien);
						parametroABuscar = Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA;
					}
					if (parametroABuscar != null) {
						Parametros parametros2 = new Parametros();
						parametros2.setParametro(parametroABuscar);
						parametros2 = this.parametrosDao.find(parametros2);
						if (parametros2 != null) {
							Long numero = new Long(parametros2.getValor());
							SantramexpServiceImpl.logger
									.info("SantramexpServiceImpl - tratarTramitacionAcuse - Generado para:  "
											+ santramexpTramiteNotificacion.getTrtiponot());
							// Resolucion incidencia 76075
							this.sanbandejaDao.aniadeAvisoBandejaDias(expedien, censoMonitor, numero, "", "",
									santramexpOriginal.getTrid(), fechaAcuse, parametroABuscar);
						}
					}
					if (parametroABuscar2 != null) {
						Parametros parametros2 = new Parametros();
						parametros2.setParametro(parametroABuscar2);
						parametros2 = this.parametrosDao.find(parametros2);
						if (parametros2 != null) {
							Sanbandeja aviso = new Sanbandeja();
							aviso.setExpedien(new Expedien(expedien.getExcodigo()));
							aviso.setBatipo(parametroABuscar2);
							List<Sanbandeja> lavisos = sanbandejaDao.findAll(aviso, null);
							for (int i = 0; i < lavisos.size(); i++) {
								this.sanbandejaDao.remove(lavisos.get(i));
							}
							Long numero = new Long(parametros2.getValor());
							this.sanbandejaDao.aniadeAvisoBandejaDias(expedien, censoMonitor, numero, "", "",
									santramexpOriginal.getTrid(), fechaAcuse, parametroABuscar2);
						}
					}
				}
			}
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public Santramexp sugiereTramiteAcuerdoIncoaccionAutomaticamente(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(expedien);
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
			santramexpNuevo.setTrfecini(
					santramexp.getTrfecini());/*
												 * LO RELACIONO CON LA APERTURA
												 */
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setFase(new Fase(Y41bConstantes.FASE_INICIO_SANCION));
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			return this.add(santramexpNuevo);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param destinatario
	 *            long
	 * @throws Exception
	 *             Exception
	 */

	public void sugiereTramiteComunicacionAutomaticamente(Santramexp santramexp, long destinatario, boolean conDoc)
			throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			// Correccion INCIDENCIA
			// La comunicacin automatica tiene que ir al responsable del
			// expediente siempre
			// si fuese al tramitador del tramite origen, en el caso de la
			// liquidacin sera incorrecto
			// porque el tramitador es el administrativo de liquidaciones y este
			// no puede hacer nada respecto a la comuniciacin
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);
			santramexpNuevo.setCensoMonitor(new CensoMonitor(sanexp.getExmocodigo(), null));

			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrasuntocomunicacion(expedien.damecodCompletoPlatea());
			if (destinatario != 0) {
				santramexpNuevo.setTruaidinterv(new BigDecimal(destinatario));
			} else {
				santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			}
			santramexpNuevo.setExpedien(expedien);
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			// Por defecto fecha de envio la del día de hoy
			santramexpNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());

			santramexpNuevo.setTrenvrem(Y41bConstantes.VALOR_SI);

			// # INICIO #
			// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
			// SANCIONADO
			santramexpNuevo.setTrisComunicacionInicio(
					Y41bConstantes.SI.equals(santramexp.getTrisComunicacionInicio()) ? Y41bConstantes.SI : "");
			// # FIN #

			// EVOLUTIVO 135083 2.1
			// NO ES NECESARIO DEBIDO A QUE LAS COMUNICACIONES GENERADAS TRAS LA
			// LIQUIDACION VAN SIN DOCUMENTOS
			// Santramexp tramiteRelacionado = null;
			// if (santramexp.getTrtridrel() != null) {
			// tramiteRelacionado = this.santramexpDao.find(new Santramexp(
			// santramexp.getTrtridrel()));
			// if (tramiteRelacionado != null) {
			// if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
			// .equals(tramiteRelacionado.getTrcodigo())) {
			//
			// this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(
			// santramexp.getTrid().toString(),
			// santramexpNuevo.getTrid().toString());
			// }
			// }
			// }
			// EVOLUTIVO 135083 2.1
			this.add(santramexpNuevo);

			if (conDoc) {
				this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
						santramexpNuevo.getTrid().toString());
				this.calcularEstadoTramiteGenerado(santramexpNuevo);
			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param destinatario
	 *            BigDecimal
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp sugiereTramiteNotificacionAutomaticamente(Santramexp santramexp, BigDecimal destinatario)
			throws Exception {
		Santramexp santramexpNuevo = new Santramexp();
		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			/* BLOQUE NUEVO TITULAR/REPRESENTANTE */
			/*
			 * sugerimos una tarea de notificacion para el
			 * sancionado/representante, solo habra uno de cada tipo al que se
			 * pueda notificar (titular o rep.validado)
			 */
			List<Saninterv> listaSancionados = null;

			/*
			 * El trmite de requerimiento de acreditacin es especial, porque
			 * puede tener como destinatario un representante que todava no se
			 * ha validado, si este es el que presenta el requerimiento. En
			 * cualquier otro trmite que genere notificaciones, el destinatario
			 * ser el titular o su representante ya validado.
			 */
			if (Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION
					.equals(santramexp.getTrcodigo())) {
				if (expedien != null && expedien.getSanexp() != null
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
								.equals(expedien.getSanexp().getExdestnotifsancionado())) {
					listaSancionados = this.sanintervDao.findAllByTipo(expedien,
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);
				}
			} else {
				if (expedien != null && expedien.getSanexp() != null
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
								.equals(expedien.getSanexp().getExdestnotifsancionado())) {
					listaSancionados = this.sanintervDao.findAllByTipo(expedien,
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
				}
			}
			if (expedien != null && expedien.getSanexp() != null
					&& Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR
							.equals(expedien.getSanexp().getExdestnotifsancionado())
					|| listaSancionados == null || listaSancionados.size() == 0) {
				listaSancionados = this.sanintervDao.findAllSancionados(expedien);
			}
			if (listaSancionados != null && listaSancionados.size() > 0) {
				destinatario = ((Saninterv) listaSancionados.get(0)).getUaidinterv();
				// this.sugiereTramiteNotificacionAutomaticamente(santramexp,
				// idInterviniente);
			}

			santramexpNuevo.setTrid(this.getNewPK().toString());
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			// Correccion INCIDENCIA
			// La notificacion automatica tiene que ir al responsable del
			// expediente siempre
			// si fuese al tramitador del tramite origen, en el caso de la
			// liquidacin sera incorrecto
			// porque el tramitador es el administrativo de liquidaciones y este
			// no puede hacer nada respecto a la notificacin
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);
			santramexpNuevo.setCensoMonitor(new CensoMonitor(sanexp.getExmocodigo(), null));

			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			String tipoNotificacion = "";
			if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION);
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_PROPUESTA_RESOLUCION);
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION)) {
				Santramexp tramiteRelacionado = null;
				if (santramexp.getTrtridrel() != null) {
					tramiteRelacionado = this.santramexpDao.find(new Santramexp(santramexp.getTrtridrel()));
					if (tramiteRelacionado != null) {
						if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tramiteRelacionado.getTrcodigo())) {
							tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION);
							// EVOLUTIVO 135083 2.1
							this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(
									tramiteRelacionado.getTrid().toString(), santramexpNuevo.getTrid().toString());
							// EVOLUTIVO 135083 2.1
						} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
								.equals(tramiteRelacionado.getTrcodigo())) {
							tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA);
						} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
								.equals(tramiteRelacionado.getTrcodigo())) {
							tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_OTROS);
						} else {
							tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION);
						}
					} else {
						tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION);
					}
				} else {
					tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION);
				}
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONRECURSOPRUEBA)) {
				tipoNotificacion = "PRUEBAS";
				// tipoNotificacion =
				// (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA);
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION_SOLICITUD_PRUEBA);
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO)) {
				// no ponia por defecto notificacion asociada cuando se recibia
				// el recurso y se generaba el tramite automaticamente
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA);
				/*
				 * Este tramite ya no genera notificacion } else if
				 * (santramexp.getTrcodigo().equals(
				 * Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA)) {
				 * tipoNotificacion = (Y41bConstantes.
				 * TIPO_NOTIFICACION_SANCIONES_ELABORACION_DOCUMENTACION_BOPV);
				 */
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION);
			} else if (santramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO);
			} else if (santramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO);
			} else if (santramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOAMPLIACIONPLAZOALEGACIONES)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES);
			} else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA)) {
				tipoNotificacion = (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCIONCOMPLEMENTARIA);
			} // EVOLUTIVO 0135083 2.4
			else if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOINFORMACION)) {
				tipoNotificacion = "REQUERIMIENTOINFORMACION";
			} // EVOLUTIVO 0135083 2.4

			santramexpNuevo.setTrtiponotplatea(tipoNotificacion);
			santramexpNuevo.setTridnotifplatea(tipoNotificacion);

			if (destinatario != null) {
				if (destinatario.intValue() != 0) {
					santramexpNuevo.setTruaidinterv(destinatario);
				}
			}
			santramexpNuevo.setExpedien(expedien);
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTrenvrem(Y41bConstantes.VALOR_SI);

			// Notificacion de acuerdo inoacion
			// Si el tramite es acuerdo de incoacion se guardara si el tramite
			// debe de ser telemtico porque dispone de mail o de lo contrario
			// debe de ser postal, esta variable se lee en js y determina la va
			// de "Notificacin".
			if (!Y41bUtils.esNullOCadenaVacia(santramexp.getTrisNotificacionIncoacion())) {
				santramexpNuevo.setTrisNotificacionIncoacion(santramexp.getTrisNotificacionIncoacion());
			}

			this.add(santramexpNuevo);
			this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString());
			this.calcularEstadoTramiteGenerado(santramexpNuevo);
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
		return santramexpNuevo;
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public void sugiereTramiteLiquidacionAutomaticamente(Santramexp santramexp) throws Exception {

		try {
			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setFase(expedien.getSanexp().getFase());
			santramexpNuevo.setExpedien(expedien);
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			Boolean existeLiquidacionConImporte = false;

			if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(santramexp.getTrcodigo())) {
				santramexpNuevo.setTrresoimporte(santramexp.getTrresoimporte());
				Santramexp santramexpReso = new Santramexp();
				santramexpReso.setExpedien(new Expedien(expedien.getExcodigo()));
				santramexpReso.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
				List<Santramexp> lsantramexp = santramexpDao.findAll(santramexpReso, null);
				if (lsantramexp != null && lsantramexp.size() > 0) {
					santramexpReso = lsantramexp.get(0);
					santramexpNuevo.setTrimporteinicial(santramexpReso.getTrimporteinicial());
					santramexpNuevo.setTrprontopago(santramexpReso.getTrprontopago());
					santramexpNuevo.setTrreconocimiento(santramexpReso.getTrreconocimiento());
				}
				// 0162635: Orden del consejo. No generar liquidacin
				expedien = this.expedienService.obtenerEstadoLiquidacion(expedien);
				// miramos el estado de la liquidacion. Solo se genera tramite
				// de liquidacion si no existe una liquidacion ya pagada de
				// importe superior
				if (null != expedien && null != expedien.getSanexp() && null != expedien.getSanexp().getExliqestado()
						&& Y41bConstantes.SAN_LIQUIDACION_PAGADO.equals(expedien.getSanexp().getExliqestado())) {

					if (new BigDecimal(expedien.getSanexp().getImportePagado().replaceAll("\\.", "").replace(",", "."))
							.doubleValue() >= santramexp.getTrresoimporte().doubleValue()) {
						existeLiquidacionConImporte = true;
					}
				}

				// Santramexp santramexpLiquidacion = new Santramexp();
				// santramexpLiquidacion.setExpedien(new
				// Expedien(expedien.getExcodigo()));
				// santramexpLiquidacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
				// santramexpLiquidacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				//
				// List<Santramexp> listaLiquidaciones =
				// this.findAllLike(santramexpLiquidacion, null, false);
				// if(!listaLiquidaciones.isEmpty()){
				// for(Santramexp liquidacion : listaLiquidaciones){
				// if(null!=liquidacion &&
				// Y41bConstantes.SAN_LIQUIDACION_PAGADO.equals(expedien.getSanexp().getExliqestado())){
				// if(santramexp.getTrresoimporte().doubleValue()>expedien.getExcamure().doubleValue()){
				//
				// }
				// }
				// }
				// }
				// 0162635: Orden del consejo. No generar liquidacin

			} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigo())) {
				santramexpNuevo.setTrprontopago(santramexp.getTrprontopago());
				santramexpNuevo.setTrreconocimiento(santramexp.getTrreconocimiento());
				santramexpNuevo.setTrimporteinicial(santramexp.getTrimporteinicial());
				santramexpNuevo.setTrresoimporte(santramexp.getTrresoimporte());
			} else {
				santramexpNuevo.setTrprontopago(santramexp.getTrprontopago());
				santramexpNuevo.setTrreconocimiento(santramexp.getTrreconocimiento());
				santramexp = new Santramexp();
				santramexp.setExpedien(new Expedien(expedien.getExcodigo()));
				santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
				List<Santramexp> lsantramexp = santramexpDao.findAll(santramexp, null);
				if (lsantramexp != null && lsantramexp.size() > 0) {
					santramexp = lsantramexp.get(0);
					santramexpNuevo.setTrimporteinicial(santramexp.getTrresoimporte());
				} else {
					santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
					lsantramexp = santramexpDao.findAll(santramexp, null);
					if (lsantramexp != null && lsantramexp.size() > 0) {
						santramexp = lsantramexp.get(0);
						santramexpNuevo.setTrimporteinicial(santramexp.getTrimporteinicial());
					}
				}
				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_PRONTO_PAGO);
				parametros = this.parametrosDao.find(parametros);
				BigDecimal importe = santramexpNuevo.getTrimporteinicial();
				if (importe != null) {
					BigDecimal reduccion1 = new BigDecimal(0);
					BigDecimal reduccion2 = new BigDecimal(0);
					if (Y41bConstantes.VALOR_SI.equals(santramexpNuevo.getTrprontopago())) {
						if (parametros != null && parametros.getValor() != null
								&& Y41bUtils.isNumeric(parametros.getValor())) {
							reduccion1 = importe.multiply(new BigDecimal(parametros.getValor()))
									.divide(new BigDecimal(Y41bConstantes.NUM_100));
						}
					}
					if (Y41bConstantes.VALOR_SI.equals(santramexpNuevo.getTrreconocimiento())) {
						parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_RECONOCIMIENTO);
						parametros = this.parametrosDao.find(parametros);
						if (parametros != null && parametros.getValor() != null
								&& Y41bUtils.isNumeric(parametros.getValor())) {
							reduccion2 = importe.multiply(new BigDecimal(parametros.getValor()))
									.divide(new BigDecimal(Y41bConstantes.NUM_100));
						}
					}
					santramexpNuevo.setTrresoimporte(
							importe.subtract(reduccion1).subtract(reduccion2).setScale(2, RoundingMode.DOWN));
				}
			}
			// 0162635: Orden del consejo. No generar liquidacin
			if (!existeLiquidacionConImporte) {
				// 0162635: Orden del consejo. No generar liquidacin
				santramexpNuevo = this.add(santramexpNuevo);

				// Se adjunta el documento de la resolucion o la orden del
				// consejero
				// segun el caso
				// EVOLUTIVO 0135083 2.1 SE QUITA DE LA CONDICION DEL IF
				// "||
				// Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigo())"
				if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(santramexp.getTrcodigo())) {
					this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
							santramexpNuevo.getTrid().toString());
				}

				this.calcularEstadoTramiteGenerado(santramexpNuevo);

			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	/*
	 * public void sugiereTramiteCierreAutomaticamente(Santramexp santramexp)
	 * throws Exception {
	 * 
	 * try {
	 * 
	 * Expedien expedien = new Expedien();
	 * expedien.setExcodigo(santramexp.getExpedien().getExcodigo()); expedien =
	 * this.expedienDao.find(expedien);
	 * 
	 * Santramexp santramexpNuevo = new Santramexp();
	 * santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien()
	 * .getExcodigo())); santramexpNuevo
	 * .setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
	 * santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy()); santramexpNuevo
	 * .setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION); // Correccion
	 * INCIDENCIA // El cierre automatico tiene que ir al responsable del //
	 * expediente siempre // si fuese al tramitador del tramite origen, en el
	 * caso de la // liquidacin sera incorrecto // porque el tramitador es el
	 * administrativo de liquidaciones y este // no puede hacer nada respecto al
	 * cierre Sanexp sanexp = new Sanexp();
	 * sanexp.setExcodigo(santramexp.getExpedien().getExcodigo()); sanexp =
	 * this.sanexpDao.find(sanexp); santramexpNuevo.setCensoMonitor(new
	 * CensoMonitor(sanexp .getExmocodigo(), null));
	 * 
	 * santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
	 * santramexpNuevo.setTrtridrel(santramexp.getTrid()); santramexpNuevo
	 * .setFase(new Fase(Y41bConstantes.FASE_CIERRE_SANCION));
	 * this.add(santramexpNuevo);
	 * 
	 * } catch (Exception e) {
	 * SantramexpServiceImpl.logger.info(e.getMessage()); throw new
	 * Y41bUDAException(e.getMessage(), true, e); } }^
	 */

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void sugiereTramiteElaboracionInformeAsesoriaAutomaticamente(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setExpedien(expedien);
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			Santramexp solicitudReduccion = new Santramexp();
			solicitudReduccion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
			solicitudReduccion.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN");
			pagination.setSord("DESC");
			List<Santramexp> lsolicitudReduccion = this.santramexpDao.findAll(solicitudReduccion, pagination);
			if (lsolicitudReduccion != null && lsolicitudReduccion.size() > 0) {
				solicitudReduccion = lsolicitudReduccion.get(0);
				if (Y41bConstantes.VALOR_SI.equals(solicitudReduccion.getTrreconocimiento())) {
					santramexpNuevo.setTrreconocimiento(Y41bConstantes.VALOR_SI);
					santramexpNuevo.setTrestimacion(String.valueOf(Y41bConstantes.SAN_DESESTIMACION));
				} else {
					santramexpNuevo.setTrreconocimiento(Y41bConstantes.VALOR_NO);
				}
			}
			this.add(santramexpNuevo);

			this.enviarEmailElaboracionInformeAsesoria(santramexp.getExpedien().getExcodigo(),
					santramexp.getCensoMonitorEj());

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComunicacion.getIdTramite());

		santramexp = this.santramexpDao.findFichaTramite(santramexp);

		TramiteComunicacion tramiteComunicacionAux = new TramiteComunicacion();
		tramiteComunicacionAux.setIdTramite(santramexp.getTrid().toString());

		tramiteComunicacionAux.setFechaInicio(santramexp.getTrfecini());
		tramiteComunicacionAux.setFechaFin(santramexp.getTrfecfin());

		if (santramexp.getCensoMonitor() != null) {
			tramiteComunicacionAux.setInstructorAsignado(santramexp.getCensoMonitor());
		} else {
			tramiteComunicacionAux.setInstructorAsignado(null);
		}

		if (santramexp.getCensoMonitorEj() != null) {
			tramiteComunicacionAux.setInstructorEjecucion(santramexp.getCensoMonitorEj());
		} else {
			tramiteComunicacionAux.setInstructorEjecucion(null);
		}

		tramiteComunicacionAux.setEstadoTramite(santramexp.getTrestado());

		tramiteComunicacionAux.setFechaComunicacion(santramexp.getTrfecnotif());

		if (santramexp.getTruaidinterv() != null) {
			tramiteComunicacionAux.setDestinatario(santramexp.getTruaidinterv() + "");
		} else {
			tramiteComunicacionAux.setDestinatario("");
		}
		tramiteComunicacionAux.setSede(santramexp.getTrsede());

		tramiteComunicacionAux.setAsuntoComunicacion(santramexp.getTrasuntocomunicacion());

		tramiteComunicacionAux.setTipoComunicacion(santramexp.getTrtipocom());

		tramiteComunicacionAux.setFechasalida(santramexp.getTrfecregs());

		tramiteComunicacionAux.setNumregistrosalida(santramexp.getTrnumregs());

		tramiteComunicacionAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));
		tramiteComunicacionAux.setTextoComunicacion(Y41bUtils.clobToString(santramexp.getTrtexto()));

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		if (santramexp.getTrtridrel() != null) {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		// Remesas Ini
		tramiteComunicacionAux.setEnvRemesaComunicacion(santramexp.getTrenvrem());
		if (santramexp.getTrcodrem() != null && !"".equals(santramexp.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(santramexp.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteComunicacionAux.setIdRemesaComunicacion(remesa.getRmcodigo());
			tramiteComunicacionAux.setFechaRemesaComunicacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteComunicacionAux.setIdmailorigen(santramexp.getTridmailorigen());
		tramiteComunicacionAux.setMailorigen(santramexp.getTrmailorigen());
		tramiteComunicacionAux.setIdmaildestino(santramexp.getTridmaildestino());
		tramiteComunicacionAux.setMaildestino(santramexp.getTrmaildestino());

		// # INICIO #
		// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
		// SANCIONADO
		tramiteComunicacionAux.setEsComunicacionInicio(santramexp.getTrisComunicacionInicio());
		// # FIN #
		return tramiteComunicacionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}
		Santramexp santramexp = new Santramexp();
		SantramexpServiceImpl.logger.info("Id del tramite:" + tramiteAcuseRecibo.getIdTramite() + "-");
		santramexp.setTrid(tramiteAcuseRecibo.getIdTramite());

		santramexp = this.santramexpDao.findFichaTramite(santramexp);

		TramiteAcuseRecibo tramiteAcuserRecibo = new TramiteAcuseRecibo();
		tramiteAcuserRecibo.setIdTramite(santramexp.getTrid().toString());

		tramiteAcuserRecibo.setFechaInicio(santramexp.getTrfecini());
		tramiteAcuserRecibo.setFechaFin(santramexp.getTrfecfin());

		if (santramexp.getCensoMonitor() != null) {
			tramiteAcuserRecibo.setInstructorAsignado(santramexp.getCensoMonitor());
		} else {
			tramiteAcuserRecibo.setInstructorAsignado(null);
		}

		if (santramexp.getCensoMonitorEj() != null) {
			tramiteAcuserRecibo.setInstructorEjecucion(santramexp.getCensoMonitorEj());
		} else {
			tramiteAcuserRecibo.setInstructorEjecucion(null);
		}

		tramiteAcuserRecibo.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		tramiteAcuserRecibo.setEstadoTramite(santramexp.getTrestado());

		tramiteAcuserRecibo.setAcusereintentado(santramexp.getTracusereintentado());

		// Info de Acuse recibo ini
		tramiteAcuserRecibo.setFechaacuse(santramexp.getTrfecacuse());
		tramiteAcuserRecibo.setSituacionacuse(santramexp.getTrestadoacuse());

		tramiteAcuserRecibo.setFechaentrada(santramexp.getTrfecrege());
		tramiteAcuserRecibo.setNumregistroentrada(santramexp.getTrnumrege());
		// Info de Acuse recibo fin

		TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
		tramiteNotificacionWhere.setIdTramite(santramexp.getTrtridrel().toString());
		TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
				censoMonitor);

		// Recupero el tramite de notificacion relacionado ini
		tramiteAcuserRecibo.setTramiteNotificacion(tramiteNotificacionRelacionado);
		// Recupero el tramite de notificacion relacionado fin

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAcuserRecibo;
	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAcuseRecibo addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, null, false, reintento);
	}

	private TramiteAcuseRecibo addTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, String idioma, boolean tramitar, Sandoctemp docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, docHechoPEE, true, false);
	}

	/**
	 * Metodo comun para realizar Tramitar acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	private TramiteAcuseRecibo addTramiteAcuseRecibo0(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, Sandoctemp docHechoPEE, boolean esRemesa, boolean reintento)
			throws Exception {
		try {

			SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteAcuseRecibo - Inicio.");

			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(tramiteComun.getIdTramite());

			santramexp = this.santramexpDao.find(santramexp);

			Expedien expedien = new Expedien();
			expedien.setExcodigo(tramiteComun.getIdExpediente());
			expedien = this.expedienDao.find(expedien);

			if (santramexp.getTrestado() != null
					&& !santramexp.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {

				// Expedien expedien = new Expedien();
				// expedien.setExcodigo(tramiteComun.getIdExpediente());
				// expedien = this.expedienDao.find(expedien);

				santramexp.setTrid(tramiteComun.getIdTramite());
				santramexp = this.santramexpDao.find(santramexp);

				santramexp.setFase(expedien.getSanexp().getFase());
				santramexp.setTrfecini(tramiteAcuseRecibo.getFechaInicio());
				if (tramitar) {
					santramexp.setTrfecfin(tramiteAcuseRecibo.getFechaFin());
					santramexp.setCensoMonitorEj(tramiteAcuseRecibo.getInstructorEjecucion());
					// llamnar a platea
					// cambiar fase
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				} else {
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
				santramexp.setExpedien(expedien);
				santramexp.setFase(expedien.getSanexp().getFase());
				santramexp.setCensoMonitor(tramiteAcuseRecibo.getInstructorAsignado());
				santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteAcuseRecibo.getComentario()));

				// Info de Acuse recibo ini
				santramexp.setTrfecacuse(tramiteAcuseRecibo.getFechaacuse());
				santramexp.setTrestadoacuse(tramiteAcuseRecibo.getSituacionacuse());
				santramexp.setTrfecrege(tramiteAcuseRecibo.getFechaentrada());
				santramexp.setTrnumrege(tramiteAcuseRecibo.getNumregistroentrada());
				// Info de Acuse recibo fin

				// Se actualiza el tramite, nunca se inserta porque ya existe
				santramexp = this.setSantramexp(santramexp);

				// buscar los documentos que no estan en la tabla de trabajo de
				// documentos y que pertenecen al Tramite
				List<Sandoctemp> listSandoctempEliminados = null;
				if (esRemesa) {
					if (docHechoPEE != null) {
						this.sandoctempDao.add(docHechoPEE);
						this.sandoctempDao.insertSanDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE.getU5codocumento(), Y41bConstantes.TIPO_PROC_SANCIONES);
					}
				} else {
					listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
							tramiteAcuseRecibo.getAnyadirPlantilla());
				}

				// Se actualiza el origen de la lista de documentos del tramite
				// dependiendo del destinatario de la notificacion
				this.actualizarOrigenDocsTramiteAcuseRecibo(tramiteComun,
						tramiteAcuseRecibo.getTramiteNotificacion().getDestinatario());

				/* actualizamos el ultimo tramite */
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				/* actualizamos la bandeja */
				this.actualizaBandeja(santramexp);

				if (tramitar) {

					if (!reintento) {
						if (!this.tratarTramitacionAcuse(santramexp)) {
							tramiteAcuseRecibo.getTramiteNotificacion().setTramiteRelacionado(Y41bConstantes.VALOR_NO);
						}
					}
				}

				if (listSandoctempEliminados != null) {
					this.eliminarDocumentosDokusi(listSandoctempEliminados);
				}

				tramiteAcuseRecibo.setAcuseSinNotificacion(santramexp.getAcuseSinNotificacion());

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					santramexp.setTracusereintentado(Y41bConstantes.SI);
					// INICIO 0150725: Problema con sancionador: no tenia
					// informada la fecha EXFENOAI
					// if (Y41bConstantes.FASE_INICIO_SANCION.equals(santramexp
					// .getFase().getFcodigo())) {
					// expedien.setExfenoai(null);
					// } else if
					// (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION
					// .equals(santramexp.getFase().getFcodigo())) {
					// expedien.setExfenopr(null);
					// } else if (Y41bConstantes.FASE_RESOLUCION_SANCION
					// .equals(santramexp.getFase().getFcodigo())) {
					// expedien.setExfenore(null);
					// }
					// this.expedienDao.update(expedien);
					// FIN 0150725: Problema con sancionador: no tenia informada
					// la fecha EXFENOAI
					this.santramexpDao.updateAcuseReintentado(santramexp);

					// generar la notificacin
					this.generarReintentoTramiteNotificacion(santramexp.getTrtridrel());
				}

				return tramiteAcuseRecibo;

			} else {

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					santramexp.setTracusereintentado(Y41bConstantes.SI);
					// INICIO 0150725: Problema con sancionador: no tenia
					// informada la fecha EXFENOAI
					// if (Y41bConstantes.FASE_INICIO_SANCION.equals(santramexp
					// .getFase().getFcodigo())) {
					// expedien.setExfenoai(null);
					// } else if
					// (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION
					// .equals(santramexp.getFase().getFcodigo())) {
					// expedien.setExfenopr(null);
					// } else if (Y41bConstantes.FASE_RESOLUCION_SANCION
					// .equals(santramexp.getFase().getFcodigo())) {
					// expedien.setExfenore(null);
					// }
					// this.expedienDao.update(expedien);
					// FIN 0150725: Problema con sancionador: no tenia informada
					// la fecha EXFENOAI
					this.santramexpDao.updateAcuseReintentado(santramexp);

					// generar la notificacin
					this.generarReintentoTramiteNotificacion(santramexp.getTrtridrel());
				}

				return tramiteAcuseRecibo;
			}

		} catch (Exception e) {
			SantramexpServiceImpl.logger
					.error("SanbandejaDaoImpl - addTramiteAcuseRecibo - EXCEPTION. " + e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Generar Reintento Tramite de Notificacion
	 * 
	 * @param trtridrel
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void generarReintentoTramiteNotificacion(String trtridrel) throws Exception {

		// Coger la notificacin relacionada con el sancionador
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(trtridrel);
		santramexp = this.santramexpDao.find(santramexp);

		// Crear la nueva notificacin en base a los campos de la ltima
		Santramexp santramexpNuevo = new Santramexp();
		santramexpNuevo.setTrcodigo(santramexp.getTrcodigo());
		santramexpNuevo.setExpedien(santramexp.getExpedien());
		santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
		santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitor());
		santramexpNuevo.setTrcodigorel(santramexp.getTrcodigorel());
		santramexpNuevo.setTrtridrel(santramexp.getTrtridrel());
		santramexpNuevo.setFase(santramexp.getFase());
		santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		santramexpNuevo.setTrasuntocomunicacion(santramexp.getTrasuntocomunicacion());
		santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
		santramexpNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
		santramexpNuevo.setTrenvrem(santramexp.getTrenvrem());
		santramexpNuevo.setTrtiponotplatea(santramexp.getTrtiponotplatea());
		santramexpNuevo.setTridnotifplatea(santramexp.getTridnotifplatea());
		santramexpNuevo.setTrtexto(santramexp.getTrtexto());
		santramexpNuevo.setTrautomatico(Y41bConstantes.VALOR_SI);

		santramexpNuevo = this.add(santramexpNuevo);

		// Relaciono tramite - documento
		this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
				santramexpNuevo.getTrid().toString());

		// Calcular el estado del trmite generado
		this.calcularEstadoTramiteGenerado(santramexpNuevo);

		// Actualizar la bandeja de arbitraje
		this.actualizaBandeja(santramexpNuevo);
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite
	 * acuse de recibo con el parametro recibido
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param destinatario
	 *            String
	 */
	private void actualizarOrigenDocsTramiteAcuseRecibo(TramiteComun tramiteComun, String destinatario) {
		String origen_doc = "";
		// Calculamos el origen del documento adjunto en el acuse a
		// partir del destinatario del tramite de notificacion
		Saninterv intervinientes = new Saninterv();
		intervinientes.setUaidinterv(new BigDecimal(destinatario));
		intervinientes = this.sanintervDao.find(intervinientes);
		String tipo_interviniente = intervinientes.getUatipointerv();
		if (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(tipo_interviniente)
				|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO;
		} else if (Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO.equals(tipo_interviniente)) {

			origen_doc = Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR.equals(tipo_interviniente)) {

			origen_doc = Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2;
		} else {
			origen_doc = Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS;
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Sandoctemp documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setU5origen(origen_doc);
				this.sandoctempDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Create ejgv document for comunication.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            the tipo procedimiento
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(
					Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteComunicacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 1/8");
			// buscar el interviniente
			Saninterv interviniente = new Saninterv();
			interviniente.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
			interviniente = this.sanintervDao.find(interviniente);
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 2/8");
			DatosPersona datosPersonaSolicitante = new DatosPersona();
			datosPersonaSolicitante.setDni(interviniente.getUanif().trim());
			datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
					: interviniente.getUanombre().concat(" ")
							.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
							.concat(" ")
							.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 3/8");
			datosPersonaSolicitante.setMail(interviniente.getUacoem());
			datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 4/8");
			crearNotifEJGV.setSender(datosPersonaSender);
			// Obtener tramite
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(tramiteComun.getIdTramite());
			santramexp = this.santramexpDao.find(santramexp);

			// Obtener el numero de expediente
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());

			expediente = this.expedienDao.find(expediente);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(expediente.damecodCompletoPlatea());
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 5/8");
			crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente
			crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES + ".serie."
					+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 6/8");
			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, null);

			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 7/8");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
					// obtener los datos del documento
					adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);
					if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho,
								tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
						// crear el objeto Sandoctemp
						Sandoctemp sandocTemp = new Sandoctemp();
						sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
						sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
						sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
						sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
						sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
						sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
						// crear el objeto Sandoctemp
						Arbdoctemp arbdocTemp = new Arbdoctemp();
						arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbdocTemp.setArbtipdoc(arbtipdoc);
						arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
						arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
						arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
						arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
						arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho,
								tramiteComunAux);
					}

					listDocumentos.add(documento);
				}
			}

			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 8/8");

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - createEJGVDocumentComunicacion. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentComunicacion(crearNotifEJGV);
			} else {
				// en odei
				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl - createEJGVDocumentComunicacion: 8/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl. - createEJGVDocumentComunicacion. Fin Llamada a Platea");
			// actualizar los oid document en bbdd
			// List<Documento> listDocumento = respuestaEjgv
			// .getDocumentosAdjuntos();
			// if (listDocumento != null && listDocumento.size() > 0) {
			// for (Documento documentoAux : listDocumento) {
			// // obtener los datos del documento
			// Sandoctemp documentoHecho = new Sandoctemp();
			//
			// documentoHecho.setU5codocumento(new Integer(documentoAux
			// .getIdDocumento()));
			// documentoHecho.setU5iddocumentum(documentoAux
			// .getOidDokusi());
			//
			// // Update oid de documentum
			// this.sandoctempDao.updateOIDDokusi(documentoHecho);
			// }
			// }
		} catch (Y41bUDAException e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			SantramexpServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			SantramexpServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		}
		return respuestaEjgv;
	}

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteComunicacionMail(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception {

		if (Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComunicacion.getDestinatario());
		}

		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}

		Santramexp santramexp = new Santramexp();

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramiteComunicacion.getFechaInicio());

		santramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
		santramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());

		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramiteComunicacion.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));

		santramexp.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());

		santramexp.setTruaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		// Remesas Ini
		santramexp.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		santramexp.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin
		santramexp.setTrsede(tramiteComunicacion.getSede());
		santramexp.setTrtipocom(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO);
		santramexp.setTrfecregs(tramiteComunicacion.getFechasalida());
		santramexp.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		santramexp.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());

		santramexp.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));

		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		santramexp.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		santramexp.setTrmailorigen(tramiteComunicacion.getMailorigen());
		santramexp.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		santramexp.setTrmaildestino(tramiteComunicacion.getMaildestino());

		santramexp = this.setSantramexp(santramexp);

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteComunicacion.getAnyadirPlantilla());

		// Mando el email
		boolean enviadoOk = this.envioEmailComunicacion(tramiteComunicacion, tramiteComun, listadjuntardocs,
				censoMonitor);
		if (!enviadoOk) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}

		// Si es comunicacion a asesoria juridica relacionada con
		// Elaboracion de informe a asesoria juridica generar tramite de
		// recepcion de orden consejero sin documentos
		Saninterv interviniente = new Saninterv();
		interviniente.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		interviniente = this.sanintervDao.find(interviniente);
		Saninterv intervinienteAsesoria = this.obtenerIntervinienteAsesoriaJuridica(tramiteComun);
		if (intervinienteAsesoria != null && intervinienteAsesoria.getUaentidad_id() != null
				&& intervinienteAsesoria.getUaentidad_id().equalsIgnoreCase(interviniente.getUaentidad_id())) {
			// Es una comunicacion a la asesoria juridica
			// Comprobar si esta relacionada con la la elaboracion de
			// documentacion para asesoria juridica
			if (santramexp != null && santramexp.getTrtridrel() != null) {
				Santramexp tramiteOriginal = new Santramexp();
				tramiteOriginal.setTrid(santramexp.getTrtridrel());
				tramiteOriginal = this.santramexpDao.find(tramiteOriginal);

				String codigoTipoTramite = tramiteOriginal.getTrcodigo();

				if (Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA.equals(codigoTipoTramite)) {
					this.sugiereTramiteOrdenConsejero(santramexp, false);
				}
			}
		}

		// Actualizar ultimo tramite
		this.actualizaUltimoTramiteEnSanExp(santramexp);

		this.insertEnvios(santramexp);

		// Tratar la bandeja, le mandamos el estado a tramitado porque es como
		// si le hubiera dado a tramitar
		this.actualizaBandeja(santramexp);

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;
	}

	/**
	 * Metodo que manda un email con la información de comunicacion recibida
	 * por parámetro.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 */
	private boolean envioEmailComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			List<Adjuntardocs> listadjuntardocs, CensoMonitor censoMonitor) throws Exception {

		try {
			// 1. Calculo FROM + TO del email

			String from = tramiteComunicacion.getMailorigen();
			String destinatariosMail = "";
			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));

			saninterv = this.sanintervDao.find(saninterv);

			if (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO)
					|| saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) {
				destinatariosMail = tramiteComunicacion.getMaildestino();
			} else {
				destinatariosMail = saninterv.getUacoem();
			}

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
			StringBuffer destinatarios = new StringBuffer();
			destinatarios.append(destinatariosMail);

			StringBuffer copiaoculta = new StringBuffer();
			copiaoculta.append(censoMonitor.getMocoem());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			// 2. Creo el asunto
			// Calculo el numero de expediente
			// Obtener el numero de expediente
			Expedien expedien = new Expedien();

			expedien.setExcodigo(tramiteComun.getIdExpediente());

			expedien = this.expedienDao.find(expedien);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(expedien.damecodCompletoPlatea());

			StringBuffer asunto = new StringBuffer();
			if (Y41bUtils.isFilled(tramiteComunicacion.getAsuntoComunicacion())) {
				asunto.append(tramiteComunicacion.getAsuntoComunicacion());
			} else {
				// Castellano
				asunto.append(this.appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
			}

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer();
			texto.append("<B>").append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ").append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.EUSKERA))).append("</B><BR><BR>");
			texto.append(tramiteComunicacion.getTextoComunicacion().replaceAll("\n", "<BR>"));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					Documento documento = new Documento();
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
							PlantillaDecision plantillaDecision = new PlantillaDecision();
							plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
							// Obtener la plantilla decision
							long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
							if (cont > 0) {// En esta tabla las
											// plantillas son
											// localizables
											// siempre
								documento.setNolocalizable(Y41bConstantes.VALOR_NO);
							}
						}
					}
					// La orden del consejero se trata como aportada por la
					// administracion
					if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO
							.equals(adjuntardocs.getThidtipodoc())) {
						adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
					}
					if (Y41bUtils.isDocumentoLocalizable(adjuntardocs) && (documento.getNolocalizable() == null
							|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {
						if (Y41bUtils.interactuarConDokusi()) {
							if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
								// 1.User
								User user = new User();
								user.setNombre(Y41bConstantes.COD_APLICACION);
								user.setDni(Y41bConstantes.COD_APLICACION);
								documento.setUser(user);
								Procedure procedure = new Procedure();
								procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
								documento.setProcedure(procedure);
								documento.setOidDokusi(adjuntardocs.getThiddocumentum());
								Formato formato = this.y41bDokusiAdapterService
										.recuperarFormatosDocumentosDokusi(documento);

								if (formato != null && formato.getName().equalsIgnoreCase(Y41bConstantes.PDFA)) {
									if (adjuntardocs != null && adjuntardocs.getThnofile() != null
											&& !com.ejie.y41b.utils.Y41bUtils
													.getExtensionFile(adjuntardocs.getThnofile())
													.equalsIgnoreCase(Y41bConstantes.PDF)) {
										throw new Y41bUDAException("error.documentos.sinlocalizador", true,
												new Exception());
									}
								} else {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						}
					}
					AttachFile fileattach = new AttachFile();
					Sandoctemp sandoctempObj = new Sandoctemp();
					sandoctempObj.setU5codocumento(adjuntardocs.getThcodocumento());

					Sandoctemp documentoHechoAux = (Sandoctemp) this.sandoctempService.find(sandoctempObj);

					fileattach.setContentType(adjuntardocs.getThcontenttypefile());
					fileattach.setNombre(adjuntardocs.getThnofile());
					fileattach.setAdjunto(documentoHechoAux.getU5datafile());

					attachments.add(fileattach);

				}
			}

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), copiaoculta.toString(), attachments);

			return envio;
		} finally {
			// 6. Borro de tablas LOB los documentos
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				Sandoctemp documentoHechoDetalle = null;
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					documentoHechoDetalle = new Sandoctemp();
					documentoHechoDetalle.setU5codocumento(adjuntardocs.getThcodocumento());
					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 11. FINALLY. bucle."
									+ adjuntardocs.getThcodocumento() + ".");
				}
			}
		}
	}

	/**
	 * Guardar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esComunicacionOrdinaria
	 *            the es notificacion ordinaria
	 * @param esComunicacionElectronica
	 *            the es notificacion tipo electronica
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile, CensoMonitor censoMonitor) throws Exception {

		if (tramitar && Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComunicacion.getDestinatario());
		}

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 1/14.\ntramitar:" + tramitar
				+ ".\nmodoEditar" + modoEditar + ".\nesNotificacionTipoElectronica" + esComunicacionElectronica + ".");
		Santramexp santramexp = new Santramexp();

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
		santramexp.setTrfecini(tramiteComunicacion.getFechaInicio());

		santramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
		santramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());

		// Remesas Ini
		santramexp.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		santramexp.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin

		if (tramitar) {
			santramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
			santramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 2/14.");

		santramexp.setExpedien(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramiteComunicacion.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));

		santramexp.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());
		santramexp.setTruaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		santramexp.setTrsede(tramiteComunicacion.getSede());
		santramexp.setTrtipocom(esComunicacionElectronica ? Y41bConstantes.TIPO_COMUNICACION_TELEMATICA
				: Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO);
		santramexp.setTrfecregs(tramiteComunicacion.getFechasalida());
		santramexp.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		santramexp.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		santramexp.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));
		santramexp.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		santramexp.setTrmailorigen(tramiteComunicacion.getMailorigen());
		santramexp.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		santramexp.setTrmaildestino(tramiteComunicacion.getMaildestino());

		// Se inserta el tramite
		santramexp.setTrid(tramiteComun.getIdTramite());

		SantramexpServiceImpl.logger.info(
				"SantramexpServiceImpl - addTramiteComunicacion: 3/14." + new BigDecimal(tramiteComun.getIdTramite()));

		// Obtener registro salida si no viene de pantalla
		if (tramitar && esComunicacionOrdinaria) {
			if (santramexp.getTrenvrem() == null || Y41bConstantes.NO.equals(santramexp.getTrenvrem())) {
				if (santramexp.getTrnumregs() == null || santramexp.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							tramiteComunicacion.getDestinatario(), false);
					santramexp.setTrnumregs(registroSalida.getRegistryNumber());
					santramexp.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 4/14.");
		santramexp = this.setSantramexp(santramexp);

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, null);

		SantramexpServiceImpl.logger
				.info("SantramexpServiceImpl - addTramiteComunicacion: 5/14.\n" + tramiteComun.toString());

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteComunicacion.getAnyadirPlantilla());

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 6/14.");

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 7/14.");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 8/14.");

			if (esComunicacionOrdinaria) {
				this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, santramexp,
						tramiteComunAux, idZipFile);
			} else {
				this.procesarComunicacionElectronica(listDocumentoHecho, tramiteComunicacion, santramexp, censoMonitor);
			}

			// Si es comunicacion a asesoria juridica relacionada con
			// Elaboracion de informe a asesoria juridica generar tramite de
			// recepcion de orden consejero sin documentos
			Saninterv interviniente = new Saninterv();
			interviniente.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
			interviniente = this.sanintervDao.find(interviniente);
			Saninterv intervinienteAsesoria = this.obtenerIntervinienteAsesoriaJuridica(tramiteComun);
			if (intervinienteAsesoria != null && intervinienteAsesoria.getUaentidad_id() != null
					&& intervinienteAsesoria.getUaentidad_id().equalsIgnoreCase(interviniente.getUaentidad_id())) {
				// Es una comunicacion a la asesoria juridica
				// Comprobar si esta relacionada con la la elaboracion de
				// documentacion para asesoria juridica
				if (santramexp != null && santramexp.getTrtridrel() != null) {
					Santramexp tramiteOriginal = new Santramexp();
					tramiteOriginal.setTrid(santramexp.getTrtridrel());
					tramiteOriginal = this.santramexpDao.find(tramiteOriginal);

					String codigoTipoTramite = tramiteOriginal.getTrcodigo();

					if (Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA.equals(codigoTipoTramite)) {
						this.sugiereTramiteOrdenConsejero(santramexp, false);
					}
				}
			}

			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 9/14.");
			/* actualizamos la bandeja */
			this.actualizaBandeja(santramexp);
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 10/14.");

			/* actualizamos el ultimo tramite */
			this.actualizaUltimoTramiteEnSanExp(santramexp);
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 11/14.");

			/* actualizo los envios del expediente */
			this.insertEnvios(santramexp);
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl - addTramiteComunicacion: 12/14." + tramiteComunicacion.getEjgvDocument());

			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl - addTramiteComunicacion - Genero el aviso para la orden del consejero si procede. ");
			// Si se envia a remesa se generarn los avisos en remesas
			if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				this.crearAvisoNotifiComuniRegistroSalida(santramexp);
			}
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 13/14.");

			// Para las comunicaciones que no van por remesa, informamos a mis
			// gestiones
			if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(santramexp.getTruaidinterv());
				saninterv = this.sanintervDao.find(saninterv);
				if (saninterv != null && saninterv.getUatipointerv() != null
						&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
								|| saninterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
								|| saninterv.getUatipointerv().equals(
										Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))) {
					listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);
					this.actualizarMisGestionesComunicacion(santramexp, listDocumentoHecho);
				}
			}
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: 14/14.");

		} else {

			this.actualizaBandeja(santramexp);

			/******************************************/
			SantramexpServiceImpl.logger
					.info("SantramexpServiceImpl - addTramiteComunicacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun);
		}

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteComunicacion: FIN.");

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;

	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarBandejaFirma(List<Sandoctemp> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		try {
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				// Elimino de la Bandeja de Firma los documentos del tramite
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				// Calculo el numero del expediente para Dokusi
				Expedien expDetalle = new Expedien();
				expDetalle.setExcodigo(tramiteComun.getIdExpediente());

				expDetalle = this.expedienDao.find(expDetalle);

				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(expDetalle.getExcoor()).append("-").append(expDetalle.getExnror()).append("-")
						.append(expDetalle.getExnran());

				// Recorro los documentos del tramite buscando aquel documento
				// que
				// este pendiente de firma
				Sandoctemp documentoHecho = null;
				Sandoctemp documentoHechoDetalleAux = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getU5estadodocumento())) {
						documentoHecho = this.limpiarOidSiErrorLocalizacion(documentoHecho);
						// Si esta pendiente de firma, lo primero lo meto en
						// Dokusi
						// si NO esta dado de alta ya
						if (!Y41bUtils.isFilled(documentoHecho.getU5iddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
							documento.setProcedure(procedure);
							String tipoDocumental = "";
							if (Y41bUtils.isFilled(documentoHecho.getU5tipodocumento())) {
								Santipdoc santipdoc = new Santipdoc();
								santipdoc.setTdid(documentoHecho.getU5tipodocumento());
								santipdoc = this.santipdocDao.find(santipdoc);
								tipoDocumental = santipdoc.getIdTipodoc();

							} else {
								tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
							}
							documento.setTipoDocumental(tipoDocumental);

							documento.setIdDocumento(documentoHecho.getU5codocumento().toString());

							documento.setNombre(Y41bUtils.getNameFile(documentoHecho.getU5nofile()));
							documento.setDescripcion(documentoHecho.getU5tedesfile());
							documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getU5nofile()));
							// Recupero el [] byte
							documentoHechoDetalleAux = new Sandoctemp();
							documentoHechoDetalleAux.setU5codocumento(documentoHecho.getU5codocumento());

							documentoHechoDetalleAux = this.sandoctempService.find(documentoHechoDetalleAux);
							Blob contenido = documentoHechoDetalleAux.getU5datafile();

							byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

							documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
							if (Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION
									.equals(documentoHecho.getU5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE
									.equals(documentoHecho.getU5origen())
									|| Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2
											.equals(documentoHecho.getU5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
							} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO.equals(documentoHecho.getU5origen())
									|| Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO
											.equals(documentoHecho.getU5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
							} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_ESTABLECIMIENTO
									.equals(documentoHecho.getU5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
							} else if (Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS.equals(documentoHecho.getU5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							} else {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							}

							StringBuffer numeroExpedienteDokusi = new StringBuffer();
							numeroExpedienteDokusi.append(Y41bConstantes.TIPO_PROC_SANCIONES).append("-")
									.append(numeroExpediente);

							documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

							// El tipo documental liquidacion tiene un metadato
							// propio
							if (Y41bConstantes.TIPO_DOC_LIQUIDACION.equals(documento.getTipoDocumental())) {
								Santramexp santramexp = new Santramexp();
								santramexp.setTrid(tramiteComun.getIdTramite());
								santramexp = this.santramexpDao.find(santramexp);
								String s_metadato = Y41bUtils.esNullOCadenaVacia(santramexp.getTrreferencia()) ? "0"
										: santramexp.getTrreferencia();
								List<Metadato> metadatos = new ArrayList<Metadato>();
								Metadato metadato = new Metadato();
								metadato.setNombre("ejgv_num_liquidacion");
								metadato.setValor(s_metadato);
								metadatos.add(metadato);
								documento.setMetadatos(metadatos);
							}

							if (Y41bUtils.interactuarConDokusi()) {
								Documento documentoRdo = this.y41bDokusiAdapterService
										.registrarDocumentoDokusi(documento);
								documentoHecho.setU5iddocumentum(documentoRdo.getOidDokusi());

								/**
								 * no tiene sentido actualizar lo del
								 * localizador en adjuntardocs porque para
								 * cuando se llama a esto ya se ha hecho el
								 * remove de todos los elementos de la tabla
								 * adjuntardocs
								 */
							}

							// Update oid de documentum
							this.sandoctempDao.updateOIDDokusi(documentoHecho);

							if (Y41bUtils.isDocumentoTransformable(documento)) {
								this.sandoctempDao.updateFechaLocalizacion(documentoHecho);
							} else {
								this.sandoctempDao.removeBlobFromOIDDokusi(documentoHecho);
							}
						}
						// Lo segundo lo meto en la Bandeja de Firma
						bandejaFirma = new BandejaFirma();

						bandejaFirma
								.setIdbandejafirma(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						bandejaFirma.setIdexpediente(tramiteComun.getIdExpediente());
						bandejaFirma.setExpediente(numeroExpediente.toString());
						bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
						bandejaFirma.setHccoor(expDetalle.getSanexp().getExcooractual());
						bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
						bandejaFirma.setTrcodigo(tipoTramite);

						Fase fase = new Fase();
						fase.setFcodigo(faseTramite);
						bandejaFirma.setFase(fase);

						bandejaFirma.setCodocumento(documentoHecho.getU5codocumento());
						bandejaFirma.setIddocumentum(documentoHecho.getU5iddocumentum());
						bandejaFirma.setNofile(documentoHecho.getU5nofile());
						bandejaFirma.setFechalimfirma(new Date());
						bandejaFirma.setIdperfilfirma(documentoHecho.getU5idPerfilfirma());
						bandejaFirma.setDesfile(documentoHecho.getU5tedesfile());

						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_SANCIONES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getU5iddocumentum());

						Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

						documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

						String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
						bandejaFirma.setHashfile(hashDocumento);

						if (bandejaFirma.getIdperfilfirma() != null
								&& bandejaFirma.getIdperfilfirma().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
							Sanexp sanexp = new Sanexp();
							sanexp.setExcodigo(expDetalle.getSanexp().getExcodigo());
							sanexp = this.sanexpDao.dameDetallesExpediente(sanexp);

							bandejaFirma.setComoasigfirma(sanexp.getExmocodigo());
						}

						this.bandejaFirmaDao.add(bandejaFirma);
					}
				}
			}
		} catch (Exception e) {
			throw e;
		}

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramite, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteBOPVAyto tramiteAux = new TramiteBOPVAyto();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setFechaPublicacionBOPV(santramexp.getTrfecbopv());
		tramiteAux.setFechaPublicacionAyto(santramexp.getTrfecinitabl());
		tramiteAux.setFechaEnvioBOPVBOE(santramexp.getTrfechaEnvioBOPVBOE());

		if (santramexp.getTrtridrel() != null) {
			TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
			tramiteNotificacionWhere.setIdTramite(santramexp.getTrtridrel().toString());
			TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
					censoMonitor);

			tramiteAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		}

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite,
			CensoMonitor monitor) throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteElaboracionBOPVAyto tramiteAux = new TramiteElaboracionBOPVAyto();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setFechaPublicacionBOPV(santramexp.getTrfecbopv());
		tramiteAux.setFechaPublicacionAyto(santramexp.getTrfecinitabl());

		if (santramexp.getTrtridrel() != null) {
			TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
			tramiteNotificacionWhere.setIdTramite(santramexp.getTrtridrel().toString());
			TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
					censoMonitor);

			tramiteAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		}

		if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteBOPVAyto(TramiteBOPVAyto tramite, TramiteComun tramiteComun, boolean tramitar,
			String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp.setTrid(tramiteComun.getIdTramite());
			santramexp = this.santramexpDao.find(santramexp);
		}

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// Propio del tramite
		santramexp.setTrfecbopv(tramite.getFechaPublicacionBOPV());
		santramexp.setTrfecinitabl(tramite.getFechaPublicacionAyto());
		santramexp.setTrfechaEnvioBOPVBOE(tramite.getFechaEnvioBOPVBOE());
		/*************************************************************
		 * ESPECIAL DE ESTE TRAMITE
		 */
		/*
		 * Prevalece la fecha del BOE Date fechaMayorBOPVAyunta =
		 * (tramite.getFechaPublicacionBOPV()
		 * .after(tramite.getFechaPublicacionAyto())) ? tramite
		 * .getFechaPublicacionBOPV() : tramite.getFechaPublicacionAyto();
		 */
		// Prevalece la del BOE
		Date fechaMayorBOPVAyunta = tramite.getFechaPublicacionAyto();
		/*************************************************************
		 * ESPECIAL DE ESTE TRAMITE
		 */

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			/*
			 * Validacion: Debe haber almenos 1 documento NO ES OBLIGATORIO EN
			 * ESTE TRAMITE if (listDocumentoHecho != null &&
			 * listDocumentoHecho.size() < 1) { // throw new Y41bUDAException(
			 * // "error.solicitud.documentoException", true, // new
			 * Exception()); }
			 */
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {

				// trato la recepci�n del acuse
				String idTramiteNotificacion = santramexp.getTrtridrel();
				Santramexp tramiteNotificacionOriginal = this.find(new Santramexp(idTramiteNotificacion));

				// ACTUALIZACI�N DE FECHAS ETC.
				this.tratarAcuseRecogido(tramiteNotificacionOriginal, fechaMayorBOPVAyunta);

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);

				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(santramexp.getTruaidinterv());
				saninterv = this.sanintervDao.find(saninterv);

				if (saninterv != null && saninterv.getUatipointerv() != null
						&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
										.equals(saninterv.getUatipointerv()))) {
					TramiteComun tramiteComunNot = new TramiteComun();
					tramiteComunNot.setIdTramite(tramiteNotificacionOriginal.getTrid().toString());
					List<Sandoctemp> listDocumentos = this.sandoctempDao.findAllDocumentosTramite(tramiteComunNot,
							null);
					this.actualizarMisGestionesNotificacion(santramexp, listDocumentos);
				}
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite, TramiteComun tramiteComun,
			boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp.setTrid(tramiteComun.getIdTramite());
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// Propio del tramite
		// santramexp.setTrfecbopv(tramite.getFechaPublicacionBOPV());
		// santramexp.setTrfecinitabl(tramite.getFechaPublicacionAyto());

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				this.sugiereTramitePublicacionBopvTablonAutomaticamente(santramexp);
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	/**
	 * @param tramite
	 *            TramiteSANLiquidacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteLiquidacion(TramiteSANLiquidacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		long cont = this.santramexpDao.findAllCount(santramexp);
		if (cont > 0L) {
			santramexp = this.santramexpDao.find(santramexp);
		}
		if (tramitar && Y41bUtils.esNullOCadenaVacia(santramexp.getTrreferencia())) {
			throw new Y41bUDAException("error.liquidacion.noHayReferencia", true, null);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporteResolucion()) ? null
				: new BigDecimal(tramite.getImporteResolucion().replace('\u002c', '\u002e')));
		santramexp.setTrimporteinicial(Y41bUtils.esNullOCadenaVacia(tramite.getImporteInicial()) ? null
				: new BigDecimal(tramite.getImporteInicial().replace('\u002c', '\u002e')));
		santramexp.setTrprontopago(tramite.getProntoPago());
		santramexp.setTrreconocimiento(tramite.getReconocimiento());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);

				/* notificamos a cada uno de los sancionados */

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				/*
				 * sugerimos una tarea de comunicacion para cada interesado si
				 * la liquidacion proviene de una resolucion en el caso de orden
				 * del consejero NO se envia comunicacion
				 */
				if (santramexp.getTrcodigorel() != null
						&& santramexp.getTrcodigorel().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
					List<Saninterv> listaInteresados = this.sanintervDao.findAllInteresados(expedien);
					if (listaInteresados != null) {
						for (int i = 0; i < listaInteresados.size(); i++) {
							Long idInterviniente = Long
									.parseLong(((Saninterv) listaInteresados.get(i)).getUaidinterv().toString());
							/*
							 * para cada interviniente sugiero una notificacion
							 */
							this.sugiereTramiteComunicacionAutomaticamente(santramexp, idInterviniente, false);
						}
					}
				}

				/*
				 * Comentado por 86472: [Evolutivo Bandejas ] - Tramite de
				 * Cierre  Sancionador boolean isTramiteCierre =
				 * this.existenMasTramites( tramiteComun.getIdExpediente(), "",
				 * Y41bConstantes.TRAMITE_SANCIONES_CIERRE); if
				 * (!isTramiteCierre) {
				 * this.sugiereTramiteCierreAutomaticamente(santramexp); }
				 */

				this.actualizaBandeja(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;

	}

	/**
	 * @param tramite
	 *            TramiteSANLiquidacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANLiquidacion
	 */
	public TramiteSANLiquidacion findTramiteLiquidacion(TramiteSANLiquidacion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANLiquidacion tramiteAux = new TramiteSANLiquidacion();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());
			tramiteAux.setIdExpediente(santramexp.getExpedien().getExcodigo());
			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			// BigDecimal importe = this.getImporteResolucion(santramexp
			// .getExpedien().getExcodigo());
			// if (importe != null) {
			// tramiteAux.setImporteResolucion(Y41bUtils
			// .formatDouble2decimalesYcoma(importe.doubleValue()));
			// }

			tramiteAux.setImporteSancion(santramexp.getTrresoimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));
			tramiteAux.setImporteInicial(santramexp.getTrimporteinicial() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrimporteinicial().doubleValue()));
			tramiteAux.setProntoPago(santramexp.getTrprontopago());
			tramiteAux.setReconocimiento(santramexp.getTrreconocimiento());
			tramiteAux.setReferencia(santramexp.getTrreferencia());
			/*
			 * PROPIO DEL TRAMITE
			 */
			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionComplementaria
	 * @param censoMonitor
	 *            CensoMonitor monitor
	 * @return TramiteSANLiquidacion
	 */
	public TramiteSANLiquidacion findTramiteResolucionComplementariaLiquidacion(
			TramiteSANResolucionComplementaria tramite, CensoMonitor censoMonitor) {

		TramiteSANLiquidacion tramiteBerria = new TramiteSANLiquidacion();
		tramiteBerria.setIdTramite(tramite.getIdTramite());
		return this.findTramiteLiquidacion(tramiteBerria, censoMonitor);

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteResolucionComplementaria(TramiteSANResolucionComplementaria tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		Expedien expedien = new Expedien();

		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		santramexp.setExpedien(expedien);
		// santramexp.setTrreferencia(tramite.getIban());
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporteResolucion()) ? null
				: new BigDecimal(tramite.getImporteResolucion().replace('\u002c', '\u002e')));
		santramexp.setTrreferencia(tramite.getReferencia());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);
			}

		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionRecursoPrueba
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANResolucionRecursoPrueba
	 */
	public TramiteSANResolucionRecursoPrueba findTramiteResolucionRecursoPrueba(
			TramiteSANResolucionRecursoPrueba tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANResolucionRecursoPrueba tramiteAux = new TramiteSANResolucionRecursoPrueba();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */
			tramiteAux.setTipoEstimacion(santramexp.getTrestimacion());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun) {
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		this.sandoctempDao.addSanAdjuntarDocs(tramiteComun);
	}

	/**
	 * Tramitar cierre.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteCierre.EXPEIDENTE:"
				+ tramiteComun.getIdExpediente() + ".IDTRAMITE: " + tramiteComun.getIdTramite() + ".");

		Santramexp santramexp = new Santramexp();

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		String idExpediente = tramiteCierre.getIdExpediente();

		if (tramitar) {

			/* CANCELAMOS EL AVISO SOBRE EL PLAZO RECURSO DE ALZADA */
			SantramexpServiceImpl.logger.info(
					"SanbandejaDaoImpl - addTramiteElaboracionInformeAsesoria - Elimino aviso sobre recurso de alzada ");
			Pagination pagination = new Pagination();
			pagination.setSort("BAFECLIMITE");
			pagination.setSord("ASC");

			Sanbandeja sanbandeja = new Sanbandeja();
			sanbandeja.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION);
			List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, pagination);
			if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
				// Borramos todos los avisos
				for (int i = 0; i < listaAvisosCancelar.size(); i++) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(i));
				}
			}

			santramexp.setTrfecfin(tramiteCierre.getFechaFin());
			santramexp.setCensoMonitorEj(tramiteCierre.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(idExpediente);
		expedien = this.expedienDao.find(expedien);

		// no cambiamos la fase

		santramexp.setTrfecini(tramiteCierre.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
		santramexp.setFase(new Fase(Y41bConstantes.FASE_CIERRE_SANCION));
		santramexp.setCensoMonitor(tramiteCierre.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteCierre.getComentario()));

		santramexp.setTrfeccierre(tramiteCierre.getFechaCierre());

		santramexp = this.setSantramexp(santramexp);

		boolean isTramiteCierre = this.existenMasTramites(tramiteCierre.getIdExpediente(), tramiteCierre.getIdTramite(),
				Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
		if (isTramiteCierre) {
			throw new Y41bUDAException("error.tramiteCierre.existeCierre", true, null);
		}

		if (tramitar) {
			// if (!this.isAllTramitesTramitados(idExpediente)) {
			// throw new Y41bUDAException(
			// "error.tramiteCierre.tramitesPendientes", true, null);
			// }

			this.actualizaUltimoTramiteEnSanExp(santramexp);

			/* Se vaca la bandeja */
			this.sanbandejaDao.removeAllEntradas(tramiteCierre.getIdExpediente());

			this.actualizaExpedienteTrasTramitar(santramexp);

			this.actualizaFaseEnSanExpDesdeTramite(tramiteCierre.getIdExpediente(),
					Y41bConstantes.TRAMITE_SANCIONES_CIERRE);

			// 5. Cerramos el expediente en PLATEA
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(expedien.damecodCompletoPlatea());
			CierreExpediente cierreExpediente = new CierreExpediente();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
			cierreExpediente.setProcedure(procedure);
			cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
			cierreExpediente.setEjercicio(expedien.getExnran().toString());
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl. - cerrarExpediente. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
			}
			SantramexpServiceImpl.logger.info("SantramexpServiceImpl. - cerrarExpediente. Fin Llamada a Platea");
		} else {
			this.actualizaBandeja(santramexp);
		}

		return santramexp;
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteResolucionRecursoPrueba(TramiteSANResolucionRecursoPrueba tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setExpedien(expedien);
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrestimacion(tramite.getTipoEstimacion());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

				this.actualizaBandeja(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANResolucion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANResolucion
	 */
	public TramiteSANResolucion findTramiteResolucion(TramiteSANResolucion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);

			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANResolucion tramiteAux = new TramiteSANResolucion();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */

			tramiteAux.setFechaResolucion(santramexp.getTrresofecha());
			tramiteAux.setImporteSancion(santramexp.getTrresoimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));
			tramiteAux.setTipoSancionAccesoria(santramexp.getTrresosan());
			tramiteAux.setTipoResolucion(santramexp.getTrresotipo());

			tramiteAux.setProntoPago(santramexp.getTrprontopago());
			tramiteAux.setReconocimiento(santramexp.getTrreconocimiento());
			tramiteAux.setImporteInicial(santramexp.getTrimporteinicial() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrimporteinicial().doubleValue()));

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteResolucion(TramiteSANResolucion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		boolean decisionError = Y41bConstantes.DECISION_SANCION_ERROR.equals(tramite.getTipoResolucion().toString());

		if (tramitar) {
			if (Y41bConstantes.VALOR_NO.equals(tramite.getProntoPago())
					&& Y41bConstantes.VALOR_NO.equals(tramite.getReconocimiento())) {
				// Si la decision es error no se comprueba la secuencia de
				// fechas
				if (!decisionError && !this.compruebaSecuenciaFechasTramitacion(tramiteComun.getIdExpediente(),
						tramiteComun.getIdTipoTramite(), tramite.getFechaResolucion())) {
					throw new Y41bUDAException("error.validacion.fechasTramitacion", true, null);
				}
			}
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrresofecha(tramite.getFechaResolucion());
		santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporteSancion()) ? null
				: new BigDecimal(tramite.getImporteSancion().replace('\u002c', '\u002e')));
		santramexp.setTrresosan(tramite.getTipoSancionAccesoria());
		santramexp.setTrresotipo(tramite.getTipoResolucion());
		santramexp.setTrimporteinicial(Y41bUtils.esNullOCadenaVacia(tramite.getImporteInicial()) ? null
				: new BigDecimal(tramite.getImporteInicial().replace('\u002c', '\u002e')));
		santramexp.setTrreconocimiento(tramite.getReconocimiento());
		santramexp.setTrprontopago(tramite.getProntoPago());

		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// Buscamos los documentos almacenados con anterioridad
		List<Sandoctemp> listDocumentosAnteriores = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento si la decision no es error
			if (!decisionError) {
				if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
					// Validacion: Debe haber almenos 1 documento
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				// Solo se crean tramites automaticamente si la decision no es
				// error
				if (!decisionError) {
					/*
					 * solo la sugerimos si ha acabado con tipo de resolucion
					 * sancion y no esta pagada en prontopago
					 */
					if (Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago())) {
						List<Saninterv> listaInteresados = this.sanintervDao.findAllInteresados(expedien);
						if (listaInteresados != null) {
							for (int i = 0; i < listaInteresados.size(); i++) {
								Long idInterviniente = Long
										.parseLong(((Saninterv) listaInteresados.get(i)).getUaidinterv().toString());
								/*
								 * para cada interviniente sugiero una
								 * notificacion
								 */
								this.sugiereTramiteComunicacionAutomaticamente(santramexp, idInterviniente, false);
							}
						}
					} else {
						if ((Y41bConstantes.DECISION_SANCION_SANCION + "")
								.equals(tramite.getTipoResolucion().toString())) {
							this.sugiereTramiteLiquidacionAutomaticamente(santramexp);
						} else {

							this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);

							/* En este caso no se sugieren comunicaciones */

							/*
							 * Comentado por 86472: [Evolutivo Bandejas ] -
							 * Tramite de Cierre  Sancionador boolean
							 * isTramiteCierre = this.existenMasTramites(
							 * tramiteComun.getIdExpediente(), "",
							 * Y41bConstantes.TRAMITE_SANCIONES_CIERRE); if
							 * (!isTramiteCierre) {
							 * this.sugiereTramiteCierreAutomaticamente
							 * (santramexp); }
							 */
						}
					}
				}

				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);

				/*
				 * ELIMINO EL AVISO SOBRE LA PROPUESTA DE RESOLUCION, SOLO HABRA
				 * UNO
				 */
				SantramexpServiceImpl.logger
						.info("SanbandejaDaoImpl - addTramiteResolucion - Elimino aviso sobre propuesta resolucion ");

				Sanbandeja sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL);
				List<Sanbandeja> listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteResolucion - ELIMINADO. ");
				}

				/*
				 * ELIMINO EL AVISO SOBRE LA RESOLUCION, SOLO HABRA UNO
				 */
				SantramexpServiceImpl.logger
						.info("SanbandejaDaoImpl - addTramiteResolucion - Elimino aviso sobre resolucion ");

				sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_RESOL);
				listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteResolucion - ELIMINADO. ");
				}

				/*
				 * ELIMINO EL AVISO SOBRE ALEGACIONES A LA PROPUESTA
				 */
				sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL);
				listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteResolucion - ELIMINADO. ");
				}

				/*
				 * ELIMINO EL AVISO SOBRE ALEGACIONES A LA SOLICITUD DE PRUEBA
				 */
				sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA);
				listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteResolucion - ELIMINADO. ");
				}

				/*
				 * ELIMINO EL AVISO SOBRE NOTIFICACION DEL ACUERDO DE INCOACION
				 */
				sanbandeja = new Sanbandeja();
				sanbandeja.setExpedien(new Expedien(expedien.getExcodigo()));
				sanbandeja.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC);
				listaAvisosCancelar = this.sanbandejaDao.findAll(sanbandeja, null);
				if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
					this.sanbandejaDao.remove(listaAvisosCancelar.get(0));
					SantramexpServiceImpl.logger.info("SanbandejaDaoImpl - addTramiteResolucion - ELIMINADO. ");
				}
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		if (!Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago())
				&& Y41bConstantes.DECISION_SANCION_SANCION.equals(tramite.getTipoResolucion())) {
			this.enviarEmailRevisionDocumento(tramiteComun.getIdExpediente(), listDocumentosAnteriores,
					listDocumentoHecho, tramite.getInstructorEjecucion(), Y41bConstantes.FASE_RESOLUCION_SANCION);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionComplementaria
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANResolucionComplementaria
	 */
	public TramiteSANResolucionComplementaria findTramiteResolucionComplementaria(
			TramiteSANResolucionComplementaria tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANResolucionComplementaria tramiteAux = new TramiteSANResolucionComplementaria();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			// tramiteAux.setImporteResolucion(Y41bUtils
			// .formatDouble2decimalesYcoma(this.getImporteResolucion(
			// tramite.getIdExpediente()).doubleValue()));

			tramiteAux.setImporteResolucion(santramexp.getTrresoimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));
			tramiteAux.setReferencia(santramexp.getTrreferencia());
			/*
			 * PROPIO DEL TRAMITE
			 */
			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {

			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - createEJGVDocumentNotificacion: 1/8");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();

			procedure.setIdProcedimiento(
					Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteNotificacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - createEJGVDocumentNotificacion: 2/8");

			Saninterv interviniente = new Saninterv();
			interviniente.setUaidinterv(new BigDecimal(tramiteNotificacion.getDestinatario()));
			interviniente = this.sanintervDao.find(interviniente);

			DatosPersona datosPersonaSolicitante = new DatosPersona();
			datosPersonaSolicitante.setDni(interviniente.getUanif().trim());
			datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
					: interviniente.getUanombre().concat(" ")
							.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
							.concat(" ")
							.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));
			datosPersonaSolicitante.setMail(interviniente.getUacoem());
			datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

			crearNotifEJGV.setSender(datosPersonaSender);

			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());

			expediente = this.expedienDao.find(expediente);

			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			// Obtener tramite
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(tramiteComun.getIdTramite());
			santramexp = this.santramexpDao.find(santramexp);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(expediente.damecodCompletoPlatea());

			crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente

			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			String serieDocumental = prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES + ".serie."
					+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString()));

			crearNotifEJGV.setSerieDocumental(serieDocumental);

			// El tipo de notificacion para PLATEA
			// En la JSP va "PRUEBAS" para distinguirlo del tipo de resolucion
			// recurso de alzada
			// Antes de enviar a Platea tenemos que tratarlo
			if ("PRUEBAS".equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				crearNotifEJGV.setIdTipoNotificacion(
						Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA);
			} // EVOLUTIVO 0135083 2.4 como requerimiento ya esta siendo
				// utilizado,
				// se usa otrA ANTES DE ENVIARLO A PLATEA
			else if ("REQUERIMIENTOINFORMACION".equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				crearNotifEJGV.setIdTipoNotificacion(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO);
			} else {
				crearNotifEJGV.setIdTipoNotificacion(tramiteNotificacion.getTipoNotificacionPlatea());
			}

			// Recupero de la tabla temporal la lista de documentos del
			// expediente

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, null);
			SantramexpServiceImpl.logger.info(
					"SantramexpServiceImpl - createEJGVDocumentNotificacion: 4/8" + tramiteComun.getIdTramite() + ".");
			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {

				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl - createEJGVDocumentNotificacion: 5/8" + listadjuntardocs.size() + ".");
				for (Adjuntardocs adjuntardocsAuxAntiguo : listadjuntardocs) {

					// obtener los datos del documento
					Adjuntardocs adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAuxAntiguo);
					if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho,
								tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
						// crear el objeto Sandoctemp
						Sandoctemp sandocTemp = new Sandoctemp();
						sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
						sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
						sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
						sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
						sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
						sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
						// crear el objeto Sandoctemp
						Arbdoctemp arbdocTemp = new Arbdoctemp();
						arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbdocTemp.setArbtipdoc(arbtipdoc);
						arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
						arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
						arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
						arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
						arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho,
								tramiteComunAux);
					}

					listDocumentos.add(documento);
				}
			}

			if (listDocumentos != null) {
				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl - createEJGVDocumentNotificacion: 6/8" + listDocumentos.size() + ".");
			}

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

			if (Y41bUtils.interactuarConDokusi()) {
				SantramexpServiceImpl.logger
						.info("SantramexpServiceImpl. - crearEJGVDocumentNotificacion. Inicio Llamada a Platea");
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentNotificacion(crearNotifEJGV);
				SantramexpServiceImpl.logger
						.info("SantramexpServiceImpl. - crearEJGVDocumentNotificacion. Fin Llamada a Platea");

				// actualizar los oid document en bbdd
				List<Documento> listDocumento = respuestaEjgv.getDocumentosAdjuntos();

				if (listDocumento != null && listDocumento.size() > 0) {

					SantramexpServiceImpl.logger.info(
							"SantramexpServiceImpl - createEJGVDocumentNotificacion: 7/8" + listDocumento.size() + ".");

					for (Documento documentoAux : listDocumento) {
						// obtener los datos del documento
						Sandoctemp documentoHecho = new Sandoctemp();

						documentoHecho.setU5codocumento(documentoAux.getIdDocumento());
						SantramexpServiceImpl.logger
								.info("SantramexpServiceImpl - createEJGVDocumentNotificacion:OID.DOKUSI "
										+ documentoAux.getOidDokusi() + ".");
						documentoHecho.setU5iddocumentum(documentoAux.getOidDokusi());

						// Update oid de documentum
						this.sandoctempDao.updateOIDDokusi(documentoHecho);
						this.sandoctempDao.removeBlobFromOIDDokusi(documentoHecho);

						// Actualizo OID Dokusi en tabla documentos
						// intermedia
						Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

						adjuntardocsAuxUpdateOID.setThcodocumento(documentoAux.getIdDocumento());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documentoAux.getOidDokusi());
						this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}
				}

			} else {
				// en odei
				SantramexpServiceImpl.logger.info(
						"SantramexpServiceImpl - createEJGVDocumentNotificacion: 7b/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}

			SantramexpServiceImpl.logger.info("SantramexpServiceImpl - createEJGVDocumentNotificacion: 8/8.");

		} catch (Y41bUDAException e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			SantramexpServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {

			SantramexpServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			SantramexpServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);

		}

		return respuestaEjgv;
	}

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esNotificacionTipoElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 0/14");

		if (tramitar) {

			if (Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
				this.validarSiExisteSede(tramiteNotificacion.getDestinatario());
			}

			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
					.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				this.validarSiExisteIncoacionTramitada(tramiteComun.getIdExpediente());
			}

			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_PROPUESTA_RESOLUCION
					.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				this.validarSiExistePropuestaTramitada(tramiteComun.getIdExpediente());
			}

			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION
					.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				this.validarSiExisteResolucionTramitada(tramiteComun.getIdExpediente());
			}

			// EVOLUTIVO 0135083 2.3
			Expedien expedienaux = new Expedien();
			expedienaux.setExcodigo(tramiteComun.getIdExpediente());
			expedienaux = this.expedienService.find(expedienaux);
			Sanexp sanexpaux = this.sanexpService.find(expedienaux.getSanexp());

			// Si no esta abierto en PLATEA seguir comprobando
			if (!Y41bConstantes.SI.equals(sanexpaux.getPlatea())) {
				Saninterv saninterv = new Saninterv();
				saninterv.setExpedien(new Expedien(expedienaux.getExcodigo()));
				saninterv.setUaidinterv(new BigDecimal(tramiteNotificacion.getDestinatario()));
				saninterv = this.sanintervService.find(saninterv);
				// Si el interviniente es sancionado o su representante y no es
				// notificacion de acuerdo de incoacion lanzamos error
				if (saninterv != null
						&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
										.equals(saninterv.getUatipointerv()))
						&& !Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
								.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
					// sino si el interviniente es sancionado o su representante
					// y es notificacion de acuerdo de incoacion entonces se
					// abre el expediente en platea y se continua con la
					// notificacion
				} else if (saninterv != null
						&& ((Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
										.equals(saninterv.getUatipointerv()))
								&& Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
										.equals(tramiteNotificacion.getTipoNotificacionPlatea()))) {
					Sanexp sanexpPlatea = new Sanexp();
					sanexpPlatea.setExcodigo(expedienaux.getExcodigo());
					sanexpPlatea = this.sanexpService.find(sanexpPlatea);
					// 135083 2.3 28/10/2019 nuevo punto apertura platea
					SantramexpServiceImpl.logger
							.info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea");
					if (!Y41bConstantes.VALOR_SI.equals(sanexpPlatea.getPlatea())) {
						SantramexpServiceImpl.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea Inicio");
						this.abrirSolicitudOficioPlatea(expedienaux);
						SantramexpServiceImpl.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea Fin");
						sanexpService.updateIndicadorPlatea(sanexpPlatea);
						SantramexpServiceImpl.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Actualizacion indicador Platea");
					}
					// sino si hay interviniente y la notificacion es
					// electronica entonces lanzar error
				} else if (saninterv != null && esNotificacionTipoElectronica) {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
					// sino si no hay interviniente lanzamos error
				} else if (saninterv == null) {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
				}
			}
			// FIN EVOLUTIVO 0135083 2.3
		}

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 1/14");

		// 1. Se genera el tramite de Notificacion
		Santramexp santramexp = new Santramexp();
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 2/14");

		// Remesas Ini
		santramexp.setTrenvrem(tramiteNotificacion.getEnvRemesaNotificacion());
		santramexp.setTrcodrem(tramiteNotificacion.getIdRemesaNotificacion());
		// Remesas Fin

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramiteNotificacion.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramiteNotificacion.getFechaFin());
			santramexp.setCensoMonitorEj(tramiteNotificacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramiteNotificacion.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramiteNotificacion.getComentario()));

		santramexp.setTrtiponot(tramiteNotificacion.getTipoNotificacion());

		santramexp.setTrtiponotplatea(tramiteNotificacion.getTipoNotificacionPlatea());

		santramexp.setTrfecnotif(tramiteNotificacion.getFechaComunicacion());
		santramexp.setTruaidinterv(new BigDecimal((tramiteNotificacion.getDestinatario())));
		santramexp.setTrsede(tramiteNotificacion.getSede());
		santramexp.setTrtiponot((tramiteNotificacion.getTipoNotificacion()));

		santramexp.setTridnotifplatea((tramiteNotificacion.getTipoNotificacionPlatea()));
		santramexp.setTrfecregs(tramiteNotificacion.getFechasalida());
		santramexp.setTrnumregs(tramiteNotificacion.getNumregistrosalida());
		santramexp.setTrtexto(Y41bUtils.stringToClob(tramiteNotificacion.getTextoComunicacion()));

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 3/14");

		if (tramitar) {
			if (esNotificacionTipoElectronica) {
				santramexp.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			} else {
				santramexp.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			}
		}

		// Se inserta el tramite
		santramexp.setTrid(tramiteComun.getIdTramite());

		if (tramitar) {
			// sustituimos la fecha de notificacion
			if (santramexp.getTrtiponot().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
				santramexp.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
			}
		}

		// Obtener registro salida si no viene de pantalla
		if (tramitar && !esNotificacionTipoElectronica) {
			if (santramexp.getTrenvrem() == null || Y41bConstantes.NO.equals(santramexp.getTrenvrem())) {
				if (santramexp.getTrnumregs() == null || santramexp.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							tramiteNotificacion.getDestinatario(), true);
					santramexp.setTrnumregs(registroSalida.getRegistryNumber());
					santramexp.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}

		santramexp = this.setSantramexp(santramexp);

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 6/14");

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocNuevo(adjuntardocs, null);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramiteNotificacion.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 7/14");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				// Eliminar de la bandeja de firma
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 8/14");

				// Incidencias 72966 y 74108. Envo ordinario no genera
				// comunicacion en PLATEA
				// Se incluye este if que si no es ordinaria hace lo que se
				// hacia antes y en caso contrario un codigo que comprueba que
				// se pueda generar el zip por estar todo localizado
				/***
				 * COMPROBAMOS SI TODOS LOS DOCUMENTOS TIENE LOCALIZADOR PARA LA
				 * ORDINARIA
				 */
				if (!esNotificacionTipoElectronica) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, santramexp,
							tramiteComun, idZipFile);
					// Se genera el tramite de acuse de recibo vinculado al
					// tramite de
					// notificacion
					SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 9AB14");

					String idEspera = null;
					this.generarTramiteAcuseReciboAutomatico(idEspera, santramexp, tramiteComun);
				} else {
					this.procesarNotificacionElectronica(listDocumentoHecho, tramiteNotificacion, santramexp,
							tramiteComun, censoMonitor);
				}
				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 10A/14");
				/* actualizamos la bandeja */
				this.actualizaBandeja(santramexp);
				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 11A/14");
				/* actualizamos el ultimo tramite */
				this.actualizaUltimoTramiteEnSanExp(santramexp);
				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 12A/14");
				/* actualizo los envios del expediente */
				this.insertEnvios(santramexp);
				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 13A/14");
				SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 14A/14");

			}
		} else {
			if (isDocPendienteFirma) {
				this.actualizaBandeja(santramexp);
				// Llamamos a un metodo que recorrera la lista de documentos
				// del
				// tramite y actualizara la bandeja de firma
				// En este caso, al ser un tramite generico le metemos la
				// fase
				// del
				// expediente
				Sanexp sanexp = new Sanexp();
				sanexp.setExcodigo(tramiteComun.getIdExpediente());
				sanexp = this.sanexpDao.find(sanexp);
				String faseExp = sanexp.getFase().getFcodigo();
				this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, faseExp,
						Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);

			} else {
				this.actualizaBandeja(santramexp);
			}
			// Subimos los documentos a dokusi
			this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun);
		}

		/*
		 * AVISOS DE LA BANDEJA
		 */
		if (tramitar) {
			if (!"S".equals(tramiteNotificacion.getEnvRemesaNotificacion())) {
				/*
				 * aniadimos aviso para recoger acuse independientemente del
				 * tipo de notificacion
				 */
				this.crearAvisoNotifiComuniRegistroSalida(santramexp);
			}
		}
		// EVOLUTIVO 0135083 2.3 ANIADIMOS EL CODIGO DEL METODO QUE AL
		// TRAMITAR EL ACUERDO DE INCOACION AL SANCIONADO ABRE EN PLATEA EL
		// EXPEDIENTE
		// se comenta lo siguiente para poner la apertura en el metodo
		// crearEJGVDocumentNotificacion en TramiteNotificacionController
		// if (tramitar) {
		// Sanexp sanexp = new Sanexp();
		// sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
		// sanexp = this.sanexpDao.find(sanexp);
		// // meter en la condicion AL SANCIONADO
		// if ((Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
		// .equals(sanexp.getSantramexp().getTrtiponotplatea()))) {
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura
		// expediente Platea");
		// if (!Y41bConstantes.VALOR_SI.equals(sanexp.getPlatea())) {
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura
		// expediente Platea Inicio");
		// this.abrirSolicitudOficioPlatea(expedien);
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura
		// expediente Platea Fin");
		// sanexpDao.updateIndicadorPlatea(sanexp);
		// SantramexpServiceImpl.logger
		// .info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion -
		// Actualizacion indicador Platea");
		// }
		// }
		// }

		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: FIN.");

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;
	}

	/**
	 * Metodo que procesa el envio de una comunicacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarComunicacionElectronica(List<Sandoctemp> listDocumentoHecho,
			TramiteComunicacion tramiteComunicacion, Santramexp tramitehecho, CensoMonitor censoMonitor)
			throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		String textoNotificacionComunicacion = tramiteComunicacion.getTextoComunicacion();
		String destinatario = tramiteComunicacion.getDestinatario();
		String envRemesa = tramiteComunicacion.getEnvRemesaComunicacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getExpedien().getExcodigo(),
				tramitehecho.getTrid(), Y41bConstantes.NOTIFICACION_COMUNICACION, textoNotificacionComunicacion,
				destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
		// envioNotifEJGV.setEjgvDocument(tramiteComunicacion.getEjgvDocument());
		//
		// // ******************* Anadimos FIRMA SERVIDOR ********************
		// // ****************************************************************
		// // envioNotifEJGV.setFirma(tramiteComunicacion.getFirma());
		//
		// Properties prop =
		// Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// NSHFServiceImpl nshf = new NSHFServiceImpl();
		// EjgvDocumentType EjgvDocumentFirma = nshf.createAdESSignature(
		// prop.getProperty("CERTIFICADO_SERVIDOR"),
		// tramiteComunicacion.getEjgvDocument(),
		// Y41bConstantes.TIPO_FIRMA_ENVELOPED);
		// envioNotifEJGV.setFirma(EjgvDocumentFirma.getEjgvDocument().getBody()
		// .getSign());
		//
		// RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
		// .procesarEnviarNotificacion(envioNotifEJGV);

		// update tramite campo idnotificacionplatea
		tramitehecho.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
		this.santramexpDao.updateIdNotificacionPlatea(tramitehecho);

		// recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setTrfecregs(Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));
		// RegistroSalida registroSalida = y41bPlateaAdapterService
		// .getRegistroSalidaFromIdNotificacion(respuestaNotif
		// .getNumeroRegistro());
		// tramitehecho.setTrnumregs(registroSalida.getRegistryNumber());
		// tramitehecho.setTrfecregs(Y41bUtils
		// .parseNotificationRegistrytimestamp(registroSalida
		// .getRegistryTimestamp()));
		this.santramexpDao.updateRegistroSalidaPlatea(tramitehecho);
	}

	/**
	 * Metodo que crea el objeto CrearNotifEJGV para envio de
	 * notificacin/comunicacin electrnica
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoNotificacion
	 *            String
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param envRemesa
	 *            String
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CrearNotifEJGV
	 * @throws Exception
	 */
	private CrearNotifEJGV crearObjetoCrearNotifEJGV(String idExpediente, String idTramite, String idTipoNotificacion,
			String textoNotificacionComunicacion, String destinatario, String envRemesa,
			List<Sandoctemp> listDocumentoHecho, CensoMonitor censoMonitor) throws Exception {

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Saninterv interviniente = new Saninterv();
		interviniente.setUaidinterv(new BigDecimal(destinatario));
		interviniente = this.sanintervDao.find(interviniente);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(interviniente.getUanif().trim());

		datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
				: interviniente.getUanombre().concat(" ")
						.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
						.concat(" ")
						.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));

		if (Y41bUtils.isFilled(interviniente.getUaapellido1())) {
			datosPersonaSolicitante.setApellido1(interviniente.getUaapellido1());
		}
		datosPersonaSolicitante.setMail(interviniente.getUacoem());

		// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
		if (Y41bUtils.isFilled(interviniente.getUaescodigo())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(interviniente.getUaescodigo());
			establecimiento = this.establecimientoService.find(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

			if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
				datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
			} else if (establecimiento != null && Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
				datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
			}
		}
		// 0173496: Mail de aviso en notificaciones/comunicaciones Platea

		datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		Expedien expediente = new Expedien();
		expediente.setExcodigo(idExpediente);

		expediente = this.expedienDao.find(expediente);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(expediente.damecodCompletoPlatea());

		crearNotifEJGV.setNumeroExpediente(expediente.damecodCompletoPlatea());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		// En la JSP va "PRUEBAS" para distinguirlo del tipo de resolucion
		// recurso de alzada
		// Antes de enviar a Platea tenemos que tratarlo
		if ("PRUEBAS".equals(idTipoNotificacion)) {
			crearNotifEJGV.setIdTipoNotificacion(
					Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA);
		} // EVOLUTIVO 0135083 2.4 como requerimiento ya esta siendo
			// utilizado,
			// se usa otrA ANTES DE ENVIARLO A PLATEA
		else if ("REQUERIMIENTOINFORMACION".equals(idTipoNotificacion)) {
			crearNotifEJGV.setIdTipoNotificacion(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO);
		} else {
			crearNotifEJGV.setIdTipoNotificacion(idTipoNotificacion);
		}

		List<Documento> listDocumentos = this.registrarDocumentosDokusi(listDocumentoHecho, null);

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return crearNotifEJGV;
	}

	/**
	 * Metodo que procesa el envio de una notificacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<Sandoctemp>
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramitehecho
	 *            Santramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarNotificacionElectronica(List<Sandoctemp> listDocumentoHecho,
			TramiteNotificacion tramiteNotificacion, Santramexp tramitehecho, TramiteComun tramiteComun,
			CensoMonitor censoMonitor) throws Exception {

		// 2. Se genera el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		String idEspera = this.expedienDao.getNewEsperaPK() + "";
		Santramexp tramiteAcuse = this.generarTramiteAcuseReciboAutomatico(idEspera, tramitehecho, tramiteComun);

		// 3. Enviamos telematicamente la solicitud
		String textoNotificacionComunicacion = tramiteNotificacion.getTextoComunicacion();
		String destinatario = tramiteNotificacion.getDestinatario();
		String envRemesa = tramiteNotificacion.getEnvRemesaNotificacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getExpedien().getExcodigo(),
				tramitehecho.getTrid(), tramiteNotificacion.getTipoNotificacionPlatea(), textoNotificacionComunicacion,
				destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
		// envioNotifEJGV.setEjgvDocument(tramiteNotificacion.getEjgvDocument());
		//
		// // ******************* Anadimos FIRMA SERVIDOR ********************
		// // ****************************************************************
		// // envioNotifEJGV.setFirma(tramiteNotificacion.getFirma());
		//
		// Properties prop =
		// Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// NSHFServiceImpl nshf = new NSHFServiceImpl();
		// EjgvDocumentType EjgvDocumentFirma = nshf.createAdESSignature(
		// prop.getProperty("CERTIFICADO_SERVIDOR"),
		// tramiteNotificacion.getEjgvDocument(),
		// Y41bConstantes.TIPO_FIRMA_ENVELOPED);
		// envioNotifEJGV.setFirma(EjgvDocumentFirma.getEjgvDocument().getBody()
		// .getSign());
		//
		// RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
		// .procesarEnviarNotificacion(envioNotifEJGV);

		// 4.1 Update tramite notificacion (campo idnotificacionplatea)
		tramitehecho.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
		this.santramexpDao.updateIdNotificacionPlatea(tramitehecho);

		// 4.2 Recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setTrfecregs(Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

		// RegistroSalida registroSalida = y41bPlateaAdapterService
		// .getRegistroSalidaFromIdNotificacion(respuestaNotif
		// .getNumeroRegistro());
		// tramitehecho.setTrnumregs(registroSalida.getRegistryNumber());
		// tramitehecho.setTrfecregs(Y41bUtils
		// .parseNotificationRegistrytimestamp(registroSalida
		// .getRegistryTimestamp()));
		this.santramexpDao.updateRegistroSalidaPlatea(tramitehecho);
		// 4.3 Add notificacion / acuse recibo (tabla)
		NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
		notificacionAcuseRecibo.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		notificacionAcuseRecibo.setEhcodigoacuse(tramiteAcuse.getTrid());
		notificacionAcuseRecibo.setEhpcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
		this.santramexpDao.addNotificacionAcuseRecibo(notificacionAcuseRecibo);
	}

	/**
	 * Metodo que procesa el envio de una comunicacin o notificacion ordinaria
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param listDocumentoHecho
	 *            List<Sandoctemp>
	 * @param tramitehecho
	 *            Santramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idZipFile
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void procesarComunicacionNotificacionOrdinaria(List<Adjuntardocs> listadjuntardocs,
			List<Sandoctemp> listDocumentoHecho, Santramexp tramitehecho, TramiteComun tramiteComun, String idZipFile)
			throws Exception {
		// Validacion: Debe haber almenos 1 documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
				PlantillaTramite plantillaTramite = null;
				if (adjuntardocsAux != null && adjuntardocsAux.getPtcodigo() != null
						&& !adjuntardocsAux.getPtcodigo().equals("")) {
					plantillaTramite = new PlantillaTramite();
					plantillaTramite.setPtcodigo(adjuntardocsAux.getPtcodigo());
					// Obtener la plantilla del tramite
					plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
				}

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocsAux)) {
					if ((tramitehecho.getTrenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getTrenvrem()))
							&& (plantillaTramite != null && plantillaTramite.getNolocalizable() != null
									&& plantillaTramite.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

					} else {
						if (!StringUtils.isBlank(adjuntardocsAux.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils
												.getExtensionFile(adjuntardocsAux.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}
				} else {
					if (tramitehecho.getTrenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getTrenvrem())) {
						if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		if (tramitehecho.getTrenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getTrenvrem())) {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				this.controlDocumentosProtegidosRemesa(listadjuntardocs);
			}
		}

		if (tramitehecho.getTrenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getTrenvrem())) {
			this.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, tramiteComun);
		}

		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI, previamente comprueba si se ha localizado y si no se ha
	 * localizado se elimina de DOKUSI y se vuelve a registrar en DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	private void guardarDocumentosDokusiTramiteComunicacionNotificacion(List<Sandoctemp> listDocumentoHechoAux,
			TramiteComun tramiteComun) throws Exception {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		Sandoctemp documentoHecho = null;
		for (int i = 0; i < listDocumentoHechoAux.size(); i++) {
			documentoHecho = listDocumentoHechoAux.get(i);
			if (documentoHecho.getU5fechasollocalizador() != null) {
				if (documentoHecho != null && documentoHecho.getU5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
						.getExtensionFile(documentoHecho.getU5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

					int minutos = 0;
					if (parametros != null && parametros.getValor() != null
							&& Y41bUtils.isNumeric(parametros.getValor())) {
						minutos = Integer.parseInt(parametros.getValor());
					}

					SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

					Date d1 = null;
					Date d2 = null;
					long diffMinutes = 0;
					try {
						d1 = format.parse(format.format(documentoHecho.getU5fechasollocalizador()));

						d2 = format.parse(format.format(new Date()));

						long diff = d2.getTime() - d1.getTime();

						diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
					} catch (ParseException e) {
						diffMinutes = 0;
					}

					if (diffMinutes > minutos) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getU5iddocumentum());
						documento.setBoolAllVersions("true");

						try {
							this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						} catch (Exception e) {
						}

						documentoHecho.setU5fechasollocalizador(null);
						documentoHecho.setU5iddocumentum(null);
					}
				}
			}
		}
		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHechoAux, tramiteComun);
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private Santramexp sugiereTramiteRecursoAutomaticamente(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setFase(new Fase(Y41bConstantes.FASE_RECURSO_SANCION));
			santramexpNuevo = this.add(santramexpNuevo);

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString(), Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO);
			return santramexpNuevo;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteResolucionSolicitudPrueba(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA);
			santramexpNuevo.setTrfecini(santramexp.getTrfecini());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setFase(santramexp.getFase());
			this.add(santramexpNuevo);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteOrdenConsejero(Santramexp santramexp, boolean docs) throws Exception {

		try {

			// Documentos
			Santramexp recepcionOrdenConsejero = new Santramexp();
			recepcionOrdenConsejero.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO);
			recepcionOrdenConsejero.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECALTA");
			pagination.setSord("DESC");
			List<Santramexp> lrecepcionOrdenConsejero = this.santramexpDao.findAll(recepcionOrdenConsejero, pagination);
			boolean hayTramite = false;
			if (lrecepcionOrdenConsejero != null && lrecepcionOrdenConsejero.size() > 0) {
				for (int j = 0; j < lrecepcionOrdenConsejero.size(); j++) {
					recepcionOrdenConsejero = lrecepcionOrdenConsejero.get(j);
					if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionOrdenConsejero.getTrestado())) {
						hayTramite = true;
						break;
					}
				}
			}
			if (!hayTramite) {
				Expedien expedien = new Expedien();
				expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
				expedien = this.expedienDao.find(expedien);

				recepcionOrdenConsejero = new Santramexp();
				recepcionOrdenConsejero.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
				recepcionOrdenConsejero.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO);
				recepcionOrdenConsejero.setTrfecini(santramexp.getTrfecini());
				recepcionOrdenConsejero.setCensoMonitor(santramexp.getCensoMonitorEj());
				recepcionOrdenConsejero.setTrcodigorel(santramexp.getTrcodigo());
				recepcionOrdenConsejero.setTrtridrel(santramexp.getTrid());
				recepcionOrdenConsejero.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				recepcionOrdenConsejero.setTruaidinterv(santramexp.getTruaidinterv());
				recepcionOrdenConsejero.setFase(santramexp.getFase());
				this.add(recepcionOrdenConsejero);

			}

			if (docs) {
				this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
						recepcionOrdenConsejero.getTrid().toString(),
						Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO);
			}
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteResolucionRecursoSolicitudPrueba(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONRECURSOPRUEBA);
			santramexpNuevo.setTrfecini(santramexp.getTrfecini());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setFase(santramexp.getFase());
			this.add(santramexpNuevo);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteSolicitudPlazoAlegaciones(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOAMPLIACIONPLAZOALEGACIONES);
			santramexpNuevo.setTrfecini(santramexp.getTrfecini());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setFase(santramexp.getFase());
			this.add(santramexpNuevo);

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro.
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite) {
		Santramexp tramitehechoAux = new Santramexp();
		tramitehechoAux.setExpedien(new Expedien(idExpediente));
		tramitehechoAux.setTrcodigo(idTipoTramite);
		List<Santramexp> listaTramitesCierre = this.santramexpDao.findAll(tramitehechoAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			for (Santramexp tramitehechoCierre : listaTramitesCierre) {
				if (!idTramite.equals(tramitehechoCierre.getTrid().toString())) {
					// En caso de que haya algun tramite que sea de cierre en el
					// expediente y no sea el recibido por parametro
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp updateReferenciaLiquidacion(Santramexp santramexp) {
		return this.santramexpDao.updateReferenciaLiquidacion(santramexp);
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param excodigo
	 *            String
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp dameUltimoTramiteEnCurso(String excodigo) {
		return this.santramexpDao.dameUltimoTramiteEnCurso(excodigo);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentosTramite
	 *            List<Sandoctemp>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Documento>
	 * @throws Exception
	 */
	private List<Documento> registrarDocumentosDokusi(List<Sandoctemp> listDocumentosTramite, TramiteComun tramiteComun)
			throws Exception {
		List<Documento> listDocumentos = new ArrayList<Documento>();
		Documento documento = null;

		SantramexpServiceImpl.logger.debug("Inicio registrarDocumentosDokusi()");

		if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {

			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			Sandoctemp sandoctemp = null;
			String pcodigo = "";
			for (int i = 0; i < listDocumentosTramite.size(); i++) {
				sandoctemp = listDocumentosTramite.get(i);
				pcodigo = sandoctemp.getU5pcodigo();
				sandoctemp = this.sandoctempService.find(sandoctemp);
				sandoctemp.setU5pcodigo(pcodigo);
				// if (!Y41bUtils.isFilled(sandoctemp.getU5iddocumentum())) {
				if (sandoctemp != null && sandoctemp.getU5pcodigo() != null
						&& sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(sandoctemp.getU5iddocumentum());
					documentoHecho.setQ5idTipodoc(sandoctemp.getU5tipodocumento());
					documentoHecho.setQ5codocumento(sandoctemp.getU5codocumento());
					documentoHecho.setQ5nofile(sandoctemp.getU5nofile());
					documentoHecho.setQ5origen(sandoctemp.getU5origen());
					documentoHecho.setQ5ptcodigo(sandoctemp.getU5ptcodigo());
					documentoHecho.setQ5datafile(sandoctemp.getU5datafile());
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(sandoctemp.getExpedien().getExcodigo());
					tramiteComunAux.setIdTramite(sandoctemp.getSantramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
				} else if (sandoctemp != null && sandoctemp.getU5pcodigo() != null
						&& sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// crear el objeto Sandoctemp
					Sandoctemp sandocTemp = new Sandoctemp();
					sandocTemp.setU5iddocumentum(sandoctemp.getU5iddocumentum());
					sandocTemp.setU5tipodocumento(sandoctemp.getU5tipodocumento());
					sandocTemp.setU5codocumento(sandoctemp.getU5codocumento());
					sandocTemp.setU5nofile(sandoctemp.getU5nofile());
					sandocTemp.setU5origen(sandoctemp.getU5origen());
					sandocTemp.setU5ptcodigo(sandoctemp.getU5ptcodigo());
					sandocTemp.setU5datafile(sandoctemp.getU5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(sandoctemp.getExpedien().getExcodigo());
					tramiteComunAux.setIdTramite(sandoctemp.getSantramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
				} else if (sandoctemp != null && sandoctemp.getU5pcodigo() != null
						&& sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// crear el objeto Sandoctemp
					Arbdoctemp arbdocTemp = new Arbdoctemp();
					arbdocTemp.setX5iddocumentum(sandoctemp.getU5iddocumentum());
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(sandoctemp.getU5tipodocumento());
					arbdocTemp.setArbtipdoc(arbtipdoc);
					arbdocTemp.setX5codocumento(sandoctemp.getU5codocumento());
					arbdocTemp.setX5nofile(sandoctemp.getU5nofile());
					arbdocTemp.setX5origen(sandoctemp.getU5origen());
					arbdocTemp.setX5ptcodigo(sandoctemp.getU5ptcodigo());
					arbdocTemp.setX5datafile(sandoctemp.getU5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(sandoctemp.getExpedien().getExcodigo());
					tramiteComunAux.setIdTramite(sandoctemp.getSantramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
				} else if (sandoctemp != null && sandoctemp.getU5pcodigo() != null
						&& (sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				} else if (sandoctemp != null && sandoctemp.getU5pcodigo() != null
						&& sandoctemp.getU5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(sandoctemp.getU5iddocumentum());
					documentoHecho.setQ5idTipodoc(sandoctemp.getU5tipodocumento());
					documentoHecho.setQ5codocumento(sandoctemp.getU5codocumento());
					documentoHecho.setQ5nofile(sandoctemp.getU5nofile());
					documentoHecho.setQ5origen(sandoctemp.getU5origen());
					documentoHecho.setQ5ptcodigo(sandoctemp.getU5ptcodigo());
					documentoHecho.setQ5datafile(sandoctemp.getU5datafile());
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(sandoctemp.getExpedien().getExcodigo());
					tramiteComunAux.setIdTramite(sandoctemp.getSantramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
				}
				listDocumentos.add(documento);
			}
		}
		return listDocumentos;
	}

	private Sandoctemp limpiarOidSiErrorLocalizacion(Sandoctemp documentoHecho) {
		SantramexpServiceImpl.logger.info("SantramexpServiceImpl - Eliminamos documentos con error de localizacion.");
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		if (documentoHecho.getU5fechasollocalizador() != null) {
			if (documentoHecho != null && documentoHecho.getU5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
					.getExtensionFile(documentoHecho.getU5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

				int minutos = 0;
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

				Date d1 = null;
				Date d2 = null;
				long diffMinutes = 0;
				try {
					d1 = format.parse(format.format(documentoHecho.getU5fechasollocalizador()));

					d2 = format.parse(format.format(new Date()));

					long diff = d2.getTime() - d1.getTime();

					diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
				} catch (ParseException e) {
					diffMinutes = 0;
				}

				if (diffMinutes > minutos) {
					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getU5iddocumentum());
					documento.setBoolAllVersions("true");

					try {
						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					} catch (Exception e) {
					}

					documentoHecho.setU5fechasollocalizador(null);
					documentoHecho.setU5iddocumentum(null);
				}
			}
		}
		return documentoHecho;
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Expedien
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(Expedien expedienAux,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception {
		Sandoctemp sandoctemp = null;
		try {
			SantramexpServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Inicio");

			Santramexp santramexp = new Santramexp();
			Expedien expedien = this.expedienDao.findSancionByNumeroExpediente(expedienAux);
			// expedien.setExcodigo(expedien.getExcodigo());
			// expedien = this.expedienDao.find(expedien);
			// santramexp.setFase(expedien.getSanexp().getFase());

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			santramexp.setTrfecini(todayWithZeroTime);

			// santramexp.setTrfecfin(todayWithZeroTime);
			/*
			 * Se ha anulado la anulacion de la modificacin (misma incidencia)
			 * // Incidencia 106947 - Sancionadores - Estado en tramitacion (SE
			 * HA // ANULADO LA MODIFICACION)
			 * santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			 * // santramexp.setTrestado(Y41bConstantes.
			 * ESTADO_TRAMITE_ENTRAMITACION );
			 */
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			santramexp.setExpedien(expedien);
			santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
			santramexp.setFase(expedien.getSanexp().getFase());
			// santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

			santramexp.setTrid(this.getNewPK().toString());

			santramexp.setTristelematica(Y41bConstantes.VALOR_SI);

			this.santramexpDao.add(santramexp);

			List<Documento> listDocumentos = mensajeAportacionDoc.getDocumentosAportados();

			for (Documento documentoAux : listDocumentos) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					if (Y41bUtils.interactuarConDokusi()) {
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoAux.getOidDokusi());

						Documento docDokusi = this.y41bDokusiAdapterService
								.descargarDocumentoDokusiSinDocumento(documento);

						// # INICIO #
						// ADAPTACIONES LEY 39
						// Tratar el documento por si se trata de una solicitud
						// de
						// datos de aviso o datos de notificacion
						// this.tratarDocumentosSolicitudMisGestiones(docDokusi,
						// expedien);
						// # FIN #

						SantramexpServiceImpl.logger.debug("generarTramiteAportacionDocumentacion-Paso 1");
						// insertar el documento
						sandoctemp = new Sandoctemp();
						sandoctemp.setU5codocumento(this.sandoctempDao.getNewPK().toString());
						sandoctemp.setExpedien(expedien);
						sandoctemp.setU5nofile(docDokusi.getNombre());
						sandoctemp.setU5sizefile((int) docDokusi.getLength());

						sandoctemp.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO);

						Saninterv sanintervaux = new Saninterv();
						sanintervaux.setExpedien(new Expedien(expedien.getExcodigo()));
						List<Saninterv> lsaninterv = sanintervDao.findAll(sanintervaux, null);
						for (Saninterv saninterv : lsaninterv) {
							if (saninterv != null && saninterv.getUatipointerv() != null
									&& mensajeAportacionDoc.getSender().equalsIgnoreCase(saninterv.getUanif())) {
								if (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) {
									sandoctemp.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO);
								} else if (saninterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)) {
									sandoctemp.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO);
								}
								if (saninterv.getUaidinterv() != null) {
									sandoctemp.setU5idinterviniente(saninterv.getUaidinterv().toString());
								}
								break;
							}
						}

						sandoctemp.setU5tedesfile(documentoAux.getDescripcion());
						sandoctemp.setU5iddocumentum(documentoAux.getOidDokusi());
						sandoctemp.setU5conttype(docDokusi.getContentType());
						SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
								Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
						Date dateFechaRegistro = formatterFechaRegistro
								.parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
						sandoctemp.setU5fecha(dateFechaRegistro);
						sandoctemp.setU5fechaaportacion(dateFechaRegistro);
						sandoctemp.setSantramexp(santramexp);
						if (documentoAux.getTipoDocumental() != null) {
							sandoctemp.setU5tipodocumento(this.getTipoDocumento(documentoAux.getTipoDocumental()));
							// String tipoDocumento = this
							// .getTipoDocumento(documentoAux
							// .getTipoDocumental());
							// if (Y41bConstantes.TIPO_DOC_SOLICITUD
							// .equalsIgnoreCase(tipoDocumento)) {
							// sandoctemp
							// .setU5tipodocumento(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD);
							// } else {
							// sandoctemp
							// .setU5tipodocumento(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_APORTACIONDOCUMENTACION);
							// }
						} else {
							sandoctemp.setU5tipodocumento(
									Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_APORTACIONDOCUMENTACION);
						}
						sandoctemp.setU5fechaentrada(dateFechaRegistro);
						sandoctemp.setU5numregistroentrada(mensajeAportacionDoc.getRegistro().getRegistryNumber());
						// Blob blob = new
						// SerialBlob(Y41bUtilsWS.decode(docDokusi
						// .getBytes()));
						// sandoctemp.setU5datafile(blob);
						this.sandoctempDao.add(sandoctemp);

						// insertar en la tabla de relacion
						this.sandoctempDao.insertSanDocTramite(santramexp.getTrid(), sandoctemp.getU5codocumento(),
								Y41bConstantes.TIPO_PROC_SANCIONES);

						// llamar a transformar docuumentos
						// Ya no se transforman los documentos aportados por
						// ciudadania
						// (INC 0097665 y 115908)
						// if (com.ejie.y41b.utils.Y41bUtils
						// .isDocumentoTransformable(docDokusi)) {
						// TransformarDocumento transformarDocumento = new
						// TransformarDocumento();
						// transformarDocumento.setProcedure(documento
						// .getProcedure());
						// transformarDocumento.setUser(documento.getUser());
						// transformarDocumento.setOidDocumento(documento
						// .getOidDokusi());
						//
						// this.y41bDokusiAdapterService
						// .transformarDocumentoDokusi(transformarDocumento);
						//
						// this.sandoctempDao.updateFechaLocalizacion(sandoctemp);
						// }
					}
				}
			}

			// Incidencia 106947 - Sancionadores - No actualizar mis gestiones
			// (SE HA ANULADO LA MODIFICACION)
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(santramexp.getTrid().toString());
			List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			this.actualizarMisGestionesAportaciondocumentacion(santramexp, listDocumentoHecho);

			// Actualizar ultimo tramite
			this.actualizaUltimoTramiteEnSanExp(santramexp);

			// Tratar la bandeja
			this.actualizaBandeja(santramexp);

		} catch (Y41bUDAException e) {
			SantramexpServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e);
			SantramexpServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + sandoctemp.toString());
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			SantramexpServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ",
					e_tratamientoAportacionDocumentacion);
			SantramexpServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + sandoctemp.toString());
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			SantramexpServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Final");
		}

	}

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination) {

		filterNotifComuni.setCompatibleAA66(this.compatibleConAA66(filterNotifComuni));

		List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.santramexpDao
				.findAllNotifiComuni(filterNotifComuni, pagination);

		for (NotificacionesComunicacionesBusqueda notifcomun : listNotifiComuniBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_SANCIONES).append(" ").append(notifcomun.getDecoor())
					.append("-").append(notifcomun.getDenror()).append("-").append(notifcomun.getDenran());

			notifcomun.setRmtipoExpediente(filterNotifComuni.getRmtipoExpediente());

			notifcomun.setNumExpediente(numeroExpediente.toString());

			// En caso de que sea el destino Sede fijar la direcci�n de la
			// misma
			if (notifcomun.getEhsede() != null && notifcomun.getEhsede().equals("S")) {

				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEsnif(notifcomun.getNif());

				establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

				if (establecimiento != null) {
					Sede sede = new Sede();
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);

					sede = this.establecimientoService.findEstablecimientoSede(sede);
					if (sede != null) {
						notifcomun.setNombre_CP(sede.getNombreCp());
						if (sede.getNombreMunicipio() != null) {
							notifcomun.setNombre_Municipio(sede.getNombreMunicipio());
						}
						if (sede.getNombreLocalidad() != null) {
							notifcomun.setNombre_Localidad(sede.getNombreLocalidad());
						}
						if (sede.getNombreProvincia() != null) {
							notifcomun.setNombre_Provincia(sede.getNombreProvincia());
						}

						if (sede.getNombreCalle() != null) {
							notifcomun.setNombre_Calle(sede.getNombreCalle());

							notifcomun.setNombre_Portal(sede.getNombrePortal());
							notifcomun.setNombre_Piso(sede.getNombrePiso());

						} else if (sede.getDireccionNocapv() != null) {
							notifcomun.setNombre_Calle("");
							notifcomun.setNombre_Portal("");
							notifcomun.setNombre_Piso("");
							if (sede.getNoraPaisNombre() != null && !sede.getNoraPaisNombre().equals("")) {
								notifcomun.setNombre_Pais(sede.getNoraPaisNombre());
							}
							notifcomun.setExtranjero(sede.getExtranjero());
							notifcomun.setDireccionNocapv(sede.getDireccionNocapv());
						}
					} else {
						this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
					}
				} else {
					this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
				}
			}
			// PREPARO LAS DIRECCIONES DESTINO
			StringBuffer direccion2 = new StringBuffer();
			if (notifcomun.getNombre_CP() != null && !notifcomun.getNombre_CP().equals("")) {
				direccion2.append(notifcomun.getNombre_CP());
			} else {
				direccion2.append("");
				notifcomun.setNombre_CP("");
			}
			if (notifcomun.getExtranjero() != null && notifcomun.getExtranjero().equals("S")) {
				notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				direccion2.append(" ").append(notifcomun.getNombre_Pais());
				notifcomun.setDireccion2(direccion2.toString());

			} else {
				if (notifcomun.getNombre_Calle() != null && !notifcomun.getNombre_Calle().equals("")) {
					StringBuffer direccionCapv = new StringBuffer();
					direccionCapv.append(notifcomun.getNombre_Calle());
					if (notifcomun.getNombre_Portal() != null && !notifcomun.getNombre_Portal().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Portal());
					}
					if (notifcomun.getNombre_Piso() != null && !notifcomun.getNombre_Piso().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Piso());
					}
					notifcomun.setDireccion1(direccionCapv.toString());
				} else {
					notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				}

				direccion2.append(" ").append(notifcomun.getNombre_Municipio());
				notifcomun.setDireccion2(direccion2.toString());

			}

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (notifcomun.getNombreCalle() != null && !notifcomun.getNombreCalle().equals("")) {
				direccionCompleta.append(notifcomun.getNombreCalle());

				if (notifcomun.getNombrePortal() != null && !notifcomun.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(notifcomun.getNombrePortal());
				}
			}

			notifcomun.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (notifcomun.getNombreCp() != null && !notifcomun.getNombreCp().equals("")) {
				cpMunicipio.append(notifcomun.getNombreCp());

				if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(notifcomun.getNombreMunicipio());
				}
			} else if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
				cpMunicipio.append(notifcomun.getNombreMunicipio());
			}

			notifcomun.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer(Y41bConstantes.NUM_20);

			piepagina_linea1.append(notifcomun.getDireccionOrganismo()).append(" - ")
					.append(notifcomun.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(notifcomun.getTelefonoOrganismo());

			notifcomun.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(notifcomun.getEmailOrganismo()).append(" / ")
					.append(notifcomun.getWebOrganismo());

			notifcomun.setPiePaginaLinea2(piepagina_linea2.toString());
		}

		return listNotifiComuniBusqueda;
	}

	/**
	 * validarSiExisteIncoacionTramitada
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void validarSiExisteIncoacionTramitada(String idExpediente) {
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(idExpediente));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination paginacion = new Pagination();
		paginacion.setSord("DESC");
		paginacion.setSort("TRFECFIN");
		List<Santramexp> listaTramites = this.santramexpDao.findAll(santramexp, paginacion);
		if (!(listaTramites != null && listaTramites.size() > 0)) {
			throw new Y41bUDAException("error.validacion.tramitacion.acuerdoIncoacionNoTramitado", true, null);
		}
	}

	/**
	 * validarSiExistePropuestaTramitada
	 * 
	 * @param idExpediente
	 *            String
	 */
	private void validarSiExistePropuestaTramitada(String idExpediente) {
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(idExpediente));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination paginacion = new Pagination();
		paginacion.setSord("DESC");
		paginacion.setSort("TRFECFIN");
		List<Santramexp> listaTramites = this.santramexpDao.findAll(santramexp, paginacion);
		if (!(listaTramites != null && listaTramites.size() > 0)) {
			throw new Y41bUDAException("error.validacion.tramitacion.propuestaResolucionNoTramitado", true, null);
		}
	}

	/**
	 * validarSiExisteResolucionTramitada
	 * 
	 * @param idExpediente
	 *            String
	 */
	private void validarSiExisteResolucionTramitada(String idExpediente) {
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(idExpediente));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination paginacion = new Pagination();
		paginacion.setSord("DESC");
		paginacion.setSort("TRFECFIN");
		List<Santramexp> listaTramites = this.santramexpDao.findAll(santramexp, paginacion);
		if (!(listaTramites != null && listaTramites.size() > 0)) {
			throw new Y41bUDAException("error.validacion.tramitacion.resolucionNoTramitado", true, null);
		}
	}

	/**
	 * 
	 * @param idInterviniente
	 *            String
	 */
	public void validarSiExisteSede(String idInterviniente) {
		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(new BigDecimal(idInterviniente));

		saninterv = this.sanintervDao.find(saninterv);

		if (Y41bUtils.isFilled(saninterv.getUanif())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(saninterv.getUanif());

			establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

			if (establecimiento == null) {
				throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
			}
		} else {
			throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
		}
	}

	/**
	 * 
	 * @param notifcomun
	 *            NotificacionesComunicacionesBusqueda
	 */
	private void ponerVaciaLaSedeEnLaNotificaComunica(NotificacionesComunicacionesBusqueda notifcomun) {
		notifcomun.setNombre_CP("");
		notifcomun.setNombre_Municipio("");
		notifcomun.setNombre_Provincia("");
		notifcomun.setNombre_Calle("");
		notifcomun.setNombre_Portal("");
		notifcomun.setNombre_Piso("");
		notifcomun.setNombre_Pais("");
		notifcomun.setExtranjero("");
		notifcomun.setDireccionNocapv("");
	}

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni) {
		return this.santramexpDao.findAllNotifiComuniCount(filterNotifComuni);
	}

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws Exception {

		List<NotificacionesComunicacionesBusqueda> listaClobsNotifiComuni = this.santramexpDao
				.findBlobTablaDocumentosHecho(filterNotifiComuni);
		if (listaClobsNotifiComuni != null) {

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listaClobsNotifiComuni) {

				// si est en dokusi, descargar de dokusi
				if (notificacionesComunicacionesBusquedaAux != null
						&& notificacionesComunicacionesBusquedaAux.getQ5iddocumentum() != null
						&& !notificacionesComunicacionesBusquedaAux.getQ5iddocumentum().equals("")) {
					// descargar de dokusi
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(notificacionesComunicacionesBusquedaAux.getQ5iddocumentum());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					notificacionesComunicacionesBusquedaAux.setQ5datafile(blob);
				} else {
					// si no est en dokusi descargar de base de datos
				}
			}
		}
		return listaClobsNotifiComuni;
	}

	/**
	 * adjuntarDocumentosDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	private void adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino) {

		this.sandoctempDao.copiaSanDocTramite(tridOrigen, tridDestino);
	}

	/**
	 * adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	private void adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino,
			String tipo) {

		this.sandoctempDao.copiaSanDocTramiteDeUnTipo(tridOrigen, tridDestino, tipo);
	}

	/**
	 * Dame tramite por tipo.
	 * 
	 * @param trcodigo
	 *            the trcodigo
	 * @param excodigo
	 *            String
	 * @return the santramexp
	 */
	public Santramexp dameTramitePorTipo(String trcodigo, String excodigo) {
		return this.santramexpDao.dameTramitePorTipo(trcodigo, excodigo);
	}

	/**
	 * Comprueba secuencia fechas tramitacion.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tipoTramite
	 *            the tipo tramite
	 * @param fecha
	 *            the fecha
	 * @return true, if successful
	 */
	public boolean compruebaSecuenciaFechasTramitacion(String excodigo, String tipoTramite, Date fecha) {
		SantramexpServiceImpl.logger.info("Inicio compruebaSecuenciaFechasTramitacion()EXID:" + "." + excodigo
				+ ".TRCODIGO:" + tipoTramite + ".FECHA:" + fecha + ".");
		boolean resultado = false;

		resultado = true;

		Expedien expedien = this.expedienDao.find(new Expedien(excodigo));
		// Sanexp sanexp = this.sanexpDao.find(new Sanexp(excodigo));

		Date fecha_tramiteIncoacion = null;
		Date fecha_tramitePropuestaResolucion = null;
		Date fecha_tramiteResolucion = null;
		Date fecha_tramiteRecepcionOrdenConsejero = null;

		fecha_tramiteIncoacion = expedien.getExfenoai();
		fecha_tramitePropuestaResolucion = expedien.getExfenopr();
		fecha_tramiteResolucion = expedien.getExfenore();

		if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(tipoTramite)) {
			fecha_tramiteIncoacion = fecha;
		} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(tipoTramite)) {
			if (fecha_tramiteIncoacion == null) {
				throw new Y41bUDAException("error.validacion.tramitacion.acuerdoIncoacion", true, null);
			}
			fecha_tramitePropuestaResolucion = fecha;
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tipoTramite)) {
			this.compruebaTramiteResolucion(expedien);
			fecha_tramiteResolucion = fecha;
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(tipoTramite)) {
			if (fecha_tramiteResolucion == null) {
				throw new Y41bUDAException("error.validacion.tramitacion.resolucion", true, null);
			}
			fecha_tramiteRecepcionOrdenConsejero = fecha;
		}

		SantramexpServiceImpl.logger.info("FECHAS: " + fecha_tramiteIncoacion + "." + fecha_tramitePropuestaResolucion
				+ "." + fecha_tramiteResolucion + "." + fecha_tramiteRecepcionOrdenConsejero + ".");

		if ((fecha_tramiteIncoacion != null) && (fecha_tramitePropuestaResolucion != null)
				&& (fecha_tramiteResolucion != null) && (fecha_tramiteRecepcionOrdenConsejero != null)) {
			SantramexpServiceImpl.logger.info("CASO1.");
			resultado = (fecha_tramiteRecepcionOrdenConsejero.compareTo(fecha_tramiteResolucion) >= 0)
					&& (fecha_tramiteResolucion.compareTo(fecha_tramitePropuestaResolucion) >= 0)
					&& (fecha_tramitePropuestaResolucion.compareTo(fecha_tramiteIncoacion) >= 0);
		} else if ((fecha_tramiteIncoacion != null) && (fecha_tramitePropuestaResolucion != null)
				&& (fecha_tramiteResolucion != null)) {
			SantramexpServiceImpl.logger.info("CASO2.");
			resultado = (fecha_tramiteResolucion.compareTo(fecha_tramitePropuestaResolucion) >= 0)
					&& (fecha_tramitePropuestaResolucion.compareTo(fecha_tramiteIncoacion) >= 0);
		} else if ((fecha_tramiteIncoacion != null) && (fecha_tramitePropuestaResolucion != null)) {
			SantramexpServiceImpl.logger.info("CASO3.");
			resultado = fecha_tramitePropuestaResolucion.compareTo(fecha_tramiteIncoacion) >= 0;
		} else {
			SantramexpServiceImpl.logger.info("CASO4.");
			resultado = true;
		}

		SantramexpServiceImpl.logger.info("Fin compruebaSecuenciaFechasTramitacion().Resultado:" + resultado + ".");
		return resultado;

	}

	private void compruebaTramiteResolucion(Expedien expedien) {
		boolean propuestaR = false;
		Date fechaAcuseAIncoacion = expedien.getExfenoai();
		Date fechaAcusePropuestaR = expedien.getExfenopr();

		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
		Pagination paginacion = new Pagination();
		paginacion.setSord("DESC");
		paginacion.setSort("TRFECFIN");
		List<Santramexp> listaTramites = this.santramexpDao.findAll(santramexp, paginacion);
		if (listaTramites != null && listaTramites.size() > 0) {
			propuestaR = true;
		}

		if (fechaAcuseAIncoacion == null) {
			throw new Y41bUDAException("error.validacion.tramitacion.acuerdoIncoacion", true, null);
		} else if (propuestaR && fechaAcusePropuestaR == null) {
			throw new Y41bUDAException("error.validacion.tramitacion.propuestaResolucion", true, null);
		}
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		return this.sandoctempDao.findAllDocumentosHechoComunicacionCount(tramiteComun);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listSandoctemp
	 *            List<Sandoctemp>
	 * @throws SQLException
	 *             SQLException
	 */
	private void eliminarDocumentosDokusi(List<Sandoctemp> listSandoctemp) throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listSandoctemp != null && listSandoctemp.size() > 0) {
			for (Sandoctemp sandoctemp : listSandoctemp) {
				if (sandoctemp != null && sandoctemp.getU5iddocumentum() != null
						&& !sandoctemp.getU5iddocumentum().equals("")) {

					Long numTramitesUtilizado = this.sandoctempDao.findAllDocTramiteHechoCount(sandoctemp);

					if (numTramitesUtilizado == 0) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(sandoctemp.getU5iddocumentum());
						documento.setBoolAllVersions("true");

						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					}
				}
			}
		}
	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp updateRegistroSalidaPlatea(Santramexp santramexp) {
		return this.santramexpDao.updateRegistroSalidaPlatea(santramexp);
	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateSantramexp(Santramexp santramexp) {

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(santramexp.getTrid().toString());
			adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			boolean denegado = false;

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				for (int i = 0; i < listAdjuntardocs.size(); i++) {
					if (listAdjuntardocs.get(i).getThestadodocumento() != null && listAdjuntardocs.get(i)
							.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA)) {
						denegado = true;
						break;
					}
				}
			}

			if (denegado) {
				santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			} else {
				boolean todosFirmados = true;
				if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
					for (int i = 0; i < listAdjuntardocs.size(); i++) {
						if (listAdjuntardocs.get(i).getThestadodocumento() != null && !listAdjuntardocs.get(i)
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
							todosFirmados = false;
							break;
						}
					}
				}
				if (todosFirmados) {
					boolean firmado = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								firmado = true;
								break;
							}
						}
					}

					if (firmado) {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}

				} else {
					boolean pendienteFirma = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								pendienteFirma = true;
								break;
							}
						}
					}

					if (pendienteFirma) {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}
				}
			}
		}
		return this.santramexpDao.update(santramexp);
	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp setSantramexp(Santramexp santramexp) {

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(santramexp.getTrid().toString());
			adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			boolean denegado = false;

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				for (int i = 0; i < listAdjuntardocs.size(); i++) {
					if (listAdjuntardocs.get(i).getThestadodocumento() != null && listAdjuntardocs.get(i)
							.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA)) {
						denegado = true;
						break;
					}
				}
			}

			if (denegado) {
				santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			} else {
				boolean todosFirmados = true;
				if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
					for (int i = 0; i < listAdjuntardocs.size(); i++) {
						if (listAdjuntardocs.get(i).getThestadodocumento() != null && !listAdjuntardocs.get(i)
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
							todosFirmados = false;
							break;
						}
					}
				}
				if (todosFirmados) {
					boolean firmado = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								firmado = true;
								break;
							}
						}
					}

					if (firmado) {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}

				} else {
					boolean pendienteFirma = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								pendienteFirma = true;
								break;
							}
						}
					}

					if (pendienteFirma) {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else {
						santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}
				}
			}
		}
		if (this.santramexpDao.exists(santramexp)) {
			Santramexp santramexpBD = this.santramexpDao.find(santramexp);
			if (santramexpBD != null && santramexpBD.getFase() != null && santramexpBD.getFase().getFcodigo() != null
					&& !santramexpBD.getFase().getFcodigo().equals("")) {
				// Tramite con fase
				santramexp.setFase(santramexpBD.getFase());
			} else {
				santramexpBD = this.santramexpDao.findUltimoTramiteConFase(santramexp);
				if (santramexpBD != null) {
					santramexp.setFase(santramexpBD.getFase());
				}
			}
			return this.santramexpDao.update(santramexp);
		} else {
			Tramite tramite = new Tramite(santramexp.getTrcodigo());
			tramite = this.tramiteDao.find(tramite);
			if (tramite != null && tramite.getFase() != null && tramite.getFase().getFcodigo() != null
					&& !"".equals(tramite.getFase().getFcodigo())) {
				// Si se crea el tramite en un expediente cerrado correo al
				// responsable del expediente
				this.enviarMailInstructorAportacionCerrado(santramexp);
				return this.santramexpDao.add(santramexp);
			} else {
				Santramexp santramexpBD = this.santramexpDao.findUltimoTramiteConFase(santramexp);
				if (santramexpBD != null) {
					santramexp.setFase(santramexpBD.getFase());
				}
				// Si se crea el tramite en un expediente cerrado correo al
				// responsable del expediente
				this.enviarMailInstructorAportacionCerrado(santramexp);
				return this.santramexpDao.add(santramexp);
			}
		}
	}

	private void enviarMailInstructorAportacionCerrado(Santramexp santramexp) {
		if (!(santramexp.getExpedien() != null && santramexp.getExpedien().getExcodigo() != null)) {
			// salimos sin enviar correo - no hay codigo de expediente
			SantramexpServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no hay codigo de expediente");
			return;
		}
		if (!Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION.equals(santramexp.getTrcodigo())) {
			// salimos sin enviar correo - no es una aportacion
			SantramexpServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no es una aportacion");
			return;
		}
		Expedien expedien = new Expedien(santramexp.getExpedien().getExcodigo());
		expedien = this.expedienService.find(expedien);
		Sanexp sanexp = new Sanexp(expedien.getExcodigo());
		sanexp = this.sanexpService.find(sanexp);
		if (sanexp.getExfecfin() == null) {
			// salimos sin enviar correo - no es un expediente cerrado
			SantramexpServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no es un expediente cerrado");
			return;
		}
		// obtener instructor
		CensoMonitor instructor = new CensoMonitor();
		instructor.setMocodigo(sanexp.getExmocodigo());
		instructor = this.censoMonitorDao.find(instructor);
		if (!(instructor != null && !Y41bUtils.esNullOCadenaVacia(instructor.getMocoem()))) {
			// salimos sin enviar correo - el instructor no existe o no tiene
			// mail
			SantramexpServiceImpl.logger.info(
					"enviarMailInstructorAportacionCerrado - Correo no enviado - el instructor no existe o no tiene mail");
			return;
		}
		// obtener servidor smtp
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
		// 0. From
		String from = "";
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_GENERAL_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);
		if (parametros == null
				|| (parametros != null && (parametros.getValor() == null || parametros.getValor().equals("")))) {
			// salimos sin enviar correo - no esta definido el from en
			// parametros
			SantramexpServiceImpl.logger.info(
					"enviarMailInstructorAportacionCerrado - Correo no enviado - no esta definido el from en parametros");
			return;
		}
		from = parametros.getValor();
		// 1. Destinatario
		String destinatario = instructor.getMocoem();
		// 2. Creo el asunto
		// Obtener el numero de expediente
		StringBuilder numeroExpediente = new StringBuilder();
		numeroExpediente.append(expedien.damecodCompletoPlatea());
		StringBuilder asunto = new StringBuilder();
		// Castellano
		asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(numeroExpediente).append(" / ");
		// Euskera
		asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
				new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);
		// 3. Creo el contenido del mail
		StringBuilder texto = new StringBuilder();
		String[] params = new String[1];
		params[0] = numeroExpediente.toString();
		texto.append("<B>").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto", params,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto", params,
				new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");
		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatario, "",
				null);
		if (!enviadoOK) {
			SantramexpServiceImpl.logger
					.trace("enviarMailInstructorAportacionCerrado - Correo no enviado - sendMail resultado false");
		}
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws SQLException
	 *             SQLException
	 */
	private void calcularEstadoTramiteGenerado(Santramexp santramexp) throws SQLException {
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {

			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(santramexp.getTrid().toString());

			List<Sandoctemp> listDocumentosTramite = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			boolean todosFirmados = true;
			if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
				for (int i = 0; i < listDocumentosTramite.size(); i++) {
					if (listDocumentosTramite.get(i).getU5estadodocumento() != null && !listDocumentosTramite.get(i)
							.getU5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
						todosFirmados = false;
						break;
					}
				}
			}
			if (todosFirmados) {
				boolean firmado = false;
				if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
					for (int i = 0; i < listDocumentosTramite.size(); i++) {
						if (listDocumentosTramite.get(i).getU5estadodocumento() != null) {
							firmado = true;
							break;
						}
					}
				}

				if (firmado) {
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
				} else {
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}

			} else {
				boolean pendienteFirma = false;
				if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
					for (int i = 0; i < listDocumentosTramite.size(); i++) {
						if (listDocumentosTramite.get(i).getU5estadodocumento() != null) {
							pendienteFirma = true;
							break;
						}
					}
				}

				if (pendienteFirma) {
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
				} else {
					santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
			}
		}

		this.santramexpDao.update(santramexp);
	}

	/**
	 * Metodo que comprueba que los documentos enviados a remesa no tienen
	 * problemas para ser remesados
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 */
	private void controlDocumentosProtegidosRemesa(List<Adjuntardocs> listadjuntardocs) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		Sandoctemp documentoHechoDetalle = null;
		for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
			documentoHechoDetalle = new Sandoctemp();
			documentoHechoDetalle.setU5codocumento(adjuntardocsAux.getThcodocumento());
			documentoHechoDetalle = this.sandoctempService.find(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getU5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());
			try {
				Document document = new Document();
				int totalPages = 0;
				PdfReader pdfReader = new PdfReader(bContenido);
				totalPages = pdfReader.getNumberOfPages();

				ByteArrayOutputStream bos = new ByteArrayOutputStream();

				ObjectOutputStream os = new ObjectOutputStream(bos);

				// Create a writer for the outputstream
				PdfWriter writer = PdfWriter.getInstance(document, os);

				document.open();
				BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
				PdfContentByte cb = writer.getDirectContent(); // Holds
																// the
																// PDF
				// data

				boolean paginate = false;
				int pageOfCurrentReaderPDF = 0;
				int currentPageNumber = 0;
				PdfImportedPage page;
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader.getPageN(pageOfCurrentReaderPDF + 1));
					// if (r.getWidth() == 792.0 && r.getHeight() ==
					// 612.0)
					if (r.getWidth() > r.getHeight()) {
						document.setPageSize(PageSize.A4.rotate());
					} else {
						document.setPageSize(PageSize.A4);
					}
					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;
					page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
					cb.addTemplate(page, 0, 0);

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, Y41bConstantes.NUM_9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, "" + currentPageNumber + " of " + totalPages,
								Y41bConstantes.NUM_520, Y41bConstantes.NUM_5, 0);
						cb.endText();
					}
				}
				pageOfCurrentReaderPDF = 0;
				pdfReader.close();

				if (document.isOpen()) {
					document.close();
				}
				writer.close();
				os.writeObject(new Date());
				os.close();
			} catch (Exception e) {
				StringBuffer errorPassword = new StringBuffer();
				errorPassword
						.append(this.appMessageSource.getMessage("error.documentos.passwordremesapdf", null, locale));
				errorPassword.append(documentoHechoDetalle.getU5nofile());
				throw new Y41bUDAException(errorPassword.toString(), true, new Exception());
			}
		}
	}

	/**
	 * @param tramite
	 *            Santramexp
	 */
	public void crearAvisoNotifiComuniRegistroSalida(Santramexp tramite) {

		Santramexp santramexp = this.santramexpDao.find(tramite);
		if (santramexp != null) {
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(sanexp.getExmocodigo());
			censoMonitor = this.censoMonitorDao.find(censoMonitor);

			if (santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION)) {
				if (santramexp.getTrtridrel() != null) {
					Santramexp santramexpOrigen = new Santramexp();
					santramexpOrigen.setTrid(santramexp.getTrtridrel());
					santramexpOrigen = this.santramexpDao.find(santramexpOrigen);
					/* si estamos comunicando el informe para asesoria */
					if (santramexpOrigen.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA)) {
						SantramexpServiceImpl.logger
								.info("SantramexpServiceImpl - addTramiteComunicacion - Generando. ");

						Parametros parametros = new Parametros();
						parametros.setParametro(Y41bConstantes.TIPO_AVISO_SANCIONES_REMISION_ASESORI);
						parametros = this.parametrosDao.find(parametros);
						if (parametros != null) {
							Long numeroDias = new Long(parametros.getValor());
							this.sanbandejaDao.aniadeAvisoBandejaDias(santramexp.getExpedien(), censoMonitor,
									numeroDias, "", "", santramexp.getTrid(), santramexp.getTrfecregs(),
									Y41bConstantes.TIPO_AVISO_SANCIONES_REMISION_ASESORI);
						}
					}
				}
			}
		}
	}

	/**
	 * Reabrir expediente
	 * 
	 * @param excodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrirExpediente(String excodigo, CensoMonitor censoMonitor) throws Exception {

		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(excodigo);

		// buscar el tramite de cierre
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
		try {
			santramexp = this.santramexpDao.findUltimoTramiteExpedientePorTipoTramite(santramexp);
		} catch (Exception e) {
		}

		// Eliminamos la fecha de cierre
		expedien = this.expedienDao.find(expedien);
		expedien.setExfear(null);
		this.expedienDao.update(expedien);
		sanexp = this.sanexpDao.find(sanexp);
		sanexp.setExfecfin(null);
		sanexp.setSantramexp(null);
		sanexp.setSantramexpEntidad(null);
		this.sanexpDao.update(sanexp);

		// Eliminar cierre de sanbandeja
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setBatrid(santramexp.getTrid());
		List<Sanbandeja> listSanbandeja = this.sanbandejaDao.findAll(sanbandeja, null);
		if (listSanbandeja != null && listSanbandeja.size() > 0) {
			for (int i = 0; i < listSanbandeja.size(); i++) {
				sanbandeja = listSanbandeja.get(i);
				this.sanbandejaDao.remove(sanbandeja);
			}
		}
		// eliminar tramite de cierre
		this.santramexpDao.remove(santramexp);

		// Actualizar expediente con el ultimo tramite
		Santramexp ultimoSantramexp = this.calculaUltimoTramiteEnSanExp(sanexp);

		// crear tramite generico con la fase del ltimo trmite que tengamos
		expedien.getSanexp().setFase(ultimoSantramexp.getFase());
		this.generarTramiteGenericoReabrirExpediente(expedien, censoMonitor);

		// Actualizar bandeja
		this.actualizaBandeja(ultimoSantramexp);

		this.actualizaUltimoTramiteEnSanExp(ultimoSantramexp);

		// Reabrir expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		actualizarExpediente.setProcedure(procedure);

		// Sancionado
		Saninterv saninterv = this.sanintervDao.dameSancionado(excodigo);

		// En actualizarExpediente el solicitante es el titular, en nuestro caso
		// el sancionado
		actualizarExpediente.setSolicitante(this.sanintervService.cargarDatosPersona(saninterv));
		actualizarExpediente.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		// REPRESENTANTE SANCIONADO
		Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(excodigo,
				Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

		if (sancionadoRepr != null) {
			DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
			// Le ponemos el idioma del titular
			datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
			actualizarExpediente.setRepresentante(datosSancionadoRepr);
		}
		// --------------------------------------------------------------------------

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SANCIONES).append("-").append(expedien.getExcoor()).append("-")
				.append(expedien.getExnror()).append("-").append(expedien.getExnran());

		actualizarExpediente.setEjercicio(expedien.getExnran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		// Se comenta para evitar que se informe en mi carpeta el nombre del
		// tramitador en el tramite de apertura
		// DatosPersona sender = new DatosPersona();
		// sender.setDni(censoMonitor.getModni());
		// sender.setNombre(censoMonitor.getMonombre());
		// actualizarExpediente.setSender(sender);

		Calendar cal = Calendar.getInstance();
		try {
			if (expedien != null && expedien.getExfere() != null) {
				cal.setTime(expedien.getExfere());
			} else {
				cal.setTime(new Date());
			}
			actualizarExpediente.setStartTimestamp(cal);
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpServiceImpl.logger.error("Error producido al realizar el setTime sobre Calendar con valor "
					+ expedien.getExfere() + e.getMessage(), e);
		}

		// Tramites Expediente
		// Buscar tramite de registro de apertura y sus documentos (en principio
		// no tiene)
		santramexp = new Santramexp();
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APERTURA);
		try {
			santramexp = this.santramexpDao.findUltimoTramiteExpedientePorTipoTramite(santramexp);
		} catch (Exception e) {
		}

		List<Proceedings> listProceedings = new ArrayList<Proceedings>();

		Proceedings proceedings = new Proceedings();
		proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_OFICIO_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_OFICIO_EU);
		cal = Calendar.getInstance();
		cal.setTime(santramexp.getTrfecfin());
		proceedings.setTimestamp(cal);
		listProceedings.add(proceedings);

		// buscar los tramites
		santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(excodigo));
		Pagination pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("asc");
		List<Santramexp> listTramiteExpediente = this.santramexpDao.findAll(santramexp, null);
		if (listTramiteExpediente != null && listTramiteExpediente.size() > 0) {
			for (int i = 0; i < listTramiteExpediente.size(); i++) {
				santramexp = listTramiteExpediente.get(i);
				if (santramexp.getTrfecfin() != null && santramexp.getTrcodigo() != null
						&& santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION)) {
					listProceedings = this.reabrirExpedienteAportacionDocumentacion(santramexp, listProceedings);
				} else if (santramexp.getTrfecfin() != null && santramexp.getTrcodigo() != null
						&& ((!Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO.equals(santramexp.getTrestadoacuse())
								&& santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO))
								|| santramexp.getTrcodigo()
										.equals(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA))) {
					listProceedings = this.reabrirExpedienteAcuseRecibo(santramexp, listProceedings);
				} else if (santramexp.getTrfecfin() != null && santramexp.getTrcodigo() != null
						&& santramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION)) {
					listProceedings = this.reabrirExpedienteComunicacion(santramexp, listProceedings);
				}
			}
		}
		actualizarExpediente
				.setProceedings(Y41bFuncionesAuxiliaresPlatea.eliminarDuplicadosProceedings(listProceedings));
		if (Y41bUtils.interactuarConDokusi()) {
			this.y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);
		}
	}

	/**
	 * Generar Tramite Generico de reapertura de expediente
	 * 
	 * @param expedien
	 *            Expedien
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private Santramexp generarTramiteGenericoReabrirExpediente(Expedien expedien, CensoMonitor censoMonitor)
			throws Exception {

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		Santramexp santramexp = new Santramexp();
		santramexp.setTrfecini(todayWithZeroTime);
		santramexp.setTrfecfin(todayWithZeroTime);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_GENERICO);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(censoMonitor);
		santramexp.setCensoMonitorEj(censoMonitor);
		santramexp.setTrid(this.getNewPK().toString());
		santramexp.setTrnomtrames(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_REAPERTURA);
		this.santramexpDao.add(santramexp);

		return santramexp;
	}

	/**
	 * @param excodigo
	 *            String
	 * @param mapa
	 *            Map<String, Object>
	 * @return Map<String, Object>
	 * @throws Exception
	 *             Exception
	 */
	public Map<String, Object> obtenerDatosTramitesFichaSancionador(String excodigo, Map<String, Object> mapa)
			throws Exception {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		Map<String, Object> mapaIncoacion = new HashMap<String, Object>();
		Map<String, Object> mapaPropuesta = new HashMap<String, Object>();
		Map<String, Object> mapaResolucion = new HashMap<String, Object>();
		Map<String, Object> mapaRecurso = new HashMap<String, Object>();
		Map<String, Object> mapaOrdenConsejero = new HashMap<String, Object>();
		Map<String, Object> mapaRCA = new HashMap<String, Object>();
		Map<String, Object> mapaLiquidacion = new HashMap<String, Object>();
		Map<String, Object> mapaPago = new HashMap<String, Object>();

		String formato = "";
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			formato = Y41bConstantes.FORMATO_FECHA_EU;
		} else {
			formato = Y41bConstantes.FORMATO_FECHA_ES;
		}

		// Alegaciones al acuerdo de incoacion
		Sandoctemp documento = new Sandoctemp();
		documento.setU5tipodocumento(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_ACUERDO_INCOACION);
		documento.setExpedien(new Expedien(excodigo));
		Santramexp aportacion = new Santramexp();
		aportacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
		aportacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		documento.setSantramexp(aportacion);
		Pagination pagination = new Pagination();
		pagination.setSort("U5FECHAENTRADA");
		pagination.setAscDsc("desc");
		List<Sandoctemp> ldocumento = this.sandoctempDao.findAll(documento, pagination);
		if (ldocumento != null && ldocumento.size() > 0) {
			documento = ldocumento.get(0);
			mapaIncoacion.put("alegaciones", Y41bConstantes.VALOR_SI);
			mapaIncoacion.put("recepcion", Y41bUtils.formatearDateToString(documento.getU5fecharegistroorigen() == null
					? documento.getU5fechaentrada() : documento.getU5fecharegistroorigen(), formato));
		} else {
			mapaIncoacion.put("alegaciones", Y41bConstantes.VALOR_NO);
		}

		// Solicitud de ampliacin del plazo de alegaciones al acuerdo de
		// incoacin (Fase inicio)
		documento = new Sandoctemp();
		aportacion = new Santramexp();
		aportacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
		Fase fase = new Fase();
		fase.setFcodigo(Y41bConstantes.FASE_INICIO_SANCION);
		aportacion.setFase(fase);
		aportacion.setExpedien(new Expedien(excodigo));
		aportacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		documento.setSantramexp(aportacion);
		documento.setU5tipodocumento(
				Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_AMPLIACION_PLAZO_ALEGACIONES);
		documento.setExpedien(new Expedien(excodigo));
		Long contador = this.sandoctempDao.findAllCount(documento);
		if (contador.longValue() > 0L) {
			mapaIncoacion.put("ampliacion", Y41bConstantes.VALOR_SI);
		} else {
			mapaIncoacion.put("ampliacion", Y41bConstantes.VALOR_NO);
		}

		// Acuerdo amplicacion del plazo de alegaciones
		Santramexp acuerdoAmpliaPlazoAl = new Santramexp();
		acuerdoAmpliaPlazoAl.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOAMPLIACIONPLAZOALEGACIONES);
		acuerdoAmpliaPlazoAl.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		acuerdoAmpliaPlazoAl.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lacuerdoAmpliaPlazoAl = this.santramexpDao.findAll(acuerdoAmpliaPlazoAl, pagination);
		if (lacuerdoAmpliaPlazoAl != null && lacuerdoAmpliaPlazoAl.size() > 0) {
			for (int i = 0; i < lacuerdoAmpliaPlazoAl.size(); i++) {
				acuerdoAmpliaPlazoAl = lacuerdoAmpliaPlazoAl.get(i);
				if (Y41bConstantes.FASE_INICIO_SANCION.equals(acuerdoAmpliaPlazoAl.getFase().getFcodigo())) {
					if (acuerdoAmpliaPlazoAl != null && acuerdoAmpliaPlazoAl.getTrnumDias() != null
							&& acuerdoAmpliaPlazoAl.getTrnumDias().intValue() > 0) {
						mapaIncoacion.put("concesion", Y41bConstantes.VALOR_SI);
					} else {
						mapaIncoacion.put("concesion", Y41bConstantes.VALOR_NO);
					}
				} else if (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION
						.equals(acuerdoAmpliaPlazoAl.getFase().getFcodigo())) {
					if (acuerdoAmpliaPlazoAl != null && acuerdoAmpliaPlazoAl.getTrnumDias() != null
							&& acuerdoAmpliaPlazoAl.getTrnumDias().intValue() > 0) {
						mapaPropuesta.put("concesion", Y41bConstantes.VALOR_SI);
					} else {
						mapaPropuesta.put("concesion", Y41bConstantes.VALOR_NO);
					}
				}
			}
		}
		// Importe inicial en el acuerdo de incoacion
		Santramexp acuerdoIncoacion = new Santramexp();
		acuerdoIncoacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
		acuerdoIncoacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		acuerdoIncoacion.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lacuerdoIncoacion = this.santramexpDao.findAll(acuerdoIncoacion, pagination);
		if (lacuerdoIncoacion != null && lacuerdoIncoacion.size() > 0) {
			acuerdoIncoacion = lacuerdoIncoacion.get(0);
			mapaIncoacion.put("importeInicial", Y41bUtils.formatearAEuros(acuerdoIncoacion.getTrimporteinicial()));
		}

		// Solicitud reduccion
		Santramexp solicitudReduccion = new Santramexp();
		solicitudReduccion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
		solicitudReduccion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		solicitudReduccion.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lsolicitudReduccion = this.santramexpDao.findAll(solicitudReduccion, pagination);
		if (lsolicitudReduccion != null && lsolicitudReduccion.size() > 0) {
			for (int i = 0; i < lsolicitudReduccion.size(); i++) {
				solicitudReduccion = lsolicitudReduccion.get(i);
				if (Y41bConstantes.FASE_INICIO_SANCION.equals(solicitudReduccion.getFase().getFcodigo())) {
					mapaIncoacion.put("fecSolRed",
							Y41bUtils.formatearDateToString(solicitudReduccion.getTrfecsolred(), formato));
					mapaIncoacion.put("prontopago", solicitudReduccion.getTrprontopago());
					mapaIncoacion.put("reconocimiento", solicitudReduccion.getTrreconocimiento());
				} else if (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION
						.equals(solicitudReduccion.getFase().getFcodigo())) {
					mapaPropuesta.put("fecSolRed",
							Y41bUtils.formatearDateToString(solicitudReduccion.getTrfecsolred(), formato));
					mapaPropuesta.put("prontopago", solicitudReduccion.getTrprontopago());
					mapaPropuesta.put("reconocimiento", solicitudReduccion.getTrreconocimiento());
				}
			}
		}
		// Liquidacion pronto pago tiene relacionada una solicitud de reduccion
		Santramexp liquidacion = new Santramexp();
		liquidacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
		liquidacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		liquidacion.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TO_NUMBER(TRID)");
		pagination.setAscDsc("desc");
		List<Santramexp> lliquidacion = this.santramexpDao.findAll(liquidacion, pagination);
		if (lliquidacion != null && lliquidacion.size() > 0) {
			for (int i = 0; i < lliquidacion.size(); i++) {
				liquidacion = lliquidacion.get(i);
				if (Y41bConstantes.FASE_INICIO_SANCION.equals(liquidacion.getFase().getFcodigo())) {
					mapaIncoacion.put("importeFinal", Y41bUtils.formatearAEuros(liquidacion.getTrresoimporte()));
				} else if (Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION
						.equals(liquidacion.getFase().getFcodigo())) {
					mapaPropuesta.put("importeFinal", Y41bUtils.formatearAEuros(liquidacion.getTrresoimporte()));
				}
				// Nos quedamos con la ultima liquidacion
				if (i == 0) {
					mapaLiquidacion.put("importeFinal", Y41bUtils.formatearAEuros(liquidacion.getTrresoimporte()));
					mapaLiquidacion.put("importeInicial", Y41bUtils.formatearAEuros(liquidacion.getTrimporteinicial()));
				}
				if (!Y41bUtils.esNullOCadenaVacia(liquidacion.getTrreferencia())) {
					mapaLiquidacion.put("emitida", Y41bConstantes.VALOR_SI);
					PagosBusqueda pagosBusqueda = new PagosBusqueda();
					pagosBusqueda.setSgidexpediente(liquidacion.getExpedien().getExcodigo());
					pagosBusqueda.setSgreferencia(liquidacion.getTrreferencia().substring(0, Y41bConstantes.NUM_11));
					pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
					List<Pagos> listaPagos = pagosDao.findAllPagos(pagosBusqueda, null);
					Pagos pagos = null;
					if (listaPagos != null && listaPagos.size() > 0) {
						pagos = listaPagos.get(0);
						if (pagos.getEstadopago().getSacodigo().equals(Y41bConstantes.ESTADO_PAGO_PAGADO)
								|| pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_DEFINITIVO)
								|| pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_PROVISIONAL)) {
							mapaLiquidacion.put("pagada", Y41bConstantes.VALOR_SI);
						}
						if (pagos.getSgfechalimitepago() != null
								&& pagos.getSgfechalimitepago().compareTo(Y41bUtils.hoy()) > 0) {
							mapaLiquidacion.put("valida", Y41bConstantes.VALOR_SI);
						}
					}
				}
			}
		}
		mapa.put("liquidacion", mapaLiquidacion);
		mapa.put("incoacion", mapaIncoacion);

		// Alegaciones al acuerdo de incoacion
		documento = new Sandoctemp();
		documento.setU5tipodocumento(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_PROPUESTA_RESOLUCION);
		documento.setExpedien(new Expedien(excodigo));
		aportacion = new Santramexp();
		aportacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
		aportacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		documento.setSantramexp(aportacion);
		pagination = new Pagination();
		pagination.setSort("U5FECHAENTRADA");
		pagination.setAscDsc("desc");
		ldocumento = this.sandoctempDao.findAll(documento, pagination);
		if (ldocumento != null && ldocumento.size() > 0) {
			documento = ldocumento.get(0);
			mapaPropuesta.put("alegaciones", Y41bConstantes.VALOR_SI);
			mapaPropuesta.put("recepcion", Y41bUtils.formatearDateToString(documento.getU5fecharegistroorigen() == null
					? documento.getU5fechaentrada() : documento.getU5fecharegistroorigen(), formato));
		} else {
			mapaPropuesta.put("alegaciones", Y41bConstantes.VALOR_NO);
		}

		// Solicitud de ampliacin del plazo de alegaciones a la propuesta (Fase
		// inicio)
		documento = new Sandoctemp();
		aportacion = new Santramexp();
		aportacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
		fase = new Fase();
		fase.setFcodigo(Y41bConstantes.FASE_PROPUESTA_RESOLUCION_SANCION);
		aportacion.setFase(fase);
		aportacion.setExpedien(new Expedien(excodigo));
		aportacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		documento.setSantramexp(aportacion);
		documento.setU5tipodocumento(
				Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_AMPLIACION_PLAZO_ALEGACIONES);
		documento.setExpedien(new Expedien(excodigo));
		contador = this.sandoctempDao.findAllCount(documento);
		if (contador > 0L) {
			mapaPropuesta.put("ampliacion", Y41bConstantes.VALOR_SI);
		} else {
			mapaPropuesta.put("ampliacion", Y41bConstantes.VALOR_NO);
		}

		Santramexp propuesta = new Santramexp();
		propuesta.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
		propuesta.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		propuesta.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lpropuesta = this.santramexpDao.findAll(propuesta, pagination);
		if (lpropuesta != null && lpropuesta.size() > 0) {
			mapaPropuesta.put("mostrar", Y41bConstantes.VALOR_SI);
			propuesta = lpropuesta.get(0);
			if (propuesta.getTrresoimporte() != null) {
				mapaPropuesta.put("importeInicial", Y41bUtils.formatearAEuros(propuesta.getTrresoimporte()));
			}
			mapaPropuesta.put("trresotipo", propuesta.getTrresotipo());
			mapaPropuesta.put("fecha", Y41bUtils.formatearDateToString(propuesta.getTrresofecha(), formato));
		}
		mapa.put("propuesta", mapaPropuesta);

		Santramexp resolucion = new Santramexp();
		resolucion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
		resolucion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		resolucion.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lresolucion = this.santramexpDao.findAll(resolucion, pagination);
		if (lresolucion != null && lresolucion.size() > 0) {
			mapaResolucion.put("mostrar", Y41bConstantes.VALOR_SI);
			resolucion = lresolucion.get(0);
			if (resolucion.getTrresoimporte() != null) {
				mapaResolucion.put("importe", Y41bUtils.formatearAEuros(resolucion.getTrresoimporte()));
			}
			if (resolucion.getTrimporteinicial() != null) {
				mapaResolucion.put("importeInicial", Y41bUtils.formatearAEuros(resolucion.getTrimporteinicial()));
			}
			mapaResolucion.put("trresotipo", resolucion.getTrresotipo());
			mapaResolucion.put("trresosan", resolucion.getTrresosan());

			mapaResolucion.put("fecha", Y41bUtils.formatearDateToString(resolucion.getTrresofecha(), formato));

			List<Sanenvio> listSanenvio = this.sanenvioDao.findSanEnvioResolucion(excodigo);
			if (listSanenvio != null && listSanenvio.size() > 0) {
				Sanenvio sanenvio = listSanenvio.get(0);
				mapaResolucion.put("trfecnotif", Y41bUtils.formatearDateToString(sanenvio.getEnfecacuse(), formato));
			} else {
				mapaResolucion.put("trfecnotif", null);
			}

		}
		mapa.put("resolucion", mapaResolucion);

		// Recepcion recurso alzada
		Santramexp recursoAlz = new Santramexp();
		recursoAlz.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA);
		recursoAlz.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		recursoAlz.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lrecurso = this.santramexpDao.findAll(recursoAlz, pagination);
		if (lrecurso != null && lrecurso.size() > 0) {
			recursoAlz = lrecurso.get(0);
			mapaRecurso.put("mostrar", Y41bConstantes.VALOR_SI);
			mapaRecurso.put("fecha", Y41bUtils.formatearDateToString(recursoAlz.getTrfecenvio(), formato));
		}
		// Informe asesora
		Santramexp informAsesoria = new Santramexp();
		informAsesoria.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACIONINFORMEASESORIA);
		informAsesoria.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		informAsesoria.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> linformAsesoria = this.santramexpDao.findAll(informAsesoria, pagination);
		if (linformAsesoria != null && linformAsesoria.size() > 0) {
			mapaRecurso.put("mostrar", Y41bConstantes.VALOR_SI);
			informAsesoria = linformAsesoria.get(0);
			mapaRecurso.put("fechaEnvioInforme",
					Y41bUtils.formatearDateToString(informAsesoria.getTrfecenvio(), formato));
		}
		mapa.put("recurso", mapaRecurso);

		// Orden consejero
		Santramexp ordenConsejero = new Santramexp();
		ordenConsejero.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO);
		ordenConsejero.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		ordenConsejero.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lordenConsejero = this.santramexpDao.findAll(ordenConsejero, pagination);
		if (lordenConsejero != null && lordenConsejero.size() > 0) {
			mapaOrdenConsejero.put("mostrar", Y41bConstantes.VALOR_SI);
			ordenConsejero = lordenConsejero.get(0);
			mapaOrdenConsejero.put("fecha", Y41bUtils.formatearDateToString(ordenConsejero.getTrresofecha(), formato));
			mapaOrdenConsejero.put("estimacion", ordenConsejero.getTrestimacion());
			if (ordenConsejero.getTrresoimporte() != null) {
				mapaOrdenConsejero.put("importe", Y41bUtils.formatearAEuros(ordenConsejero.getTrresoimporte()));
			}
			Recurso recurso = new Recurso();
			recurso.setExpedien(new Expedien(excodigo));
			Long cuantosRecursos = this.recursoDao.findAllCount(recurso);
			if (cuantosRecursos > 0) {
				List<Recurso> recursosLista = this.recursoDao.findAll(recurso, null);
				if (recursosLista != null && recursosLista.size() > 0) {
					recurso = recursosLista.get(0);
					mapaOrdenConsejero.put("fechaNot", Y41bUtils.formatearDateToString(recurso.getRefenrro(), formato));
					Sanrecrca sanrecrca = new Sanrecrca();
					sanrecrca.setRecodigo(recurso.getRecodigo());
					sanrecrca = this.sanrecrcaDao.find(sanrecrca);
					if (sanrecrca != null) {
						mapaRCA.put("mostrar", Y41bConstantes.VALOR_SI);
						mapaRCA.put("fecha", recurso.getRefeinrc() != null
								? Y41bUtils.formatearDateToString(recurso.getRefeinrc(), formato) : "");
						mapaRCA.put("fechaDevolucion", sanrecrca.getRercafecdev() != null
								? Y41bUtils.formatearDateToString(sanrecrca.getRercafecdev(), formato) : "");
						if (sanrecrca.getRercaimpdev() != null && !"".equals(sanrecrca.getRercaimpdev())) {
							mapaRCA.put("importeDevolucion",
									Y41bUtils.formatearAEuros(new BigDecimal(sanrecrca.getRercaimpdev())));
						}
						mapaRCA.put("resulsen",
								sanrecrca.getSanresulsen() != null ? sanrecrca.getSanresulsen().getRsid() : "");
						mapaRCA.put("tribunal",
								sanrecrca.getTribunal() != null ? sanrecrca.getTribunal().getTbcodigo() : "");
						if (recurso.getRecamurc() != null && !"".equals(recurso.getRecamurc())) {
							mapaRCA.put("multa", Y41bUtils.formatearAEuros(recurso.getRecamurc()));
						}
					}
				}
			}
		}
		mapa.put("ordenConsejero", mapaOrdenConsejero);

		mapa.put("rca", mapaRCA);

		// Pago
		// Obtener los pagos realizados
		PagosBusqueda pagosBusqueda = new PagosBusqueda();
		pagosBusqueda.setSgidexpediente(excodigo);
		pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
		List<Pagos> listaPagos = pagosDao.findAllPagos(pagosBusqueda, null);
		Pagos pagos = null;
		if (listaPagos != null && listaPagos.size() > 0) {
			// Si hay algun pago en via de apremio, activar flag
			for (int i = 0; i < listaPagos.size(); i++) {
				pagos = listaPagos.get(i);
				// Va de apremio no se puede determinar por el estado
				// Existe un campo para marcar las liquidacion via de
				// apremio
				if (Y41bConstantes.VALOR_SI.equals(pagos.getSgviaapremio())) {
					mapaPago.put("viaApremio", pagos.getSgviaapremio());
				}
			}
		}
		Santramexp pago = new Santramexp();
		pago.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PAGO);
		pago.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		pago.setExpedien(new Expedien(excodigo));
		pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lpago = this.santramexpDao.findAll(pago, pagination);
		if (lpago != null && lpago.size() > 0) {
			pago = lpago.get(0);
			mapaPago.put("fase", pago.getFase().getFcodigo());
			mapaPago.put("fecha", Y41bUtils.formatearDateToString(pago.getTrresofecha(), formato));
		}
		mapa.put("pago", mapaPago);
		return mapa;
	}

	/**
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return boolean
	 */
	private boolean compatibleConAA66(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	/**
	 * 
	 * @param expedien
	 *            Expedien
	 * @param saninterv
	 *            Saninterv
	 */
	public void abrirSolicitudOficioPlatea(Expedien expedien) {
		logger.info("ExpedienteServiceImpl. - Add. Preparar Llamada a Platea");
		SolicitudOficio solicitudOficio = new SolicitudOficio();

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());

		sanexp = this.sanexpDao.find(sanexp);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		solicitudOficio.setProcedure(procedure);
		DatosPersona datosPersona = new DatosPersona();
		CensoMonitor censoMonitorSender = new CensoMonitor();
		censoMonitorSender.setMocodigo(expedien.getSanexp().getExmocodigo());
		censoMonitorSender = censoMonitorDao.find(censoMonitorSender);
		datosPersona.setDni(censoMonitorSender.getModni());
		datosPersona.setNombre(censoMonitorSender.getMonombre());
		solicitudOficio.setSender(datosPersona);
		solicitudOficio.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		/* SANCIONADO */
		Saninterv saninterv = this.sanintervDao.dameSancionado(expedien.getExcodigo());
		DatosPersona datosEstablecimientoSancionado = new DatosPersona();
		datosEstablecimientoSancionado.setDni(saninterv.getUanif().trim());
		datosEstablecimientoSancionado.setNombre(saninterv.getUanombre());
		datosEstablecimientoSancionado.setTelefono(saninterv.getUanrtel());
		datosEstablecimientoSancionado.setMail(saninterv.getUacoem());

		solicitudOficio.setSancionado(datosEstablecimientoSancionado);
		solicitudOficio.setNumeroExpediente(expedien.damecodCompletoPlatea());
		solicitudOficio.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		logger.info("ExpedienteServiceImpl. - Add. Inicio Llamada a Platea");
		if (Y41bUtils.interactuarConDokusi()) {
			y41bPlateaAdapterService.crearSolicitudOficio(solicitudOficio);
		}

		logger.info("ExpedienteServiceImpl. - Add. Fin Llamada a Platea");
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @throws Exception
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacion(Santramexp santramexp,
			List<Proceedings> listProceedings) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(santramexp.getTrid().toString());
		List<Sandoctemp> listDocumentosAporta = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux, null);
		if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
			Sandoctemp sandoctemp = null;
			boolean aportadoReclamado = false;
			for (int j = 0; j < listDocumentosAporta.size(); j++) {
				sandoctemp = listDocumentosAporta.get(j);
				if (sandoctemp.getU5origen() != null
						&& (sandoctemp.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO) || sandoctemp
								.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO))
						&& sandoctemp.getU5iddocumentum() != null && !sandoctemp.getU5iddocumentum().equals("")) {
					aportadoReclamado = true;
					break;
				}
			}
			if (aportadoReclamado) {
				Proceedings proceedings = new Proceedings();
				if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
					proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

				// Calendar cal = Calendar.getInstance();
				// cal.setTime(santramexp.getTrfecfin());
				// proceedings.setTimestamp(cal);

				Date fechaAportacion = null;

				ArrayList<Documento> documentos = new ArrayList<Documento>();
				if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
					for (int k = 0; k < listDocumentosAporta.size(); k++) {
						sandoctemp = listDocumentosAporta.get(k);
						Documento documento = new Documento();
						if (sandoctemp.getU5origen() != null
								&& (sandoctemp.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO)
										|| sandoctemp.getU5origen()
												.equals(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO))
								&& sandoctemp.getU5iddocumentum() != null
								&& !sandoctemp.getU5iddocumentum().equals("")) {
							if (fechaAportacion == null) {
								fechaAportacion = sandoctemp.getU5fechaentrada();
							} else if (sandoctemp.getU5fechaentrada() != null
									&& sandoctemp.getU5fechaentrada().after(fechaAportacion)) {
								fechaAportacion = sandoctemp.getU5fechaentrada();
							}

							documento.setOidDokusi(sandoctemp.getU5iddocumentum());
							documento.setNombre(sandoctemp.getU5nofile());
							documento.setDescripcion(sandoctemp.getU5tedesfile());
							documentos.add(documento);
						}
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion,
						Y41bConstantes.CASTELLANO);

				String fechaAportacionConHoras = "";

				DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
						.append(hourFormat.format(santramexp.getTrfecini())).toString();
				aportacionTimestamp.setTime(
						Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacion(Santramexp santramexp, List<Proceedings> listProceedings) {

		Santramexp santramexpAux = new Santramexp();
		santramexpAux.setTrid(santramexp.getTrid());
		santramexpAux = santramexpDao.find(santramexpAux);
		boolean remesaEmitida = true;
		if (santramexpAux.getTrenvrem() != null && santramexpAux.getTrenvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (santramexpAux.getTrcodrem() != null && !santramexpAux.getTrcodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(santramexpAux.getTrcodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(santramexp.getTruaidinterv());
		saninterv = this.sanintervDao.find(saninterv);

		if (saninterv != null && saninterv.getUatipointerv() != null
				&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
						|| saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
						|| saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))
				&& (santramexp.getTrtipocom() != null
						&& (santramexp.getTrtipocom().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
								|| santramexp.getTrtipocom().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			Santramexp tramiteRelacionado = null;
			if (santramexp.getTrtridrel() != null) {
				tramiteRelacionado = this.santramexpDao.find(new Santramexp(santramexp.getTrtridrel()));
			}
			if (tramiteRelacionado != null) {
				if (!Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())
						&& !existeProceedingsID(tramiteRelacionado.getTrproceedingsidplatea(), listProceedings)) {
					if (tramiteRelacionado.getTrfecfin() != null && tramiteRelacionado.getTrcodigo() != null
							&& (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION
									.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
											.equals(tramiteRelacionado.getTrcodigo())
									|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO
											.equals(tramiteRelacionado.getTrcodigo()))) {
						listProceedings = this.reabrirExpedienteTramite(tramiteRelacionado, listProceedings);
					}
				}
			}

			Proceedings proceedings = new Proceedings();

			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);

			if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(santramexp.getTrtipocom())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(santramexp.getTridnotifplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(santramexp.getTrid().toString());
			List<Sandoctemp> listDocumentoComunicacion = this.sandoctempDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				Sandoctemp sandoctemp = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					sandoctemp = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (sandoctemp.getU5iddocumentum() != null && !sandoctemp.getU5iddocumentum().equals("")) {
						documento.setOidDokusi(sandoctemp.getU5iddocumentum());
						documento.setNombre(sandoctemp.getU5nofile());
						documento.setDescripcion(sandoctemp.getU5tedesfile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * 
	 * @param id
	 *            String
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return boolean
	 */
	private boolean existeProceedingsID(String id, List<Proceedings> listProceedings) {
		boolean existe = false;
		Proceedings proceedings = new Proceedings();
		for (int i = 0; i < listProceedings.size(); i++) {
			proceedings = listProceedings.get(i);
			if (id.equals(proceedings.getProceedingsID())) {
				existe = true;
				break;
			}
		}
		return existe;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 */
	private List<Proceedings> reabrirExpedienteAcuseRecibo(Santramexp santramexp, List<Proceedings> listProceedings)
			throws Exception {

		Santramexp acuseRelacionado = null;
		if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
			acuseRelacionado = santramexp;
		} else {
			// Buscamos un acuse con la misma notificacion relacionada
			Santramexp santramexpAux = new Santramexp();
			santramexpAux.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO);
			santramexpAux.setTrtridrel(santramexp.getTrtridrel());
			List<Santramexp> listaSantramexp = this.santramexpDao.findAll(santramexpAux, null);
			if (listaSantramexp != null && listaSantramexp.size() > 0) {
				acuseRelacionado = listaSantramexp.get(0);
			}
		}

		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(santramexp.getTruaidinterv());
		saninterv = this.sanintervDao.find(saninterv);
		Santramexp tramiteNotificacion = null;
		Santramexp tramiteRelacionado = null;
		if (saninterv != null && saninterv.getUatipointerv() != null
				&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
						|| saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
						|| saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))) {

			if (santramexp.getTrtridrel() != null) {
				tramiteNotificacion = this.santramexpDao.find(new Santramexp(santramexp.getTrtridrel()));
				if (tramiteNotificacion != null) {
					if (tramiteNotificacion.getTrtridrel() != null) {
						tramiteRelacionado = this.santramexpDao
								.find(new Santramexp(tramiteNotificacion.getTrtridrel()));
					}
					if (tramiteRelacionado != null) {
						if (!Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())
								&& !existeProceedingsID(tramiteRelacionado.getTrproceedingsidplatea(),
										listProceedings)) {
							if (tramiteRelacionado.getTrfecfin() != null && tramiteRelacionado.getTrcodigo() != null
									&& (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION
											.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
													.equals(tramiteRelacionado.getTrcodigo())
											|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO
													.equals(tramiteRelacionado.getTrcodigo()))) {
								listProceedings = this.reabrirExpedienteTramite(tramiteRelacionado, listProceedings);
							}
						}
					}

					Proceedings proceedings = new Proceedings();

					if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
						proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
					} else {
						proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
					}

					proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
					proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);
					Calendar cal = Calendar.getInstance();
					cal.setTime(santramexp.getTrfecfin());
					proceedings.setTimestamp(cal);

					if (tramiteNotificacion != null) {
						if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteNotificacion.getTrtiponot())) {
							proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
						} else {
							proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
						}
						proceedings.setOidnotification(tramiteNotificacion.getTridnotifplatea());

						proceedings.setNotifiedActId(tramiteNotificacion.getTrtiponotplatea());

						cal = Calendar.getInstance();
						cal.setTime(tramiteNotificacion.getTrfecfin());
						proceedings.setNotifiedPublicationtimestamp(cal);
					}

					if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
						cal = Calendar.getInstance();
						cal.setTime(acuseRelacionado.getTrfecacuse());
						proceedings.setNotifiedDeliverytimestamp(cal);
						proceedings.setNotifiedResult(acuseRelacionado.getTrestadoacuse());
					} else {
						// No entregado publicado en el BOE, no hay
						// NotifiedDeliverytimestamp
						proceedings.setNotifiedResult(Y41bUtils
								.formatearDateToString(santramexp.getTrfecinitabl(), Y41bConstantes.FORMATO_FECHA_ES)
								.concat("@").concat(Y41bUtils.formatearDateToString(santramexp.getTrfecinitabl(),
										Y41bConstantes.FORMATO_FECHA_EU)));
					}

					List<Documento> documentos = new ArrayList<Documento>();
					if (tramiteNotificacion != null) {
						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdTramite(tramiteNotificacion.getTrid().toString());
						List<Sandoctemp> listDocumentoComunicacion = this.sandoctempDao
								.findAllDocumentosTramite(tramiteComunAux, null);
						if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
							Sandoctemp sandoctemp = null;

							for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
								sandoctemp = listDocumentoComunicacion.get(k);
								Documento documento = new Documento();
								if (sandoctemp.getU5iddocumentum() != null
										&& !sandoctemp.getU5iddocumentum().equals("")) {
									documento.setOidDokusi(sandoctemp.getU5iddocumentum());
									documento.setNombre(sandoctemp.getU5nofile());
									documento.setDescripcion(sandoctemp.getU5tedesfile());
									documentos.add(documento);
								}
							}
						}
						proceedings.setDocumentosNotificacionComunicacion(documentos);
						listProceedings.add(proceedings);
					}
				}
			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteTramite(Santramexp santramexp, List<Proceedings> listProceedings) {

		if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_ACUERDOINCOACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_ACUERDOINCOACION_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			proceedings.setDecisionCast(decision.getDenombre());
			proceedings.setDecisionEus(decision.getDenombree());
			cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrresofecha());
			proceedings.setDecisiontimestamp(cal);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RESOLUCION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			proceedings.setDecisionCast(decision.getDenombre());
			proceedings.setDecisionEus(decision.getDenombree());
			cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrresofecha());
			proceedings.setDecisiontimestamp(cal);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RECURSOALZADA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RECURSOALZADA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_ORDENCONSEJERO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_ORDENCONSEJERO_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			proceedings.setDecisionCast(decision.getDenombre());
			proceedings.setDecisionEus(decision.getDenombree());
			cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrresofecha());
			proceedings.setDecisiontimestamp(cal);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_SOLICITUD_REDUCCION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_SOLICITUD_REDUCCION_EU);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION.equals(santramexp.getTrcodigo())) {
			// Buscamos el trmite relacionado que puede ser la resolucin o la
			// orden del consejero
			Santramexp tramiteRelacionado = null;
			if (santramexp.getTrtridrel() != null) {
				tramiteRelacionado = this.santramexpDao.find(new Santramexp(santramexp.getTrtridrel()));
				Proceedings proceedings = new Proceedings();
				Calendar cal = Calendar.getInstance();
				cal.setTime(tramiteRelacionado.getTrfecfin());
				proceedings.setTimestamp(cal);
				if (tramiteRelacionado != null
						&& !Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())) {
					proceedings.setProceedingsID(tramiteRelacionado.getTrproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

					tramiteRelacionado.setTrproceedingsidplatea(proceedings.getProceedingsID());
					this.santramexpDao.updateProceedingsIdPlatea(tramiteRelacionado);
				}

				if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tramiteRelacionado.getTrcodigo())) {
					proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RESOLUCION_ES);
					proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
					Decision decision = new Decision();
					decision.setDecodigo(tramiteRelacionado.getTrresotipo());
					decision = this.decisionDao.find(decision);
					proceedings.setDecisionCast(decision.getDenombre());
					proceedings.setDecisionEus(decision.getDenombree());
					cal = Calendar.getInstance();
					cal.setTime(tramiteRelacionado.getTrresofecha());
					proceedings.setDecisiontimestamp(cal);
				} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
						.equals(tramiteRelacionado.getTrcodigo())) {
					proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_ORDENCONSEJERO_ES);
					proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_ORDENCONSEJERO_EU);
					Decision decision = new Decision();
					decision.setDecodigo(tramiteRelacionado.getTrresotipo());
					decision = this.decisionDao.find(decision);
					proceedings.setDecisionCast(decision.getDenombre());
					proceedings.setDecisionEus(decision.getDenombree());
					cal = Calendar.getInstance();
					cal.setTime(tramiteRelacionado.getTrresofecha());
					proceedings.setDecisiontimestamp(cal);
				} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
						.equals(tramiteRelacionado.getTrcodigo())) {
					proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_SOLICITUD_REDUCCION_ES);
					proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_SOLICITUD_REDUCCION_EU);
				}
				listProceedings.add(proceedings);
			}
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (tramiteRelacionado != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_LIQUIDACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_LIQUIDACION_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO.equals(santramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(santramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				santramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RECURSOEXTRAORDINARIO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RECURSOEXTRAORDINARIO_EU);
			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws SQLException
	 */
	private void eliminarMisGestiones(Santramexp santramexp) throws SQLException {

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		Saninterv saninterv = this.sanintervDao.dameSancionado(santramexp.getExpedien().getExcodigo());

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
		sanexp = this.sanexpDao.find(sanexp);
		actualizarMisGestiones.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(saninterv.getUanif());
		datosPersona.setNombre(saninterv.getUanombre());
		actualizarMisGestiones.setSolicitante(datosPersona);

		// REPRESENTANTE SANCIONADO
		Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(santramexp.getExpedien().getExcodigo(),
				Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

		if (sancionadoRepr != null) {
			DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
			// Le ponemos el idioma del titular
			datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
			actualizarMisGestiones.setRepresentante(datosSancionadoRepr);
		}
		// --------------------------------------------------------------------------

		actualizarMisGestiones.setEjercicio(santramexp.getExpedien().getExnran().toString());

		actualizarMisGestiones.setNumeroExpediente(santramexp.getExpedien().damecodCompletoPlatea());

		actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());

		if (Y41bUtils.interactuarConDokusi()) {
			y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
		}
	}

	/**
	 * @param santramexp
	 *            Santramexp
	 * @param listDocumentos
	 *            List<Sandoctemp>
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarMisGestionesAportaciondocumentacion(Santramexp santramexp, List<Sandoctemp> listDocumentos)
			throws Exception {
		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

		actualizarMisGestiones.setProcedure(procedure);
		DatosPersona datosPersona = new DatosPersona();
		Saninterv saninterv = this.sanintervDao.dameSancionado(santramexp.getExpedien().getExcodigo());

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
		sanexp = this.sanexpDao.find(sanexp);
		actualizarMisGestiones.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		datosPersona.setDni(saninterv.getUanif());
		datosPersona.setNombre(saninterv.getUanombre());
		if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
			datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).append(" ")
						.append(saninterv.getUaapellido2()).toString());
			}
		}
		datosPersona.setMail(saninterv.getUacoem());
		datosPersona.setTelefono(saninterv.getUanrtel());

		actualizarMisGestiones.setSolicitante(datosPersona);

		// REPRESENTANTE SANCIONADO
		Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(santramexp.getExpedien().getExcodigo(),
				Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
		if (sancionadoRepr != null) {
			DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
			// Le ponemos el idioma del titular
			datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
			actualizarMisGestiones.setRepresentante(datosSancionadoRepr);
		}
		// --------------------------------------------------------------------------

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(santramexp.getExpedien().damecodCompletoPlatea());

		actualizarMisGestiones.setEjercicio(santramexp.getExpedien().getExnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		List<Documento> listaDocumentosRdo = null;
		Date fechaAportacion = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (Sandoctemp documentoHecho : listDocumentos) {
				if (documentoHecho.getU5origen() != null
						&& (documentoHecho.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO)
								|| documentoHecho.getU5origen()
										.equals(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO))) {
					if (fechaAportacion == null) {
						fechaAportacion = documentoHecho.getU5fechaentrada();
					} else if (documentoHecho.getU5fechaentrada() != null
							&& documentoHecho.getU5fechaentrada().after(fechaAportacion)) {
						fechaAportacion = documentoHecho.getU5fechaentrada();
					}
					documento = new Documento();
					documento.setNombre(documentoHecho.getU5nofile());
					documento.setDescripcion(documentoHecho.getU5tedesfile());
					documento.setOidDokusi(documentoHecho.getU5iddocumentum());
					String tipoDocumental = "";
					if (Y41bUtils.isFilled(documentoHecho.getU5tipodocumento())) {
						if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getU5pcodigo())) {
							Santipdoc santipdoc = new Santipdoc();
							santipdoc.setTdid(documentoHecho.getU5tipodocumento());
							santipdoc = this.santipdocDao.find(santipdoc);
							tipoDocumental = santipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getU5pcodigo())) {
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoHecho.getU5tipodocumento());
							arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
							tipoDocumental = arbtipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getU5pcodigo())) {
							tipoDocumental = documentoHecho.getU5tipodocumento();
						}
					} else {
						tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					}
					documento.setTipoDocumental(tipoDocumental);
					listaDocumentosRdo.add(documento);
				}
			}
		}

		// Los documentos son de origen interesado
		if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {

			Calendar aportacionTimestamp = Calendar.getInstance();

			String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, Y41bConstantes.CASTELLANO);

			String fechaAportacionConHoras = "";

			DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

			fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
					.append(hourFormat.format(santramexp.getTrfecini())).toString();
			aportacionTimestamp
					.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

			actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			if (Y41bUtils.interactuarConDokusi()) {
				y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}

			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		}

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listDocumentos
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesComunicacion(Santramexp tramiteComunicacion, List<Sandoctemp> listDocumentos)
			throws SQLException {

		Santramexp tramiteRelacionado = null;
		if (tramiteComunicacion.getTrtridrel() != null) {
			tramiteRelacionado = this.santramexpDao.find(new Santramexp(tramiteComunicacion.getTrtridrel()));
		}
		if (tramiteRelacionado != null && Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())) {
			this.actualizarMisGestiones(tramiteRelacionado);
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		Saninterv saninterv = this.sanintervDao.dameSancionado(tramiteComunicacion.getExpedien().getExcodigo());

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(tramiteComunicacion.getExpedien().getExcodigo());
		sanexp = this.sanexpDao.find(sanexp);
		actualizarMisGestiones.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(saninterv.getUanif());
		datosPersona.setNombre(saninterv.getUanombre());
		if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
			datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).append(" ")
						.append(saninterv.getUaapellido2()).toString());
			}
		}
		datosPersona.setMail(saninterv.getUacoem());
		datosPersona.setTelefono(saninterv.getUanrtel());
		actualizarMisGestiones.setSolicitante(datosPersona);

		// REPRESENTANTE SANCIONADO
		Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(tramiteComunicacion.getExpedien().getExcodigo(),
				Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
		if (sancionadoRepr != null) {
			DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
			// Le ponemos el idioma del titular
			datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
			actualizarMisGestiones.setRepresentante(datosSancionadoRepr);
		}
		// --------------------------------------------------------------------------

		actualizarMisGestiones.setEjercicio(tramiteComunicacion.getExpedien().getExnran().toString());

		actualizarMisGestiones.setNumeroExpediente(tramiteComunicacion.getExpedien().damecodCompletoPlatea());

		if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteComunicacion.getTrtipocom())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramiteComunicacion.getTridnotifplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (Sandoctemp documentoHecho : listDocumentos) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getU5nofile());
				documento.setDescripcion(documentoHecho.getU5tedesfile());
				documento.setOidDokusi(documentoHecho.getU5iddocumentum());
				String tipoDocumental = "";
				if (Y41bUtils.isFilled(documentoHecho.getU5tipodocumento())) {
					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getU5pcodigo())) {
						Santipdoc santipdoc = new Santipdoc();
						santipdoc.setTdid(documentoHecho.getU5tipodocumento());
						santipdoc = this.santipdocDao.find(santipdoc);
						tipoDocumental = santipdoc.getIdTipodoc();
					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getU5pcodigo())) {
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(documentoHecho.getU5tipodocumento());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						tipoDocumental = arbtipdoc.getIdTipodoc();
					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getU5pcodigo())) {
						tipoDocumental = documentoHecho.getU5tipodocumento();
					}
				} else {
					tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
				}
				documento.setTipoDocumental(tipoDocumental);
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
		if (Y41bUtils.interactuarConDokusi()) {
			y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);
		}

		tramiteComunicacion.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.santramexpDao.updateProceedingsIdPlatea(tramiteComunicacion);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listDocumentos
	 *            List<Sandoctemp>
	 * @throws Exception
	 */
	public void actualizarMisGestionesNotificacion(Santramexp santramexp, List<Sandoctemp> listDocumentos)
			throws Exception {

		Santramexp acuseRelacionado = null;
		if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
			acuseRelacionado = santramexp;
		} else {
			// Buscamos un acuse con la misma notificacion relacionada
			Santramexp santramexpAux = new Santramexp();
			santramexpAux.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO);
			santramexpAux.setTrtridrel(santramexp.getTrtridrel());
			List<Santramexp> listaSantramexp = this.santramexpDao.findAll(santramexpAux, null);
			if (listaSantramexp != null && listaSantramexp.size() > 0) {
				acuseRelacionado = listaSantramexp.get(0);
			}
		}

		Santramexp tramiteNotificacion = null;
		if (acuseRelacionado.getTrtridrel() != null) {
			tramiteNotificacion = this.santramexpDao.find(new Santramexp(acuseRelacionado.getTrtridrel()));

			if (tramiteNotificacion != null) {
				Santramexp tramiteRelacionado = null;
				if (santramexp.getTrtridrel() != null) {
					tramiteRelacionado = this.santramexpDao.find(new Santramexp(tramiteNotificacion.getTrtridrel()));
					if (tramiteRelacionado != null) {
						this.actualizarMisGestiones(tramiteRelacionado);
					}
				}

				ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

				actualizarMisGestiones.setProcedure(procedure);

				Saninterv saninterv = this.sanintervDao.dameSancionado(santramexp.getExpedien().getExcodigo());

				Sanexp sanexp = new Sanexp();
				sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
				sanexp = this.sanexpDao.find(sanexp);
				actualizarMisGestiones.setIdParticipacion(sanexp.getExidparticipacionsancionado());

				DatosPersona datosPersona = new DatosPersona();
				datosPersona.setDni(saninterv.getUanif());
				datosPersona.setNombre(saninterv.getUanombre());
				if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
					datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).toString());

					if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
						datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).append(" ")
								.append(saninterv.getUaapellido2()).toString());
					}
				}
				datosPersona.setMail(saninterv.getUacoem());
				datosPersona.setTelefono(saninterv.getUanrtel());
				actualizarMisGestiones.setSolicitante(datosPersona);

				// REPRESENTANTE SANCIONADO
				Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(santramexp.getExpedien().getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
				if (sancionadoRepr != null) {
					DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
					// Le ponemos el idioma del titular
					datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
					actualizarMisGestiones.setRepresentante(datosSancionadoRepr);
				}
				// --------------------------------------------------------------------------

				actualizarMisGestiones.setEjercicio(santramexp.getExpedien().getExnran().toString());

				actualizarMisGestiones.setNumeroExpediente(santramexp.getExpedien().damecodCompletoPlatea());

				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());

				actualizarMisGestiones.setIdnotificacionplatea(tramiteNotificacion.getTridnotifplatea());
				actualizarMisGestiones.setIdTiponotificacionplatea(tramiteNotificacion.getTrtiponotplatea());

				Calendar notificacionPublicationTimestamp = Calendar.getInstance();
				notificacionPublicationTimestamp.setTime(tramiteNotificacion.getTrfecfin());
				actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);
				if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteNotificacion.getTrtiponot())) {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
				} else {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
				}

				Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
				notificacionDeliveryTimestamp.setTime(acuseRelacionado.getTrfecacuse());
				actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);
				if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())) {
					actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(acuseRelacionado.getTrestadoacuse());
				} else {
					actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(Y41bUtils
							.formatearDateToString(santramexp.getTrfecinitabl(), Y41bConstantes.FORMATO_FECHA_ES)
							.concat("@").concat(Y41bUtils.formatearDateToString(santramexp.getTrfecinitabl(),
									Y41bConstantes.FORMATO_FECHA_EU)));
				}

				List<Documento> listaDocumentosRdo = null;
				if (listDocumentos != null && listDocumentos.size() > 0) {
					listaDocumentosRdo = new ArrayList<Documento>();
					Documento documento = null;
					for (Sandoctemp documentoHecho : listDocumentos) {
						documento = new Documento();
						documento.setNombre(documentoHecho.getU5nofile());
						documento.setDescripcion(documentoHecho.getU5tedesfile());
						documento.setOidDokusi(documentoHecho.getU5iddocumentum());
						String tipoDocumental = "";
						if (Y41bUtils.isFilled(documentoHecho.getU5tipodocumento())) {
							if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getU5pcodigo())) {
								Santipdoc santipdoc = new Santipdoc();
								santipdoc.setTdid(documentoHecho.getU5tipodocumento());
								santipdoc = this.santipdocDao.find(santipdoc);
								tipoDocumental = santipdoc.getIdTipodoc();
							} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getU5pcodigo())) {
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documentoHecho.getU5tipodocumento());
								arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
								tipoDocumental = arbtipdoc.getIdTipodoc();
							} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getU5pcodigo())) {
								tipoDocumental = documentoHecho.getU5tipodocumento();
							}
						} else {
							tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
						}
						documento.setTipoDocumental(tipoDocumental);
						listaDocumentosRdo.add(documento);
					}
				}

				actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
				if (Y41bUtils.interactuarConDokusi()) {
					y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);
				}

				santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
				this.santramexpDao.updateProceedingsIdPlatea(santramexp);

			}
		}
	}

	/**
	 * @param santramexp
	 *            Santramexp
	 * @throws SQLException
	 *             SQLException
	 */
	private void actualizarMisGestiones(Santramexp santramexp) throws SQLException {

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		Saninterv saninterv = this.sanintervDao.dameSancionado(santramexp.getExpedien().getExcodigo());
		actualizarMisGestiones.setSolicitante(this.sanintervService.cargarDatosPersona(saninterv));

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(santramexp.getExpedien().getExcodigo());
		sanexp = this.sanexpDao.find(sanexp);
		actualizarMisGestiones.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		// REPRESENTANTE SANCIONADO
		Saninterv sancionadoRepr = this.sanintervDao.dameInterviniente(santramexp.getExpedien().getExcodigo(),
				Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

		if (sancionadoRepr != null) {
			DatosPersona datosSancionadoRepr = this.sanintervService.cargarDatosPersona(sancionadoRepr);
			// Le ponemos el idioma del titular
			datosSancionadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));
			actualizarMisGestiones.setRepresentante(datosSancionadoRepr);
		}
		// --------------------------------------------------------------------------

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(santramexp.getExpedien().damecodCompletoPlatea());

		actualizarMisGestiones.setEjercicio(santramexp.getExpedien().getExnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_ACUERDOINCOACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_ACUERDOINCOACION_EU);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(santramexp.getTrresofecha());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RESOLUCION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(santramexp.getTrresofecha());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RECURSOALZADA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RECURSOALZADA_EU);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_ORDENCONSEJERO_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_ORDENCONSEJERO_EU);
			Decision decision = new Decision();
			decision.setDecodigo(santramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(santramexp.getTrresofecha());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION.equals(santramexp.getTrcodigo())) {
			// Primero la resolucion u orden del consejero
			Santramexp tramiteRelacionado = null;
			if (santramexp.getTrtridrel() != null) {
				tramiteRelacionado = this.santramexpDao.find(new Santramexp(santramexp.getTrtridrel()));
				if (tramiteRelacionado != null
						&& Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())) {
					actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
					if (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tramiteRelacionado.getTrcodigo())) {
						actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RESOLUCION_ES);
						actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
						Decision decision = new Decision();
						decision.setDecodigo(tramiteRelacionado.getTrresotipo());
						decision = this.decisionDao.find(decision);
						actualizarMisGestiones.setDecisionCas(decision.getDenombre());
						actualizarMisGestiones.setDecisionEus(decision.getDenombree());
						Calendar decisionTimestamp = Calendar.getInstance();
						decisionTimestamp.setTime(tramiteRelacionado.getTrresofecha());
						actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
						if (Y41bUtils.interactuarConDokusi()) {
							this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
						}
						tramiteRelacionado.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
						this.santramexpDao.updateProceedingsIdPlatea(tramiteRelacionado);
					} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
							.equals(tramiteRelacionado.getTrcodigo())) {
						actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_ORDENCONSEJERO_ES);
						actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_ORDENCONSEJERO_EU);
						Decision decision = new Decision();
						decision.setDecodigo(tramiteRelacionado.getTrresotipo());
						decision = this.decisionDao.find(decision);
						actualizarMisGestiones.setDecisionCas(decision.getDenombre());
						actualizarMisGestiones.setDecisionEus(decision.getDenombree());
						Calendar decisionTimestamp = Calendar.getInstance();
						decisionTimestamp.setTime(tramiteRelacionado.getTrresofecha());
						actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
						if (Y41bUtils.interactuarConDokusi()) {
							this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
						}
						tramiteRelacionado.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
						this.santramexpDao.updateProceedingsIdPlatea(tramiteRelacionado);
					}
				}
			}

			// Segundo la liquidacion
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}

			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_LIQUIDACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_LIQUIDACION_EU);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO.equals(santramexp.getTrcodigo())) {
			if (santramexp != null && !Y41bUtils.esNullOCadenaVacia(santramexp.getTrproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(santramexp.getTrproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(santramexpDao.getNewPKProceedingsPlatea().toString());
			}
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RECURSOEXTRAORDINARIO_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RECURSOEXTRAORDINARIO_EU);
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			}
			santramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.santramexpDao.updateProceedingsIdPlatea(santramexp);
		}

	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param fecha
	 *            Date
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteRecepcionSolicitudReduccion(Santramexp santramexp, Date fecha) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
			santramexpNuevo.setTrfecini(santramexp.getTrfecini());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTrfecsolred(fecha);

			BigDecimal importeInicial = null;
			// Buscamos la propuesta y si no hay el acuerdo de incoacion
			// Aunque no se muestre en pantalla, se necesita para sugerir la
			// liquidacion
			Santramexp santramexpAux = new Santramexp();
			santramexpAux.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
			Pagination paginacion = new Pagination();
			paginacion.setSord("DESC");
			paginacion.setSort("TRID");
			List<Santramexp> lista = this.santramexpDao.findAll(santramexpAux, paginacion);
			if (lista != null && lista.size() > 0) {
				importeInicial = lista.get(0).getTrimporteinicial();
			} else {
				santramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
				lista = this.santramexpDao.findAll(santramexpAux, paginacion);
				if (lista != null && lista.size() > 0) {
					importeInicial = lista.get(0).getTrimporteinicial();
				}
			}
			santramexpNuevo.setTrimporteinicial(importeInicial);
			this.add(santramexpNuevo);

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString(),
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_REDUCCION);
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private void sugiereTramiteRecepcionRequerimientoAcreditacion(Santramexp santramexp, TramiteComun tramiteComun)
			throws Exception {

		Expedien expedien = new Expedien();
		expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
		expedien = this.expedienDao.find(expedien);

		List<Sandoctemp> documentosAportados = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		santramexp.setSandoctemps(documentosAportados);
		for (Sandoctemp sandoctemp : documentosAportados) {
			if (Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ACREDITACION_REPRESENTACION
					.equals(sandoctemp.getU5tipodocumento())) {
				if (Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO.equals(sandoctemp.getU5origen())) {
					santramexp.setTipoDestOrigen(
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);
				} else {
					santramexp.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
				}
			}
		}

		Santramexp santramexpNuevo = new Santramexp();
		santramexpNuevo.setExpedien(expedien);
		santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
		santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECALTA");
		pagination.setSord("DESC");
		List<Santramexp> lrecepcionRequerimientoAcreditacion = this.santramexpDao.findAll(santramexpNuevo, pagination);
		santramexpNuevo = null;
		if (lrecepcionRequerimientoAcreditacion != null && lrecepcionRequerimientoAcreditacion.size() > 0) {
			santramexpNuevo = lrecepcionRequerimientoAcreditacion.get(0);
		}

		if (santramexpNuevo != null) {
			// 1.2 Hay que relacionar los documentos
			// Sandoctemp sandoctemp = new Sandoctemp();
			// sandoctemp.setSantramexp(santramexpNuevo);
			// sandoctemp.setU5codocumento(santramexpNuevo.getU5codocumento());
			// this.sandoctempDao.add(sandoctemp);

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString(),
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ACREDITACION_REPRESENTACION);
		} else {

			santramexpNuevo = new Santramexp();
			// santramexpNuevo.setTrid(Y41bUIDGenerator.getInstance().generateId(
			// Y41bConstantes.PK_SIZE));
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo
					.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
			santramexpNuevo.setTrfecini(santramexp.getTrfecini());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setFase(santramexp.getFase());
			santramexpNuevo.setTipoDestOrigen(santramexp.getTipoDestOrigen());

			// Se inserta el tramite
			this.santramexpDao.add(santramexpNuevo);

			// 1.2 Hay que relacionar los documentos
			// Sandoctemp sandoctemp = new Sandoctemp();
			// sandoctemp.setSantramexp(santramexpNuevo);
			// sandoctemp.setU5codocumento(santramexpNuevo.getU5codocumento());
			// this.sandoctempDao.add(sandoctemp);

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString(),
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ACREDITACION_REPRESENTACION);
		}
		this.calcularEstadoTramiteGenerado(santramexpNuevo);
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANRecepcionSolicitudReduccion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANRecepcionSolicitudReduccion
	 */
	public TramiteSANRecepcionSolicitudReduccion findTramiteSANRecepcionSolicitudReduccion(
			TramiteSANRecepcionSolicitudReduccion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANRecepcionSolicitudReduccion tramiteAux = new TramiteSANRecepcionSolicitudReduccion();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */

			tramiteAux.setFechaSolicitud(santramexp.getTrfecsolred());
			tramiteAux.setProntoPago(santramexp.getTrprontopago());
			tramiteAux.setReconocimiento(santramexp.getTrreconocimiento());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			if (santramexp.getTruaidinterv() != null) {
				tramiteAux.setInterviniente(new Saninterv(santramexp.getTruaidinterv()));
			}
			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionSolicitudReduccion(TramiteSANRecepcionSolicitudReduccion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		if (tramite.getInterviniente() != null) {
			santramexp.setTruaidinterv(tramite.getInterviniente().getUaidinterv());
		}
		santramexp.setTrfecsolred(tramite.getFechaSolicitud());
		santramexp.setTrprontopago(tramite.getProntoPago());
		santramexp.setTrreconocimiento(tramite.getReconocimiento());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		if (tramitar) {
			// Debe haber al menos un documento
			List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			if (Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago())) {
				this.sugiereTramiteLiquidacionAutomaticamente(santramexp);
			}

			this.actualizaBandeja(santramexp);
			this.actualizaUltimoTramiteEnSanExp(santramexp);
			this.actualizaExpedienteTrasTramitar(santramexp);

		} else {
			this.actualizaBandeja(santramexp);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANPago
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANPago
	 */
	public TramiteSANPago findTramitePago(TramiteSANPago tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);

			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANPago tramiteAux = new TramiteSANPago();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */
			tramiteAux.setFechaPago(santramexp.getTrresofecha());
			tramiteAux.setImporte(santramexp.getTrresoimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(santramexp.getTrresoimporte().doubleValue()));

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteSANPAgo
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramitePago(TramiteSANPago tramite, TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrresofecha(tramite.getFechaPago());
		santramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporte()) ? null
				: new BigDecimal(tramite.getImporte().replace('\u002c', '\u002e')));

		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_ALTA.equals(modoEditar)) {
			this.setSantramexp(santramexp);
		} else if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			this.updateSantramexp(santramexp);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma
		boolean isDocPendienteFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Sandoctemp documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getU5estadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getU5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}
		if (tramitar) {
			// Debe haber al menos un documento
			tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);

				this.actualizaExpedienteTrasTramitar(santramexp);
			}
		} else {
			if (isDocPendienteFirma) {
				this.actualizaBandeja(santramexp);
				this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, Y41bConstantes.FASE_RESOLUCION_SANCION,
						Y41bConstantes.TRAMITE_SANCIONES_PAGO);

			} else {
				this.actualizaBandeja(santramexp);
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
			}
		}

		this.eliminarDocumentosDokusi(listSandoctempEliminados);

		return santramexp;

	}

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 * @param remesaEmitida
	 * @param envio
	 * @param fechaSituacion
	 * @param situacionCorreos
	 * @param envcestado
	 * @param documentoZipByte
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoZipByte, String filename) {

		// "Salir si no est respondido por Correos"
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)
				&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
			return;
		}

		TramiteComun tramiteComun = null;
		TramiteAcuseRecibo tramiteAcuseRecibo = null;

		if (envio.getIdTramiteAcuseRelacionado() != null) {
			try {
				// Buscar el trmite de Acuse relacionado con el envio
				tramiteAcuseRecibo = new TramiteAcuseRecibo();
				tramiteAcuseRecibo.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				tramiteAcuseRecibo = this.findTramiteAcuseRecibo(tramiteAcuseRecibo, censoMonitor);

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(envio.getHdcodigo());
				tramiteComun.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(remesaEmitida.getRmtipoproc());
				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				// "Crear el documento hecho del PEE para asociar al tramite,
				// siempre y cuando el envio no haya dado error"
				// " El unico error que se ha podido dar es que no exista
				// documento PEE; ya que el resto dan excepcin previa y no
				// entran por aqui"
				Sandoctemp docHechoPEE_Aux = null;
				if (!Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
					docHechoPEE_Aux = new Sandoctemp();
					docHechoPEE_Aux.setU5codocumento(this.sandoctempService.getNewPK().toString());

					docHechoPEE_Aux.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS);
					docHechoPEE_Aux.setU5tipodocumento(Y41bConstantes.TIPO_DOC_SAN_ACUSE);

					Blob blob = new SerialBlob(documentoZipByte);
					docHechoPEE_Aux.setU5datafile(blob);
					docHechoPEE_Aux.setU5conttype(Y41bConstantes.CONTENT_TYPE_PDF);
					docHechoPEE_Aux.setU5nofile(filename);
					docHechoPEE_Aux.setU5tedesfile(Y41bConstantes.PRUEBA_ENTREGA_ENVIO);
					docHechoPEE_Aux.setU5sizefile((int) documentoZipByte.length);

					Expedien expAux = new Expedien();
					expAux.setExcodigo(tramiteComun.getIdExpediente());
					docHechoPEE_Aux.setExpedien(expAux);

					Santramexp tramiteAux = new Santramexp();
					tramiteAux.setTrid(tramiteComun.getIdTramite());
					docHechoPEE_Aux.setSantramexp(tramiteAux);

					docHechoPEE_Aux.setU5fecha(new Date());
				}

				// "Actualizar tramite de acuse de recibo asociado al envio"
				Date fecha;
				fecha = Y41bUtils.convertFromSQLDateToJAVADate(
						Y41bUtils.formatearStringToDateFormato(fechaSituacion, Y41bConstantes.FORMATO_FECHA_ES));
				tramiteAcuseRecibo.setFechaacuse(fecha);

				if (situacionCorreos != null) {
					tramiteAcuseRecibo.setSituacionacuse(situacionCorreos);
				}

				// "Si el trmite ya estaba TRAMITADO, entonces SOLO se aade el
				// documeto PEE al trmite"
				if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteAcuseRecibo.getEstadoTramite())) {

					// "Solo si ha sido respondido por Correos"
					if (Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)) {

						this.sandoctempDao.add(docHechoPEE_Aux);
						this.sandoctempDao.insertSanDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE_Aux.getU5codocumento(), Y41bConstantes.TIPO_PROC_SANCIONES);
					}
					// "ELSE: Si el envo viene erroneo; entonces NO se hace
					// nada, se queda a la espera de que venga el documento PEE"

				} else {

					// "Si la situacin devuelta por Correos es convertida a
					// ACUSE ACEPTADO, entonces hay que tramitar el trmite de
					// Acuese e informar al responsable."
					// "Aunque solo en el caso de que NO se haya producido un
					// error (el de no existe PEE, ya que el resto lanzan
					// excepcin y no pasan por aqu)"
					String idioma = LocaleContextHolder.getLocale().getLanguage();
					if (situacionCorreos != null
							&& situacionCorreos.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
							&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {

						// "Aceptado y NO erroneo >>> Tramita acuse y envia
						// email al responsable."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, true,
								docHechoPEE_Aux);
						this.envioMailAcuseRecibo(tramiteComun, fecha);

					} else {
						// "Guarda acuse."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, false,
								docHechoPEE_Aux);
					}
				}
			} catch (ParseException e) {
				logger.error("error ParseException", e);
				throw new Y41bUDAException("error.generico", true, e);
			} catch (Exception e) {
				logger.error("error genrico", e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * Envio mail acuse de recibo aceptado
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param fecha
	 *            Date
	 */
	private void envioMailAcuseRecibo(TramiteComun tramiteComun, Date fecha) {
		// Enviar mail
		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());

		expedien = this.expedienService.find(expedien);

		CensoMonitor responsableExpediente = new CensoMonitor();
		responsableExpediente.setMocodigo(expedien.getExcoit());

		if (responsableExpediente.getMocodigo() != null && !responsableExpediente.getMocodigo().equals("")) {
			responsableExpediente = this.censoMonitorDao.find(responsableExpediente);
		}

		String from = "";
		if (responsableExpediente != null && responsableExpediente.getOrganismo() != null) {
			from = responsableExpediente.getOrganismo().getEmail();
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.CASTELLANO)));

		asunto.append(" ").append(expedien.getCodCompletoConPrefijo()).append(" / ");

		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(expedien.getCodCompletoConPrefijo());

		StringBuffer texto = new StringBuffer(Y41bConstantes.CIEN);
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append("</B>");
		texto.append(" ").append(expedien.getCodCompletoConPrefijo()).append("<BR>");
		texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
				new Locale(Y41bConstantes.CASTELLANO))).append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.CASTELLANO)).append("<BR><BR>");

		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(expedien.getCodCompletoConPrefijo()).append("<BR>");
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.textofecha", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.EUSKERA)).append("<BR><BR>");

		String destinatariosMail = responsableExpediente.getMocoem();

		ArrayList attachments = new ArrayList();

		// Envio mail
		Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatariosMail, "", attachments);
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return String
	 */
	private String calcularDestinatarioComunicacionNotificacion(Santramexp santramexp) {
		// Calcular el destinatario
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {
			Expedien expedien = new Expedien();
			expedien = (santramexp.getExpedien());
			expedien = this.expedienDao.find(expedien);

			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(santramexp.getTruaidinterv());
			saninterv = this.sanintervDao.find(saninterv);

			if (saninterv != null && saninterv.getUatipointerv() != null
					&& saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) {
				if (expedien != null && expedien.getSanexp() != null
						&& expedien.getSanexp().getExdestnotifsancionado() != null
						&& expedien.getSanexp().getExdestnotifsancionado()
								.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

					// buscar el representante
					Saninterv sanintervAux = new Saninterv();
					List<Saninterv> representantes = null;
					representantes = this.sanintervDao.findAllByTipo(expedien,
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
					if (representantes != null && representantes.size() > 0) {
						sanintervAux = representantes.get(0);
						String idInterviniente = new String(sanintervAux.getUaidinterv() + "");
						return idInterviniente;

					} else if (Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION
							.equals(santramexp.getTrcodigorel())) {
						representantes = this.sanintervDao.findAllByTipo(expedien,
								Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);
						if (representantes != null && representantes.size() > 0) {
							sanintervAux = representantes.get(0);
						}
						String idInterviniente = "";
						if (sanintervAux.getUaidinterv() != null) {
							idInterviniente = new String(sanintervAux.getUaidinterv() + "");
						}
						if (sanintervAux != null && Y41bUtils.isFilled(idInterviniente)) {
							return idInterviniente;
						} else {
							// Si no existe se pone como destinatario el
							// titular
							return santramexp.getTruaidinterv() + "";
						}
					} else {
						return santramexp.getTruaidinterv() + "";
					}

				} else {
					return santramexp.getTruaidinterv() + "";
				}
			} else {
				return santramexp.getTruaidinterv() + "";
			}

		} else {
			return santramexp.getTruaidinterv() + "";
		}
	}

	/*
	 * # INICIO # ADAPTACIONES LEY 39 private void
	 * tratarDocumentosSolicitudMisGestiones(Documento docDokusi, Expedien
	 * expedien) { if
	 * (Y41bConstantes.TIPO_DOC_SOLICITUD.equalsIgnoreCase(docDokusi
	 * .getTipoDocumental())) { if
	 * (Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_ES
	 * .equalsIgnoreCase(docDokusi.getNombre()) ||
	 * Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_EU
	 * .equalsIgnoreCase(docDokusi.getNombre())) {
	 * this.tratarDocumentoDatosAviso(docDokusi, expedien); } else if
	 * (Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_ES
	 * .equalsIgnoreCase(docDokusi.getNombre()) ||
	 * Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_EU
	 * .equalsIgnoreCase(docDokusi.getNombre())) {
	 * this.tratarDocumentoDatosNotificacion(docDokusi, expedien); } } }
	 * 
	 * private void tratarDocumentoDatosAviso(Documento docDokusi, Expedien
	 * expedien) { String fichero = docDokusi.getBytes(); String mail =
	 * Y41bUtils.localizarMailEnXML(fichero); String telefono =
	 * Y41bUtils.localizarTelefonoEnXML(fichero); // guardar los datos de mail y
	 * telefono en interviniente // correspondiente y en platea Saninterv
	 * sanintervRep = null; Saninterv saninterv =
	 * sanintervDao.dameSancionado(expedien .getExcodigo()); List<Saninterv>
	 * sanintervRepl = sanintervDao.findAllByTipo(expedien,
	 * Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO); if
	 * (sanintervRepl != null && sanintervRepl.size() > 0) { sanintervRep =
	 * sanintervRepl.get(0); }
	 * 
	 * if (sanintervRep != null) {
	 * sanintervRep.setUanrtel(Y41bUtils.idiomaOneChar(telefono));
	 * sanintervRep.setUacoem(Y41bUtils.idiomaOneChar(mail));
	 * sanintervDao.update(sanintervRep); } else if (saninterv != null) {
	 * saninterv.setUanrtel(Y41bUtils.idiomaOneChar(telefono));
	 * saninterv.setUacoem(Y41bUtils.idiomaOneChar(mail));
	 * sanintervDao.update(saninterv); }
	 * 
	 * if (Y41bUtils.interactuarConDokusi()) { if (Y41bConstantes.VALOR_SI
	 * .equals(expedien.getSanexp().getPlatea())) { if (saninterv != null &&
	 * saninterv.getUanif() != null) { CensoMonitor censoMonitor = new
	 * CensoMonitor(); censoMonitor.setMocodigo(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setModni(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setMonombre(Y41bConstantes.COD_APLICACION);
	 * sanexpService.actualizarParticipantPlatea(expedien, saninterv,
	 * censoMonitor, false); } } } }
	 * 
	 * private void tratarDocumentoDatosNotificacion(Documento docDokusi,
	 * Expedien expedien) { String fichero = docDokusi.getBytes(); String idioma
	 * = Y41bUtils.localizarIdiomaEnXML(fichero); // guardar el dato de idioma
	 * en interviniente correspondiente y en // platea Saninterv saninterv =
	 * sanintervDao.dameSancionado(expedien .getExcodigo()); if (saninterv !=
	 * null) { saninterv.setUaidioma(Y41bUtils.idiomaOneChar(idioma));
	 * sanintervDao.update(saninterv); if (Y41bUtils.interactuarConDokusi()) {
	 * if (Y41bConstantes.VALOR_SI.equals(expedien.getSanexp() .getPlatea())) {
	 * if (saninterv != null && saninterv.getUanif() != null) { CensoMonitor
	 * censoMonitor = new CensoMonitor();
	 * censoMonitor.setMocodigo(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setModni(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setMonombre(Y41bConstantes.COD_APLICACION);
	 * sanexpService.actualizarParticipantPlatea(expedien, saninterv,
	 * censoMonitor, false); } } } } } # FIN #
	 */

	/**
	 * Generar Tramite Automatico de Recepcion Informacion desde Requerimiento
	 * de Acreditacion Representacion
	 * 
	 * @param RecepcionRequerimientoAcreditacionRepresentacion
	 *            Santramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Santramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	private Santramexp sugiereTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			Santramexp requerimientoAcreditacionRepresentacion, Saninterv saninterv) throws Exception {

		Santramexp santramexp = new Santramexp();

		santramexp.setExpedien(requerimientoAcreditacionRepresentacion.getExpedien());
		santramexp.setTruaidinterv(saninterv.getUaidinterv());
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
		santramexp.setTrcodigorel(requerimientoAcreditacionRepresentacion.getTrcodigo());
		santramexp.setTrtridrel(requerimientoAcreditacionRepresentacion.getTrid());
		santramexp.setFase(requerimientoAcreditacionRepresentacion.getFase());
		santramexp.setCensoMonitor(requerimientoAcreditacionRepresentacion.getCensoMonitorEj());

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		santramexp.setTrfecini(todayWithZeroTime);

		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se fija el origen en funcin del requerimiento
		santramexp.setTipoDestOrigen(requerimientoAcreditacionRepresentacion.getTipoDestOrigen());

		// Se inserta el tramite
		this.santramexpDao.add(santramexp);

		return santramexp;
	}

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacion de
	 * Representacion
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Santramexp
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp sugiereTramiteRequerimientoAcreditacionRepresentacion(Saninterv saninterv) throws Exception {

		Expedien expedien = new Expedien();
		expedien.setExcodigo(saninterv.getExpedien().getExcodigo());
		expedien = this.expedienDao.find(expedien);

		Santramexp santramexpNuevo = new Santramexp();

		santramexpNuevo.setExpedien(expedien);
		santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOACREDITACIONREPRESENTACION);
		santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
		santramexpNuevo.setCensoMonitor(new CensoMonitor(expedien.getSanexp().getExmocodigo(), null));
		santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		santramexpNuevo.setTruaidinterv(saninterv.getUaidinterv());
		santramexpNuevo.setFase(expedien.getSanexp().getFase());

		santramexpNuevo.setTrid(this.getNewPK().toString());

		santramexpNuevo.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

		// Se inserta el tramite
		this.santramexpDao.add(santramexpNuevo);

		return santramexpNuevo;
	}

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni) {

		return this.santramexpDao.findSumSizeBlobNotifiComuni(filterNotifiComuni);
	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		String resultado = null;
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		} else {
			String asuntodocumental = tokCadena.nextToken();
			if (asuntodocumental != null && !asuntodocumental.equals("0")) {
				tipo = roleId;
			}
		}
		Santipdoc santipdoc = new Santipdoc();
		santipdoc.setIdTipodoc(tipo);
		List<Santipdoc> listaSantipdoc = this.santipdocDao.findAll(santipdoc, null);
		if (listaSantipdoc == null || (listaSantipdoc != null && listaSantipdoc.size() != 1)) {
			resultado = Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_APORTACIONDOCUMENTACION;
		} else {
			resultado = ((Santipdoc) listaSantipdoc.get(0)).getTdid();
		}
		return resultado;
	}

	// EVOLUTIVO 135083 2.8
	/**
	 * 
	 * Devuelve si tiene o no notificacion con acuse
	 * 
	 * @param excodigo
	 *            String
	 * @return Boolean
	 */
	public boolean existeNotificacionConAcuse(String excodigo) {

		// Miramos si hay algun documento pendiente de firma o denegada
		boolean tiene = false;

		Expedien expedien = this.expedienDao.find(new Expedien(excodigo));
		Date fecha_tramiteResolucion = null;
		fecha_tramiteResolucion = expedien.getExfenore();
		if (fecha_tramiteResolucion != null) {
			tiene = true;
		}
		// Miramos si hay algun documento pendiente de firma
		return tiene;
	}

	// EVOLUTIVO 135083 2.8

	// EVOLUTIVO 0135083 2.4

	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRequerimientoInformacion(TramiteRequerimientoInformacion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// if (tramite.getInterviniente() != null) {
		// santramexp.setTruaidinterv(tramite.getInterviniente()
		// .getUaidinterv());
		// }
		// santramexp.setTrfecsolred(tramite.getFechaSolicitud());
		// santramexp.setTrprontopago(tramite.getProntoPago());
		// santramexp.setTrreconocimiento(tramite.getReconocimiento());

		santramexp.setTrresumenalegaciones(Y41bUtils.stringToClob(tramite.getDocumentacionrequerida()));
		santramexp.setTrdocreqeus(Y41bUtils.stringToClob(tramite.getDocumentacionrequeridae()));
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				// if (Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago()))
				// {
				// this.sugiereTramiteLiquidacionAutomaticamente(santramexp);
				// }

				this.sugiereTramiteNotificacionAutomaticamente(santramexp, null);
				this.sugiereTramiteRecepcionRequerimientoInformacion(santramexp);
				this.actualizaBandeja(santramexp);
				this.actualizaUltimoTramiteEnSanExp(santramexp);
				this.actualizaExpedienteTrasTramitar(santramexp);
			}
		} else {
			this.guardarTramite(santramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionRequerimientoInformacion(TramiteRecepcionRequerimientoInformacion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// if (tramite.getInterviniente() != null) {
		// santramexp.setTruaidinterv(tramite.getInterviniente()
		// .getUaidinterv());
		// }
		// santramexp.setTrfecsolred(tramite.getFechaSolicitud());
		// santramexp.setTrprontopago(tramite.getProntoPago());
		// santramexp.setTrreconocimiento(tramite.getReconocimiento());
		santramexp.setTrresumenalegaciones(Y41bUtils.stringToClob(tramite.getResumenAlegaciones()));
		santramexp.setTrrespuesta(tramite.getRespuesta());

		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		if (tramitar) {
			// Debe haber al menos un documento
			List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			// if (Y41bConstantes.VALOR_SI.equals(tramite.getProntoPago())) {
			// this.sugiereTramiteLiquidacionAutomaticamente(santramexp);
			// }

			this.actualizaBandeja(santramexp);
			this.actualizaUltimoTramiteEnSanExp(santramexp);
			this.actualizaExpedienteTrasTramitar(santramexp);

		} else {
			this.actualizaBandeja(santramexp);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;
	}

	public TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramite, CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteRecepcionRequerimientoInformacion tramiteAux = new TramiteRecepcionRequerimientoInformacion();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setOrigen(santramexp.getTipoDestOrigen());
		tramiteAux.setRespuesta(santramexp.getTrrespuesta());
		tramiteAux.setResumenAlegaciones(Y41bUtils.clobToString(santramexp.getTrresumenalegaciones()));

		if (this.tratamientoSeguridad(santramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	public TramiteRequerimientoInformacion findTramiteRequerimientoInformacion(TramiteRequerimientoInformacion tramite,
			CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Santramexp santramexp = new Santramexp();
		String trid = new String(tramite.getIdTramite());
		santramexp.setTrid(trid);
		santramexp = this.santramexpDao.find(santramexp);

		TramiteRequerimientoInformacion tramiteAux = new TramiteRequerimientoInformacion();
		tramiteAux.setIdTramite(santramexp.getTrid().toString());
		tramiteAux.setFechaInicio(santramexp.getTrfecini());
		tramiteAux.setFechaFin(santramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
			instructorAsignado = santramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = santramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(santramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setDocumentacionrequerida(Y41bUtils.clobToString(santramexp.getTrresumenalegaciones()));
		tramiteAux.setDocumentacionrequeridae(Y41bUtils.clobToString(santramexp.getTrdocreqeus()));

		if (this.tratamientoSeguridad(santramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	// EVOLUTIVO 0135083 2.5
	private void incorporaDocTramiteRecepcionReqInd(Santramexp santramexp) {
		// TODO Auto-generated method stub
		// Documentos
		Santramexp recepcionRequerimientoInformacion = new Santramexp();
		recepcionRequerimientoInformacion
				.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION);
		recepcionRequerimientoInformacion.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
		Pagination pagination = new Pagination();
		pagination.setSidx("TRFECALTA");
		pagination.setSord("DESC");
		List<Santramexp> lrecepcionRequerimientoInformacion = this.santramexpDao
				.findAll(recepcionRequerimientoInformacion, pagination);
		boolean hayTramite = false;
		if (lrecepcionRequerimientoInformacion != null && lrecepcionRequerimientoInformacion.size() > 0) {
			for (int j = 0; j < lrecepcionRequerimientoInformacion.size(); j++) {
				recepcionRequerimientoInformacion = lrecepcionRequerimientoInformacion.get(j);
				if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionRequerimientoInformacion.getTrestado())) {
					hayTramite = true;
					break;
				}
			}
		}
		if (hayTramite) {

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					recepcionRequerimientoInformacion.getTrid().toString(), Y41bConstantes.TIPO_DOC_SAN_REQ_ENTRADA);

		}
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramiteAcuse
	 *            the tramite acuse
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void sugiereTramiteRecepcionRequerimientoInformacion(Santramexp santramexp) throws Exception {

		try {

			// Documentos
			Santramexp recepcionRequerimientoInformacion = new Santramexp();
			recepcionRequerimientoInformacion
					.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION);
			recepcionRequerimientoInformacion.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECALTA");
			pagination.setSord("DESC");
			// List<Santramexp> lrecepcionRequerimientoInformacion =
			// this.santramexpDao
			// .findAll(recepcionRequerimientoInformacion, pagination);
			// boolean hayTramite = false;
			// if (lrecepcionRequerimientoInformacion != null
			// && lrecepcionRequerimientoInformacion.size() > 0) {
			// for (int j = 0; j < lrecepcionRequerimientoInformacion.size();
			// j++) {
			// recepcionRequerimientoInformacion =
			// lrecepcionRequerimientoInformacion
			// .get(j);
			// if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
			// .equals(recepcionRequerimientoInformacion
			// .getTrestado())) {
			// hayTramite = true;
			// break;
			// }
			// }
			// }
			// if (!hayTramite) {
			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			recepcionRequerimientoInformacion = new Santramexp();
			recepcionRequerimientoInformacion.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			recepcionRequerimientoInformacion
					.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION);
			recepcionRequerimientoInformacion.setTrfecini(santramexp.getTrfecini());
			recepcionRequerimientoInformacion.setCensoMonitor(santramexp.getCensoMonitorEj());
			recepcionRequerimientoInformacion.setTrcodigorel(santramexp.getTrcodigo());
			recepcionRequerimientoInformacion.setTrtridrel(santramexp.getTrid());
			recepcionRequerimientoInformacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			recepcionRequerimientoInformacion.setTruaidinterv(santramexp.getTruaidinterv());
			recepcionRequerimientoInformacion.setFase(santramexp.getFase());
			this.add(recepcionRequerimientoInformacion);

			// }

		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramiteAcuse
	 *            Santramexp
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(Santramexp tramiteAcuse, Documento justificanteAcuse) {
		// TODO Auto-generated method stub

		DocumentoHecho docHechoJustificanteAcuse = new DocumentoHecho();
		docHechoJustificanteAcuse.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

		docHechoJustificanteAcuse.setQ5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);
		docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_SAN_ACUSE);
		docHechoJustificanteAcuse.setQ5iddocumentum(justificanteAcuse.getOidDokusi());
		docHechoJustificanteAcuse.setQ5contenttypefile(justificanteAcuse.getContentType());
		docHechoJustificanteAcuse.setQ5nofile(justificanteAcuse.getNombre());
		docHechoJustificanteAcuse.setQ5tedesfile(Y41bConstantes.JUSTIFICANTE_NOTIFICACION_ELECTRONICA);
		docHechoJustificanteAcuse.setQ5sizefile((int) justificanteAcuse.getLength());
		docHechoJustificanteAcuse.setQ5hdcodigo(tramiteAcuse.getExpedien().getExcodigo());
		docHechoJustificanteAcuse.setQ5tramite(tramiteAcuse.getTrid());
		docHechoJustificanteAcuse.setQ5fecha(new Date());

		this.documentoHechoDao.add(docHechoJustificanteAcuse);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		// documentoTramiteHecho.setEhcodigo(tramitehechoAcuse.getEhcodigo());
		documentoTramiteHecho.setEhcodigo(tramiteAcuse.getTrid());

		documentoTramiteHecho.setCodocumento(docHechoJustificanteAcuse.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

	}

	private List<Pagos> obtenerPagosViaApremioExpediente(String excodigo) {
		Pagos pagos = new Pagos();
		pagos.setSgidexpediente(excodigo);
		pagos.setSgviaapremio(Y41bConstantes.VALOR_SI);
		return this.pagosDao.findAll(pagos, null);
	}

	private boolean expedienteTienePagosViaApremio(String excodigo) {
		List<Pagos> listaPagos = this.obtenerPagosViaApremioExpediente(excodigo);
		return listaPagos != null && !listaPagos.isEmpty();
	}

	/**
	 * Generar Tramite Generico de reapertura de expediente
	 * 
	 * @param expedien
	 *            Expedien
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	public void generarTramiteGenericoViaApremio(Expedien expedien, CensoMonitor censoMonitor, String comentario,
			String excluir) throws Exception {

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		Santramexp santramexp = new Santramexp();
		santramexp.setTrfecini(todayWithZeroTime);
		santramexp.setTrfecfin(todayWithZeroTime);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_GENERICO);
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(censoMonitor);
		santramexp.setCensoMonitorEj(censoMonitor);
		santramexp.setTrid(this.getNewPK().toString());
		if (excluir.equals(Y41bConstantes.VALOR_SI)) {
			santramexp.setTrnomtrames(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_EXCLUIR);
		} else {
			santramexp.setTrnomtrames(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_INCLUIR);
		}

		santramexp.setTrobserves(Y41bUtils.stringToClob(comentario));

		this.santramexpDao.add(santramexp);

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANRecepcionRecursoAlzada
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANRecepcionRecursoAlzada
	 */
	public TramiteSANRecepcionRecursoExtraordinario findTramiteSANRecepcionRecursoExtraordinario(
			TramiteSANRecepcionRecursoExtraordinario tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Santramexp santramexp = new Santramexp();
			String trid = new String(tramite.getIdTramite());
			santramexp.setTrid(trid);
			santramexp = this.santramexpDao.find(santramexp);

			TramiteSANRecepcionRecursoExtraordinario tramiteAux = new TramiteSANRecepcionRecursoExtraordinario();
			tramiteAux.setIdTramite(santramexp.getTrid().toString());
			tramiteAux.setFechaInicio(santramexp.getTrfecini());
			tramiteAux.setFechaFin(santramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (santramexp.getCensoMonitor() != null && !santramexp.getCensoMonitor().equals("")) {
				instructorAsignado = santramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (santramexp.getCensoMonitorEj() != null && !santramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = santramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(santramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(santramexp.getTrobserves()));

			/*
			 * PROPIO DEL TRAMITE
			 */

			tramiteAux.setFechaRecurso(santramexp.getTrfecenvio());

			if (this.tratamientoSeguridad(santramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			if (santramexp.getTruaidinterv() != null) {
				tramiteAux.setInterviniente(new Saninterv(santramexp.getTruaidinterv()));
			}
			return tramiteAux;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteRecepcionRecursoExtraordinario(TramiteSANRecepcionRecursoExtraordinario tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			santramexp = this.santramexpDao.find(santramexp);
		}

		this.actualizaFaseEnSanExpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			santramexp.setTrfecfin(tramite.getFechaFin());
			santramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Expedien expedien = new Expedien();
		expedien.setExcodigo(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setTrfecini(tramite.getFechaInicio());
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		santramexp.setFase(expedien.getSanexp().getFase());
		santramexp.setCensoMonitor(tramite.getInstructorAsignado());
		santramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		if (tramite.getInterviniente() != null) {
			santramexp.setTruaidinterv(tramite.getInterviniente().getUaidinterv());
		}
		/*
		 * PROPIO DEL TRAMITE
		 */
		santramexp.setTrfecenvio(tramite.getFechaRecurso());
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.setSantramexp(santramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Sandoctemp> listSandoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);
		boolean tieneResolucionAcusada = this.existeNotificacionConAcuse(santramexp.getExpedien().getExcodigo());

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(santramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			}

			// validamos que el expediente se haya tramitado el recurso de
			// alzada previamente
			Santramexp santramexpBuscarRecursoAlzada = new Santramexp();
			santramexpBuscarRecursoAlzada.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpBuscarRecursoAlzada.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA);
			santramexpBuscarRecursoAlzada.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			List<Santramexp> listaRecursoAlzada = this.santramexpDao.findAll(santramexpBuscarRecursoAlzada, null);
			if (listaRecursoAlzada.isEmpty()) {
				throw new Y41bUDAException("error.tramiteRecepcionRecursoExtraordinario.noExisteRecursoAlzada", true,
						null);
			}

			/* seguerimos el tramite de elaboracion informe para asesoria */
			this.sugiereTramiteElaboracionInformeAsesoriaAutomaticamente(santramexp);
			this.actualizaBandeja(santramexp);
			this.actualizaUltimoTramiteEnSanExp(santramexp);
			this.actualizaExpedienteTrasTramitar(santramexp);

			this.actualizarMisGestiones(santramexp);

		} else {
			this.actualizaBandeja(santramexp);
		}
		this.eliminarDocumentosDokusi(listSandoctempEliminados);
		return santramexp;

	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */

	private Santramexp sugiereTramiteRecursoAutomaticamenteExtraordinario(Santramexp santramexp) throws Exception {

		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(santramexp.getExpedien().getExcodigo());
			expedien = this.expedienDao.find(expedien);

			Santramexp santramexpNuevo = new Santramexp();
			santramexpNuevo.setExpedien(new Expedien(santramexp.getExpedien().getExcodigo()));
			santramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO);
			santramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
			santramexpNuevo.setCensoMonitor(santramexp.getCensoMonitorEj());
			santramexpNuevo.setTrcodigorel(santramexp.getTrcodigo());
			santramexpNuevo.setTrtridrel(santramexp.getTrid());
			santramexpNuevo.setTruaidinterv(santramexp.getTruaidinterv());
			santramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpNuevo.setFase(new Fase(Y41bConstantes.FASE_RECURSO_SANCION));
			santramexpNuevo = this.add(santramexpNuevo);

			this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(santramexp.getTrid().toString(),
					santramexpNuevo.getTrid().toString(),
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSOEXTRAORDINARIO);
			return santramexpNuevo;
		} catch (Exception e) {
			SantramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

}
