package com.ejie.y41b.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.TramiteSANAcuerdoIncoacion;
import com.ejie.y41b.model.TramiteSANAmpliacionPlazoAlegaciones;
import com.ejie.y41b.model.TramiteSANApertura;
import com.ejie.y41b.model.TramiteSANElaboracionInformeAsesoria;
import com.ejie.y41b.model.TramiteSANLiquidacion;
import com.ejie.y41b.model.TramiteSANPago;
import com.ejie.y41b.model.TramiteSANPropuestaResolucion;
import com.ejie.y41b.model.TramiteSANRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteSANRecepcionRecursoAlzada;
import com.ejie.y41b.model.TramiteSANRecepcionRecursoExtraordinario;
import com.ejie.y41b.model.TramiteSANRecepcionSolicitudReduccion;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteSANResolucion;
import com.ejie.y41b.model.TramiteSANResolucionComplementaria;
import com.ejie.y41b.model.TramiteSANResolucionRecursoPrueba;
import com.ejie.y41b.model.TramiteSANResolucionSolicitudPrueba;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;

/**
 * SantramexpService  
 * 
 *  
 */

public interface SantramexpService {

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp add(Santramexp santramexp);

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp update(Santramexp santramexp);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp find(Santramexp santramexp);

	/**
	 * Finds a List of rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Santramexp> findAll(Santramexp santramexp, Pagination pagination);

	/**
	 * Counts rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Long
	 */
	Long findAllCount(Santramexp santramexp);

	/**
	 * Finds rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Santramexp> findAllLike(Santramexp santramexp, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santramexp santramexp, Boolean startsWith);

	/**
	 * Deletes a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return
	 */
	void remove(Santramexp santramexp);

	/**
	 * Deletes multiple rows in the Santramexp table.
	 * 
	 * @param santramexpList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Santramexp> santramexpList);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor censoMonitor);

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            the id interviniente
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, String idInterviniente) throws Exception;

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param esNotificacion
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(TramiteComun tramiteComun, String idInterviniente, boolean esNotificacion)
			throws Exception;

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteAmpliacionPlazoAlegaciones(TramiteSANAmpliacionPlazoAlegaciones tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANAmpliacionPlazoAlegaciones findTramiteAmpliacionPlazoAlegaciones(
			TramiteSANAmpliacionPlazoAlegaciones tramite, CensoMonitor censoMonitor);

	/**
	 * Comprueba si dispone de los datos en 'Mi perfil' platea (1) o en el censo
	 * (2) de la aplicacin (establecimiento) o con el cif del establecimiento y
	 * tipo de procedimiento (3).
	 * 
	 * @param codigoEstablecimiento
	 *            - codigoEstablecimiento
	 * @param nifEstablecimiento
	 *            - codigoEstablecimiento
	 * @param tipoProcedimeinto
	 *            - Constante que define el tipo de procedimiento
	 * @return boolean - Si tiene mail o no
	 * @throws Exception
	 */
	public boolean tieneEmail(String codigoEstablecimiento, String nifEstablecimiento, final String tipoProcedimeinto)
			throws Exception;

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteAcuerdoIncoacion(TramiteSANAcuerdoIncoacion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANAcuerdoIncoacion findTramiteAcuerdoIncoacion(TramiteSANAcuerdoIncoacion tramite,
			CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramiteAcuse
	 *            the tramite acuse
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp sugiereTramiteAytoDesdeAcuse(Santramexp tramiteAcuse) throws Exception;

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramite
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramite
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteResolucionSolicitudPrueba(TramiteSANResolucionSolicitudPrueba tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANResolucionSolicitudPrueba findTramiteResolucionSolicitudPrueba(
			TramiteSANResolucionSolicitudPrueba tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramitePropuestaResolucion(TramiteSANPropuestaResolucion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANPropuestaResolucion findTramitePropuestaResolucion(TramiteSANPropuestaResolucion tramite,
			CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteResolucion(TramiteSANResolucion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANResolucion findTramiteResolucion(TramiteSANResolucion tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteResolucionRecursoPrueba(TramiteSANResolucionRecursoPrueba tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANResolucionRecursoPrueba findTramiteResolucionRecursoPrueba(
			TramiteSANResolucionRecursoPrueba tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteResolucionComplementaria(TramiteSANResolucionComplementaria tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Adds the tramite liquidacion.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return the santramexp
	 * @throws Exception
	 *             the exception
	 */
	public Santramexp addTramiteLiquidacion(TramiteSANLiquidacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteSANResolucionComplementaria findTramiteResolucionComplementaria(
			TramiteSANResolucionComplementaria tramite, CensoMonitor censoMonitor);

	/**
	 * Find tramite liquidacion.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return the tramite san liquidacion
	 */
	public TramiteSANLiquidacion findTramiteLiquidacion(TramiteSANLiquidacion tramite, CensoMonitor censoMonitor);

	/**
	 * Find tramite liquidacion.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return the tramite san liquidacion
	 */
	public TramiteSANLiquidacion findTramiteResolucionComplementariaLiquidacion(
			TramiteSANResolucionComplementaria tramite, CensoMonitor censoMonitor);

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);

	/*
	 * metodos de amaia nuevos
	 */

	/**
	 * Tramitar cierre.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */

	public Santramexp addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/* metodos de sara nuevos */

	/**
	 * Get a New PK Santramexp.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, CensoMonitor censoMonitor);

	/*
	 * amaia
	 */

	/**
	 * Create ejgv document for notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            the tipo procedimiento
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception;

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param electronica
	 *            the electronica
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean electronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/* sara */

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteRecepcionRecursoAlzada(TramiteSANRecepcionRecursoAlzada tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteSANRecepcionRecursoAlzada findTramiteSANRecepcionRecursoAlzada(TramiteSANRecepcionRecursoAlzada tramite,
			CensoMonitor censoMonitor);

	/**
	 * Actualiza expediente tras acusar.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tramitenotificacion
	 *            the tramitenotificacion
	 * @param fechaAcuse
	 *            the fecha acuse
	 * @throws Exception
	 *             the exception
	 */
	public void actualizaExpedienteTrasAcusar(String excodigo, Santramexp tramitenotificacion, Date fechaAcuse)
			throws Exception;

	/**
	 * getImporteResolucion.
	 * 
	 * @param idExpediente
	 *            the id expediente
	 * @param codigoTramite
	 *            the codigoTramite
	 * @return the Santramexp resolucion
	 */
	Santramexp getDatosSancion(String idExpediente, String codigoTramite);

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @throws Exception
	 *             the exception
	 */

	public void actualizaBandeja(Santramexp santramexp) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param santramexp
	 *            the santramexp
	 * @return the sanexp
	 */

	public Sanexp actualizaUltimoTramiteEnSanExp(Santramexp santramexp);

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */

	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp sugiereTramiteAcuerdoIncoaccionAutomaticamente(Santramexp santramexp) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param destinatario
	 *            the destinatario
	 * @param conDoc
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	public void sugiereTramiteComunicacionAutomaticamente(Santramexp santramexp, long destinatario, boolean conDoc)
			throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public void sugiereTramiteLiquidacionAutomaticamente(Santramexp santramexp) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */
	/*
	 * public void sugiereTramiteCierreAutomaticamente(Santramexp santramexp)
	 * throws Exception;
	 */
	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public void sugiereTramitePublicacionBopvTablonAutomaticamente(Santramexp santramexp) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @throws Exception
	 *             Exception
	 */
	public void sugiereTramiteElaboracionInformeAsesoriaAutomaticamente(Santramexp santramexp) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param destinatario
	 *            the destinatario
	 * @return the santramexp
	 * @throws Exception
	 *             Exception
	 */

	public Santramexp sugiereTramiteNotificacionAutomaticamente(Santramexp santramexp, BigDecimal destinatario)
			throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Guardar el tramite acuse de recibo.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param reintento
	 *            boolean
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */

	public TramiteAcuseRecibo addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento) throws Exception;

	/**
	 * Find tramite san apertura.
	 * 
	 * @param tramite
	 *            TramiteSANApertura
	 * @param censoMonitor
	 *            CensoMonitor the censo monitor
	 * @return the tramite san apertura
	 */
	TramiteSANApertura findTramiteSANApertura(TramiteSANApertura tramite, CensoMonitor censoMonitor);

	/**
	 * Adds the tramite elaboracion informe asesoria.
	 * 
	 * @param tramite
	 *            TramiteSANElaboracionInformeAsesoria
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param b
	 *            boolean
	 * @param modo
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteElaboracionInformeAsesoria(TramiteSANElaboracionInformeAsesoria tramite,
			TramiteComun tramiteComun, String idioma, boolean b, String modo) throws Exception;

	/**
	 * @param tramite
	 *            TramiteSANElaboracionInformeAsesoria
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteSANElaboracionInformeAsesoria
	 */
	TramiteSANElaboracionInformeAsesoria findTramiteSANElaboracionInformeAsesoria(
			TramiteSANElaboracionInformeAsesoria tramite, CensoMonitor censoMonitor);

	/**
	 * Create ejgv document for comunication.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            the tipo procedimiento
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception;

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Santramexp addTramiteComunicacionMail(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tipoDeTramite
	 *            the tipo de tramite
	 */

	public void actualizaFaseEnSanExpDesdeTramite(String excodigo, String tipoDeTramite);

	/**
	 * Adds the tramite san recepcion orden consejero.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param b
	 *            the b
	 * @param modo
	 *            the modo
	 * @return the santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteRecepcionOrdenConsejero(TramiteSANRecepcionOrdenConsejero tramite, TramiteComun tramiteComun,
			String idioma, boolean b, String modo) throws Exception;

	/**
	 * Find tramite san recepcion orden consejero.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return the tramite san recepcion orden consejero
	 */
	TramiteSANRecepcionOrdenConsejero findTramiteSANRecepcionOrdenConsejero(TramiteSANRecepcionOrdenConsejero tramite,
			CensoMonitor censoMonitor);

	/**
	 * Guardar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esComunicacionOrdinaria
	 *            the es notificacion ordinaria
	 * @param esComunicacionElectronica
	 *            the es notificacion tipo electronica
	 * @param idZipFile
	 *            the id zip file
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 * @throws SQLException
	 *             the sQL exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramite, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 * @throws SQLException
	 *             the sQL exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Adds the tramite bopv ayto.
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoBOPVAyto
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, TramiteComun tramiteComun, boolean tramitar,
			String modoBOPVAyto) throws Exception;

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             Exception
	 */
	Santramexp addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite, TramiteComun tramiteComun,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	public boolean tratarTramitacionAcuse(Santramexp santramexp) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param nuevaFase
	 *            the nueva fase
	 */

	public void actualizaFaseEnSanExpDesdeAportacion(String excodigo, String nuevaFase);

	/**
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp updateReferenciaLiquidacion(Santramexp santramexp);

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param excodigo
	 *            String
	 * @return Santramexp
	 */
	Santramexp dameUltimoTramiteEnCurso(String excodigo);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Expedien
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	public void generarTramiteAportacionDocumentacion(Expedien expedienAux,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception;

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination);

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             e
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws Exception;

	/**
	 * 
	 * @param idInterviniente
	 *            String
	 */
	public void validarSiExisteSede(String idInterviniente);

	/**
	 * validarSiExisteIncoacionTramitada
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void validarSiExisteIncoacionTramitada(String idExpediente);

	/**
	 * Dame tramite por tipo.
	 * 
	 * @param trcodigo
	 *            the trcodigo
	 * @param excodigo
	 *            String
	 * @return the santramexp
	 */
	public Santramexp dameTramitePorTipo(String trcodigo, String excodigo);

	/**
	 * Comprueba secuencia fechas tramitacion.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param tipoTramite
	 *            the tipo tramite
	 * @param fecha
	 *            the fecha
	 * @return true, if successful
	 */
	public boolean compruebaSecuenciaFechasTramitacion(String excodigo, String tipoTramite, Date fecha);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp updateRegistroSalidaPlatea(Santramexp santramexp);

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro.
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite);

	/**
	 * @param tramite
	 *            Santramexp
	 */
	void crearAvisoNotifiComuniRegistroSalida(Santramexp tramite);

	/**
	 * Reabrir expediente
	 * 
	 * @param excodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	void reabrirExpediente(String excodigo, CensoMonitor censoMonitor) throws Exception;

	/**
	 * @param excodigo
	 *            String
	 * @param mapa
	 *            Map<String, Object>
	 * @return Map<String, Object>
	 * @throws Exception
	 *             Exception
	 */
	Map<String, Object> obtenerDatosTramitesFichaSancionador(String excodigo, Map<String, Object> mapa)
			throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listDocumentos
	 *            List<Sandoctemp>
	 * @throws Exception
	 *             excepcion
	 */
	void actualizarMisGestionesNotificacion(Santramexp santramexp, List<Sandoctemp> listDocumentos) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listDocumentos
	 *            List<Sandoctemp>
	 * @throws SQLException
	 *             excepcion
	 */
	void actualizarMisGestionesComunicacion(Santramexp santramexp, List<Sandoctemp> listDocumentos) throws SQLException;

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteRecepcionSolicitudReduccion(TramiteSANRecepcionSolicitudReduccion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteSANRecepcionSolicitudReduccion findTramiteSANRecepcionSolicitudReduccion(
			TramiteSANRecepcionSolicitudReduccion tramite, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteSANPago
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteSANPago
	 */
	TramiteSANPago findTramitePago(TramiteSANPago tramite, CensoMonitor monitor);

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteSANPAgo
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramitePago(TramiteSANPago tramite, TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar) throws Exception;

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param estadoDelEnvio
	 *            String
	 * @param documentoZipByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoZipByte, String filename);

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni);

	// EVOLUTIVO 0135083 2.4

	/**
	 * addTramiteRequerimientoInformacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param b
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             excepcion
	 */
	Santramexp addTramiteRequerimientoInformacion(TramiteRequerimientoInformacion tramiteRequerimientoInformacion,
			TramiteComun tramiteComun, String idioma, boolean b, String modoEditar) throws Exception;

	/**
	 * addTramiteRecepcionRequerimientoInformacion
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param b
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Santramexp
	 * @throws Exception
	 *             excepcion
	 */
	Santramexp addTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			TramiteComun tramiteComun, String idioma, boolean b, String modoEditar) throws Exception;

	/**
	 * findTramiteRecepcionRequerimientoInformacion
	 * 
	 * @param tramiteRecepcionRequerimientoInformacion
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoInformacion
	 */
	TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimientoInformacion(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacion,
			CensoMonitor censoMonitor);

	/**
	 * findTramiteRequerimientoInformacion
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoInformacion
	 */
	TramiteRequerimientoInformacion findTramiteRequerimientoInformacion(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, CensoMonitor censoMonitor);

	// 0135083 2.3
	/**
	 * 
	 * @param expedien
	 *            Expedien
	 */
	void abrirSolicitudOficioPlatea(Expedien expedien);

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacion de
	 * Representacion
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Santramexp
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santramexp sugiereTramiteRequerimientoAcreditacionRepresentacion(Saninterv saninterv) throws Exception;

	void aportarJustificanteAcuseRecibo(Santramexp tramiteAcuse, Documento justificanteAcuse);

	public void generarTramiteGenericoViaApremio(Expedien expedien, CensoMonitor censoMonitor, String string,
			String excluir) throws Exception;

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Santramexp
	 * @throws Exception
	 *             the exception
	 */
	Santramexp addTramiteRecepcionRecursoExtraordinario(TramiteSANRecepcionRecursoExtraordinario tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteSANRecepcionRecursoExtraordinario findTramiteSANRecepcionRecursoExtraordinario(
			TramiteSANRecepcionRecursoExtraordinario tramite, CensoMonitor censoMonitor);
}
