package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SantipsanaccDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipsanacc;

/**
 * SantipsanaccServiceImpl  
 * 
 *  
 */

@Service(value = "santipsanaccService")
public class SantipsanaccServiceImpl implements SantipsanaccService {

	@Autowired()
	private SantipsanaccDao santipsanaccDao;

	/**
	 * Inserts a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Santipsanacc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipsanacc add(Santipsanacc santipsanacc) {
		return this.santipsanaccDao.add(santipsanacc);
	}

	/**
	 * Updates a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Santipsanacc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipsanacc update(Santipsanacc santipsanacc) {
		return this.santipsanaccDao.update(santipsanacc);
	}

	/**
	 * Finds a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Santipsanacc
	 */
	public Santipsanacc find(Santipsanacc santipsanacc) {
		return (Santipsanacc) this.santipsanaccDao.find(santipsanacc);
	}

	/**
	 * Finds a List of rows in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Santipsanacc> findAll(Santipsanacc santipsanacc,
			Pagination pagination) {
		return (List<Santipsanacc>) this.santipsanaccDao.findAll(santipsanacc,
				pagination);
	}

	/**
	 * Counts rows in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Long
	 */
	public Long findAllCount(Santipsanacc santipsanacc) {
		return this.santipsanaccDao.findAllCount(santipsanacc);
	}

	/**
	 * Finds rows in the Santipsanacc table using like.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Santipsanacc> findAllLike(Santipsanacc santipsanacc,
			Pagination pagination, Boolean startsWith) {
		return (List<Santipsanacc>) this.santipsanaccDao.findAllLike(
				santipsanacc, pagination, startsWith);
	}

	/**
	 * Counts rows in the Santipsanacc table using like.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santipsanacc santipsanacc, Boolean startsWith) {
		return this.santipsanaccDao.findAllLikeCount(santipsanacc, startsWith);
	}

	/**
	 * Deletes a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santipsanacc santipsanacc) {
		this.santipsanaccDao.remove(santipsanacc);
	}

	/**
	 * Deletes multiple rows in the Santipsanacc table.
	 * 
	 * @param santipsanaccList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santipsanacc> santipsanaccList) {
		for (Santipsanacc santipsanaccAux : santipsanaccList) {
			this.santipsanaccDao.remove(santipsanaccAux);
		}
	}

}
