package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SantipresulDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipresul;

/**
 * SantipresulServiceImpl  
 * 
 *  
 */

@Service(value = "santipresulService")
public class SantipresulServiceImpl implements SantipresulService {

	@Autowired()
	private SantipresulDao santipresulDao;

	/**
	 * Inserts a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Santipresul
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipresul add(Santipresul santipresul) {
		return this.santipresulDao.add(santipresul);
	}

	/**
	 * Updates a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Santipresul
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipresul update(Santipresul santipresul) {
		return this.santipresulDao.update(santipresul);
	}

	/**
	 * Finds a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Santipresul
	 */
	public Santipresul find(Santipresul santipresul) {
		return (Santipresul) this.santipresulDao.find(santipresul);
	}

	/**
	 * Finds a List of rows in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Santipresul> findAll(Santipresul santipresul,
			Pagination pagination) {
		return (List<Santipresul>) this.santipresulDao.findAll(santipresul,
				pagination);
	}

	/**
	 * Counts rows in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Long
	 */
	public Long findAllCount(Santipresul santipresul) {
		return this.santipresulDao.findAllCount(santipresul);
	}

	/**
	 * Finds rows in the Santipresul table using like.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Santipresul> findAllLike(Santipresul santipresul,
			Pagination pagination, Boolean startsWith) {
		return (List<Santipresul>) this.santipresulDao.findAllLike(santipresul,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Santipresul table using like.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santipresul santipresul, Boolean startsWith) {
		return this.santipresulDao.findAllLikeCount(santipresul, startsWith);
	}

	/**
	 * Deletes a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santipresul santipresul) {
		this.santipresulDao.remove(santipresul);
	}

	/**
	 * Deletes multiple rows in the Santipresul table.
	 * 
	 * @param santipresulList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santipresul> santipresulList) {
		for (Santipresul santipresulAux : santipresulList) {
			this.santipresulDao.remove(santipresulAux);
		}
	}

}
