package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SantipinffrecDao;
import com.ejie.y41b.model.Santipinffrec;
import com.ejie.y41b.model.SantipinffrecDetalle;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SantipinffrecServiceImpl  
 * 
 *  
 */

@Service(value = "santipinffrecService")
public class SantipinffrecServiceImpl implements SantipinffrecService {

	@Autowired()
	private SantipinffrecDao santipinffrecDao;

	/**
	 * Inserts a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipinffrec add(Santipinffrec santipinffrec) {
		try {
			return this.santipinffrecDao.add(santipinffrec);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccionfrecuente.DuplicateKeyException",
					true, e);
		}
	}

	/**
	 * Updates a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipinffrec update(Santipinffrec santipinffrec) {
		return this.santipinffrecDao.update(santipinffrec);
	}

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	public Santipinffrec find(Santipinffrec santipinffrec) {
		return (Santipinffrec) this.santipinffrecDao.find(santipinffrec);
	}

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return SantipinffrecDetalle
	 */
	public SantipinffrecDetalle findSantipinffrec(Santipinffrec santipinffrec) {
		return (SantipinffrecDetalle) this.santipinffrecDao
				.findSantipinffrec(santipinffrec);
	}

	/**
	 * Finds a List of rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Santipinffrec> findAll(Santipinffrec santipinffrec,
			Pagination pagination) {
		return (List<Santipinffrec>) this.santipinffrecDao.findAll(
				santipinffrec, pagination);
	}

	/**
	 * Counts rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Long
	 */
	public Long findAllCount(Santipinffrec santipinffrec) {
		return this.santipinffrecDao.findAllCount(santipinffrec);
	}

	/**
	 * Finds rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Santipinffrec> findAllLike(Santipinffrec santipinffrec,
			Pagination pagination, Boolean startsWith) {
		return (List<Santipinffrec>) this.santipinffrecDao.findAllLike(
				santipinffrec, pagination, startsWith);
	}

	/**
	 * Counts rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santipinffrec santipinffrec, Boolean startsWith) {
		return this.santipinffrecDao
				.findAllLikeCount(santipinffrec, startsWith);
	}

	/**
	 * Deletes a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santipinffrec santipinffrec) {
		try {
			this.santipinffrecDao.remove(santipinffrec);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccionfrecuente.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Santipinffrec table.
	 * 
	 * @param santipinffrecList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santipinffrec> santipinffrecList) {
		for (Santipinffrec santipinffrecAux : santipinffrecList) {
			this.santipinffrecDao.remove(santipinffrecAux);
		}
	}

	/**
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @param materiasAniadidas
	 *            List<String>
	 * @return List<Santipinffrec>
	 */
	public List<Santipinffrec> findAllMaterias(Santipinffrec santipinffrec,
			Pagination pagination, List<String> materiasAniadidas) {
		return (List<Santipinffrec>) this.santipinffrecDao.findAllMaterias(
				santipinffrec, pagination, materiasAniadidas);
	}

	/**
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param materiasAniadidas
	 *            List<String>
	 * @return Long
	 */
	public Long findAllMateriasCount(Santipinffrec santipinffrec,
			List<String> materiasAniadidas) {
		return this.santipinffrecDao.findAllMateriasCount(santipinffrec,
				materiasAniadidas);
	}

}
