package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Santipinffrec;
import com.ejie.y41b.model.SantipinffrecDetalle;

/**
 * SantipinffrecService  
 * 
 *  
 */

public interface SantipinffrecService {

	/**
	 * Inserts a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	Santipinffrec add(Santipinffrec santipinffrec);

	/**
	 * Updates a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	Santipinffrec update(Santipinffrec santipinffrec);

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Santipinffrec
	 */
	Santipinffrec find(Santipinffrec santipinffrec);

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return SantipinffrecDetalle
	 */
	public SantipinffrecDetalle findSantipinffrec(Santipinffrec santipinffrec);

	/**
	 * Finds a List of rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Santipinffrec> findAll(Santipinffrec santipinffrec,
			Pagination pagination);

	/**
	 * Counts rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Long
	 */
	Long findAllCount(Santipinffrec santipinffrec);

	/**
	 * Finds rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Santipinffrec> findAllLike(Santipinffrec santipinffrec,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santipinffrec santipinffrec, Boolean startsWith);

	/**
	 * Deletes a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return
	 */
	void remove(Santipinffrec santipinffrec);

	/**
	 * Deletes multiple rows in the Santipinffrec table.
	 * 
	 * @param santipinffrecList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Santipinffrec> santipinffrecList);

	/**
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param materiasAniadidas
	 *            List<String>
	 * @return Long
	 */
	Long findAllMateriasCount(Santipinffrec santipinffrec,
			List<String> materiasAniadidas);

	/**
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @param materiasAniadidas
	 *            List<String>
	 * @return List<Santipinffrec>
	 */
	List<Santipinffrec> findAllMaterias(Santipinffrec santipinffrec,
			Pagination pagination, List<String> materiasAniadidas);
}
