package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SantipestimDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipestim;

/**
 * SantipestimServiceImpl  
 * 
 *  
 */

@Service(value = "santipestimService")
public class SantipestimServiceImpl implements SantipestimService {

	@Autowired()
	private SantipestimDao santipestimDao;

	/**
	 * Inserts a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipestim add(Santipestim santipestim) {
		return this.santipestimDao.add(santipestim);
	}

	/**
	 * Updates a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipestim update(Santipestim santipestim) {
		return this.santipestimDao.update(santipestim);
	}

	/**
	 * Finds a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	public Santipestim find(Santipestim santipestim) {
		return (Santipestim) this.santipestimDao.find(santipestim);
	}

	/**
	 * Finds a List of rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param incluirDadosBaja
	 *            Boolean
	 * @return List
	 */
	public List<Santipestim> findAll(Santipestim santipestim,
			Pagination pagination, Boolean incluirDadosBaja) {
		return (List<Santipestim>) this.santipestimDao.findAll(santipestim,
				pagination, incluirDadosBaja);
	}

	/**
	 * Counts rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param mostrarDadosDeBaja
	 *            Boolean
	 * @return Long
	 */
	public Long findAllCount(Santipestim santipestim, Boolean mostrarDadosDeBaja) {
		return this.santipestimDao
				.findAllCount(santipestim, mostrarDadosDeBaja);
	}

	/**
	 * Finds rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param mostrarDadosDeBaja
	 *            Boolean
	 * @return List
	 */
	public List<Santipestim> findAllLike(Santipestim santipestim,
			Pagination pagination, Boolean startsWith,
			Boolean mostrarDadosDeBaja) {
		return (List<Santipestim>) this.santipestimDao.findAllLike(santipestim,
				pagination, startsWith, mostrarDadosDeBaja);
	}

	/**
	 * Counts rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param startsWith
	 *            Boolean
	 * @param mostrarDadosDeBaja
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santipestim santipestim, Boolean startsWith,
			Boolean mostrarDadosDeBaja) {
		return this.santipestimDao.findAllLikeCount(santipestim, startsWith,
				mostrarDadosDeBaja);
	}

	/**
	 * Deletes a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santipestim santipestim) {
		this.santipestimDao.remove(santipestim);
	}

	/**
	 * Deletes multiple rows in the Santipestim table.
	 * 
	 * @param santipestimList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santipestim> santipestimList) {
		for (Santipestim santipestimAux : santipestimList) {
			this.santipestimDao.remove(santipestimAux);
		}
	}

}
