package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Santipestim;

/**
 * SantipestimService  
 * 
 *  
 */

public interface SantipestimService {

	/**
	 * Inserts a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim add(Santipestim santipestim);

	/**
	 * Updates a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim update(Santipestim santipestim);

	/**
	 * Finds a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim find(Santipestim santipestim);

	/**
	 * Finds a List of rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param incluirDadosBaja
	 *            Boolean
	 * @return List
	 */
	List<Santipestim> findAll(Santipestim santipestim, Pagination pagination,
			Boolean incluirDadosBaja);

	/**
	 * Counts rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param incluirDadosBaja
	 *            Boolean
	 * @return Long
	 */
	Long findAllCount(Santipestim santipestim, Boolean mostrarDadosDeBaja);

	/**
	 * Finds rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param incluirDadosBaja
	 *            Boolean
	 * @return List
	 */
	List<Santipestim> findAllLike(Santipestim santipestim,
			Pagination pagination, Boolean startsWith,
			Boolean mostrarDadosDeBaja);

	/**
	 * Counts rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param startsWith
	 *            Boolean
	 * @param incluirDadosBaja
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santipestim santipestim, Boolean startsWith,
			Boolean mostrarDadosDeBaja);

	/**
	 * Deletes a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return
	 */
	void remove(Santipestim santipestim);

	/**
	 * Deletes multiple rows in the Santipestim table.
	 * 
	 * @param santipestimList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Santipestim> santipestimList);

}
