package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.TipoDocumento;

/**
 * SantipdocServiceImpl  
 * 
 *  
 */

@Service(value = "santipdocService")
public class SantipdocServiceImpl implements SantipdocService {

	@Autowired()
	private SantipdocDao santipdocDao;

	/**
	 * Inserts a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipdoc add(Santipdoc santipdoc) {
		return this.santipdocDao.add(santipdoc);
	}

	/**
	 * Updates a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Santipdoc update(Santipdoc santipdoc) {
		return this.santipdocDao.update(santipdoc);
	}

	/**
	 * Finds a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	public Santipdoc find(Santipdoc santipdoc) {
		return (Santipdoc) this.santipdocDao.find(santipdoc);
	}

	/**
	 * Finds a List of rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Santipdoc> findAll(Santipdoc santipdoc, Pagination pagination) {
		return (List<Santipdoc>) this.santipdocDao.findAll(santipdoc,
				pagination);
	}

	/**
	 * Finds a List of rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoDocumento> findAllTipoDocumento(Santipdoc santipdoc,
			Pagination pagination) {
		List<Santipdoc> listSantipdoc = (List<Santipdoc>) this.santipdocDao
				.findAll(santipdoc, pagination);
		if (listSantipdoc != null) {
			List<TipoDocumento> listTipoDocumento = new ArrayList<TipoDocumento>();
			if (listSantipdoc.size() > 0) {
				TipoDocumento tipoDocumentoAux;
				for (Santipdoc santipdocAux : listSantipdoc) {
					tipoDocumentoAux = new TipoDocumento();
					tipoDocumentoAux.setIdTipodoc(santipdocAux.getTdid());
					tipoDocumentoAux.setTdnombre(santipdocAux.getTdnombre());
					tipoDocumentoAux.setTdnombree(santipdocAux.getTdnombree());
					listTipoDocumento.add(tipoDocumentoAux);
				}
			}
			return listTipoDocumento;
		} else {
			return null;
		}
	}

	/**
	 * Counts rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Long
	 */
	public Long findAllCount(Santipdoc santipdoc) {
		return this.santipdocDao.findAllCount(santipdoc);
	}

	/**
	 * Counts rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Long
	 */
	public Long findAllCountTipoDocumento(Santipdoc santipdoc) {
		return this.santipdocDao.findAllCount(santipdoc);
	}

	/**
	 * Finds rows in the Santipdoc table using like.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Santipdoc> findAllLike(Santipdoc santipdoc,
			Pagination pagination, Boolean startsWith) {
		return (List<Santipdoc>) this.santipdocDao.findAllLike(santipdoc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Santipdoc table using like.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Santipdoc santipdoc, Boolean startsWith) {
		return this.santipdocDao.findAllLikeCount(santipdoc, startsWith);
	}

	/**
	 * Deletes a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Santipdoc santipdoc) {
		this.santipdocDao.remove(santipdoc);
	}

	/**
	 * Deletes multiple rows in the Santipdoc table.
	 * 
	 * @param santipdocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Santipdoc> santipdocList) {
		for (Santipdoc santipdocAux : santipdocList) {
			this.santipdocDao.remove(santipdocAux);
		}
	}

}
