package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.TipoDocumento;

/**
 * SantipdocService  
 * 
 *  
 */

public interface SantipdocService {

	/**
	 * Inserts a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	Santipdoc add(Santipdoc santipdoc);

	/**
	 * Updates a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	Santipdoc update(Santipdoc santipdoc);

	/**
	 * Finds a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Santipdoc
	 */
	Santipdoc find(Santipdoc santipdoc);

	/**
	 * Finds a List of rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Santipdoc> findAll(Santipdoc santipdoc, Pagination pagination);

	/**
	 * Finds a List of rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoDocumento> findAllTipoDocumento(Santipdoc santipdoc,
			Pagination pagination);

	/**
	 * Counts rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Long
	 */
	Long findAllCount(Santipdoc santipdoc);

	/**
	 * Counts rows in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return Long
	 */
	Long findAllCountTipoDocumento(Santipdoc santipdoc);

	/**
	 * Finds rows in the Santipdoc table using like.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Santipdoc> findAllLike(Santipdoc santipdoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Santipdoc table using like.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santipdoc santipdoc, Boolean startsWith);

	/**
	 * Deletes a single row in the Santipdoc table.
	 * 
	 * @param santipdoc
	 *            Santipdoc
	 * @return
	 */
	void remove(Santipdoc santipdoc);

	/**
	 * Deletes multiple rows in the Santipdoc table.
	 * 
	 * @param santipdocList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Santipdoc> santipdocList);

}
