package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanresulsenDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanresulsen;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanresulsenServiceImpl  
 * 
 *  
 */

@Service(value = "sanresulsenService")
public class SanresulsenServiceImpl implements SanresulsenService {

	@Autowired()
	private SanresulsenDao sanresulsenDao;

	/**
	 * Inserts a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanresulsen add(Sanresulsen sanresulsen) {
		try {
			return this.sanresulsenDao.add(sanresulsen);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.sanresulsen.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanresulsen update(Sanresulsen sanresulsen) {
		return this.sanresulsenDao.update(sanresulsen);
	}

	/**
	 * Finds a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	public Sanresulsen find(Sanresulsen sanresulsen) {
		return (Sanresulsen) this.sanresulsenDao.find(sanresulsen);
	}

	/**
	 * Finds a List of rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanresulsen> findAll(Sanresulsen sanresulsen,
			Pagination pagination) {
		return (List<Sanresulsen>) this.sanresulsenDao.findAll(sanresulsen,
				pagination);
	}

	/**
	 * Counts rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Long
	 */
	public Long findAllCount(Sanresulsen sanresulsen) {
		return this.sanresulsenDao.findAllCount(sanresulsen);
	}

	/**
	 * Finds rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanresulsen> findAllLike(Sanresulsen sanresulsen,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanresulsen>) this.sanresulsenDao.findAllLike(sanresulsen,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanresulsen sanresulsen, Boolean startsWith) {
		return this.sanresulsenDao.findAllLikeCount(sanresulsen, startsWith);
	}

	/**
	 * Deletes a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanresulsen sanresulsen) {
		try {
			this.sanresulsenDao.remove(sanresulsen);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.sanresulsen.DataIntegrityViolationException", true,
					e);
		}
	}

	/**
	 * Deletes multiple rows in the Sanresulsen table.
	 * 
	 * @param sanresulsenList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanresulsen> sanresulsenList) {
		for (Sanresulsen sanresulsenAux : sanresulsenList) {
			this.sanresulsenDao.remove(sanresulsenAux);
		}
	}

}
