package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanrecrcaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanrecrca;

/**
 * SanrecrcaServiceImpl  
 * 
 *  
 */

@Service(value = "sanrecrcaService")
public class SanrecrcaServiceImpl implements SanrecrcaService {

	@Autowired()
	private SanrecrcaDao sanrecrcaDao;

	/**
	 * Inserts a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Sanrecrca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanrecrca add(Sanrecrca sanrecrca) {
		return this.sanrecrcaDao.add(sanrecrca);
	}

	/**
	 * Updates a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Sanrecrca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanrecrca update(Sanrecrca sanrecrca) {
		return this.sanrecrcaDao.update(sanrecrca);
	}

	/**
	 * Finds a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Sanrecrca
	 */
	public Sanrecrca find(Sanrecrca sanrecrca) {
		return (Sanrecrca) this.sanrecrcaDao.find(sanrecrca);
	}

	/**
	 * Finds a List of rows in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanrecrca> findAll(Sanrecrca sanrecrca, Pagination pagination) {
		return (List<Sanrecrca>) this.sanrecrcaDao.findAll(sanrecrca,
				pagination);
	}

	/**
	 * Counts rows in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Long
	 */
	public Long findAllCount(Sanrecrca sanrecrca) {
		return this.sanrecrcaDao.findAllCount(sanrecrca);
	}

	/**
	 * Finds rows in the Sanrecrca table using like.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanrecrca> findAllLike(Sanrecrca sanrecrca,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanrecrca>) this.sanrecrcaDao.findAllLike(sanrecrca,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanrecrca table using like.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanrecrca sanrecrca, Boolean startsWith) {
		return this.sanrecrcaDao.findAllLikeCount(sanrecrca, startsWith);
	}

	/**
	 * Deletes a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanrecrca sanrecrca) {
		this.sanrecrcaDao.remove(sanrecrca);
	}

	/**
	 * Deletes multiple rows in the Sanrecrca table.
	 * 
	 * @param sanrecrcaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanrecrca> sanrecrcaList) {
		for (Sanrecrca sanrecrcaAux : sanrecrcaList) {
			this.sanrecrcaDao.remove(sanrecrcaAux);
		}
	}

}
