package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanprueDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanprue;

/**
 * SanprueServiceImpl  
 * 
 *  
 */

@Service(value = "sanprueService")
public class SanprueServiceImpl implements SanprueService {

	@Autowired()
	private SanprueDao sanprueDao;

	/**
	 * Inserts a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Sanprue
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanprue add(Sanprue sanprue) {
		return this.sanprueDao.add(sanprue);
	}

	/**
	 * Updates a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Sanprue
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanprue update(Sanprue sanprue) {
		return this.sanprueDao.update(sanprue);
	}

	/**
	 * Finds a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Sanprue
	 */
	public Sanprue find(Sanprue sanprue) {
		return (Sanprue) this.sanprueDao.find(sanprue);
	}

	/**
	 * Finds a List of rows in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanprue> findAll(Sanprue sanprue, Pagination pagination) {
		if (pagination != null) {
			if ("prfecprac".equals(pagination.getSort())) {
				pagination.setSort("PRFECPRAC");
			} else if ("prres".equals(pagination.getSort())) {
				pagination.setSort("PRRES");
			} else if ("prfecprue".equals(pagination.getSort())) {
				pagination.setSort("PRFECPRUE");
			} else if ("prtipoprue".equals(pagination.getSort())) {
				pagination.setSort("PRTIPOPRUE");
			} else if ("saninterv.uanombre".equals(pagination.getSort())) {
				pagination.setSort("UANOMBRE");
			} else if ("prid".equals(pagination.getSort())) {
				pagination.setSort("PRID");
			}
		}
		return (List<Sanprue>) this.sanprueDao.findAll(sanprue, pagination);
	}

	/**
	 * Counts rows in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Long
	 */
	public Long findAllCount(Sanprue sanprue) {
		return this.sanprueDao.findAllCount(sanprue);
	}

	/**
	 * Finds rows in the Sanprue table using like.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanprue> findAllLike(Sanprue sanprue, Pagination pagination,
			Boolean startsWith) {
		return (List<Sanprue>) this.sanprueDao.findAllLike(sanprue, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Sanprue table using like.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanprue sanprue, Boolean startsWith) {
		return this.sanprueDao.findAllLikeCount(sanprue, startsWith);
	}

	/**
	 * Deletes a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanprue sanprue) {
		this.sanprueDao.remove(sanprue);
	}

	/**
	 * Deletes multiple rows in the Sanprue table.
	 * 
	 * @param sanprueList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanprue> sanprueList) {
		for (Sanprue sanprueAux : sanprueList) {
			this.sanprueDao.remove(sanprueAux);
		}
	}

}
