package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanpropbandejaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanpropbandeja;

/**
 * SanpropbandejaServiceImpl  
 * 
 *  
 */

@Service(value = "sanpropbandejaService")
public class SanpropbandejaServiceImpl implements SanpropbandejaService {

	@Autowired()
	private SanpropbandejaDao sanpropbandejaDao;

	/**
	 * Inserts a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanpropbandeja add(Sanpropbandeja sanpropbandeja) {
		return this.sanpropbandejaDao.add(sanpropbandeja);
	}

	/**
	 * Updates a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanpropbandeja update(Sanpropbandeja sanpropbandeja) {
		return this.sanpropbandejaDao.update(sanpropbandeja);
	}

	/**
	 * Finds a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	public Sanpropbandeja find(Sanpropbandeja sanpropbandeja) {
		return (Sanpropbandeja) this.sanpropbandejaDao.find(sanpropbandeja);
	}

	/**
	 * Finds a List of rows in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanpropbandeja> findAll(Sanpropbandeja sanpropbandeja,
			Pagination pagination) {
		if (pagination != null) {
			if ("baprsanid".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANID");
			} else if ("censoMonitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("baprsanmunic".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANMUNIC");
			} else if ("baprsanprov".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANPROV");
			} else if ("establecimiento.esnoco".equals(pagination.getSort())) {
				pagination.setSort("ESNOCO");
			} else if ("baprsanfec".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANFEC");
			} else if ("tipoProcedimiento.pnombre".equals(pagination.getSort())) {
				pagination.setSort("PNOMBRE");
			} else if ("tipoProcedimiento.pnombree"
					.equals(pagination.getSort())) {
				pagination.setSort("PNOMBREE");
			} else if ("tipoProcedimiento.pcodigo".equals(pagination.getSort())) {
				pagination.setSort("PCODIGO");
			} else if ("baprsanexcodigocompleto".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANEXCODCOMPLETO");
				if (pagination.getAscDsc().equals("asc")) {
					pagination
							.setSort("SUBSTR(BAPRSANEXCODCOMPLETO,0,6) ASC, CASE REGEXP_COUNT(BAPRSANEXCODCOMPLETO,'-',1) WHEN 2 THEN TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,-4,4)) ELSE  TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,-6,4)) END ASC, TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,8,INSTR(BAPRSANEXCODCOMPLETO,'-',1,2)-8)) ");
				} else if (pagination.getAscDsc().equals("desc")) {
					pagination
							.setSort("SUBSTR(BAPRSANEXCODCOMPLETO,0,6) DESC, CASE REGEXP_COUNT(BAPRSANEXCODCOMPLETO,'-',1) WHEN 2 THEN TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,-4,4)) ELSE  TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,-6,4)) END DESC , TO_NUMBER(SUBSTR(BAPRSANEXCODCOMPLETO,8,INSTR(BAPRSANEXCODCOMPLETO,'-',1,2)-8)) ");
				}
			} else if ("baprsanexcodigo".equals(pagination.getSort())) {
				pagination.setSort("BAPRSANEXCODIGO");
			}
		}
		return (List<Sanpropbandeja>) this.sanpropbandejaDao.findAll(
				sanpropbandeja, pagination);
	}

	/**
	 * Counts rows in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Long
	 */
	public Long findAllCount(Sanpropbandeja sanpropbandeja) {
		return this.sanpropbandejaDao.findAllCount(sanpropbandeja);
	}

	/**
	 * Finds rows in the Sanpropbandeja table using like.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanpropbandeja> findAllLike(Sanpropbandeja sanpropbandeja,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanpropbandeja>) this.sanpropbandejaDao.findAllLike(
				sanpropbandeja, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanpropbandeja table using like.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanpropbandeja sanpropbandeja,
			Boolean startsWith) {
		return this.sanpropbandejaDao.findAllLikeCount(sanpropbandeja,
				startsWith);
	}

	/**
	 * Deletes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanpropbandeja sanpropbandeja) {
		this.sanpropbandejaDao.remove(sanpropbandeja);
	}

	/**
	 * Deletes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSolicitudes(Sanpropbandeja sanpropbandeja) {
		this.sanpropbandejaDao.removeSolicitudes(sanpropbandeja);
	}

	/**
	 * Deletes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInspecciones(Sanpropbandeja sanpropbandeja) {
		this.sanpropbandejaDao.removeInspecciones(sanpropbandeja);
	}

	/**
	 * Deletes multiple rows in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandejaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanpropbandeja> sanpropbandejaList) {
		for (Sanpropbandeja sanpropbandejaAux : sanpropbandejaList) {
			this.sanpropbandejaDao.remove(sanpropbandejaAux);
		}
	}

	/**
	 * Updates a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Sanpropbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanpropbandeja updateBaprNuevoOrganismo(Sanpropbandeja sanpropbandeja) {
		return this.sanpropbandejaDao.updateBaprNuevoOrganismo(sanpropbandeja);
	}

}
