package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanplazosDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanplazos;

/**
 * SanplazosServiceImpl  
 * 
 *  
 */

@Service(value = "sanplazosService")
public class SanplazosServiceImpl implements SanplazosService {

	@Autowired()
	private SanplazosDao sanplazosDao;

	/**
	 * Inserts a single row in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Sanplazos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanplazos add(Sanplazos sanplazos) {
		return this.sanplazosDao.add(sanplazos);
	}

	/**
	 * Updates a single row in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Sanplazos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanplazos update(Sanplazos sanplazos) {
		return this.sanplazosDao.update(sanplazos);
	}

	/**
	 * Finds a single row in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Sanplazos
	 */
	public Sanplazos find(Sanplazos sanplazos) {
		return (Sanplazos) this.sanplazosDao.find(sanplazos);
	}

	/**
	 * Finds a List of rows in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanplazos> findAll(Sanplazos sanplazos, Pagination pagination) {
		return (List<Sanplazos>) this.sanplazosDao.findAll(sanplazos,
				pagination);
	}

	/**
	 * Counts rows in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return Long
	 */
	public Long findAllCount(Sanplazos sanplazos) {
		return this.sanplazosDao.findAllCount(sanplazos);
	}

	/**
	 * Finds rows in the Sanplazos table using like.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanplazos> findAllLike(Sanplazos sanplazos,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanplazos>) this.sanplazosDao.findAllLike(sanplazos,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanplazos table using like.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanplazos sanplazos, Boolean startsWith) {
		return this.sanplazosDao.findAllLikeCount(sanplazos, startsWith);
	}

	/**
	 * Deletes a single row in the Sanplazos table.
	 * 
	 * @param sanplazos
	 *            Sanplazos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanplazos sanplazos) {
		this.sanplazosDao.remove(sanplazos);
	}

	/**
	 * Deletes multiple rows in the Sanplazos table.
	 * 
	 * @param sanplazosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanplazos> sanplazosList) {
		for (Sanplazos sanplazosAux : sanplazosList) {
			this.sanplazosDao.remove(sanplazosAux);
		}
	}

}
