package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanintervinienteDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Saninterviniente;

/**
 * SanintervinienteServiceImpl  
 * 
 *  
 */

@Service(value = "sanintervinienteService")
public class SanintervinienteServiceImpl implements SanintervinienteService {

	@Autowired()
	private SanintervinienteDao sanintervinienteDao;

	/**
	 * Inserts a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return Saninterviniente
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterviniente add(Saninterviniente saninterviniente) {
		return this.sanintervinienteDao.add(saninterviniente);
	}

	/**
	 * Updates a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return Saninterviniente
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterviniente update(Saninterviniente saninterviniente) {
		return this.sanintervinienteDao.update(saninterviniente);
	}

	/**
	 * Finds a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return Saninterviniente
	 */
	public Saninterviniente find(Saninterviniente saninterviniente) {
		return (Saninterviniente) this.sanintervinienteDao
				.find(saninterviniente);
	}

	/**
	 * Finds a List of rows in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Saninterviniente> findAll(Saninterviniente saninterviniente,
			Pagination pagination) {
		return (List<Saninterviniente>) this.sanintervinienteDao.findAll(
				saninterviniente, pagination);
	}

	/**
	 * Counts rows in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return Long
	 */
	public Long findAllCount(Saninterviniente saninterviniente) {
		return this.sanintervinienteDao.findAllCount(saninterviniente);
	}

	/**
	 * Finds rows in the Saninterviniente table using like.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Saninterviniente> findAllLike(
			Saninterviniente saninterviniente, Pagination pagination,
			Boolean startsWith) {
		return (List<Saninterviniente>) this.sanintervinienteDao.findAllLike(
				saninterviniente, pagination, startsWith);
	}

	/**
	 * Counts rows in the Saninterviniente table using like.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Saninterviniente saninterviniente,
			Boolean startsWith) {
		return this.sanintervinienteDao.findAllLikeCount(saninterviniente,
				startsWith);
	}

	/**
	 * Deletes a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Saninterviniente saninterviniente) {
		this.sanintervinienteDao.remove(saninterviniente);
	}

	/**
	 * Deletes multiple rows in the Saninterviniente table.
	 * 
	 * @param sanintervinienteList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Saninterviniente> sanintervinienteList) {
		for (Saninterviniente sanintervinienteAux : sanintervinienteList) {
			this.sanintervinienteDao.remove(sanintervinienteAux);
		}
	}

}
