package com.ejie.y41b.service;

import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.SanintervDetalle;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SanintervServiceImpl  
 * 
 *  
 */

@Service(value = "sanintervService")
public class SanintervServiceImpl implements SanintervService {

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private T17CalleDao t17CalleDao;

	@Autowired()
	private T17PortalDao t17PortalDao;

	@Autowired()
	private T17LocalidadDao t17LocalidadDao;

	@Autowired()
	private T17MunicipioDao t17MunicipioDao;

	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private EstablecimientoService establecimientoService;

	@Autowired()
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired()
	private SedeDao sedeDao;

	@Autowired()
	private T17PortalService t17PortalService;

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterv add(Saninterv saninterv) {
		return this.sanintervDao.add(saninterv);
	}

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterv update(Saninterv saninterv) {
		return this.sanintervDao.update(saninterv);
	}

	/**
	 * Finds a single row in the Saninterv table.
	 * 
	 * @param filterSaninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	public Saninterv find(Saninterv filterSaninterv) {

		Saninterv saninterv = (Saninterv) this.sanintervDao.find(filterSaninterv);
		saninterv.setDireccionCompleta(this.dameDireccionCompleta(saninterv));
		return saninterv;

	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Saninterv> findAll(Saninterv saninterv, Pagination pagination) {
		List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(saninterv, pagination);
		for (Saninterv saninterv2 : listaIntervinientes) {
			saninterv2.setDireccionCompleta(this.dameDireccionCompleta(saninterv2));
			saninterv2.setCodTipointerv(saninterv2.getUatipointerv());
		}
		return listaIntervinientes;
	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Saninterv> findAllCombo(Saninterv saninterv, Pagination pagination) {
		List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(saninterv, pagination);
		for (Saninterv saninterv2 : listaIntervinientes) {
			saninterv2.setNombreCompleto((saninterv2.getUanombre() == null ? ""
					: saninterv2.getUanombre().concat(" ")
							.concat(saninterv2.getUaapellido1() == null ? "" : saninterv2.getUaapellido1()).concat(" ")
							.concat(saninterv2.getUaapellido2() == null ? "" : saninterv2.getUaapellido2())).trim());
		}
		return listaIntervinientes;
	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientes(Intervinientes saninterv, Pagination pagination) {
		return (List<Intervinientes>) this.sanintervDao.findAllIntervinientes(saninterv, pagination);
	}

	// EVOLUTIVO 0135083 2.2
	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientesConCIF(Intervinientes saninterv, Pagination pagination) {
		return (List<Intervinientes>) this.sanintervDao.findAllIntervinientesConCIF(saninterv, pagination);
	}

	// EVOLUTIVO 0135083 2.2

	/**
	 * Counts rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Long
	 */
	public Long findAllCount(Saninterv saninterv) {
		return this.sanintervDao.findAllCount(saninterv);
	}

	/**
	 * Finds rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Saninterv> findAllLike(Saninterv saninterv, Pagination pagination, Boolean startsWith) {
		return (List<Saninterv>) this.sanintervDao.findAllLike(saninterv, pagination, startsWith);
	}

	/**
	 * Counts rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Saninterv saninterv, Boolean startsWith) {
		return this.sanintervDao.findAllLikeCount(saninterv, startsWith);
	}

	/**
	 * Deletes a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Saninterv saninterv) {
		this.sanintervDao.remove(saninterv);
	}

	/**
	 * Deletes multiple rows in the Saninterv table.
	 * 
	 * @param sanintervList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Saninterv> sanintervList) {
		for (Saninterv sanintervAux : sanintervList) {
			this.sanintervDao.remove(sanintervAux);
		}
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	private String dameDireccionCompleta(Saninterv saninterv) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(saninterv));

		/*
		 * if ((saninterv.getUalocId() != null) && (saninterv.getUamunId() !=
		 * null) && (saninterv.getUaprovId() != null)) {
		 * direccion.append(dameLocalidad(saninterv)); }
		 */

		if ((saninterv.getUamunId() != null) && (saninterv.getUaprovId() != null)) {
			direccion.append(this.dameMunicipio(saninterv));
		}

		if (saninterv.getUaprovId() != null) {
			direccion.append(this.dameProvincia(saninterv));
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameLineaDireccion(Saninterv saninterv) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUadireNocapv())) {
			direccion.append(saninterv.getUadireNocapv());
		} else if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUacalleId())) {
			String calle = "";
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(saninterv.getUacalleId()), null)).getDsO();
			} catch (Exception e) {

			}
			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
					direccion.append(saninterv.getUanodir());
				}
			} else {
				if (saninterv.getUaportalId() != null) {
					t17portal.setId(Long.parseLong(saninterv.getUaportalId()));
					t17portal.setCalleId(Long.parseLong(saninterv.getUacalleId()));
					List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
					if (list != null && list.size() > 0) {
						t17portal = list.get(0);
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ")
									.append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(),
											t17portal.getPortal(), 0, null, saninterv.getUanombrePiso(),
											saninterv.getUanodir()));
						} else if (t17portal != null && t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
								direccion.append(" ").append(saninterv.getUanodir());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
								direccion.append(" ").append(saninterv.getUanodir());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
							direccion.append(" ").append(saninterv.getUanodir());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
						direccion.append(" ").append(saninterv.getUanodir());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUanodir())) {
				direccion.append(" ").append(saninterv.getUanodir());
			}
		}
		return (direccion.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameCodigoPostal(Saninterv saninterv) {
		StringBuffer cp = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUaportalId())) {
			t17portal.setId(Long.parseLong(saninterv.getUaportalId()));
			List<T17Portal> listat17portal = this.t17PortalDao.findAll(t17portal, null);

			if (listat17portal != null && listat17portal.size() > 0) {
				t17portal = listat17portal.get(0);
				return t17portal.getCodigoPostal();
			}

		}

		return (cp.toString());

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameLocalidad(Saninterv saninterv) {
		StringBuffer direccion = new StringBuffer("");
		String localidad = "";

		/* localidad */
		if ((saninterv.getUalocId() != null) && (saninterv.getUamunId() != null) && (saninterv.getUaprovId() != null)) {
			T17Localidad localidadVO = this.t17LocalidadDao.find(new T17Localidad(saninterv.getUalocId(), null,
					saninterv.getUamunId(), saninterv.getUaprovId(), null));
			if (localidadVO != null) {
				localidad = localidadVO.getDsO() == null ? "" : localidadVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(localidad);
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameMunicipio(Saninterv saninterv) {
		StringBuffer direccion = new StringBuffer("");

		String municipio = "";

		/* localidad */

		if ((saninterv.getUamunId() != null) && (saninterv.getUaprovId() != null)) {
			T17Municipio municipiodVO = (this.t17MunicipioDao
					.find(new T17Municipio(saninterv.getUamunId(), saninterv.getUaprovId(), null, null)));

			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(municipio);
		}

		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameProvincia(Saninterv saninterv) {
		StringBuffer direccion = new StringBuffer("");

		String provincia = "";
		/* localidad */
		if (saninterv.getUaprovId() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(saninterv.getUaprovId(), null, null)));

			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}

			direccion.append(" ");
			direccion.append(provincia);

		}
		return (direccion.toString());
	}

	/**
	 * Dame sancionado.
	 * 
	 * @param excodigo
	 *            the expedien
	 * @return Saninterv
	 */
	public Saninterv dameSancionado(String excodigo) {

		Saninterv saninterv = this.sanintervDao.dameSancionado(excodigo);
		if (saninterv != null) {
			saninterv.setDireccionCompleta(this.dameDireccionCompleta(saninterv));
		}
		// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho
		// de los expedientes
		saninterv.setEstablecimientoCerrado(
				this.establecimientoService.estadoCerradoEstablecimientoCenso(saninterv.getUaescodigo()));
		// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho
		// de los expedientes

		return saninterv;

	}

	/**
	 * Metodo para recoger los datos de la tabla Saninterv especificando el
	 * identificativo
	 * 
	 * @param sanintervAux
	 *            Saninterv
	 * @return SanintervDetalle
	 */
	public SanintervDetalle findEstSancion(Saninterv sanintervAux) {
		Saninterv saninterv = (Saninterv) this.sanintervDao.find(sanintervAux);

		SanintervDetalle sanintervdetalle = new SanintervDetalle();
		sanintervdetalle.setUaidinterv(saninterv.getUaidinterv());
		sanintervdetalle.setUaescodigo(saninterv.getUaescodigo());
		sanintervdetalle.setUanombre(saninterv.getUanombre());
		sanintervdetalle.setUaapellido1(saninterv.getUaapellido1());
		sanintervdetalle.setUaapellido2(saninterv.getUaapellido2());
		sanintervdetalle.setUanif(saninterv.getUanif());
		sanintervdetalle.setUanrtel(saninterv.getUanrtel());
		sanintervdetalle.setUanrtel2(saninterv.getUanrtel2());
		sanintervdetalle.setUacoem(saninterv.getUacoem());
		sanintervdetalle.setUapaisId(saninterv.getUapaisId());
		sanintervdetalle.setUaprovId(saninterv.getUaprovId());
		sanintervdetalle.setUamunId(saninterv.getUamunId());
		sanintervdetalle.setUalocId(saninterv.getUalocId());
		sanintervdetalle.setUacalleId(saninterv.getUacalleId());
		sanintervdetalle.setUacpId(saninterv.getUacpId());
		sanintervdetalle.setUaportalId(saninterv.getUaportalId());
		sanintervdetalle.setUanombrePiso(saninterv.getUanombrePiso());
		sanintervdetalle.setUadireNocapv(saninterv.getUadireNocapv());
		sanintervdetalle.setUafecultmod(saninterv.getUafecultmod());
		sanintervdetalle.setUausuultmod(saninterv.getUausuultmod());
		sanintervdetalle.setUsuarioxlnet(saninterv.getUsuarioxlnet());
		sanintervdetalle.setEsnopeco(saninterv.getUanopeco());
		sanintervdetalle.setEsnoco(saninterv.getUanoco());
		sanintervdetalle.setEsteurl(saninterv.getUaurl());
		sanintervdetalle.setSecodigo(saninterv.getUasecodigo());
		sanintervdetalle.setSenombre(saninterv.getUasenombre());
		sanintervdetalle.setSenombree(saninterv.getUasenombree());
		sanintervdetalle.setUaidioma(saninterv.getUaidioma());

		String calle = "";
		if (!Y41bUtils.esNullOCadenaVacia(sanintervdetalle.getUacalleId())) {
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(sanintervdetalle.getUacalleId()), null))
						.getDsO();
			} catch (Exception e) {

			}
			sanintervdetalle.setCalleId_label(calle);
		}

		// Recuperamos el establecimiento
		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUaescodigo())) {
			Establecimiento estableci = (Establecimiento) this.establecimientoDao
					.find(new Establecimiento(saninterv.getUaescodigo()));

			sanintervdetalle.setDireccionAntiguaCompleta(this.dameDireccionAntigua(estableci));

			sanintervdetalle.setEssede(estableci.getEssede());
			// idioma blanco:
			// sanintervdetalle.setEscoidco(estableci.getEscoidco());
			sanintervdetalle.setEsfeadar(estableci.getEsfeadar());
			sanintervdetalle.setEsintiar(estableci.getEsintiar());
			// Comentarios blanco:
			// sanintervdetalle.setEsteco(estableci.getEsteco());

			// Sector de saninterv
			/*
			 * EstablecimSector establecimSector = new EstablecimSector();
			 * establecimSector.setEstablecimiento(estableci); EstablecimSector
			 * establecSector = new EstablecimSector(); Actividad actividad =
			 * new Actividad(); Sector sector = new Sector();
			 * establecSector.setActividad(actividad);
			 * establecSector.setSector(sector);
			 * 
			 * establecSector = (EstablecimSector) this.establecimSectorDao
			 * .findSectorEstablecimiento(establecimSector);
			 * 
			 * sanintervdetalle.setEacodigo(establecSector.getEacodigo());
			 * sanintervdetalle.setAvcodigo(establecSector.getActividad()
			 * .getAvcodigo());
			 * sanintervdetalle.setAvnombre(establecSector.getActividad()
			 * .getAvnombre());
			 * sanintervdetalle.setAvnombree(establecSector.getActividad()
			 * .getAvnombree());
			 * sanintervdetalle.setSecodigo(establecSector.getSector()
			 * .getSecodigo());
			 * sanintervdetalle.setSenombre(establecSector.getSector()
			 * .getSenombre());
			 * sanintervdetalle.setSenombree(establecSector.getSector()
			 * .getSenombree());
			 * sanintervdetalle.setEainprse(establecSector.getEainprse());
			 */

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
				sanintervdetalle.setEsinadar(estableci.getEsinadar());
				sanintervdetalle.setAhfeba(establecimArbitra.getAhfeba());
				sanintervdetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			} catch (Exception e) {

			}
			// buscar sedes
			if (estableci.getEssede() != null && estableci.getEssede().equals(Y41bConstantes.SI)) {
				Sede sede = new Sede();
				sede.setEscodigo(estableci.getEscodigo());

				List<Sede> listSede = this.sedeDao.findAll(sede, null);
				sanintervdetalle.setSedes(listSede);
			}

			/*
			 * Descriptores blanco: List<Descriptor> listDescriptor =
			 * this.establecimientoDao .findAllEstablecimientoDescriptor(new
			 * Establecimiento( saninterv.getUaescodigo()), null);
			 * 
			 * StringBuffer strIdsDescriptores = new StringBuffer();
			 * StringBuffer strDescsDescriptores = new StringBuffer();
			 * 
			 * strDescsDescriptores.append("[");
			 * 
			 * boolean firstElement = true;
			 * 
			 * // se recorre para obtener los ids de etiquetas for (Descriptor
			 * descriptor : listDescriptor) { if (firstElement) {
			 * strIdsDescriptores.append(descriptor.getIdDescriptor());
			 * strDescsDescriptores.append(descriptor.getNombre()); firstElement
			 * = false; } else { strIdsDescriptores.append(",").append(
			 * descriptor.getIdDescriptor());
			 * strDescsDescriptores.append(",").append( descriptor.getNombre());
			 * } } strDescsDescriptores.append("]");
			 * 
			 * sanintervdetalle.setIdsDescriptores(strIdsDescriptores.toString()
			 * ) ; sanintervdetalle.setDescsDescriptores(strDescsDescriptores
			 * .toString());
			 */
		}

		return sanintervdetalle;
	}

	/**
	 * 
	 * @param interviniente
	 *            Saninterv
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findEstablecimiento(Saninterv interviniente) {
		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle();
		Establecimiento estableci = null;

		Saninterv saninterv = (Saninterv) this.sanintervDao.find(interviniente);
		estableci = (Establecimiento) this.establecimientoDao.find(new Establecimiento(saninterv.getUaescodigo()));
		establecidetalle.setEscodigo(saninterv.getUaescodigo());
		StringBuffer nombre = new StringBuffer("");
		nombre.append(saninterv.getUanombre());
		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUaapellido1())) {
			nombre.append(" ").append(saninterv.getUaapellido1());
		}
		if (!Y41bUtils.esNullOCadenaVacia(saninterv.getUaapellido2())) {
			nombre.append(" ").append(saninterv.getUaapellido2());
		}
		establecidetalle.setEsnombre(nombre.toString());
		establecidetalle.setEsnif(saninterv.getUanif());
		establecidetalle.setEsnrtel(saninterv.getUanrtel());
		establecidetalle.setEsnrtel2(saninterv.getUanrtel2());
		establecidetalle.setEscoem(saninterv.getUacoem());
		establecidetalle.setEsnoraPaisId(saninterv.getUapaisId());
		establecidetalle.setProvinciaId(saninterv.getUaprovId());
		establecidetalle.setMunicipioId(saninterv.getUamunId());
		establecidetalle.setLocalidadId(saninterv.getUalocId());
		establecidetalle.setCalleId(saninterv.getUacalleId());
		establecidetalle.setCpId(saninterv.getUacpId());
		establecidetalle.setEsnombreCp(this.dameCodigoPostal(saninterv));
		establecidetalle.setPortalId(saninterv.getUaportalId());
		establecidetalle.setEsnombrePiso(saninterv.getUanombrePiso());
		establecidetalle.setEsdireccion_nocapv(saninterv.getUadireNocapv());
		establecidetalle.setEsfemod(saninterv.getUafecultmod());
		establecidetalle.setMocodigo(saninterv.getUausuultmod());
		establecidetalle.setMousu(saninterv.getUsuarioxlnet());
		establecidetalle.setEsnopeco(saninterv.getUanopeco());
		establecidetalle.setEsnoco(saninterv.getUanoco());
		establecidetalle.setEsteurl(saninterv.getUaurl());
		establecidetalle.setSecodigo(saninterv.getUasecodigo());
		establecidetalle.setSenombre(saninterv.getUasenombre());
		establecidetalle.setSenombree(saninterv.getUasenombree());
		establecidetalle.setEscoidco(saninterv.getUaidioma());

		String calle = "";
		if (!Y41bUtils.esNullOCadenaVacia(establecidetalle.getCalleId())) {
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(establecidetalle.getCalleId()), null))
						.getDsO();
			} catch (Exception e) {

			}
			establecidetalle.setCalleId_label(calle);
		}

		establecidetalle.setEsdireccionCompleta(this.dameDireccionCompleta(saninterv));

		establecidetalle.setDireccionAntiguaCompleta(this.dameDireccionAntigua(estableci));

		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());
		establecidetalle.setEsfeba(estableci.getEsfeba());
		establecidetalle.setEsteco(estableci.getEsteco());
		establecidetalle.setEstipid(estableci.getEstipid());

		// Mail de avisos
		establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}
		// buscar sedes
		if (estableci.getEssede() != null && estableci.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(estableci.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return establecidetalle;
	}

	/**
	 * 
	 * @param estableci
	 *            Establecimiento
	 * @return String
	 */
	private String dameDireccionAntigua(Establecimiento estableci) {
		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu).append(" ").append(esnolo).append(" ")
				.append(esnodir).append(" ").append(esnrcopo);
		return direccionAntiguaCompleta.toString();
	}

	/**
	 * Metodo para cargar el objeto DatosPersona con la informacin del
	 * interviniente
	 * 
	 * @param datosPersona
	 *            DatosPersona
	 * @param saninterv
	 *            Saninterv
	 */
	public DatosPersona cargarDatosPersona(Saninterv saninterv) {

		DatosPersona datosPersona = new DatosPersona();

		datosPersona.setDni(saninterv.getUanif().trim());
		datosPersona.setNombre(saninterv.getUanombre());
		datosPersona.setMail(saninterv.getUacoem());
		datosPersona.setTelefono(saninterv.getUanrtel());

		datosPersona.setDni(saninterv.getUanif().trim().toUpperCase());
		datosPersona.setNombre(StringEscapeUtils.escapeHtml(saninterv.getUanombre()));

		if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
			datosPersona.setApellido1(StringEscapeUtils.escapeHtml(saninterv.getUaapellido1()));

			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				datosPersona.setApellido1(StringEscapeUtils.escapeHtml(new StringBuffer(saninterv.getUaapellido1())
						.append(" ").append(saninterv.getUaapellido2()).toString()));
			}
		}

		if (Y41bUtils.isFilled(saninterv.getUacoem())) {
			datosPersona.setMail(saninterv.getUacoem());
		}
		if (Y41bUtils.isFilled(saninterv.getUanrtel())) {
			datosPersona.setTelefono(saninterv.getUanrtel());
		}
		datosPersona.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));

		return datosPersona;
	}
}
