package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.*;
import com.ejie.y41b.model.platea.DatosPersona;

/**
 * SanintervService  
 * 
 *  
 */

public interface SanintervService {

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv add(Saninterv saninterv);

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv update(Saninterv saninterv);

	/**
	 * Finds a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv find(Saninterv saninterv);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Saninterv> findAll(Saninterv saninterv, Pagination pagination);

	/**
	 * Counts rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Long
	 */
	Long findAllCount(Saninterv saninterv);

	/**
	 * Finds rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Saninterv> findAllLike(Saninterv saninterv, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Saninterv saninterv, Boolean startsWith);

	/**
	 * Deletes a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return
	 */
	void remove(Saninterv saninterv);

	/**
	 * Deletes multiple rows in the Saninterv table.
	 * 
	 * @param sanintervList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Saninterv> sanintervList);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAllIntervinientes(Intervinientes saninterv,
			Pagination pagination);

	// EVOLUTIVO 0135083 2.2
	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAllIntervinientesConCIF(Intervinientes saninterv,
			Pagination pagination);

	// EVOLUTIVO 0135083 2.2

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameLineaDireccion(Saninterv saninterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameLocalidad(Saninterv saninterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameMunicipio(Saninterv saninterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameProvincia(Saninterv saninterv);

	/**
	 * Dame direccion completa.
	 * 
	 * @param saninterv
	 *            the saninterv
	 * @return the string
	 */
	public String dameCodigoPostal(Saninterv saninterv);

	List<Saninterv> findAllCombo(Saninterv interviniente, Pagination pagination);

	/**
	 * Dame sancionado.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return the saninterv
	 */
	public Saninterv dameSancionado(String excodigo);

	/**
	 * Metodo para recoger los datos de la tabla Saninterv especificando el
	 * identificativo
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return SanintervDetalle
	 */
	SanintervDetalle findEstSancion(Saninterv saninterv);

	/**
	 * 
	 * @param interviniente
	 *            Saninterv
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findEstablecimiento(Saninterv interviniente);

	/**
	 * Metodo para cargar el objeto DatosPersona con la informacin del
	 * interviniente
	 * 
	 * @param datosPersona
	 *            DatosPersona
	 * @param saninterv
	 *            Saninterv
	 */
	DatosPersona cargarDatosPersona(Saninterv saninterv);

}
