package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanfracsipcaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanfracsipca;

/**
 * SanfracsipcaServiceImpl  
 * 
 *  
 */

@Service(value = "sanfracsipcaService")
public class SanfracsipcaServiceImpl implements SanfracsipcaService {

	@Autowired()
	private SanfracsipcaDao sanfracsipcaDao;

	/**
	 * Inserts a single row in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Sanfracsipca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanfracsipca add(Sanfracsipca sanfracsipca) {
		return this.sanfracsipcaDao.add(sanfracsipca);
	}

	/**
	 * Updates a single row in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Sanfracsipca
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanfracsipca update(Sanfracsipca sanfracsipca) {
		return this.sanfracsipcaDao.update(sanfracsipca);
	}

	/**
	 * Finds a single row in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Sanfracsipca
	 */
	public Sanfracsipca find(Sanfracsipca sanfracsipca) {
		return (Sanfracsipca) this.sanfracsipcaDao.find(sanfracsipca);
	}

	/**
	 * Finds a List of rows in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanfracsipca> findAll(Sanfracsipca sanfracsipca,
			Pagination pagination) {
		return (List<Sanfracsipca>) this.sanfracsipcaDao.findAll(sanfracsipca,
				pagination);
	}

	/**
	 * Counts rows in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return Long
	 */
	public Long findAllCount(Sanfracsipca sanfracsipca) {
		return this.sanfracsipcaDao.findAllCount(sanfracsipca);
	}

	/**
	 * Finds rows in the Sanfracsipca table using like.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanfracsipca> findAllLike(Sanfracsipca sanfracsipca,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanfracsipca>) this.sanfracsipcaDao.findAllLike(
				sanfracsipca, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanfracsipca table using like.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanfracsipca sanfracsipca, Boolean startsWith) {
		return this.sanfracsipcaDao.findAllLikeCount(sanfracsipca, startsWith);
	}

	/**
	 * Deletes a single row in the Sanfracsipca table.
	 * 
	 * @param sanfracsipca
	 *            Sanfracsipca
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanfracsipca sanfracsipca) {
		this.sanfracsipcaDao.remove(sanfracsipca);
	}

	/**
	 * Deletes multiple rows in the Sanfracsipca table.
	 * 
	 * @param sanfracsipcaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanfracsipca> sanfracsipcaList) {
		for (Sanfracsipca sanfracsipcaAux : sanfracsipcaList) {
			this.sanfracsipcaDao.remove(sanfracsipcaAux);
		}
	}

}
