package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SanfraccDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.y41b.model.Sanfracc;

/**
 * SanfraccServiceImpl  
 * 
 *  
 */

@Service(value = "sanfraccService")
public class SanfraccServiceImpl implements SanfraccService {

	@Autowired()
	private SanfraccDao sanfraccDao;

	/**
	 * Inserts a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanfracc add(Sanfracc sanfracc) {
		return this.sanfraccDao.add(sanfracc);
	}

	/**
	 * Updates a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanfracc update(Sanfracc sanfracc) {
		return this.sanfraccDao.update(sanfracc);
	}

	/**
	 * Finds a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	public Sanfracc find(Sanfracc sanfracc) {
		return (Sanfracc) this.sanfraccDao.find(sanfracc);
	}

	/**
	 * Finds a List of rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanfracc> findAll(Sanfracc sanfracc, Pagination pagination) {
		return (List<Sanfracc>) this.sanfraccDao.findAll(sanfracc, pagination);
	}

	/**
	 * Counts rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Long
	 */
	public Long findAllCount(Sanfracc sanfracc) {
		return this.sanfraccDao.findAllCount(sanfracc);
	}

	/**
	 * Finds rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanfracc> findAllLike(Sanfracc sanfracc, Pagination pagination,
			Boolean startsWith) {
		return (List<Sanfracc>) this.sanfraccDao.findAllLike(sanfracc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanfracc sanfracc, Boolean startsWith) {
		return this.sanfraccDao.findAllLikeCount(sanfracc, startsWith);
	}

	/**
	 * Deletes a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanfracc sanfracc) {
		this.sanfraccDao.remove(sanfracc);
	}

	/**
	 * Deletes multiple rows in the Sanfracc table.
	 * 
	 * @param sanfraccList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanfracc> sanfraccList) {
		for (Sanfracc sanfraccAux : sanfraccList) {
			this.sanfraccDao.remove(sanfraccAux);
		}
	}

}
