package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DecisionHechoDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanexprelServiceImpl  
 * 
 *  
 */

@Service(value = "sanexprelService")
public class SanexprelServiceImpl implements SanexprelService {

	@Autowired()
	private SanexprelDao sanexprelDao;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private SoltramexpService soltramexpService;
	@Autowired()
	private HechoDenunciadoDao hechodenunciadoDao;
	@Autowired()
	private SanintervDao sanintervDao;
	@Autowired()
	private TramiteHechoDao tramiteHechoDao;
	@Autowired()
	private DecisionHechoDao decisionHechoDao;

	/**
	 * Inserts a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanexprel add(Sanexprel sanexprel) {
		return this.sanexprelDao.add(sanexprel);
	}

	/**
	 * Updates a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanexprel update(Sanexprel sanexprel) {
		return this.sanexprelDao.update(sanexprel);
	}

	/**
	 * Finds a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	public Sanexprel find(Sanexprel sanexprel) {
		return (Sanexprel) this.sanexprelDao.find(sanexprel);
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanexprel> findAll(Sanexprel sanexprel, Pagination pagination) {
		if (pagination != null) {
			if ("excodigo".equals(pagination.getSort())) {
				pagination.setSort("CODEXPCOMPLETO");
			} else if ("tipoProcedimiento.pnombre".equals(pagination.getSort())) {
				pagination.setSort("PNOMBRE");
			} else if ("tipoProcedimiento.pnombree"
					.equals(pagination.getSort())) {
				pagination.setSort("PNOMBREE");
			} else if ("instructor".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("codCompleto1".equals(pagination.getSort())) {
				pagination.setSort("CODEXPCOMPLETO");
			} else if ("rlesorig1".equals(pagination.getSort())) {
				pagination.setSort("RLESORIG");
			} else if ("codCompleto".equals(pagination.getSort())) {
				pagination.setSort("CODEXPCOMPLETO");
			}
		}
		return (List<Sanexprel>) this.sanexprelDao.findAll(sanexprel,
				pagination);
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoProcedimiento> findAllTipoProcExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination) {
		return (List<TipoProcedimiento>) this.sanexprelDao
				.findAllTipoProcExpedientesRelacionados2(sanexprel, pagination);
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanexprel> findAllNumExpedientesExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination) {
		return (List<Sanexprel>) this.sanexprelDao
				.findAllNumExpedientesExpedientesRelacionados2(sanexprel,
						pagination);
	}

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	public Long findAllCount(Sanexprel sanexprel) {
		return this.sanexprelDao.findAllCount(sanexprel);
	}

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	public Long findSancionadorRelacionadoSolicitudesCount(Sanexprel sanexprel) {
		return this.sanexprelDao
				.findSancionadorRelacionadoSolicitudesCount(sanexprel);
	}

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findSancionadorRelacionadoInspeccionesCount(
			Sanexprel sanexprel, Establecimiento establecimiento) {
		return this.sanexprelDao.findSancionadorRelacionadoInspeccionesCount(
				sanexprel, establecimiento);
	}

	/**
	 * Finds rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanexprel> findAllLike(Sanexprel sanexprel,
			Pagination pagination, Boolean startsWith) {
		return (List<Sanexprel>) this.sanexprelDao.findAllLike(sanexprel,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanexprel sanexprel, Boolean startsWith) {
		return this.sanexprelDao.findAllLikeCount(sanexprel, startsWith);
	}

	/**
	 * Deletes a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanexprel sanexprel, CensoMonitor censoMonitor)
			throws Exception {
		Sanexprel sanexprelBD = this.sanexprelDao.find(sanexprel);

		Sanexprel sanexprelBDAux = new Sanexprel();
		sanexprelBDAux.setRlhdcodrel(sanexprelBD.getRlhdcodigo());
		sanexprelBDAux.setRlarbcodigo(sanexprelBD.getRlarbcodrel());

		Expedien expedien = new Expedien();
		expedien.setExcodigo(sanexprelBD.getRlexcodrel());
		sanexprelBDAux.setExpedienByRlexcodigo(expedien);

		sanexprelBDAux = this.sanexprelDao.findRel(sanexprelBDAux);

		if (sanexprelBDAux == null
				&& (Y41bUtils.esNullOCadenaVacia(sanexprelBD.getRlesorig()) || Y41bConstantes.TIPO_SAN_EXPREL_OTROS
						.equals(sanexprelBD.getRlesorig()))) {
			this.sanexprelDao.remove(sanexprelBD);

		} else if (Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN.equals(sanexprelBD
				.getRlesorig())
				&& ((sanexprelBD.getRlinscodigo() != null && sanexprelBD
						.getRlhdcodrel() != null) || (sanexprelBD
						.getRlhdcodigo() != null && sanexprelBD
						.getRlinscodrel() != null))) {
			// Comprobamos que es de tipo Origen y que el origen y el destino
			// sea solicitudes o inspecciones
			throw new Y41bUDAException(
					"error.solicitud.expedientesRelacionadosOrigen", true,
					new Exception());

		} else if (sanexprelBDAux != null
				&& Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN.equals(sanexprelBDAux
						.getRlesorig())
				&& ((sanexprelBDAux.getExpedienByRlexcodigo() != null
						&& sanexprelBDAux.getExpedienByRlexcodigo()
								.getExcodigo() != null && !""
						.equals(sanexprelBDAux.getExpedienByRlexcodigo()
								.getExcodigo())) || (sanexprelBDAux
						.getRlarbcodigo() != null && !"".equals(sanexprelBDAux
						.getRlarbcodigo())))) {
			// Comprobamos que no es de tipo Origen ni tiene codigos de
			// expediente sancionador / arbitraje
			// relacionados.
			throw new Y41bUDAException(
					"error.solicitud.expedientesRelacionados", true,
					new Exception());

		} else {
			// Borramos la relacion del sancionador
			this.sanexprelDao.remove(sanexprelBD);
			if (sanexprelBD.getRlhdcodrel() != null) {
				// Actualizamos el consumidor origen como consumidor si no est
				// en otra relacin del sancionador
				boolean actualizarInteresado = true;
				// Buscamos el consumidor de la solicitud borrada
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setHdcodigo(sanexprelBD.getRlhdcodrel());
				hechodenunciado = this.hechodenunciadoDao.find(hechodenunciado);
				String interesado = hechodenunciado.getHdinteresado();
				String tipoInterviniente = hechodenunciado
						.getHdtipodenunciante();
				// Buscamos solicitudes relacionadas con el sancionador
				Sanexprel sanexprelConsumidor = new Sanexprel();
				sanexprelConsumidor.setExpedienByRlexcodigo(sanexprelBD
						.getExpedienByRlexcodigo());
				List<Sanexprel> lsanexprelConsumidor = this.sanexprelDao
						.findAll(sanexprelConsumidor, null);

				HechoDenunciado hechoDenunciadoAux = new HechoDenunciado();
				for (int i = 0; i < lsanexprelConsumidor.size(); i++) {
					sanexprelConsumidor = lsanexprelConsumidor.get(i);
					// Buscamos si el
					if ((Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN
							.equals(sanexprelConsumidor.getRlesorig()) || Y41bConstantes.TIPO_SAN_EXPREL_ACUMULADO
							.equals(sanexprelConsumidor.getRlesorig()))) {
						if (sanexprelConsumidor.getRlhdcodrel() != sanexprelBD
								.getRlhdcodrel()) {
							hechoDenunciadoAux.setHdcodigo(sanexprelConsumidor
									.getRlhdcodrel());
							hechoDenunciadoAux = this.hechodenunciadoDao
									.find(hechoDenunciadoAux);
							if (hechoDenunciadoAux != null
									&& hechoDenunciadoAux.getHdinteresado() != null
									&& hechoDenunciadoAux.getHdinteresado()
											.equals(interesado)) {
								actualizarInteresado = false;
								break;
							}
						}
					}
				}
				if (actualizarInteresado) {
					Saninterv saninterv = new Saninterv();
					saninterv
							.setExpedien(sanexprelBD.getExpedienByRlexcodigo());
					// Consumidor
					if (tipoInterviniente == null) {
						saninterv.setUadtcodigo(interesado);
					} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS
							.equals(tipoInterviniente)) {
						saninterv.setUaescodigo(interesado);
					} else {
						saninterv.setUaentidad_id(interesado);
					}

					// Borramos el interviniente porque no esta en ninguna
					// solicitud origen/acumulada
					try {
						List<Saninterv> lsaninterv = this.sanintervDao.findAll(
								saninterv, null);
						if (lsaninterv != null && lsaninterv.size() > 0) {
							this.sanintervDao.remove(lsaninterv.get(0));
						}
					} catch (DataIntegrityViolationException e) {
						// Si falla, es porque existe algun tramite con el
						// interviniente en uso. Actualizamos el tipo
						// Consumidor
						if (tipoInterviniente == null) {
							saninterv
									.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
							this.sanintervDao
									.updateTipointerviniente(
											saninterv,
											Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
						} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS
								.equals(tipoInterviniente)) {
							saninterv
									.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO);
							this.sanintervDao
									.updateTipointerviniente(
											saninterv,
											Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO);
						} else {
							saninterv
									.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS);
							this.sanintervDao.updateTipointerviniente(
									saninterv,
									Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS);
						}
					}
				}
				// Creamos tramite generico
				TramiteGenerico tramiteGenerico = new TramiteGenerico();
				tramiteGenerico.setIdExpediente(sanexprelBD.getRlhdcodrel());
				tramiteGenerico.setFechaInicio(new Date());
				tramiteGenerico.setInstructorAsignado(censoMonitor);
				String[] args = new String[2];
				args[0] = sanexprel.getCodCompleto();
				args[1] = sanexprel.getExpedienByRlexcodigo().getcodCompleto();
				tramiteGenerico.setComentario(this.appMessageSource.getMessage(
						"tramite.anulacionAperturaSancionComentario", args,
						LocaleContextHolder.getLocale()));
				String literalNombreTramite = "tramite.anulacionAperturaSancion";
				this.soltramexpService.addTramiteGenericoAutomatico(
						tramiteGenerico, literalNombreTramite);
				// Borramos la relacion de la solicitud
				Sanexprel sanexprelSol = new Sanexprel();
				sanexprelSol.setRlhdcodigo(sanexprelBD.getRlhdcodrel());
				sanexprelSol.setRlexcodrel(sanexprelBD
						.getExpedienByRlexcodigo().getExcodigo());
				List<Sanexprel> listasanexprelSol = this.sanexprelDao.findAll(
						sanexprelSol, null);
				if (listasanexprelSol != null && listasanexprelSol.size() > 0) {
					sanexprelSol = listasanexprelSol.get(0);
				}
				this.sanexprelDao.remove(sanexprelSol);
				// Recrear el registro de propuesta de sancionador
				// si en la solicitud existe referencia a la propuesta de
				// sancionador,
				// no existe trmite genrico de rechazo (se localiza por
				// contenido del campo comentario)
				// y no existe relacin de origen o acumulado en otro
				// sancionador
				boolean hayDecisionPropSan = false;
				boolean noExisteRechazo = true;
				boolean noExisteOrigenAcumuladoEnSancionador = true;

				DecisionHechoDetalle decisionHecho = new DecisionHechoDetalle();
				decisionHecho.setHdcodigo(sanexprelBD.getRlhdcodrel());
				decisionHecho = this.decisionHechoDao
						.findDecisionHecho(decisionHecho);
				if (("ARES".equals(decisionHecho.getDecodigo()))
						|| Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA
								.equals(decisionHecho.getDecodigo())
						|| Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA
								.equals(decisionHecho.getDecodigo())
						|| Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION
								.equals(decisionHecho.getDecodigo())) {
					hayDecisionPropSan = true;
				}

				TramiteHecho tramitehechoRechazo = new TramiteHecho();
				tramitehechoRechazo.setEhcohd(sanexprelBD.getRlhdcodrel());
				tramitehechoRechazo.setEhcotee(Y41bConstantes.TRAMITE_GENERICO);
				List<TramiteHecho> lista = this.tramiteHechoDao.findAll(
						tramitehechoRechazo, null);
				StringBuffer texto = new StringBuffer();
				texto.append(this.appMessageSource.getMessage(
						"propuesta.rechazo", null, new Locale(
								Y41bConstantes.CASTELLANO)));
				texto.append(" / ");
				texto.append(this.appMessageSource.getMessage(
						"propuesta.rechazo", null, new Locale(
								Y41bConstantes.EUSKERA)));
				for (int i = 0; i < lista.size(); i++) {
					tramitehechoRechazo = lista.get(i);
					if (tramitehechoRechazo.getEhnombretramite().equals(
							texto.toString())) {
						noExisteRechazo = false;
						break;
					}
				}

				Sanexprel sanexprelAux = new Sanexprel();
				sanexprelAux.setRlhdcodrel(sanexprelBD.getRlhdcodrel());
				List<Sanexprel> listaSanexprel = this.sanexprelDao.findAll(
						sanexprelAux, null);
				for (int i = 0; i < listaSanexprel.size(); i++) {
					sanexprelAux = listaSanexprel.get(i);
					if (Y41bConstantes.VALOR_SI.equals(sanexprelAux
							.getRlesorig())
							|| "A".equals(sanexprelAux.getRlesorig())) {
						noExisteOrigenAcumuladoEnSancionador = false;
						break;
					}
				}
				if (hayDecisionPropSan && noExisteRechazo
						&& noExisteOrigenAcumuladoEnSancionador) {
					TramiteHecho tramitehecho = new TramiteHecho();
					tramitehecho.setEhcohd(sanexprelBD.getRlhdcodrel());
					this.soltramexpService
							.tratamientoBandejaPropuestaSancion(tramitehecho);
				}

			}

		}
	}

	/**
	 * Deletes multiple rows in the Sanexprel table.
	 * 
	 * @param sanexprelList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanexprel> sanexprelList) {
		for (Sanexprel sanexprelAux : sanexprelList) {
			this.sanexprelDao.remove(sanexprelAux);
		}
	}

}
