package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * SanexprelService  
 * 
 *  
 */

public interface SanexprelService {

	/**
	 * Inserts a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	Sanexprel add(Sanexprel sanexprel);

	/**
	 * Updates a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	Sanexprel update(Sanexprel sanexprel);

	/**
	 * Finds a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Sanexprel
	 */
	Sanexprel find(Sanexprel sanexprel);

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanexprel> findAll(Sanexprel sanexprel, Pagination pagination);

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	Long findAllCount(Sanexprel sanexprel);

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	public Long findSancionadorRelacionadoSolicitudesCount(Sanexprel sanexprel);

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findSancionadorRelacionadoInspeccionesCount(
			Sanexprel sanexprel, Establecimiento establecimiento);

	/**
	 * Finds rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanexprel> findAllLike(Sanexprel sanexprel, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanexprel sanexprel, Boolean startsWith);

	/**
	 * Deletes a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 * @throws Exception
	 *             Exception
	 */
	void remove(Sanexprel sanexprel, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Deletes multiple rows in the Sanexprel table.
	 * 
	 * @param sanexprelList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Sanexprel> sanexprelList);

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoProcedimiento> findAllTipoProcExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination);

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanexprel> findAllNumExpedientesExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination);

}
