/*
 * 
 */
package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.DtsaDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PagosDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanexpDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Dtsa;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteSANDetalle;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bNumberToLetterConverter;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * SanexpServiceImpl  
 * 
 *  
 */

@Service(value = "sanexpService")
public class SanexpServiceImpl implements SanexpService {

	private final static Logger logger = LoggerFactory.getLogger(SanexpServiceImpl.class);

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private SanexpDao sanexpDao;

	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;

	@Autowired()
	private ExpedienDao expedienDao;

	@Autowired()
	private ConsumidorDao consumidorDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private InfraccHechoDenDao infraccHechoDenDao;

	@Autowired()
	private RepresentantesService representantesService;

	@Autowired()
	private SantramexpDao santramexpDao;

	@Autowired()
	private SandoctempDao sandoctempDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	@Autowired()
	private SanexprelDao sanexprelDao;

	@Autowired()
	private TramiteDao tramiteDao;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private SedeService sedeService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private PagosDao pagosDao;

	@Autowired()
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;

	@Autowired()
	private EstablecimientoService establecimientoService;

	@Autowired()
	private DatosMailSedeDao datosMailSedeDao;

	@Autowired()
	private HechoDenunciadoDao hechodenunciadoDao;
	@Autowired()
	private DtsaDao dtsaDao;

	/**
	 * Inserts a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanexp add(Sanexp sanexp) {
		return this.sanexpDao.add(sanexp);
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanexp update(Sanexp sanexp) {
		return this.sanexpDao.update(sanexp);
	}

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	public Sanexp find(Sanexp sanexp) {
		Sanexp sanexp2 = this.sanexpDao.find(sanexp);

		if (sanexp2 != null) {
			Sanexp sanexpaux = this.sanexpDao.findLobTablaTemporal(sanexp2);
			if (sanexpaux != null) {
				sanexp2.setHdte(sanexpaux.getHdte());
			}
		}
		return sanexp2;
	}

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanexp> findAll(Sanexp sanexp, Pagination pagination) {
		return (List<Sanexp>) this.sanexpDao.findAll(sanexp, pagination);
	}

	/**
	 * Counts rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Long
	 */
	public Long findAllCount(Sanexp sanexp) {
		return this.sanexpDao.findAllCount(sanexp);
	}

	/**
	 * Finds rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanexp> findAllLike(Sanexp sanexp, Pagination pagination, Boolean startsWith) {
		return (List<Sanexp>) this.sanexpDao.findAllLike(sanexp, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanexp sanexp, Boolean startsWith) {
		return this.sanexpDao.findAllLikeCount(sanexp, startsWith);
	}

	/**
	 * Deletes a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanexp sanexp) {
		this.sanexpDao.remove(sanexp);
	}

	/**
	 * Deletes multiple rows in the Sanexp table.
	 * 
	 * @param sanexpList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanexp> sanexpList) {
		for (Sanexp sanexpAux : sanexpList) {
			this.sanexpDao.remove(sanexpAux);
		}
	}

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	public Sanexp dameDetallesExpediente(Sanexp sanexp) {
		return (Sanexp) this.sanexpDao.dameDetallesExpediente(sanexp);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	private String findPlantilla(PlantillaTramite plantillaTramite, TramiteComun tramiteComun) throws Exception {

		// Obtener la plantilla del tramite
		PlantillaTramite plantillaTramite2 = this.plantillaTramiteDao.find(plantillaTramite);

		// Obtener los datos de la sancion
		PlantillaTramiteSANDetalle plantillaTramiteSANDetalle = new PlantillaTramiteSANDetalle();
		plantillaTramiteSANDetalle.setExcodigo(tramiteComun.getIdExpediente());

		// Obtener los datos del tramite
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(tramiteComun.getIdTramite());
		santramexp = this.santramexpDao.find(santramexp);
		if (santramexp != null) {
			plantillaTramiteSANDetalle.setSantramexp(santramexp);
		}

		String ficheroGenerado = "";
		if (plantillaTramite2.getPtplantilla() != null) {
			plantillaTramiteSANDetalle = this.completeInfoplantillaTramiteSANDetalle(plantillaTramiteSANDetalle);

			// Transformar el documento en castellano
			String plantilla = Y41bUtils.blobToString(plantillaTramite2.getPtplantilla());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

			rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_SAN_CASTELLANO);

			ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
					plantillaTramiteSANDetalle, plantilla);
		}

		return ficheroGenerado;
	}

	/**
	 * Complete information of the object plantillaTramiteSANDetalle.
	 * 
	 * @param plantillaTramiteSANDetalle
	 *            PlantillaTramiteSANDetalle
	 * @return PlantillaTramiteSANDetalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private PlantillaTramiteSANDetalle completeInfoplantillaTramiteSANDetalle(
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {

		try {
			// Expediente
			Expedien expedien = new Expedien();
			expedien.setExcodigo(plantillaTramiteSANDetalle.getExcodigo());
			expedien = this.expedienDao.find(expedien);
			plantillaTramiteSANDetalle.setExcoor(expedien.getExcoor());
			plantillaTramiteSANDetalle.setExnror(expedien.getExnror());
			plantillaTramiteSANDetalle.setExnran(expedien.getExnran());
			StringBuffer numeroExpediente = new StringBuffer();
			numeroExpediente.append(expedien.getExcoor()).append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP)
					.append(expedien.getExnror()).append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP)
					.append(expedien.getExnran());
			// Incidencia 74262 - Con Caracter general todos los impresos deben
			// incluir el cdigo de procedimiento en el cdigo de expediente
			plantillaTramiteSANDetalle.setNumExpediente(Y41bConstantes.TIPO_PROC_SANCIONES
					+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + numeroExpediente.toString());
			plantillaTramiteSANDetalle.setNumExpedienteCompleto(Y41bConstantes.TIPO_PROC_SANCIONES
					+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + numeroExpediente.toString());

			// Expediente sancionador
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(plantillaTramiteSANDetalle.getExcodigo());
			sanexp = this.sanexpDao.find(sanexp);

			Sanexp sanexpAux = this.sanexpDao.findLobTablaTemporal(sanexp);
			if (sanexpAux != null) {
				plantillaTramiteSANDetalle.setHdte(sanexpAux.getHdte());
			}

			// Fecha
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				plantillaTramiteSANDetalle.setFechaTexto(Y41bUtils.formatearDateToStringEuskera(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			} else {
				plantillaTramiteSANDetalle.setFechaTexto(Y41bUtils.formatearDateToString(new Date(),
						Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			}
			plantillaTramiteSANDetalle.setFechaTextoCas(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFechaTextoEus(Y41bUtils.formatearDateToStringEuskera(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			plantillaTramiteSANDetalle.setFecha(Y41bUtils.parseDateToString(new Date(), idioma));
			plantillaTramiteSANDetalle.setFechaCas(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFechaEus(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.EUSKERA));

			// Organismo
			this.rellenaOrganismo(expedien, plantillaTramiteSANDetalle);

			this.rellenaPieOficina(expedien, plantillaTramiteSANDetalle);
			// 0154940: Actualizacin de datos explcitos en plantillas a uso de
			// campos
			// combinados
			this.rellenaCentralPieOficina(expedien, plantillaTramiteSANDetalle);
			// 0154940
			this.rellenaExpedienteRelacionado(expedien, plantillaTramiteSANDetalle);

			// Instructor
			CensoMonitor censoMonitor = new CensoMonitor();
			if (expedien.getExcoit() != null) {
				censoMonitor.setMocodigo(expedien.getExcoit());
				censoMonitor = this.censoMonitorDao.find(censoMonitor);
				plantillaTramiteSANDetalle.setInstructor(censoMonitor.getMonombre());

				// FECHA DE RESOLUCION DEL INSTRUCTOR
				Parametros parametrosFecResolucionMonitor = new Parametros();
				parametrosFecResolucionMonitor.setParametro(
						Y41bConstantes.PARAMETRO_SANCIONES_FECHA_RESOLUCION_INSTRUCTOR + censoMonitor.getMocodigo());
				parametrosFecResolucionMonitor = this.parametrosDao.find(parametrosFecResolucionMonitor);
				if (parametrosFecResolucionMonitor != null) {
					String fechaResolucion = parametrosFecResolucionMonitor.getValor();
					Date fechaResolucionDate = new SimpleDateFormat("dd/MM/yyyy").parse(fechaResolucion);

					plantillaTramiteSANDetalle
							.setFECRESOLUCIONINSTCAS(Y41bUtils.formatearDateToString(fechaResolucionDate,
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteSANDetalle.setFECRESOLUCIONINSTEUS(Y41bUtils.formatearDateToStringEuskera(
							fechaResolucionDate, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
				}
			}

			// Ejecutor, censoMonitor que crea el tramite todav�a sin tramitar
			CensoMonitor censoMonitorEj = new CensoMonitor();
			censoMonitorEj.setMocodigo(plantillaTramiteSANDetalle.getSantramexp().getCensoMonitor().getMocodigo());
			censoMonitorEj = this.censoMonitorDao.find(censoMonitorEj);
			plantillaTramiteSANDetalle.setEjecutor(censoMonitorEj.getMonombre());

			this.rellenaDirector(expedien, plantillaTramiteSANDetalle);

			this.rellenaResponsable(expedien, plantillaTramiteSANDetalle);

			// SI NOTIFICO A SEDE
			if (plantillaTramiteSANDetalle.getSantramexp().getTrsede() != null) {
				if (plantillaTramiteSANDetalle.getSantramexp().getTrsede().equals(Y41bConstantes.SI)) {
					this.rellenaSedeSancionado(expedien, plantillaTramiteSANDetalle);
				} else {
					this.rellenaSancionado(expedien, plantillaTramiteSANDetalle);
				}
			} else {
				this.rellenaSancionado(expedien, plantillaTramiteSANDetalle);
			}
			// Destinatario
			if (plantillaTramiteSANDetalle.getSantramexp().getTrsede() != null) {
				if (plantillaTramiteSANDetalle.getSantramexp().getTrsede().equals(Y41bConstantes.SI)) {
					this.rellenaSedeDestinatario(expedien, plantillaTramiteSANDetalle);
				} else {
					this.rellenaDestinatario(expedien, plantillaTramiteSANDetalle);
				}
			} else {
				this.rellenaDestinatario(expedien, plantillaTramiteSANDetalle);
			}

			this.rellenaArticulosInfringidos(expedien, plantillaTramiteSANDetalle);

			this.rellenaCalificacion(expedien, sanexp, plantillaTramiteSANDetalle);

			this.rellenaPropuestaResolucion(expedien, sanexp, plantillaTramiteSANDetalle);

			this.rellenaAcuerdoIncoacion(expedien, sanexp, plantillaTramiteSANDetalle);

			this.rellenaSolicitudReduccionProntoPago(expedien.getExcodigo(), plantillaTramiteSANDetalle);

			this.rellenaRequerimientoAcreditacionRepresentacion(expedien, plantillaTramiteSANDetalle);

			// FECACUSENOTIFICACION
			if (expedien.getExfenoai() != null) {
				plantillaTramiteSANDetalle.setFecAcuseNotificacion(Y41bUtils.formatearDateToString(
						expedien.getExfenoai(), Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFecAcuseNotificacionEus(Y41bUtils.formatearDateToStringEuskera(
						expedien.getExfenoai(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			// FECRECEPALEGACIONES
			plantillaTramiteSANDetalle
					.setFecRecepAlegaciones(Y41bUtils.parseDateToString(expedien.getExfecoal(), idioma));
			// FECASIGNAINSTRUCTOR
			plantillaTramiteSANDetalle
					.setFecAsignaInstructor(Y41bUtils.parseDateToString(expedien.getExfeacin(), idioma));

			// Plantilla resolucion
			// IMPORTESANCION
			// si existe el tramite de resolución busco el importe de la
			// sancion

			if (expedien.getExcamure() != null) {
				plantillaTramiteSANDetalle.setImporteSancion(
						Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(expedien.getExcamure().doubleValue()));
				try {
					plantillaTramiteSANDetalle.setTxtImporteSancion(
							Y41bNumberToLetterConverter.convertNumberToLetter(expedien.getExcamure().doubleValue()));
				} catch (Exception e) {
					plantillaTramiteSANDetalle.setTxtImporteSancion(null);
				}
			}
			if (expedien.getExferes() != null) {
				plantillaTramiteSANDetalle.setFecResolucion(Y41bUtils.parseDateToString(expedien.getExferes(), idioma));
				plantillaTramiteSANDetalle.setFECRESOLUCIONCAS(
						Y41bUtils.parseDateToString(expedien.getExferes(), Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECRESOLUCIONEUS(
						Y41bUtils.parseDateToString(expedien.getExferes(), Y41bConstantes.EUSKERA));
				plantillaTramiteSANDetalle.setFECRESOLUCIONTEXTOCAS(Y41bUtils.formatearDateToString(
						expedien.getExferes(), Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECRESOLUCIONTEXTOEUS(Y41bUtils.formatearDateToStringEuskera(
						expedien.getExferes(), Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			// si estoy en el tramite de resolucion y todavia no he guardado
			if ((plantillaTramiteSANDetalle.getSantramexp() != null)
					&& (Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
							.equals(plantillaTramiteSANDetalle.getSantramexp().getTrcodigo()))
					|| Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION
							.equals(plantillaTramiteSANDetalle.getSantramexp().getTrcodigo())) {
				if (plantillaTramiteSANDetalle.getSantramexp().getTrresoimporte() != null) {
					plantillaTramiteSANDetalle.setImporteSancion(Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(
							plantillaTramiteSANDetalle.getSantramexp().getTrresoimporte().doubleValue()));
					try {
						plantillaTramiteSANDetalle
								.setTxtImporteSancion(Y41bNumberToLetterConverter.convertNumberToLetter(
										plantillaTramiteSANDetalle.getSantramexp().getTrresoimporte().doubleValue()));
					} catch (Exception e) {
						plantillaTramiteSANDetalle.setTxtImporteSancion(null);
					}
				}
				plantillaTramiteSANDetalle.setFecResolucion(Y41bUtils
						.parseDateToString(plantillaTramiteSANDetalle.getSantramexp().getTrresofecha(), idioma));
			}

			// Plantilla Acreditacion Representacion
			// TRAMITE: INCOACION o PROPUESTA de RESOLUCION en funcion de la
			// existencia de fecha / fecha de notificacion de uno u otro
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS1("");
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS2("");
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS3("");
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS1("");
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS2("");
			plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS3("");

			StringBuffer strTramite = new StringBuffer("");
			Tramite tramite = new Tramite();
			if (plantillaTramiteSANDetalle.getFECPROPRESOLUCIONNOTIFCAS() != null
					|| plantillaTramiteSANDetalle.getFECPROPRESOLUCIONCAS() != null) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
				tramite = this.tramiteDao.find(tramite);
				if (Y41bConstantes.EUSKERA.equals(idioma)) {
					strTramite.append(tramite.getTrnombree());
				} else {
					strTramite.append(tramite.getTrnombre());
				}
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS1(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso1", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS2(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso2", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONCAS3(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso3", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS1(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso1", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS2(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso2", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteSANDetalle.setTEXTOSIPROPUESTARESOLUCIONEUS3(this.appMessageSource
						.getMessage("plantilla.requReprSiPropReso3", null, new Locale(Y41bConstantes.EUSKERA)));
			} else if (plantillaTramiteSANDetalle.getFECNOTIFACUERDOINCOACIONCAS() != null
					|| plantillaTramiteSANDetalle.getFecAcuerdoIncoacion() != null) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
				tramite = this.tramiteDao.find(tramite);
				if (Y41bConstantes.EUSKERA.equals(idioma)) {
					strTramite.append(tramite.getTrnombree());
				} else {
					strTramite.append(tramite.getTrnombre());
				}
			}
			plantillaTramiteSANDetalle.setTramite(strTramite.toString());

			// Plantilla Ampliacion alegaciones
			// FECACUERDOINCOACION (Más arriba se coge del expediente)
			// FECPROPRESOLUCION (Más arriba se coge del expediente)
			plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOCAS1("");
			plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOCAS2("");
			plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOEUS1("");
			plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOEUS2("");

			if (plantillaTramiteSANDetalle.getFecPropResolucion() != null) {
				plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOCAS1(this.appMessageSource
						.getMessage("plantilla.amplPlazSiPropReso1", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOCAS2(this.appMessageSource
						.getMessage("plantilla.amplPlazSiPropReso2", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOEUS1(this.appMessageSource
						.getMessage("plantilla.amplPlazSiPropReso1", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteSANDetalle.setTEXTOAMPLPLAZSIPROPRESOEUS2(this.appMessageSource
						.getMessage("plantilla.amplPlazSiPropReso2", null, new Locale(Y41bConstantes.EUSKERA)));
			}

			// DIASPLAZO
			if (plantillaTramiteSANDetalle.getSantramexp() != null) {
				plantillaTramiteSANDetalle
						.setDiasPlazo(Y41bUtils.trataNull(plantillaTramiteSANDetalle.getSantramexp().getTrnumDias()));
			}
			// FECAMPLIACION: Documento aportado de tipo y cogemos la fecha de
			// registro
			Date fechaAmpliacion = this.sandoctempDao.dameFechaAportacionDocumentacion(
					Y41bConstantes.TIPO_DOC_SAN_SOLICITUD_AMP_PLAZO, plantillaTramiteSANDetalle.getExcodigo());
			if (fechaAmpliacion != null) {
				plantillaTramiteSANDetalle
						.setFecAmpliacion(Y41bUtils.parseDateToString(fechaAmpliacion, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle
						.setFecAmpliacionEus(Y41bUtils.parseDateToString(fechaAmpliacion, Y41bConstantes.EUSKERA));
			}

			// FECRECEPSOLPRUCAS,FECRECEPSOLPRUEUS: Documento aportado de tipo y
			// cogemos la fecha de registro
			Date fechaSolicitudPrueba = this.sandoctempDao.dameFechaAportacionDocumentacion(
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUDPRUEBA,
					plantillaTramiteSANDetalle.getExcodigo());
			if (fechaSolicitudPrueba != null) {
				plantillaTramiteSANDetalle.setFECRECEPSOLPRUCAS(
						Y41bUtils.parseDateToString(fechaSolicitudPrueba, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECRECEPSOLPRUEUS(
						Y41bUtils.parseDateToString(fechaSolicitudPrueba, Y41bConstantes.EUSKERA));
			}

			// FECDENEGPRUEBACAS,FECDENEGPRUEBAEUS:
			Santramexp tramiteResolucionSolicitudPrueba = null;
			if ((plantillaTramiteSANDetalle.getSantramexp() != null) && (plantillaTramiteSANDetalle.getSantramexp()
					.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA))) {
				/* por si estoy en el propio tramite */
				tramiteResolucionSolicitudPrueba = plantillaTramiteSANDetalle.getSantramexp();
			} else {
				tramiteResolucionSolicitudPrueba = this.santramexpDao.dameTramitePorTipo(
						Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONSOLICITUDPRUEBA, expedien.getExcodigo());
			}
			if (tramiteResolucionSolicitudPrueba != null && tramiteResolucionSolicitudPrueba.getTrfecfin() != null) {
				plantillaTramiteSANDetalle.setFECDENEGPRUEBACAS(Y41bUtils
						.parseDateToString(tramiteResolucionSolicitudPrueba.getTrfecfin(), Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECDENEGPRUEBAEUS(Y41bUtils
						.parseDateToString(tramiteResolucionSolicitudPrueba.getTrfecfin(), Y41bConstantes.EUSKERA));
			}

			// FECRECDENEGPRUEBACAS,FECRECDENEGPRUEBAEUS: Documento aportado de
			// tipo y cogemos la fecha de registro
			Date fechaRecursoAceptacionDenegacionPrueba = this.sandoctempDao.dameFechaAportacionDocumentacion(
					Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO_ACEPTACION_DENEGACION,
					plantillaTramiteSANDetalle.getExcodigo());
			if (fechaRecursoAceptacionDenegacionPrueba != null) {
				plantillaTramiteSANDetalle.setFECRECDENEGPRUEBACAS(
						Y41bUtils.parseDateToString(fechaRecursoAceptacionDenegacionPrueba, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECRECDENEGPRUEBAEUS(
						Y41bUtils.parseDateToString(fechaRecursoAceptacionDenegacionPrueba, Y41bConstantes.EUSKERA));
			}

			Santramexp tramiteOrdenConsejero = null;
			if ((plantillaTramiteSANDetalle.getSantramexp() != null) && (plantillaTramiteSANDetalle.getSantramexp()
					.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO))) {
				/* por si estoy en el propio tramite */
				tramiteOrdenConsejero = plantillaTramiteSANDetalle.getSantramexp();
			} else {
				tramiteOrdenConsejero = this.santramexpDao.dameTramitePorTipo(
						Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO, expedien.getExcodigo());
			}
			if (tramiteOrdenConsejero != null) {
				plantillaTramiteSANDetalle.setFECORDENCONSEJEROCAS(
						Y41bUtils.parseDateToString(tramiteOrdenConsejero.getTrresofecha(), Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECORDENCONSEJEROEUS(
						Y41bUtils.parseDateToString(tramiteOrdenConsejero.getTrresofecha(), Y41bConstantes.EUSKERA));
				plantillaTramiteSANDetalle.setFECORDENCONSEJEROTEXTOCAS(
						Y41bUtils.formatearDateToString(tramiteOrdenConsejero.getTrresofecha(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle.setFECORDENCONSEJEROTEXTOEUS(
						Y41bUtils.formatearDateToStringEuskera(tramiteOrdenConsejero.getTrresofecha(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.EUSKERA));
				if (!Y41bUtils.esNullOCadenaVacia(tramiteOrdenConsejero.getTrestimacion())) {
					plantillaTramiteSANDetalle.setESTIMACIONORDENCONSEJEROCAS(this.appMessageSource.getMessage(
							"plantilla.estimacion" + tramiteOrdenConsejero.getTrestimacion(), null,
							new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteSANDetalle.setESTIMACIONORDENCONSEJEROEUS(this.appMessageSource.getMessage(
							"plantilla.estimacion" + tramiteOrdenConsejero.getTrestimacion(), null,
							new Locale(Y41bConstantes.EUSKERA)));
				}
			}

			Santramexp tramiteResolucion = null;
			if ((plantillaTramiteSANDetalle.getSantramexp() != null) && (plantillaTramiteSANDetalle.getSantramexp()
					.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION))) {
				tramiteResolucion = plantillaTramiteSANDetalle.getSantramexp();
			} else {
				tramiteResolucion = this.santramexpDao.dameTramitePorTipo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION,
						expedien.getExcodigo());
			}
			if (tramiteResolucion != null && tramiteResolucion.getTrresofecha() != null) {
				Date fechaResolucion = tramiteResolucion.getTrresofecha();
				plantillaTramiteSANDetalle
						.setFECRESOLUCIONCAS(Y41bUtils.parseDateToString(fechaResolucion, Y41bConstantes.CASTELLANO));
				plantillaTramiteSANDetalle
						.setFECRESOLUCIONEUS(Y41bUtils.parseDateToString(fechaResolucion, Y41bConstantes.EUSKERA));
			}

			this.rellenaFechaNotificacion(expedien, sanexp, plantillaTramiteSANDetalle);

			this.rellenaAlegaciones(expedien, plantillaTramiteSANDetalle);

			// Calendario SIPCA para Resolucion Complementaria
			if (plantillaTramiteSANDetalle.getSantramexp() != null
					&& Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA
							.equals(plantillaTramiteSANDetalle.getSantramexp().getTrcodigo().toString())) {
				Date fechaSolicitudFraccionamiento = this.sandoctempDao.dameFechaAportacionDocumentacion(
						Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_SOLICITUD_FRACCIONAMIENTO,
						plantillaTramiteSANDetalle.getExcodigo());
				if (fechaSolicitudPrueba != null) {
					plantillaTramiteSANDetalle.setFecsolfraccas(
							Y41bUtils.parseDateToString(fechaSolicitudFraccionamiento, Y41bConstantes.CASTELLANO));
					plantillaTramiteSANDetalle.setFecsolfraceus(
							Y41bUtils.parseDateToString(fechaSolicitudFraccionamiento, Y41bConstantes.EUSKERA));
				}
				if (plantillaTramiteSANDetalle.getSantramexp().getTrreferencia() != null) {
					this.generarTablaPlazos(plantillaTramiteSANDetalle);
				}
			}
			// EVOLUTIVO 0135083 2.4
			Santramexp tramiteRequerimientoInformacion = null;
			tramiteRequerimientoInformacion = plantillaTramiteSANDetalle.getSantramexp();
			if (Y41bConstantes.TRAMITE_SANCIONES_REQUERIMIENTOINFORMACION
					.equals(plantillaTramiteSANDetalle.getSantramexp().getTrcodigo())) {
				if (tramiteRequerimientoInformacion.getTrresumenalegaciones() != null) {
					plantillaTramiteSANDetalle.setDocReqEs(
							Y41bUtils.clobToString(tramiteRequerimientoInformacion.getTrresumenalegaciones()));
				}
				if (tramiteRequerimientoInformacion.getTrdocreqeus() != null) {
					plantillaTramiteSANDetalle
							.setDocReqEu(Y41bUtils.clobToString(tramiteRequerimientoInformacion.getTrdocreqeus()));
				}
			}
			if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION
					.equals(plantillaTramiteSANDetalle.getSantramexp().getTrcodigo())) {
				this.rellenaRecepcionRequerimientoInformacion(expedien, plantillaTramiteSANDetalle);
			}
			// EVOLUTIVO 0135083 2.4

			return plantillaTramiteSANDetalle;
		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Intervinientes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterv addInterviniente(Intervinientes intervinientes, CensoMonitor censoMonitor) {

		Saninterv sanintervAux = null;

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_CONSUMIDOR)) {
			sanintervAux = this.cargarIntervinienteConsumidor(intervinientes);

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_ESTABLECIMIENTO)) {
			sanintervAux = this.cargarIntervinienteEstablecimiento(intervinientes, censoMonitor);

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_OTROS)) {
			sanintervAux = this.cargarIntervinienteOrganismo(intervinientes);

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))) {

			sanintervAux = this.representantesService.cargarIntervinienteRepresentanteSAN(intervinientes);
		}

		return sanintervAux;
	}

	/**
	 * CargarIntervinienteConsumidor
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Saninterv
	 */
	private Saninterv cargarIntervinienteConsumidor(Intervinientes intervinientes) {
		Saninterv sanintervAux = new Saninterv();
		boolean insercion = false;
		String pais;
		Consumidor consumidor = new Consumidor();

		consumidor.setDtcodigo(intervinientes.getIdinterviniente());

		// Alta de interviniente consumidor
		consumidor = this.consumidorDao.find(consumidor);

		try {
			sanintervAux.setUadtcodigo(consumidor.getDtcodigo());
			sanintervAux.setExpedien(new Expedien(intervinientes.getIdExpediente()));
			List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(sanintervAux, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					sanintervAux = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			sanintervAux = null;
			insercion = true;
		}

		if (sanintervAux == null) {
			sanintervAux = new Saninterv();
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		sanintervAux.setExpedien(expedien);
		sanintervAux.setUanombre(consumidor.getDtnombre());
		sanintervAux.setUaapellido1(consumidor.getDtapellido1());
		sanintervAux.setUaapellido2(consumidor.getDtapellido2());
		sanintervAux.setUacoem(consumidor.getDttecoem());
		sanintervAux.setUanif(consumidor.getDtnif());
		sanintervAux.setUanrtel(consumidor.getDtnrtel());
		sanintervAux.setUanrtel2(consumidor.getDtnrtel2());
		sanintervAux.setUaprovId(consumidor.getDtnoraProvinciaId());
		sanintervAux.setUamunId(consumidor.getDtnoraMunicipioId());
		sanintervAux.setUalocId(consumidor.getDtnoraLocalidadId());
		sanintervAux.setUacalleId(consumidor.getDtnoraCalleId());
		// Este campo no se utiliza. Nora y no nora guarda el cp en
		// dtnombrecp
		// sanintervAux.setUacpId(consumidor.getDtnoraCpId());
		sanintervAux.setUacpId(consumidor.getDtnombreCp());
		sanintervAux.setUaportalId(consumidor.getDtnoraPortalId());
		sanintervAux.setUanombrePiso(consumidor.getDtnombrePiso());
		sanintervAux.setUadireNocapv(consumidor.getDtdireccion_nocapv());
		// En el censo la logica de estos campos esta cambiada.
		sanintervAux.setUanodir(consumidor.getDtnombrePiso());
		sanintervAux.setUadireAnt(consumidor.getDtnodir());
		sanintervAux.setUadtcodigo(consumidor.getDtcodigo());
		if (Y41bConstantes.SI.equals(consumidor.getDtextranjero())) {
			pais = consumidor.getDtnoraPaisId();
		} else {
			pais = Y41bConstantes.COD_PAIS_ESTADO;
		}
		sanintervAux.setUapaisId(pais);

		sanintervAux.setUafecultmod(consumidor.getDtfemod());
		sanintervAux.setUausuultmod(consumidor.getCensoMonitor().getMocodigo());
		sanintervAux.setUasexo(consumidor.getDtcosx());
		sanintervAux.setUaedad(consumidor.getRangoEdad().getRancod());
		sanintervAux.setUaidioma(consumidor.getDtcoidco());
		sanintervAux.setUatipoidentificacion(consumidor.getDtintipid());
		if (!insercion) {
			this.sanintervDao.update(sanintervAux);
		} else {
			sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			this.sanintervDao.add(sanintervAux);
		}
		return sanintervAux;
	}

	/**
	 * cargarIntervinienteEstablecimiento
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Saninterv
	 */
	private Saninterv cargarIntervinienteEstablecimiento(Intervinientes intervinientes, CensoMonitor censoMonitor) {
		Saninterv sanintervAux = null;
		boolean insercion = false;
		String pais;
		Establecimiento establecimiento = new Establecimiento();

		establecimiento.setEscodigo(intervinientes.getIdinterviniente());

		// Alta interviniente establecimiento
		establecimiento = this.establecimientoDao.find(establecimiento);

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(establecimiento);

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

		try {
			sanintervAux = new Saninterv();
			sanintervAux.setUaescodigo(intervinientes.getIdinterviniente());
			sanintervAux.setExpedien(new Expedien(intervinientes.getIdExpediente()));
			List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(sanintervAux, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					sanintervAux = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			sanintervAux = null;
			insercion = true;
		}
		Saninterv sanintervAux2 = new Saninterv();
		sanintervAux2.setExpedien(new Expedien(intervinientes.getIdExpediente()));
		sanintervAux2.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
		boolean existeSancionado = (this.sanintervDao.findAll(sanintervAux2, null).size() > 0);
		if (insercion && !existeSancionado) {
			establecimiento = this.tratamientoAnyadirIntervinienteSancionado(establecimiento);
		}
		if (sanintervAux == null) {
			sanintervAux = new Saninterv();
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		expedien.setSanexp(this.sanexpDao.find(expedien.getSanexp()));
		sanintervAux.setExpedien(expedien);
		sanintervAux.setUanombre(establecimiento.getEsnombre());
		sanintervAux.setUacoem(establecimiento.getEscoem());
		sanintervAux.setUanif(establecimiento.getEsnif());
		sanintervAux.setUanrtel(establecimiento.getEsnrtel());
		sanintervAux.setUanrtel2(establecimiento.getEsnrtel2());
		sanintervAux.setUaprovId(establecimiento.getEsnoraProvinciaId());
		sanintervAux.setUamunId(establecimiento.getEsnoraMunicipioId());
		sanintervAux.setUalocId(establecimiento.getEsnoraLocalidadId());
		sanintervAux.setUacalleId(establecimiento.getEsnoraCalleId());
		sanintervAux.setUacpId(establecimiento.getEsnombreCp());
		sanintervAux.setUaportalId(establecimiento.getEsnoraPortalId());
		sanintervAux.setUanombrePiso(establecimiento.getEsnombrePiso());
		sanintervAux.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
		// En el censo la logica de estos campos esta cambiada.
		sanintervAux.setUanodir(establecimiento.getEsnombrePiso());
		sanintervAux.setUadireAnt(establecimiento.getEsnodir());
		sanintervAux.setUaescodigo(intervinientes.getIdinterviniente());
		if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
			pais = establecimiento.getEsnoraPaisId();
		} else {
			pais = Y41bConstantes.COD_PAIS_ESTADO;
		}
		sanintervAux.setUapaisId(pais);

		sanintervAux.setUanopeco(establecimiento.getEsnopeco());
		sanintervAux.setUaurl(establecimiento.getEsteurl());
		sanintervAux.setUanoco(establecimiento.getEsnoco());
		sanintervAux.setUasecodigo(establecSector.getSector().getSecodigo());
		sanintervAux.setUasenombre(establecSector.getSector().getSenombre());
		sanintervAux.setUasenombree(establecSector.getSector().getSenombree());

		sanintervAux.setUafecultmod(establecimiento.getEsfemod());
		sanintervAux.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());
		sanintervAux.setUaidioma(establecimiento.getEscoidco());
		if (insercion) {
			if (existeSancionado) {
				sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO);
				this.sanintervDao.add(sanintervAux);
			} else {
				sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
				// INICIO: 0198881: Sancionador. Cambiar el canal de canal de
				// notificacion del sancionado a telematico
				if (Y41bUtils.isValidCIF(sanintervAux.getUanif())) {
					sanintervAux.setUaformanotificacion(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
				}
				// FIN: 0198881: Sancionador. Cambiar el canal de canal de
				// notificacion del sancionado a telematico
				this.sanintervDao.add(sanintervAux);
				this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sanintervAux, expedien.getExcodigo());
			}

		} else {
			// INICIO: 0198881: Sancionador. Cambiar el canal de canal de
			// notificacion del sancionado a telematico
			if (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equalsIgnoreCase(sanintervAux.getUatipointerv())
					&& Y41bUtils.isValidCIF(sanintervAux.getUanif())) {
				sanintervAux.setUaformanotificacion(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
			}
			// FIN: 0198881: Sancionador. Cambiar el canal de canal de
			// notificacion del sancionado a telematico
			this.sanintervDao.update(sanintervAux);

			// tengo que actualizar PLATEA mis gestiones!!!
			if (Y41bUtils.interactuarConDokusi() && expedien != null && expedien.getSanexp() != null) {
				if (Y41bConstantes.VALOR_SI.equals(expedien.getSanexp().getPlatea())) {

					this.actualizarParticipantPlatea(expedien, sanintervAux, censoMonitor, false);
				}
			}
		}
		return sanintervAux;
	}

	/**
	 * cargaIntervinienteOrganismo
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Saninterv
	 */
	private Saninterv cargarIntervinienteOrganismo(Intervinientes intervinientes) {
		Saninterv sanintervAux = null;
		boolean insercion = false;
		/*
		 * ORGANISMO
		 */
		Organismo organismo = new Organismo();
		organismo.setEntidadId(intervinientes.getIdinterviniente());
		organismo = this.organismoDao.findOrganismoById(organismo);

		try {
			sanintervAux = new Saninterv();
			sanintervAux.setUaentidad_id(intervinientes.getIdinterviniente());
			sanintervAux.setExpedien(new Expedien(intervinientes.getIdExpediente()));
			List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(sanintervAux, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					sanintervAux = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			sanintervAux = null;
			insercion = true;
		}

		if (sanintervAux == null) {
			sanintervAux = new Saninterv();
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		sanintervAux.setExpedien(expedien);
		sanintervAux.setUanombre(organismo.getNombreEs());
		// sanintervAux.setUacoem(establecimiento.getEscoem());
		sanintervAux.setUanif(organismo.getCif());
		sanintervAux.setUanrtel(organismo.getTelefono());
		sanintervAux.setUanrtel2(null);
		sanintervAux.setUaprovId(organismo.getNoraProvinciaId());
		sanintervAux.setUamunId(organismo.getNoraMunicipioId());
		sanintervAux.setUalocId(organismo.getNoraLocalidadId());
		sanintervAux.setUacalleId(organismo.getNoraCalleId());
		// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
		// nombrecp
		// sanintervAux.setUacpId(organismo.getNoraCpId());
		sanintervAux.setUacpId(organismo.getNombreCp());
		sanintervAux.setUaportalId(organismo.getNoraPortalId());
		sanintervAux.setUanombrePiso(organismo.getCompleDirec());
		if (organismo.getCompleDirec() != null && organismo.getCompleDirec().length() > Y41bConstantes.NUM_40) {
			sanintervAux.setUanombrePiso(organismo.getCompleDirec().substring(0, Y41bConstantes.NUM_40));
		} else {
			sanintervAux.setUanombrePiso(organismo.getCompleDirec());
		}
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
				|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
			sanintervAux.setUadireNocapv(organismo.getNombreCalle());
		}
		sanintervAux.setUadireAnt(organismo.getCompleDirec());
		sanintervAux.setUaentidad_id(organismo.getEntidadId());
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
			sanintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
		} else {
			sanintervAux.setUapaisId(organismo.getNoraPaisId());
		}
		sanintervAux.setUaentidad_id(organismo.getEntidadId());
		sanintervAux.setUaurl(organismo.getUrl());
		sanintervAux.setUacoem(organismo.getEmail());

		sanintervAux.setUafecultmod(null);
		sanintervAux.setUausuultmod(null);

		if (!insercion) {
			this.sanintervDao.update(sanintervAux);
		} else {
			sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_OTRO);
			this.sanintervDao.add(sanintervAux);
		}

		return sanintervAux;
	}

	/**
	 * Borrado de un interviniente de un expediente
	 * 
	 * @param interviniente
	 *            Saninterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInterviniente(Saninterv interviniente) {

		try {
			Saninterv interv = this.sanintervDao.find(interviniente);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(interv.getExpedien().getExcodigo());
			documentoHecho.setQ5idinterviniente(interv.getUaidinterv().toString());

			Long numdocumentosAportadosInterviniente = this.documentoHechoDao
					.findAllDocumentosAportadosIntervinienteCount(documentoHecho);

			if (numdocumentosAportadosInterviniente > 0) {
				throw new Y41bUDAException("error.interviniente.DeleteAportacionException", true, new Exception());
			}

			this.sanintervDao.remove(interv);

			// if (Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
			// .equals(interv.getUatipointerv())
			// ||
			// Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO
			// .equals(interv.getUatipointerv())) {
			//
			// }

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.interviniente.DataIntegrityViolationException2", true, e);
		}
	}

	// /**
	// * Actualiza la participacin del sancionado
	// *
	// * @param tramiteComun
	// * tramiteComun the tramite comun
	// * @throws Exception
	// * Exception
	// */
	// public void actualizarParticipacionSancionado(TramiteComun tramiteComun)
	// throws Exception {
	//
	// Saninterv saninterv = new Saninterv();
	// Expedien expedien = new Expedien();
	// expedien.setExcodigo(tramiteComun.getIdExpediente());
	//
	// expedien = this.expedienDao.find(expedien);
	//
	// saninterv = this.sanintervDao.dameSancionado(expedien.getExcodigo());
	// this.sanintervDao
	// .updateTipointerviniente(
	// saninterv,
	// Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR);
	//
	// // actualizar expediente
	// ActualizarExpediente actualizarExpediente = new ActualizarExpediente();
	//
	// Procedure procedure = new Procedure();
	// procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
	// actualizarExpediente.setProcedure(procedure);
	//
	// // Reclamante
	// DatosPersona datosPersona = new DatosPersona();
	// datosPersona.setDni(saninterv.getUanif());
	// datosPersona.setNombre(saninterv.getUanombre());
	//
	// if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
	// datosPersona.setApellido1(new StringBuffer(saninterv
	// .getUaapellido1()).toString());
	//
	// if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
	// datosPersona.setApellido1(new StringBuffer(saninterv
	// .getUaapellido1()).append(" ")
	// .append(saninterv.getUaapellido2()).toString());
	// }
	// }
	//
	// // Si tiene representante los datos sern del representante
	// datosPersona.setMail(saninterv.getUacoem());
	// datosPersona.setTelefono(saninterv.getUanrtel());
	//
	// datosPersona.setIdioma(saninterv.getUaidioma());
	//
	// // buscar el representante del reclamante validado
	// // si existe se aade
	// saninterv = new Saninterv();
	// expedien = new Expedien(tramiteComun.getIdExpediente());
	// expedien = this.expedienDao.find(expedien);
	//
	// saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
	// saninterv
	// .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);
	// saninterv = this.sanintervDao.find(saninterv);
	//
	// if (saninterv != null && Y41bUtils.isFilled(saninterv.getUanif())) {
	//
	// DatosPersona datosPersonaRepresentante = new DatosPersona();
	// datosPersonaRepresentante.setDni(saninterv.getUanif());
	// datosPersonaRepresentante.setNombre(saninterv.getUanombre());
	//
	// if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
	// datosPersonaRepresentante.setApellido1(new StringBuffer(
	// saninterv.getUaapellido1()).toString());
	//
	// if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
	// datosPersonaRepresentante.setApellido1(new StringBuffer(
	// saninterv.getUaapellido1()).append(" ")
	// .append(saninterv.getUaapellido2()).toString());
	// }
	// }
	// actualizarExpediente.setRepresentante(datosPersonaRepresentante);
	//
	// // Si tiene representante los datos sern del representante
	// datosPersona.setMail(saninterv.getUacoem());
	// datosPersona.setTelefono(saninterv.getUanrtel());
	// }
	//
	// // En actualizarExpediente el solicitante es el titular de la
	// // participacin, en nuestro caso
	// // el reclamante
	// actualizarExpediente.setSolicitante(datosPersona);
	//
	// StringBuffer numeroExpediente = new StringBuffer();
	//
	// numeroExpediente.append(Y41bConstantes.TIPO_PROC_SANCIONES).append("-")
	// .append(expedien.getExcoor()).append("-")
	// .append(expedien.getExnror()).append("-")
	// .append(expedien.getExnran());
	//
	// actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());
	//
	// actualizarExpediente.setEjercicio(expedien.getExnran().toString());
	//
	// actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
	//
	// DatosRegistro datosRegistro = new DatosRegistro();
	// // datosRegistro.setRegistryNumber(expedien.getNumeroRegistro());???
	// datosRegistro
	// .setRegistryTimestamp(Y41bUtils.formatearDateToString(
	// expedien.getExfere(),
	// Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
	//
	// actualizarExpediente.setDatosRegistro(datosRegistro);
	//
	// this.y41bPlateaAdapterService
	// .actualizarParticipantExpediente(actualizarExpediente);
	// }

	/**
	 * actualizarParticipantPlatea
	 * 
	 * @param expedien
	 *            Expedien
	 * @param saninterv
	 *            Saninterv
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param eliminarRep
	 *            boolean
	 */
	public void actualizarParticipantPlatea(Expedien expedien, Saninterv saninterv, CensoMonitor censoMonitor,
			boolean eliminarRep) {

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());

		sanexp = this.sanexpDao.find(sanexp);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		actualizarExpediente.setProcedure(procedure);

		// Sancionado
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(saninterv.getUanif().trim().toUpperCase());
		datosPersona.setNombre(StringEscapeUtils.escapeHtml(saninterv.getUanombre()));

		if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
			datosPersona.setApellido1(StringEscapeUtils.escapeHtml(saninterv.getUaapellido1()));

			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				datosPersona.setApellido1(StringEscapeUtils.escapeHtml(new StringBuffer(saninterv.getUaapellido1())
						.append(" ").append(saninterv.getUaapellido2()).toString()));
			}
		}

		if (Y41bUtils.isFilled(saninterv.getUacoem())) {
			datosPersona.setMail(saninterv.getUacoem());
		}
		if (Y41bUtils.isFilled(saninterv.getUanrtel())) {
			datosPersona.setTelefono(saninterv.getUanrtel());
		}
		datosPersona.setIdioma(Y41bUtils.idiomaTwoChar(saninterv.getUaidioma()));

		// Actualizamos los datos del solicitante (titular)
		actualizarExpediente.setSolicitante(datosPersona);
		actualizarExpediente.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		// Buscar el representante del sancionado validado
		// si existe se aade
		String tipo = null;
		if (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())) {
			tipo = Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO;
		}

		if (tipo != null && !eliminarRep) {
			Saninterv representante = this.sanintervDao.dameInterviniente(expedien.getSanexp().getExcodigo(), tipo);

			if (representante != null) {

				DatosPersona datosRepresentante = new DatosPersona();
				datosRepresentante.setDni(representante.getUanif().trim().toUpperCase());
				datosRepresentante.setNombre(StringEscapeUtils.escapeHtml(representante.getUanombre()));

				if (Y41bUtils.isFilled(representante.getUaapellido1())) {
					datosRepresentante.setApellido1(StringEscapeUtils.escapeHtml(representante.getUaapellido1()));

					if (Y41bUtils.isFilled(representante.getUaapellido2())) {
						datosRepresentante.setApellido1(
								StringEscapeUtils.escapeHtml(new StringBuffer(representante.getUaapellido1())
										.append(" ").append(representante.getUaapellido2()).toString()));
					}
				}

				if (Y41bUtils.isFilled(representante.getUacoem())) {
					datosRepresentante.setMail(representante.getUacoem());
				}
				if (Y41bUtils.isFilled(representante.getUanrtel())) {
					datosRepresentante.setTelefono(representante.getUanrtel());
				}
				datosRepresentante.setIdioma(Y41bUtils.idiomaTwoChar(representante.getUaidioma()));

				// Le ponemos el idioma del titular
				datosRepresentante.setIdioma(Y41bUtils.idiomaTwoChar(representante.getUaidioma()));
				actualizarExpediente.setRepresentante(datosRepresentante);
			}
		}

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(expedien.damecodCompletoPlatea());

		actualizarExpediente.setEjercicio(expedien.getExnran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (censoMonitor != null) {
			DatosPersona sender = new DatosPersona();
			sender.setDni(censoMonitor.getModni());
			sender.setNombre(censoMonitor.getMonombre());
			actualizarExpediente.setSender(sender);
		}

		Calendar cal = Calendar.getInstance();
		try {
			if (expedien != null && expedien.getExfere() != null) {
				cal.setTime(expedien.getExfere());
			} else {
				cal.setTime(new Date());
			}
			actualizarExpediente.setStartTimestamp(cal);
		} catch (Exception e) {
			e.printStackTrace();
			SanexpServiceImpl.logger.error("Error producido al realizar el setTime sobre Calendar con valor +"
					+ expedien.getExfere() + e.getMessage(), e);
		}

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaDestinatario(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// Cogemos el destinatario del tramite
		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(plantillaTramiteSANDetalle.getSantramexp().getTruaidinterv());
		Saninterv destinatario = this.sanintervDao.find(saninterv);

		if (destinatario != null) {
			plantillaTramiteSANDetalle.setCifDestinatario(destinatario.getUanif());

			if (destinatario.getUacpId() != null) {
				plantillaTramiteSANDetalle.setCpDestinatario(destinatario.getCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteSANDetalle.setCpDestinatario(this.sanintervService.dameCodigoPostal(destinatario));
			}

			plantillaTramiteSANDetalle.setNombreDestinatario((destinatario.getUanombre() == null ? ""
					: destinatario.getUanombre().concat(" ")
							.concat(destinatario.getUaapellido1() == null ? "" : destinatario.getUaapellido1())
							.concat(" ")
							.concat(destinatario.getUaapellido2() == null ? "" : destinatario.getUaapellido2()))
									.trim());

			plantillaTramiteSANDetalle.setDirDestinatario(this.sanintervService.dameLineaDireccion(destinatario));
			plantillaTramiteSANDetalle.setCpDestinatario(destinatario.getUacpId());

			plantillaTramiteSANDetalle.setProvDestinatario(this.sanintervService.dameProvincia(destinatario));
			plantillaTramiteSANDetalle.setMunDestinatario(this.sanintervService.dameMunicipio(destinatario));
			plantillaTramiteSANDetalle.setLocDestinatario(this.sanintervService.dameLocalidad(destinatario));

			// Si es un reclamante
			boolean hayExpedienteOrigen = false;
			if (Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO.equals(destinatario.getUatipointerv())
					&& destinatario.getUadtcodigo() != null) {
				// Expediente origen
				Sanexprel sanexprel = new Sanexprel();
				sanexprel.setExpedienByRlexcodigo(expedien);
				List<Sanexprel> lsanexprel = this.sanexprelDao.findAll(sanexprel, null);
				for (int i = 0; i < lsanexprel.size(); i++) {
					sanexprel = lsanexprel.get(i);
					if (!Y41bConstantes.VALOR_NO.equals(sanexprel.getRlesorig())) {
						if (sanexprel.getRlhdcodrel() != null) {
							HechoDenunciado hechodenunciado = new HechoDenunciado();
							hechodenunciado.setHdcodigo(sanexprel.getRlhdcodrel());
							hechodenunciado = this.hechodenunciadoDao.find(hechodenunciado);
							if (destinatario.getUadtcodigo()
									.equals(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo())) {
								hayExpedienteOrigen = true;
								break;
							}
						} else if (sanexprel.getRlarbcodrel() != null) {
							Dtsa dtsa = new Dtsa();
							dtsa.setSolarb(new Solarb(sanexprel.getRlarbcodrel()));
							Consumidor consumidor = new Consumidor();
							consumidor.setDtcodigo(destinatario.getUadtcodigo());
							dtsa.setConsumidor(consumidor);
							List<Dtsa> ldtsa = this.dtsaDao.findAll(dtsa, null);
							if (ldtsa != null && ldtsa.size() > 0) {
								hayExpedienteOrigen = true;
								break;
							}
						}
					}
				}
				if (hayExpedienteOrigen) {
					if (sanexprel.getTipoProcedimiento() != null
							&& !Y41bUtils.esNullOCadenaVacia(sanexprel.getTipoProcedimiento().getPcodigo())) {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getTipoProcedimiento().getPcodigo()
								+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + sanexprel.getCodCompleto());
					} else {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getCodCompleto());
					}
				}

			} else if (Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS_ORIGEN.equals(destinatario.getUatipointerv())
					&& destinatario.getUaentidad_id() != null) {
				// Expediente origen
				Sanexprel sanexprel = new Sanexprel();
				sanexprel.setExpedienByRlexcodigo(expedien);
				List<Sanexprel> lsanexprel = this.sanexprelDao.findAll(sanexprel, null);
				for (int i = 0; i < lsanexprel.size(); i++) {
					sanexprel = lsanexprel.get(i);
					if (!Y41bConstantes.VALOR_NO.equals(sanexprel.getRlesorig())) {
						if (sanexprel.getRlhdcodrel() != null) {
							HechoDenunciado hechodenunciado = new HechoDenunciado();
							hechodenunciado.setHdcodigo(sanexprel.getRlhdcodrel());
							hechodenunciado = this.hechodenunciadoDao.find(hechodenunciado);
							if (destinatario.getUaentidad_id().equals(hechodenunciado.getHdinteresado())) {
								hayExpedienteOrigen = true;
								break;
							}
						}
					}
				}
				if (hayExpedienteOrigen) {
					if (sanexprel.getTipoProcedimiento() != null
							&& !Y41bUtils.esNullOCadenaVacia(sanexprel.getTipoProcedimiento().getPcodigo())) {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getTipoProcedimiento().getPcodigo()
								+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + sanexprel.getCodCompleto());
					} else {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getCodCompleto());
					}
				}
			} else if (Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN
					.equals(destinatario.getUatipointerv()) && destinatario.getUaescodigo() != null) {
				// Expediente origen
				Sanexprel sanexprel = new Sanexprel();
				sanexprel.setExpedienByRlexcodigo(expedien);
				List<Sanexprel> lsanexprel = this.sanexprelDao.findAll(sanexprel, null);
				for (int i = 0; i < lsanexprel.size(); i++) {
					sanexprel = lsanexprel.get(i);
					if (!Y41bConstantes.VALOR_NO.equals(sanexprel.getRlesorig())) {
						if (sanexprel.getRlhdcodrel() != null) {
							HechoDenunciado hechodenunciado = new HechoDenunciado();
							hechodenunciado.setHdcodigo(sanexprel.getRlhdcodrel());
							hechodenunciado = this.hechodenunciadoDao.find(hechodenunciado);
							if (destinatario.getUaescodigo().equals(hechodenunciado.getHdinteresado())) {
								hayExpedienteOrigen = true;
								break;
							}
						}
					}
				}
				if (hayExpedienteOrigen) {
					if (sanexprel.getTipoProcedimiento() != null
							&& !Y41bUtils.esNullOCadenaVacia(sanexprel.getTipoProcedimiento().getPcodigo())) {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getTipoProcedimiento().getPcodigo()
								+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + sanexprel.getCodCompleto());
					} else {
						plantillaTramiteSANDetalle.setExpedienteOrigen(sanexprel.getCodCompleto());
					}
				}
			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaPieOficina(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// Rellenamos el pie dependiendo de la oficiona de la provincia
		// correspondiente
		Organismo oficinaProvincia = new Organismo();
		if (expedien.getSanexp() != null && expedien.getSanexp().getExcooractual() != null
				&& expedien.getSanexp().getExcooractual().length() > 2) {
			String provincia = expedien.getSanexp().getExcooractual().substring(0, 2);
			if (provincia.equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
				oficinaProvincia.setEntidadId(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA);
			} else if (provincia.equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
				oficinaProvincia.setEntidadId(Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA);
			} else if (provincia.equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
				oficinaProvincia.setEntidadId(Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA);
			} else {
				oficinaProvincia.setEntidadId("XXXXXX");
			}
			List<Organismo> listaoficinaProvincia = this.organismoDao.findAll(oficinaProvincia, null);
			if (listaoficinaProvincia != null) {
				oficinaProvincia = listaoficinaProvincia.get(0);
				if (oficinaProvincia != null && oficinaProvincia.getEntidadId() != null) {
					plantillaTramiteSANDetalle.setDireccionOficina(oficinaProvincia.getAdressCallePortal());
					plantillaTramiteSANDetalle.setCpOficina(oficinaProvincia.getAdressCP());
					plantillaTramiteSANDetalle.setTelefonoOficina(oficinaProvincia.getTelefono());
					plantillaTramiteSANDetalle.setFaxOficina(oficinaProvincia.getFax());
					/* cogemos solo el municipio */
					plantillaTramiteSANDetalle.setLocalidadOficina(oficinaProvincia.getNombreMunicipio());

					// Creamos el campo pie pagina linea1
					StringBuffer piepagina_linea1 = new StringBuffer();

					piepagina_linea1.append(plantillaTramiteSANDetalle.getDireccionOficina()).append(" - ")
							.append(plantillaTramiteSANDetalle.getCpOficina()).append(" / ").append(" Tl. ")
							.append(plantillaTramiteSANDetalle.getTelefonoOficina());

					plantillaTramiteSANDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

					// Creamos el campo pie pagina linea2
					StringBuffer piepagina_linea2 = new StringBuffer();

					piepagina_linea2.append("e-mail: ").append(oficinaProvincia.getEmail()).append(" / ")
							.append(oficinaProvincia.getUrl());

					plantillaTramiteSANDetalle.setPiePaginaLinea2(piepagina_linea2.toString());
				}
			}
		}

	}

	// 0154940: Actualizacin de datos explcitos en plantillas a uso de campos
	// combinados
	/**
	 * Rellena el pie de la oficina central .
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaCentralPieOficina(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {

		Organismo organismo = new Organismo();
		if (expedien.getSanexp() != null && expedien.getSanexp().getExcooractual() != null
				&& expedien.getSanexp().getExcooractual().length() > 2) {

			organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
			organismo = this.organismoDao.findOrganismo(organismo);
			if (organismo != null) {
				if (organismo != null && organismo.getEntidadId() != null) {
					// plantillaTramiteSANDetalle.setDireccionOficina(organismo
					// .getAdressCallePortal());
					// plantillaTramiteSANDetalle.setCpOficina(organismo
					// .getAdressCP());
					// plantillaTramiteSANDetalle.setTelefonoOficina(organismo
					// .getTelefono());
					// plantillaTramiteSANDetalle
					// .setFaxOficina(organismo.getFax());
					// /* cogemos solo el municipio */
					// plantillaTramiteSANDetalle.setLocalidadOficina(organismo
					// .getNombreMunicipio());

					// Creamos el campo pie pagina linea1
					StringBuffer centralpiepagina_linea1 = new StringBuffer();

					centralpiepagina_linea1.append(organismo.getAdressCallePortal()).append(" - ")
							.append(organismo.getAdressCP()).append(" / ").append(" Tl. ")
							.append(organismo.getTelefono());

					plantillaTramiteSANDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

					// Creamos el campo pie pagina linea2
					StringBuffer centralpiepagina_linea2 = new StringBuffer();

					centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
							.append(organismo.getUrl());

					plantillaTramiteSANDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

					plantillaTramiteSANDetalle.setCentralMail(organismo.getEmail());

					plantillaTramiteSANDetalle.setCentralTelefono(organismo.getTelefono());

					Parametros parametros = new Parametros();
					parametros.setParametro(Y41bConstantes.CUENTA_BANCARIA);
					parametros = this.parametrosDao.find(parametros);
					plantillaTramiteSANDetalle.setCuentaBancaria(parametros.getValor());
				}
			}
		}

	}

	// 0154940: Actualizacin de datos explcitos en plantillas a uso de campos
	// combinados

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaOrganismo(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		Organismo organismo = new Organismo();
		organismo.setCodOrg(expedien.getSanexp().getExcooractual());
		organismo = this.organismoDao.find(organismo);
		plantillaTramiteSANDetalle.setNombreOficina(organismo.getNombreEs());
		plantillaTramiteSANDetalle.setLugarOficina(organismo.getNombreLocalidad());
		plantillaTramiteSANDetalle.setDireccionOficina(organismo.getNombreCalle() + " " + organismo.getNombrePortal());
		plantillaTramiteSANDetalle.setCpOficina(organismo.getNombreCp());
		plantillaTramiteSANDetalle.setProvinciaOficina(organismo.getNombreProvincia());
		plantillaTramiteSANDetalle.setTelefonoOficina(organismo.getTelefono());
		plantillaTramiteSANDetalle.setFaxOficina(organismo.getFax());
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private void rellenaExpedienteRelacionado(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle)
			throws ParseException {
		// expediente relacionado
		Date fecTramiteRelacionado = null;
		Tramite tipotramiteRelacionado = new Tramite();
		if ((plantillaTramiteSANDetalle.getSantramexp() != null)
				&& plantillaTramiteSANDetalle.getSantramexp().getTrtridrel() != null) {
			// tiene relacionado
			String tridrel = plantillaTramiteSANDetalle.getSantramexp().getTrtridrel();

			Santramexp tramiteRelacionado = this.santramexpDao.find(new Santramexp(tridrel));

			if (tramiteRelacionado != null && tramiteRelacionado.getTrcodigo() != null) {
				if (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION)) {
					// si es una notificacion el tramite relacionado es el
					// relacionado de este
					String tridrelnotificacion = tramiteRelacionado.getTrtridrel();
					Santramexp tramiteNotificado = this.santramexpDao.find(new Santramexp(tridrelnotificacion));
					tramiteRelacionado = tramiteNotificado;
				}
				if (tramiteRelacionado != null && tramiteRelacionado.getTrcodigo() != null) {
					if (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION)) {
						fecTramiteRelacionado = tramiteRelacionado.getTrfecacini();
					} else if (tramiteRelacionado.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION)) {
						fecTramiteRelacionado = tramiteRelacionado.getTrresofecha();
					} else if (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
						fecTramiteRelacionado = tramiteRelacionado.getTrresofecha();
					} else if (tramiteRelacionado.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO)) {
						fecTramiteRelacionado = tramiteRelacionado.getTrresofecha();
					} else if (tramiteRelacionado.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION)) {
						Santramexp tramiteRelLiquidacion = this.santramexpDao
								.find(new Santramexp(tramiteRelacionado.getTrtridrel()));
						if (tramiteRelLiquidacion != null && (tramiteRelLiquidacion.getTrcodigo()
								.equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION))) {
							fecTramiteRelacionado = tramiteRelLiquidacion.getTrresofecha();
						}
					}
					tipotramiteRelacionado = this.tramiteDao.find(new Tramite(tramiteRelacionado.getTrcodigo()));
					if (tipotramiteRelacionado != null) {
						plantillaTramiteSANDetalle
								.setTramiterelacionadobopv(Y41bUtils.trataNull(tipotramiteRelacionado.getTrnombre()));
						plantillaTramiteSANDetalle.setTramiterelacionadobopveus(
								Y41bUtils.trataNull(tipotramiteRelacionado.getTrnombree()));
					}

					if (fecTramiteRelacionado != null) {
						plantillaTramiteSANDetalle
								.setFectramiterelacionadobopv(Y41bUtils.formatearDateToString(fecTramiteRelacionado,
										Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));

						plantillaTramiteSANDetalle.setFectramiterelacionadobopveus(
								Y41bUtils.formatearDateToStringEuskera(fecTramiteRelacionado,
										Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
					}
				}
			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaResponsable(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// Responsable
		CensoMonitor censoMonitorResp = new CensoMonitor();
		Organismo organismoResponsable = new Organismo();
		organismoResponsable.setCodOrg(expedien.getSanexp().getExcooractual());
		censoMonitorResp.setOrganismo(organismoResponsable);
		CensoMonitor responsable = this.censoMonitorDao.findCoordinadorSanciones(censoMonitorResp);
		if (responsable == null || (responsable != null && responsable.getMonombre() == null)) {
			throw new Y41bUDAException("error.tramite.nocoordinador", true, new Exception());
		} else {
			plantillaTramiteSANDetalle
					.setResponsable((responsable.getMonombre() == null) ? "" : responsable.getMonombre());
		}

		// recuperar texto de properties
		if (organismoResponsable != null && organismoResponsable.getCodOrg() != null) {
			String strTerritorio = organismoResponsable.getCodOrg();

			strTerritorio = strTerritorio.substring(0, 2);

			if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
				// recuperar texto de properties
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorCas(this.appMessageSource
						.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorEus(this.appMessageSource
						.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.EUSKERA)));

			} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
				// recuperar texto de properties
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorCas(this.appMessageSource
						.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorEus(this.appMessageSource
						.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.EUSKERA)));

			} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
				// recuperar texto de properties
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorCas(this.appMessageSource
						.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setTextoPuestoCoordinadorEus(this.appMessageSource
						.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.EUSKERA)));
			}
		}
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaDirector(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// Director

		// Parametros parametros = new Parametros();
		// parametros
		// .setParametro(Y41bConstantes.PARAMETRO_SANCIONES_DIRECTOR_KONTSUMOBIDE);
		// List<Parametros> lparametros = parametrosDao.findAll(parametros,
		// null);
		// if (lparametros != null && lparametros.size() > 0) {
		// parametros = lparametros.get(0);
		// Contacto contacto = new Contacto();
		// contacto.setContactoId(parametros.getValor());
		// contacto = contactoDao.find(contacto);
		// plantillaTramiteSANDetalle.setDirector(contacto.getNombre());
		// } else {
		// plantillaTramiteSANDetalle.setDirector("");
		// }
		CensoMonitor director = this.censoMonitorDao.findDirectorSanciones();
		if (director == null || (director != null && director.getMonombre() == null)) {
			throw new Y41bUDAException("error.tramite.nodirector", true, new Exception());
		} else {
			plantillaTramiteSANDetalle.setDirector((director.getMonombre() == null) ? "" : director.getMonombre());
		}

		// recuperar texto de properties
		plantillaTramiteSANDetalle.setTextoPuestoDirectorCas(this.appMessageSource
				.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteSANDetalle.setTextoPuestoDirectorEus(
				this.appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSancionado(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {

		// Sancionado
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
		List<Saninterv> lsaninterv = this.sanintervDao.findAll(saninterv, null);
		if (lsaninterv != null && lsaninterv.size() > 0) {
			saninterv = lsaninterv.get(0);
			plantillaTramiteSANDetalle.setCifSancionado(saninterv.getUanif());

			plantillaTramiteSANDetalle.setNombreSancionado(saninterv.getUanombre());
			/*
			 * Aqui no es necesario porque el sancionado es una razon social y
			 * no tiene apellidos (saninterv.getUanombre() == null ? "" :
			 * saninterv .getUanombre() .concat(" ")
			 * .concat(saninterv.getUaapellido1() == null ? "" :
			 * saninterv.getUaapellido1()) .concat(" ")
			 * .concat(saninterv.getUaapellido2() == null ? "" :
			 * saninterv.getUaapellido2()).trim()
			 */

			plantillaTramiteSANDetalle.setDirSancionado(this.sanintervService.dameLineaDireccion(saninterv));
			if (saninterv.getUacpId() != null) {
				plantillaTramiteSANDetalle.setCpSancionado(saninterv.getUacpId());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteSANDetalle.setCpSancionado(this.sanintervService.dameCodigoPostal(saninterv));
			}

			plantillaTramiteSANDetalle.setProvSancionado(this.sanintervService.dameProvincia(saninterv));
			plantillaTramiteSANDetalle.setMunSancionado(this.sanintervService.dameMunicipio(saninterv));
			plantillaTramiteSANDetalle.setLocSancionado(this.sanintervService.dameLocalidad(saninterv));

		}

		// buscamos el ayuntamiento de la localidad del sancionado
		if (saninterv.getUamunId() != null && saninterv.getUaprovId() != null) {
			String municipio = saninterv.getUamunId();
			String provincia = saninterv.getUaprovId();
			List<Organismo> layuntamientodelSancionado = this.organismoDao.getAyuntamientoPorMunicipio(provincia,
					municipio);
			if (layuntamientodelSancionado != null) {
				for (int i = 0; i < layuntamientodelSancionado.size(); i++) {
					Organismo ayuntamientodelSancionado = layuntamientodelSancionado.get(0);
					plantillaTramiteSANDetalle.setNomAyuntaEstablecimiento(ayuntamientodelSancionado.getNombreEs()
					// Incidencia 0073506: Plantillas con nombre de
					// organismo
					// + " / "
					// + ayuntamientodelSancionado.getNombreEu());
					);
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimiento(ayuntamientodelSancionado.getAdressCallePortal());
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimientoMun(ayuntamientodelSancionado.getNombreMunicipio());
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimientoProv(ayuntamientodelSancionado.getNombreProvincia());
				}
			}
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSedeSancionado(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {

		// Sancionado
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);

		Establecimiento establecimientoAux = new Establecimiento();
		Establecimiento establecimientoSede = new Establecimiento();

		List<Saninterv> lsaninterv = this.sanintervDao.findAll(saninterv, null);
		if (lsaninterv != null && lsaninterv.size() > 0) {
			saninterv = lsaninterv.get(0);

			establecimientoAux.setEsnif(saninterv.getUanif());
			establecimientoSede = this.establecimientoService.obtenerEstablecimientoSede(establecimientoAux);

			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoSede.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			Sede sede = this.establecimientoService.findEstablecimientoSede(sedeAux);

			plantillaTramiteSANDetalle.setCifSancionado(saninterv.getUanif());

			plantillaTramiteSANDetalle.setNombreSancionado(saninterv.getUanombre());

			plantillaTramiteSANDetalle.setDirSancionado(this.sedeService.dameLineaDireccion(sede));

			if (sede.getNombreCp() != null) {
				plantillaTramiteSANDetalle.setCpSancionado(sede.getNombreCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteSANDetalle.setCpSancionado(this.sedeService.dameCodigoPostal(sede));
			}

			plantillaTramiteSANDetalle.setProvSancionado(this.sedeService.dameProvincia(sede));
			plantillaTramiteSANDetalle.setMunSancionado(this.sedeService.dameMunicipio(sede));
			plantillaTramiteSANDetalle.setLocSancionado(this.sedeService.dameLocalidad(sede));
		}

		// buscamos el ayuntamiento de la localidad del sancionado
		if (saninterv.getUamunId() != null && saninterv.getUaprovId() != null) {
			String municipio = saninterv.getUamunId();
			String provincia = saninterv.getUaprovId();
			List<Organismo> layuntamientodelSancionado = this.organismoDao.getAyuntamientoPorMunicipio(provincia,
					municipio);
			if (layuntamientodelSancionado != null) {
				for (int i = 0; i < layuntamientodelSancionado.size(); i++) {
					Organismo ayuntamientodelSancionado = layuntamientodelSancionado.get(0);
					plantillaTramiteSANDetalle.setNomAyuntaEstablecimiento(ayuntamientodelSancionado.getNombreEs()
					// Incidencia 0073506: Plantillas con nombre de
					// organismo
					// + " / "
					// + ayuntamientodelSancionado.getNombreEu());
					);
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimiento(ayuntamientodelSancionado.getAdressCallePortal());
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimientoMun(ayuntamientodelSancionado.getNombreMunicipio());
					plantillaTramiteSANDetalle
							.setDireAyuntaEstablecimientoProv(ayuntamientodelSancionado.getNombreProvincia());
				}
			}
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaSedeDestinatario(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {

		// Sancionado
		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(plantillaTramiteSANDetalle.getSantramexp().getTruaidinterv());
		saninterv = this.sanintervDao.find(saninterv);

		Establecimiento establecimientoAux = new Establecimiento();
		Establecimiento establecimientoSede = new Establecimiento();

		establecimientoAux.setEsnif(saninterv.getUanif());
		establecimientoSede = this.establecimientoService.obtenerEstablecimientoSede(establecimientoAux);
		if (establecimientoSede != null) {
			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoSede.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
			Sede sede = this.establecimientoService.findEstablecimientoSede(sedeAux);

			plantillaTramiteSANDetalle.setCifDestinatario(saninterv.getUanif());

			plantillaTramiteSANDetalle.setNombreDestinatario(saninterv.getUanombre());

			plantillaTramiteSANDetalle.setDirDestinatario(this.sedeService.dameLineaDireccion(sede));

			if (sede.getNombreCp() != null) {
				plantillaTramiteSANDetalle.setCpDestinatario(sede.getNombreCp());
			} else {
				// intento calcular el cp mediante el portal
				plantillaTramiteSANDetalle.setCpDestinatario(this.sedeService.dameCodigoPostal(sede));
			}

			plantillaTramiteSANDetalle.setProvDestinatario(this.sedeService.dameProvincia(sede));
			plantillaTramiteSANDetalle.setMunDestinatario(this.sedeService.dameMunicipio(sede));
			plantillaTramiteSANDetalle.setLocDestinatario(this.sedeService.dameLocalidad(sede));

			// buscamos el ayuntamiento de la localidad del Destinatario
			if (saninterv.getUamunId() != null && saninterv.getUaprovId() != null) {
				String municipio = saninterv.getUamunId();
				String provincia = saninterv.getUaprovId();
				List<Organismo> layuntamientodelDestinatario = this.organismoDao.getAyuntamientoPorMunicipio(provincia,
						municipio);
				if (layuntamientodelDestinatario != null) {
					for (int i = 0; i < layuntamientodelDestinatario.size(); i++) {
						Organismo ayuntamientodelDestinatario = layuntamientodelDestinatario.get(0);
						plantillaTramiteSANDetalle.setNomAyuntaEstablecimiento(ayuntamientodelDestinatario.getNombreEs()
						// Incidencia 0073506: Plantillas con nombre de
						// organismo
						// + " / "
						// + ayuntamientodelSancionado.getNombreEu());
						);
						plantillaTramiteSANDetalle
								.setDireAyuntaEstablecimiento(ayuntamientodelDestinatario.getAdressCallePortal());
						plantillaTramiteSANDetalle
								.setDireAyuntaEstablecimientoMun(ayuntamientodelDestinatario.getNombreMunicipio());
						plantillaTramiteSANDetalle
								.setDireAyuntaEstablecimientoProv(ayuntamientodelDestinatario.getNombreProvincia());
					}
				}
			}
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaArticulosInfringidos(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// NUMARTICULO y TXTARTICULO
		StringBuffer numArticulo = new StringBuffer("");
		StringBuffer txtArticulo = new StringBuffer("");
		StringBuffer txtArticuloEu = new StringBuffer("");

		List<InfraccHechoDen> lInfraccHechoDen = this.infraccHechoDenDao
				.findArticulos(plantillaTramiteSANDetalle.getExcodigo(), null);

		if (lInfraccHechoDen != null) {
			InfraccHechoDen infraccHechoDen = null;
			String[] articulo = null;
			String[] articuloEu = null;
			for (int i = 0; i < lInfraccHechoDen.size(); i++) {
				infraccHechoDen = lInfraccHechoDen.get(i);

				articulo = infraccHechoDen.getTipReqNormativo().getTtinombre().split("-");

				if (articulo.length > 0) {
					if (!"".equals(numArticulo.toString())) {
						numArticulo.append(", ");
					}
					numArticulo.append(articulo[0]);
					if (articulo.length > 1) {
						if (!"".equals(txtArticulo.toString())) {
							txtArticulo.append(", ");
						}
						txtArticulo.append(articulo[1]);
					}
				}

				if (infraccHechoDen.getTipReqNormativo().getTtinombree() != null) {
					articuloEu = infraccHechoDen.getTipReqNormativo().getTtinombree().split("-");
					if (articuloEu != null && articuloEu.length > 1) {
						if (!"".equals(txtArticuloEu.toString())) {
							txtArticuloEu.append(", ");
						}
						txtArticuloEu.append(articuloEu[1]);
					}
				}
			}
		}
		plantillaTramiteSANDetalle.setNumArticulo(numArticulo.toString());
		plantillaTramiteSANDetalle.setTxtArticulo(txtArticulo.toString());
		plantillaTramiteSANDetalle.setTxtArticuloEu(txtArticuloEu.toString());
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param sanexp
	 *            the sanexp
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 */
	private void rellenaCalificacion(Expedien expedien, Sanexp sanexp,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {
		// NUMARTICULO y TXTARTICULO

		// calificacion del expediente
		String calificacionCas = null;
		String calificacionEus = null;
		String parametroImporteSancion = "";
		if (sanexp.getExcalif() != null) {
			if (Y41bConstantes.SAN_CALIFICACION_LEVE.equals(sanexp.getExcalif())) {
				calificacionCas = this.appMessageSource.getMessage("sanciones.calificacion.leve", null,
						new Locale(Y41bConstantes.CASTELLANO));
				calificacionCas = calificacionCas.toLowerCase();
				calificacionEus = this.appMessageSource.getMessage("sanciones.calificacion.leve", null,
						new Locale(Y41bConstantes.EUSKERA));
				calificacionEus = calificacionEus.toLowerCase();
				parametroImporteSancion = Y41bConstantes.PARAMETRO_IMPORTE_SANCION_LEVE;
			} else if (Y41bConstantes.SAN_CALIFICACION_GRAVE.equals(sanexp.getExcalif())) {
				calificacionCas = this.appMessageSource.getMessage("sanciones.calificacion.grave", null,
						new Locale(Y41bConstantes.CASTELLANO));
				calificacionCas = calificacionCas.toLowerCase();
				calificacionEus = this.appMessageSource.getMessage("sanciones.calificacion.grave", null,
						new Locale(Y41bConstantes.EUSKERA));
				calificacionEus = calificacionEus.toLowerCase();
				parametroImporteSancion = Y41bConstantes.PARAMETRO_IMPORTE_SANCION_GRAVE;
			} else if (Y41bConstantes.SAN_CALIFICACION_MUYGRAVE.equals(sanexp.getExcalif())) {
				calificacionCas = this.appMessageSource.getMessage("sanciones.calificacion.muygrave", null,
						new Locale(Y41bConstantes.CASTELLANO));
				calificacionCas = calificacionCas.toLowerCase();
				calificacionEus = this.appMessageSource.getMessage("sanciones.calificacion.muygrave", null,
						new Locale(Y41bConstantes.EUSKERA));
				calificacionEus = calificacionEus.toLowerCase();
				parametroImporteSancion = Y41bConstantes.PARAMETRO_IMPORTE_SANCION_MUYGRAVE;
			}
		}
		if (parametroImporteSancion != null) {
			Parametros parametro = this.parametrosDao.find(new Parametros(parametroImporteSancion));
			if (parametro != null) {
				plantillaTramiteSANDetalle.setIMPORTEMAXSANCION(parametro.getValor());
			}
		}

		plantillaTramiteSANDetalle.setCalificacionCas(calificacionCas);
		plantillaTramiteSANDetalle.setCalificacionEus(calificacionEus);
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaAlegaciones(Expedien expedien, PlantillaTramiteSANDetalle plantillaTramiteSANDetalle)
			throws ParseException {
		// ALEGACIONES A LA PROPUESTA DE RESOLUCION
		Date fechaAlegacionesPropuesta = this.sandoctempDao.dameFechaAportacionDocumentacion(
				Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_PROPUESTA_RESOLUCION, expedien.getExcodigo());
		plantillaTramiteSANDetalle.setFECALEGAPROPRESOLCAS(Y41bUtils.formatearDateToString(fechaAlegacionesPropuesta,
				Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteSANDetalle.setFECALEGAPROPRESOLEUS(Y41bUtils.formatearDateToStringEuskera(
				fechaAlegacionesPropuesta, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// ALEGACIONES AL ACUERDO DE INCOACION
		Date fechaAlegacionesIncoac = this.sandoctempDao.dameFechaAportacionDocumentacion(
				Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ALEGACION_ACUERDO_INCOACION, expedien.getExcodigo());
		plantillaTramiteSANDetalle.setFECALEGAACUERDOINCOACIONCAS(Y41bUtils.formatearDateToString(
				fechaAlegacionesIncoac, Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteSANDetalle.setFECALEGAACUERDOINCOACIONEUS(Y41bUtils.formatearDateToStringEuskera(
				fechaAlegacionesIncoac, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param sanexp
	 *            the sanexp
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private void rellenaPropuestaResolucion(Expedien expedien, Sanexp sanexp,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		// Plantilla Propuesta resolucion / Resolucion
		// FECACUERDOINCOACION
		Date fechaPropResolucion = null;
		if ((plantillaTramiteSANDetalle.getSantramexp() != null) && (plantillaTramiteSANDetalle.getSantramexp()
				.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION))) {
			fechaPropResolucion = plantillaTramiteSANDetalle.getSantramexp().getTrresofecha();
		} else {
			fechaPropResolucion = sanexp.getExfecpropreso();
		}

		if (fechaPropResolucion != null) {
			plantillaTramiteSANDetalle.setFECPROPRESOLUCIONCAS(Y41bUtils.formatearDateToString(fechaPropResolucion,
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFECPROPRESOLUCIONEUS(Y41bUtils.formatearDateToStringEuskera(
					fechaPropResolucion, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			plantillaTramiteSANDetalle.setFecPropResolucion(plantillaTramiteSANDetalle.getFECPROPRESOLUCIONCAS());
			plantillaTramiteSANDetalle.setFecPropResolucionEus(plantillaTramiteSANDetalle.getFECPROPRESOLUCIONEUS());
			if (plantillaTramiteSANDetalle.getSantramexp() != null
					&& plantillaTramiteSANDetalle.getSantramexp().getTrimporteinicial() != null) {
				plantillaTramiteSANDetalle.setImporteSancionInicial(Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(
						plantillaTramiteSANDetalle.getSantramexp().getTrimporteinicial().doubleValue()));
			}
		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param sanexp
	 *            the sanexp
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private void rellenaAcuerdoIncoacion(Expedien expedien, Sanexp sanexp,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		// si estamos dentro del tramite de incoación la fecha esta
		// dentro
		// del trmaite
		Date fechaAcuerdoIncoacion = null;

		if ((plantillaTramiteSANDetalle.getSantramexp() != null) && (plantillaTramiteSANDetalle.getSantramexp()
				.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION))) {
			fechaAcuerdoIncoacion = plantillaTramiteSANDetalle.getSantramexp().getTrfecacini();
		} else {
			fechaAcuerdoIncoacion = expedien.getExfeacin();
		}
		if (fechaAcuerdoIncoacion != null) {
			plantillaTramiteSANDetalle.setFecAcuerdoIncoacion(Y41bUtils.formatearDateToString(fechaAcuerdoIncoacion,
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFecAcuerdoIncoacionEus(Y41bUtils.formatearDateToStringEuskera(
					fechaAcuerdoIncoacion, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			if (plantillaTramiteSANDetalle.getSantramexp() != null
					&& plantillaTramiteSANDetalle.getSantramexp().getTrimporteinicial() != null) {
				plantillaTramiteSANDetalle.setImporteSancionInicial(Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(
						plantillaTramiteSANDetalle.getSantramexp().getTrimporteinicial().doubleValue()));
			}
		}

	}

	/**
	 * rellenaSolicitudReduccionProntoPago
	 * 
	 * @param excodigo
	 *            String
	 * @param plantillaTramiteSANDetalle
	 *            PlantillaTramiteSANDetalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaSolicitudReduccionProntoPago(String excodigo,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		// Buscamos si hay solicitud
		Santramexp santramexp = new Santramexp();
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
		santramexp.setExpedien(new Expedien(excodigo));
		Pagination pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setSord("desc");

		BigDecimal reduccion1 = new BigDecimal("0");
		BigDecimal reduccion2 = new BigDecimal("0");
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_PRONTO_PAGO);
		parametros = this.parametrosDao.find(parametros);
		reduccion1 = new BigDecimal(parametros.getValor());
		parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_RECONOCIMIENTO);
		parametros = this.parametrosDao.find(parametros);
		reduccion2 = new BigDecimal(parametros.getValor());

		plantillaTramiteSANDetalle.setPorcentajeReduccionResp(reduccion2.toString());
		plantillaTramiteSANDetalle.setPorcentajeReduccionPago(reduccion1.toString());

		List<Santramexp> lista = this.santramexpDao.findAll(santramexp, pagination);
		if (lista != null && lista.size() > 0) {
			santramexp = lista.get(0);
			if (santramexp.getTrfecsolred() != null) {
				plantillaTramiteSANDetalle
						.setFecSolReduccionEus(Y41bUtils.formatearDateToStringEuskera(santramexp.getTrfecsolred(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
				plantillaTramiteSANDetalle
						.setFecSolReduccionCas(Y41bUtils.formatearDateToString(santramexp.getTrfecsolred(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			}
			boolean reconocimiento = false;
			boolean pagoVoluntario = false;
			if (Y41bConstantes.SI.equalsIgnoreCase(santramexp.getTrreconocimiento())) {
				reconocimiento = true;
				plantillaTramiteSANDetalle.setResponsabilidadCas(this.appMessageSource
						.getMessage("sanciones.reconocimiento", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setResponsabilidadCas2(this.appMessageSource
						.getMessage("sanciones.reconocimiento2", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setResponsabilidadEus(this.appMessageSource
						.getMessage("sanciones.reconocimiento", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteSANDetalle.setResponsabilidadEus2(this.appMessageSource
						.getMessage("sanciones.reconocimiento2", null, new Locale(Y41bConstantes.EUSKERA)));
			}
			if (Y41bConstantes.SI.equalsIgnoreCase(santramexp.getTrprontopago())) {
				pagoVoluntario = true;
				plantillaTramiteSANDetalle.setPagoVoluntarioCas(this.appMessageSource
						.getMessage("sanciones.pagoVoluntario", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setPagoVoluntarioCas2(this.appMessageSource
						.getMessage("sanciones.pagoVoluntario2", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteSANDetalle.setPagoVoluntarioEus(this.appMessageSource
						.getMessage("sanciones.pagoVoluntario", null, new Locale(Y41bConstantes.EUSKERA)));
				plantillaTramiteSANDetalle.setPagoVoluntarioEus2(this.appMessageSource
						.getMessage("sanciones.pagoVoluntario2", null, new Locale(Y41bConstantes.EUSKERA)));
			}

			if (pagoVoluntario && reconocimiento) {
				plantillaTramiteSANDetalle.setResponsabilidadCas(
						plantillaTramiteSANDetalle.getResponsabilidadCas().concat(" ").concat(this.appMessageSource
								.getMessage("sanciones.y", null, new Locale(Y41bConstantes.CASTELLANO))));
				plantillaTramiteSANDetalle.setPagoVoluntarioCas2(
						plantillaTramiteSANDetalle.getPagoVoluntarioCas2().concat(" ").concat(this.appMessageSource
								.getMessage("sanciones.y", null, new Locale(Y41bConstantes.CASTELLANO))));
				plantillaTramiteSANDetalle.setResponsabilidadEus(
						plantillaTramiteSANDetalle.getResponsabilidadEus().concat(" ").concat(this.appMessageSource
								.getMessage("sanciones.y", null, new Locale(Y41bConstantes.EUSKERA))));
				plantillaTramiteSANDetalle.setPagoVoluntarioEus2(
						plantillaTramiteSANDetalle.getPagoVoluntarioEus2().concat(" ").concat(this.appMessageSource
								.getMessage("sanciones.y", null, new Locale(Y41bConstantes.EUSKERA))));
				plantillaTramiteSANDetalle.setPorcentajeReduccion(reduccion1.add(reduccion2).toString());
			} else if (pagoVoluntario) {
				plantillaTramiteSANDetalle.setPorcentajeReduccion(reduccion1.toString());
			} else if (reconocimiento) {
				plantillaTramiteSANDetalle.setPorcentajeReduccion(reduccion2.toString());
			}
		}

		santramexp = new Santramexp();
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PAGO);
		santramexp.setExpedien(new Expedien(excodigo));
		lista = this.santramexpDao.findAll(santramexp, pagination);
		if (lista != null && lista.size() > 0) {
			santramexp = lista.get(0);
			if (santramexp.getTrresofecha() != null) {
				plantillaTramiteSANDetalle.setFecPagoEus(Y41bUtils.formatearDateToStringEuskera(
						santramexp.getTrresofecha(), Y41bConstantes.FORMATO_FECHA_EU, Y41bConstantes.EUSKERA));
				plantillaTramiteSANDetalle.setFecPagoCas(Y41bUtils.formatearDateToString(santramexp.getTrresofecha(),
						Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

			}
			// 0195396: Plantilla Diligencia de archivo calcula erroneamente el
			// importe inicial
			// Se comenta porque el importe inicial del pago no es correcto. Se
			// guarda el mismo que el final al recibir el pago
			//
			// if (santramexp.getTrimporteinicial() != null) {
			// plantillaTramiteSANDetalle.setImporteSancionInicial(Y41bUtils
			// .formatDouble2decimalesYcomaYpuntoMiles(santramexp.getTrimporteinicial().doubleValue()));
			// }
			// Se obtiene el importe inicial del tramite de resolucion
			Santramexp tramiteResolucion = this.santramexpDao
					.dameTramitePorTipo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION, excodigo);
			if (tramiteResolucion != null && tramiteResolucion.getTrimporteinicial() != null) {
				plantillaTramiteSANDetalle.setImporteSancionInicial(Y41bUtils
						.formatDouble2decimalesYcomaYpuntoMiles(tramiteResolucion.getTrimporteinicial().doubleValue()));
			}
			if (santramexp.getTrresoimporte() != null) {
				plantillaTramiteSANDetalle.setImporteSancion(
						Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(santramexp.getTrresoimporte().doubleValue()));
			}

		}

	}

	/**
	 * Rellena destinatario.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param sanexp
	 *            the sanexp
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private void rellenaFechaNotificacion(Expedien expedien, Sanexp sanexp,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		/* FECHA DE NOTIFICACION DEL ACUERDO DE INCOACION */
		// En fecha 21/05/2019 Arrate exige que se cambie y que devuelva la
		// fecha de notificacin y no la fecha de acuse.
		// El cambio afecta colateralmente a dos plantillas que hacen uso de
		// ella
		// if (expedien.getExfenoai() != null) {
		// plantillaTramiteSANDetalle.setFECNOTIFACUERDOINCOACIONCAS(Y41bUtils
		// .formatearDateToString(expedien.getExfenoai(),
		// Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA,
		// Y41bConstantes.CASTELLANO));
		// plantillaTramiteSANDetalle.setFECNOTIFACUERDOINCOACIONEUS(Y41bUtils
		// .formatearDateToString(expedien.getExfenoai(),
		// Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA,
		// Y41bConstantes.EUSKERA));
		// }
		Date fechaNotificacionAcuerdoIncoacion = this.santramexpDao.dameFechanotificacionTramite(
				Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION, expedien.getExcodigo());
		if (fechaNotificacionAcuerdoIncoacion != null) {
			plantillaTramiteSANDetalle.setFECNOTIFACUERDOINCOACIONCAS(
					Y41bUtils.parseDateToString(fechaNotificacionAcuerdoIncoacion, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFECNOTIFACUERDOINCOACIONEUS(
					Y41bUtils.parseDateToString(fechaNotificacionAcuerdoIncoacion, Y41bConstantes.EUSKERA));
		}

		/* FECHA DE NOTIFICACION DE LA PROPUESTA DE RESOLUCION */
		Date fechaNotificacionPropuestaResolucion = this.santramexpDao.dameFechanotificacionTramite(
				Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION, expedien.getExcodigo());
		if (fechaNotificacionPropuestaResolucion != null) {
			plantillaTramiteSANDetalle
					.setFECPROPRESOLUCIONNOTIFCAS(Y41bUtils.formatearDateToString(fechaNotificacionPropuestaResolucion,
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFECPROPRESOLUCIONNOTIFEUS(
					Y41bUtils.formatearDateToStringEuskera(fechaNotificacionPropuestaResolucion,
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

		/* FECHA DE ACUSE DE LA PROPUESTA DE RESOLUCION */
		Date fechaAcusePropuestaResolucion = this.santramexpDao
				.dameFechaAcuseTramite(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION, expedien.getExcodigo());
		if (fechaAcusePropuestaResolucion != null) {
			plantillaTramiteSANDetalle
					.setFECPROPRESOLUCIONACUSECAS(Y41bUtils.formatearDateToString(fechaAcusePropuestaResolucion,
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteSANDetalle.setFECPROPRESOLUCIONACUSEEUS(Y41bUtils.formatearDateToStringEuskera(
					fechaAcusePropuestaResolucion, Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
		}

	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaDecision
	 *            the plantilla decision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	private String findPlantillaDecision(PlantillaDecision plantillaDecision, TramiteComun tramiteComun)
			throws Exception {
		String ficheroGenerado = "";
		// Obtener la plantilla del tramite
		PlantillaDecision plantillaDecision2 = this.plantillaDecisionDao.find(plantillaDecision);

		// Obtener los datos de la sancion
		if (plantillaDecision2.getPdplantilla() != null) {
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle = new PlantillaTramiteSANDetalle();
			plantillaTramiteSANDetalle.setExcodigo(tramiteComun.getIdExpediente());

			// Obtener los datos del tramite
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(tramiteComun.getIdTramite());
			santramexp = this.santramexpDao.find(santramexp);
			if (santramexp != null) {
				plantillaTramiteSANDetalle.setSantramexp(santramexp);
			}

			if (plantillaDecision2.getPdplantilla() != null) {
				plantillaTramiteSANDetalle = this.completeInfoplantillaTramiteSANDetalle(plantillaTramiteSANDetalle);

				// Transformar el documento en castellano
				String plantilla = Y41bUtils.blobToString(plantillaDecision2.getPdplantilla());

				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

				StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

				rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_SAN_CASTELLANO);

				ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
						plantillaTramiteSANDetalle, plantilla);
			}

		}
		return ficheroGenerado;
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            the tipodocumento
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		// No es necesario porque en el guardado previo no se vaca la temporal
		// this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		// this.sandoctempDao.addSanAdjuntarDocs(tramiteComun);

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
		String plantilla = "";
		String nombreDocumento = "";
		boolean tratamientoPlantillaNormal = false;

		adjuntardocs.setThcodocumento(this.getNewPKSanDocTemp().toString());

		/*
		 * EL COMPORTAMIENTO ES DIFERENTE PARA PROPUESTA Y PARA RESOLUCION, RSTO
		 * DE TRAMITES IGUAL
		 */
		if (tramiteComun.getIdTipoTramite() == null) {
			// tramites de BM
			tratamientoPlantillaNormal = true;
		} else if (tramiteComun.getIdTipoTramite().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)
				|| (tramiteComun.getIdTipoTramite().equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION))) {
			tratamientoPlantillaNormal = false;
		} else {
			tratamientoPlantillaNormal = true;
		}

		boolean ficheroPdf = false;
		if (tratamientoPlantillaNormal) {
			plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
			if (Y41bConstantes.CONTENT_TYPE_PDF.equalsIgnoreCase(plantillaTramite.getPtcontenttypefile())
					|| Y41bConstantes.EXTENSION_PDF
							.equalsIgnoreCase(Y41bUtils.getExtensionFile(plantillaTramite.getPtnofile()))) {
				plantilla = Y41bUtils.blobToString(plantillaTramite.getPtplantilla());
				nombreDocumento = new StringBuffer(plantillaTramite.getPtnombre()).append(Y41bConstantes.EXTENSION_PDF)
						.toString();
				ficheroPdf = true;
			} else {
				plantilla = this.findPlantilla(plantillaTramite, tramiteComun);
				nombreDocumento = new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString();
			}
		} else {
			/* PLANTILLA DECISION PARA PROPUESTA DE RESOLUCION Y RESOLUCION */
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
			plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);
			if (Y41bConstantes.CONTENT_TYPE_PDF.equalsIgnoreCase(plantillaDecision.getPdcontenttypefile())
					|| Y41bConstantes.EXTENSION_PDF
							.equalsIgnoreCase(Y41bUtils.getExtensionFile(plantillaDecision.getPdnofile()))) {
				plantilla = Y41bUtils.blobToString(plantillaDecision.getPdplantilla());
				nombreDocumento = new StringBuffer(plantillaDecision.getPdnombre()).append(Y41bConstantes.EXTENSION_PDF)
						.toString();
				ficheroPdf = true;
			} else {
				plantilla = this.findPlantillaDecision(plantillaDecision, tramiteComun);
				nombreDocumento = new StringBuffer(plantillaDecision.getPdnombre()).append(".rtf").toString();
			}
		}

		Expedien expedien = new Expedien(tramiteComun.getIdExpediente());
		expedien = this.expedienDao.find(expedien);
		String codigoExpediente = expedien.damecodCompletoPlatea();
		nombreDocumento = codigoExpediente.concat("-").concat(nombreDocumento);

		adjuntardocs.setThcodocumento(this.sandoctempService.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		if (ficheroPdf) {
			adjuntardocs.setThcontenttypefile(Y41bConstantes.CONTENT_TYPE_PDF);
		} else {
			adjuntardocs.setThcontenttypefile("application/msword");
		}
		adjuntardocs.setThnofile(nombreDocumento);
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		adjuntardocs.setThfecha(new Date());
		adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);
		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
		}

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Genera la tabla de tramites que estara en la plantilla de la solicitud
	 * 
	 * @param plantillaTramiteSANDetalle
	 *            PlantillaTramiteSANDetalle
	 */
	private void generarTablaPlazos(PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) {

		int numPlazos = 0;
		Santramexp resolucionComplementaria = plantillaTramiteSANDetalle.getSantramexp();
		Pagos pagos = new Pagos();
		pagos.setSgidexpediente(resolucionComplementaria.getExpedien().getExcodigo());
		// En santramexp se guarda la referencia (11) mas el digito de control
		// (2)
		pagos.setSgreferenciafracc(resolucionComplementaria.getTrreferencia().substring(0,
				resolucionComplementaria.getTrreferencia().length() - 2));
		List<Pagos> listPagos = this.pagosDao.findAll(pagos, null);
		StringBuffer stablaDoc = new StringBuffer(Y41bConstantes.NUM_1000);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");
		// Tabla: linea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh500 ");

		// Bordes de la fila
		stablaDoc.append("\\\\trbrdrt\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrl\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrb\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrr\\\\brdrs\\\\brdrw10");

		// Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx2055");

		// Bordes de la segunda celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx3402");

		// Bordes de la tercera celda stablaDoc.append("\\\\clvertalc");
		/*
		 * stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\cellx4750");
		 * 
		 * // Bordes de la cuarta celda stablaDoc.append("\\\\clvertalc");
		 * stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\cellx6663");
		 * 
		 * // Bordes de la quinta celda stablaDoc.append("\\\\clvertalc");
		 * stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		 * stablaDoc.append("\\\\cellx8612");
		 */

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		// Trazado de la filas

		// inicio cabecera *****************
		// stablaDoc.append(" \\\\intbl ");

		// c1
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("PLAZO");
		stablaDoc.append(" \\\\cell ");
		// c2
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("IMPORTE");
		stablaDoc.append(" \\\\cell ");
		// c3
		/*
		 * stablaDoc.append(" \\\\qc "); stablaDoc.append(" \\\\b ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\b0 ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\cell "); // c4
		 * stablaDoc.append(" \\\\qc "); stablaDoc.append(" \\\\b ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\b0 ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\cell "); // c5
		 * stablaDoc.append(" \\\\qc "); stablaDoc.append(" \\\\b ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\b0 ");
		 * stablaDoc.append(""); stablaDoc.append(" \\\\cell  ");
		 */

		stablaDoc.append(" \\\\row  ");
		// fin cabecera

		// Inicio Resto filas

		if (listPagos != null) {
			numPlazos = listPagos.size();
			for (Pagos pagosAux : listPagos) {
				// stablaDoc.append(" \\\\intbl ");

				if (pagosAux.getSgfechalimitepago() != null) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(
							Y41bUtils.parseDateToString(pagosAux.getSgfechalimitepago(), Y41bConstantes.CASTELLANO));
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (pagosAux.getSgimporteEuros() != null) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(pagosAux.getSgimporteEuros()).append(" ");
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				/*
				 * stablaDoc.append(" \\\\b0 ");
				 * stablaDoc.append("  \\\\cell  ");
				 * 
				 * stablaDoc.append(" \\\\b0 ");
				 * stablaDoc.append("  \\\\cell  ");
				 * 
				 * stablaDoc.append(" \\\\b0 ");
				 * stablaDoc.append("  \\\\cell  ");
				 */

				stablaDoc.append("  \\\\row  ");
			}
		}

		// Fin resto filas
		stablaDoc.append(" \\\\pard\\\\par ");
		// Cierre final
		stablaDoc.append("}");

		plantillaTramiteSANDetalle.setTablaPlazos(stablaDoc.toString());
		plantillaTramiteSANDetalle.setNumPlazos(String.valueOf(numPlazos));
		// plantillaTramiteSANDetalle.setFecolfraccas()
	}

	/**
	 * Get a New PK DocumentoHecho.
	 * 
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long getNewPKSanDocTemp() {
		return this.sandoctempDao.getNewPK();
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun, Pagination pagination) {

		List<DatosMailOrigen> listDatosMailOrigen = new ArrayList<DatosMailOrigen>();

		// Obtener el numero de expediente
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(tramiteComun.getIdExpediente());

		sanexp = this.sanexpDao.find(sanexp);

		// Buscar el monitor
		CensoMonitor remitente = new CensoMonitor();
		remitente.setMocodigo(sanexp.getExmocodigo());

		remitente = this.censoMonitorDao.find(remitente);

		DatosMailOrigen datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
		datosMailOrigen.setEmail(remitente.getMocoem());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		// Buscar el organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg(sanexp.getExcooractual());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
		datosMailOrigen.setEmail(organismo.getEmail());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		return listDatosMailOrigen;
	}

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(TramiteComun tramiteComun, DatosMailOrigen datosMailOrigen) {
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(tramiteComun.getIdExpediente());

		sanexp = this.sanexpDao.find(sanexp);

		DatosMailOrigen datosMailOrigenAux = new DatosMailOrigen();

		if (Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el monitor
			CensoMonitor remitente = new CensoMonitor();
			remitente.setMocodigo(sanexp.getExmocodigo());

			remitente = this.censoMonitorDao.find(remitente);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
			datosMailOrigenAux.setEmail(remitente.getMocoem());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);
		} else if (Y41bConstantes.ID_MAIL_ORIGEN_GENERICO.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg(sanexp.getExcooractual());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
			datosMailOrigenAux.setEmail(organismo.getEmail());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);
		}

		return datosMailOrigenAux;
	}

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun, Saninterv saninterv,
			Pagination pagination) {

		List<DatosMailEstablecimiento> listDatosMailEstablecimiento = new ArrayList<DatosMailEstablecimiento>();

		Saninterv saninterv2 = this.sanintervDao.find(saninterv);

		DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();

		datosMailEstablecimiento.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailEstablecimiento.setEmail(saninterv2.getUacoem());
		datosMailEstablecimiento.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailEstablecimiento.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailEstablecimiento.add(datosMailEstablecimiento);

		// buscar todos los mails del establecimiento
		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();
		datosMailEstablecimientoAux.setEscodigo(saninterv2.getUaescodigo());

		List<DatosMailEstablecimiento> listDatosMailEstablecimientoAux = this.datosMailEstablecimientoDao
				.findAll(datosMailEstablecimientoAux, null);

		for (DatosMailEstablecimiento datosMailEstablecimientoAux2 : listDatosMailEstablecimientoAux) {
			// aadirlo a la lista
			listDatosMailEstablecimiento.add(datosMailEstablecimientoAux2);
		}

		return listDatosMailEstablecimiento;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento) {

		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailEstablecimiento.getIdDatomail())) {
			// buscar el interviniente demandado
			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			/*
			 * saninterv
			 * .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			 */
			saninterv.setUaidinterv(new BigDecimal(idDestinatario));

			List<Saninterv> listSaninterv = this.sanintervDao.findAll(saninterv, null);

			if (listSaninterv.size() > 0) {
				datosMailEstablecimientoAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
				datosMailEstablecimientoAux.setEmail(listSaninterv.get(0).getUacoem());
				datosMailEstablecimientoAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
				datosMailEstablecimientoAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

			}

		} else {
			datosMailEstablecimientoAux = this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
		}

		return datosMailEstablecimientoAux;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Saninterv saninterv,
			Pagination pagination) {

		List<DatosMailSede> listDatosMailSede = new ArrayList<DatosMailSede>();

		Sede sede = new Sede();
		sede.setEscodigo(saninterv.getUaescodigo());
		sede.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);

		sede = this.establecimientoService.findEstablecimientoSede(sede);

		DatosMailSede datosMailSede = new DatosMailSede();

		datosMailSede.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailSede.setEmail(sede.getEmail());
		datosMailSede.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailSede.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailSede.add(datosMailSede);

		// buscar todos los mails del establecimiento
		DatosMailSede datosMailSedeAux = new DatosMailSede();
		datosMailSedeAux.setEscodigo(saninterv.getUaescodigo());
		datosMailSedeAux.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<DatosMailSede> listDatosMailSedeAux = this.datosMailSedeDao.findAll(datosMailSedeAux, null);

		for (DatosMailSede datosMailSedeAux2 : listDatosMailSedeAux) {
			// aadirlo a la lista
			listDatosMailSede.add(datosMailSedeAux2);
		}

		return listDatosMailSede;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede) {

		DatosMailSede datosMailSedeAux = new DatosMailSede();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailSede.getIdDatomail())) {

			Sede sede = new Sede();
			sede.setEscodigo(datosMailSede.getEscodigo());
			sede.setPcodigo(Y41bConstantes.TIPO_PROC_SANCIONES);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			datosMailSedeAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			datosMailSedeAux.setEmail(sede.getEmail());
			datosMailSedeAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailSedeAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailSedeAux = this.datosMailSedeDao.find(datosMailSede);
		}

		return datosMailSedeAux;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.SanexpService#tramitesGenerablesProntoPago(java
	 * .util.List, java.lang.String)
	 */
	@Override()
	public List<Tramite> tramitesGenerablesProntoPago(List<Tramite> listaTramites, String excodigo) {

		// Si hay recepcin de solicitud de reconocimiento de culpa='S'
		// Quitamos la propuesta
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(excodigo));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		santramexp.setTrreconocimiento(Y41bConstantes.VALOR_SI);
		long cont = this.santramexpDao.findAllCount(santramexp);
		if (cont > 0L) {
			Tramite tramiteAux = null;
			for (int i = 0; i < listaTramites.size(); i++) {
				tramiteAux = listaTramites.get(i);
				if (tramiteAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION)) {
					listaTramites.remove(i);
				}
			}
			// Si hay recepcin de solicitud de reconocimiento de culpa='S' y
			// pronto
			// pago='N'
			santramexp = new Santramexp();
			santramexp.setExpedien(new Expedien(excodigo));
			santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			santramexp.setTrreconocimiento(Y41bConstantes.VALOR_SI);
			santramexp.setTrprontopago(Y41bConstantes.VALOR_NO);
			cont = this.santramexpDao.findAllCount(santramexp);
			if (cont > 0L) {
				santramexp = new Santramexp();
				santramexp.setExpedien(new Expedien(excodigo));
				santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
				long cont1 = this.santramexpDao.findAllCount(santramexp);
				// Y no hay resolucin, aadimos al combo el trmite de
				// resolucin
				if (cont1 == 0L) {
					boolean comboConReso = false;
					for (int i = 0; i < listaTramites.size(); i++) {
						tramiteAux = listaTramites.get(i);
						if (tramiteAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
							comboConReso = true;
							break;
						}
					}
					if (!comboConReso) {
						Tramite tramite = new Tramite();
						tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
						listaTramites.add(this.tramiteDao.find(tramite));
					}
				}
			} else {
				// Si hay recepcin de solicitud de reconocimiento de culpa='S'
				// y
				// pronto pago='S'
				santramexp = new Santramexp();
				santramexp.setExpedien(new Expedien(excodigo));
				santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
				santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				santramexp.setTrreconocimiento(Y41bConstantes.VALOR_SI);
				santramexp.setTrprontopago(Y41bConstantes.VALOR_SI);
				cont = this.santramexpDao.findAllCount(santramexp);
				// Y hay liquidacion pasado el plazo de pago
				if (cont > 0L) {
					if (this.hayLiquidacionVencida(excodigo)) {
						santramexp = new Santramexp();
						santramexp.setExpedien(new Expedien(excodigo));
						santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
						long cont1 = this.santramexpDao.findAllCount(santramexp);
						// Y no hay resolucin, aadimos al combo el trmite de
						// resolucin
						if (cont1 == 0L) {
							boolean comboConReso = false;
							for (int i = 0; i < listaTramites.size(); i++) {
								tramiteAux = listaTramites.get(i);
								if (tramiteAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION)) {
									comboConReso = true;
									break;
								}
							}
							if (!comboConReso) {
								Tramite tramite = new Tramite();
								tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION);
								listaTramites.add(this.tramiteDao.find(tramite));
							}
						}
					}
				}
			}
		} else {
			// Hay una solicitud de reconocimiento de culpa='N' y pronto
			// pago='S'
			santramexp = new Santramexp();
			santramexp.setExpedien(new Expedien(excodigo));
			santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION);
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			santramexp.setTrreconocimiento(Y41bConstantes.VALOR_NO);
			santramexp.setTrprontopago(Y41bConstantes.VALOR_SI);
			cont = this.santramexpDao.findAllCount(santramexp);
			if (cont > 0L) {
				// Y estamos en fase de inicio o pruebas
				Sanexp sanexp = new Sanexp(excodigo);
				sanexp = this.sanexpDao.find(sanexp);
				if (Y41bConstantes.FASE_INICIO_SANCION.equals(sanexp.getFase().getFcodigo())
						|| Y41bConstantes.FASE_PRUEBAS_SANCION.equals(sanexp.getFase().getFcodigo())) {
					// Y no hay propuesta
					santramexp = new Santramexp();
					santramexp.setExpedien(new Expedien(excodigo));
					santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
					long cont1 = this.santramexpDao.findAllCount(santramexp);
					if (cont1 == 0L) {
						if (this.hayLiquidacionVencida(excodigo)) {
							// Y hay liquidacion pasado el plazo de pago
							boolean comboConProp = false;
							Tramite tramiteAux = null;
							for (int i = 0; i < listaTramites.size(); i++) {
								tramiteAux = listaTramites.get(i);
								if (tramiteAux.getTrcodigo()
										.equals(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION)) {
									comboConProp = true;
									break;
								}
							}
							if (!comboConProp) {
								Tramite tramite = new Tramite();
								tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION);
								listaTramites.add(this.tramiteDao.find(tramite));
							}
						}
					}
				}
			}
		}

		return listaTramites;
	}

	/**
	 * hayLiquidacionVencida
	 * 
	 * @param excodigo
	 *            String
	 * @return boolean
	 */
	private boolean hayLiquidacionVencida(String excodigo) {
		boolean liquidacionVencida = false;
		Santramexp liquidacion = new Santramexp();
		liquidacion.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
		liquidacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		liquidacion.setExpedien(new Expedien(excodigo));
		Pagination pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("desc");
		List<Santramexp> lliquidacion = this.santramexpDao.findAll(liquidacion, pagination);
		if (lliquidacion != null && lliquidacion.size() > 0) {
			for (int i = 0; i < lliquidacion.size(); i++) {
				liquidacion = lliquidacion.get(i);
				if (!Y41bUtils.esNullOCadenaVacia(liquidacion.getTrreferencia())) {
					PagosBusqueda pagosBusqueda = new PagosBusqueda();
					pagosBusqueda.setSgidexpediente(liquidacion.getExpedien().getExcodigo());
					pagosBusqueda.setSgreferencia(liquidacion.getTrreferencia().substring(0, Y41bConstantes.NUM_11));
					pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
					List<Pagos> listaPagos = this.pagosDao.findAllPagos(pagosBusqueda, null);
					Pagos pagos = null;
					// Existe un pago sin pagar fuera de plazo
					if (listaPagos != null && listaPagos.size() > 0) {
						pagos = listaPagos.get(0);
						if (!pagos.getEstadopago().getSacodigo().equals(Y41bConstantes.ESTADO_PAGO_PAGADO)
								&& !pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_DEFINITIVO)
								&& !pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_PROVISIONAL)
								&& pagos.getSgfechalimitepago().compareTo(Y41bUtils.hoy()) < 0) {
							liquidacionVencida = true;
						}
					}
				}
			}
		}
		return liquidacionVencida;
	}

	/**
	 * Rellena RequerimientoAcreditacionRepresentacion.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param plantillaTramiteSANDetalle
	 *            PlantillaTramiteSANDetalle
	 * @throws ParseException
	 *             the parse exception
	 */
	private void rellenaRequerimientoAcreditacionRepresentacion(Expedien expedien,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		Saninterv representante = new Saninterv();
		try {
			List<Saninterv> sanintervs = this.sanintervDao.findAllByTipo(expedien,
					Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO);
			if (sanintervs != null && sanintervs.size() > 0) {
				representante = sanintervs.get(0);
				if (representante.getNombreCompleto() != null) {
					plantillaTramiteSANDetalle.setNombreRepresentante(representante.getNombreCompleto());
				} else {
					plantillaTramiteSANDetalle.setNombreRepresentante(representante.getUanombre().trim());
					if (representante.getUaapellido1() != null) {
						plantillaTramiteSANDetalle.setNombreRepresentante(plantillaTramiteSANDetalle
								.getNombreRepresentante().concat(" ").concat(representante.getUaapellido1().trim()));
					}
					if (representante.getUaapellido2() != null) {
						plantillaTramiteSANDetalle.setNombreRepresentante(plantillaTramiteSANDetalle
								.getNombreRepresentante().concat(" ").concat(representante.getUaapellido2().trim()));
					}
					if (representante.getUanif() != null) {
						plantillaTramiteSANDetalle.setNifRepresentante(representante.getUanif());
					}
				}
				// } else {
				// throw new Exception();
			}
		} catch (Exception e) {
			throw new Y41bUDAException("error.tramiteRequerimientoAcreditacionRepresentacion.norepresentado", true,
					new Exception());
		}
	}

	// EVOLUTIVO 0135083 2.4
	// /**
	// * Rellena RequerimientoInformacion
	// *
	// * @param expedien
	// * the expedien
	// * @param plantillaTramiteSANDetalle
	// * the plantilla tramite san detalle
	// * @throws ParseException
	// * excepcion
	// */
	// private void rellenaRequerimientoInformacion(Expedien expedien,
	// PlantillaTramiteSANDetalle plantillaTramiteSANDetalle)
	// throws ParseException {
	// // Campos de requerimiento informacion
	// Santramexp santramexp = new Santramexp();
	// Expedien expedien1 = new Expedien();
	// expedien.setExcodigo(expedien.getExcodigo());
	// expedien1 = this.expedienDao.find(expedien1);
	// santramexp.setExpedien(expedien1);
	// // santramexp.setExpedien(new Expedien(expedien.getExcodigo()));
	// santramexp = this.santramexpDao.find(santramexp);
	// if (santramexp != null) {
	// plantillaTramiteSANDetalle.setSantramexp(santramexp);
	//
	// if (santramexp.getTrresumenalegaciones() != null) {
	// plantillaTramiteSANDetalle.setDocReqEs(santramexp
	// .getTrresumenalegaciones().toString());
	// }
	// if (santramexp.getTrdocreqeus() != null) {
	// plantillaTramiteSANDetalle.setDocReqEu(santramexp
	// .getTrdocreqeus().toString());
	// }
	//
	// }
	// }

	/**
	 * Rellena RequerimientoInformacion
	 * 
	 * @param expedien
	 *            the expedien
	 * @param plantillaTramiteSANDetalle
	 *            the plantilla tramite san detalle
	 * @throws ParseException
	 *             excepcion
	 */
	private void rellenaRecepcionRequerimientoInformacion(Expedien expedien,
			PlantillaTramiteSANDetalle plantillaTramiteSANDetalle) throws ParseException {
		// Campos de requerimiento informacion
		Santramexp santramexp = new Santramexp();
		Expedien expedien1 = new Expedien();
		expedien.setExcodigo(expedien.getExcodigo());
		expedien1 = this.expedienDao.find(expedien1);
		santramexp.setExpedien(expedien1);
		santramexp = this.santramexpDao.find(santramexp);
		if (santramexp != null) {
			plantillaTramiteSANDetalle.setSantramexp(santramexp);

			if (santramexp.getTrresumenalegaciones() != null) {
				plantillaTramiteSANDetalle.setResumenRecepReqInf(santramexp.getTrresumenalegaciones().toString());
			}
			if (santramexp.getTrrespuesta() != null) {
				plantillaTramiteSANDetalle.setRespuestaRecepReqInf(santramexp.getTrrespuesta());
			}

		}
	}

	// EVOLUTIVO 0135083 2.3
	@Override()
	public void updateIndicadorPlatea(Sanexp sanexp) {
		this.sanexpDao.updateIndicadorPlatea(sanexp);

	}

	/**
	 * tratamientoAnyadirIntervinienteSancionado
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	private Establecimiento tratamientoAnyadirIntervinienteSancionado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un sancionado a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

}