package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;

/**
 * SanexpService  
 * 
 *  
 */

public interface SanexpService {

	/**
	 * Inserts a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp add(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp update(Sanexp sanexp);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp find(Sanexp sanexp);

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanexp> findAll(Sanexp sanexp, Pagination pagination);

	/**
	 * Counts rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Long
	 */
	Long findAllCount(Sanexp sanexp);

	/**
	 * Finds rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanexp> findAllLike(Sanexp sanexp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanexp sanexp, Boolean startsWith);

	/**
	 * Deletes a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return
	 */
	void remove(Sanexp sanexp);

	/**
	 * Deletes multiple rows in the Sanexp table.
	 * 
	 * @param sanexpList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Sanexp> sanexpList);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp dameDetallesExpediente(Sanexp sanexp);

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Intervinientes
	 */
	public Saninterv addInterviniente(Intervinientes intervinientes,
			CensoMonitor censoMonitor);

	/**
	 * Borrado de un interviniente de un expediente
	 * 
	 * @param interviniente
	 *            Saninterv
	 */
	public void removeInterviniente(Saninterv interviniente);

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void addPlantilla(Adjuntardocs adjuntardocs,
			TramiteComun tramiteComun, String tipodocumento) throws Exception;

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<DatosMailOrigen>
	 */
	List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	DatosMailOrigen findMailOrigen(TramiteComun tramiteComun,
			DatosMailOrigen datosMailOrigen);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List<DatosMailEstablecimiento>
	 */
	List<DatosMailEstablecimiento> findAllMailEstablecimiento(
			TramiteComun tramiteComun, Saninterv saninterv,
			Pagination pagination);

	/**
	 * @param idEstablecimiento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento findMailEstablecimiento(String idEstablecimiento,
			TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List<DatosMailSede>
	 */
	List<DatosMailSede> findAllMailEstablecimientoSede(
			TramiteComun tramiteComun, Saninterv saninterv,
			Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun,
			DatosMailSede datosMailSede);

	/**
	 * @param listaTramites
	 * @param excodigo
	 * @return
	 */
	List<Tramite> tramitesGenerablesProntoPago(List<Tramite> listaTramites,
			String excodigo);

	/**
	 * Actualiza la participacin del sancionado
	 * 
	 * @param expedien
	 *            Expedien
	 * @param saninterv
	 *            Saninterv
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	void actualizarParticipantPlatea(Expedien expedien, Saninterv saninterv,
			CensoMonitor censoMonitor, boolean eliminarRep);
	//EVOLUTIVO 0135083 2.3
	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	void updateIndicadorPlatea(Sanexp sanexp);
}
