package com.ejie.y41b.service;

import java.util.List;
import java.util.ListIterator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanenvioDao;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanenvio;
import com.ejie.y41b.model.TramiteComun;

/**
 * SanenvioServiceImpl  
 * 
 *  
 */

@Service(value = "sanenvioService")
public class SanenvioServiceImpl implements SanenvioService {

	@Autowired()
	private SanenvioDao sanenvioDao;
	@Autowired()
	private SandoctempDao sandoctempDao;

	/**
	 * Inserts a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Sanenvio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanenvio add(Sanenvio sanenvio) {
		return this.sanenvioDao.add(sanenvio);
	}

	/**
	 * Updates a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Sanenvio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanenvio update(Sanenvio sanenvio) {
		return this.sanenvioDao.update(sanenvio);
	}

	/**
	 * Finds a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Sanenvio
	 */
	public Sanenvio find(Sanenvio sanenvio) {
		return (Sanenvio) this.sanenvioDao.find(sanenvio);
	}

	/**
	 * Finds a List of rows in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanenvio> findAll(Sanenvio sanenvio, Pagination pagination) {
		if (pagination != null && pagination.getSort() != null) {
			if ("fecharegistro".equals(pagination.getSort())) {
				pagination.setSort("FECHAREGISTRO");
			} else if ("santramexpByEntrid.tridnotifplatea".equals(pagination
					.getSort())) {
				pagination.setSort("t2.tridnotifplatea");
			} else if ("saninterv.uanombre".equals(pagination.getSort())) {
				pagination.setSort("t3.uanombre");
			}
		}
		List<Sanenvio> listSancionEnvios = this.sanenvioDao.findAll(sanenvio,
				pagination);

		if (listSancionEnvios != null && listSancionEnvios.size() > 0) {
			ListIterator<Sanenvio> iter = listSancionEnvios
					.listIterator(listSancionEnvios.size());

			Sanenvio sancionEnviosAux = null;
			TramiteComun tramiteComun = new TramiteComun();
			while (iter.hasPrevious()) {
				sancionEnviosAux = (Sanenvio) iter.previous();

				// buscar los documentos del tramite
				tramiteComun.setIdTramite(sancionEnviosAux
						.getSantramexpByEntrid().getTrid().toString());

				List<Sandoctemp> listDocumentoHecho = this.sandoctempDao
						.findAllDocumentosTramite(tramiteComun, null);

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null
						&& listDocumentoHecho.size() == 1) {
					sancionEnviosAux.setIndVariosDocumentos(Y41bConstantes.NO);

					sancionEnviosAux.setU5codocumento(listDocumentoHecho.get(0)
							.getU5codocumento());
					sancionEnviosAux.setU5tedesfile(listDocumentoHecho.get(0)
							.getU5tedesfile());
				} else {
					if (listDocumentoHecho != null
							&& listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						sancionEnviosAux
								.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}
			}
		}
		return listSancionEnvios;
	}

	/**
	 * Counts rows in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Long
	 */
	public Long findAllCount(Sanenvio sanenvio) {
		return this.sanenvioDao.findAllCount(sanenvio);
	}

	/**
	 * Finds rows in the Sanenvio table using like.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanenvio> findAllLike(Sanenvio sanenvio, Pagination pagination,
			Boolean startsWith) {
		return (List<Sanenvio>) this.sanenvioDao.findAllLike(sanenvio,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanenvio table using like.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanenvio sanenvio, Boolean startsWith) {
		return this.sanenvioDao.findAllLikeCount(sanenvio, startsWith);
	}

	/**
	 * Deletes a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanenvio sanenvio) {
		this.sanenvioDao.remove(sanenvio);
	}

	/**
	 * Deletes multiple rows in the Sanenvio table.
	 * 
	 * @param sanenvioList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanenvio> sanenvioList) {
		for (Sanenvio sanenvioAux : sanenvioList) {
			this.sanenvioDao.remove(sanenvioAux);
		}
	}

}
