package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanenvio;

/**
 * SanenvioService  
 *  
 */

public interface SanenvioService {

	/**
	 * Inserts a single row in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @return Sanenvio
	 */
    Sanenvio add(Sanenvio sanenvio);

	/**
	 * Updates a single row in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @return Sanenvio
	 */
	Sanenvio update(Sanenvio sanenvio);

	/**
	 * Finds a single row in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @return Sanenvio
	 */
	Sanenvio find(Sanenvio sanenvio);

	/**
	 * Finds a List of rows in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @param pagination Pagination
	 * @return List
	 */
	List<Sanenvio> findAll(Sanenvio sanenvio, Pagination pagination);

	/**
	 * Counts rows in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @return Long
	 */
	Long findAllCount(Sanenvio sanenvio);
	
	/**
	 * Finds rows in the Sanenvio table using like.
	 *
	 * @param sanenvio Sanenvio
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Sanenvio> findAllLike(Sanenvio sanenvio, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Sanenvio table using like.
	 *
	 * @param sanenvio Sanenvio
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Sanenvio sanenvio, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Sanenvio table.
	 *
	 * @param sanenvio Sanenvio
	 * @return 
	 */
	void remove(Sanenvio sanenvio);
	
	/**
	 * Deletes multiple rows in the Sanenvio table.
	 *
	 * @param sanenvioList List
	 * @return 
	 */	
	void removeMultiple(List<Sanenvio> sanenvioList);
    
}


