package com.ejie.y41b.service;

import java.sql.Blob;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * SandoctempServiceImpl  
 * 
 *  
 */

@Service(value = "sandoctempService")
public class SandoctempServiceImpl implements SandoctempService {

	@Autowired()
	private SandoctempDao sandoctempDao;

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	/**
	 * Inserts a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sandoctemp add(Sandoctemp sandoctemp) {
		return this.sandoctempDao.add(sandoctemp);
	}

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sandoctemp update(Sandoctemp sandoctemp) {
		return this.sandoctempDao.update(sandoctemp);
	}

	/**
	 * Finds a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public Sandoctemp find(Sandoctemp sandoctemp) throws Exception {
		sandoctemp = (Sandoctemp) this.sandoctempDao.find(sandoctemp);
		if (sandoctemp != null && sandoctemp.getU5iddocumentum() != null
				&& !sandoctemp.getU5iddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure
					.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
			documento.setProcedure(procedure);
			documento.setOidDokusi(sandoctemp.getU5iddocumentum());

			Documento docDokusi = y41bDokusiAdapterService
					.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			sandoctemp.setU5datafile(blob);
			sandoctemp.setU5conttype(docDokusi.getContentType());
			sandoctemp.setU5nofile(Y41bUtils.getNameFileDokusi(docDokusi
					.getNombre()));
			sandoctemp.setU5sizefile(Integer.valueOf((int) docDokusi
					.getLength()));
		}
		return sandoctemp;
	}

	/**
	 * Finds a List of rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sandoctemp> findAll(Sandoctemp sandoctemp, Pagination pagination) {
		return (List<Sandoctemp>) this.sandoctempDao.findAll(sandoctemp,
				pagination);
	}

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Long
	 */
	public Long findAllCount(Sandoctemp sandoctemp) {
		return this.sandoctempDao.findAllCount(sandoctemp);
	}

	/**
	 * Finds rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sandoctemp> findAllLike(Sandoctemp sandoctemp,
			Pagination pagination, Boolean startsWith) {
		return (List<Sandoctemp>) this.sandoctempDao.findAllLike(sandoctemp,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sandoctemp sandoctemp, Boolean startsWith) {
		return this.sandoctempDao.findAllLikeCount(sandoctemp, startsWith);
	}

	/**
	 * Deletes a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sandoctemp sandoctemp) {
		this.sandoctempDao.remove(sandoctemp);
	}

	/**
	 * Deletes multiple rows in the Sandoctemp table.
	 * 
	 * @param sandoctempList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sandoctemp> sandoctempList) {
		for (Sandoctemp sandoctempAux : sandoctempList) {
			this.sandoctempDao.remove(sandoctempAux);
		}
	}

	/**
	 * Get a New PK SANDOCTEMP.
	 * 
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long getNewPK() {
		return this.sandoctempDao.getNewPK();
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination) {

		if (pagination != null) {
			if ("codocumento".equals(pagination.getSort())) {
				pagination.setSort("U5CODOCUMENTO");
			} else if ("nofile".equals(pagination.getSort())) {
				pagination.setSort("U5NOFILE");
			} else if ("fecha".equals(pagination.getSort())) {
				pagination.setSort("U5FECHA");
			} else if ("origen".equals(pagination.getSort())) {
				pagination.setSort("U5ORIGEN");
			} else if ("tedesfile".equals(pagination.getSort())) {
				pagination.setSort("U5TEDESFILE");
			}
		}
		List<DocumentoExpediente> lista = this.sandoctempDao
				.findAllDocumentosExpediente(tramiteComun, pagination);
		if (lista != null && lista.size() > 0) {
			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			saninterv
					.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			long cont = this.sanintervDao.findAllCount(saninterv);
			if (cont == 0) {
				for (int i = 0; i < lista.size(); i++) {
					if (Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE
							.equals((((DocumentoExpediente) lista.get(i))
									.getOrigen()))) {
						((DocumentoExpediente) lista.get(i))
								.setOrigen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2);
					}
				}
			}
		}
		return lista;
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {

		return this.sandoctempDao
				.findAllDocumentosExpedienteCount(tramiteComun);
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Sandoctemp> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination) {
		return this.sandoctempDao.findAllDocumentosTramite(tramiteComun,
				pagination);
	}

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		return this.sandoctempDao.findAllDocumentosTramiteCount(tramiteComun);
	}

}
