package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TramiteComun;

/**
 * SandoctempService  
 * 
 *  
 */

public interface SandoctempService {

	/**
	 * Inserts a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp add(Sandoctemp sandoctemp);

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp update(Sandoctemp sandoctemp);

	/**
	 * Finds a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp find(Sandoctemp sandoctemp) throws Exception;

	/**
	 * Finds a List of rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sandoctemp> findAll(Sandoctemp sandoctemp, Pagination pagination);

	/**
	 * Finds rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sandoctemp> findAllLike(Sandoctemp sandoctemp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sandoctemp sandoctemp, Boolean startsWith);

	/**
	 * Deletes a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return
	 */
	void remove(Sandoctemp sandoctemp);

	/**
	 * Deletes multiple rows in the Sandoctemp table.
	 * 
	 * @param sandoctempList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Sandoctemp> sandoctempList);

	/**
	 * Get a New PK SANDOCTEMP.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Sandoctemp> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Sandoctemp table using like.
	 * 
	 * @param tramiteComun
	 *            Sandoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * @param tramiteComun
	 * @param pagination
	 * @return
	 */
	Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);
}
