package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SancuesprocedDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancuesproced;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SancuesprocedServiceImpl  
 * 
 *  
 */

@Service(value = "sancuesprocedService")
public class SancuesprocedServiceImpl implements SancuesprocedService {

	@Autowired()
	private SancuesprocedDao sancuesprocedDao;

	/**
	 * Inserts a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancuesproced add(Sancuesproced sancuesproced) {
		try {
			return this.sancuesprocedDao.add(sancuesproced);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.sancuesproced.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancuesproced update(Sancuesproced sancuesproced) {
		return this.sancuesprocedDao.update(sancuesproced);
	}

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancuesproced updateFechaBaja(Sancuesproced sancuesproced) {
		return this.sancuesprocedDao.updateFechaBaja(sancuesproced);
	}

	/**
	 * Finds a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	public Sancuesproced find(Sancuesproced sancuesproced) {
		return (Sancuesproced) this.sancuesprocedDao.find(sancuesproced);
	}

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sancuesproced> findAll(Sancuesproced sancuesproced,
			Pagination pagination) {
		return (List<Sancuesproced>) this.sancuesprocedDao.findAll(
				sancuesproced, pagination);
	}

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sancuesproced> findAllAlta(Sancuesproced sancuesproced,
			Pagination pagination) {
		return (List<Sancuesproced>) this.sancuesprocedDao.findAllAlta(
				sancuesproced, pagination);
	}

	/**
	 * Counts rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Long
	 */
	public Long findAllCount(Sancuesproced sancuesproced) {
		return this.sancuesprocedDao.findAllCount(sancuesproced);
	}

	/**
	 * Finds rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sancuesproced> findAllLike(Sancuesproced sancuesproced,
			Pagination pagination, Boolean startsWith) {

		// Control para poder ordenar correctamente el campo código
		// alfanumérico
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("cpcodigo")) {

				if (pagination.getAscDsc().equals("asc")) {
					pagination
							.setSort("regexp_substr(cpcodigo, '^\\D*') , to_number(regexp_substr(cpcodigo, '\\d+')) ");

				} else if (pagination.getAscDsc().equals("desc")) {
					pagination
							.setSort("regexp_substr(cpcodigo, '^\\D*') DESC, to_number(regexp_substr(cpcodigo, '\\d+')) ");

				}

			}
		}

		return (List<Sancuesproced>) this.sancuesprocedDao.findAllLike(
				sancuesproced, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sancuesproced sancuesproced, Boolean startsWith) {
		return this.sancuesprocedDao
				.findAllLikeCount(sancuesproced, startsWith);
	}

	/**
	 * Deletes a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sancuesproced sancuesproced) {
		try {
			this.sancuesprocedDao.remove(sancuesproced);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.sancuesproced.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Sancuesproced table.
	 * 
	 * @param sancuesprocedList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sancuesproced> sancuesprocedList) {
		for (Sancuesproced sancuesprocedAux : sancuesprocedList) {
			this.sancuesprocedDao.remove(sancuesprocedAux);
		}
	}

}
