package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SancuesfondoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancuesfondo;

/**
 * SancuesfondoServiceImpl  
 * 
 *  
 */

@Service(value = "sancuesfondoService")
public class SancuesfondoServiceImpl implements SancuesfondoService {

	@Autowired()
	private SancuesfondoDao sancuesfondoDao;

	/**
	 * Inserts a single row in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Sancuesfondo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancuesfondo add(Sancuesfondo sancuesfondo) {
		return this.sancuesfondoDao.add(sancuesfondo);
	}

	/**
	 * Updates a single row in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Sancuesfondo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancuesfondo update(Sancuesfondo sancuesfondo) {
		return this.sancuesfondoDao.update(sancuesfondo);
	}

	/**
	 * Finds a single row in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Sancuesfondo
	 */
	public Sancuesfondo find(Sancuesfondo sancuesfondo) {
		return (Sancuesfondo) this.sancuesfondoDao.find(sancuesfondo);
	}

	/**
	 * Finds a List of rows in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sancuesfondo> findAll(Sancuesfondo sancuesfondo,
			Pagination pagination) {
		return (List<Sancuesfondo>) this.sancuesfondoDao.findAll(sancuesfondo,
				pagination);
	}

	/**
	 * Counts rows in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return Long
	 */
	public Long findAllCount(Sancuesfondo sancuesfondo) {
		return this.sancuesfondoDao.findAllCount(sancuesfondo);
	}

	/**
	 * Finds rows in the Sancuesfondo table using like.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sancuesfondo> findAllLike(Sancuesfondo sancuesfondo,
			Pagination pagination, Boolean startsWith) {
		return (List<Sancuesfondo>) this.sancuesfondoDao.findAllLike(
				sancuesfondo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sancuesfondo table using like.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sancuesfondo sancuesfondo, Boolean startsWith) {
		return this.sancuesfondoDao.findAllLikeCount(sancuesfondo, startsWith);
	}

	/**
	 * Deletes a single row in the Sancuesfondo table.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sancuesfondo sancuesfondo) {
		this.sancuesfondoDao.remove(sancuesfondo);
	}

	/**
	 * Deletes multiple rows in the Sancuesfondo table.
	 * 
	 * @param sancuesfondoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sancuesfondo> sancuesfondoList) {
		for (Sancuesfondo sancuesfondoAux : sancuesfondoList) {
			this.sancuesfondoDao.remove(sancuesfondoAux);
		}
	}

}
